# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AdmCredentialArgs',
    'AdmCredentialPropertiesArgs',
    'ApnsCredentialArgs',
    'ApnsCredentialPropertiesArgs',
    'BaiduCredentialArgs',
    'BaiduCredentialPropertiesArgs',
    'GcmCredentialArgs',
    'GcmCredentialPropertiesArgs',
    'MpnsCredentialArgs',
    'MpnsCredentialPropertiesArgs',
    'NamespacePropertiesArgs',
    'NotificationHubPropertiesArgs',
    'SharedAccessAuthorizationRulePropertiesArgs',
    'WnsCredentialArgs',
    'WnsCredentialPropertiesArgs',
]

@pulumi.input_type
class AdmCredentialArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input['AdmCredentialPropertiesArgs']] = None):
        """
        Description of a NotificationHub AdmCredential.
        :param pulumi.Input['AdmCredentialPropertiesArgs'] properties: Gets or sets properties of NotificationHub AdmCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AdmCredentialPropertiesArgs']]:
        """
        Gets or sets properties of NotificationHub AdmCredential.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AdmCredentialPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class AdmCredentialPropertiesArgs:
    def __init__(__self__, *,
                 auth_token_url: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None):
        """
        Description of a NotificationHub AdmCredential.
        :param pulumi.Input[str] auth_token_url: Gets or sets the URL of the authorization token.
        :param pulumi.Input[str] client_id: Gets or sets the client identifier.
        :param pulumi.Input[str] client_secret: Gets or sets the credential secret access key.
        """
        if auth_token_url is not None:
            pulumi.set(__self__, "auth_token_url", auth_token_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="authTokenUrl")
    def auth_token_url(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the URL of the authorization token.
        """
        return pulumi.get(self, "auth_token_url")

    @auth_token_url.setter
    def auth_token_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the client identifier.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the credential secret access key.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)


@pulumi.input_type
class ApnsCredentialArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input['ApnsCredentialPropertiesArgs']] = None):
        """
        Description of a NotificationHub ApnsCredential.
        :param pulumi.Input['ApnsCredentialPropertiesArgs'] properties: Gets or sets properties of NotificationHub ApnsCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ApnsCredentialPropertiesArgs']]:
        """
        Gets or sets properties of NotificationHub ApnsCredential.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ApnsCredentialPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class ApnsCredentialPropertiesArgs:
    def __init__(__self__, *,
                 apns_certificate: Optional[pulumi.Input[str]] = None,
                 certificate_key: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Description of a NotificationHub ApnsCredential.
        :param pulumi.Input[str] apns_certificate: Gets or sets the APNS certificate.
        :param pulumi.Input[str] certificate_key: Gets or sets the certificate key.
        :param pulumi.Input[str] endpoint: Gets or sets the endpoint of this credential.
        :param pulumi.Input[str] thumbprint: Gets or sets the Apns certificate Thumbprint
        """
        if apns_certificate is not None:
            pulumi.set(__self__, "apns_certificate", apns_certificate)
        if certificate_key is not None:
            pulumi.set(__self__, "certificate_key", certificate_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="apnsCertificate")
    def apns_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the APNS certificate.
        """
        return pulumi.get(self, "apns_certificate")

    @apns_certificate.setter
    def apns_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apns_certificate", value)

    @property
    @pulumi.getter(name="certificateKey")
    def certificate_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the certificate key.
        """
        return pulumi.get(self, "certificate_key")

    @certificate_key.setter
    def certificate_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_key", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the endpoint of this credential.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Apns certificate Thumbprint
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class BaiduCredentialArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input['BaiduCredentialPropertiesArgs']] = None):
        """
        Description of a NotificationHub BaiduCredential.
        :param pulumi.Input['BaiduCredentialPropertiesArgs'] properties: Gets or sets properties of NotificationHub BaiduCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['BaiduCredentialPropertiesArgs']]:
        """
        Gets or sets properties of NotificationHub BaiduCredential.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['BaiduCredentialPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class BaiduCredentialPropertiesArgs:
    def __init__(__self__, *,
                 baidu_api_key: Optional[pulumi.Input[str]] = None,
                 baidu_end_point: Optional[pulumi.Input[str]] = None,
                 baidu_secret_key: Optional[pulumi.Input[str]] = None):
        """
        Description of a NotificationHub BaiduCredential.
        :param pulumi.Input[str] baidu_api_key: Get or Set Baidu Api Key.
        :param pulumi.Input[str] baidu_end_point: Get or Set Baidu Endpoint.
        :param pulumi.Input[str] baidu_secret_key: Get or Set Baidu Secret Key
        """
        if baidu_api_key is not None:
            pulumi.set(__self__, "baidu_api_key", baidu_api_key)
        if baidu_end_point is not None:
            pulumi.set(__self__, "baidu_end_point", baidu_end_point)
        if baidu_secret_key is not None:
            pulumi.set(__self__, "baidu_secret_key", baidu_secret_key)

    @property
    @pulumi.getter(name="baiduApiKey")
    def baidu_api_key(self) -> Optional[pulumi.Input[str]]:
        """
        Get or Set Baidu Api Key.
        """
        return pulumi.get(self, "baidu_api_key")

    @baidu_api_key.setter
    def baidu_api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baidu_api_key", value)

    @property
    @pulumi.getter(name="baiduEndPoint")
    def baidu_end_point(self) -> Optional[pulumi.Input[str]]:
        """
        Get or Set Baidu Endpoint.
        """
        return pulumi.get(self, "baidu_end_point")

    @baidu_end_point.setter
    def baidu_end_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baidu_end_point", value)

    @property
    @pulumi.getter(name="baiduSecretKey")
    def baidu_secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Get or Set Baidu Secret Key
        """
        return pulumi.get(self, "baidu_secret_key")

    @baidu_secret_key.setter
    def baidu_secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baidu_secret_key", value)


@pulumi.input_type
class GcmCredentialArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input['GcmCredentialPropertiesArgs']] = None):
        """
        Description of a NotificationHub GcmCredential.
        :param pulumi.Input['GcmCredentialPropertiesArgs'] properties: Gets or sets properties of NotificationHub GcmCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['GcmCredentialPropertiesArgs']]:
        """
        Gets or sets properties of NotificationHub GcmCredential.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['GcmCredentialPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class GcmCredentialPropertiesArgs:
    def __init__(__self__, *,
                 gcm_endpoint: Optional[pulumi.Input[str]] = None,
                 google_api_key: Optional[pulumi.Input[str]] = None):
        """
        Description of a NotificationHub GcmCredential.
        :param pulumi.Input[str] gcm_endpoint: Gets or sets the GCM endpoint.
        :param pulumi.Input[str] google_api_key: Gets or sets the Google API key.
        """
        if gcm_endpoint is not None:
            pulumi.set(__self__, "gcm_endpoint", gcm_endpoint)
        if google_api_key is not None:
            pulumi.set(__self__, "google_api_key", google_api_key)

    @property
    @pulumi.getter(name="gcmEndpoint")
    def gcm_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the GCM endpoint.
        """
        return pulumi.get(self, "gcm_endpoint")

    @gcm_endpoint.setter
    def gcm_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcm_endpoint", value)

    @property
    @pulumi.getter(name="googleApiKey")
    def google_api_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Google API key.
        """
        return pulumi.get(self, "google_api_key")

    @google_api_key.setter
    def google_api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_api_key", value)


@pulumi.input_type
class MpnsCredentialArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input['MpnsCredentialPropertiesArgs']] = None):
        """
        Description of a NotificationHub MpnsCredential.
        :param pulumi.Input['MpnsCredentialPropertiesArgs'] properties: Gets or sets properties of NotificationHub MpnsCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['MpnsCredentialPropertiesArgs']]:
        """
        Gets or sets properties of NotificationHub MpnsCredential.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['MpnsCredentialPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class MpnsCredentialPropertiesArgs:
    def __init__(__self__, *,
                 certificate_key: Optional[pulumi.Input[str]] = None,
                 mpns_certificate: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Description of a NotificationHub MpnsCredential.
        :param pulumi.Input[str] certificate_key: Gets or sets the certificate key for this credential.
        :param pulumi.Input[str] mpns_certificate: Gets or sets the MPNS certificate.
        :param pulumi.Input[str] thumbprint: Gets or sets the Mpns certificate Thumbprint
        """
        if certificate_key is not None:
            pulumi.set(__self__, "certificate_key", certificate_key)
        if mpns_certificate is not None:
            pulumi.set(__self__, "mpns_certificate", mpns_certificate)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="certificateKey")
    def certificate_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the certificate key for this credential.
        """
        return pulumi.get(self, "certificate_key")

    @certificate_key.setter
    def certificate_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_key", value)

    @property
    @pulumi.getter(name="mpnsCertificate")
    def mpns_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the MPNS certificate.
        """
        return pulumi.get(self, "mpns_certificate")

    @mpns_certificate.setter
    def mpns_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mpns_certificate", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Mpns certificate Thumbprint
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class NamespacePropertiesArgs:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 critical: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_type: Optional[pulumi.Input['NamespaceType']] = None,
                 provisioning_state: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scale_unit: Optional[pulumi.Input[str]] = None,
                 service_bus_endpoint: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None):
        """
        Namespace properties.
        :param pulumi.Input[str] created_at: The time the namespace was created.
        :param pulumi.Input[bool] critical: Whether or not the namespace is set as Critical.
        :param pulumi.Input[bool] enabled: Whether or not the namespace is currently enabled.
        :param pulumi.Input[str] name: The name of the namespace.
        :param pulumi.Input['NamespaceType'] namespace_type: Gets or sets the namespace type.
        :param pulumi.Input[str] provisioning_state: Gets or sets provisioning state of the Namespace.
        :param pulumi.Input[str] region: Specifies the targeted region in which the namespace should be created. It can be any of the following values: Australia East, Australia Southeast, Central US, East US, East US 2, West US, North Central US, South Central US, East Asia, Southeast Asia, Brazil South, Japan East, Japan West, North Europe, West Europe
        :param pulumi.Input[str] scale_unit: ScaleUnit where the namespace gets created
        :param pulumi.Input[str] service_bus_endpoint: Endpoint you can use to perform NotificationHub operations.
        :param pulumi.Input[str] status: Status of the namespace. It can be any of these values:1 = Created/Active2 = Creating3 = Suspended4 = Deleting
        :param pulumi.Input[str] subscription_id: The Id of the Azure subscription associated with the namespace.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_type is not None:
            pulumi.set(__self__, "namespace_type", namespace_type)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scale_unit is not None:
            pulumi.set(__self__, "scale_unit", scale_unit)
        if service_bus_endpoint is not None:
            pulumi.set(__self__, "service_bus_endpoint", service_bus_endpoint)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The time the namespace was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def critical(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the namespace is set as Critical.
        """
        return pulumi.get(self, "critical")

    @critical.setter
    def critical(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "critical", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the namespace is currently enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceType")
    def namespace_type(self) -> Optional[pulumi.Input['NamespaceType']]:
        """
        Gets or sets the namespace type.
        """
        return pulumi.get(self, "namespace_type")

    @namespace_type.setter
    def namespace_type(self, value: Optional[pulumi.Input['NamespaceType']]):
        pulumi.set(self, "namespace_type", value)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets provisioning state of the Namespace.
        """
        return pulumi.get(self, "provisioning_state")

    @provisioning_state.setter
    def provisioning_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_state", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the targeted region in which the namespace should be created. It can be any of the following values: Australia East, Australia Southeast, Central US, East US, East US 2, West US, North Central US, South Central US, East Asia, Southeast Asia, Brazil South, Japan East, Japan West, North Europe, West Europe
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scaleUnit")
    def scale_unit(self) -> Optional[pulumi.Input[str]]:
        """
        ScaleUnit where the namespace gets created
        """
        return pulumi.get(self, "scale_unit")

    @scale_unit.setter
    def scale_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_unit", value)

    @property
    @pulumi.getter(name="serviceBusEndpoint")
    def service_bus_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoint you can use to perform NotificationHub operations.
        """
        return pulumi.get(self, "service_bus_endpoint")

    @service_bus_endpoint.setter
    def service_bus_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bus_endpoint", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the namespace. It can be any of these values:1 = Created/Active2 = Creating3 = Suspended4 = Deleting
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Azure subscription associated with the namespace.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class NotificationHubPropertiesArgs:
    def __init__(__self__, *,
                 adm_credential: Optional[pulumi.Input['AdmCredentialArgs']] = None,
                 apns_credential: Optional[pulumi.Input['ApnsCredentialArgs']] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SharedAccessAuthorizationRulePropertiesArgs']]]] = None,
                 baidu_credential: Optional[pulumi.Input['BaiduCredentialArgs']] = None,
                 gcm_credential: Optional[pulumi.Input['GcmCredentialArgs']] = None,
                 mpns_credential: Optional[pulumi.Input['MpnsCredentialArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 registration_ttl: Optional[pulumi.Input[str]] = None,
                 wns_credential: Optional[pulumi.Input['WnsCredentialArgs']] = None):
        """
        NotificationHub properties.
        :param pulumi.Input['AdmCredentialArgs'] adm_credential: The AdmCredential of the created NotificationHub
        :param pulumi.Input['ApnsCredentialArgs'] apns_credential: The ApnsCredential of the created NotificationHub
        :param pulumi.Input[Sequence[pulumi.Input['SharedAccessAuthorizationRulePropertiesArgs']]] authorization_rules: The AuthorizationRules of the created NotificationHub
        :param pulumi.Input['BaiduCredentialArgs'] baidu_credential: The BaiduCredential of the created NotificationHub
        :param pulumi.Input['GcmCredentialArgs'] gcm_credential: The GcmCredential of the created NotificationHub
        :param pulumi.Input['MpnsCredentialArgs'] mpns_credential: The MpnsCredential of the created NotificationHub
        :param pulumi.Input[str] name: The NotificationHub name.
        :param pulumi.Input[str] registration_ttl: The RegistrationTtl of the created NotificationHub
        :param pulumi.Input['WnsCredentialArgs'] wns_credential: The WnsCredential of the created NotificationHub
        """
        if adm_credential is not None:
            pulumi.set(__self__, "adm_credential", adm_credential)
        if apns_credential is not None:
            pulumi.set(__self__, "apns_credential", apns_credential)
        if authorization_rules is not None:
            pulumi.set(__self__, "authorization_rules", authorization_rules)
        if baidu_credential is not None:
            pulumi.set(__self__, "baidu_credential", baidu_credential)
        if gcm_credential is not None:
            pulumi.set(__self__, "gcm_credential", gcm_credential)
        if mpns_credential is not None:
            pulumi.set(__self__, "mpns_credential", mpns_credential)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registration_ttl is not None:
            pulumi.set(__self__, "registration_ttl", registration_ttl)
        if wns_credential is not None:
            pulumi.set(__self__, "wns_credential", wns_credential)

    @property
    @pulumi.getter(name="admCredential")
    def adm_credential(self) -> Optional[pulumi.Input['AdmCredentialArgs']]:
        """
        The AdmCredential of the created NotificationHub
        """
        return pulumi.get(self, "adm_credential")

    @adm_credential.setter
    def adm_credential(self, value: Optional[pulumi.Input['AdmCredentialArgs']]):
        pulumi.set(self, "adm_credential", value)

    @property
    @pulumi.getter(name="apnsCredential")
    def apns_credential(self) -> Optional[pulumi.Input['ApnsCredentialArgs']]:
        """
        The ApnsCredential of the created NotificationHub
        """
        return pulumi.get(self, "apns_credential")

    @apns_credential.setter
    def apns_credential(self, value: Optional[pulumi.Input['ApnsCredentialArgs']]):
        pulumi.set(self, "apns_credential", value)

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SharedAccessAuthorizationRulePropertiesArgs']]]]:
        """
        The AuthorizationRules of the created NotificationHub
        """
        return pulumi.get(self, "authorization_rules")

    @authorization_rules.setter
    def authorization_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SharedAccessAuthorizationRulePropertiesArgs']]]]):
        pulumi.set(self, "authorization_rules", value)

    @property
    @pulumi.getter(name="baiduCredential")
    def baidu_credential(self) -> Optional[pulumi.Input['BaiduCredentialArgs']]:
        """
        The BaiduCredential of the created NotificationHub
        """
        return pulumi.get(self, "baidu_credential")

    @baidu_credential.setter
    def baidu_credential(self, value: Optional[pulumi.Input['BaiduCredentialArgs']]):
        pulumi.set(self, "baidu_credential", value)

    @property
    @pulumi.getter(name="gcmCredential")
    def gcm_credential(self) -> Optional[pulumi.Input['GcmCredentialArgs']]:
        """
        The GcmCredential of the created NotificationHub
        """
        return pulumi.get(self, "gcm_credential")

    @gcm_credential.setter
    def gcm_credential(self, value: Optional[pulumi.Input['GcmCredentialArgs']]):
        pulumi.set(self, "gcm_credential", value)

    @property
    @pulumi.getter(name="mpnsCredential")
    def mpns_credential(self) -> Optional[pulumi.Input['MpnsCredentialArgs']]:
        """
        The MpnsCredential of the created NotificationHub
        """
        return pulumi.get(self, "mpns_credential")

    @mpns_credential.setter
    def mpns_credential(self, value: Optional[pulumi.Input['MpnsCredentialArgs']]):
        pulumi.set(self, "mpns_credential", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The NotificationHub name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="registrationTtl")
    def registration_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        The RegistrationTtl of the created NotificationHub
        """
        return pulumi.get(self, "registration_ttl")

    @registration_ttl.setter
    def registration_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_ttl", value)

    @property
    @pulumi.getter(name="wnsCredential")
    def wns_credential(self) -> Optional[pulumi.Input['WnsCredentialArgs']]:
        """
        The WnsCredential of the created NotificationHub
        """
        return pulumi.get(self, "wns_credential")

    @wns_credential.setter
    def wns_credential(self, value: Optional[pulumi.Input['WnsCredentialArgs']]):
        pulumi.set(self, "wns_credential", value)


@pulumi.input_type
class SharedAccessAuthorizationRulePropertiesArgs:
    def __init__(__self__, *,
                 claim_type: Optional[pulumi.Input[str]] = None,
                 claim_value: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 modified_time: Optional[pulumi.Input[str]] = None,
                 primary_key: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[int]] = None,
                 rights: Optional[pulumi.Input[Sequence[pulumi.Input['AccessRights']]]] = None,
                 secondary_key: Optional[pulumi.Input[str]] = None):
        """
        SharedAccessAuthorizationRule properties.
        :param pulumi.Input[str] claim_type: The type of the claim.
        :param pulumi.Input[str] claim_value: The value of the claim.
        :param pulumi.Input[str] created_time: The time at which the authorization rule was created.
        :param pulumi.Input[str] key_name: The name of the key that was used.
        :param pulumi.Input[str] modified_time: The most recent time the rule was updated.
        :param pulumi.Input[str] primary_key: The primary key that was used.
        :param pulumi.Input[int] revision: The revision number for the rule.
        :param pulumi.Input[Sequence[pulumi.Input['AccessRights']]] rights: The rights associated with the rule.
        :param pulumi.Input[str] secondary_key: The secondary key that was used.
        """
        if claim_type is not None:
            pulumi.set(__self__, "claim_type", claim_type)
        if claim_value is not None:
            pulumi.set(__self__, "claim_value", claim_value)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if modified_time is not None:
            pulumi.set(__self__, "modified_time", modified_time)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if rights is not None:
            pulumi.set(__self__, "rights", rights)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the claim.
        """
        return pulumi.get(self, "claim_type")

    @claim_type.setter
    def claim_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "claim_type", value)

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the claim.
        """
        return pulumi.get(self, "claim_value")

    @claim_value.setter
    def claim_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "claim_value", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the authorization rule was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the key that was used.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> Optional[pulumi.Input[str]]:
        """
        The most recent time the rule was updated.
        """
        return pulumi.get(self, "modified_time")

    @modified_time.setter
    def modified_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_time", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The primary key that was used.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[int]]:
        """
        The revision number for the rule.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter
    def rights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessRights']]]]:
        """
        The rights associated with the rule.
        """
        return pulumi.get(self, "rights")

    @rights.setter
    def rights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessRights']]]]):
        pulumi.set(self, "rights", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary key that was used.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_key", value)


@pulumi.input_type
class WnsCredentialArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input['WnsCredentialPropertiesArgs']] = None):
        """
        Description of a NotificationHub WnsCredential.
        :param pulumi.Input['WnsCredentialPropertiesArgs'] properties: Gets or sets properties of NotificationHub WnsCredential.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['WnsCredentialPropertiesArgs']]:
        """
        Gets or sets properties of NotificationHub WnsCredential.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['WnsCredentialPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class WnsCredentialPropertiesArgs:
    def __init__(__self__, *,
                 package_sid: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 windows_live_endpoint: Optional[pulumi.Input[str]] = None):
        """
        Description of a NotificationHub WnsCredential.
        :param pulumi.Input[str] package_sid: Gets or sets the package ID for this credential.
        :param pulumi.Input[str] secret_key: Gets or sets the secret key.
        :param pulumi.Input[str] windows_live_endpoint: Gets or sets the Windows Live endpoint.
        """
        if package_sid is not None:
            pulumi.set(__self__, "package_sid", package_sid)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if windows_live_endpoint is not None:
            pulumi.set(__self__, "windows_live_endpoint", windows_live_endpoint)

    @property
    @pulumi.getter(name="packageSid")
    def package_sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the package ID for this credential.
        """
        return pulumi.get(self, "package_sid")

    @package_sid.setter
    def package_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_sid", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the secret key.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="windowsLiveEndpoint")
    def windows_live_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Windows Live endpoint.
        """
        return pulumi.get(self, "windows_live_endpoint")

    @windows_live_endpoint.setter
    def windows_live_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "windows_live_endpoint", value)


