# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AdditionalCapabilitiesArgs',
    'AdditionalUnattendContentArgs',
    'ApiEntityReferenceArgs',
    'AutomaticOSUpgradePolicyArgs',
    'AutomaticRepairsPolicyArgs',
    'BillingProfileArgs',
    'BootDiagnosticsArgs',
    'CloudServiceExtensionProfileArgs',
    'CloudServiceExtensionPropertiesArgs',
    'CloudServiceNetworkProfileArgs',
    'CloudServiceOsProfileArgs',
    'CloudServicePropertiesArgs',
    'CloudServiceRoleProfileArgs',
    'CloudServiceRoleProfilePropertiesArgs',
    'CloudServiceRoleSkuArgs',
    'CloudServiceVaultAndSecretReferenceArgs',
    'CloudServiceVaultCertificateArgs',
    'CloudServiceVaultSecretGroupArgs',
    'DataDiskArgs',
    'DiagnosticsProfileArgs',
    'DiffDiskSettingsArgs',
    'DiskEncryptionSetParametersArgs',
    'DiskEncryptionSettingsArgs',
    'ExtendedLocationArgs',
    'ExtensionArgs',
    'HardwareProfileArgs',
    'ImageDataDiskArgs',
    'ImageOSDiskArgs',
    'ImageReferenceArgs',
    'ImageStorageProfileArgs',
    'InstanceViewStatusArgs',
    'KeyVaultKeyReferenceArgs',
    'KeyVaultSecretReferenceArgs',
    'LinuxConfigurationArgs',
    'LinuxPatchSettingsArgs',
    'LoadBalancerConfigurationArgs',
    'LoadBalancerConfigurationPropertiesArgs',
    'LoadBalancerFrontendIPConfigurationArgs',
    'LoadBalancerFrontendIPConfigurationPropertiesArgs',
    'ManagedDiskParametersArgs',
    'NetworkInterfaceReferenceArgs',
    'NetworkProfileArgs',
    'OSDiskArgs',
    'OSProfileArgs',
    'PatchSettingsArgs',
    'PlanArgs',
    'PublicIPAddressSkuArgs',
    'RestorePointCollectionSourcePropertiesArgs',
    'RollingUpgradePolicyArgs',
    'RunCommandInputParameterArgs',
    'ScaleInPolicyArgs',
    'ScheduledEventsProfileArgs',
    'SecurityProfileArgs',
    'SkuArgs',
    'SshConfigurationArgs',
    'SshPublicKeyArgs',
    'StorageProfileArgs',
    'SubResourceArgs',
    'TerminateNotificationProfileArgs',
    'UefiSettingsArgs',
    'UpgradePolicyArgs',
    'VaultCertificateArgs',
    'VaultSecretGroupArgs',
    'VirtualHardDiskArgs',
    'VirtualMachineExtensionInstanceViewArgs',
    'VirtualMachineIdentityArgs',
    'VirtualMachineIpTagArgs',
    'VirtualMachineNetworkInterfaceConfigurationArgs',
    'VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs',
    'VirtualMachineNetworkInterfaceIPConfigurationArgs',
    'VirtualMachinePublicIPAddressConfigurationArgs',
    'VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs',
    'VirtualMachineRunCommandScriptSourceArgs',
    'VirtualMachineScaleSetDataDiskArgs',
    'VirtualMachineScaleSetExtensionArgs',
    'VirtualMachineScaleSetExtensionProfileArgs',
    'VirtualMachineScaleSetIPConfigurationArgs',
    'VirtualMachineScaleSetIdentityArgs',
    'VirtualMachineScaleSetIpTagArgs',
    'VirtualMachineScaleSetManagedDiskParametersArgs',
    'VirtualMachineScaleSetNetworkConfigurationArgs',
    'VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs',
    'VirtualMachineScaleSetNetworkProfileArgs',
    'VirtualMachineScaleSetOSDiskArgs',
    'VirtualMachineScaleSetOSProfileArgs',
    'VirtualMachineScaleSetPublicIPAddressConfigurationArgs',
    'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs',
    'VirtualMachineScaleSetStorageProfileArgs',
    'VirtualMachineScaleSetVMNetworkProfileConfigurationArgs',
    'VirtualMachineScaleSetVMProfileArgs',
    'VirtualMachineScaleSetVMProtectionPolicyArgs',
    'WinRMConfigurationArgs',
    'WinRMListenerArgs',
    'WindowsConfigurationArgs',
]

@pulumi.input_type
class AdditionalCapabilitiesArgs:
    def __init__(__self__, *,
                 ultra_ssd_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Enables or disables a capability on the virtual machine or virtual machine scale set.
        :param pulumi.Input[bool] ultra_ssd_enabled: The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
        """
        if ultra_ssd_enabled is not None:
            pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)

    @property
    @pulumi.getter(name="ultraSSDEnabled")
    def ultra_ssd_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
        """
        return pulumi.get(self, "ultra_ssd_enabled")

    @ultra_ssd_enabled.setter
    def ultra_ssd_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ultra_ssd_enabled", value)


@pulumi.input_type
class AdditionalUnattendContentArgs:
    def __init__(__self__, *,
                 component_name: Optional[pulumi.Input['ComponentNames']] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 pass_name: Optional[pulumi.Input['PassNames']] = None,
                 setting_name: Optional[pulumi.Input['SettingNames']] = None):
        """
        Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.
        :param pulumi.Input['ComponentNames'] component_name: The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
        :param pulumi.Input[str] content: Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
        :param pulumi.Input['PassNames'] pass_name: The pass name. Currently, the only allowable value is OobeSystem.
        :param pulumi.Input['SettingNames'] setting_name: Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
        """
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if pass_name is not None:
            pulumi.set(__self__, "pass_name", pass_name)
        if setting_name is not None:
            pulumi.set(__self__, "setting_name", setting_name)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[pulumi.Input['ComponentNames']]:
        """
        The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
        """
        return pulumi.get(self, "component_name")

    @component_name.setter
    def component_name(self, value: Optional[pulumi.Input['ComponentNames']]):
        pulumi.set(self, "component_name", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="passName")
    def pass_name(self) -> Optional[pulumi.Input['PassNames']]:
        """
        The pass name. Currently, the only allowable value is OobeSystem.
        """
        return pulumi.get(self, "pass_name")

    @pass_name.setter
    def pass_name(self, value: Optional[pulumi.Input['PassNames']]):
        pulumi.set(self, "pass_name", value)

    @property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> Optional[pulumi.Input['SettingNames']]:
        """
        Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
        """
        return pulumi.get(self, "setting_name")

    @setting_name.setter
    def setting_name(self, value: Optional[pulumi.Input['SettingNames']]):
        pulumi.set(self, "setting_name", value)


@pulumi.input_type
class ApiEntityReferenceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The API entity reference.
        :param pulumi.Input[str] id: The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class AutomaticOSUpgradePolicyArgs:
    def __init__(__self__, *,
                 disable_automatic_rollback: Optional[pulumi.Input[bool]] = None,
                 enable_automatic_os_upgrade: Optional[pulumi.Input[bool]] = None):
        """
        The configuration parameters used for performing automatic OS upgrade.
        :param pulumi.Input[bool] disable_automatic_rollback: Whether OS image rollback feature should be disabled. Default value is false.
        :param pulumi.Input[bool] enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. Default value is false. <br><br> If this is set to true for Windows based scale sets, [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet) is automatically set to false and cannot be set to true.
        """
        if disable_automatic_rollback is not None:
            pulumi.set(__self__, "disable_automatic_rollback", disable_automatic_rollback)
        if enable_automatic_os_upgrade is not None:
            pulumi.set(__self__, "enable_automatic_os_upgrade", enable_automatic_os_upgrade)

    @property
    @pulumi.getter(name="disableAutomaticRollback")
    def disable_automatic_rollback(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether OS image rollback feature should be disabled. Default value is false.
        """
        return pulumi.get(self, "disable_automatic_rollback")

    @disable_automatic_rollback.setter
    def disable_automatic_rollback(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_automatic_rollback", value)

    @property
    @pulumi.getter(name="enableAutomaticOSUpgrade")
    def enable_automatic_os_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. Default value is false. <br><br> If this is set to true for Windows based scale sets, [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet) is automatically set to false and cannot be set to true.
        """
        return pulumi.get(self, "enable_automatic_os_upgrade")

    @enable_automatic_os_upgrade.setter
    def enable_automatic_os_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_os_upgrade", value)


@pulumi.input_type
class AutomaticRepairsPolicyArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 grace_period: Optional[pulumi.Input[str]] = None):
        """
        Specifies the configuration parameters for automatic repairs on the virtual machine scale set.
        :param pulumi.Input[bool] enabled: Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
        :param pulumi.Input[str] grace_period: The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 30 minutes (PT30M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 30 minutes (PT30M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
        """
        return pulumi.get(self, "grace_period")

    @grace_period.setter
    def grace_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grace_period", value)


@pulumi.input_type
class BillingProfileArgs:
    def __init__(__self__, *,
                 max_price: Optional[pulumi.Input[float]] = None):
        """
        Specifies the billing related details of a Azure Spot VM or VMSS. <br><br>Minimum api-version: 2019-03-01.
        :param pulumi.Input[float] max_price: Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS. This price is in US Dollars. <br><br> This price will be compared with the current Azure Spot price for the VM size. Also, the prices are compared at the time of create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is greater than the current Azure Spot price. <br><br> The maxPrice will also be used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice after creation of VM/VMSS. <br><br> Possible values are: <br><br> - Any decimal value greater than zero. Example: 0.01538 <br><br> -1 – indicates default price to be up-to on-demand. <br><br> You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS should not be evicted for price reasons. Also, the default max price is -1 if it is not provided by you. <br><br>Minimum api-version: 2019-03-01.
        """
        if max_price is not None:
            pulumi.set(__self__, "max_price", max_price)

    @property
    @pulumi.getter(name="maxPrice")
    def max_price(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS. This price is in US Dollars. <br><br> This price will be compared with the current Azure Spot price for the VM size. Also, the prices are compared at the time of create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is greater than the current Azure Spot price. <br><br> The maxPrice will also be used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice after creation of VM/VMSS. <br><br> Possible values are: <br><br> - Any decimal value greater than zero. Example: 0.01538 <br><br> -1 – indicates default price to be up-to on-demand. <br><br> You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS should not be evicted for price reasons. Also, the default max price is -1 if it is not provided by you. <br><br>Minimum api-version: 2019-03-01.
        """
        return pulumi.get(self, "max_price")

    @max_price.setter
    def max_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_price", value)


@pulumi.input_type
class BootDiagnosticsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 storage_uri: Optional[pulumi.Input[str]] = None):
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        :param pulumi.Input[bool] enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
        :param pulumi.Input[str] storage_uri: Uri of the storage account to use for placing the console output and screenshot. <br><br>If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if storage_uri is not None:
            pulumi.set(__self__, "storage_uri", storage_uri)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether boot diagnostics should be enabled on the Virtual Machine.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="storageUri")
    def storage_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Uri of the storage account to use for placing the console output and screenshot. <br><br>If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
        """
        return pulumi.get(self, "storage_uri")

    @storage_uri.setter
    def storage_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_uri", value)


@pulumi.input_type
class CloudServiceExtensionProfileArgs:
    def __init__(__self__, *,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionArgs']]]] = None):
        """
        Describes a cloud service extension profile.
        :param pulumi.Input[Sequence[pulumi.Input['ExtensionArgs']]] extensions: List of extensions for the cloud service.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionArgs']]]]:
        """
        List of extensions for the cloud service.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)


@pulumi.input_type
class CloudServiceExtensionPropertiesArgs:
    def __init__(__self__, *,
                 auto_upgrade_minor_version: Optional[pulumi.Input[bool]] = None,
                 force_update_tag: Optional[pulumi.Input[str]] = None,
                 protected_settings: Optional[pulumi.Input[str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input['CloudServiceVaultAndSecretReferenceArgs']] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 roles_applied_to: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 settings: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 type_handler_version: Optional[pulumi.Input[str]] = None):
        """
        Extension Properties.
        :param pulumi.Input[bool] auto_upgrade_minor_version: Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become available.
        :param pulumi.Input[str] force_update_tag: Tag to force apply the provided public and protected settings.
               Changing the tag value allows for re-running the extension without changing any of the public or protected settings.
               If forceUpdateTag is not changed, updates to public or protected settings would still be applied by the handler.
               If neither forceUpdateTag nor any of public or protected settings change, extension would flow to the role instance with the same sequence-number, and
               it is up to handler implementation whether to re-run it or not
        :param pulumi.Input[str] protected_settings: Protected settings for the extension which are encrypted before sent to the role instance.
        :param pulumi.Input[str] publisher: The name of the extension handler publisher.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles_applied_to: Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
        :param pulumi.Input[str] settings: Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension (like RDP), this is the XML setting for the extension.
        :param pulumi.Input[str] type: Specifies the type of the extension.
        :param pulumi.Input[str] type_handler_version: Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an asterisk (*) is used as the value, the latest version of the extension is used. If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor version of the specified major version is selected. If a major version number and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade is performed on the role instance.
        """
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if protected_settings_from_key_vault is not None:
            pulumi.set(__self__, "protected_settings_from_key_vault", protected_settings_from_key_vault)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if roles_applied_to is not None:
            pulumi.set(__self__, "roles_applied_to", roles_applied_to)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become available.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Tag to force apply the provided public and protected settings.
        Changing the tag value allows for re-running the extension without changing any of the public or protected settings.
        If forceUpdateTag is not changed, updates to public or protected settings would still be applied by the handler.
        If neither forceUpdateTag nor any of public or protected settings change, extension would flow to the role instance with the same sequence-number, and
        it is up to handler implementation whether to re-run it or not
        """
        return pulumi.get(self, "force_update_tag")

    @force_update_tag.setter
    def force_update_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_update_tag", value)

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Protected settings for the extension which are encrypted before sent to the role instance.
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_settings", value)

    @property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> Optional[pulumi.Input['CloudServiceVaultAndSecretReferenceArgs']]:
        return pulumi.get(self, "protected_settings_from_key_vault")

    @protected_settings_from_key_vault.setter
    def protected_settings_from_key_vault(self, value: Optional[pulumi.Input['CloudServiceVaultAndSecretReferenceArgs']]):
        pulumi.set(self, "protected_settings_from_key_vault", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="rolesAppliedTo")
    def roles_applied_to(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
        """
        return pulumi.get(self, "roles_applied_to")

    @roles_applied_to.setter
    def roles_applied_to(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles_applied_to", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[str]]:
        """
        Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension (like RDP), this is the XML setting for the extension.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the extension.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an asterisk (*) is used as the value, the latest version of the extension is used. If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor version of the specified major version is selected. If a major version number and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade is performed on the role instance.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_handler_version", value)


@pulumi.input_type
class CloudServiceNetworkProfileArgs:
    def __init__(__self__, *,
                 load_balancer_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerConfigurationArgs']]]] = None,
                 swappable_cloud_service: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Network Profile for the cloud service.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerConfigurationArgs']]] load_balancer_configurations: List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
        :param pulumi.Input['SubResourceArgs'] swappable_cloud_service: The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown.
        """
        if load_balancer_configurations is not None:
            pulumi.set(__self__, "load_balancer_configurations", load_balancer_configurations)
        if swappable_cloud_service is not None:
            pulumi.set(__self__, "swappable_cloud_service", swappable_cloud_service)

    @property
    @pulumi.getter(name="loadBalancerConfigurations")
    def load_balancer_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerConfigurationArgs']]]]:
        """
        List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
        """
        return pulumi.get(self, "load_balancer_configurations")

    @load_balancer_configurations.setter
    def load_balancer_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerConfigurationArgs']]]]):
        pulumi.set(self, "load_balancer_configurations", value)

    @property
    @pulumi.getter(name="swappableCloudService")
    def swappable_cloud_service(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown.
        """
        return pulumi.get(self, "swappable_cloud_service")

    @swappable_cloud_service.setter
    def swappable_cloud_service(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "swappable_cloud_service", value)


@pulumi.input_type
class CloudServiceOsProfileArgs:
    def __init__(__self__, *,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultSecretGroupArgs']]]] = None):
        """
        Describes the OS profile for the cloud service.
        :param pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultSecretGroupArgs']]] secrets: Specifies set of certificates that should be installed onto the role instances.
        """
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultSecretGroupArgs']]]]:
        """
        Specifies set of certificates that should be installed onto the role instances.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultSecretGroupArgs']]]]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class CloudServicePropertiesArgs:
    def __init__(__self__, *,
                 allow_model_override: Optional[pulumi.Input[bool]] = None,
                 configuration: Optional[pulumi.Input[str]] = None,
                 configuration_url: Optional[pulumi.Input[str]] = None,
                 extension_profile: Optional[pulumi.Input['CloudServiceExtensionProfileArgs']] = None,
                 network_profile: Optional[pulumi.Input['CloudServiceNetworkProfileArgs']] = None,
                 os_profile: Optional[pulumi.Input['CloudServiceOsProfileArgs']] = None,
                 package_url: Optional[pulumi.Input[str]] = None,
                 role_profile: Optional[pulumi.Input['CloudServiceRoleProfileArgs']] = None,
                 start_cloud_service: Optional[pulumi.Input[bool]] = None,
                 upgrade_mode: Optional[pulumi.Input[Union[str, 'CloudServiceUpgradeMode']]] = None):
        """
        Cloud service properties
        :param pulumi.Input[bool] allow_model_override: (Optional) Indicates whether the role sku properties (roleProfile.roles.sku) specified in the model/template should override the role instance count and vm size specified in the .cscfg and .csdef respectively.
               The default value is `false`.
        :param pulumi.Input[str] configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
        :param pulumi.Input[str] configuration_url: Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL  can be Shared Access Signature (SAS) URI from any storage account.
               This is a write-only property and is not returned in GET calls.
        :param pulumi.Input['CloudServiceExtensionProfileArgs'] extension_profile: Describes a cloud service extension profile.
        :param pulumi.Input['CloudServiceNetworkProfileArgs'] network_profile: Network Profile for the cloud service.
        :param pulumi.Input['CloudServiceOsProfileArgs'] os_profile: Describes the OS profile for the cloud service.
        :param pulumi.Input[str] package_url: Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage account.
               This is a write-only property and is not returned in GET calls.
        :param pulumi.Input['CloudServiceRoleProfileArgs'] role_profile: Describes the role profile for the cloud service.
        :param pulumi.Input[bool] start_cloud_service: (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is `true`.
               If false, the service model is still deployed, but the code is not run immediately. Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service still incurs charges, even if it is poweredoff.
        :param pulumi.Input[Union[str, 'CloudServiceUpgradeMode']] upgrade_mode: Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
               Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
               If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
        """
        if allow_model_override is not None:
            pulumi.set(__self__, "allow_model_override", allow_model_override)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if configuration_url is not None:
            pulumi.set(__self__, "configuration_url", configuration_url)
        if extension_profile is not None:
            pulumi.set(__self__, "extension_profile", extension_profile)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if package_url is not None:
            pulumi.set(__self__, "package_url", package_url)
        if role_profile is not None:
            pulumi.set(__self__, "role_profile", role_profile)
        if start_cloud_service is not None:
            pulumi.set(__self__, "start_cloud_service", start_cloud_service)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)

    @property
    @pulumi.getter(name="allowModelOverride")
    def allow_model_override(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Indicates whether the role sku properties (roleProfile.roles.sku) specified in the model/template should override the role instance count and vm size specified in the .cscfg and .csdef respectively.
        The default value is `false`.
        """
        return pulumi.get(self, "allow_model_override")

    @allow_model_override.setter
    def allow_model_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_model_override", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the XML service configuration (.cscfg) for the cloud service.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="configurationUrl")
    def configuration_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL  can be Shared Access Signature (SAS) URI from any storage account.
        This is a write-only property and is not returned in GET calls.
        """
        return pulumi.get(self, "configuration_url")

    @configuration_url.setter
    def configuration_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_url", value)

    @property
    @pulumi.getter(name="extensionProfile")
    def extension_profile(self) -> Optional[pulumi.Input['CloudServiceExtensionProfileArgs']]:
        """
        Describes a cloud service extension profile.
        """
        return pulumi.get(self, "extension_profile")

    @extension_profile.setter
    def extension_profile(self, value: Optional[pulumi.Input['CloudServiceExtensionProfileArgs']]):
        pulumi.set(self, "extension_profile", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['CloudServiceNetworkProfileArgs']]:
        """
        Network Profile for the cloud service.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['CloudServiceNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['CloudServiceOsProfileArgs']]:
        """
        Describes the OS profile for the cloud service.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['CloudServiceOsProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter(name="packageUrl")
    def package_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage account.
        This is a write-only property and is not returned in GET calls.
        """
        return pulumi.get(self, "package_url")

    @package_url.setter
    def package_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_url", value)

    @property
    @pulumi.getter(name="roleProfile")
    def role_profile(self) -> Optional[pulumi.Input['CloudServiceRoleProfileArgs']]:
        """
        Describes the role profile for the cloud service.
        """
        return pulumi.get(self, "role_profile")

    @role_profile.setter
    def role_profile(self, value: Optional[pulumi.Input['CloudServiceRoleProfileArgs']]):
        pulumi.set(self, "role_profile", value)

    @property
    @pulumi.getter(name="startCloudService")
    def start_cloud_service(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is `true`.
        If false, the service model is still deployed, but the code is not run immediately. Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service still incurs charges, even if it is poweredoff.
        """
        return pulumi.get(self, "start_cloud_service")

    @start_cloud_service.setter
    def start_cloud_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_cloud_service", value)

    @property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[pulumi.Input[Union[str, 'CloudServiceUpgradeMode']]]:
        """
        Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
        Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
        If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
        """
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: Optional[pulumi.Input[Union[str, 'CloudServiceUpgradeMode']]]):
        pulumi.set(self, "upgrade_mode", value)


@pulumi.input_type
class CloudServiceRoleProfileArgs:
    def __init__(__self__, *,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceRoleProfilePropertiesArgs']]]] = None):
        """
        Describes the role profile for the cloud service.
        :param pulumi.Input[Sequence[pulumi.Input['CloudServiceRoleProfilePropertiesArgs']]] roles: List of roles for the cloud service.
        """
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceRoleProfilePropertiesArgs']]]]:
        """
        List of roles for the cloud service.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceRoleProfilePropertiesArgs']]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class CloudServiceRoleProfilePropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input['CloudServiceRoleSkuArgs']] = None):
        """
        Describes the role properties.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input['CloudServiceRoleSkuArgs'] sku: Describes the cloud service role sku.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['CloudServiceRoleSkuArgs']]:
        """
        Describes the cloud service role sku.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['CloudServiceRoleSkuArgs']]):
        pulumi.set(self, "sku", value)


@pulumi.input_type
class CloudServiceRoleSkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Describes the cloud service role sku.
        :param pulumi.Input[float] capacity: Specifies the number of role instances in the cloud service.
        :param pulumi.Input[str] name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete and recreate the cloud service or move back to the old sku.
        :param pulumi.Input[str] tier: Specifies the tier of the cloud service. Possible Values are <br /><br /> **Standard** <br /><br /> **Basic**
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the number of role instances in the cloud service.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete and recreate the cloud service or move back to the old sku.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the tier of the cloud service. Possible Values are <br /><br /> **Standard** <br /><br /> **Basic**
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class CloudServiceVaultAndSecretReferenceArgs:
    def __init__(__self__, *,
                 secret_url: Optional[pulumi.Input[str]] = None,
                 source_vault: Optional[pulumi.Input['SubResourceArgs']] = None):
        if secret_url is not None:
            pulumi.set(__self__, "secret_url", secret_url)
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secret_url")

    @secret_url.setter
    def secret_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class CloudServiceVaultCertificateArgs:
    def __init__(__self__, *,
                 certificate_url: Optional[pulumi.Input[str]] = None):
        """
        Describes a single certificate reference in a Key Vault, and where the certificate should reside on the role instance.
        :param pulumi.Input[str] certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret.
        """
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[pulumi.Input[str]]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret.
        """
        return pulumi.get(self, "certificate_url")

    @certificate_url.setter
    def certificate_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_url", value)


@pulumi.input_type
class CloudServiceVaultSecretGroupArgs:
    def __init__(__self__, *,
                 source_vault: Optional[pulumi.Input['SubResourceArgs']] = None,
                 vault_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultCertificateArgs']]]] = None):
        """
        Describes a set of certificates which are all in the same Key Vault.
        :param pulumi.Input['SubResourceArgs'] source_vault: The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        :param pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultCertificateArgs']]] vault_certificates: The list of key vault references in SourceVault which contain certificates.
        """
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)
        if vault_certificates is not None:
            pulumi.set(__self__, "vault_certificates", vault_certificates)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "source_vault", value)

    @property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultCertificateArgs']]]]:
        """
        The list of key vault references in SourceVault which contain certificates.
        """
        return pulumi.get(self, "vault_certificates")

    @vault_certificates.setter
    def vault_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultCertificateArgs']]]]):
        pulumi.set(self, "vault_certificates", value)


@pulumi.input_type
class DataDiskArgs:
    def __init__(__self__, *,
                 create_option: pulumi.Input[Union[str, 'DiskCreateOptionTypes']],
                 lun: pulumi.Input[int],
                 caching: Optional[pulumi.Input['CachingTypes']] = None,
                 delete_option: Optional[pulumi.Input[Union[str, 'DiskDeleteOptionTypes']]] = None,
                 detach_option: Optional[pulumi.Input[Union[str, 'DiskDetachOptionTypes']]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 image: Optional[pulumi.Input['VirtualHardDiskArgs']] = None,
                 managed_disk: Optional[pulumi.Input['ManagedDiskParametersArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 to_be_detached: Optional[pulumi.Input[bool]] = None,
                 vhd: Optional[pulumi.Input['VirtualHardDiskArgs']] = None,
                 write_accelerator_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Describes a data disk.
        :param pulumi.Input[Union[str, 'DiskCreateOptionTypes']] create_option: Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param pulumi.Input[int] lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param pulumi.Input['CachingTypes'] caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param pulumi.Input[Union[str, 'DiskDeleteOptionTypes']] delete_option: Specifies whether data disk should be deleted or detached upon VM deletion.<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VM is deleted.<br><br> The default value is set to **detach**
        :param pulumi.Input[Union[str, 'DiskDetachOptionTypes']] detach_option: Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach**. <br><br> detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. <br><br> This feature is still in preview mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
        :param pulumi.Input[int] disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param pulumi.Input['VirtualHardDiskArgs'] image: The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        :param pulumi.Input['ManagedDiskParametersArgs'] managed_disk: The managed disk parameters.
        :param pulumi.Input[str] name: The disk name.
        :param pulumi.Input[bool] to_be_detached: Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
        :param pulumi.Input['VirtualHardDiskArgs'] vhd: The virtual hard disk.
        :param pulumi.Input[bool] write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if delete_option is not None:
            pulumi.set(__self__, "delete_option", delete_option)
        if detach_option is not None:
            pulumi.set(__self__, "detach_option", detach_option)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if to_be_detached is not None:
            pulumi.set(__self__, "to_be_detached", to_be_detached)
        if vhd is not None:
            pulumi.set(__self__, "vhd", vhd)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Input[Union[str, 'DiskCreateOptionTypes']]:
        """
        Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: pulumi.Input[Union[str, 'DiskCreateOptionTypes']]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input['CachingTypes']]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input['CachingTypes']]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="deleteOption")
    def delete_option(self) -> Optional[pulumi.Input[Union[str, 'DiskDeleteOptionTypes']]]:
        """
        Specifies whether data disk should be deleted or detached upon VM deletion.<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VM is deleted.<br><br> The default value is set to **detach**
        """
        return pulumi.get(self, "delete_option")

    @delete_option.setter
    def delete_option(self, value: Optional[pulumi.Input[Union[str, 'DiskDeleteOptionTypes']]]):
        pulumi.set(self, "delete_option", value)

    @property
    @pulumi.getter(name="detachOption")
    def detach_option(self) -> Optional[pulumi.Input[Union[str, 'DiskDetachOptionTypes']]]:
        """
        Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach**. <br><br> detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. <br><br> This feature is still in preview mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
        """
        return pulumi.get(self, "detach_option")

    @detach_option.setter
    def detach_option(self, value: Optional[pulumi.Input[Union[str, 'DiskDetachOptionTypes']]]):
        pulumi.set(self, "detach_option", value)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['VirtualHardDiskArgs']]:
        """
        The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['VirtualHardDiskArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional[pulumi.Input['ManagedDiskParametersArgs']]:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @managed_disk.setter
    def managed_disk(self, value: Optional[pulumi.Input['ManagedDiskParametersArgs']]):
        pulumi.set(self, "managed_disk", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="toBeDetached")
    def to_be_detached(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
        """
        return pulumi.get(self, "to_be_detached")

    @to_be_detached.setter
    def to_be_detached(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "to_be_detached", value)

    @property
    @pulumi.getter
    def vhd(self) -> Optional[pulumi.Input['VirtualHardDiskArgs']]:
        """
        The virtual hard disk.
        """
        return pulumi.get(self, "vhd")

    @vhd.setter
    def vhd(self, value: Optional[pulumi.Input['VirtualHardDiskArgs']]):
        pulumi.set(self, "vhd", value)

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")

    @write_accelerator_enabled.setter
    def write_accelerator_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_accelerator_enabled", value)


@pulumi.input_type
class DiagnosticsProfileArgs:
    def __init__(__self__, *,
                 boot_diagnostics: Optional[pulumi.Input['BootDiagnosticsArgs']] = None):
        """
        Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        :param pulumi.Input['BootDiagnosticsArgs'] boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['BootDiagnosticsArgs']]:
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['BootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)


@pulumi.input_type
class DiffDiskSettingsArgs:
    def __init__(__self__, *,
                 option: Optional[pulumi.Input[Union[str, 'DiffDiskOptions']]] = None,
                 placement: Optional[pulumi.Input[Union[str, 'DiffDiskPlacement']]] = None):
        """
        Describes the parameters of ephemeral disk settings that can be specified for operating system disk. <br><br> NOTE: The ephemeral disk settings can only be specified for managed disk.
        :param pulumi.Input[Union[str, 'DiffDiskOptions']] option: Specifies the ephemeral disk settings for operating system disk.
        :param pulumi.Input[Union[str, 'DiffDiskPlacement']] placement: Specifies the ephemeral disk placement for operating system disk.<br><br> Possible values are: <br><br> **CacheDisk** <br><br> **ResourceDisk** <br><br> Default: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used.<br><br> Refer to VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
        """
        if option is not None:
            pulumi.set(__self__, "option", option)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)

    @property
    @pulumi.getter
    def option(self) -> Optional[pulumi.Input[Union[str, 'DiffDiskOptions']]]:
        """
        Specifies the ephemeral disk settings for operating system disk.
        """
        return pulumi.get(self, "option")

    @option.setter
    def option(self, value: Optional[pulumi.Input[Union[str, 'DiffDiskOptions']]]):
        pulumi.set(self, "option", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[Union[str, 'DiffDiskPlacement']]]:
        """
        Specifies the ephemeral disk placement for operating system disk.<br><br> Possible values are: <br><br> **CacheDisk** <br><br> **ResourceDisk** <br><br> Default: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used.<br><br> Refer to VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[Union[str, 'DiffDiskPlacement']]]):
        pulumi.set(self, "placement", value)


@pulumi.input_type
class DiskEncryptionSetParametersArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. <br><br> NOTE: The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
        :param pulumi.Input[str] id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class DiskEncryptionSettingsArgs:
    def __init__(__self__, *,
                 disk_encryption_key: Optional[pulumi.Input['KeyVaultSecretReferenceArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_encryption_key: Optional[pulumi.Input['KeyVaultKeyReferenceArgs']] = None):
        """
        Describes a Encryption Settings for a Disk
        :param pulumi.Input['KeyVaultSecretReferenceArgs'] disk_encryption_key: Specifies the location of the disk encryption key, which is a Key Vault Secret.
        :param pulumi.Input[bool] enabled: Specifies whether disk encryption should be enabled on the virtual machine.
        :param pulumi.Input['KeyVaultKeyReferenceArgs'] key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        """
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional[pulumi.Input['KeyVaultSecretReferenceArgs']]:
        """
        Specifies the location of the disk encryption key, which is a Key Vault Secret.
        """
        return pulumi.get(self, "disk_encryption_key")

    @disk_encryption_key.setter
    def disk_encryption_key(self, value: Optional[pulumi.Input['KeyVaultSecretReferenceArgs']]):
        pulumi.set(self, "disk_encryption_key", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether disk encryption should be enabled on the virtual machine.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional[pulumi.Input['KeyVaultKeyReferenceArgs']]:
        """
        Specifies the location of the key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_encryption_key")

    @key_encryption_key.setter
    def key_encryption_key(self, value: Optional[pulumi.Input['KeyVaultKeyReferenceArgs']]):
        pulumi.set(self, "key_encryption_key", value)


@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]] = None):
        """
        The complex type of the extended location.
        :param pulumi.Input[str] name: The name of the extended location.
        :param pulumi.Input[Union[str, 'ExtendedLocationTypes']] type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ExtensionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['CloudServiceExtensionPropertiesArgs']] = None):
        """
        Describes a cloud service Extension.
        :param pulumi.Input[str] name: The name of the extension.
        :param pulumi.Input['CloudServiceExtensionPropertiesArgs'] properties: Extension Properties.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['CloudServiceExtensionPropertiesArgs']]:
        """
        Extension Properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['CloudServiceExtensionPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class HardwareProfileArgs:
    def __init__(__self__, *,
                 vm_size: Optional[pulumi.Input[Union[str, 'VirtualMachineSizeTypes']]] = None):
        """
        Specifies the hardware settings for the virtual machine.
        :param pulumi.Input[Union[str, 'VirtualMachineSizeTypes']] vm_size: Specifies the size of the virtual machine. <br><br> The enum data type is currently deprecated and will be removed by December 23rd 2023. <br><br> Recommended way to get the list of available sizes is using these APIs: <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region]( https://docs.microsoft.com/rest/api/compute/resourceskus/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes). For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). <br><br> The available VM sizes depend on region and availability set.
        """
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[Union[str, 'VirtualMachineSizeTypes']]]:
        """
        Specifies the size of the virtual machine. <br><br> The enum data type is currently deprecated and will be removed by December 23rd 2023. <br><br> Recommended way to get the list of available sizes is using these APIs: <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region]( https://docs.microsoft.com/rest/api/compute/resourceskus/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes). For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). <br><br> The available VM sizes depend on region and availability set.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[Union[str, 'VirtualMachineSizeTypes']]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class ImageDataDiskArgs:
    def __init__(__self__, *,
                 lun: pulumi.Input[int],
                 blob_uri: Optional[pulumi.Input[str]] = None,
                 caching: Optional[pulumi.Input['CachingTypes']] = None,
                 disk_encryption_set: Optional[pulumi.Input['DiskEncryptionSetParametersArgs']] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 managed_disk: Optional[pulumi.Input['SubResourceArgs']] = None,
                 snapshot: Optional[pulumi.Input['SubResourceArgs']] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]] = None):
        """
        Describes a data disk.
        :param pulumi.Input[int] lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param pulumi.Input[str] blob_uri: The Virtual Hard Disk.
        :param pulumi.Input['CachingTypes'] caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param pulumi.Input['DiskEncryptionSetParametersArgs'] disk_encryption_set: Specifies the customer managed disk encryption set resource id for the managed image disk.
        :param pulumi.Input[int] disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param pulumi.Input['SubResourceArgs'] managed_disk: The managedDisk.
        :param pulumi.Input['SubResourceArgs'] snapshot: The snapshot.
        :param pulumi.Input[Union[str, 'StorageAccountTypes']] storage_account_type: Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        pulumi.set(__self__, "lun", lun)
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_encryption_set is not None:
            pulumi.set(__self__, "disk_encryption_set", disk_encryption_set)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Virtual Hard Disk.
        """
        return pulumi.get(self, "blob_uri")

    @blob_uri.setter
    def blob_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_uri", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input['CachingTypes']]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input['CachingTypes']]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="diskEncryptionSet")
    def disk_encryption_set(self) -> Optional[pulumi.Input['DiskEncryptionSetParametersArgs']]:
        """
        Specifies the customer managed disk encryption set resource id for the managed image disk.
        """
        return pulumi.get(self, "disk_encryption_set")

    @disk_encryption_set.setter
    def disk_encryption_set(self, value: Optional[pulumi.Input['DiskEncryptionSetParametersArgs']]):
        pulumi.set(self, "disk_encryption_set", value)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The managedDisk.
        """
        return pulumi.get(self, "managed_disk")

    @managed_disk.setter
    def managed_disk(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "managed_disk", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The snapshot.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]]:
        """
        Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class ImageOSDiskArgs:
    def __init__(__self__, *,
                 os_state: pulumi.Input['OperatingSystemStateTypes'],
                 os_type: pulumi.Input['OperatingSystemTypes'],
                 blob_uri: Optional[pulumi.Input[str]] = None,
                 caching: Optional[pulumi.Input['CachingTypes']] = None,
                 disk_encryption_set: Optional[pulumi.Input['DiskEncryptionSetParametersArgs']] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 managed_disk: Optional[pulumi.Input['SubResourceArgs']] = None,
                 snapshot: Optional[pulumi.Input['SubResourceArgs']] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]] = None):
        """
        Describes an Operating System disk.
        :param pulumi.Input['OperatingSystemStateTypes'] os_state: The OS State.
        :param pulumi.Input['OperatingSystemTypes'] os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from a custom image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param pulumi.Input[str] blob_uri: The Virtual Hard Disk.
        :param pulumi.Input['CachingTypes'] caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param pulumi.Input['DiskEncryptionSetParametersArgs'] disk_encryption_set: Specifies the customer managed disk encryption set resource id for the managed image disk.
        :param pulumi.Input[int] disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param pulumi.Input['SubResourceArgs'] managed_disk: The managedDisk.
        :param pulumi.Input['SubResourceArgs'] snapshot: The snapshot.
        :param pulumi.Input[Union[str, 'StorageAccountTypes']] storage_account_type: Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        pulumi.set(__self__, "os_state", os_state)
        pulumi.set(__self__, "os_type", os_type)
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_encryption_set is not None:
            pulumi.set(__self__, "disk_encryption_set", disk_encryption_set)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="osState")
    def os_state(self) -> pulumi.Input['OperatingSystemStateTypes']:
        """
        The OS State.
        """
        return pulumi.get(self, "os_state")

    @os_state.setter
    def os_state(self, value: pulumi.Input['OperatingSystemStateTypes']):
        pulumi.set(self, "os_state", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input['OperatingSystemTypes']:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from a custom image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input['OperatingSystemTypes']):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Virtual Hard Disk.
        """
        return pulumi.get(self, "blob_uri")

    @blob_uri.setter
    def blob_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_uri", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input['CachingTypes']]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input['CachingTypes']]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="diskEncryptionSet")
    def disk_encryption_set(self) -> Optional[pulumi.Input['DiskEncryptionSetParametersArgs']]:
        """
        Specifies the customer managed disk encryption set resource id for the managed image disk.
        """
        return pulumi.get(self, "disk_encryption_set")

    @disk_encryption_set.setter
    def disk_encryption_set(self, value: Optional[pulumi.Input['DiskEncryptionSetParametersArgs']]):
        pulumi.set(self, "disk_encryption_set", value)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The managedDisk.
        """
        return pulumi.get(self, "managed_disk")

    @managed_disk.setter
    def managed_disk(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "managed_disk", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The snapshot.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]]:
        """
        Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class ImageReferenceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] offer: Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        :param pulumi.Input[str] publisher: The image publisher.
        :param pulumi.Input[str] sku: The image SKU.
        :param pulumi.Input[str] version: Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        The image SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ImageStorageProfileArgs:
    def __init__(__self__, *,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDataDiskArgs']]]] = None,
                 os_disk: Optional[pulumi.Input['ImageOSDiskArgs']] = None,
                 zone_resilient: Optional[pulumi.Input[bool]] = None):
        """
        Describes a storage profile.
        :param pulumi.Input[Sequence[pulumi.Input['ImageDataDiskArgs']]] data_disks: Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        :param pulumi.Input['ImageOSDiskArgs'] os_disk: Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        :param pulumi.Input[bool] zone_resilient: Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)
        if zone_resilient is not None:
            pulumi.set(__self__, "zone_resilient", zone_resilient)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageDataDiskArgs']]]]:
        """
        Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional[pulumi.Input['ImageOSDiskArgs']]:
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: Optional[pulumi.Input['ImageOSDiskArgs']]):
        pulumi.set(self, "os_disk", value)

    @property
    @pulumi.getter(name="zoneResilient")
    def zone_resilient(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        """
        return pulumi.get(self, "zone_resilient")

    @zone_resilient.setter
    def zone_resilient(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "zone_resilient", value)


@pulumi.input_type
class InstanceViewStatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 display_status: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input['StatusLevelTypes']] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 time: Optional[pulumi.Input[str]] = None):
        """
        Instance view status.
        :param pulumi.Input[str] code: The status code.
        :param pulumi.Input[str] display_status: The short localizable label for the status.
        :param pulumi.Input['StatusLevelTypes'] level: The level code.
        :param pulumi.Input[str] message: The detailed status message, including for alerts and error messages.
        :param pulumi.Input[str] time: The time of the status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        The status code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[pulumi.Input[str]]:
        """
        The short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @display_status.setter
    def display_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_status", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input['StatusLevelTypes']]:
        """
        The level code.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input['StatusLevelTypes']]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The detailed status message, including for alerts and error messages.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[str]]:
        """
        The time of the status.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class KeyVaultKeyReferenceArgs:
    def __init__(__self__, *,
                 key_url: pulumi.Input[str],
                 source_vault: pulumi.Input['SubResourceArgs']):
        """
        Describes a reference to Key Vault Key
        :param pulumi.Input[str] key_url: The URL referencing a key encryption key in Key Vault.
        :param pulumi.Input['SubResourceArgs'] source_vault: The relative URL of the Key Vault containing the key.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> pulumi.Input[str]:
        """
        The URL referencing a key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_url")

    @key_url.setter
    def key_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> pulumi.Input['SubResourceArgs']:
        """
        The relative URL of the Key Vault containing the key.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: pulumi.Input['SubResourceArgs']):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class KeyVaultSecretReferenceArgs:
    def __init__(__self__, *,
                 secret_url: pulumi.Input[str],
                 source_vault: pulumi.Input['SubResourceArgs']):
        """
        Describes a reference to Key Vault Secret
        :param pulumi.Input[str] secret_url: The URL referencing a secret in a Key Vault.
        :param pulumi.Input['SubResourceArgs'] source_vault: The relative URL of the Key Vault containing the secret.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> pulumi.Input[str]:
        """
        The URL referencing a secret in a Key Vault.
        """
        return pulumi.get(self, "secret_url")

    @secret_url.setter
    def secret_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> pulumi.Input['SubResourceArgs']:
        """
        The relative URL of the Key Vault containing the secret.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: pulumi.Input['SubResourceArgs']):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class LinuxConfigurationArgs:
    def __init__(__self__, *,
                 disable_password_authentication: Optional[pulumi.Input[bool]] = None,
                 patch_settings: Optional[pulumi.Input['LinuxPatchSettingsArgs']] = None,
                 provision_vm_agent: Optional[pulumi.Input[bool]] = None,
                 ssh: Optional[pulumi.Input['SshConfigurationArgs']] = None):
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        :param pulumi.Input[bool] disable_password_authentication: Specifies whether password authentication should be disabled.
        :param pulumi.Input['LinuxPatchSettingsArgs'] patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on Linux.
        :param pulumi.Input[bool] provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        :param pulumi.Input['SshConfigurationArgs'] ssh: Specifies the ssh key configuration for a Linux OS.
        """
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if patch_settings is not None:
            pulumi.set(__self__, "patch_settings", patch_settings)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether password authentication should be disabled.
        """
        return pulumi.get(self, "disable_password_authentication")

    @disable_password_authentication.setter
    def disable_password_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_password_authentication", value)

    @property
    @pulumi.getter(name="patchSettings")
    def patch_settings(self) -> Optional[pulumi.Input['LinuxPatchSettingsArgs']]:
        """
        [Preview Feature] Specifies settings related to VM Guest Patching on Linux.
        """
        return pulumi.get(self, "patch_settings")

    @patch_settings.setter
    def patch_settings(self, value: Optional[pulumi.Input['LinuxPatchSettingsArgs']]):
        pulumi.set(self, "patch_settings", value)

    @property
    @pulumi.getter(name="provisionVMAgent")
    def provision_vm_agent(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        """
        return pulumi.get(self, "provision_vm_agent")

    @provision_vm_agent.setter
    def provision_vm_agent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "provision_vm_agent", value)

    @property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['SshConfigurationArgs']]:
        """
        Specifies the ssh key configuration for a Linux OS.
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['SshConfigurationArgs']]):
        pulumi.set(self, "ssh", value)


@pulumi.input_type
class LinuxPatchSettingsArgs:
    def __init__(__self__, *,
                 assessment_mode: Optional[pulumi.Input[Union[str, 'LinuxPatchAssessmentMode']]] = None,
                 patch_mode: Optional[pulumi.Input[Union[str, 'LinuxVMGuestPatchMode']]] = None):
        """
        Specifies settings related to VM Guest Patching on Linux.
        :param pulumi.Input[Union[str, 'LinuxPatchAssessmentMode']] assessment_mode: Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
        :param pulumi.Input[Union[str, 'LinuxVMGuestPatchMode']] patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true
        """
        if assessment_mode is not None:
            pulumi.set(__self__, "assessment_mode", assessment_mode)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)

    @property
    @pulumi.getter(name="assessmentMode")
    def assessment_mode(self) -> Optional[pulumi.Input[Union[str, 'LinuxPatchAssessmentMode']]]:
        """
        Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
        """
        return pulumi.get(self, "assessment_mode")

    @assessment_mode.setter
    def assessment_mode(self, value: Optional[pulumi.Input[Union[str, 'LinuxPatchAssessmentMode']]]):
        pulumi.set(self, "assessment_mode", value)

    @property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[pulumi.Input[Union[str, 'LinuxVMGuestPatchMode']]]:
        """
        Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true
        """
        return pulumi.get(self, "patch_mode")

    @patch_mode.setter
    def patch_mode(self, value: Optional[pulumi.Input[Union[str, 'LinuxVMGuestPatchMode']]]):
        pulumi.set(self, "patch_mode", value)


@pulumi.input_type
class LoadBalancerConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 properties: pulumi.Input['LoadBalancerConfigurationPropertiesArgs'],
                 id: Optional[pulumi.Input[str]] = None):
        """
        Describes the load balancer configuration.
        :param pulumi.Input[str] name: The name of the Load balancer
        :param pulumi.Input['LoadBalancerConfigurationPropertiesArgs'] properties: Properties of the load balancer configuration.
        :param pulumi.Input[str] id: Resource Id
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Load balancer
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input['LoadBalancerConfigurationPropertiesArgs']:
        """
        Properties of the load balancer configuration.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input['LoadBalancerConfigurationPropertiesArgs']):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class LoadBalancerConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 frontend_ip_configurations: pulumi.Input[Sequence[pulumi.Input['LoadBalancerFrontendIPConfigurationArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerFrontendIPConfigurationArgs']]] frontend_ip_configurations: Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
        """
        pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerFrontendIPConfigurationArgs']]]:
        """
        Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @frontend_ip_configurations.setter
    def frontend_ip_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerFrontendIPConfigurationArgs']]]):
        pulumi.set(self, "frontend_ip_configurations", value)


@pulumi.input_type
class LoadBalancerFrontendIPConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 properties: pulumi.Input['LoadBalancerFrontendIPConfigurationPropertiesArgs']):
        """
        :param pulumi.Input[str] name: The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
        :param pulumi.Input['LoadBalancerFrontendIPConfigurationPropertiesArgs'] properties: Properties of load balancer frontend ip configuration.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input['LoadBalancerFrontendIPConfigurationPropertiesArgs']:
        """
        Properties of load balancer frontend ip configuration.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input['LoadBalancerFrontendIPConfigurationPropertiesArgs']):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class LoadBalancerFrontendIPConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 public_ip_address: Optional[pulumi.Input['SubResourceArgs']] = None,
                 subnet: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Describes a cloud service IP Configuration
        :param pulumi.Input[str] private_ip_address: The virtual network private IP address of the IP configuration.
        :param pulumi.Input['SubResourceArgs'] public_ip_address: The reference to the public ip address resource.
        :param pulumi.Input['SubResourceArgs'] subnet: The reference to the virtual network subnet resource.
        """
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual network private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the public ip address resource.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The reference to the virtual network subnet resource.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class ManagedDiskParametersArgs:
    def __init__(__self__, *,
                 disk_encryption_set: Optional[pulumi.Input['DiskEncryptionSetParametersArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]] = None):
        """
        The parameters of a managed disk.
        :param pulumi.Input['DiskEncryptionSetParametersArgs'] disk_encryption_set: Specifies the customer managed disk encryption set resource id for the managed disk.
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[Union[str, 'StorageAccountTypes']] storage_account_type: Specifies the storage account type for the managed disk. Managed OS disk storage account type can only be set when you create the scale set. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        if disk_encryption_set is not None:
            pulumi.set(__self__, "disk_encryption_set", disk_encryption_set)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="diskEncryptionSet")
    def disk_encryption_set(self) -> Optional[pulumi.Input['DiskEncryptionSetParametersArgs']]:
        """
        Specifies the customer managed disk encryption set resource id for the managed disk.
        """
        return pulumi.get(self, "disk_encryption_set")

    @disk_encryption_set.setter
    def disk_encryption_set(self, value: Optional[pulumi.Input['DiskEncryptionSetParametersArgs']]):
        pulumi.set(self, "disk_encryption_set", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]]:
        """
        Specifies the storage account type for the managed disk. Managed OS disk storage account type can only be set when you create the scale set. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class NetworkInterfaceReferenceArgs:
    def __init__(__self__, *,
                 delete_option: Optional[pulumi.Input[Union[str, 'DeleteOptions']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 primary: Optional[pulumi.Input[bool]] = None):
        """
        Describes a network interface reference.
        :param pulumi.Input[Union[str, 'DeleteOptions']] delete_option: Specify what happens to the network interface when the VM is deleted
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[bool] primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        if delete_option is not None:
            pulumi.set(__self__, "delete_option", delete_option)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter(name="deleteOption")
    def delete_option(self) -> Optional[pulumi.Input[Union[str, 'DeleteOptions']]]:
        """
        Specify what happens to the network interface when the VM is deleted
        """
        return pulumi.get(self, "delete_option")

    @delete_option.setter
    def delete_option(self, value: Optional[pulumi.Input[Union[str, 'DeleteOptions']]]):
        pulumi.set(self, "delete_option", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)


@pulumi.input_type
class NetworkProfileArgs:
    def __init__(__self__, *,
                 network_api_version: Optional[pulumi.Input[Union[str, 'NetworkApiVersion']]] = None,
                 network_interface_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceConfigurationArgs']]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceReferenceArgs']]]] = None):
        """
        Specifies the network interfaces or the networking configuration of the virtual machine.
        :param pulumi.Input[Union[str, 'NetworkApiVersion']] network_api_version: specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceConfigurationArgs']]] network_interface_configurations: Specifies the networking configurations that will be used to create the virtual machine networking resources.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceReferenceArgs']]] network_interfaces: Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
        """
        if network_api_version is not None:
            pulumi.set(__self__, "network_api_version", network_api_version)
        if network_interface_configurations is not None:
            pulumi.set(__self__, "network_interface_configurations", network_interface_configurations)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkApiVersion")
    def network_api_version(self) -> Optional[pulumi.Input[Union[str, 'NetworkApiVersion']]]:
        """
        specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
        """
        return pulumi.get(self, "network_api_version")

    @network_api_version.setter
    def network_api_version(self, value: Optional[pulumi.Input[Union[str, 'NetworkApiVersion']]]):
        pulumi.set(self, "network_api_version", value)

    @property
    @pulumi.getter(name="networkInterfaceConfigurations")
    def network_interface_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceConfigurationArgs']]]]:
        """
        Specifies the networking configurations that will be used to create the virtual machine networking resources.
        """
        return pulumi.get(self, "network_interface_configurations")

    @network_interface_configurations.setter
    def network_interface_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceConfigurationArgs']]]]):
        pulumi.set(self, "network_interface_configurations", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceReferenceArgs']]]]:
        """
        Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceReferenceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)


@pulumi.input_type
class OSDiskArgs:
    def __init__(__self__, *,
                 create_option: pulumi.Input[Union[str, 'DiskCreateOptionTypes']],
                 caching: Optional[pulumi.Input['CachingTypes']] = None,
                 delete_option: Optional[pulumi.Input[Union[str, 'DiskDeleteOptionTypes']]] = None,
                 diff_disk_settings: Optional[pulumi.Input['DiffDiskSettingsArgs']] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 encryption_settings: Optional[pulumi.Input['DiskEncryptionSettingsArgs']] = None,
                 image: Optional[pulumi.Input['VirtualHardDiskArgs']] = None,
                 managed_disk: Optional[pulumi.Input['ManagedDiskParametersArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input['OperatingSystemTypes']] = None,
                 vhd: Optional[pulumi.Input['VirtualHardDiskArgs']] = None,
                 write_accelerator_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        :param pulumi.Input[Union[str, 'DiskCreateOptionTypes']] create_option: Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param pulumi.Input['CachingTypes'] caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None** for Standard storage. **ReadOnly** for Premium storage.
        :param pulumi.Input[Union[str, 'DiskDeleteOptionTypes']] delete_option: Specifies whether OS Disk should be deleted or detached upon VM deletion. <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VM is deleted.<br><br> **Detach** If this value is used, the os disk is retained after VM is deleted. <br><br> The default value is set to **detach**. For an ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for ephemeral OS Disk.
        :param pulumi.Input['DiffDiskSettingsArgs'] diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
        :param pulumi.Input[int] disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param pulumi.Input['DiskEncryptionSettingsArgs'] encryption_settings: Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        :param pulumi.Input['VirtualHardDiskArgs'] image: The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        :param pulumi.Input['ManagedDiskParametersArgs'] managed_disk: The managed disk parameters.
        :param pulumi.Input[str] name: The disk name.
        :param pulumi.Input['OperatingSystemTypes'] os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param pulumi.Input['VirtualHardDiskArgs'] vhd: The virtual hard disk.
        :param pulumi.Input[bool] write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if delete_option is not None:
            pulumi.set(__self__, "delete_option", delete_option)
        if diff_disk_settings is not None:
            pulumi.set(__self__, "diff_disk_settings", diff_disk_settings)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd is not None:
            pulumi.set(__self__, "vhd", vhd)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Input[Union[str, 'DiskCreateOptionTypes']]:
        """
        Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: pulumi.Input[Union[str, 'DiskCreateOptionTypes']]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input['CachingTypes']]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None** for Standard storage. **ReadOnly** for Premium storage.
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input['CachingTypes']]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="deleteOption")
    def delete_option(self) -> Optional[pulumi.Input[Union[str, 'DiskDeleteOptionTypes']]]:
        """
        Specifies whether OS Disk should be deleted or detached upon VM deletion. <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VM is deleted.<br><br> **Detach** If this value is used, the os disk is retained after VM is deleted. <br><br> The default value is set to **detach**. For an ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for ephemeral OS Disk.
        """
        return pulumi.get(self, "delete_option")

    @delete_option.setter
    def delete_option(self, value: Optional[pulumi.Input[Union[str, 'DiskDeleteOptionTypes']]]):
        pulumi.set(self, "delete_option", value)

    @property
    @pulumi.getter(name="diffDiskSettings")
    def diff_disk_settings(self) -> Optional[pulumi.Input['DiffDiskSettingsArgs']]:
        """
        Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
        """
        return pulumi.get(self, "diff_disk_settings")

    @diff_disk_settings.setter
    def diff_disk_settings(self, value: Optional[pulumi.Input['DiffDiskSettingsArgs']]):
        pulumi.set(self, "diff_disk_settings", value)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional[pulumi.Input['DiskEncryptionSettingsArgs']]:
        """
        Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        """
        return pulumi.get(self, "encryption_settings")

    @encryption_settings.setter
    def encryption_settings(self, value: Optional[pulumi.Input['DiskEncryptionSettingsArgs']]):
        pulumi.set(self, "encryption_settings", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['VirtualHardDiskArgs']]:
        """
        The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['VirtualHardDiskArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional[pulumi.Input['ManagedDiskParametersArgs']]:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @managed_disk.setter
    def managed_disk(self, value: Optional[pulumi.Input['ManagedDiskParametersArgs']]):
        pulumi.set(self, "managed_disk", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input['OperatingSystemTypes']]:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input['OperatingSystemTypes']]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def vhd(self) -> Optional[pulumi.Input['VirtualHardDiskArgs']]:
        """
        The virtual hard disk.
        """
        return pulumi.get(self, "vhd")

    @vhd.setter
    def vhd(self, value: Optional[pulumi.Input['VirtualHardDiskArgs']]):
        pulumi.set(self, "vhd", value)

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")

    @write_accelerator_enabled.setter
    def write_accelerator_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_accelerator_enabled", value)


@pulumi.input_type
class OSProfileArgs:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 allow_extension_operations: Optional[pulumi.Input[bool]] = None,
                 computer_name: Optional[pulumi.Input[str]] = None,
                 custom_data: Optional[pulumi.Input[str]] = None,
                 linux_configuration: Optional[pulumi.Input['LinuxConfigurationArgs']] = None,
                 require_guest_provision_signal: Optional[pulumi.Input[bool]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['VaultSecretGroupArgs']]]] = None,
                 windows_configuration: Optional[pulumi.Input['WindowsConfigurationArgs']] = None):
        """
        Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
        :param pulumi.Input[str] admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        :param pulumi.Input[str] admin_username: Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        :param pulumi.Input[bool] allow_extension_operations: Specifies whether extension operations should be allowed on the virtual machine. <br><br>This may only be set to False when no extensions are present on the virtual machine.
        :param pulumi.Input[str] computer_name: Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules).
        :param pulumi.Input[str] custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file, for more information see [Custom Data on Azure VMs](https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
        :param pulumi.Input['LinuxConfigurationArgs'] linux_configuration: Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        :param pulumi.Input[bool] require_guest_provision_signal: Specifies whether the guest provision signal is required to infer provision success of the virtual machine.  **Note: This property is for private testing only, and all customers must not set the property to false.**
        :param pulumi.Input[Sequence[pulumi.Input['VaultSecretGroupArgs']]] secrets: Specifies set of certificates that should be installed onto the virtual machine. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        :param pulumi.Input['WindowsConfigurationArgs'] windows_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if allow_extension_operations is not None:
            pulumi.set(__self__, "allow_extension_operations", allow_extension_operations)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if require_guest_provision_signal is not None:
            pulumi.set(__self__, "require_guest_provision_signal", require_guest_provision_signal)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="allowExtensionOperations")
    def allow_extension_operations(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether extension operations should be allowed on the virtual machine. <br><br>This may only be set to False when no extensions are present on the virtual machine.
        """
        return pulumi.get(self, "allow_extension_operations")

    @allow_extension_operations.setter
    def allow_extension_operations(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_extension_operations", value)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules).
        """
        return pulumi.get(self, "computer_name")

    @computer_name.setter
    def computer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "computer_name", value)

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file, for more information see [Custom Data on Azure VMs](https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_data", value)

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional[pulumi.Input['LinuxConfigurationArgs']]:
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        """
        return pulumi.get(self, "linux_configuration")

    @linux_configuration.setter
    def linux_configuration(self, value: Optional[pulumi.Input['LinuxConfigurationArgs']]):
        pulumi.set(self, "linux_configuration", value)

    @property
    @pulumi.getter(name="requireGuestProvisionSignal")
    def require_guest_provision_signal(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the guest provision signal is required to infer provision success of the virtual machine.  **Note: This property is for private testing only, and all customers must not set the property to false.**
        """
        return pulumi.get(self, "require_guest_provision_signal")

    @require_guest_provision_signal.setter
    def require_guest_provision_signal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_guest_provision_signal", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultSecretGroupArgs']]]]:
        """
        Specifies set of certificates that should be installed onto the virtual machine. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultSecretGroupArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional[pulumi.Input['WindowsConfigurationArgs']]:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "windows_configuration")

    @windows_configuration.setter
    def windows_configuration(self, value: Optional[pulumi.Input['WindowsConfigurationArgs']]):
        pulumi.set(self, "windows_configuration", value)


@pulumi.input_type
class PatchSettingsArgs:
    def __init__(__self__, *,
                 assessment_mode: Optional[pulumi.Input[Union[str, 'WindowsPatchAssessmentMode']]] = None,
                 enable_hotpatching: Optional[pulumi.Input[bool]] = None,
                 patch_mode: Optional[pulumi.Input[Union[str, 'WindowsVMGuestPatchMode']]] = None):
        """
        Specifies settings related to VM Guest Patching on Windows.
        :param pulumi.Input[Union[str, 'WindowsPatchAssessmentMode']] assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true. 
        :param pulumi.Input[bool] enable_hotpatching: Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
        :param pulumi.Input[Union[str, 'WindowsVMGuestPatchMode']] patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true 
        """
        if assessment_mode is not None:
            pulumi.set(__self__, "assessment_mode", assessment_mode)
        if enable_hotpatching is not None:
            pulumi.set(__self__, "enable_hotpatching", enable_hotpatching)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)

    @property
    @pulumi.getter(name="assessmentMode")
    def assessment_mode(self) -> Optional[pulumi.Input[Union[str, 'WindowsPatchAssessmentMode']]]:
        """
        Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true. 
        """
        return pulumi.get(self, "assessment_mode")

    @assessment_mode.setter
    def assessment_mode(self, value: Optional[pulumi.Input[Union[str, 'WindowsPatchAssessmentMode']]]):
        pulumi.set(self, "assessment_mode", value)

    @property
    @pulumi.getter(name="enableHotpatching")
    def enable_hotpatching(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
        """
        return pulumi.get(self, "enable_hotpatching")

    @enable_hotpatching.setter
    def enable_hotpatching(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_hotpatching", value)

    @property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[pulumi.Input[Union[str, 'WindowsVMGuestPatchMode']]]:
        """
        Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true 
        """
        return pulumi.get(self, "patch_mode")

    @patch_mode.setter
    def patch_mode(self, value: Optional[pulumi.Input[Union[str, 'WindowsVMGuestPatchMode']]]):
        pulumi.set(self, "patch_mode", value)


@pulumi.input_type
class PlanArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 product: Optional[pulumi.Input[str]] = None,
                 promotion_code: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None):
        """
        Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
        :param pulumi.Input[str] name: The plan ID.
        :param pulumi.Input[str] product: Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        :param pulumi.Input[str] promotion_code: The promotion code.
        :param pulumi.Input[str] publisher: The publisher ID.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[pulumi.Input[str]]:
        """
        The promotion code.
        """
        return pulumi.get(self, "promotion_code")

    @promotion_code.setter
    def promotion_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "promotion_code", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)


@pulumi.input_type
class PublicIPAddressSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'PublicIPAddressSkuName']]] = None,
                 tier: Optional[pulumi.Input[Union[str, 'PublicIPAddressSkuTier']]] = None):
        """
        Describes the public IP Sku
        :param pulumi.Input[Union[str, 'PublicIPAddressSkuName']] name: Specify public IP sku name
        :param pulumi.Input[Union[str, 'PublicIPAddressSkuTier']] tier: Specify public IP sku tier
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'PublicIPAddressSkuName']]]:
        """
        Specify public IP sku name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'PublicIPAddressSkuName']]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[Union[str, 'PublicIPAddressSkuTier']]]:
        """
        Specify public IP sku tier
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[Union[str, 'PublicIPAddressSkuTier']]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class RestorePointCollectionSourcePropertiesArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The properties of the source resource that this restore point collection is created from.
        :param pulumi.Input[str] id: Resource Id of the source resource used to create this restore point collection
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id of the source resource used to create this restore point collection
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class RollingUpgradePolicyArgs:
    def __init__(__self__, *,
                 enable_cross_zone_upgrade: Optional[pulumi.Input[bool]] = None,
                 max_batch_instance_percent: Optional[pulumi.Input[int]] = None,
                 max_unhealthy_instance_percent: Optional[pulumi.Input[int]] = None,
                 max_unhealthy_upgraded_instance_percent: Optional[pulumi.Input[int]] = None,
                 pause_time_between_batches: Optional[pulumi.Input[str]] = None,
                 prioritize_unhealthy_instances: Optional[pulumi.Input[bool]] = None):
        """
        The configuration parameters used while performing a rolling upgrade.
        :param pulumi.Input[bool] enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size.
        :param pulumi.Input[int] max_batch_instance_percent: The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        :param pulumi.Input[int] max_unhealthy_instance_percent: The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
        :param pulumi.Input[int] max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
        :param pulumi.Input[str] pause_time_between_batches: The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        :param pulumi.Input[bool] prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before any healthy instances.
        """
        if enable_cross_zone_upgrade is not None:
            pulumi.set(__self__, "enable_cross_zone_upgrade", enable_cross_zone_upgrade)
        if max_batch_instance_percent is not None:
            pulumi.set(__self__, "max_batch_instance_percent", max_batch_instance_percent)
        if max_unhealthy_instance_percent is not None:
            pulumi.set(__self__, "max_unhealthy_instance_percent", max_unhealthy_instance_percent)
        if max_unhealthy_upgraded_instance_percent is not None:
            pulumi.set(__self__, "max_unhealthy_upgraded_instance_percent", max_unhealthy_upgraded_instance_percent)
        if pause_time_between_batches is not None:
            pulumi.set(__self__, "pause_time_between_batches", pause_time_between_batches)
        if prioritize_unhealthy_instances is not None:
            pulumi.set(__self__, "prioritize_unhealthy_instances", prioritize_unhealthy_instances)

    @property
    @pulumi.getter(name="enableCrossZoneUpgrade")
    def enable_cross_zone_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size.
        """
        return pulumi.get(self, "enable_cross_zone_upgrade")

    @enable_cross_zone_upgrade.setter
    def enable_cross_zone_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cross_zone_upgrade", value)

    @property
    @pulumi.getter(name="maxBatchInstancePercent")
    def max_batch_instance_percent(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        """
        return pulumi.get(self, "max_batch_instance_percent")

    @max_batch_instance_percent.setter
    def max_batch_instance_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_batch_instance_percent", value)

    @property
    @pulumi.getter(name="maxUnhealthyInstancePercent")
    def max_unhealthy_instance_percent(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
        """
        return pulumi.get(self, "max_unhealthy_instance_percent")

    @max_unhealthy_instance_percent.setter
    def max_unhealthy_instance_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_unhealthy_instance_percent", value)

    @property
    @pulumi.getter(name="maxUnhealthyUpgradedInstancePercent")
    def max_unhealthy_upgraded_instance_percent(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
        """
        return pulumi.get(self, "max_unhealthy_upgraded_instance_percent")

    @max_unhealthy_upgraded_instance_percent.setter
    def max_unhealthy_upgraded_instance_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_unhealthy_upgraded_instance_percent", value)

    @property
    @pulumi.getter(name="pauseTimeBetweenBatches")
    def pause_time_between_batches(self) -> Optional[pulumi.Input[str]]:
        """
        The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        """
        return pulumi.get(self, "pause_time_between_batches")

    @pause_time_between_batches.setter
    def pause_time_between_batches(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pause_time_between_batches", value)

    @property
    @pulumi.getter(name="prioritizeUnhealthyInstances")
    def prioritize_unhealthy_instances(self) -> Optional[pulumi.Input[bool]]:
        """
        Upgrade all unhealthy instances in a scale set before any healthy instances.
        """
        return pulumi.get(self, "prioritize_unhealthy_instances")

    @prioritize_unhealthy_instances.setter
    def prioritize_unhealthy_instances(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prioritize_unhealthy_instances", value)


@pulumi.input_type
class RunCommandInputParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Describes the properties of a run command parameter.
        :param pulumi.Input[str] name: The run command parameter name.
        :param pulumi.Input[str] value: The run command parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The run command parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The run command parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ScaleInPolicyArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'VirtualMachineScaleSetScaleInRules']]]]] = None):
        """
        Describes a scale-in policy for a virtual machine scale set.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'VirtualMachineScaleSetScaleInRules']]]] rules: The rules to be followed when scaling-in a virtual machine scale set. <br><br> Possible values are: <br><br> **Default** When a virtual machine scale set is scaled in, the scale set will first be balanced across zones if it is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not protected from scale-in. <br><br> **OldestVM** When a virtual machine scale set is being scaled-in, the oldest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the oldest virtual machines that are not protected will be chosen for removal. <br><br> **NewestVM** When a virtual machine scale set is being scaled-in, the newest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the newest virtual machines that are not protected will be chosen for removal. <br><br>
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'VirtualMachineScaleSetScaleInRules']]]]]:
        """
        The rules to be followed when scaling-in a virtual machine scale set. <br><br> Possible values are: <br><br> **Default** When a virtual machine scale set is scaled in, the scale set will first be balanced across zones if it is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not protected from scale-in. <br><br> **OldestVM** When a virtual machine scale set is being scaled-in, the oldest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the oldest virtual machines that are not protected will be chosen for removal. <br><br> **NewestVM** When a virtual machine scale set is being scaled-in, the newest virtual machines that are not protected from scale-in will be chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced across zones. Within each zone, the newest virtual machines that are not protected will be chosen for removal. <br><br>
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'VirtualMachineScaleSetScaleInRules']]]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class ScheduledEventsProfileArgs:
    def __init__(__self__, *,
                 terminate_notification_profile: Optional[pulumi.Input['TerminateNotificationProfileArgs']] = None):
        """
        :param pulumi.Input['TerminateNotificationProfileArgs'] terminate_notification_profile: Specifies Terminate Scheduled Event related configurations.
        """
        if terminate_notification_profile is not None:
            pulumi.set(__self__, "terminate_notification_profile", terminate_notification_profile)

    @property
    @pulumi.getter(name="terminateNotificationProfile")
    def terminate_notification_profile(self) -> Optional[pulumi.Input['TerminateNotificationProfileArgs']]:
        """
        Specifies Terminate Scheduled Event related configurations.
        """
        return pulumi.get(self, "terminate_notification_profile")

    @terminate_notification_profile.setter
    def terminate_notification_profile(self, value: Optional[pulumi.Input['TerminateNotificationProfileArgs']]):
        pulumi.set(self, "terminate_notification_profile", value)


@pulumi.input_type
class SecurityProfileArgs:
    def __init__(__self__, *,
                 encryption_at_host: Optional[pulumi.Input[bool]] = None,
                 security_type: Optional[pulumi.Input[Union[str, 'SecurityTypes']]] = None,
                 uefi_settings: Optional[pulumi.Input['UefiSettingsArgs']] = None):
        """
        Specifies the Security profile settings for the virtual machine or virtual machine scale set.
        :param pulumi.Input[bool] encryption_at_host: This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. <br><br> Default: The Encryption at host will be disabled unless this property is set to true for the resource.
        :param pulumi.Input[Union[str, 'SecurityTypes']] security_type: Specifies the SecurityType of the virtual machine. It is set as TrustedLaunch to enable UefiSettings. <br><br> Default: UefiSettings will not be enabled unless this property is set as TrustedLaunch.
        :param pulumi.Input['UefiSettingsArgs'] uefi_settings: Specifies the security settings like secure boot and vTPM used while creating the virtual machine. <br><br>Minimum api-version: 2020-12-01
        """
        if encryption_at_host is not None:
            pulumi.set(__self__, "encryption_at_host", encryption_at_host)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)
        if uefi_settings is not None:
            pulumi.set(__self__, "uefi_settings", uefi_settings)

    @property
    @pulumi.getter(name="encryptionAtHost")
    def encryption_at_host(self) -> Optional[pulumi.Input[bool]]:
        """
        This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. <br><br> Default: The Encryption at host will be disabled unless this property is set to true for the resource.
        """
        return pulumi.get(self, "encryption_at_host")

    @encryption_at_host.setter
    def encryption_at_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_at_host", value)

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[pulumi.Input[Union[str, 'SecurityTypes']]]:
        """
        Specifies the SecurityType of the virtual machine. It is set as TrustedLaunch to enable UefiSettings. <br><br> Default: UefiSettings will not be enabled unless this property is set as TrustedLaunch.
        """
        return pulumi.get(self, "security_type")

    @security_type.setter
    def security_type(self, value: Optional[pulumi.Input[Union[str, 'SecurityTypes']]]):
        pulumi.set(self, "security_type", value)

    @property
    @pulumi.getter(name="uefiSettings")
    def uefi_settings(self) -> Optional[pulumi.Input['UefiSettingsArgs']]:
        """
        Specifies the security settings like secure boot and vTPM used while creating the virtual machine. <br><br>Minimum api-version: 2020-12-01
        """
        return pulumi.get(self, "uefi_settings")

    @uefi_settings.setter
    def uefi_settings(self, value: Optional[pulumi.Input['UefiSettingsArgs']]):
        pulumi.set(self, "uefi_settings", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.
        :param pulumi.Input[float] capacity: Specifies the number of virtual machines in the scale set.
        :param pulumi.Input[str] name: The sku name.
        :param pulumi.Input[str] tier: Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the number of virtual machines in the scale set.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SshConfigurationArgs:
    def __init__(__self__, *,
                 public_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]] = None):
        """
        SSH configuration for Linux based VMs running on Azure
        :param pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]] public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]:
        """
        The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class SshPublicKeyArgs:
    def __init__(__self__, *,
                 key_data: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
        :param pulumi.Input[str] key_data: SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        :param pulumi.Input[str] path: Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_data", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class StorageProfileArgs:
    def __init__(__self__, *,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]]] = None,
                 image_reference: Optional[pulumi.Input['ImageReferenceArgs']] = None,
                 os_disk: Optional[pulumi.Input['OSDiskArgs']] = None):
        """
        Specifies the storage settings for the virtual machine disks.
        :param pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]] data_disks: Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        :param pulumi.Input['ImageReferenceArgs'] image_reference: Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        :param pulumi.Input['OSDiskArgs'] os_disk: Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]]]:
        """
        Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional[pulumi.Input['ImageReferenceArgs']]:
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        """
        return pulumi.get(self, "image_reference")

    @image_reference.setter
    def image_reference(self, value: Optional[pulumi.Input['ImageReferenceArgs']]):
        pulumi.set(self, "image_reference", value)

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional[pulumi.Input['OSDiskArgs']]:
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: Optional[pulumi.Input['OSDiskArgs']]):
        pulumi.set(self, "os_disk", value)


@pulumi.input_type
class SubResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class TerminateNotificationProfileArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None,
                 not_before_timeout: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
        :param pulumi.Input[str] not_before_timeout: Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if not_before_timeout is not None:
            pulumi.set(__self__, "not_before_timeout", not_before_timeout)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the Terminate Scheduled event is enabled or disabled.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="notBeforeTimeout")
    def not_before_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)
        """
        return pulumi.get(self, "not_before_timeout")

    @not_before_timeout.setter
    def not_before_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "not_before_timeout", value)


@pulumi.input_type
class UefiSettingsArgs:
    def __init__(__self__, *,
                 secure_boot_enabled: Optional[pulumi.Input[bool]] = None,
                 v_tpm_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Specifies the security settings like secure boot and vTPM used while creating the virtual machine. <br><br>Minimum api-version: 2020-12-01
        :param pulumi.Input[bool] secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual machine. <br><br>Minimum api-version: 2020-12-01
        :param pulumi.Input[bool] v_tpm_enabled: Specifies whether vTPM should be enabled on the virtual machine. <br><br>Minimum api-version: 2020-12-01
        """
        if secure_boot_enabled is not None:
            pulumi.set(__self__, "secure_boot_enabled", secure_boot_enabled)
        if v_tpm_enabled is not None:
            pulumi.set(__self__, "v_tpm_enabled", v_tpm_enabled)

    @property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether secure boot should be enabled on the virtual machine. <br><br>Minimum api-version: 2020-12-01
        """
        return pulumi.get(self, "secure_boot_enabled")

    @secure_boot_enabled.setter
    def secure_boot_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "secure_boot_enabled", value)

    @property
    @pulumi.getter(name="vTpmEnabled")
    def v_tpm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether vTPM should be enabled on the virtual machine. <br><br>Minimum api-version: 2020-12-01
        """
        return pulumi.get(self, "v_tpm_enabled")

    @v_tpm_enabled.setter
    def v_tpm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "v_tpm_enabled", value)


@pulumi.input_type
class UpgradePolicyArgs:
    def __init__(__self__, *,
                 automatic_os_upgrade_policy: Optional[pulumi.Input['AutomaticOSUpgradePolicyArgs']] = None,
                 mode: Optional[pulumi.Input['UpgradeMode']] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input['RollingUpgradePolicyArgs']] = None):
        """
        Describes an upgrade policy - automatic, manual, or rolling.
        :param pulumi.Input['AutomaticOSUpgradePolicyArgs'] automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS Upgrade.
        :param pulumi.Input['UpgradeMode'] mode: Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
        :param pulumi.Input['RollingUpgradePolicyArgs'] rolling_upgrade_policy: The configuration parameters used while performing a rolling upgrade.
        """
        if automatic_os_upgrade_policy is not None:
            pulumi.set(__self__, "automatic_os_upgrade_policy", automatic_os_upgrade_policy)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)

    @property
    @pulumi.getter(name="automaticOSUpgradePolicy")
    def automatic_os_upgrade_policy(self) -> Optional[pulumi.Input['AutomaticOSUpgradePolicyArgs']]:
        """
        Configuration parameters used for performing automatic OS Upgrade.
        """
        return pulumi.get(self, "automatic_os_upgrade_policy")

    @automatic_os_upgrade_policy.setter
    def automatic_os_upgrade_policy(self, value: Optional[pulumi.Input['AutomaticOSUpgradePolicyArgs']]):
        pulumi.set(self, "automatic_os_upgrade_policy", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['UpgradeMode']]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['UpgradeMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional[pulumi.Input['RollingUpgradePolicyArgs']]:
        """
        The configuration parameters used while performing a rolling upgrade.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @rolling_upgrade_policy.setter
    def rolling_upgrade_policy(self, value: Optional[pulumi.Input['RollingUpgradePolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_policy", value)


@pulumi.input_type
class VaultCertificateArgs:
    def __init__(__self__, *,
                 certificate_store: Optional[pulumi.Input[str]] = None,
                 certificate_url: Optional[pulumi.Input[str]] = None):
        """
        Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
        :param pulumi.Input[str] certificate_store: For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
        :param pulumi.Input[str] certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br> "data":"<Base64-encoded-certificate>",<br> "dataType":"pfx",<br> "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        """
        if certificate_store is not None:
            pulumi.set(__self__, "certificate_store", certificate_store)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @property
    @pulumi.getter(name="certificateStore")
    def certificate_store(self) -> Optional[pulumi.Input[str]]:
        """
        For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
        """
        return pulumi.get(self, "certificate_store")

    @certificate_store.setter
    def certificate_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_store", value)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[pulumi.Input[str]]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br> "data":"<Base64-encoded-certificate>",<br> "dataType":"pfx",<br> "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        """
        return pulumi.get(self, "certificate_url")

    @certificate_url.setter
    def certificate_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_url", value)


@pulumi.input_type
class VaultSecretGroupArgs:
    def __init__(__self__, *,
                 source_vault: Optional[pulumi.Input['SubResourceArgs']] = None,
                 vault_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]]] = None):
        """
        Describes a set of certificates which are all in the same Key Vault.
        :param pulumi.Input['SubResourceArgs'] source_vault: The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        :param pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]] vault_certificates: The list of key vault references in SourceVault which contain certificates.
        """
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)
        if vault_certificates is not None:
            pulumi.set(__self__, "vault_certificates", vault_certificates)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "source_vault", value)

    @property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]]]:
        """
        The list of key vault references in SourceVault which contain certificates.
        """
        return pulumi.get(self, "vault_certificates")

    @vault_certificates.setter
    def vault_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]]]):
        pulumi.set(self, "vault_certificates", value)


@pulumi.input_type
class VirtualHardDiskArgs:
    def __init__(__self__, *,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Describes the uri of a disk.
        :param pulumi.Input[str] uri: Specifies the virtual hard disk's uri.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the virtual hard disk's uri.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class VirtualMachineExtensionInstanceViewArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceViewStatusArgs']]]] = None,
                 substatuses: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceViewStatusArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 type_handler_version: Optional[pulumi.Input[str]] = None):
        """
        The instance view of a virtual machine extension.
        :param pulumi.Input[str] name: The virtual machine extension name.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceViewStatusArgs']]] statuses: The resource status information.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceViewStatusArgs']]] substatuses: The resource status information.
        :param pulumi.Input[str] type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param pulumi.Input[str] type_handler_version: Specifies the version of the script handler.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if substatuses is not None:
            pulumi.set(__self__, "substatuses", substatuses)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual machine extension name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceViewStatusArgs']]]]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceViewStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def substatuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceViewStatusArgs']]]]:
        """
        The resource status information.
        """
        return pulumi.get(self, "substatuses")

    @substatuses.setter
    def substatuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceViewStatusArgs']]]]):
        pulumi.set(self, "substatuses", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_handler_version", value)


@pulumi.input_type
class VirtualMachineIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the virtual machine.
        :param pulumi.Input['ResourceIdentityType'] type: The type of identity used for the virtual machine. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user identities associated with the Virtual Machine. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The type of identity used for the virtual machine. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user identities associated with the Virtual Machine. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class VirtualMachineIpTagArgs:
    def __init__(__self__, *,
                 ip_tag_type: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        Contains the IP tag associated with the public IP address.
        :param pulumi.Input[str] ip_tag_type: IP tag type. Example: FirstPartyUsage.
        :param pulumi.Input[str] tag: IP tag associated with the public IP. Example: SQL, Storage etc.
        """
        if ip_tag_type is not None:
            pulumi.set(__self__, "ip_tag_type", ip_tag_type)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="ipTagType")
    def ip_tag_type(self) -> Optional[pulumi.Input[str]]:
        """
        IP tag type. Example: FirstPartyUsage.
        """
        return pulumi.get(self, "ip_tag_type")

    @ip_tag_type.setter
    def ip_tag_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_tag_type", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        IP tag associated with the public IP. Example: SQL, Storage etc.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class VirtualMachineNetworkInterfaceConfigurationArgs:
    def __init__(__self__, *,
                 ip_configurations: pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceIPConfigurationArgs']]],
                 name: pulumi.Input[str],
                 delete_option: Optional[pulumi.Input[Union[str, 'DeleteOptions']]] = None,
                 dns_settings: Optional[pulumi.Input['VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs']] = None,
                 dscp_configuration: Optional[pulumi.Input['SubResourceArgs']] = None,
                 enable_accelerated_networking: Optional[pulumi.Input[bool]] = None,
                 enable_fpga: Optional[pulumi.Input[bool]] = None,
                 enable_ip_forwarding: Optional[pulumi.Input[bool]] = None,
                 network_security_group: Optional[pulumi.Input['SubResourceArgs']] = None,
                 primary: Optional[pulumi.Input[bool]] = None):
        """
        Describes a virtual machine network interface configurations.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceIPConfigurationArgs']]] ip_configurations: Specifies the IP configurations of the network interface.
        :param pulumi.Input[str] name: The network interface configuration name.
        :param pulumi.Input[Union[str, 'DeleteOptions']] delete_option: Specify what happens to the network interface when the VM is deleted
        :param pulumi.Input['VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs'] dns_settings: The dns settings to be applied on the network interfaces.
        :param pulumi.Input[bool] enable_accelerated_networking: Specifies whether the network interface is accelerated networking-enabled.
        :param pulumi.Input[bool] enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
        :param pulumi.Input[bool] enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :param pulumi.Input['SubResourceArgs'] network_security_group: The network security group.
        :param pulumi.Input[bool] primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        if delete_option is not None:
            pulumi.set(__self__, "delete_option", delete_option)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if dscp_configuration is not None:
            pulumi.set(__self__, "dscp_configuration", dscp_configuration)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_fpga is not None:
            pulumi.set(__self__, "enable_fpga", enable_fpga)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceIPConfigurationArgs']]]:
        """
        Specifies the IP configurations of the network interface.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceIPConfigurationArgs']]]):
        pulumi.set(self, "ip_configurations", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The network interface configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="deleteOption")
    def delete_option(self) -> Optional[pulumi.Input[Union[str, 'DeleteOptions']]]:
        """
        Specify what happens to the network interface when the VM is deleted
        """
        return pulumi.get(self, "delete_option")

    @delete_option.setter
    def delete_option(self, value: Optional[pulumi.Input[Union[str, 'DeleteOptions']]]):
        pulumi.set(self, "delete_option", value)

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs']]:
        """
        The dns settings to be applied on the network interfaces.
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs']]):
        pulumi.set(self, "dns_settings", value)

    @property
    @pulumi.getter(name="dscpConfiguration")
    def dscp_configuration(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        return pulumi.get(self, "dscp_configuration")

    @dscp_configuration.setter
    def dscp_configuration(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "dscp_configuration", value)

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the network interface is accelerated networking-enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @enable_accelerated_networking.setter
    def enable_accelerated_networking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_accelerated_networking", value)

    @property
    @pulumi.getter(name="enableFpga")
    def enable_fpga(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the network interface is FPGA networking-enabled.
        """
        return pulumi.get(self, "enable_fpga")

    @enable_fpga.setter
    def enable_fpga(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_fpga", value)

    @property
    @pulumi.getter(name="enableIPForwarding")
    def enable_ip_forwarding(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether IP forwarding enabled on this NIC.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @enable_ip_forwarding.setter
    def enable_ip_forwarding(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ip_forwarding", value)

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The network security group.
        """
        return pulumi.get(self, "network_security_group")

    @network_security_group.setter
    def network_security_group(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "network_security_group", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)


@pulumi.input_type
class VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs:
    def __init__(__self__, *,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Describes a virtual machines network configuration's DNS settings.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: List of DNS servers IP addresses
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of DNS servers IP addresses
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)


@pulumi.input_type
class VirtualMachineNetworkInterfaceIPConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 application_gateway_backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 application_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 load_balancer_backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 primary: Optional[pulumi.Input[bool]] = None,
                 private_ip_address_version: Optional[pulumi.Input[Union[str, 'IPVersions']]] = None,
                 public_ip_address_configuration: Optional[pulumi.Input['VirtualMachinePublicIPAddressConfigurationArgs']] = None,
                 subnet: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Describes a virtual machine network profile's IP configuration.
        :param pulumi.Input[str] name: The IP configuration name.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] application_gateway_backend_address_pools: Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] application_security_groups: Specifies an array of references to application security group.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] load_balancer_backend_address_pools: Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
        :param pulumi.Input[bool] primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        :param pulumi.Input[Union[str, 'IPVersions']] private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        :param pulumi.Input['VirtualMachinePublicIPAddressConfigurationArgs'] public_ip_address_configuration: The publicIPAddressConfiguration.
        :param pulumi.Input['SubResourceArgs'] subnet: Specifies the identifier of the subnet.
        """
        pulumi.set(__self__, "name", name)
        if application_gateway_backend_address_pools is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pools", application_gateway_backend_address_pools)
        if application_security_groups is not None:
            pulumi.set(__self__, "application_security_groups", application_security_groups)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if public_ip_address_configuration is not None:
            pulumi.set(__self__, "public_ip_address_configuration", public_ip_address_configuration)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The IP configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="applicationGatewayBackendAddressPools")
    def application_gateway_backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
        """
        return pulumi.get(self, "application_gateway_backend_address_pools")

    @application_gateway_backend_address_pools.setter
    def application_gateway_backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "application_gateway_backend_address_pools", value)

    @property
    @pulumi.getter(name="applicationSecurityGroups")
    def application_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Specifies an array of references to application security group.
        """
        return pulumi.get(self, "application_security_groups")

    @application_security_groups.setter
    def application_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "application_security_groups", value)

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @load_balancer_backend_address_pools.setter
    def load_balancer_backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "load_balancer_backend_address_pools", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[pulumi.Input[Union[str, 'IPVersions']]]:
        """
        Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "private_ip_address_version")

    @private_ip_address_version.setter
    def private_ip_address_version(self, value: Optional[pulumi.Input[Union[str, 'IPVersions']]]):
        pulumi.set(self, "private_ip_address_version", value)

    @property
    @pulumi.getter(name="publicIPAddressConfiguration")
    def public_ip_address_configuration(self) -> Optional[pulumi.Input['VirtualMachinePublicIPAddressConfigurationArgs']]:
        """
        The publicIPAddressConfiguration.
        """
        return pulumi.get(self, "public_ip_address_configuration")

    @public_ip_address_configuration.setter
    def public_ip_address_configuration(self, value: Optional[pulumi.Input['VirtualMachinePublicIPAddressConfigurationArgs']]):
        pulumi.set(self, "public_ip_address_configuration", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Specifies the identifier of the subnet.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class VirtualMachinePublicIPAddressConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 delete_option: Optional[pulumi.Input[Union[str, 'DeleteOptions']]] = None,
                 dns_settings: Optional[pulumi.Input['VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs']] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 ip_tags: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineIpTagArgs']]]] = None,
                 public_ip_address_version: Optional[pulumi.Input[Union[str, 'IPVersions']]] = None,
                 public_ip_allocation_method: Optional[pulumi.Input[Union[str, 'PublicIPAllocationMethod']]] = None,
                 public_ip_prefix: Optional[pulumi.Input['SubResourceArgs']] = None,
                 sku: Optional[pulumi.Input['PublicIPAddressSkuArgs']] = None):
        """
        Describes a virtual machines IP Configuration's PublicIPAddress configuration
        :param pulumi.Input[str] name: The publicIP address configuration name.
        :param pulumi.Input[Union[str, 'DeleteOptions']] delete_option: Specify what happens to the public IP address when the VM is deleted
        :param pulumi.Input['VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs'] dns_settings: The dns settings to be applied on the publicIP addresses .
        :param pulumi.Input[int] idle_timeout_in_minutes: The idle timeout of the public IP address.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineIpTagArgs']]] ip_tags: The list of IP tags associated with the public IP address.
        :param pulumi.Input[Union[str, 'IPVersions']] public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
        :param pulumi.Input[Union[str, 'PublicIPAllocationMethod']] public_ip_allocation_method: Specify the public IP allocation type
        :param pulumi.Input['SubResourceArgs'] public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
        :param pulumi.Input['PublicIPAddressSkuArgs'] sku: Describes the public IP Sku
        """
        pulumi.set(__self__, "name", name)
        if delete_option is not None:
            pulumi.set(__self__, "delete_option", delete_option)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if public_ip_address_version is not None:
            pulumi.set(__self__, "public_ip_address_version", public_ip_address_version)
        if public_ip_allocation_method is not None:
            pulumi.set(__self__, "public_ip_allocation_method", public_ip_allocation_method)
        if public_ip_prefix is not None:
            pulumi.set(__self__, "public_ip_prefix", public_ip_prefix)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The publicIP address configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="deleteOption")
    def delete_option(self) -> Optional[pulumi.Input[Union[str, 'DeleteOptions']]]:
        """
        Specify what happens to the public IP address when the VM is deleted
        """
        return pulumi.get(self, "delete_option")

    @delete_option.setter
    def delete_option(self, value: Optional[pulumi.Input[Union[str, 'DeleteOptions']]]):
        pulumi.set(self, "delete_option", value)

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs']]:
        """
        The dns settings to be applied on the publicIP addresses .
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs']]):
        pulumi.set(self, "dns_settings", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The idle timeout of the public IP address.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineIpTagArgs']]]]:
        """
        The list of IP tags associated with the public IP address.
        """
        return pulumi.get(self, "ip_tags")

    @ip_tags.setter
    def ip_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineIpTagArgs']]]]):
        pulumi.set(self, "ip_tags", value)

    @property
    @pulumi.getter(name="publicIPAddressVersion")
    def public_ip_address_version(self) -> Optional[pulumi.Input[Union[str, 'IPVersions']]]:
        """
        Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "public_ip_address_version")

    @public_ip_address_version.setter
    def public_ip_address_version(self, value: Optional[pulumi.Input[Union[str, 'IPVersions']]]):
        pulumi.set(self, "public_ip_address_version", value)

    @property
    @pulumi.getter(name="publicIPAllocationMethod")
    def public_ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'PublicIPAllocationMethod']]]:
        """
        Specify the public IP allocation type
        """
        return pulumi.get(self, "public_ip_allocation_method")

    @public_ip_allocation_method.setter
    def public_ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'PublicIPAllocationMethod']]]):
        pulumi.set(self, "public_ip_allocation_method", value)

    @property
    @pulumi.getter(name="publicIPPrefix")
    def public_ip_prefix(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The PublicIPPrefix from which to allocate publicIP addresses.
        """
        return pulumi.get(self, "public_ip_prefix")

    @public_ip_prefix.setter
    def public_ip_prefix(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "public_ip_prefix", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['PublicIPAddressSkuArgs']]:
        """
        Describes the public IP Sku
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['PublicIPAddressSkuArgs']]):
        pulumi.set(self, "sku", value)


@pulumi.input_type
class VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs:
    def __init__(__self__, *,
                 domain_name_label: pulumi.Input[str]):
        """
        Describes a virtual machines network configuration's DNS settings.
        :param pulumi.Input[str] domain_name_label: The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.
        """
        pulumi.set(__self__, "domain_name_label", domain_name_label)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> pulumi.Input[str]:
        """
        The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.
        """
        return pulumi.get(self, "domain_name_label")

    @domain_name_label.setter
    def domain_name_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name_label", value)


@pulumi.input_type
class VirtualMachineRunCommandScriptSourceArgs:
    def __init__(__self__, *,
                 command_id: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 script_uri: Optional[pulumi.Input[str]] = None):
        """
        Describes the script sources for run command.
        :param pulumi.Input[str] command_id: Specifies a commandId of predefined built-in script.
        :param pulumi.Input[str] script: Specifies the script content to be executed on the VM.
        :param pulumi.Input[str] script_uri: Specifies the script download location.
        """
        if command_id is not None:
            pulumi.set(__self__, "command_id", command_id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if script_uri is not None:
            pulumi.set(__self__, "script_uri", script_uri)

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a commandId of predefined built-in script.
        """
        return pulumi.get(self, "command_id")

    @command_id.setter
    def command_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "command_id", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script content to be executed on the VM.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="scriptUri")
    def script_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script download location.
        """
        return pulumi.get(self, "script_uri")

    @script_uri.setter
    def script_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_uri", value)


@pulumi.input_type
class VirtualMachineScaleSetDataDiskArgs:
    def __init__(__self__, *,
                 create_option: pulumi.Input[Union[str, 'DiskCreateOptionTypes']],
                 lun: pulumi.Input[int],
                 caching: Optional[pulumi.Input['CachingTypes']] = None,
                 disk_iops_read_write: Optional[pulumi.Input[float]] = None,
                 disk_m_bps_read_write: Optional[pulumi.Input[float]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 managed_disk: Optional[pulumi.Input['VirtualMachineScaleSetManagedDiskParametersArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 write_accelerator_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Describes a virtual machine scale set data disk.
        :param pulumi.Input[Union[str, 'DiskCreateOptionTypes']] create_option: The create option.
        :param pulumi.Input[int] lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param pulumi.Input['CachingTypes'] caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param pulumi.Input[float] disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
        :param pulumi.Input[float] disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
        :param pulumi.Input[int] disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param pulumi.Input['VirtualMachineScaleSetManagedDiskParametersArgs'] managed_disk: The managed disk parameters.
        :param pulumi.Input[str] name: The disk name.
        :param pulumi.Input[bool] write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_iops_read_write is not None:
            pulumi.set(__self__, "disk_iops_read_write", disk_iops_read_write)
        if disk_m_bps_read_write is not None:
            pulumi.set(__self__, "disk_m_bps_read_write", disk_m_bps_read_write)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Input[Union[str, 'DiskCreateOptionTypes']]:
        """
        The create option.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: pulumi.Input[Union[str, 'DiskCreateOptionTypes']]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input['CachingTypes']]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input['CachingTypes']]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="diskIOPSReadWrite")
    def disk_iops_read_write(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
        """
        return pulumi.get(self, "disk_iops_read_write")

    @disk_iops_read_write.setter
    def disk_iops_read_write(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "disk_iops_read_write", value)

    @property
    @pulumi.getter(name="diskMBpsReadWrite")
    def disk_m_bps_read_write(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
        """
        return pulumi.get(self, "disk_m_bps_read_write")

    @disk_m_bps_read_write.setter
    def disk_m_bps_read_write(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "disk_m_bps_read_write", value)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional[pulumi.Input['VirtualMachineScaleSetManagedDiskParametersArgs']]:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @managed_disk.setter
    def managed_disk(self, value: Optional[pulumi.Input['VirtualMachineScaleSetManagedDiskParametersArgs']]):
        pulumi.set(self, "managed_disk", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")

    @write_accelerator_enabled.setter
    def write_accelerator_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_accelerator_enabled", value)


@pulumi.input_type
class VirtualMachineScaleSetExtensionArgs:
    def __init__(__self__, *,
                 auto_upgrade_minor_version: Optional[pulumi.Input[bool]] = None,
                 enable_automatic_upgrade: Optional[pulumi.Input[bool]] = None,
                 force_update_tag: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protected_settings: Optional[Any] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 settings: Optional[Any] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 type_handler_version: Optional[pulumi.Input[str]] = None):
        """
        Describes a Virtual Machine Scale Set Extension.
        :param pulumi.Input[bool] auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param pulumi.Input[bool] enable_automatic_upgrade: Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
        :param pulumi.Input[str] force_update_tag: If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        :param pulumi.Input[str] name: The name of the extension.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] provision_after_extensions: Collection of extension names after which this extension needs to be provisioned.
        :param pulumi.Input[str] publisher: The name of the extension handler publisher.
        :param Any settings: Json formatted public settings for the extension.
        :param pulumi.Input[str] type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param pulumi.Input[str] type_handler_version: Specifies the version of the script handler.
        """
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if enable_automatic_upgrade is not None:
            pulumi.set(__self__, "enable_automatic_upgrade", enable_automatic_upgrade)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @property
    @pulumi.getter(name="enableAutomaticUpgrade")
    def enable_automatic_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
        """
        return pulumi.get(self, "enable_automatic_upgrade")

    @enable_automatic_upgrade.setter
    def enable_automatic_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_upgrade", value)

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[pulumi.Input[str]]:
        """
        If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @force_update_tag.setter
    def force_update_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_update_tag", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[Any]):
        pulumi.set(self, "protected_settings", value)

    @property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @provision_after_extensions.setter
    def provision_after_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "provision_after_extensions", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[Any]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_handler_version", value)


@pulumi.input_type
class VirtualMachineScaleSetExtensionProfileArgs:
    def __init__(__self__, *,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetExtensionArgs']]]] = None,
                 extensions_time_budget: Optional[pulumi.Input[str]] = None):
        """
        Describes a virtual machine scale set extension profile.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetExtensionArgs']]] extensions: The virtual machine scale set child extension resources.
        :param pulumi.Input[str] extensions_time_budget: Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). <br><br> Minimum api-version: 2020-06-01
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if extensions_time_budget is not None:
            pulumi.set(__self__, "extensions_time_budget", extensions_time_budget)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetExtensionArgs']]]]:
        """
        The virtual machine scale set child extension resources.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). <br><br> Minimum api-version: 2020-06-01
        """
        return pulumi.get(self, "extensions_time_budget")

    @extensions_time_budget.setter
    def extensions_time_budget(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extensions_time_budget", value)


@pulumi.input_type
class VirtualMachineScaleSetIPConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 application_gateway_backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 application_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 load_balancer_backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 load_balancer_inbound_nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 primary: Optional[pulumi.Input[bool]] = None,
                 private_ip_address_version: Optional[pulumi.Input[Union[str, 'IPVersion']]] = None,
                 public_ip_address_configuration: Optional[pulumi.Input['VirtualMachineScaleSetPublicIPAddressConfigurationArgs']] = None,
                 subnet: Optional[pulumi.Input['ApiEntityReferenceArgs']] = None):
        """
        Describes a virtual machine scale set network profile's IP configuration.
        :param pulumi.Input[str] name: The IP configuration name.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] application_gateway_backend_address_pools: Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] application_security_groups: Specifies an array of references to application security group.
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] load_balancer_backend_address_pools: Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        :param pulumi.Input[bool] primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        :param pulumi.Input[Union[str, 'IPVersion']] private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        :param pulumi.Input['VirtualMachineScaleSetPublicIPAddressConfigurationArgs'] public_ip_address_configuration: The publicIPAddressConfiguration.
        :param pulumi.Input['ApiEntityReferenceArgs'] subnet: Specifies the identifier of the subnet.
        """
        pulumi.set(__self__, "name", name)
        if application_gateway_backend_address_pools is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pools", application_gateway_backend_address_pools)
        if application_security_groups is not None:
            pulumi.set(__self__, "application_security_groups", application_security_groups)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_inbound_nat_pools is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_pools", load_balancer_inbound_nat_pools)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if public_ip_address_configuration is not None:
            pulumi.set(__self__, "public_ip_address_configuration", public_ip_address_configuration)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The IP configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="applicationGatewayBackendAddressPools")
    def application_gateway_backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
        """
        return pulumi.get(self, "application_gateway_backend_address_pools")

    @application_gateway_backend_address_pools.setter
    def application_gateway_backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "application_gateway_backend_address_pools", value)

    @property
    @pulumi.getter(name="applicationSecurityGroups")
    def application_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Specifies an array of references to application security group.
        """
        return pulumi.get(self, "application_security_groups")

    @application_security_groups.setter
    def application_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "application_security_groups", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @load_balancer_backend_address_pools.setter
    def load_balancer_backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "load_balancer_backend_address_pools", value)

    @property
    @pulumi.getter(name="loadBalancerInboundNatPools")
    def load_balancer_inbound_nat_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_pools")

    @load_balancer_inbound_nat_pools.setter
    def load_balancer_inbound_nat_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "load_balancer_inbound_nat_pools", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[pulumi.Input[Union[str, 'IPVersion']]]:
        """
        Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "private_ip_address_version")

    @private_ip_address_version.setter
    def private_ip_address_version(self, value: Optional[pulumi.Input[Union[str, 'IPVersion']]]):
        pulumi.set(self, "private_ip_address_version", value)

    @property
    @pulumi.getter(name="publicIPAddressConfiguration")
    def public_ip_address_configuration(self) -> Optional[pulumi.Input['VirtualMachineScaleSetPublicIPAddressConfigurationArgs']]:
        """
        The publicIPAddressConfiguration.
        """
        return pulumi.get(self, "public_ip_address_configuration")

    @public_ip_address_configuration.setter
    def public_ip_address_configuration(self, value: Optional[pulumi.Input['VirtualMachineScaleSetPublicIPAddressConfigurationArgs']]):
        pulumi.set(self, "public_ip_address_configuration", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ApiEntityReferenceArgs']]:
        """
        Specifies the identifier of the subnet.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ApiEntityReferenceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class VirtualMachineScaleSetIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the virtual machine scale set.
        :param pulumi.Input['ResourceIdentityType'] type: The type of identity used for the virtual machine scale set. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine scale set.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user identities associated with the virtual machine scale set. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The type of identity used for the virtual machine scale set. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine scale set.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user identities associated with the virtual machine scale set. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class VirtualMachineScaleSetIpTagArgs:
    def __init__(__self__, *,
                 ip_tag_type: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        Contains the IP tag associated with the public IP address.
        :param pulumi.Input[str] ip_tag_type: IP tag type. Example: FirstPartyUsage.
        :param pulumi.Input[str] tag: IP tag associated with the public IP. Example: SQL, Storage etc.
        """
        if ip_tag_type is not None:
            pulumi.set(__self__, "ip_tag_type", ip_tag_type)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="ipTagType")
    def ip_tag_type(self) -> Optional[pulumi.Input[str]]:
        """
        IP tag type. Example: FirstPartyUsage.
        """
        return pulumi.get(self, "ip_tag_type")

    @ip_tag_type.setter
    def ip_tag_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_tag_type", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        IP tag associated with the public IP. Example: SQL, Storage etc.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class VirtualMachineScaleSetManagedDiskParametersArgs:
    def __init__(__self__, *,
                 disk_encryption_set: Optional[pulumi.Input['DiskEncryptionSetParametersArgs']] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]] = None):
        """
        Describes the parameters of a ScaleSet managed disk.
        :param pulumi.Input['DiskEncryptionSetParametersArgs'] disk_encryption_set: Specifies the customer managed disk encryption set resource id for the managed disk.
        :param pulumi.Input[Union[str, 'StorageAccountTypes']] storage_account_type: Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        if disk_encryption_set is not None:
            pulumi.set(__self__, "disk_encryption_set", disk_encryption_set)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="diskEncryptionSet")
    def disk_encryption_set(self) -> Optional[pulumi.Input['DiskEncryptionSetParametersArgs']]:
        """
        Specifies the customer managed disk encryption set resource id for the managed disk.
        """
        return pulumi.get(self, "disk_encryption_set")

    @disk_encryption_set.setter
    def disk_encryption_set(self, value: Optional[pulumi.Input['DiskEncryptionSetParametersArgs']]):
        pulumi.set(self, "disk_encryption_set", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]]:
        """
        Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountTypes']]]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class VirtualMachineScaleSetNetworkConfigurationArgs:
    def __init__(__self__, *,
                 ip_configurations: pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetIPConfigurationArgs']]],
                 name: pulumi.Input[str],
                 delete_option: Optional[pulumi.Input[Union[str, 'DeleteOptions']]] = None,
                 dns_settings: Optional[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs']] = None,
                 enable_accelerated_networking: Optional[pulumi.Input[bool]] = None,
                 enable_fpga: Optional[pulumi.Input[bool]] = None,
                 enable_ip_forwarding: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 network_security_group: Optional[pulumi.Input['SubResourceArgs']] = None,
                 primary: Optional[pulumi.Input[bool]] = None):
        """
        Describes a virtual machine scale set network profile's network configurations.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetIPConfigurationArgs']]] ip_configurations: Specifies the IP configurations of the network interface.
        :param pulumi.Input[str] name: The network configuration name.
        :param pulumi.Input[Union[str, 'DeleteOptions']] delete_option: Specify what happens to the network interface when the VM is deleted
        :param pulumi.Input['VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs'] dns_settings: The dns settings to be applied on the network interfaces.
        :param pulumi.Input[bool] enable_accelerated_networking: Specifies whether the network interface is accelerated networking-enabled.
        :param pulumi.Input[bool] enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
        :param pulumi.Input[bool] enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input['SubResourceArgs'] network_security_group: The network security group.
        :param pulumi.Input[bool] primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        if delete_option is not None:
            pulumi.set(__self__, "delete_option", delete_option)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_fpga is not None:
            pulumi.set(__self__, "enable_fpga", enable_fpga)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetIPConfigurationArgs']]]:
        """
        Specifies the IP configurations of the network interface.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetIPConfigurationArgs']]]):
        pulumi.set(self, "ip_configurations", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The network configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="deleteOption")
    def delete_option(self) -> Optional[pulumi.Input[Union[str, 'DeleteOptions']]]:
        """
        Specify what happens to the network interface when the VM is deleted
        """
        return pulumi.get(self, "delete_option")

    @delete_option.setter
    def delete_option(self, value: Optional[pulumi.Input[Union[str, 'DeleteOptions']]]):
        pulumi.set(self, "delete_option", value)

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs']]:
        """
        The dns settings to be applied on the network interfaces.
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs']]):
        pulumi.set(self, "dns_settings", value)

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the network interface is accelerated networking-enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @enable_accelerated_networking.setter
    def enable_accelerated_networking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_accelerated_networking", value)

    @property
    @pulumi.getter(name="enableFpga")
    def enable_fpga(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the network interface is FPGA networking-enabled.
        """
        return pulumi.get(self, "enable_fpga")

    @enable_fpga.setter
    def enable_fpga(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_fpga", value)

    @property
    @pulumi.getter(name="enableIPForwarding")
    def enable_ip_forwarding(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether IP forwarding enabled on this NIC.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @enable_ip_forwarding.setter
    def enable_ip_forwarding(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ip_forwarding", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The network security group.
        """
        return pulumi.get(self, "network_security_group")

    @network_security_group.setter
    def network_security_group(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "network_security_group", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)


@pulumi.input_type
class VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs:
    def __init__(__self__, *,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Describes a virtual machines scale sets network configuration's DNS settings.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: List of DNS servers IP addresses
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of DNS servers IP addresses
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)


@pulumi.input_type
class VirtualMachineScaleSetNetworkProfileArgs:
    def __init__(__self__, *,
                 health_probe: Optional[pulumi.Input['ApiEntityReferenceArgs']] = None,
                 network_api_version: Optional[pulumi.Input[Union[str, 'NetworkApiVersion']]] = None,
                 network_interface_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationArgs']]]] = None):
        """
        Describes a virtual machine scale set network profile.
        :param pulumi.Input['ApiEntityReferenceArgs'] health_probe: A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        :param pulumi.Input[Union[str, 'NetworkApiVersion']] network_api_version: specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationArgs']]] network_interface_configurations: The list of network configurations.
        """
        if health_probe is not None:
            pulumi.set(__self__, "health_probe", health_probe)
        if network_api_version is not None:
            pulumi.set(__self__, "network_api_version", network_api_version)
        if network_interface_configurations is not None:
            pulumi.set(__self__, "network_interface_configurations", network_interface_configurations)

    @property
    @pulumi.getter(name="healthProbe")
    def health_probe(self) -> Optional[pulumi.Input['ApiEntityReferenceArgs']]:
        """
        A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        """
        return pulumi.get(self, "health_probe")

    @health_probe.setter
    def health_probe(self, value: Optional[pulumi.Input['ApiEntityReferenceArgs']]):
        pulumi.set(self, "health_probe", value)

    @property
    @pulumi.getter(name="networkApiVersion")
    def network_api_version(self) -> Optional[pulumi.Input[Union[str, 'NetworkApiVersion']]]:
        """
        specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'
        """
        return pulumi.get(self, "network_api_version")

    @network_api_version.setter
    def network_api_version(self, value: Optional[pulumi.Input[Union[str, 'NetworkApiVersion']]]):
        pulumi.set(self, "network_api_version", value)

    @property
    @pulumi.getter(name="networkInterfaceConfigurations")
    def network_interface_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationArgs']]]]:
        """
        The list of network configurations.
        """
        return pulumi.get(self, "network_interface_configurations")

    @network_interface_configurations.setter
    def network_interface_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationArgs']]]]):
        pulumi.set(self, "network_interface_configurations", value)


@pulumi.input_type
class VirtualMachineScaleSetOSDiskArgs:
    def __init__(__self__, *,
                 create_option: pulumi.Input[Union[str, 'DiskCreateOptionTypes']],
                 caching: Optional[pulumi.Input['CachingTypes']] = None,
                 diff_disk_settings: Optional[pulumi.Input['DiffDiskSettingsArgs']] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 image: Optional[pulumi.Input['VirtualHardDiskArgs']] = None,
                 managed_disk: Optional[pulumi.Input['VirtualMachineScaleSetManagedDiskParametersArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input['OperatingSystemTypes']] = None,
                 vhd_containers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 write_accelerator_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Describes a virtual machine scale set operating system disk.
        :param pulumi.Input[Union[str, 'DiskCreateOptionTypes']] create_option: Specifies how the virtual machines in the scale set should be created.<br><br> The only allowed value is: **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param pulumi.Input['CachingTypes'] caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param pulumi.Input['DiffDiskSettingsArgs'] diff_disk_settings: Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
        :param pulumi.Input[int] disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param pulumi.Input['VirtualHardDiskArgs'] image: Specifies information about the unmanaged user image to base the scale set on.
        :param pulumi.Input['VirtualMachineScaleSetManagedDiskParametersArgs'] managed_disk: The managed disk parameters.
        :param pulumi.Input[str] name: The disk name.
        :param pulumi.Input['OperatingSystemTypes'] os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vhd_containers: Specifies the container urls that are used to store operating system disks for the scale set.
        :param pulumi.Input[bool] write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if diff_disk_settings is not None:
            pulumi.set(__self__, "diff_disk_settings", diff_disk_settings)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd_containers is not None:
            pulumi.set(__self__, "vhd_containers", vhd_containers)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Input[Union[str, 'DiskCreateOptionTypes']]:
        """
        Specifies how the virtual machines in the scale set should be created.<br><br> The only allowed value is: **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: pulumi.Input[Union[str, 'DiskCreateOptionTypes']]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input['CachingTypes']]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input['CachingTypes']]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="diffDiskSettings")
    def diff_disk_settings(self) -> Optional[pulumi.Input['DiffDiskSettingsArgs']]:
        """
        Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
        """
        return pulumi.get(self, "diff_disk_settings")

    @diff_disk_settings.setter
    def diff_disk_settings(self, value: Optional[pulumi.Input['DiffDiskSettingsArgs']]):
        pulumi.set(self, "diff_disk_settings", value)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of the operating system disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['VirtualHardDiskArgs']]:
        """
        Specifies information about the unmanaged user image to base the scale set on.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['VirtualHardDiskArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional[pulumi.Input['VirtualMachineScaleSetManagedDiskParametersArgs']]:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @managed_disk.setter
    def managed_disk(self, value: Optional[pulumi.Input['VirtualMachineScaleSetManagedDiskParametersArgs']]):
        pulumi.set(self, "managed_disk", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input['OperatingSystemTypes']]:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input['OperatingSystemTypes']]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="vhdContainers")
    def vhd_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the container urls that are used to store operating system disks for the scale set.
        """
        return pulumi.get(self, "vhd_containers")

    @vhd_containers.setter
    def vhd_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vhd_containers", value)

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")

    @write_accelerator_enabled.setter
    def write_accelerator_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_accelerator_enabled", value)


@pulumi.input_type
class VirtualMachineScaleSetOSProfileArgs:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 computer_name_prefix: Optional[pulumi.Input[str]] = None,
                 custom_data: Optional[pulumi.Input[str]] = None,
                 linux_configuration: Optional[pulumi.Input['LinuxConfigurationArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['VaultSecretGroupArgs']]]] = None,
                 windows_configuration: Optional[pulumi.Input['WindowsConfigurationArgs']] = None):
        """
        Describes a virtual machine scale set OS profile.
        :param pulumi.Input[str] admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        :param pulumi.Input[str] admin_username: Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters
        :param pulumi.Input[str] computer_name_prefix: Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        :param pulumi.Input[str] custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
        :param pulumi.Input['LinuxConfigurationArgs'] linux_configuration: Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        :param pulumi.Input[Sequence[pulumi.Input['VaultSecretGroupArgs']]] secrets: Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        :param pulumi.Input['WindowsConfigurationArgs'] windows_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name_prefix is not None:
            pulumi.set(__self__, "computer_name_prefix", computer_name_prefix)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        """
        return pulumi.get(self, "computer_name_prefix")

    @computer_name_prefix.setter
    def computer_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "computer_name_prefix", value)

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_data", value)

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional[pulumi.Input['LinuxConfigurationArgs']]:
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        """
        return pulumi.get(self, "linux_configuration")

    @linux_configuration.setter
    def linux_configuration(self, value: Optional[pulumi.Input['LinuxConfigurationArgs']]):
        pulumi.set(self, "linux_configuration", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultSecretGroupArgs']]]]:
        """
        Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultSecretGroupArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional[pulumi.Input['WindowsConfigurationArgs']]:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "windows_configuration")

    @windows_configuration.setter
    def windows_configuration(self, value: Optional[pulumi.Input['WindowsConfigurationArgs']]):
        pulumi.set(self, "windows_configuration", value)


@pulumi.input_type
class VirtualMachineScaleSetPublicIPAddressConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 delete_option: Optional[pulumi.Input[Union[str, 'DeleteOptions']]] = None,
                 dns_settings: Optional[pulumi.Input['VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs']] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 ip_tags: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetIpTagArgs']]]] = None,
                 public_ip_address_version: Optional[pulumi.Input[Union[str, 'IPVersion']]] = None,
                 public_ip_prefix: Optional[pulumi.Input['SubResourceArgs']] = None,
                 sku: Optional[pulumi.Input['PublicIPAddressSkuArgs']] = None):
        """
        Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
        :param pulumi.Input[str] name: The publicIP address configuration name.
        :param pulumi.Input[Union[str, 'DeleteOptions']] delete_option: Specify what happens to the public IP when the VM is deleted
        :param pulumi.Input['VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs'] dns_settings: The dns settings to be applied on the publicIP addresses .
        :param pulumi.Input[int] idle_timeout_in_minutes: The idle timeout of the public IP address.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetIpTagArgs']]] ip_tags: The list of IP tags associated with the public IP address.
        :param pulumi.Input[Union[str, 'IPVersion']] public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
        :param pulumi.Input['SubResourceArgs'] public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
        :param pulumi.Input['PublicIPAddressSkuArgs'] sku: Describes the public IP Sku
        """
        pulumi.set(__self__, "name", name)
        if delete_option is not None:
            pulumi.set(__self__, "delete_option", delete_option)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if public_ip_address_version is not None:
            pulumi.set(__self__, "public_ip_address_version", public_ip_address_version)
        if public_ip_prefix is not None:
            pulumi.set(__self__, "public_ip_prefix", public_ip_prefix)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The publicIP address configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="deleteOption")
    def delete_option(self) -> Optional[pulumi.Input[Union[str, 'DeleteOptions']]]:
        """
        Specify what happens to the public IP when the VM is deleted
        """
        return pulumi.get(self, "delete_option")

    @delete_option.setter
    def delete_option(self, value: Optional[pulumi.Input[Union[str, 'DeleteOptions']]]):
        pulumi.set(self, "delete_option", value)

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs']]:
        """
        The dns settings to be applied on the publicIP addresses .
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs']]):
        pulumi.set(self, "dns_settings", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The idle timeout of the public IP address.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetIpTagArgs']]]]:
        """
        The list of IP tags associated with the public IP address.
        """
        return pulumi.get(self, "ip_tags")

    @ip_tags.setter
    def ip_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetIpTagArgs']]]]):
        pulumi.set(self, "ip_tags", value)

    @property
    @pulumi.getter(name="publicIPAddressVersion")
    def public_ip_address_version(self) -> Optional[pulumi.Input[Union[str, 'IPVersion']]]:
        """
        Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "public_ip_address_version")

    @public_ip_address_version.setter
    def public_ip_address_version(self, value: Optional[pulumi.Input[Union[str, 'IPVersion']]]):
        pulumi.set(self, "public_ip_address_version", value)

    @property
    @pulumi.getter(name="publicIPPrefix")
    def public_ip_prefix(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The PublicIPPrefix from which to allocate publicIP addresses.
        """
        return pulumi.get(self, "public_ip_prefix")

    @public_ip_prefix.setter
    def public_ip_prefix(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "public_ip_prefix", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['PublicIPAddressSkuArgs']]:
        """
        Describes the public IP Sku
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['PublicIPAddressSkuArgs']]):
        pulumi.set(self, "sku", value)


@pulumi.input_type
class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs:
    def __init__(__self__, *,
                 domain_name_label: pulumi.Input[str]):
        """
        Describes a virtual machines scale sets network configuration's DNS settings.
        :param pulumi.Input[str] domain_name_label: The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
        """
        pulumi.set(__self__, "domain_name_label", domain_name_label)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> pulumi.Input[str]:
        """
        The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
        """
        return pulumi.get(self, "domain_name_label")

    @domain_name_label.setter
    def domain_name_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name_label", value)


@pulumi.input_type
class VirtualMachineScaleSetStorageProfileArgs:
    def __init__(__self__, *,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetDataDiskArgs']]]] = None,
                 image_reference: Optional[pulumi.Input['ImageReferenceArgs']] = None,
                 os_disk: Optional[pulumi.Input['VirtualMachineScaleSetOSDiskArgs']] = None):
        """
        Describes a virtual machine scale set storage profile.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetDataDiskArgs']]] data_disks: Specifies the parameters that are used to add data disks to the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        :param pulumi.Input['ImageReferenceArgs'] image_reference: Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        :param pulumi.Input['VirtualMachineScaleSetOSDiskArgs'] os_disk: Specifies information about the operating system disk used by the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetDataDiskArgs']]]]:
        """
        Specifies the parameters that are used to add data disks to the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional[pulumi.Input['ImageReferenceArgs']]:
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        """
        return pulumi.get(self, "image_reference")

    @image_reference.setter
    def image_reference(self, value: Optional[pulumi.Input['ImageReferenceArgs']]):
        pulumi.set(self, "image_reference", value)

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional[pulumi.Input['VirtualMachineScaleSetOSDiskArgs']]:
        """
        Specifies information about the operating system disk used by the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: Optional[pulumi.Input['VirtualMachineScaleSetOSDiskArgs']]):
        pulumi.set(self, "os_disk", value)


@pulumi.input_type
class VirtualMachineScaleSetVMNetworkProfileConfigurationArgs:
    def __init__(__self__, *,
                 network_interface_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationArgs']]]] = None):
        """
        Describes a virtual machine scale set VM network profile.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationArgs']]] network_interface_configurations: The list of network configurations.
        """
        if network_interface_configurations is not None:
            pulumi.set(__self__, "network_interface_configurations", network_interface_configurations)

    @property
    @pulumi.getter(name="networkInterfaceConfigurations")
    def network_interface_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationArgs']]]]:
        """
        The list of network configurations.
        """
        return pulumi.get(self, "network_interface_configurations")

    @network_interface_configurations.setter
    def network_interface_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineScaleSetNetworkConfigurationArgs']]]]):
        pulumi.set(self, "network_interface_configurations", value)


@pulumi.input_type
class VirtualMachineScaleSetVMProfileArgs:
    def __init__(__self__, *,
                 billing_profile: Optional[pulumi.Input['BillingProfileArgs']] = None,
                 diagnostics_profile: Optional[pulumi.Input['DiagnosticsProfileArgs']] = None,
                 eviction_policy: Optional[pulumi.Input[Union[str, 'VirtualMachineEvictionPolicyTypes']]] = None,
                 extension_profile: Optional[pulumi.Input['VirtualMachineScaleSetExtensionProfileArgs']] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 network_profile: Optional[pulumi.Input['VirtualMachineScaleSetNetworkProfileArgs']] = None,
                 os_profile: Optional[pulumi.Input['VirtualMachineScaleSetOSProfileArgs']] = None,
                 priority: Optional[pulumi.Input[Union[str, 'VirtualMachinePriorityTypes']]] = None,
                 scheduled_events_profile: Optional[pulumi.Input['ScheduledEventsProfileArgs']] = None,
                 security_profile: Optional[pulumi.Input['SecurityProfileArgs']] = None,
                 storage_profile: Optional[pulumi.Input['VirtualMachineScaleSetStorageProfileArgs']] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        Describes a virtual machine scale set virtual machine profile.
        :param pulumi.Input['BillingProfileArgs'] billing_profile: Specifies the billing related details of a Azure Spot VMSS. <br><br>Minimum api-version: 2019-03-01.
        :param pulumi.Input['DiagnosticsProfileArgs'] diagnostics_profile: Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        :param pulumi.Input[Union[str, 'VirtualMachineEvictionPolicyTypes']] eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. <br><br>For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. <br><br>For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
        :param pulumi.Input['VirtualMachineScaleSetExtensionProfileArgs'] extension_profile: Specifies a collection of settings for extensions installed on virtual machines in the scale set.
        :param pulumi.Input[str] license_type: Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
        :param pulumi.Input['VirtualMachineScaleSetNetworkProfileArgs'] network_profile: Specifies properties of the network interfaces of the virtual machines in the scale set.
        :param pulumi.Input['VirtualMachineScaleSetOSProfileArgs'] os_profile: Specifies the operating system settings for the virtual machines in the scale set.
        :param pulumi.Input[Union[str, 'VirtualMachinePriorityTypes']] priority: Specifies the priority for the virtual machines in the scale set. <br><br>Minimum api-version: 2017-10-30-preview
        :param pulumi.Input['ScheduledEventsProfileArgs'] scheduled_events_profile: Specifies Scheduled Event related configurations.
        :param pulumi.Input['SecurityProfileArgs'] security_profile: Specifies the Security related profile settings for the virtual machines in the scale set.
        :param pulumi.Input['VirtualMachineScaleSetStorageProfileArgs'] storage_profile: Specifies the storage settings for the virtual machine disks.
        :param pulumi.Input[str] user_data: UserData for the virtual machines in the scale set, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
        """
        if billing_profile is not None:
            pulumi.set(__self__, "billing_profile", billing_profile)
        if diagnostics_profile is not None:
            pulumi.set(__self__, "diagnostics_profile", diagnostics_profile)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extension_profile is not None:
            pulumi.set(__self__, "extension_profile", extension_profile)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if scheduled_events_profile is not None:
            pulumi.set(__self__, "scheduled_events_profile", scheduled_events_profile)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="billingProfile")
    def billing_profile(self) -> Optional[pulumi.Input['BillingProfileArgs']]:
        """
        Specifies the billing related details of a Azure Spot VMSS. <br><br>Minimum api-version: 2019-03-01.
        """
        return pulumi.get(self, "billing_profile")

    @billing_profile.setter
    def billing_profile(self, value: Optional[pulumi.Input['BillingProfileArgs']]):
        pulumi.set(self, "billing_profile", value)

    @property
    @pulumi.getter(name="diagnosticsProfile")
    def diagnostics_profile(self) -> Optional[pulumi.Input['DiagnosticsProfileArgs']]:
        """
        Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        """
        return pulumi.get(self, "diagnostics_profile")

    @diagnostics_profile.setter
    def diagnostics_profile(self, value: Optional[pulumi.Input['DiagnosticsProfileArgs']]):
        pulumi.set(self, "diagnostics_profile", value)

    @property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[Union[str, 'VirtualMachineEvictionPolicyTypes']]]:
        """
        Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. <br><br>For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. <br><br>For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[Union[str, 'VirtualMachineEvictionPolicyTypes']]]):
        pulumi.set(self, "eviction_policy", value)

    @property
    @pulumi.getter(name="extensionProfile")
    def extension_profile(self) -> Optional[pulumi.Input['VirtualMachineScaleSetExtensionProfileArgs']]:
        """
        Specifies a collection of settings for extensions installed on virtual machines in the scale set.
        """
        return pulumi.get(self, "extension_profile")

    @extension_profile.setter
    def extension_profile(self, value: Optional[pulumi.Input['VirtualMachineScaleSetExtensionProfileArgs']]):
        pulumi.set(self, "extension_profile", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['VirtualMachineScaleSetNetworkProfileArgs']]:
        """
        Specifies properties of the network interfaces of the virtual machines in the scale set.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['VirtualMachineScaleSetNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['VirtualMachineScaleSetOSProfileArgs']]:
        """
        Specifies the operating system settings for the virtual machines in the scale set.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['VirtualMachineScaleSetOSProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[Union[str, 'VirtualMachinePriorityTypes']]]:
        """
        Specifies the priority for the virtual machines in the scale set. <br><br>Minimum api-version: 2017-10-30-preview
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[Union[str, 'VirtualMachinePriorityTypes']]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="scheduledEventsProfile")
    def scheduled_events_profile(self) -> Optional[pulumi.Input['ScheduledEventsProfileArgs']]:
        """
        Specifies Scheduled Event related configurations.
        """
        return pulumi.get(self, "scheduled_events_profile")

    @scheduled_events_profile.setter
    def scheduled_events_profile(self, value: Optional[pulumi.Input['ScheduledEventsProfileArgs']]):
        pulumi.set(self, "scheduled_events_profile", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['SecurityProfileArgs']]:
        """
        Specifies the Security related profile settings for the virtual machines in the scale set.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['SecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional[pulumi.Input['VirtualMachineScaleSetStorageProfileArgs']]:
        """
        Specifies the storage settings for the virtual machine disks.
        """
        return pulumi.get(self, "storage_profile")

    @storage_profile.setter
    def storage_profile(self, value: Optional[pulumi.Input['VirtualMachineScaleSetStorageProfileArgs']]):
        pulumi.set(self, "storage_profile", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        UserData for the virtual machines in the scale set, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class VirtualMachineScaleSetVMProtectionPolicyArgs:
    def __init__(__self__, *,
                 protect_from_scale_in: Optional[pulumi.Input[bool]] = None,
                 protect_from_scale_set_actions: Optional[pulumi.Input[bool]] = None):
        """
        The protection policy of a virtual machine scale set VM.
        :param pulumi.Input[bool] protect_from_scale_in: Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
        :param pulumi.Input[bool] protect_from_scale_set_actions: Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
        """
        if protect_from_scale_in is not None:
            pulumi.set(__self__, "protect_from_scale_in", protect_from_scale_in)
        if protect_from_scale_set_actions is not None:
            pulumi.set(__self__, "protect_from_scale_set_actions", protect_from_scale_set_actions)

    @property
    @pulumi.getter(name="protectFromScaleIn")
    def protect_from_scale_in(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
        """
        return pulumi.get(self, "protect_from_scale_in")

    @protect_from_scale_in.setter
    def protect_from_scale_in(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protect_from_scale_in", value)

    @property
    @pulumi.getter(name="protectFromScaleSetActions")
    def protect_from_scale_set_actions(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
        """
        return pulumi.get(self, "protect_from_scale_set_actions")

    @protect_from_scale_set_actions.setter
    def protect_from_scale_set_actions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protect_from_scale_set_actions", value)


@pulumi.input_type
class WinRMConfigurationArgs:
    def __init__(__self__, *,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['WinRMListenerArgs']]]] = None):
        """
        Describes Windows Remote Management configuration of the VM
        :param pulumi.Input[Sequence[pulumi.Input['WinRMListenerArgs']]] listeners: The list of Windows Remote Management listeners
        """
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)

    @property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WinRMListenerArgs']]]]:
        """
        The list of Windows Remote Management listeners
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WinRMListenerArgs']]]]):
        pulumi.set(self, "listeners", value)


@pulumi.input_type
class WinRMListenerArgs:
    def __init__(__self__, *,
                 certificate_url: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input['ProtocolTypes']] = None):
        """
        Describes Protocol and thumbprint of Windows Remote Management listener
        :param pulumi.Input[str] certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br> "data":"<Base64-encoded-certificate>",<br> "dataType":"pfx",<br> "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        :param pulumi.Input['ProtocolTypes'] protocol: Specifies the protocol of WinRM listener. <br><br> Possible values are: <br>**http** <br><br> **https**
        """
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[pulumi.Input[str]]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br> "data":"<Base64-encoded-certificate>",<br> "dataType":"pfx",<br> "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        """
        return pulumi.get(self, "certificate_url")

    @certificate_url.setter
    def certificate_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_url", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['ProtocolTypes']]:
        """
        Specifies the protocol of WinRM listener. <br><br> Possible values are: <br>**http** <br><br> **https**
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['ProtocolTypes']]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class WindowsConfigurationArgs:
    def __init__(__self__, *,
                 additional_unattend_content: Optional[pulumi.Input[Sequence[pulumi.Input['AdditionalUnattendContentArgs']]]] = None,
                 enable_automatic_updates: Optional[pulumi.Input[bool]] = None,
                 patch_settings: Optional[pulumi.Input['PatchSettingsArgs']] = None,
                 provision_vm_agent: Optional[pulumi.Input[bool]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 win_rm: Optional[pulumi.Input['WinRMConfigurationArgs']] = None):
        """
        Specifies Windows operating system settings on the virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input['AdditionalUnattendContentArgs']]] additional_unattend_content: Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
        :param pulumi.Input[bool] enable_automatic_updates: Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. <br><br> For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
        :param pulumi.Input['PatchSettingsArgs'] patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on Windows.
        :param pulumi.Input[bool] provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        :param pulumi.Input[str] time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". <br><br> Possible values can be [TimeZoneInfo.Id](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo.GetSystemTimeZones](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones).
        :param pulumi.Input['WinRMConfigurationArgs'] win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
        """
        if additional_unattend_content is not None:
            pulumi.set(__self__, "additional_unattend_content", additional_unattend_content)
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if patch_settings is not None:
            pulumi.set(__self__, "patch_settings", patch_settings)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if win_rm is not None:
            pulumi.set(__self__, "win_rm", win_rm)

    @property
    @pulumi.getter(name="additionalUnattendContent")
    def additional_unattend_content(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdditionalUnattendContentArgs']]]]:
        """
        Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
        """
        return pulumi.get(self, "additional_unattend_content")

    @additional_unattend_content.setter
    def additional_unattend_content(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdditionalUnattendContentArgs']]]]):
        pulumi.set(self, "additional_unattend_content", value)

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. <br><br> For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
        """
        return pulumi.get(self, "enable_automatic_updates")

    @enable_automatic_updates.setter
    def enable_automatic_updates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_updates", value)

    @property
    @pulumi.getter(name="patchSettings")
    def patch_settings(self) -> Optional[pulumi.Input['PatchSettingsArgs']]:
        """
        [Preview Feature] Specifies settings related to VM Guest Patching on Windows.
        """
        return pulumi.get(self, "patch_settings")

    @patch_settings.setter
    def patch_settings(self, value: Optional[pulumi.Input['PatchSettingsArgs']]):
        pulumi.set(self, "patch_settings", value)

    @property
    @pulumi.getter(name="provisionVMAgent")
    def provision_vm_agent(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        """
        return pulumi.get(self, "provision_vm_agent")

    @provision_vm_agent.setter
    def provision_vm_agent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "provision_vm_agent", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". <br><br> Possible values can be [TimeZoneInfo.Id](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo.GetSystemTimeZones](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="winRM")
    def win_rm(self) -> Optional[pulumi.Input['WinRMConfigurationArgs']]:
        """
        Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
        """
        return pulumi.get(self, "win_rm")

    @win_rm.setter
    def win_rm(self, value: Optional[pulumi.Input['WinRMConfigurationArgs']]):
        pulumi.set(self, "win_rm", value)


