# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApiConnectionDefinitionPropertiesArgs',
    'ApiConnectionTestLinkArgs',
    'ApiOAuthSettingsArgs',
    'ApiOAuthSettingsParameterArgs',
    'ApiReferenceArgs',
    'ApiResourceBackendServiceArgs',
    'ApiResourceDefinitionsArgs',
    'ConnectionErrorArgs',
    'ConnectionGatewayDefinitionPropertiesArgs',
    'ConnectionGatewayReferenceArgs',
    'ConnectionParameterArgs',
    'ConnectionStatusDefinitionArgs',
    'ConsentLinkParameterDefinition',
    'CustomApiPropertiesDefinitionArgs',
    'WsdlDefinitionArgs',
    'WsdlServiceArgs',
    'WsdlService',
]

@pulumi.input_type
class ApiConnectionDefinitionPropertiesArgs:
    def __init__(__self__, *,
                 api: Optional[pulumi.Input['ApiReferenceArgs']] = None,
                 changed_time: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 custom_parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 non_secret_parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionStatusDefinitionArgs']]]] = None,
                 test_links: Optional[pulumi.Input[Sequence[pulumi.Input['ApiConnectionTestLinkArgs']]]] = None):
        """
        :param pulumi.Input[str] changed_time: Timestamp of last connection change
        :param pulumi.Input[str] created_time: Timestamp of the connection creation
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_parameter_values: Dictionary of custom parameter values
        :param pulumi.Input[str] display_name: Display name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] non_secret_parameter_values: Dictionary of nonsecret parameter values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameter_values: Dictionary of parameter values
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionStatusDefinitionArgs']]] statuses: Status of the connection
        :param pulumi.Input[Sequence[pulumi.Input['ApiConnectionTestLinkArgs']]] test_links: Links to test the API connection
        """
        if api is not None:
            pulumi.set(__self__, "api", api)
        if changed_time is not None:
            pulumi.set(__self__, "changed_time", changed_time)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if custom_parameter_values is not None:
            pulumi.set(__self__, "custom_parameter_values", custom_parameter_values)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if non_secret_parameter_values is not None:
            pulumi.set(__self__, "non_secret_parameter_values", non_secret_parameter_values)
        if parameter_values is not None:
            pulumi.set(__self__, "parameter_values", parameter_values)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if test_links is not None:
            pulumi.set(__self__, "test_links", test_links)

    @property
    @pulumi.getter
    def api(self) -> Optional[pulumi.Input['ApiReferenceArgs']]:
        return pulumi.get(self, "api")

    @api.setter
    def api(self, value: Optional[pulumi.Input['ApiReferenceArgs']]):
        pulumi.set(self, "api", value)

    @property
    @pulumi.getter(name="changedTime")
    def changed_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of last connection change
        """
        return pulumi.get(self, "changed_time")

    @changed_time.setter
    def changed_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "changed_time", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the connection creation
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="customParameterValues")
    def custom_parameter_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary of custom parameter values
        """
        return pulumi.get(self, "custom_parameter_values")

    @custom_parameter_values.setter
    def custom_parameter_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_parameter_values", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="nonSecretParameterValues")
    def non_secret_parameter_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary of nonsecret parameter values
        """
        return pulumi.get(self, "non_secret_parameter_values")

    @non_secret_parameter_values.setter
    def non_secret_parameter_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "non_secret_parameter_values", value)

    @property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary of parameter values
        """
        return pulumi.get(self, "parameter_values")

    @parameter_values.setter
    def parameter_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameter_values", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionStatusDefinitionArgs']]]]:
        """
        Status of the connection
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionStatusDefinitionArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter(name="testLinks")
    def test_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiConnectionTestLinkArgs']]]]:
        """
        Links to test the API connection
        """
        return pulumi.get(self, "test_links")

    @test_links.setter
    def test_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiConnectionTestLinkArgs']]]]):
        pulumi.set(self, "test_links", value)


@pulumi.input_type
class ApiConnectionTestLinkArgs:
    def __init__(__self__, *,
                 method: Optional[pulumi.Input[str]] = None,
                 request_uri: Optional[pulumi.Input[str]] = None):
        """
        API connection properties
        :param pulumi.Input[str] method: HTTP Method
        :param pulumi.Input[str] request_uri: Test link request URI
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if request_uri is not None:
            pulumi.set(__self__, "request_uri", request_uri)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP Method
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="requestUri")
    def request_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Test link request URI
        """
        return pulumi.get(self, "request_uri")

    @request_uri.setter
    def request_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_uri", value)


@pulumi.input_type
class ApiOAuthSettingsArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 custom_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApiOAuthSettingsParameterArgs']]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 properties: Optional[Any] = None,
                 redirect_url: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        OAuth settings for the connection provider
        :param pulumi.Input[str] client_id: Resource provider client id
        :param pulumi.Input[str] client_secret: Client Secret needed for OAuth
        :param pulumi.Input[Mapping[str, pulumi.Input['ApiOAuthSettingsParameterArgs']]] custom_parameters: OAuth parameters key is the name of parameter
        :param pulumi.Input[str] identity_provider: Identity provider
        :param Any properties: Read only properties for this oauth setting.
        :param pulumi.Input[str] redirect_url: Url
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: OAuth scopes
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if custom_parameters is not None:
            pulumi.set(__self__, "custom_parameters", custom_parameters)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource provider client id
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Client Secret needed for OAuth
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="customParameters")
    def custom_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ApiOAuthSettingsParameterArgs']]]]:
        """
        OAuth parameters key is the name of parameter
        """
        return pulumi.get(self, "custom_parameters")

    @custom_parameters.setter
    def custom_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApiOAuthSettingsParameterArgs']]]]):
        pulumi.set(self, "custom_parameters", value)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[pulumi.Input[str]]:
        """
        Identity provider
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Any]:
        """
        Read only properties for this oauth setting.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[Any]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Url
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        OAuth scopes
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class ApiOAuthSettingsParameterArgs:
    def __init__(__self__, *,
                 options: Optional[Any] = None,
                 ui_definition: Optional[Any] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        OAuth settings for the API
        :param Any options: Options available to this parameter
        :param Any ui_definition: UI definitions per culture as caller can specify the culture
        :param pulumi.Input[str] value: Value of the setting
        """
        if options is not None:
            pulumi.set(__self__, "options", options)
        if ui_definition is not None:
            pulumi.set(__self__, "ui_definition", ui_definition)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[Any]:
        """
        Options available to this parameter
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[Any]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="uiDefinition")
    def ui_definition(self) -> Optional[Any]:
        """
        UI definitions per culture as caller can specify the culture
        """
        return pulumi.get(self, "ui_definition")

    @ui_definition.setter
    def ui_definition(self, value: Optional[Any]):
        pulumi.set(self, "ui_definition", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the setting
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ApiReferenceArgs:
    def __init__(__self__, *,
                 brand_color: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 icon_uri: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 swagger: Optional[Any] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] brand_color: Brand color
        :param pulumi.Input[str] description: The custom API description
        :param pulumi.Input[str] display_name: The display name
        :param pulumi.Input[str] icon_uri: The icon URI
        :param pulumi.Input[str] id: Resource reference id
        :param pulumi.Input[str] name: The name of the API
        :param Any swagger: The JSON representation of the swagger
        :param pulumi.Input[str] type: Resource reference type
        """
        if brand_color is not None:
            pulumi.set(__self__, "brand_color", brand_color)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if icon_uri is not None:
            pulumi.set(__self__, "icon_uri", icon_uri)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if swagger is not None:
            pulumi.set(__self__, "swagger", swagger)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="brandColor")
    def brand_color(self) -> Optional[pulumi.Input[str]]:
        """
        Brand color
        """
        return pulumi.get(self, "brand_color")

    @brand_color.setter
    def brand_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "brand_color", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The custom API description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="iconUri")
    def icon_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The icon URI
        """
        return pulumi.get(self, "icon_uri")

    @icon_uri.setter
    def icon_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_uri", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource reference id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the API
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def swagger(self) -> Optional[Any]:
        """
        The JSON representation of the swagger
        """
        return pulumi.get(self, "swagger")

    @swagger.setter
    def swagger(self, value: Optional[Any]):
        pulumi.set(self, "swagger", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource reference type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ApiResourceBackendServiceArgs:
    def __init__(__self__, *,
                 service_url: Optional[pulumi.Input[str]] = None):
        """
        The API backend service
        :param pulumi.Input[str] service_url: The service URL
        """
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[str]]:
        """
        The service URL
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_url", value)


@pulumi.input_type
class ApiResourceDefinitionsArgs:
    def __init__(__self__, *,
                 modified_swagger_url: Optional[pulumi.Input[str]] = None,
                 original_swagger_url: Optional[pulumi.Input[str]] = None):
        """
        API Definitions
        :param pulumi.Input[str] modified_swagger_url: The modified swagger URL
        :param pulumi.Input[str] original_swagger_url: The original swagger URL
        """
        if modified_swagger_url is not None:
            pulumi.set(__self__, "modified_swagger_url", modified_swagger_url)
        if original_swagger_url is not None:
            pulumi.set(__self__, "original_swagger_url", original_swagger_url)

    @property
    @pulumi.getter(name="modifiedSwaggerUrl")
    def modified_swagger_url(self) -> Optional[pulumi.Input[str]]:
        """
        The modified swagger URL
        """
        return pulumi.get(self, "modified_swagger_url")

    @modified_swagger_url.setter
    def modified_swagger_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_swagger_url", value)

    @property
    @pulumi.getter(name="originalSwaggerUrl")
    def original_swagger_url(self) -> Optional[pulumi.Input[str]]:
        """
        The original swagger URL
        """
        return pulumi.get(self, "original_swagger_url")

    @original_swagger_url.setter
    def original_swagger_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "original_swagger_url", value)


@pulumi.input_type
class ConnectionErrorArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Connection error
        :param pulumi.Input[str] code: Code of the status
        :param pulumi.Input[str] etag: Resource ETag
        :param pulumi.Input[str] location: Resource location
        :param pulumi.Input[str] message: Description of the status
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        Code of the status
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ETag
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the status
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ConnectionGatewayDefinitionPropertiesArgs:
    def __init__(__self__, *,
                 backend_uri: Optional[pulumi.Input[str]] = None,
                 connection_gateway_installation: Optional[pulumi.Input['ConnectionGatewayReferenceArgs']] = None,
                 contact_information: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 machine_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[Any] = None):
        """
        :param pulumi.Input[str] backend_uri: The URI of the backend
        :param pulumi.Input['ConnectionGatewayReferenceArgs'] connection_gateway_installation: The gateway installation reference
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_information: The gateway admin
        :param pulumi.Input[str] description: The gateway description
        :param pulumi.Input[str] display_name: The gateway display name
        :param pulumi.Input[str] machine_name: The machine name of the gateway
        :param Any status: The gateway status
        """
        if backend_uri is not None:
            pulumi.set(__self__, "backend_uri", backend_uri)
        if connection_gateway_installation is not None:
            pulumi.set(__self__, "connection_gateway_installation", connection_gateway_installation)
        if contact_information is not None:
            pulumi.set(__self__, "contact_information", contact_information)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if machine_name is not None:
            pulumi.set(__self__, "machine_name", machine_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="backendUri")
    def backend_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the backend
        """
        return pulumi.get(self, "backend_uri")

    @backend_uri.setter
    def backend_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_uri", value)

    @property
    @pulumi.getter(name="connectionGatewayInstallation")
    def connection_gateway_installation(self) -> Optional[pulumi.Input['ConnectionGatewayReferenceArgs']]:
        """
        The gateway installation reference
        """
        return pulumi.get(self, "connection_gateway_installation")

    @connection_gateway_installation.setter
    def connection_gateway_installation(self, value: Optional[pulumi.Input['ConnectionGatewayReferenceArgs']]):
        pulumi.set(self, "connection_gateway_installation", value)

    @property
    @pulumi.getter(name="contactInformation")
    def contact_information(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The gateway admin
        """
        return pulumi.get(self, "contact_information")

    @contact_information.setter
    def contact_information(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contact_information", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The gateway description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The gateway display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The machine name of the gateway
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[Any]:
        """
        The gateway status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[Any]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ConnectionGatewayReferenceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The gateway installation reference
        :param pulumi.Input[str] id: Resource reference id
        :param pulumi.Input[str] location: Resource reference location
        :param pulumi.Input[str] name: Resource reference name
        :param pulumi.Input[str] type: Resource reference type
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource reference id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource reference location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource reference name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource reference type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConnectionParameterArgs:
    def __init__(__self__, *,
                 o_auth_settings: Optional[pulumi.Input['ApiOAuthSettingsArgs']] = None,
                 type: Optional[pulumi.Input['ConnectionParameterType']] = None):
        """
        Connection provider parameters
        :param pulumi.Input['ApiOAuthSettingsArgs'] o_auth_settings: OAuth settings for the connection provider
        :param pulumi.Input['ConnectionParameterType'] type: Type of the parameter
        """
        if o_auth_settings is not None:
            pulumi.set(__self__, "o_auth_settings", o_auth_settings)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="oAuthSettings")
    def o_auth_settings(self) -> Optional[pulumi.Input['ApiOAuthSettingsArgs']]:
        """
        OAuth settings for the connection provider
        """
        return pulumi.get(self, "o_auth_settings")

    @o_auth_settings.setter
    def o_auth_settings(self, value: Optional[pulumi.Input['ApiOAuthSettingsArgs']]):
        pulumi.set(self, "o_auth_settings", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ConnectionParameterType']]:
        """
        Type of the parameter
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ConnectionParameterType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConnectionStatusDefinitionArgs:
    def __init__(__self__, *,
                 error: Optional[pulumi.Input['ConnectionErrorArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        Connection status
        :param pulumi.Input['ConnectionErrorArgs'] error: Connection error
        :param pulumi.Input[str] status: The gateway status
        :param pulumi.Input[str] target: Target of the error
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input['ConnectionErrorArgs']]:
        """
        Connection error
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input['ConnectionErrorArgs']]):
        pulumi.set(self, "error", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The gateway status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Target of the error
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ConsentLinkParameterDefinition:
    def __init__(__self__, *,
                 object_id: Optional[str] = None,
                 parameter_name: Optional[str] = None,
                 redirect_url: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Consent link definition
        :param str object_id: AAD OID (user or group) if the principal type is ActiveDirectory. MSA PUID if the principal type is MicrosoftAccount
        :param str parameter_name: Name of the parameter in the connection provider's OAuth settings
        :param str redirect_url: Name of the parameter in the connection provider's OAuth settings
        :param str tenant_id: The tenant id
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if parameter_name is not None:
            pulumi.set(__self__, "parameter_name", parameter_name)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        AAD OID (user or group) if the principal type is ActiveDirectory. MSA PUID if the principal type is MicrosoftAccount
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[str]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> Optional[str]:
        """
        Name of the parameter in the connection provider's OAuth settings
        """
        return pulumi.get(self, "parameter_name")

    @parameter_name.setter
    def parameter_name(self, value: Optional[str]):
        pulumi.set(self, "parameter_name", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        """
        Name of the parameter in the connection provider's OAuth settings
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[str]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant id
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class CustomApiPropertiesDefinitionArgs:
    def __init__(__self__, *,
                 api_definitions: Optional[pulumi.Input['ApiResourceDefinitionsArgs']] = None,
                 api_type: Optional[pulumi.Input[Union[str, 'ApiType']]] = None,
                 backend_service: Optional[pulumi.Input['ApiResourceBackendServiceArgs']] = None,
                 brand_color: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connection_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ConnectionParameterArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 icon_uri: Optional[pulumi.Input[str]] = None,
                 runtime_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 swagger: Optional[Any] = None,
                 wsdl_definition: Optional[pulumi.Input['WsdlDefinitionArgs']] = None):
        """
        Custom API properties
        :param pulumi.Input['ApiResourceDefinitionsArgs'] api_definitions: API Definitions
        :param pulumi.Input[Union[str, 'ApiType']] api_type: The API type
        :param pulumi.Input['ApiResourceBackendServiceArgs'] backend_service: The API backend service
        :param pulumi.Input[str] brand_color: Brand color
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: The custom API capabilities
        :param pulumi.Input[Mapping[str, pulumi.Input['ConnectionParameterArgs']]] connection_parameters: Connection parameters
        :param pulumi.Input[str] description: The custom API description
        :param pulumi.Input[str] display_name: The display name
        :param pulumi.Input[str] icon_uri: The icon URI
        :param pulumi.Input[Sequence[pulumi.Input[str]]] runtime_urls: Runtime URLs
        :param Any swagger: The JSON representation of the swagger
        :param pulumi.Input['WsdlDefinitionArgs'] wsdl_definition: The WSDL definition
        """
        if api_definitions is not None:
            pulumi.set(__self__, "api_definitions", api_definitions)
        if api_type is not None:
            pulumi.set(__self__, "api_type", api_type)
        if backend_service is not None:
            pulumi.set(__self__, "backend_service", backend_service)
        if brand_color is not None:
            pulumi.set(__self__, "brand_color", brand_color)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if connection_parameters is not None:
            pulumi.set(__self__, "connection_parameters", connection_parameters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if icon_uri is not None:
            pulumi.set(__self__, "icon_uri", icon_uri)
        if runtime_urls is not None:
            pulumi.set(__self__, "runtime_urls", runtime_urls)
        if swagger is not None:
            pulumi.set(__self__, "swagger", swagger)
        if wsdl_definition is not None:
            pulumi.set(__self__, "wsdl_definition", wsdl_definition)

    @property
    @pulumi.getter(name="apiDefinitions")
    def api_definitions(self) -> Optional[pulumi.Input['ApiResourceDefinitionsArgs']]:
        """
        API Definitions
        """
        return pulumi.get(self, "api_definitions")

    @api_definitions.setter
    def api_definitions(self, value: Optional[pulumi.Input['ApiResourceDefinitionsArgs']]):
        pulumi.set(self, "api_definitions", value)

    @property
    @pulumi.getter(name="apiType")
    def api_type(self) -> Optional[pulumi.Input[Union[str, 'ApiType']]]:
        """
        The API type
        """
        return pulumi.get(self, "api_type")

    @api_type.setter
    def api_type(self, value: Optional[pulumi.Input[Union[str, 'ApiType']]]):
        pulumi.set(self, "api_type", value)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> Optional[pulumi.Input['ApiResourceBackendServiceArgs']]:
        """
        The API backend service
        """
        return pulumi.get(self, "backend_service")

    @backend_service.setter
    def backend_service(self, value: Optional[pulumi.Input['ApiResourceBackendServiceArgs']]):
        pulumi.set(self, "backend_service", value)

    @property
    @pulumi.getter(name="brandColor")
    def brand_color(self) -> Optional[pulumi.Input[str]]:
        """
        Brand color
        """
        return pulumi.get(self, "brand_color")

    @brand_color.setter
    def brand_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "brand_color", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The custom API capabilities
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="connectionParameters")
    def connection_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ConnectionParameterArgs']]]]:
        """
        Connection parameters
        """
        return pulumi.get(self, "connection_parameters")

    @connection_parameters.setter
    def connection_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ConnectionParameterArgs']]]]):
        pulumi.set(self, "connection_parameters", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The custom API description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="iconUri")
    def icon_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The icon URI
        """
        return pulumi.get(self, "icon_uri")

    @icon_uri.setter
    def icon_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_uri", value)

    @property
    @pulumi.getter(name="runtimeUrls")
    def runtime_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Runtime URLs
        """
        return pulumi.get(self, "runtime_urls")

    @runtime_urls.setter
    def runtime_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "runtime_urls", value)

    @property
    @pulumi.getter
    def swagger(self) -> Optional[Any]:
        """
        The JSON representation of the swagger
        """
        return pulumi.get(self, "swagger")

    @swagger.setter
    def swagger(self, value: Optional[Any]):
        pulumi.set(self, "swagger", value)

    @property
    @pulumi.getter(name="wsdlDefinition")
    def wsdl_definition(self) -> Optional[pulumi.Input['WsdlDefinitionArgs']]:
        """
        The WSDL definition
        """
        return pulumi.get(self, "wsdl_definition")

    @wsdl_definition.setter
    def wsdl_definition(self, value: Optional[pulumi.Input['WsdlDefinitionArgs']]):
        pulumi.set(self, "wsdl_definition", value)


@pulumi.input_type
class WsdlDefinitionArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 import_method: Optional[pulumi.Input[Union[str, 'WsdlImportMethod']]] = None,
                 service: Optional[pulumi.Input['WsdlServiceArgs']] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        The WSDL definition
        :param pulumi.Input[str] content: The WSDL content
        :param pulumi.Input[Union[str, 'WsdlImportMethod']] import_method: The WSDL import method
        :param pulumi.Input['WsdlServiceArgs'] service: The service with name and endpoint names
        :param pulumi.Input[str] url: The WSDL URL
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if import_method is not None:
            pulumi.set(__self__, "import_method", import_method)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The WSDL content
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="importMethod")
    def import_method(self) -> Optional[pulumi.Input[Union[str, 'WsdlImportMethod']]]:
        """
        The WSDL import method
        """
        return pulumi.get(self, "import_method")

    @import_method.setter
    def import_method(self, value: Optional[pulumi.Input[Union[str, 'WsdlImportMethod']]]):
        pulumi.set(self, "import_method", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input['WsdlServiceArgs']]:
        """
        The service with name and endpoint names
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input['WsdlServiceArgs']]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The WSDL URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class WsdlServiceArgs:
    def __init__(__self__, *,
                 qualified_name: pulumi.Input[str],
                 endpoint_qualified_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The service with name and endpoint names
        :param pulumi.Input[str] qualified_name: The service's qualified name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoint_qualified_names: List of the endpoints' qualified names
        """
        pulumi.set(__self__, "qualified_name", qualified_name)
        if endpoint_qualified_names is not None:
            pulumi.set(__self__, "endpoint_qualified_names", endpoint_qualified_names)

    @property
    @pulumi.getter(name="qualifiedName")
    def qualified_name(self) -> pulumi.Input[str]:
        """
        The service's qualified name
        """
        return pulumi.get(self, "qualified_name")

    @qualified_name.setter
    def qualified_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "qualified_name", value)

    @property
    @pulumi.getter(name="endpointQualifiedNames")
    def endpoint_qualified_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the endpoints' qualified names
        """
        return pulumi.get(self, "endpoint_qualified_names")

    @endpoint_qualified_names.setter
    def endpoint_qualified_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "endpoint_qualified_names", value)


@pulumi.input_type
class WsdlService:
    def __init__(__self__, *,
                 qualified_name: str,
                 endpoint_qualified_names: Optional[Sequence[str]] = None):
        """
        The service with name and endpoint names
        :param str qualified_name: The service's qualified name
        :param Sequence[str] endpoint_qualified_names: List of the endpoints' qualified names
        """
        pulumi.set(__self__, "qualified_name", qualified_name)
        if endpoint_qualified_names is not None:
            pulumi.set(__self__, "endpoint_qualified_names", endpoint_qualified_names)

    @property
    @pulumi.getter(name="qualifiedName")
    def qualified_name(self) -> str:
        """
        The service's qualified name
        """
        return pulumi.get(self, "qualified_name")

    @qualified_name.setter
    def qualified_name(self, value: str):
        pulumi.set(self, "qualified_name", value)

    @property
    @pulumi.getter(name="endpointQualifiedNames")
    def endpoint_qualified_names(self) -> Optional[Sequence[str]]:
        """
        List of the endpoints' qualified names
        """
        return pulumi.get(self, "endpoint_qualified_names")

    @endpoint_qualified_names.setter
    def endpoint_qualified_names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "endpoint_qualified_names", value)


