# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApiDefinitionInfoArgs',
    'ApplicationLogsConfigArgs',
    'AutoHealActionsArgs',
    'AutoHealCustomActionArgs',
    'AutoHealRulesArgs',
    'AutoHealTriggersArgs',
    'AzureBlobStorageApplicationLogsConfigArgs',
    'AzureBlobStorageHttpLogsConfigArgs',
    'AzureTableStorageApplicationLogsConfigArgs',
    'BackupScheduleArgs',
    'BackupSchedule',
    'CloningInfoArgs',
    'ConnStringInfoArgs',
    'ConnStringValueTypePairArgs',
    'CorsSettingsArgs',
    'DatabaseBackupSettingArgs',
    'DatabaseBackupSetting',
    'EnabledConfigArgs',
    'ExperimentsArgs',
    'FileSystemApplicationLogsConfigArgs',
    'FileSystemHttpLogsConfigArgs',
    'HandlerMappingArgs',
    'HostNameSslStateArgs',
    'HostingEnvironmentProfileArgs',
    'HttpLogsConfigArgs',
    'IpSecurityRestrictionArgs',
    'NameValuePairArgs',
    'NetworkAccessControlEntryArgs',
    'RampUpRuleArgs',
    'RequestsBasedTriggerArgs',
    'SiteConfigArgs',
    'SiteLimitsArgs',
    'SkuDescriptionArgs',
    'SlowRequestsBasedTriggerArgs',
    'StampCapacityArgs',
    'StatusCodesBasedTriggerArgs',
    'VirtualApplicationArgs',
    'VirtualDirectoryArgs',
    'VirtualIPMappingArgs',
    'VirtualNetworkProfileArgs',
    'VnetRouteArgs',
    'WorkerPoolArgs',
]

@pulumi.input_type
class ApiDefinitionInfoArgs:
    def __init__(__self__, *,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the formal API definition for the web app.
        :param pulumi.Input[str] url: The URL of the API definition.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the API definition.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ApplicationLogsConfigArgs:
    def __init__(__self__, *,
                 azure_blob_storage: Optional[pulumi.Input['AzureBlobStorageApplicationLogsConfigArgs']] = None,
                 azure_table_storage: Optional[pulumi.Input['AzureTableStorageApplicationLogsConfigArgs']] = None,
                 file_system: Optional[pulumi.Input['FileSystemApplicationLogsConfigArgs']] = None):
        """
        Application logs configuration
        :param pulumi.Input['AzureBlobStorageApplicationLogsConfigArgs'] azure_blob_storage: Application logs to blob storage configuration
        :param pulumi.Input['AzureTableStorageApplicationLogsConfigArgs'] azure_table_storage: Application logs to azure table storage configuration
        :param pulumi.Input['FileSystemApplicationLogsConfigArgs'] file_system: Application logs to file system configuration
        """
        if azure_blob_storage is not None:
            pulumi.set(__self__, "azure_blob_storage", azure_blob_storage)
        if azure_table_storage is not None:
            pulumi.set(__self__, "azure_table_storage", azure_table_storage)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)

    @property
    @pulumi.getter(name="azureBlobStorage")
    def azure_blob_storage(self) -> Optional[pulumi.Input['AzureBlobStorageApplicationLogsConfigArgs']]:
        """
        Application logs to blob storage configuration
        """
        return pulumi.get(self, "azure_blob_storage")

    @azure_blob_storage.setter
    def azure_blob_storage(self, value: Optional[pulumi.Input['AzureBlobStorageApplicationLogsConfigArgs']]):
        pulumi.set(self, "azure_blob_storage", value)

    @property
    @pulumi.getter(name="azureTableStorage")
    def azure_table_storage(self) -> Optional[pulumi.Input['AzureTableStorageApplicationLogsConfigArgs']]:
        """
        Application logs to azure table storage configuration
        """
        return pulumi.get(self, "azure_table_storage")

    @azure_table_storage.setter
    def azure_table_storage(self, value: Optional[pulumi.Input['AzureTableStorageApplicationLogsConfigArgs']]):
        pulumi.set(self, "azure_table_storage", value)

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional[pulumi.Input['FileSystemApplicationLogsConfigArgs']]:
        """
        Application logs to file system configuration
        """
        return pulumi.get(self, "file_system")

    @file_system.setter
    def file_system(self, value: Optional[pulumi.Input['FileSystemApplicationLogsConfigArgs']]):
        pulumi.set(self, "file_system", value)


@pulumi.input_type
class AutoHealActionsArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input['AutoHealActionType'],
                 custom_action: Optional[pulumi.Input['AutoHealCustomActionArgs']] = None,
                 min_process_execution_time: Optional[pulumi.Input[str]] = None):
        """
        AutoHealActions - Describes the actions which can be
                    taken by the auto-heal module when a rule is triggered.
        :param pulumi.Input['AutoHealActionType'] action_type: ActionType - predefined action to be taken
        :param pulumi.Input['AutoHealCustomActionArgs'] custom_action: CustomAction - custom action to be taken
        :param pulumi.Input[str] min_process_execution_time: MinProcessExecutionTime - minimum time the process must execute
                           before taking the action
        """
        pulumi.set(__self__, "action_type", action_type)
        if custom_action is not None:
            pulumi.set(__self__, "custom_action", custom_action)
        if min_process_execution_time is not None:
            pulumi.set(__self__, "min_process_execution_time", min_process_execution_time)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input['AutoHealActionType']:
        """
        ActionType - predefined action to be taken
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input['AutoHealActionType']):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="customAction")
    def custom_action(self) -> Optional[pulumi.Input['AutoHealCustomActionArgs']]:
        """
        CustomAction - custom action to be taken
        """
        return pulumi.get(self, "custom_action")

    @custom_action.setter
    def custom_action(self, value: Optional[pulumi.Input['AutoHealCustomActionArgs']]):
        pulumi.set(self, "custom_action", value)

    @property
    @pulumi.getter(name="minProcessExecutionTime")
    def min_process_execution_time(self) -> Optional[pulumi.Input[str]]:
        """
        MinProcessExecutionTime - minimum time the process must execute
                    before taking the action
        """
        return pulumi.get(self, "min_process_execution_time")

    @min_process_execution_time.setter
    def min_process_execution_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_process_execution_time", value)


@pulumi.input_type
class AutoHealCustomActionArgs:
    def __init__(__self__, *,
                 exe: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None):
        """
        AutoHealCustomAction - Describes the custom action to be executed
                    when an auto heal rule is triggered.
        :param pulumi.Input[str] exe: Executable to be run
        :param pulumi.Input[str] parameters: Parameters for the executable
        """
        if exe is not None:
            pulumi.set(__self__, "exe", exe)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def exe(self) -> Optional[pulumi.Input[str]]:
        """
        Executable to be run
        """
        return pulumi.get(self, "exe")

    @exe.setter
    def exe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exe", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        Parameters for the executable
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class AutoHealRulesArgs:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input['AutoHealActionsArgs']] = None,
                 triggers: Optional[pulumi.Input['AutoHealTriggersArgs']] = None):
        """
        AutoHealRules - describes the rules which can be defined for auto-heal
        :param pulumi.Input['AutoHealActionsArgs'] actions: Actions - Actions to be executed when a rule is triggered
        :param pulumi.Input['AutoHealTriggersArgs'] triggers: Triggers - Conditions that describe when to execute the auto-heal actions
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['AutoHealActionsArgs']]:
        """
        Actions - Actions to be executed when a rule is triggered
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['AutoHealActionsArgs']]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input['AutoHealTriggersArgs']]:
        """
        Triggers - Conditions that describe when to execute the auto-heal actions
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input['AutoHealTriggersArgs']]):
        pulumi.set(self, "triggers", value)


@pulumi.input_type
class AutoHealTriggersArgs:
    def __init__(__self__, *,
                 private_bytes_in_kb: Optional[pulumi.Input[int]] = None,
                 requests: Optional[pulumi.Input['RequestsBasedTriggerArgs']] = None,
                 slow_requests: Optional[pulumi.Input['SlowRequestsBasedTriggerArgs']] = None,
                 status_codes: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCodesBasedTriggerArgs']]]] = None):
        """
        AutoHealTriggers - describes the triggers for auto-heal.
        :param pulumi.Input[int] private_bytes_in_kb: PrivateBytesInKB - Defines a rule based on private bytes
        :param pulumi.Input['RequestsBasedTriggerArgs'] requests: Requests - Defines a rule based on total requests
        :param pulumi.Input['SlowRequestsBasedTriggerArgs'] slow_requests: SlowRequests - Defines a rule based on request execution time
        :param pulumi.Input[Sequence[pulumi.Input['StatusCodesBasedTriggerArgs']]] status_codes: StatusCodes - Defines a rule based on status codes
        """
        if private_bytes_in_kb is not None:
            pulumi.set(__self__, "private_bytes_in_kb", private_bytes_in_kb)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if slow_requests is not None:
            pulumi.set(__self__, "slow_requests", slow_requests)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter(name="privateBytesInKB")
    def private_bytes_in_kb(self) -> Optional[pulumi.Input[int]]:
        """
        PrivateBytesInKB - Defines a rule based on private bytes
        """
        return pulumi.get(self, "private_bytes_in_kb")

    @private_bytes_in_kb.setter
    def private_bytes_in_kb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "private_bytes_in_kb", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input['RequestsBasedTriggerArgs']]:
        """
        Requests - Defines a rule based on total requests
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input['RequestsBasedTriggerArgs']]):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter(name="slowRequests")
    def slow_requests(self) -> Optional[pulumi.Input['SlowRequestsBasedTriggerArgs']]:
        """
        SlowRequests - Defines a rule based on request execution time
        """
        return pulumi.get(self, "slow_requests")

    @slow_requests.setter
    def slow_requests(self, value: Optional[pulumi.Input['SlowRequestsBasedTriggerArgs']]):
        pulumi.set(self, "slow_requests", value)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StatusCodesBasedTriggerArgs']]]]:
        """
        StatusCodes - Defines a rule based on status codes
        """
        return pulumi.get(self, "status_codes")

    @status_codes.setter
    def status_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCodesBasedTriggerArgs']]]]):
        pulumi.set(self, "status_codes", value)


@pulumi.input_type
class AzureBlobStorageApplicationLogsConfigArgs:
    def __init__(__self__, *,
                 level: Optional[pulumi.Input['LogLevel']] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 sas_url: Optional[pulumi.Input[str]] = None):
        """
        Application logs azure blob storage configuration
        :param pulumi.Input['LogLevel'] level: Log level
        :param pulumi.Input[int] retention_in_days: Retention in days.
                           Remove blobs older than X days.
                           0 or lower means no retention.
        :param pulumi.Input[str] sas_url: SAS url to a azure blob container with read/write/list/delete permissions
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sas_url is not None:
            pulumi.set(__self__, "sas_url", sas_url)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input['LogLevel']]:
        """
        Log level
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input['LogLevel']]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Retention in days.
                    Remove blobs older than X days.
                    0 or lower means no retention.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> Optional[pulumi.Input[str]]:
        """
        SAS url to a azure blob container with read/write/list/delete permissions
        """
        return pulumi.get(self, "sas_url")

    @sas_url.setter
    def sas_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url", value)


@pulumi.input_type
class AzureBlobStorageHttpLogsConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 sas_url: Optional[pulumi.Input[str]] = None):
        """
        Http logs to azure blob storage configuration
        :param pulumi.Input[bool] enabled: Enabled
        :param pulumi.Input[int] retention_in_days: Retention in days.
                           Remove blobs older than X days.
                           0 or lower means no retention.
        :param pulumi.Input[str] sas_url: SAS url to a azure blob container with read/write/list/delete permissions
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sas_url is not None:
            pulumi.set(__self__, "sas_url", sas_url)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Retention in days.
                    Remove blobs older than X days.
                    0 or lower means no retention.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> Optional[pulumi.Input[str]]:
        """
        SAS url to a azure blob container with read/write/list/delete permissions
        """
        return pulumi.get(self, "sas_url")

    @sas_url.setter
    def sas_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url", value)


@pulumi.input_type
class AzureTableStorageApplicationLogsConfigArgs:
    def __init__(__self__, *,
                 level: Optional[pulumi.Input['LogLevel']] = None,
                 sas_url: Optional[pulumi.Input[str]] = None):
        """
        Application logs to azure table storage configuration
        :param pulumi.Input['LogLevel'] level: Log level
        :param pulumi.Input[str] sas_url: SAS url to an azure table with add/query/delete permissions
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if sas_url is not None:
            pulumi.set(__self__, "sas_url", sas_url)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input['LogLevel']]:
        """
        Log level
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input['LogLevel']]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> Optional[pulumi.Input[str]]:
        """
        SAS url to an azure table with add/query/delete permissions
        """
        return pulumi.get(self, "sas_url")

    @sas_url.setter
    def sas_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url", value)


@pulumi.input_type
class BackupScheduleArgs:
    def __init__(__self__, *,
                 frequency_unit: pulumi.Input['FrequencyUnit'],
                 frequency_interval: Optional[pulumi.Input[int]] = None,
                 keep_at_least_one_backup: Optional[pulumi.Input[bool]] = None,
                 last_execution_time: Optional[pulumi.Input[str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.
        :param pulumi.Input['FrequencyUnit'] frequency_unit: How often should be the backup executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        :param pulumi.Input[int] frequency_interval: How often should be the backup executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        :param pulumi.Input[bool] keep_at_least_one_backup: True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        :param pulumi.Input[str] last_execution_time: The last time when this schedule was triggered
        :param pulumi.Input[int] retention_period_in_days: After how many days backups should be deleted
        :param pulumi.Input[str] start_time: When the schedule should start working
        """
        pulumi.set(__self__, "frequency_unit", frequency_unit)
        if frequency_interval is not None:
            pulumi.set(__self__, "frequency_interval", frequency_interval)
        if keep_at_least_one_backup is not None:
            pulumi.set(__self__, "keep_at_least_one_backup", keep_at_least_one_backup)
        if last_execution_time is not None:
            pulumi.set(__self__, "last_execution_time", last_execution_time)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="frequencyUnit")
    def frequency_unit(self) -> pulumi.Input['FrequencyUnit']:
        """
        How often should be the backup executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        """
        return pulumi.get(self, "frequency_unit")

    @frequency_unit.setter
    def frequency_unit(self, value: pulumi.Input['FrequencyUnit']):
        pulumi.set(self, "frequency_unit", value)

    @property
    @pulumi.getter(name="frequencyInterval")
    def frequency_interval(self) -> Optional[pulumi.Input[int]]:
        """
        How often should be the backup executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        """
        return pulumi.get(self, "frequency_interval")

    @frequency_interval.setter
    def frequency_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency_interval", value)

    @property
    @pulumi.getter(name="keepAtLeastOneBackup")
    def keep_at_least_one_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        """
        return pulumi.get(self, "keep_at_least_one_backup")

    @keep_at_least_one_backup.setter
    def keep_at_least_one_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_at_least_one_backup", value)

    @property
    @pulumi.getter(name="lastExecutionTime")
    def last_execution_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last time when this schedule was triggered
        """
        return pulumi.get(self, "last_execution_time")

    @last_execution_time.setter
    def last_execution_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_execution_time", value)

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        After how many days backups should be deleted
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period_in_days", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        When the schedule should start working
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class BackupSchedule:
    def __init__(__self__, *,
                 frequency_unit: 'FrequencyUnit',
                 frequency_interval: Optional[int] = None,
                 keep_at_least_one_backup: Optional[bool] = None,
                 last_execution_time: Optional[str] = None,
                 retention_period_in_days: Optional[int] = None,
                 start_time: Optional[str] = None):
        """
        Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.
        :param 'FrequencyUnit' frequency_unit: How often should be the backup executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        :param int frequency_interval: How often should be the backup executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        :param bool keep_at_least_one_backup: True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        :param str last_execution_time: The last time when this schedule was triggered
        :param int retention_period_in_days: After how many days backups should be deleted
        :param str start_time: When the schedule should start working
        """
        pulumi.set(__self__, "frequency_unit", frequency_unit)
        if frequency_interval is not None:
            pulumi.set(__self__, "frequency_interval", frequency_interval)
        if keep_at_least_one_backup is not None:
            pulumi.set(__self__, "keep_at_least_one_backup", keep_at_least_one_backup)
        if last_execution_time is not None:
            pulumi.set(__self__, "last_execution_time", last_execution_time)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="frequencyUnit")
    def frequency_unit(self) -> 'FrequencyUnit':
        """
        How often should be the backup executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        """
        return pulumi.get(self, "frequency_unit")

    @frequency_unit.setter
    def frequency_unit(self, value: 'FrequencyUnit'):
        pulumi.set(self, "frequency_unit", value)

    @property
    @pulumi.getter(name="frequencyInterval")
    def frequency_interval(self) -> Optional[int]:
        """
        How often should be the backup executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        """
        return pulumi.get(self, "frequency_interval")

    @frequency_interval.setter
    def frequency_interval(self, value: Optional[int]):
        pulumi.set(self, "frequency_interval", value)

    @property
    @pulumi.getter(name="keepAtLeastOneBackup")
    def keep_at_least_one_backup(self) -> Optional[bool]:
        """
        True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        """
        return pulumi.get(self, "keep_at_least_one_backup")

    @keep_at_least_one_backup.setter
    def keep_at_least_one_backup(self, value: Optional[bool]):
        pulumi.set(self, "keep_at_least_one_backup", value)

    @property
    @pulumi.getter(name="lastExecutionTime")
    def last_execution_time(self) -> Optional[str]:
        """
        The last time when this schedule was triggered
        """
        return pulumi.get(self, "last_execution_time")

    @last_execution_time.setter
    def last_execution_time(self, value: Optional[str]):
        pulumi.set(self, "last_execution_time", value)

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[int]:
        """
        After how many days backups should be deleted
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: Optional[int]):
        pulumi.set(self, "retention_period_in_days", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        When the schedule should start working
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[str]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class CloningInfoArgs:
    def __init__(__self__, *,
                 app_settings_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 clone_custom_host_names: Optional[pulumi.Input[bool]] = None,
                 clone_source_control: Optional[pulumi.Input[bool]] = None,
                 configure_load_balancing: Optional[pulumi.Input[bool]] = None,
                 correlation_id: Optional[pulumi.Input[str]] = None,
                 hosting_environment: Optional[pulumi.Input[str]] = None,
                 overwrite: Optional[pulumi.Input[bool]] = None,
                 source_web_app_id: Optional[pulumi.Input[str]] = None,
                 traffic_manager_profile_id: Optional[pulumi.Input[str]] = None,
                 traffic_manager_profile_name: Optional[pulumi.Input[str]] = None):
        """
        Represents information needed for cloning operation
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] app_settings_overrides: Application settings overrides for cloned web app. If specified these settings will override the settings cloned 
                           from source web app. If not specified, application settings from source web app are retained.
        :param pulumi.Input[bool] clone_custom_host_names: If true, clone custom hostnames from source web app
        :param pulumi.Input[bool] clone_source_control: Clone source control from source web app
        :param pulumi.Input[bool] configure_load_balancing: If specified configure load balancing for source and clone site
        :param pulumi.Input[str] correlation_id: Correlation Id of cloning operation. This id ties multiple cloning operations
                           together to use the same snapshot
        :param pulumi.Input[str] hosting_environment: Hosting environment
        :param pulumi.Input[bool] overwrite: Overwrite destination web app
        :param pulumi.Input[str] source_web_app_id: ARM resource id of the source web app. Web app resource id is of the form 
                           /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and 
                           /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots
        :param pulumi.Input[str] traffic_manager_profile_id: ARM resource id of the traffic manager profile to use if it exists. Traffic manager resource id is of the form 
                           /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}
        :param pulumi.Input[str] traffic_manager_profile_name: Name of traffic manager profile to create. This is only needed if traffic manager profile does not already exist
        """
        if app_settings_overrides is not None:
            pulumi.set(__self__, "app_settings_overrides", app_settings_overrides)
        if clone_custom_host_names is not None:
            pulumi.set(__self__, "clone_custom_host_names", clone_custom_host_names)
        if clone_source_control is not None:
            pulumi.set(__self__, "clone_source_control", clone_source_control)
        if configure_load_balancing is not None:
            pulumi.set(__self__, "configure_load_balancing", configure_load_balancing)
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if hosting_environment is not None:
            pulumi.set(__self__, "hosting_environment", hosting_environment)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if source_web_app_id is not None:
            pulumi.set(__self__, "source_web_app_id", source_web_app_id)
        if traffic_manager_profile_id is not None:
            pulumi.set(__self__, "traffic_manager_profile_id", traffic_manager_profile_id)
        if traffic_manager_profile_name is not None:
            pulumi.set(__self__, "traffic_manager_profile_name", traffic_manager_profile_name)

    @property
    @pulumi.getter(name="appSettingsOverrides")
    def app_settings_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Application settings overrides for cloned web app. If specified these settings will override the settings cloned 
                    from source web app. If not specified, application settings from source web app are retained.
        """
        return pulumi.get(self, "app_settings_overrides")

    @app_settings_overrides.setter
    def app_settings_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "app_settings_overrides", value)

    @property
    @pulumi.getter(name="cloneCustomHostNames")
    def clone_custom_host_names(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, clone custom hostnames from source web app
        """
        return pulumi.get(self, "clone_custom_host_names")

    @clone_custom_host_names.setter
    def clone_custom_host_names(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "clone_custom_host_names", value)

    @property
    @pulumi.getter(name="cloneSourceControl")
    def clone_source_control(self) -> Optional[pulumi.Input[bool]]:
        """
        Clone source control from source web app
        """
        return pulumi.get(self, "clone_source_control")

    @clone_source_control.setter
    def clone_source_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "clone_source_control", value)

    @property
    @pulumi.getter(name="configureLoadBalancing")
    def configure_load_balancing(self) -> Optional[pulumi.Input[bool]]:
        """
        If specified configure load balancing for source and clone site
        """
        return pulumi.get(self, "configure_load_balancing")

    @configure_load_balancing.setter
    def configure_load_balancing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "configure_load_balancing", value)

    @property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[pulumi.Input[str]]:
        """
        Correlation Id of cloning operation. This id ties multiple cloning operations
                    together to use the same snapshot
        """
        return pulumi.get(self, "correlation_id")

    @correlation_id.setter
    def correlation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "correlation_id", value)

    @property
    @pulumi.getter(name="hostingEnvironment")
    def hosting_environment(self) -> Optional[pulumi.Input[str]]:
        """
        Hosting environment
        """
        return pulumi.get(self, "hosting_environment")

    @hosting_environment.setter
    def hosting_environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hosting_environment", value)

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        Overwrite destination web app
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite", value)

    @property
    @pulumi.getter(name="sourceWebAppId")
    def source_web_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the source web app. Web app resource id is of the form 
                    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and 
                    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots
        """
        return pulumi.get(self, "source_web_app_id")

    @source_web_app_id.setter
    def source_web_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_web_app_id", value)

    @property
    @pulumi.getter(name="trafficManagerProfileId")
    def traffic_manager_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the traffic manager profile to use if it exists. Traffic manager resource id is of the form 
                    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}
        """
        return pulumi.get(self, "traffic_manager_profile_id")

    @traffic_manager_profile_id.setter
    def traffic_manager_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_manager_profile_id", value)

    @property
    @pulumi.getter(name="trafficManagerProfileName")
    def traffic_manager_profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of traffic manager profile to create. This is only needed if traffic manager profile does not already exist
        """
        return pulumi.get(self, "traffic_manager_profile_name")

    @traffic_manager_profile_name.setter
    def traffic_manager_profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_manager_profile_name", value)


@pulumi.input_type
class ConnStringInfoArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['DatabaseServerType'],
                 connection_string: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Represents database connection string information
        :param pulumi.Input['DatabaseServerType'] type: Type of database
        :param pulumi.Input[str] connection_string: Connection string value
        :param pulumi.Input[str] name: Name of connection string
        """
        pulumi.set(__self__, "type", type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['DatabaseServerType']:
        """
        Type of database
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['DatabaseServerType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        Connection string value
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of connection string
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ConnStringValueTypePairArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['DatabaseServerType'],
                 value: Optional[pulumi.Input[str]] = None):
        """
        Database connection string value to type pair
        :param pulumi.Input['DatabaseServerType'] type: Type of database
        :param pulumi.Input[str] value: Value of pair
        """
        pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['DatabaseServerType']:
        """
        Type of database
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['DatabaseServerType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of pair
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CorsSettingsArgs:
    def __init__(__self__, *,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Cross-Origin Resource Sharing (CORS) settings for the web app.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: Gets or sets the list of origins that should be allowed to make cross-origin
                           calls (for example: http://example.com:12345). Use "*" to allow all.
        """
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the list of origins that should be allowed to make cross-origin
                    calls (for example: http://example.com:12345). Use "*" to allow all.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_origins", value)


@pulumi.input_type
class DatabaseBackupSettingArgs:
    def __init__(__self__, *,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 connection_string_name: Optional[pulumi.Input[str]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Note: properties are serialized in JSON format and stored in DB. 
                    if new properties are added they might not be in the previous data rows 
                    so please handle nulls
        :param pulumi.Input[str] connection_string: Contains a connection string to a database which is being backed up/restored. If the restore should happen to a new database, the database name inside is the new one.
        :param pulumi.Input[str] connection_string_name: Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
                           This is used during restore with overwrite connection strings options.
        :param pulumi.Input[str] database_type: SqlAzure / MySql
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_name is not None:
            pulumi.set(__self__, "connection_string_name", connection_string_name)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        Contains a connection string to a database which is being backed up/restored. If the restore should happen to a new database, the database name inside is the new one.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectionStringName")
    def connection_string_name(self) -> Optional[pulumi.Input[str]]:
        """
        Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
                    This is used during restore with overwrite connection strings options.
        """
        return pulumi.get(self, "connection_string_name")

    @connection_string_name.setter
    def connection_string_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string_name", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        """
        SqlAzure / MySql
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DatabaseBackupSetting:
    def __init__(__self__, *,
                 connection_string: Optional[str] = None,
                 connection_string_name: Optional[str] = None,
                 database_type: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Note: properties are serialized in JSON format and stored in DB. 
                    if new properties are added they might not be in the previous data rows 
                    so please handle nulls
        :param str connection_string: Contains a connection string to a database which is being backed up/restored. If the restore should happen to a new database, the database name inside is the new one.
        :param str connection_string_name: Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
                           This is used during restore with overwrite connection strings options.
        :param str database_type: SqlAzure / MySql
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_name is not None:
            pulumi.set(__self__, "connection_string_name", connection_string_name)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        Contains a connection string to a database which is being backed up/restored. If the restore should happen to a new database, the database name inside is the new one.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectionStringName")
    def connection_string_name(self) -> Optional[str]:
        """
        Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
                    This is used during restore with overwrite connection strings options.
        """
        return pulumi.get(self, "connection_string_name")

    @connection_string_name.setter
    def connection_string_name(self, value: Optional[str]):
        pulumi.set(self, "connection_string_name", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[str]:
        """
        SqlAzure / MySql
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[str]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EnabledConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Enabled configuration
        :param pulumi.Input[bool] enabled: Enabled
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ExperimentsArgs:
    def __init__(__self__, *,
                 ramp_up_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RampUpRuleArgs']]]] = None):
        """
        Class containing Routing in production experiments
        :param pulumi.Input[Sequence[pulumi.Input['RampUpRuleArgs']]] ramp_up_rules: List of {Microsoft.Web.Hosting.Administration.RampUpRule} objects.
        """
        if ramp_up_rules is not None:
            pulumi.set(__self__, "ramp_up_rules", ramp_up_rules)

    @property
    @pulumi.getter(name="rampUpRules")
    def ramp_up_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RampUpRuleArgs']]]]:
        """
        List of {Microsoft.Web.Hosting.Administration.RampUpRule} objects.
        """
        return pulumi.get(self, "ramp_up_rules")

    @ramp_up_rules.setter
    def ramp_up_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RampUpRuleArgs']]]]):
        pulumi.set(self, "ramp_up_rules", value)


@pulumi.input_type
class FileSystemApplicationLogsConfigArgs:
    def __init__(__self__, *,
                 level: Optional[pulumi.Input['LogLevel']] = None):
        """
        Application logs to file system configuration
        :param pulumi.Input['LogLevel'] level: Log level
        """
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input['LogLevel']]:
        """
        Log level
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input['LogLevel']]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class FileSystemHttpLogsConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 retention_in_mb: Optional[pulumi.Input[int]] = None):
        """
        Http logs to file system configuration
        :param pulumi.Input[bool] enabled: Enabled
        :param pulumi.Input[int] retention_in_days: Retention in days.
                           Remove files older than X days.
                           0 or lower means no retention.
        :param pulumi.Input[int] retention_in_mb: Maximum size in megabytes that http log files can use.
                           When reached old log files will be removed to make space for new ones.
                           Value can range between 25 and 100.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if retention_in_mb is not None:
            pulumi.set(__self__, "retention_in_mb", retention_in_mb)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Retention in days.
                    Remove files older than X days.
                    0 or lower means no retention.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="retentionInMb")
    def retention_in_mb(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size in megabytes that http log files can use.
                    When reached old log files will be removed to make space for new ones.
                    Value can range between 25 and 100.
        """
        return pulumi.get(self, "retention_in_mb")

    @retention_in_mb.setter
    def retention_in_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_mb", value)


@pulumi.input_type
class HandlerMappingArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[str]] = None,
                 extension: Optional[pulumi.Input[str]] = None,
                 script_processor: Optional[pulumi.Input[str]] = None):
        """
        The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
                    For example it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.
        :param pulumi.Input[str] arguments: Command-line arguments to be passed to the script processor.
        :param pulumi.Input[str] extension: Requests with this extension will be handled using the specified FastCGI application.
        :param pulumi.Input[str] script_processor: The absolute path to the FastCGI application.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if script_processor is not None:
            pulumi.set(__self__, "script_processor", script_processor)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[str]]:
        """
        Command-line arguments to be passed to the script processor.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[str]]:
        """
        Requests with this extension will be handled using the specified FastCGI application.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter(name="scriptProcessor")
    def script_processor(self) -> Optional[pulumi.Input[str]]:
        """
        The absolute path to the FastCGI application.
        """
        return pulumi.get(self, "script_processor")

    @script_processor.setter
    def script_processor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_processor", value)


@pulumi.input_type
class HostNameSslStateArgs:
    def __init__(__self__, *,
                 ssl_state: pulumi.Input['SslState'],
                 name: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None,
                 to_update: Optional[pulumi.Input[bool]] = None,
                 virtual_ip: Optional[pulumi.Input[str]] = None):
        """
        Object that represents a SSL-enabled host name.
        :param pulumi.Input['SslState'] ssl_state: SSL type
        :param pulumi.Input[str] name: Host name
        :param pulumi.Input[str] thumbprint: SSL cert thumbprint
        :param pulumi.Input[bool] to_update: Set this flag to update existing host name
        :param pulumi.Input[str] virtual_ip: Virtual IP address assigned to the host name if IP based SSL is enabled
        """
        pulumi.set(__self__, "ssl_state", ssl_state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if to_update is not None:
            pulumi.set(__self__, "to_update", to_update)
        if virtual_ip is not None:
            pulumi.set(__self__, "virtual_ip", virtual_ip)

    @property
    @pulumi.getter(name="sslState")
    def ssl_state(self) -> pulumi.Input['SslState']:
        """
        SSL type
        """
        return pulumi.get(self, "ssl_state")

    @ssl_state.setter
    def ssl_state(self, value: pulumi.Input['SslState']):
        pulumi.set(self, "ssl_state", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Host name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        SSL cert thumbprint
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter(name="toUpdate")
    def to_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this flag to update existing host name
        """
        return pulumi.get(self, "to_update")

    @to_update.setter
    def to_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "to_update", value)

    @property
    @pulumi.getter(name="virtualIP")
    def virtual_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual IP address assigned to the host name if IP based SSL is enabled
        """
        return pulumi.get(self, "virtual_ip")

    @virtual_ip.setter
    def virtual_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_ip", value)


@pulumi.input_type
class HostingEnvironmentProfileArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Specification for a hostingEnvironment (App Service Environment) to use for this resource
        :param pulumi.Input[str] id: Resource id of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] name: Name of the hostingEnvironment (App Service Environment) (read only)
        :param pulumi.Input[str] type: Resource type of the hostingEnvironment (App Service Environment) (read only)
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the hostingEnvironment (App Service Environment) (read only)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type of the hostingEnvironment (App Service Environment) (read only)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class HttpLogsConfigArgs:
    def __init__(__self__, *,
                 azure_blob_storage: Optional[pulumi.Input['AzureBlobStorageHttpLogsConfigArgs']] = None,
                 file_system: Optional[pulumi.Input['FileSystemHttpLogsConfigArgs']] = None):
        """
        Http logs configuration
        :param pulumi.Input['AzureBlobStorageHttpLogsConfigArgs'] azure_blob_storage: Http logs to azure blob storage configuration
        :param pulumi.Input['FileSystemHttpLogsConfigArgs'] file_system: Http logs to file system configuration
        """
        if azure_blob_storage is not None:
            pulumi.set(__self__, "azure_blob_storage", azure_blob_storage)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)

    @property
    @pulumi.getter(name="azureBlobStorage")
    def azure_blob_storage(self) -> Optional[pulumi.Input['AzureBlobStorageHttpLogsConfigArgs']]:
        """
        Http logs to azure blob storage configuration
        """
        return pulumi.get(self, "azure_blob_storage")

    @azure_blob_storage.setter
    def azure_blob_storage(self, value: Optional[pulumi.Input['AzureBlobStorageHttpLogsConfigArgs']]):
        pulumi.set(self, "azure_blob_storage", value)

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional[pulumi.Input['FileSystemHttpLogsConfigArgs']]:
        """
        Http logs to file system configuration
        """
        return pulumi.get(self, "file_system")

    @file_system.setter
    def file_system(self, value: Optional[pulumi.Input['FileSystemHttpLogsConfigArgs']]):
        pulumi.set(self, "file_system", value)


@pulumi.input_type
class IpSecurityRestrictionArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 subnet_mask: Optional[pulumi.Input[str]] = None):
        """
        Represents an ip security restriction on a web app.
        :param pulumi.Input[str] ip_address: IP address the security restriction is valid for
        :param pulumi.Input[str] subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address the security restriction is valid for
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet mask for the range of IP addresses the restriction is valid for
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_mask", value)


@pulumi.input_type
class NameValuePairArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Name value pair
        :param pulumi.Input[str] name: Pair name
        :param pulumi.Input[str] value: Pair value
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Pair name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Pair value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NetworkAccessControlEntryArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['AccessControlEntryAction']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 order: Optional[pulumi.Input[int]] = None,
                 remote_subnet: Optional[pulumi.Input[str]] = None):
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if remote_subnet is not None:
            pulumi.set(__self__, "remote_subnet", remote_subnet)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['AccessControlEntryAction']]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['AccessControlEntryAction']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remote_subnet")

    @remote_subnet.setter
    def remote_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_subnet", value)


@pulumi.input_type
class RampUpRuleArgs:
    def __init__(__self__, *,
                 action_host_name: Optional[pulumi.Input[str]] = None,
                 change_decision_callback_url: Optional[pulumi.Input[str]] = None,
                 change_interval_in_minutes: Optional[pulumi.Input[int]] = None,
                 change_step: Optional[pulumi.Input[float]] = None,
                 max_reroute_percentage: Optional[pulumi.Input[float]] = None,
                 min_reroute_percentage: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reroute_percentage: Optional[pulumi.Input[float]] = None):
        """
        Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance
        :param pulumi.Input[str] action_host_name: Hostname of a slot to which the traffic will be redirected if decided to. E.g. mysite-stage.azurewebsites.net
        :param pulumi.Input[str] change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback site extension which Url can be specified. See TiPCallback site extension for the scaffold and contracts.
                           https://www.siteextensions.net/packages/TiPCallback/
        :param pulumi.Input[int] change_interval_in_minutes: [Optional] Specifies interval in minutes to reevaluate ReroutePercentage
        :param pulumi.Input[float] change_step: [Optional] In auto ramp up scenario this is the step to add/remove from {Microsoft.Web.Hosting.Administration.RampUpRule.ReroutePercentage} until it reaches 
                           {Microsoft.Web.Hosting.Administration.RampUpRule.MinReroutePercentage} or {Microsoft.Web.Hosting.Administration.RampUpRule.MaxReroutePercentage}. Site metrics are checked every N minutes specified in {Microsoft.Web.Hosting.Administration.RampUpRule.ChangeIntervalInMinutes}.
                           Custom decision algorithm can be provided in TiPCallback site extension which Url can be specified in {Microsoft.Web.Hosting.Administration.RampUpRule.ChangeDecisionCallbackUrl}
        :param pulumi.Input[float] max_reroute_percentage: [Optional] Specifies upper boundary below which ReroutePercentage will stay.
        :param pulumi.Input[float] min_reroute_percentage: [Optional] Specifies lower boundary above which ReroutePercentage will stay.
        :param pulumi.Input[str] name: Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
        :param pulumi.Input[float] reroute_percentage: Percentage of the traffic which will be redirected to {Microsoft.Web.Hosting.Administration.RampUpRule.ActionHostName}
        """
        if action_host_name is not None:
            pulumi.set(__self__, "action_host_name", action_host_name)
        if change_decision_callback_url is not None:
            pulumi.set(__self__, "change_decision_callback_url", change_decision_callback_url)
        if change_interval_in_minutes is not None:
            pulumi.set(__self__, "change_interval_in_minutes", change_interval_in_minutes)
        if change_step is not None:
            pulumi.set(__self__, "change_step", change_step)
        if max_reroute_percentage is not None:
            pulumi.set(__self__, "max_reroute_percentage", max_reroute_percentage)
        if min_reroute_percentage is not None:
            pulumi.set(__self__, "min_reroute_percentage", min_reroute_percentage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reroute_percentage is not None:
            pulumi.set(__self__, "reroute_percentage", reroute_percentage)

    @property
    @pulumi.getter(name="actionHostName")
    def action_host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of a slot to which the traffic will be redirected if decided to. E.g. mysite-stage.azurewebsites.net
        """
        return pulumi.get(self, "action_host_name")

    @action_host_name.setter
    def action_host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_host_name", value)

    @property
    @pulumi.getter(name="changeDecisionCallbackUrl")
    def change_decision_callback_url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom decision algorithm can be provided in TiPCallback site extension which Url can be specified. See TiPCallback site extension for the scaffold and contracts.
                    https://www.siteextensions.net/packages/TiPCallback/
        """
        return pulumi.get(self, "change_decision_callback_url")

    @change_decision_callback_url.setter
    def change_decision_callback_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "change_decision_callback_url", value)

    @property
    @pulumi.getter(name="changeIntervalInMinutes")
    def change_interval_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        [Optional] Specifies interval in minutes to reevaluate ReroutePercentage
        """
        return pulumi.get(self, "change_interval_in_minutes")

    @change_interval_in_minutes.setter
    def change_interval_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "change_interval_in_minutes", value)

    @property
    @pulumi.getter(name="changeStep")
    def change_step(self) -> Optional[pulumi.Input[float]]:
        """
        [Optional] In auto ramp up scenario this is the step to add/remove from {Microsoft.Web.Hosting.Administration.RampUpRule.ReroutePercentage} until it reaches 
                    {Microsoft.Web.Hosting.Administration.RampUpRule.MinReroutePercentage} or {Microsoft.Web.Hosting.Administration.RampUpRule.MaxReroutePercentage}. Site metrics are checked every N minutes specified in {Microsoft.Web.Hosting.Administration.RampUpRule.ChangeIntervalInMinutes}.
                    Custom decision algorithm can be provided in TiPCallback site extension which Url can be specified in {Microsoft.Web.Hosting.Administration.RampUpRule.ChangeDecisionCallbackUrl}
        """
        return pulumi.get(self, "change_step")

    @change_step.setter
    def change_step(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "change_step", value)

    @property
    @pulumi.getter(name="maxReroutePercentage")
    def max_reroute_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        [Optional] Specifies upper boundary below which ReroutePercentage will stay.
        """
        return pulumi.get(self, "max_reroute_percentage")

    @max_reroute_percentage.setter
    def max_reroute_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_reroute_percentage", value)

    @property
    @pulumi.getter(name="minReroutePercentage")
    def min_reroute_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        [Optional] Specifies lower boundary above which ReroutePercentage will stay.
        """
        return pulumi.get(self, "min_reroute_percentage")

    @min_reroute_percentage.setter
    def min_reroute_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_reroute_percentage", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="reroutePercentage")
    def reroute_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        Percentage of the traffic which will be redirected to {Microsoft.Web.Hosting.Administration.RampUpRule.ActionHostName}
        """
        return pulumi.get(self, "reroute_percentage")

    @reroute_percentage.setter
    def reroute_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "reroute_percentage", value)


@pulumi.input_type
class RequestsBasedTriggerArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 time_interval: Optional[pulumi.Input[str]] = None):
        """
        RequestsBasedTrigger
        :param pulumi.Input[int] count: Count
        :param pulumi.Input[str] time_interval: TimeInterval
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[pulumi.Input[str]]:
        """
        TimeInterval
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_interval", value)


@pulumi.input_type
class SiteConfigArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 always_on: Optional[pulumi.Input[bool]] = None,
                 api_definition: Optional[pulumi.Input['ApiDefinitionInfoArgs']] = None,
                 app_command_line: Optional[pulumi.Input[str]] = None,
                 app_settings: Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]] = None,
                 auto_heal_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_heal_rules: Optional[pulumi.Input['AutoHealRulesArgs']] = None,
                 auto_swap_slot_name: Optional[pulumi.Input[str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['ConnStringInfoArgs']]]] = None,
                 cors: Optional[pulumi.Input['CorsSettingsArgs']] = None,
                 default_documents: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 detailed_error_logging_enabled: Optional[pulumi.Input[bool]] = None,
                 document_root: Optional[pulumi.Input[str]] = None,
                 experiments: Optional[pulumi.Input['ExperimentsArgs']] = None,
                 handler_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['HandlerMappingArgs']]]] = None,
                 http_logging_enabled: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_security_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]]] = None,
                 java_container: Optional[pulumi.Input[str]] = None,
                 java_container_version: Optional[pulumi.Input[str]] = None,
                 java_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 limits: Optional[pulumi.Input['SiteLimitsArgs']] = None,
                 load_balancing: Optional[pulumi.Input['SiteLoadBalancing']] = None,
                 local_my_sql_enabled: Optional[pulumi.Input[bool]] = None,
                 logs_directory_size_limit: Optional[pulumi.Input[int]] = None,
                 managed_pipeline_mode: Optional[pulumi.Input['ManagedPipelineMode']] = None,
                 metadata: Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 net_framework_version: Optional[pulumi.Input[str]] = None,
                 node_version: Optional[pulumi.Input[str]] = None,
                 number_of_workers: Optional[pulumi.Input[int]] = None,
                 php_version: Optional[pulumi.Input[str]] = None,
                 publishing_password: Optional[pulumi.Input[str]] = None,
                 publishing_username: Optional[pulumi.Input[str]] = None,
                 python_version: Optional[pulumi.Input[str]] = None,
                 remote_debugging_enabled: Optional[pulumi.Input[bool]] = None,
                 remote_debugging_version: Optional[pulumi.Input[str]] = None,
                 request_tracing_enabled: Optional[pulumi.Input[bool]] = None,
                 request_tracing_expiration_time: Optional[pulumi.Input[str]] = None,
                 scm_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tracing_options: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 use32_bit_worker_process: Optional[pulumi.Input[bool]] = None,
                 virtual_applications: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualApplicationArgs']]]] = None,
                 vnet_name: Optional[pulumi.Input[str]] = None,
                 web_sockets_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration of Azure web site
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[bool] always_on: Always On
        :param pulumi.Input['ApiDefinitionInfoArgs'] api_definition: Information about the formal API definition for the web app.
        :param pulumi.Input[str] app_command_line: App Command Line to launch
        :param pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]] app_settings: Application Settings
        :param pulumi.Input[bool] auto_heal_enabled: Auto heal enabled
        :param pulumi.Input['AutoHealRulesArgs'] auto_heal_rules: Auto heal rules
        :param pulumi.Input[str] auto_swap_slot_name: Auto swap slot name
        :param pulumi.Input[Sequence[pulumi.Input['ConnStringInfoArgs']]] connection_strings: Connection strings
        :param pulumi.Input['CorsSettingsArgs'] cors: Cross-Origin Resource Sharing (CORS) settings.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_documents: Default documents
        :param pulumi.Input[bool] detailed_error_logging_enabled: Detailed error logging enabled
        :param pulumi.Input[str] document_root: Document root
        :param pulumi.Input['ExperimentsArgs'] experiments: This is work around for polymorphic types
        :param pulumi.Input[Sequence[pulumi.Input['HandlerMappingArgs']]] handler_mappings: Handler mappings
        :param pulumi.Input[bool] http_logging_enabled: HTTP logging Enabled
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]] ip_security_restrictions: Ip Security restrictions
        :param pulumi.Input[str] java_container: Java container
        :param pulumi.Input[str] java_container_version: Java container version
        :param pulumi.Input[str] java_version: Java version
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input['SiteLimitsArgs'] limits: Site limits
        :param pulumi.Input['SiteLoadBalancing'] load_balancing: Site load balancing
        :param pulumi.Input[bool] local_my_sql_enabled: Local mysql enabled
        :param pulumi.Input[int] logs_directory_size_limit: HTTP Logs Directory size limit
        :param pulumi.Input['ManagedPipelineMode'] managed_pipeline_mode: Managed pipeline mode
        :param pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]] metadata: Site Metadata
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[str] net_framework_version: Net Framework Version
        :param pulumi.Input[str] node_version: Version of Node
        :param pulumi.Input[int] number_of_workers: Number of workers
        :param pulumi.Input[str] php_version: Version of PHP
        :param pulumi.Input[str] publishing_password: Publishing password
        :param pulumi.Input[str] publishing_username: Publishing user name
        :param pulumi.Input[str] python_version: Version of Python
        :param pulumi.Input[bool] remote_debugging_enabled: Remote Debugging Enabled
        :param pulumi.Input[str] remote_debugging_version: Remote Debugging Version
        :param pulumi.Input[bool] request_tracing_enabled: Enable request tracing
        :param pulumi.Input[str] request_tracing_expiration_time: Request tracing expiration time
        :param pulumi.Input[str] scm_type: SCM type
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] tracing_options: Tracing options
        :param pulumi.Input[str] type: Resource type
        :param pulumi.Input[bool] use32_bit_worker_process: Use 32 bit worker process
        :param pulumi.Input[Sequence[pulumi.Input['VirtualApplicationArgs']]] virtual_applications: Virtual applications
        :param pulumi.Input[str] vnet_name: Vnet name
        :param pulumi.Input[bool] web_sockets_enabled: Web socket enabled.
        """
        pulumi.set(__self__, "location", location)
        if always_on is not None:
            pulumi.set(__self__, "always_on", always_on)
        if api_definition is not None:
            pulumi.set(__self__, "api_definition", api_definition)
        if app_command_line is not None:
            pulumi.set(__self__, "app_command_line", app_command_line)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auto_heal_enabled is not None:
            pulumi.set(__self__, "auto_heal_enabled", auto_heal_enabled)
        if auto_heal_rules is not None:
            pulumi.set(__self__, "auto_heal_rules", auto_heal_rules)
        if auto_swap_slot_name is not None:
            pulumi.set(__self__, "auto_swap_slot_name", auto_swap_slot_name)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if default_documents is not None:
            pulumi.set(__self__, "default_documents", default_documents)
        if detailed_error_logging_enabled is not None:
            pulumi.set(__self__, "detailed_error_logging_enabled", detailed_error_logging_enabled)
        if document_root is not None:
            pulumi.set(__self__, "document_root", document_root)
        if experiments is not None:
            pulumi.set(__self__, "experiments", experiments)
        if handler_mappings is not None:
            pulumi.set(__self__, "handler_mappings", handler_mappings)
        if http_logging_enabled is not None:
            pulumi.set(__self__, "http_logging_enabled", http_logging_enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_security_restrictions is not None:
            pulumi.set(__self__, "ip_security_restrictions", ip_security_restrictions)
        if java_container is not None:
            pulumi.set(__self__, "java_container", java_container)
        if java_container_version is not None:
            pulumi.set(__self__, "java_container_version", java_container_version)
        if java_version is not None:
            pulumi.set(__self__, "java_version", java_version)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if load_balancing is not None:
            pulumi.set(__self__, "load_balancing", load_balancing)
        if local_my_sql_enabled is not None:
            pulumi.set(__self__, "local_my_sql_enabled", local_my_sql_enabled)
        if logs_directory_size_limit is not None:
            pulumi.set(__self__, "logs_directory_size_limit", logs_directory_size_limit)
        if managed_pipeline_mode is not None:
            pulumi.set(__self__, "managed_pipeline_mode", managed_pipeline_mode)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if net_framework_version is not None:
            pulumi.set(__self__, "net_framework_version", net_framework_version)
        if node_version is not None:
            pulumi.set(__self__, "node_version", node_version)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if php_version is not None:
            pulumi.set(__self__, "php_version", php_version)
        if publishing_password is not None:
            pulumi.set(__self__, "publishing_password", publishing_password)
        if publishing_username is not None:
            pulumi.set(__self__, "publishing_username", publishing_username)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)
        if remote_debugging_enabled is not None:
            pulumi.set(__self__, "remote_debugging_enabled", remote_debugging_enabled)
        if remote_debugging_version is not None:
            pulumi.set(__self__, "remote_debugging_version", remote_debugging_version)
        if request_tracing_enabled is not None:
            pulumi.set(__self__, "request_tracing_enabled", request_tracing_enabled)
        if request_tracing_expiration_time is not None:
            pulumi.set(__self__, "request_tracing_expiration_time", request_tracing_expiration_time)
        if scm_type is not None:
            pulumi.set(__self__, "scm_type", scm_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tracing_options is not None:
            pulumi.set(__self__, "tracing_options", tracing_options)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if use32_bit_worker_process is not None:
            pulumi.set(__self__, "use32_bit_worker_process", use32_bit_worker_process)
        if virtual_applications is not None:
            pulumi.set(__self__, "virtual_applications", virtual_applications)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)
        if web_sockets_enabled is not None:
            pulumi.set(__self__, "web_sockets_enabled", web_sockets_enabled)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="alwaysOn")
    def always_on(self) -> Optional[pulumi.Input[bool]]:
        """
        Always On
        """
        return pulumi.get(self, "always_on")

    @always_on.setter
    def always_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_on", value)

    @property
    @pulumi.getter(name="apiDefinition")
    def api_definition(self) -> Optional[pulumi.Input['ApiDefinitionInfoArgs']]:
        """
        Information about the formal API definition for the web app.
        """
        return pulumi.get(self, "api_definition")

    @api_definition.setter
    def api_definition(self, value: Optional[pulumi.Input['ApiDefinitionInfoArgs']]):
        pulumi.set(self, "api_definition", value)

    @property
    @pulumi.getter(name="appCommandLine")
    def app_command_line(self) -> Optional[pulumi.Input[str]]:
        """
        App Command Line to launch
        """
        return pulumi.get(self, "app_command_line")

    @app_command_line.setter
    def app_command_line(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_command_line", value)

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]]:
        """
        Application Settings
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]]):
        pulumi.set(self, "app_settings", value)

    @property
    @pulumi.getter(name="autoHealEnabled")
    def auto_heal_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Auto heal enabled
        """
        return pulumi.get(self, "auto_heal_enabled")

    @auto_heal_enabled.setter
    def auto_heal_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_heal_enabled", value)

    @property
    @pulumi.getter(name="autoHealRules")
    def auto_heal_rules(self) -> Optional[pulumi.Input['AutoHealRulesArgs']]:
        """
        Auto heal rules
        """
        return pulumi.get(self, "auto_heal_rules")

    @auto_heal_rules.setter
    def auto_heal_rules(self, value: Optional[pulumi.Input['AutoHealRulesArgs']]):
        pulumi.set(self, "auto_heal_rules", value)

    @property
    @pulumi.getter(name="autoSwapSlotName")
    def auto_swap_slot_name(self) -> Optional[pulumi.Input[str]]:
        """
        Auto swap slot name
        """
        return pulumi.get(self, "auto_swap_slot_name")

    @auto_swap_slot_name.setter
    def auto_swap_slot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_swap_slot_name", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnStringInfoArgs']]]]:
        """
        Connection strings
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnStringInfoArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['CorsSettingsArgs']]:
        """
        Cross-Origin Resource Sharing (CORS) settings.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['CorsSettingsArgs']]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter(name="defaultDocuments")
    def default_documents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Default documents
        """
        return pulumi.get(self, "default_documents")

    @default_documents.setter
    def default_documents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "default_documents", value)

    @property
    @pulumi.getter(name="detailedErrorLoggingEnabled")
    def detailed_error_logging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Detailed error logging enabled
        """
        return pulumi.get(self, "detailed_error_logging_enabled")

    @detailed_error_logging_enabled.setter
    def detailed_error_logging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "detailed_error_logging_enabled", value)

    @property
    @pulumi.getter(name="documentRoot")
    def document_root(self) -> Optional[pulumi.Input[str]]:
        """
        Document root
        """
        return pulumi.get(self, "document_root")

    @document_root.setter
    def document_root(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_root", value)

    @property
    @pulumi.getter
    def experiments(self) -> Optional[pulumi.Input['ExperimentsArgs']]:
        """
        This is work around for polymorphic types
        """
        return pulumi.get(self, "experiments")

    @experiments.setter
    def experiments(self, value: Optional[pulumi.Input['ExperimentsArgs']]):
        pulumi.set(self, "experiments", value)

    @property
    @pulumi.getter(name="handlerMappings")
    def handler_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HandlerMappingArgs']]]]:
        """
        Handler mappings
        """
        return pulumi.get(self, "handler_mappings")

    @handler_mappings.setter
    def handler_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HandlerMappingArgs']]]]):
        pulumi.set(self, "handler_mappings", value)

    @property
    @pulumi.getter(name="httpLoggingEnabled")
    def http_logging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        HTTP logging Enabled
        """
        return pulumi.get(self, "http_logging_enabled")

    @http_logging_enabled.setter
    def http_logging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_logging_enabled", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipSecurityRestrictions")
    def ip_security_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]]]:
        """
        Ip Security restrictions
        """
        return pulumi.get(self, "ip_security_restrictions")

    @ip_security_restrictions.setter
    def ip_security_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionArgs']]]]):
        pulumi.set(self, "ip_security_restrictions", value)

    @property
    @pulumi.getter(name="javaContainer")
    def java_container(self) -> Optional[pulumi.Input[str]]:
        """
        Java container
        """
        return pulumi.get(self, "java_container")

    @java_container.setter
    def java_container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "java_container", value)

    @property
    @pulumi.getter(name="javaContainerVersion")
    def java_container_version(self) -> Optional[pulumi.Input[str]]:
        """
        Java container version
        """
        return pulumi.get(self, "java_container_version")

    @java_container_version.setter
    def java_container_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "java_container_version", value)

    @property
    @pulumi.getter(name="javaVersion")
    def java_version(self) -> Optional[pulumi.Input[str]]:
        """
        Java version
        """
        return pulumi.get(self, "java_version")

    @java_version.setter
    def java_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "java_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['SiteLimitsArgs']]:
        """
        Site limits
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['SiteLimitsArgs']]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> Optional[pulumi.Input['SiteLoadBalancing']]:
        """
        Site load balancing
        """
        return pulumi.get(self, "load_balancing")

    @load_balancing.setter
    def load_balancing(self, value: Optional[pulumi.Input['SiteLoadBalancing']]):
        pulumi.set(self, "load_balancing", value)

    @property
    @pulumi.getter(name="localMySqlEnabled")
    def local_my_sql_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Local mysql enabled
        """
        return pulumi.get(self, "local_my_sql_enabled")

    @local_my_sql_enabled.setter
    def local_my_sql_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local_my_sql_enabled", value)

    @property
    @pulumi.getter(name="logsDirectorySizeLimit")
    def logs_directory_size_limit(self) -> Optional[pulumi.Input[int]]:
        """
        HTTP Logs Directory size limit
        """
        return pulumi.get(self, "logs_directory_size_limit")

    @logs_directory_size_limit.setter
    def logs_directory_size_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "logs_directory_size_limit", value)

    @property
    @pulumi.getter(name="managedPipelineMode")
    def managed_pipeline_mode(self) -> Optional[pulumi.Input['ManagedPipelineMode']]:
        """
        Managed pipeline mode
        """
        return pulumi.get(self, "managed_pipeline_mode")

    @managed_pipeline_mode.setter
    def managed_pipeline_mode(self, value: Optional[pulumi.Input['ManagedPipelineMode']]):
        pulumi.set(self, "managed_pipeline_mode", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]]:
        """
        Site Metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="netFrameworkVersion")
    def net_framework_version(self) -> Optional[pulumi.Input[str]]:
        """
        Net Framework Version
        """
        return pulumi.get(self, "net_framework_version")

    @net_framework_version.setter
    def net_framework_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_framework_version", value)

    @property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of Node
        """
        return pulumi.get(self, "node_version")

    @node_version.setter
    def node_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_version", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[int]]:
        """
        Number of workers
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter(name="phpVersion")
    def php_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of PHP
        """
        return pulumi.get(self, "php_version")

    @php_version.setter
    def php_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "php_version", value)

    @property
    @pulumi.getter(name="publishingPassword")
    def publishing_password(self) -> Optional[pulumi.Input[str]]:
        """
        Publishing password
        """
        return pulumi.get(self, "publishing_password")

    @publishing_password.setter
    def publishing_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publishing_password", value)

    @property
    @pulumi.getter(name="publishingUsername")
    def publishing_username(self) -> Optional[pulumi.Input[str]]:
        """
        Publishing user name
        """
        return pulumi.get(self, "publishing_username")

    @publishing_username.setter
    def publishing_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publishing_username", value)

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of Python
        """
        return pulumi.get(self, "python_version")

    @python_version.setter
    def python_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "python_version", value)

    @property
    @pulumi.getter(name="remoteDebuggingEnabled")
    def remote_debugging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Remote Debugging Enabled
        """
        return pulumi.get(self, "remote_debugging_enabled")

    @remote_debugging_enabled.setter
    def remote_debugging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remote_debugging_enabled", value)

    @property
    @pulumi.getter(name="remoteDebuggingVersion")
    def remote_debugging_version(self) -> Optional[pulumi.Input[str]]:
        """
        Remote Debugging Version
        """
        return pulumi.get(self, "remote_debugging_version")

    @remote_debugging_version.setter
    def remote_debugging_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_debugging_version", value)

    @property
    @pulumi.getter(name="requestTracingEnabled")
    def request_tracing_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable request tracing
        """
        return pulumi.get(self, "request_tracing_enabled")

    @request_tracing_enabled.setter
    def request_tracing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_tracing_enabled", value)

    @property
    @pulumi.getter(name="requestTracingExpirationTime")
    def request_tracing_expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        Request tracing expiration time
        """
        return pulumi.get(self, "request_tracing_expiration_time")

    @request_tracing_expiration_time.setter
    def request_tracing_expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_tracing_expiration_time", value)

    @property
    @pulumi.getter(name="scmType")
    def scm_type(self) -> Optional[pulumi.Input[str]]:
        """
        SCM type
        """
        return pulumi.get(self, "scm_type")

    @scm_type.setter
    def scm_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scm_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tracingOptions")
    def tracing_options(self) -> Optional[pulumi.Input[str]]:
        """
        Tracing options
        """
        return pulumi.get(self, "tracing_options")

    @tracing_options.setter
    def tracing_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracing_options", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="use32BitWorkerProcess")
    def use32_bit_worker_process(self) -> Optional[pulumi.Input[bool]]:
        """
        Use 32 bit worker process
        """
        return pulumi.get(self, "use32_bit_worker_process")

    @use32_bit_worker_process.setter
    def use32_bit_worker_process(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use32_bit_worker_process", value)

    @property
    @pulumi.getter(name="virtualApplications")
    def virtual_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualApplicationArgs']]]]:
        """
        Virtual applications
        """
        return pulumi.get(self, "virtual_applications")

    @virtual_applications.setter
    def virtual_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualApplicationArgs']]]]):
        pulumi.set(self, "virtual_applications", value)

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        Vnet name
        """
        return pulumi.get(self, "vnet_name")

    @vnet_name.setter
    def vnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_name", value)

    @property
    @pulumi.getter(name="webSocketsEnabled")
    def web_sockets_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Web socket enabled.
        """
        return pulumi.get(self, "web_sockets_enabled")

    @web_sockets_enabled.setter
    def web_sockets_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "web_sockets_enabled", value)


@pulumi.input_type
class SiteLimitsArgs:
    def __init__(__self__, *,
                 max_disk_size_in_mb: Optional[pulumi.Input[float]] = None,
                 max_memory_in_mb: Optional[pulumi.Input[float]] = None,
                 max_percentage_cpu: Optional[pulumi.Input[float]] = None):
        """
        Represents metric limits set on a web app.
        :param pulumi.Input[float] max_disk_size_in_mb: Maximum allowed disk size usage in MB
        :param pulumi.Input[float] max_memory_in_mb: Maximum allowed memory usage in MB
        :param pulumi.Input[float] max_percentage_cpu: Maximum allowed CPU usage percentage
        """
        if max_disk_size_in_mb is not None:
            pulumi.set(__self__, "max_disk_size_in_mb", max_disk_size_in_mb)
        if max_memory_in_mb is not None:
            pulumi.set(__self__, "max_memory_in_mb", max_memory_in_mb)
        if max_percentage_cpu is not None:
            pulumi.set(__self__, "max_percentage_cpu", max_percentage_cpu)

    @property
    @pulumi.getter(name="maxDiskSizeInMb")
    def max_disk_size_in_mb(self) -> Optional[pulumi.Input[float]]:
        """
        Maximum allowed disk size usage in MB
        """
        return pulumi.get(self, "max_disk_size_in_mb")

    @max_disk_size_in_mb.setter
    def max_disk_size_in_mb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_disk_size_in_mb", value)

    @property
    @pulumi.getter(name="maxMemoryInMb")
    def max_memory_in_mb(self) -> Optional[pulumi.Input[float]]:
        """
        Maximum allowed memory usage in MB
        """
        return pulumi.get(self, "max_memory_in_mb")

    @max_memory_in_mb.setter
    def max_memory_in_mb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_memory_in_mb", value)

    @property
    @pulumi.getter(name="maxPercentageCpu")
    def max_percentage_cpu(self) -> Optional[pulumi.Input[float]]:
        """
        Maximum allowed CPU usage percentage
        """
        return pulumi.get(self, "max_percentage_cpu")

    @max_percentage_cpu.setter
    def max_percentage_cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_percentage_cpu", value)


@pulumi.input_type
class SkuDescriptionArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Describes a sku for a scalable resource
        :param pulumi.Input[int] capacity: Current number of instances assigned to the resource
        :param pulumi.Input[str] family: Family code of the resource sku
        :param pulumi.Input[str] name: Name of the resource sku
        :param pulumi.Input[str] size: Size specifier of the resource sku
        :param pulumi.Input[str] tier: Service Tier of the resource sku
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Current number of instances assigned to the resource
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        Family code of the resource sku
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource sku
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Size specifier of the resource sku
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Service Tier of the resource sku
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SlowRequestsBasedTriggerArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 time_interval: Optional[pulumi.Input[str]] = None,
                 time_taken: Optional[pulumi.Input[str]] = None):
        """
        SlowRequestsBasedTrigger
        :param pulumi.Input[int] count: Count
        :param pulumi.Input[str] time_interval: TimeInterval
        :param pulumi.Input[str] time_taken: TimeTaken
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)
        if time_taken is not None:
            pulumi.set(__self__, "time_taken", time_taken)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[pulumi.Input[str]]:
        """
        TimeInterval
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_interval", value)

    @property
    @pulumi.getter(name="timeTaken")
    def time_taken(self) -> Optional[pulumi.Input[str]]:
        """
        TimeTaken
        """
        return pulumi.get(self, "time_taken")

    @time_taken.setter
    def time_taken(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_taken", value)


@pulumi.input_type
class StampCapacityArgs:
    def __init__(__self__, *,
                 available_capacity: Optional[pulumi.Input[float]] = None,
                 compute_mode: Optional[pulumi.Input['ComputeModeOptions']] = None,
                 exclude_from_capacity_allocation: Optional[pulumi.Input[bool]] = None,
                 is_applicable_for_all_compute_modes: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 site_mode: Optional[pulumi.Input[str]] = None,
                 total_capacity: Optional[pulumi.Input[float]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 worker_size: Optional[pulumi.Input['WorkerSizeOptions']] = None,
                 worker_size_id: Optional[pulumi.Input[int]] = None):
        """
        Class containing stamp capacity information
        :param pulumi.Input[float] available_capacity: Available capacity (# of machines, bytes of storage etc...)
        :param pulumi.Input['ComputeModeOptions'] compute_mode: Shared/Dedicated workers
        :param pulumi.Input[bool] exclude_from_capacity_allocation: If true it includes basic sites
                           Basic sites are not used for capacity allocation.
        :param pulumi.Input[bool] is_applicable_for_all_compute_modes: Is capacity applicable for all sites?
        :param pulumi.Input[str] name: Name of the stamp
        :param pulumi.Input[str] site_mode: Shared or Dedicated
        :param pulumi.Input[float] total_capacity: Total capacity (# of machines, bytes of storage etc...)
        :param pulumi.Input[str] unit: Name of the unit
        :param pulumi.Input['WorkerSizeOptions'] worker_size: Size of the machines
        :param pulumi.Input[int] worker_size_id: Size Id of machines: 
                           0 - Small
                           1 - Medium
                           2 - Large
        """
        if available_capacity is not None:
            pulumi.set(__self__, "available_capacity", available_capacity)
        if compute_mode is not None:
            pulumi.set(__self__, "compute_mode", compute_mode)
        if exclude_from_capacity_allocation is not None:
            pulumi.set(__self__, "exclude_from_capacity_allocation", exclude_from_capacity_allocation)
        if is_applicable_for_all_compute_modes is not None:
            pulumi.set(__self__, "is_applicable_for_all_compute_modes", is_applicable_for_all_compute_modes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if site_mode is not None:
            pulumi.set(__self__, "site_mode", site_mode)
        if total_capacity is not None:
            pulumi.set(__self__, "total_capacity", total_capacity)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if worker_size is not None:
            pulumi.set(__self__, "worker_size", worker_size)
        if worker_size_id is not None:
            pulumi.set(__self__, "worker_size_id", worker_size_id)

    @property
    @pulumi.getter(name="availableCapacity")
    def available_capacity(self) -> Optional[pulumi.Input[float]]:
        """
        Available capacity (# of machines, bytes of storage etc...)
        """
        return pulumi.get(self, "available_capacity")

    @available_capacity.setter
    def available_capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "available_capacity", value)

    @property
    @pulumi.getter(name="computeMode")
    def compute_mode(self) -> Optional[pulumi.Input['ComputeModeOptions']]:
        """
        Shared/Dedicated workers
        """
        return pulumi.get(self, "compute_mode")

    @compute_mode.setter
    def compute_mode(self, value: Optional[pulumi.Input['ComputeModeOptions']]):
        pulumi.set(self, "compute_mode", value)

    @property
    @pulumi.getter(name="excludeFromCapacityAllocation")
    def exclude_from_capacity_allocation(self) -> Optional[pulumi.Input[bool]]:
        """
        If true it includes basic sites
                    Basic sites are not used for capacity allocation.
        """
        return pulumi.get(self, "exclude_from_capacity_allocation")

    @exclude_from_capacity_allocation.setter
    def exclude_from_capacity_allocation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_from_capacity_allocation", value)

    @property
    @pulumi.getter(name="isApplicableForAllComputeModes")
    def is_applicable_for_all_compute_modes(self) -> Optional[pulumi.Input[bool]]:
        """
        Is capacity applicable for all sites?
        """
        return pulumi.get(self, "is_applicable_for_all_compute_modes")

    @is_applicable_for_all_compute_modes.setter
    def is_applicable_for_all_compute_modes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_applicable_for_all_compute_modes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the stamp
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="siteMode")
    def site_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Shared or Dedicated
        """
        return pulumi.get(self, "site_mode")

    @site_mode.setter
    def site_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_mode", value)

    @property
    @pulumi.getter(name="totalCapacity")
    def total_capacity(self) -> Optional[pulumi.Input[float]]:
        """
        Total capacity (# of machines, bytes of storage etc...)
        """
        return pulumi.get(self, "total_capacity")

    @total_capacity.setter
    def total_capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_capacity", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the unit
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter(name="workerSize")
    def worker_size(self) -> Optional[pulumi.Input['WorkerSizeOptions']]:
        """
        Size of the machines
        """
        return pulumi.get(self, "worker_size")

    @worker_size.setter
    def worker_size(self, value: Optional[pulumi.Input['WorkerSizeOptions']]):
        pulumi.set(self, "worker_size", value)

    @property
    @pulumi.getter(name="workerSizeId")
    def worker_size_id(self) -> Optional[pulumi.Input[int]]:
        """
        Size Id of machines: 
                    0 - Small
                    1 - Medium
                    2 - Large
        """
        return pulumi.get(self, "worker_size_id")

    @worker_size_id.setter
    def worker_size_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "worker_size_id", value)


@pulumi.input_type
class StatusCodesBasedTriggerArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 sub_status: Optional[pulumi.Input[int]] = None,
                 time_interval: Optional[pulumi.Input[str]] = None,
                 win32_status: Optional[pulumi.Input[int]] = None):
        """
        StatusCodeBasedTrigger
        :param pulumi.Input[int] count: Count
        :param pulumi.Input[int] status: HTTP status code
        :param pulumi.Input[int] sub_status: SubStatus
        :param pulumi.Input[str] time_interval: TimeInterval
        :param pulumi.Input[int] win32_status: Win32 error code
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_status is not None:
            pulumi.set(__self__, "sub_status", sub_status)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)
        if win32_status is not None:
            pulumi.set(__self__, "win32_status", win32_status)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        HTTP status code
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> Optional[pulumi.Input[int]]:
        """
        SubStatus
        """
        return pulumi.get(self, "sub_status")

    @sub_status.setter
    def sub_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sub_status", value)

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[pulumi.Input[str]]:
        """
        TimeInterval
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_interval", value)

    @property
    @pulumi.getter(name="win32Status")
    def win32_status(self) -> Optional[pulumi.Input[int]]:
        """
        Win32 error code
        """
        return pulumi.get(self, "win32_status")

    @win32_status.setter
    def win32_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "win32_status", value)


@pulumi.input_type
class VirtualApplicationArgs:
    def __init__(__self__, *,
                 physical_path: Optional[pulumi.Input[str]] = None,
                 preload_enabled: Optional[pulumi.Input[bool]] = None,
                 virtual_directories: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualDirectoryArgs']]]] = None,
                 virtual_path: Optional[pulumi.Input[str]] = None):
        if physical_path is not None:
            pulumi.set(__self__, "physical_path", physical_path)
        if preload_enabled is not None:
            pulumi.set(__self__, "preload_enabled", preload_enabled)
        if virtual_directories is not None:
            pulumi.set(__self__, "virtual_directories", virtual_directories)
        if virtual_path is not None:
            pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter(name="physicalPath")
    def physical_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "physical_path")

    @physical_path.setter
    def physical_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_path", value)

    @property
    @pulumi.getter(name="preloadEnabled")
    def preload_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "preload_enabled")

    @preload_enabled.setter
    def preload_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preload_enabled", value)

    @property
    @pulumi.getter(name="virtualDirectories")
    def virtual_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualDirectoryArgs']]]]:
        return pulumi.get(self, "virtual_directories")

    @virtual_directories.setter
    def virtual_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualDirectoryArgs']]]]):
        pulumi.set(self, "virtual_directories", value)

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "virtual_path")

    @virtual_path.setter
    def virtual_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_path", value)


@pulumi.input_type
class VirtualDirectoryArgs:
    def __init__(__self__, *,
                 physical_path: Optional[pulumi.Input[str]] = None,
                 virtual_path: Optional[pulumi.Input[str]] = None):
        if physical_path is not None:
            pulumi.set(__self__, "physical_path", physical_path)
        if virtual_path is not None:
            pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter(name="physicalPath")
    def physical_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "physical_path")

    @physical_path.setter
    def physical_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_path", value)

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "virtual_path")

    @virtual_path.setter
    def virtual_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_path", value)


@pulumi.input_type
class VirtualIPMappingArgs:
    def __init__(__self__, *,
                 in_use: Optional[pulumi.Input[bool]] = None,
                 internal_http_port: Optional[pulumi.Input[int]] = None,
                 internal_https_port: Optional[pulumi.Input[int]] = None,
                 virtual_ip: Optional[pulumi.Input[str]] = None):
        """
        Class that represents a VIP mapping
        :param pulumi.Input[bool] in_use: Is VIP mapping in use
        :param pulumi.Input[int] internal_http_port: Internal HTTP port
        :param pulumi.Input[int] internal_https_port: Internal HTTPS port
        :param pulumi.Input[str] virtual_ip: Virtual IP address
        """
        if in_use is not None:
            pulumi.set(__self__, "in_use", in_use)
        if internal_http_port is not None:
            pulumi.set(__self__, "internal_http_port", internal_http_port)
        if internal_https_port is not None:
            pulumi.set(__self__, "internal_https_port", internal_https_port)
        if virtual_ip is not None:
            pulumi.set(__self__, "virtual_ip", virtual_ip)

    @property
    @pulumi.getter(name="inUse")
    def in_use(self) -> Optional[pulumi.Input[bool]]:
        """
        Is VIP mapping in use
        """
        return pulumi.get(self, "in_use")

    @in_use.setter
    def in_use(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "in_use", value)

    @property
    @pulumi.getter(name="internalHttpPort")
    def internal_http_port(self) -> Optional[pulumi.Input[int]]:
        """
        Internal HTTP port
        """
        return pulumi.get(self, "internal_http_port")

    @internal_http_port.setter
    def internal_http_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internal_http_port", value)

    @property
    @pulumi.getter(name="internalHttpsPort")
    def internal_https_port(self) -> Optional[pulumi.Input[int]]:
        """
        Internal HTTPS port
        """
        return pulumi.get(self, "internal_https_port")

    @internal_https_port.setter
    def internal_https_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internal_https_port", value)

    @property
    @pulumi.getter(name="virtualIP")
    def virtual_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual IP address
        """
        return pulumi.get(self, "virtual_ip")

    @virtual_ip.setter
    def virtual_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_ip", value)


@pulumi.input_type
class VirtualNetworkProfileArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Specification for using a virtual network
        :param pulumi.Input[str] id: Resource id of the virtual network
        :param pulumi.Input[str] name: Name of the virtual network (read-only)
        :param pulumi.Input[str] subnet: Subnet within the virtual network
        :param pulumi.Input[str] type: Resource type of the virtual network (read-only)
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of the virtual network
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the virtual network (read-only)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet within the virtual network
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type of the virtual network (read-only)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class VnetRouteArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 end_address: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_type: Optional[pulumi.Input[str]] = None,
                 start_address: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        VnetRoute contract used to pass routing information for a vnet.
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[str] end_address: The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[str] route_type: The type of route this is:
                           DEFAULT - By default, every web app has routes to the local address ranges specified by RFC1918
                           INHERITED - Routes inherited from the real Virtual Network routes
                           STATIC - Static route set on the web app only
                           
                           These values will be used for syncing a Web App's routes with those from a Virtual Network. This operation will clear all DEFAULT and INHERITED routes and replace them
                           with new INHERITED routes.
        :param pulumi.Input[str] start_address: The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if end_address is not None:
            pulumi.set(__self__, "end_address", end_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_type is not None:
            pulumi.set(__self__, "route_type", route_type)
        if start_address is not None:
            pulumi.set(__self__, "start_address", start_address)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="endAddress")
    def end_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
        """
        return pulumi.get(self, "end_address")

    @end_address.setter
    def end_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of route this is:
                    DEFAULT - By default, every web app has routes to the local address ranges specified by RFC1918
                    INHERITED - Routes inherited from the real Virtual Network routes
                    STATIC - Static route set on the web app only
                    
                    These values will be used for syncing a Web App's routes with those from a Virtual Network. This operation will clear all DEFAULT and INHERITED routes and replace them
                    with new INHERITED routes.
        """
        return pulumi.get(self, "route_type")

    @route_type.setter
    def route_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_type", value)

    @property
    @pulumi.getter(name="startAddress")
    def start_address(self) -> Optional[pulumi.Input[str]]:
        """
        The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
        """
        return pulumi.get(self, "start_address")

    @start_address.setter
    def start_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_address", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class WorkerPoolArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 compute_mode: Optional[pulumi.Input['ComputeModeOptions']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 instance_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input['SkuDescriptionArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 worker_count: Optional[pulumi.Input[int]] = None,
                 worker_size: Optional[pulumi.Input[str]] = None,
                 worker_size_id: Optional[pulumi.Input[int]] = None):
        """
        Worker pool of a hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input['ComputeModeOptions'] compute_mode: Shared or dedicated web app hosting
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_names: Names of all instances in the worker pool (read only)
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input['SkuDescriptionArgs'] sku: Describes a sku for a scalable resource
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        :param pulumi.Input[int] worker_count: Number of instances in the worker pool
        :param pulumi.Input[str] worker_size: VM size of the worker pool instances
        :param pulumi.Input[int] worker_size_id: Worker size id for referencing this worker pool
        """
        pulumi.set(__self__, "location", location)
        if compute_mode is not None:
            pulumi.set(__self__, "compute_mode", compute_mode)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if worker_count is not None:
            pulumi.set(__self__, "worker_count", worker_count)
        if worker_size is not None:
            pulumi.set(__self__, "worker_size", worker_size)
        if worker_size_id is not None:
            pulumi.set(__self__, "worker_size_id", worker_size_id)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="computeMode")
    def compute_mode(self) -> Optional[pulumi.Input['ComputeModeOptions']]:
        """
        Shared or dedicated web app hosting
        """
        return pulumi.get(self, "compute_mode")

    @compute_mode.setter
    def compute_mode(self, value: Optional[pulumi.Input['ComputeModeOptions']]):
        pulumi.set(self, "compute_mode", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of all instances in the worker pool (read only)
        """
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['SkuDescriptionArgs']]:
        """
        Describes a sku for a scalable resource
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['SkuDescriptionArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of instances in the worker pool
        """
        return pulumi.get(self, "worker_count")

    @worker_count.setter
    def worker_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "worker_count", value)

    @property
    @pulumi.getter(name="workerSize")
    def worker_size(self) -> Optional[pulumi.Input[str]]:
        """
        VM size of the worker pool instances
        """
        return pulumi.get(self, "worker_size")

    @worker_size.setter
    def worker_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_size", value)

    @property
    @pulumi.getter(name="workerSizeId")
    def worker_size_id(self) -> Optional[pulumi.Input[int]]:
        """
        Worker size id for referencing this worker pool
        """
        return pulumi.get(self, "worker_size_id")

    @worker_size_id.setter
    def worker_size_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "worker_size_id", value)


