# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'SkuV3Response',
    'SystemDataResponse',
]

@pulumi.output_type
class SkuV3Response(dict):
    """
    An ARM Resource SKU.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: Optional[str] = None):
        """
        An ARM Resource SKU.
        :param str name: The name of the SKU, typically, a letter + Number code, e.g. P3.
        :param str tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU, typically, a letter + Number code, e.g. P3.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    ARM System Data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: str,
                 created_by: str,
                 created_by_type: str,
                 last_modified_at: str,
                 last_modified_by: str,
                 last_modified_by_type: str):
        """
        ARM System Data.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: A string identifier for the identity that created the resource.
        :param str created_by_type: The type of identity that created the resource: <User|Application|ManagedIdentity|Key>
        :param str last_modified_at: The timestamp of last modification (UTC).
        :param str last_modified_by: A string identifier for the identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource: <User|Application|ManagedIdentity|Key>
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "created_by_type", created_by_type)
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        A string identifier for the identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> str:
        """
        The type of identity that created the resource: <User|Application|ManagedIdentity|Key>
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> str:
        """
        The timestamp of last modification (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> str:
        """
        A string identifier for the identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> str:
        """
        The type of identity that last modified the resource: <User|Application|ManagedIdentity|Key>
        """
        return pulumi.get(self, "last_modified_by_type")


