# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdaptiveApplicationControlIssueSummaryResponse',
    'AdditionalWorkspacesPropertiesResponse',
    'AllowlistCustomAlertRuleResponse',
    'AssessmentLinksResponse',
    'AssessmentStatusResponse',
    'AutomationActionEventHubResponse',
    'AutomationActionLogicAppResponse',
    'AutomationActionWorkspaceResponse',
    'AutomationRuleSetResponse',
    'AutomationScopeResponse',
    'AutomationSourceResponse',
    'AutomationTriggeringRuleResponse',
    'AwAssumeRoleAuthenticationDetailsPropertiesResponse',
    'AwsCredsAuthenticationDetailsPropertiesResponse',
    'AzureResourceDetailsResponse',
    'DenylistCustomAlertRuleResponse',
    'GcpCredentialsDetailsPropertiesResponse',
    'HybridComputeSettingsPropertiesResponse',
    'IngestionConnectionStringResponse',
    'JitNetworkAccessPolicyVirtualMachineResponse',
    'JitNetworkAccessPortRuleResponse',
    'JitNetworkAccessRequestPortResponse',
    'JitNetworkAccessRequestResponse',
    'JitNetworkAccessRequestVirtualMachineResponse',
    'OnPremiseResourceDetailsResponse',
    'OnPremiseSqlResourceDetailsResponse',
    'PathRecommendationResponse',
    'ProtectionModeResponse',
    'ProxyServerPropertiesResponse',
    'PublisherInfoResponse',
    'RecommendationConfigurationPropertiesResponse',
    'RuleResultsPropertiesResponse',
    'ScopeElementResponse',
    'SecurityAssessmentMetadataPartnerDataResponse',
    'SecurityAssessmentMetadataPropertiesResponse',
    'SecurityAssessmentPartnerDataResponse',
    'SecurityContactPropertiesResponseAlertNotifications',
    'SecurityContactPropertiesResponseNotificationsByRole',
    'ServicePrincipalPropertiesResponse',
    'SuppressionAlertsScopeResponse',
    'SystemDataResponse',
    'ThresholdCustomAlertRuleResponse',
    'TimeWindowCustomAlertRuleResponse',
    'UserDefinedResourcesPropertiesResponse',
    'UserRecommendationResponse',
    'VmRecommendationResponse',
]

@pulumi.output_type
class AdaptiveApplicationControlIssueSummaryResponse(dict):
    """
    Represents a summary of the alerts of the machine group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numberOfVms":
            suggest = "number_of_vms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdaptiveApplicationControlIssueSummaryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdaptiveApplicationControlIssueSummaryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdaptiveApplicationControlIssueSummaryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issue: Optional[str] = None,
                 number_of_vms: Optional[float] = None):
        """
        Represents a summary of the alerts of the machine group
        :param str issue: An alert that machines within a group can have
        :param float number_of_vms: The number of machines in the group that have this alert
        """
        if issue is not None:
            pulumi.set(__self__, "issue", issue)
        if number_of_vms is not None:
            pulumi.set(__self__, "number_of_vms", number_of_vms)

    @property
    @pulumi.getter
    def issue(self) -> Optional[str]:
        """
        An alert that machines within a group can have
        """
        return pulumi.get(self, "issue")

    @property
    @pulumi.getter(name="numberOfVms")
    def number_of_vms(self) -> Optional[float]:
        """
        The number of machines in the group that have this alert
        """
        return pulumi.get(self, "number_of_vms")


@pulumi.output_type
class AdditionalWorkspacesPropertiesResponse(dict):
    """
    Properties of the additional workspaces.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataTypes":
            suggest = "data_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdditionalWorkspacesPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdditionalWorkspacesPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdditionalWorkspacesPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_types: Optional[Sequence[str]] = None,
                 type: Optional[str] = None,
                 workspace: Optional[str] = None):
        """
        Properties of the additional workspaces.
        :param Sequence[str] data_types: List of data types sent to workspace
        :param str type: Workspace type.
        :param str workspace: Workspace resource id
        """
        if data_types is not None:
            pulumi.set(__self__, "data_types", data_types)
        if type is None:
            type = 'Sentinel'
        if type is not None:
            pulumi.set(__self__, "type", type)
        if workspace is not None:
            pulumi.set(__self__, "workspace", workspace)

    @property
    @pulumi.getter(name="dataTypes")
    def data_types(self) -> Optional[Sequence[str]]:
        """
        List of data types sent to workspace
        """
        return pulumi.get(self, "data_types")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Workspace type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def workspace(self) -> Optional[str]:
        """
        Workspace resource id
        """
        return pulumi.get(self, "workspace")


@pulumi.output_type
class AllowlistCustomAlertRuleResponse(dict):
    """
    A custom alert rule that checks if a value (depends on the custom alert type) is allowed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowlistValues":
            suggest = "allowlist_values"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "ruleType":
            suggest = "rule_type"
        elif key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllowlistCustomAlertRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllowlistCustomAlertRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllowlistCustomAlertRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowlist_values: Sequence[str],
                 description: str,
                 display_name: str,
                 is_enabled: bool,
                 rule_type: str,
                 value_type: str):
        """
        A custom alert rule that checks if a value (depends on the custom alert type) is allowed.
        :param Sequence[str] allowlist_values: The values to allow. The format of the values depends on the rule type.
        :param str description: The description of the custom alert.
        :param str display_name: The display name of the custom alert.
        :param bool is_enabled: Status of the custom alert.
        :param str rule_type: The type of the custom alert rule.
               Expected value is 'AllowlistCustomAlertRule'.
        :param str value_type: The value type of the items in the list.
        """
        pulumi.set(__self__, "allowlist_values", allowlist_values)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "rule_type", 'AllowlistCustomAlertRule')
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="allowlistValues")
    def allowlist_values(self) -> Sequence[str]:
        """
        The values to allow. The format of the values depends on the rule type.
        """
        return pulumi.get(self, "allowlist_values")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the custom alert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the custom alert.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Status of the custom alert.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of the custom alert rule.
        Expected value is 'AllowlistCustomAlertRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The value type of the items in the list.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class AssessmentLinksResponse(dict):
    """
    Links relevant to the assessment
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azurePortalUri":
            suggest = "azure_portal_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentLinksResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentLinksResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentLinksResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_portal_uri: str):
        """
        Links relevant to the assessment
        :param str azure_portal_uri: Link to assessment in Azure Portal
        """
        pulumi.set(__self__, "azure_portal_uri", azure_portal_uri)

    @property
    @pulumi.getter(name="azurePortalUri")
    def azure_portal_uri(self) -> str:
        """
        Link to assessment in Azure Portal
        """
        return pulumi.get(self, "azure_portal_uri")


@pulumi.output_type
class AssessmentStatusResponse(dict):
    """
    The result of the assessment
    """
    def __init__(__self__, *,
                 code: str,
                 cause: Optional[str] = None,
                 description: Optional[str] = None):
        """
        The result of the assessment
        :param str code: Programmatic code for the status of the assessment
        :param str cause: Programmatic code for the cause of the assessment status
        :param str description: Human readable description of the assessment status
        """
        pulumi.set(__self__, "code", code)
        if cause is not None:
            pulumi.set(__self__, "cause", cause)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Programmatic code for the status of the assessment
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def cause(self) -> Optional[str]:
        """
        Programmatic code for the cause of the assessment status
        """
        return pulumi.get(self, "cause")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Human readable description of the assessment status
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AutomationActionEventHubResponse(dict):
    """
    The target Event Hub to which event data will be exported. To learn more about Security Center continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "sasPolicyName":
            suggest = "sas_policy_name"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "eventHubResourceId":
            suggest = "event_hub_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationActionEventHubResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationActionEventHubResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationActionEventHubResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 sas_policy_name: str,
                 connection_string: Optional[str] = None,
                 event_hub_resource_id: Optional[str] = None):
        """
        The target Event Hub to which event data will be exported. To learn more about Security Center continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
        :param str action_type: The type of the action that will be triggered by the Automation
               Expected value is 'EventHub'.
        :param str sas_policy_name: The target Event Hub SAS policy name.
        :param str connection_string: The target Event Hub connection string (it will not be included in any response).
        :param str event_hub_resource_id: The target Event Hub Azure Resource ID.
        """
        pulumi.set(__self__, "action_type", 'EventHub')
        pulumi.set(__self__, "sas_policy_name", sas_policy_name)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if event_hub_resource_id is not None:
            pulumi.set(__self__, "event_hub_resource_id", event_hub_resource_id)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of the action that will be triggered by the Automation
        Expected value is 'EventHub'.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="sasPolicyName")
    def sas_policy_name(self) -> str:
        """
        The target Event Hub SAS policy name.
        """
        return pulumi.get(self, "sas_policy_name")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        The target Event Hub connection string (it will not be included in any response).
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="eventHubResourceId")
    def event_hub_resource_id(self) -> Optional[str]:
        """
        The target Event Hub Azure Resource ID.
        """
        return pulumi.get(self, "event_hub_resource_id")


@pulumi.output_type
class AutomationActionLogicAppResponse(dict):
    """
    The logic app action that should be triggered. To learn more about Security Center's Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "logicAppResourceId":
            suggest = "logic_app_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationActionLogicAppResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationActionLogicAppResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationActionLogicAppResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 logic_app_resource_id: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        The logic app action that should be triggered. To learn more about Security Center's Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore
        :param str action_type: The type of the action that will be triggered by the Automation
               Expected value is 'LogicApp'.
        :param str logic_app_resource_id: The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
        :param str uri: The Logic App trigger URI endpoint (it will not be included in any response).
        """
        pulumi.set(__self__, "action_type", 'LogicApp')
        if logic_app_resource_id is not None:
            pulumi.set(__self__, "logic_app_resource_id", logic_app_resource_id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of the action that will be triggered by the Automation
        Expected value is 'LogicApp'.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="logicAppResourceId")
    def logic_app_resource_id(self) -> Optional[str]:
        """
        The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
        """
        return pulumi.get(self, "logic_app_resource_id")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The Logic App trigger URI endpoint (it will not be included in any response).
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class AutomationActionWorkspaceResponse(dict):
    """
    The Log Analytics Workspace to which event data will be exported. Security alerts data will reside in the 'SecurityAlert' table and the assessments data will reside in the 'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order to view the data in the workspace, the Security Center Log Analytics free/standard solution needs to be enabled on that workspace. To learn more about Security Center continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "workspaceResourceId":
            suggest = "workspace_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationActionWorkspaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationActionWorkspaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationActionWorkspaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 workspace_resource_id: Optional[str] = None):
        """
        The Log Analytics Workspace to which event data will be exported. Security alerts data will reside in the 'SecurityAlert' table and the assessments data will reside in the 'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order to view the data in the workspace, the Security Center Log Analytics free/standard solution needs to be enabled on that workspace. To learn more about Security Center continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
        :param str action_type: The type of the action that will be triggered by the Automation
               Expected value is 'Workspace'.
        :param str workspace_resource_id: The fully qualified Log Analytics Workspace Azure Resource ID.
        """
        pulumi.set(__self__, "action_type", 'Workspace')
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of the action that will be triggered by the Automation
        Expected value is 'Workspace'.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[str]:
        """
        The fully qualified Log Analytics Workspace Azure Resource ID.
        """
        return pulumi.get(self, "workspace_resource_id")


@pulumi.output_type
class AutomationRuleSetResponse(dict):
    """
    A rule set which evaluates all its rules upon an event interception. Only when all the included rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.
    """
    def __init__(__self__, *,
                 rules: Optional[Sequence['outputs.AutomationTriggeringRuleResponse']] = None):
        """
        A rule set which evaluates all its rules upon an event interception. Only when all the included rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AutomationTriggeringRuleResponse']]:
        return pulumi.get(self, "rules")


@pulumi.output_type
class AutomationScopeResponse(dict):
    """
    A single automation scope.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scopePath":
            suggest = "scope_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationScopeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationScopeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationScopeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 scope_path: Optional[str] = None):
        """
        A single automation scope.
        :param str description: The resources scope description.
        :param str scope_path: The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if scope_path is not None:
            pulumi.set(__self__, "scope_path", scope_path)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The resources scope description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="scopePath")
    def scope_path(self) -> Optional[str]:
        """
        The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
        """
        return pulumi.get(self, "scope_path")


@pulumi.output_type
class AutomationSourceResponse(dict):
    """
    The source event types which evaluate the security automation set of rules. For example - security alerts and security assessments. To learn more about the supported security events data models schemas - please visit https://aka.ms/ASCAutomationSchemas.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventSource":
            suggest = "event_source"
        elif key == "ruleSets":
            suggest = "rule_sets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_source: Optional[str] = None,
                 rule_sets: Optional[Sequence['outputs.AutomationRuleSetResponse']] = None):
        """
        The source event types which evaluate the security automation set of rules. For example - security alerts and security assessments. To learn more about the supported security events data models schemas - please visit https://aka.ms/ASCAutomationSchemas.
        :param str event_source: A valid event source type.
        :param Sequence['AutomationRuleSetResponse'] rule_sets: A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
        """
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if rule_sets is not None:
            pulumi.set(__self__, "rule_sets", rule_sets)

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional[str]:
        """
        A valid event source type.
        """
        return pulumi.get(self, "event_source")

    @property
    @pulumi.getter(name="ruleSets")
    def rule_sets(self) -> Optional[Sequence['outputs.AutomationRuleSetResponse']]:
        """
        A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
        """
        return pulumi.get(self, "rule_sets")


@pulumi.output_type
class AutomationTriggeringRuleResponse(dict):
    """
    A rule which is evaluated upon event interception. The rule is configured by comparing a specific value from the event model to an expected value. This comparison is done by using one of the supported operators set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedValue":
            suggest = "expected_value"
        elif key == "propertyJPath":
            suggest = "property_j_path"
        elif key == "propertyType":
            suggest = "property_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationTriggeringRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationTriggeringRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationTriggeringRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expected_value: Optional[str] = None,
                 operator: Optional[str] = None,
                 property_j_path: Optional[str] = None,
                 property_type: Optional[str] = None):
        """
        A rule which is evaluated upon event interception. The rule is configured by comparing a specific value from the event model to an expected value. This comparison is done by using one of the supported operators set.
        :param str expected_value: The expected value.
        :param str operator: A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
        :param str property_j_path: The JPath of the entity model property that should be checked.
        :param str property_type: The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
        """
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if property_j_path is not None:
            pulumi.set(__self__, "property_j_path", property_j_path)
        if property_type is not None:
            pulumi.set(__self__, "property_type", property_type)

    @property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[str]:
        """
        The expected value.
        """
        return pulumi.get(self, "expected_value")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="propertyJPath")
    def property_j_path(self) -> Optional[str]:
        """
        The JPath of the entity model property that should be checked.
        """
        return pulumi.get(self, "property_j_path")

    @property
    @pulumi.getter(name="propertyType")
    def property_type(self) -> Optional[str]:
        """
        The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
        """
        return pulumi.get(self, "property_type")


@pulumi.output_type
class AwAssumeRoleAuthenticationDetailsPropertiesResponse(dict):
    """
    AWS cloud account connector based assume role, the role enables delegating access to your AWS resources. The role is composed of role Amazon Resource Name (ARN) and external ID. For more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating a Role to Delegate Permissions to an IAM User (write only)</a>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "authenticationProvisioningState":
            suggest = "authentication_provisioning_state"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "awsAssumeRoleArn":
            suggest = "aws_assume_role_arn"
        elif key == "awsExternalId":
            suggest = "aws_external_id"
        elif key == "grantedPermissions":
            suggest = "granted_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwAssumeRoleAuthenticationDetailsPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwAssumeRoleAuthenticationDetailsPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwAssumeRoleAuthenticationDetailsPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: str,
                 authentication_provisioning_state: str,
                 authentication_type: str,
                 aws_assume_role_arn: str,
                 aws_external_id: str,
                 granted_permissions: Sequence[str]):
        """
        AWS cloud account connector based assume role, the role enables delegating access to your AWS resources. The role is composed of role Amazon Resource Name (ARN) and external ID. For more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating a Role to Delegate Permissions to an IAM User (write only)</a>
        :param str account_id: The ID of the cloud account
        :param str authentication_provisioning_state: State of the multi-cloud connector
        :param str authentication_type: Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
               Expected value is 'awsAssumeRole'.
        :param str aws_assume_role_arn: Assumed role ID is an identifier that you can use to create temporary security credentials.
        :param str aws_external_id: A unique identifier that is required when you assume a role in another account.
        :param Sequence[str] granted_permissions: The permissions detected in the cloud account.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "authentication_provisioning_state", authentication_provisioning_state)
        pulumi.set(__self__, "authentication_type", 'awsAssumeRole')
        pulumi.set(__self__, "aws_assume_role_arn", aws_assume_role_arn)
        pulumi.set(__self__, "aws_external_id", aws_external_id)
        pulumi.set(__self__, "granted_permissions", granted_permissions)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The ID of the cloud account
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="authenticationProvisioningState")
    def authentication_provisioning_state(self) -> str:
        """
        State of the multi-cloud connector
        """
        return pulumi.get(self, "authentication_provisioning_state")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
        Expected value is 'awsAssumeRole'.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="awsAssumeRoleArn")
    def aws_assume_role_arn(self) -> str:
        """
        Assumed role ID is an identifier that you can use to create temporary security credentials.
        """
        return pulumi.get(self, "aws_assume_role_arn")

    @property
    @pulumi.getter(name="awsExternalId")
    def aws_external_id(self) -> str:
        """
        A unique identifier that is required when you assume a role in another account.
        """
        return pulumi.get(self, "aws_external_id")

    @property
    @pulumi.getter(name="grantedPermissions")
    def granted_permissions(self) -> Sequence[str]:
        """
        The permissions detected in the cloud account.
        """
        return pulumi.get(self, "granted_permissions")


@pulumi.output_type
class AwsCredsAuthenticationDetailsPropertiesResponse(dict):
    """
    AWS cloud account connector based credentials, the credentials is composed of access key ID and secret key, for more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating an IAM User in Your AWS Account (write only)</a>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "authenticationProvisioningState":
            suggest = "authentication_provisioning_state"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "awsAccessKeyId":
            suggest = "aws_access_key_id"
        elif key == "awsSecretAccessKey":
            suggest = "aws_secret_access_key"
        elif key == "grantedPermissions":
            suggest = "granted_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsCredsAuthenticationDetailsPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsCredsAuthenticationDetailsPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsCredsAuthenticationDetailsPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: str,
                 authentication_provisioning_state: str,
                 authentication_type: str,
                 aws_access_key_id: str,
                 aws_secret_access_key: str,
                 granted_permissions: Sequence[str]):
        """
        AWS cloud account connector based credentials, the credentials is composed of access key ID and secret key, for more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating an IAM User in Your AWS Account (write only)</a>
        :param str account_id: The ID of the cloud account
        :param str authentication_provisioning_state: State of the multi-cloud connector
        :param str authentication_type: Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
               Expected value is 'awsCreds'.
        :param str aws_access_key_id: Public key element of the AWS credential object (write only)
        :param str aws_secret_access_key: Secret key element of the AWS credential object (write only)
        :param Sequence[str] granted_permissions: The permissions detected in the cloud account.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "authentication_provisioning_state", authentication_provisioning_state)
        pulumi.set(__self__, "authentication_type", 'awsCreds')
        pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        pulumi.set(__self__, "granted_permissions", granted_permissions)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The ID of the cloud account
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="authenticationProvisioningState")
    def authentication_provisioning_state(self) -> str:
        """
        State of the multi-cloud connector
        """
        return pulumi.get(self, "authentication_provisioning_state")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
        Expected value is 'awsCreds'.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> str:
        """
        Public key element of the AWS credential object (write only)
        """
        return pulumi.get(self, "aws_access_key_id")

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> str:
        """
        Secret key element of the AWS credential object (write only)
        """
        return pulumi.get(self, "aws_secret_access_key")

    @property
    @pulumi.getter(name="grantedPermissions")
    def granted_permissions(self) -> Sequence[str]:
        """
        The permissions detected in the cloud account.
        """
        return pulumi.get(self, "granted_permissions")


@pulumi.output_type
class AzureResourceDetailsResponse(dict):
    """
    Details of the Azure resource that was assessed
    """
    def __init__(__self__, *,
                 id: str,
                 source: str):
        """
        Details of the Azure resource that was assessed
        :param str id: Azure resource Id of the assessed resource
        :param str source: The platform where the assessed resource resides
               Expected value is 'Azure'.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "source", 'Azure')

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure resource Id of the assessed resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The platform where the assessed resource resides
        Expected value is 'Azure'.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class DenylistCustomAlertRuleResponse(dict):
    """
    A custom alert rule that checks if a value (depends on the custom alert type) is denied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "denylistValues":
            suggest = "denylist_values"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "ruleType":
            suggest = "rule_type"
        elif key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DenylistCustomAlertRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DenylistCustomAlertRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DenylistCustomAlertRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 denylist_values: Sequence[str],
                 description: str,
                 display_name: str,
                 is_enabled: bool,
                 rule_type: str,
                 value_type: str):
        """
        A custom alert rule that checks if a value (depends on the custom alert type) is denied.
        :param Sequence[str] denylist_values: The values to deny. The format of the values depends on the rule type.
        :param str description: The description of the custom alert.
        :param str display_name: The display name of the custom alert.
        :param bool is_enabled: Status of the custom alert.
        :param str rule_type: The type of the custom alert rule.
               Expected value is 'DenylistCustomAlertRule'.
        :param str value_type: The value type of the items in the list.
        """
        pulumi.set(__self__, "denylist_values", denylist_values)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "rule_type", 'DenylistCustomAlertRule')
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="denylistValues")
    def denylist_values(self) -> Sequence[str]:
        """
        The values to deny. The format of the values depends on the rule type.
        """
        return pulumi.get(self, "denylist_values")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the custom alert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the custom alert.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Status of the custom alert.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of the custom alert rule.
        Expected value is 'DenylistCustomAlertRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The value type of the items in the list.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GcpCredentialsDetailsPropertiesResponse(dict):
    """
    GCP cloud account connector based service to service credentials, the credentials are composed of the organization ID and a JSON API key (write only)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authProviderX509CertUrl":
            suggest = "auth_provider_x509_cert_url"
        elif key == "authUri":
            suggest = "auth_uri"
        elif key == "authenticationProvisioningState":
            suggest = "authentication_provisioning_state"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "clientEmail":
            suggest = "client_email"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientX509CertUrl":
            suggest = "client_x509_cert_url"
        elif key == "grantedPermissions":
            suggest = "granted_permissions"
        elif key == "organizationId":
            suggest = "organization_id"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "privateKeyId":
            suggest = "private_key_id"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "tokenUri":
            suggest = "token_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpCredentialsDetailsPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpCredentialsDetailsPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpCredentialsDetailsPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_provider_x509_cert_url: str,
                 auth_uri: str,
                 authentication_provisioning_state: str,
                 authentication_type: str,
                 client_email: str,
                 client_id: str,
                 client_x509_cert_url: str,
                 granted_permissions: Sequence[str],
                 organization_id: str,
                 private_key: str,
                 private_key_id: str,
                 project_id: str,
                 token_uri: str,
                 type: str):
        """
        GCP cloud account connector based service to service credentials, the credentials are composed of the organization ID and a JSON API key (write only)
        :param str auth_provider_x509_cert_url: Auth provider x509 certificate URL field of the API key (write only)
        :param str auth_uri: Auth URI field of the API key (write only)
        :param str authentication_provisioning_state: State of the multi-cloud connector
        :param str authentication_type: Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
               Expected value is 'gcpCredentials'.
        :param str client_email: Client email field of the API key (write only)
        :param str client_id: Client ID field of the API key (write only)
        :param str client_x509_cert_url: Client x509 certificate URL field of the API key (write only)
        :param Sequence[str] granted_permissions: The permissions detected in the cloud account.
        :param str organization_id: The organization ID of the GCP cloud account
        :param str private_key: Private key field of the API key (write only)
        :param str private_key_id: Private key ID field of the API key (write only)
        :param str project_id: Project ID field of the API key (write only)
        :param str token_uri: Token URI field of the API key (write only)
        :param str type: Type field of the API key (write only)
        """
        pulumi.set(__self__, "auth_provider_x509_cert_url", auth_provider_x509_cert_url)
        pulumi.set(__self__, "auth_uri", auth_uri)
        pulumi.set(__self__, "authentication_provisioning_state", authentication_provisioning_state)
        pulumi.set(__self__, "authentication_type", 'gcpCredentials')
        pulumi.set(__self__, "client_email", client_email)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_x509_cert_url", client_x509_cert_url)
        pulumi.set(__self__, "granted_permissions", granted_permissions)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "private_key_id", private_key_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "token_uri", token_uri)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="authProviderX509CertUrl")
    def auth_provider_x509_cert_url(self) -> str:
        """
        Auth provider x509 certificate URL field of the API key (write only)
        """
        return pulumi.get(self, "auth_provider_x509_cert_url")

    @property
    @pulumi.getter(name="authUri")
    def auth_uri(self) -> str:
        """
        Auth URI field of the API key (write only)
        """
        return pulumi.get(self, "auth_uri")

    @property
    @pulumi.getter(name="authenticationProvisioningState")
    def authentication_provisioning_state(self) -> str:
        """
        State of the multi-cloud connector
        """
        return pulumi.get(self, "authentication_provisioning_state")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
        Expected value is 'gcpCredentials'.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> str:
        """
        Client email field of the API key (write only)
        """
        return pulumi.get(self, "client_email")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        Client ID field of the API key (write only)
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientX509CertUrl")
    def client_x509_cert_url(self) -> str:
        """
        Client x509 certificate URL field of the API key (write only)
        """
        return pulumi.get(self, "client_x509_cert_url")

    @property
    @pulumi.getter(name="grantedPermissions")
    def granted_permissions(self) -> Sequence[str]:
        """
        The permissions detected in the cloud account.
        """
        return pulumi.get(self, "granted_permissions")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The organization ID of the GCP cloud account
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        Private key field of the API key (write only)
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> str:
        """
        Private key ID field of the API key (write only)
        """
        return pulumi.get(self, "private_key_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Project ID field of the API key (write only)
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="tokenUri")
    def token_uri(self) -> str:
        """
        Token URI field of the API key (write only)
        """
        return pulumi.get(self, "token_uri")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type field of the API key (write only)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HybridComputeSettingsPropertiesResponse(dict):
    """
    Settings for hybrid compute management
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoProvision":
            suggest = "auto_provision"
        elif key == "hybridComputeProvisioningState":
            suggest = "hybrid_compute_provisioning_state"
        elif key == "proxyServer":
            suggest = "proxy_server"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"
        elif key == "servicePrincipal":
            suggest = "service_principal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HybridComputeSettingsPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HybridComputeSettingsPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HybridComputeSettingsPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_provision: str,
                 hybrid_compute_provisioning_state: str,
                 proxy_server: Optional['outputs.ProxyServerPropertiesResponse'] = None,
                 region: Optional[str] = None,
                 resource_group_name: Optional[str] = None,
                 service_principal: Optional['outputs.ServicePrincipalPropertiesResponse'] = None):
        """
        Settings for hybrid compute management
        :param str auto_provision: Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
        :param str hybrid_compute_provisioning_state: State of the service principal and its secret
        :param 'ProxyServerPropertiesResponse' proxy_server: For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
        :param str region: The location where the metadata of machines will be stored
        :param str resource_group_name: The name of the resource group where Arc (Hybrid Compute) connectors are connected.
        :param 'ServicePrincipalPropertiesResponse' service_principal: An object to access resources that are secured by an Azure AD tenant.
        """
        pulumi.set(__self__, "auto_provision", auto_provision)
        pulumi.set(__self__, "hybrid_compute_provisioning_state", hybrid_compute_provisioning_state)
        if proxy_server is not None:
            pulumi.set(__self__, "proxy_server", proxy_server)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_principal is not None:
            pulumi.set(__self__, "service_principal", service_principal)

    @property
    @pulumi.getter(name="autoProvision")
    def auto_provision(self) -> str:
        """
        Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
        """
        return pulumi.get(self, "auto_provision")

    @property
    @pulumi.getter(name="hybridComputeProvisioningState")
    def hybrid_compute_provisioning_state(self) -> str:
        """
        State of the service principal and its secret
        """
        return pulumi.get(self, "hybrid_compute_provisioning_state")

    @property
    @pulumi.getter(name="proxyServer")
    def proxy_server(self) -> Optional['outputs.ProxyServerPropertiesResponse']:
        """
        For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
        """
        return pulumi.get(self, "proxy_server")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The location where the metadata of machines will be stored
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[str]:
        """
        The name of the resource group where Arc (Hybrid Compute) connectors are connected.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> Optional['outputs.ServicePrincipalPropertiesResponse']:
        """
        An object to access resources that are secured by an Azure AD tenant.
        """
        return pulumi.get(self, "service_principal")


@pulumi.output_type
class IngestionConnectionStringResponse(dict):
    """
    Connection string for ingesting security data and logs
    """
    def __init__(__self__, *,
                 location: str,
                 value: str):
        """
        Connection string for ingesting security data and logs
        :param str location: The region where ingested logs and data resides
        :param str value: Connection string value
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The region where ingested logs and data resides
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Connection string value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JitNetworkAccessPolicyVirtualMachineResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JitNetworkAccessPolicyVirtualMachineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JitNetworkAccessPolicyVirtualMachineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JitNetworkAccessPolicyVirtualMachineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 ports: Sequence['outputs.JitNetworkAccessPortRuleResponse'],
                 public_ip_address: Optional[str] = None):
        """
        :param str id: Resource ID of the virtual machine that is linked to this policy
        :param Sequence['JitNetworkAccessPortRuleResponse'] ports: Port configurations for the virtual machine
        :param str public_ip_address: Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.JitNetworkAccessPortRuleResponse']:
        """
        Port configurations for the virtual machine
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[str]:
        """
        Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class JitNetworkAccessPortRuleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRequestAccessDuration":
            suggest = "max_request_access_duration"
        elif key == "allowedSourceAddressPrefix":
            suggest = "allowed_source_address_prefix"
        elif key == "allowedSourceAddressPrefixes":
            suggest = "allowed_source_address_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JitNetworkAccessPortRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JitNetworkAccessPortRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JitNetworkAccessPortRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_request_access_duration: str,
                 number: int,
                 protocol: str,
                 allowed_source_address_prefix: Optional[str] = None,
                 allowed_source_address_prefixes: Optional[Sequence[str]] = None):
        """
        :param str max_request_access_duration: Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        :param str allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param Sequence[str] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        pulumi.set(__self__, "max_request_access_duration", max_request_access_duration)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "protocol", protocol)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)

    @property
    @pulumi.getter(name="maxRequestAccessDuration")
    def max_request_access_duration(self) -> str:
        """
        Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        """
        return pulumi.get(self, "max_request_access_duration")

    @property
    @pulumi.getter
    def number(self) -> int:
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[str]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")


@pulumi.output_type
class JitNetworkAccessRequestPortResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimeUtc":
            suggest = "end_time_utc"
        elif key == "statusReason":
            suggest = "status_reason"
        elif key == "allowedSourceAddressPrefix":
            suggest = "allowed_source_address_prefix"
        elif key == "allowedSourceAddressPrefixes":
            suggest = "allowed_source_address_prefixes"
        elif key == "mappedPort":
            suggest = "mapped_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JitNetworkAccessRequestPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JitNetworkAccessRequestPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JitNetworkAccessRequestPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time_utc: str,
                 number: int,
                 status: str,
                 status_reason: str,
                 allowed_source_address_prefix: Optional[str] = None,
                 allowed_source_address_prefixes: Optional[Sequence[str]] = None,
                 mapped_port: Optional[int] = None):
        """
        :param str end_time_utc: The date & time at which the request ends in UTC
        :param str status: The status of the port
        :param str status_reason: A description of why the `status` has its value
        :param str allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param Sequence[str] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        :param int mapped_port: The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)
        if mapped_port is not None:
            pulumi.set(__self__, "mapped_port", mapped_port)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> str:
        """
        The date & time at which the request ends in UTC
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter
    def number(self) -> int:
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the port
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> str:
        """
        A description of why the `status` has its value
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[str]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")

    @property
    @pulumi.getter(name="mappedPort")
    def mapped_port(self) -> Optional[int]:
        """
        The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        return pulumi.get(self, "mapped_port")


@pulumi.output_type
class JitNetworkAccessRequestResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "virtualMachines":
            suggest = "virtual_machines"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JitNetworkAccessRequestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JitNetworkAccessRequestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JitNetworkAccessRequestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 requestor: str,
                 start_time_utc: str,
                 virtual_machines: Sequence['outputs.JitNetworkAccessRequestVirtualMachineResponse'],
                 justification: Optional[str] = None):
        """
        :param str requestor: The identity of the person who made the request
        :param str start_time_utc: The start time of the request in UTC
        :param str justification: The justification for making the initiate request
        """
        pulumi.set(__self__, "requestor", requestor)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "virtual_machines", virtual_machines)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)

    @property
    @pulumi.getter
    def requestor(self) -> str:
        """
        The identity of the person who made the request
        """
        return pulumi.get(self, "requestor")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        The start time of the request in UTC
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Sequence['outputs.JitNetworkAccessRequestVirtualMachineResponse']:
        return pulumi.get(self, "virtual_machines")

    @property
    @pulumi.getter
    def justification(self) -> Optional[str]:
        """
        The justification for making the initiate request
        """
        return pulumi.get(self, "justification")


@pulumi.output_type
class JitNetworkAccessRequestVirtualMachineResponse(dict):
    def __init__(__self__, *,
                 id: str,
                 ports: Sequence['outputs.JitNetworkAccessRequestPortResponse']):
        """
        :param str id: Resource ID of the virtual machine that is linked to this policy
        :param Sequence['JitNetworkAccessRequestPortResponse'] ports: The ports that were opened for the virtual machine
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.JitNetworkAccessRequestPortResponse']:
        """
        The ports that were opened for the virtual machine
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class OnPremiseResourceDetailsResponse(dict):
    """
    Details of the On Premise resource that was assessed
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineName":
            suggest = "machine_name"
        elif key == "sourceComputerId":
            suggest = "source_computer_id"
        elif key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnPremiseResourceDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnPremiseResourceDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnPremiseResourceDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_name: str,
                 source: str,
                 source_computer_id: str,
                 vmuuid: str,
                 workspace_id: str):
        """
        Details of the On Premise resource that was assessed
        :param str machine_name: The name of the machine
        :param str source: The platform where the assessed resource resides
               Expected value is 'OnPremise'.
        :param str source_computer_id: The oms agent Id installed on the machine
        :param str vmuuid: The unique Id of the machine
        :param str workspace_id: Azure resource Id of the workspace the machine is attached to
        """
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "source", 'OnPremise')
        pulumi.set(__self__, "source_computer_id", source_computer_id)
        pulumi.set(__self__, "vmuuid", vmuuid)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> str:
        """
        The name of the machine
        """
        return pulumi.get(self, "machine_name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The platform where the assessed resource resides
        Expected value is 'OnPremise'.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceComputerId")
    def source_computer_id(self) -> str:
        """
        The oms agent Id installed on the machine
        """
        return pulumi.get(self, "source_computer_id")

    @property
    @pulumi.getter
    def vmuuid(self) -> str:
        """
        The unique Id of the machine
        """
        return pulumi.get(self, "vmuuid")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        """
        Azure resource Id of the workspace the machine is attached to
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class OnPremiseSqlResourceDetailsResponse(dict):
    """
    Details of the On Premise Sql resource that was assessed
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "machineName":
            suggest = "machine_name"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sourceComputerId":
            suggest = "source_computer_id"
        elif key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnPremiseSqlResourceDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnPremiseSqlResourceDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnPremiseSqlResourceDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 machine_name: str,
                 server_name: str,
                 source: str,
                 source_computer_id: str,
                 vmuuid: str,
                 workspace_id: str):
        """
        Details of the On Premise Sql resource that was assessed
        :param str database_name: The Sql database name installed on the machine
        :param str machine_name: The name of the machine
        :param str server_name: The Sql server name installed on the machine
        :param str source: The platform where the assessed resource resides
               Expected value is 'OnPremiseSql'.
        :param str source_computer_id: The oms agent Id installed on the machine
        :param str vmuuid: The unique Id of the machine
        :param str workspace_id: Azure resource Id of the workspace the machine is attached to
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "source", 'OnPremiseSql')
        pulumi.set(__self__, "source_computer_id", source_computer_id)
        pulumi.set(__self__, "vmuuid", vmuuid)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The Sql database name installed on the machine
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> str:
        """
        The name of the machine
        """
        return pulumi.get(self, "machine_name")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        """
        The Sql server name installed on the machine
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The platform where the assessed resource resides
        Expected value is 'OnPremiseSql'.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceComputerId")
    def source_computer_id(self) -> str:
        """
        The oms agent Id installed on the machine
        """
        return pulumi.get(self, "source_computer_id")

    @property
    @pulumi.getter
    def vmuuid(self) -> str:
        """
        The unique Id of the machine
        """
        return pulumi.get(self, "vmuuid")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        """
        Azure resource Id of the workspace the machine is attached to
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class PathRecommendationResponse(dict):
    """
    Represents a path that is recommended to be allowed and its properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationStatus":
            suggest = "configuration_status"
        elif key == "fileType":
            suggest = "file_type"
        elif key == "publisherInfo":
            suggest = "publisher_info"
        elif key == "userSids":
            suggest = "user_sids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathRecommendationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathRecommendationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathRecommendationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 common: Optional[bool] = None,
                 configuration_status: Optional[str] = None,
                 file_type: Optional[str] = None,
                 path: Optional[str] = None,
                 publisher_info: Optional['outputs.PublisherInfoResponse'] = None,
                 type: Optional[str] = None,
                 user_sids: Optional[Sequence[str]] = None,
                 usernames: Optional[Sequence['outputs.UserRecommendationResponse']] = None):
        """
        Represents a path that is recommended to be allowed and its properties
        :param str action: The recommendation action of the machine or rule
        :param bool common: Whether the application is commonly run on the machine
        :param str configuration_status: The configuration status of the machines group or machine or rule
        :param str file_type: The type of the file (for Linux files - Executable is used)
        :param str path: The full path of the file, or an identifier of the application
        :param 'PublisherInfoResponse' publisher_info: Represents the publisher information of a process/rule
        :param str type: The type of the rule to be allowed
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if common is not None:
            pulumi.set(__self__, "common", common)
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if publisher_info is not None:
            pulumi.set(__self__, "publisher_info", publisher_info)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_sids is not None:
            pulumi.set(__self__, "user_sids", user_sids)
        if usernames is not None:
            pulumi.set(__self__, "usernames", usernames)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The recommendation action of the machine or rule
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def common(self) -> Optional[bool]:
        """
        Whether the application is commonly run on the machine
        """
        return pulumi.get(self, "common")

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[str]:
        """
        The configuration status of the machines group or machine or rule
        """
        return pulumi.get(self, "configuration_status")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[str]:
        """
        The type of the file (for Linux files - Executable is used)
        """
        return pulumi.get(self, "file_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The full path of the file, or an identifier of the application
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="publisherInfo")
    def publisher_info(self) -> Optional['outputs.PublisherInfoResponse']:
        """
        Represents the publisher information of a process/rule
        """
        return pulumi.get(self, "publisher_info")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the rule to be allowed
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userSids")
    def user_sids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "user_sids")

    @property
    @pulumi.getter
    def usernames(self) -> Optional[Sequence['outputs.UserRecommendationResponse']]:
        return pulumi.get(self, "usernames")


@pulumi.output_type
class ProtectionModeResponse(dict):
    """
    The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
    """
    def __init__(__self__, *,
                 exe: Optional[str] = None,
                 executable: Optional[str] = None,
                 msi: Optional[str] = None,
                 script: Optional[str] = None):
        """
        The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
        :param str exe: The application control policy enforcement/protection mode of the machine group
        :param str executable: The application control policy enforcement/protection mode of the machine group
        :param str msi: The application control policy enforcement/protection mode of the machine group
        :param str script: The application control policy enforcement/protection mode of the machine group
        """
        if exe is not None:
            pulumi.set(__self__, "exe", exe)
        if executable is not None:
            pulumi.set(__self__, "executable", executable)
        if msi is not None:
            pulumi.set(__self__, "msi", msi)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def exe(self) -> Optional[str]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "exe")

    @property
    @pulumi.getter
    def executable(self) -> Optional[str]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "executable")

    @property
    @pulumi.getter
    def msi(self) -> Optional[str]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "msi")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class ProxyServerPropertiesResponse(dict):
    """
    For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
    """
    def __init__(__self__, *,
                 ip: Optional[str] = None,
                 port: Optional[str] = None):
        """
        For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
        :param str ip: Proxy server IP
        :param str port: Proxy server port
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        Proxy server IP
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Proxy server port
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class PublisherInfoResponse(dict):
    """
    Represents the publisher information of a process/rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "binaryName":
            suggest = "binary_name"
        elif key == "productName":
            suggest = "product_name"
        elif key == "publisherName":
            suggest = "publisher_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublisherInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublisherInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublisherInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 binary_name: Optional[str] = None,
                 product_name: Optional[str] = None,
                 publisher_name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Represents the publisher information of a process/rule
        :param str binary_name: The "OriginalName" field taken from the file's version resource
        :param str product_name: The product name taken from the file's version resource
        :param str publisher_name: The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        :param str version: The binary file version taken from the file's version resource
        """
        if binary_name is not None:
            pulumi.set(__self__, "binary_name", binary_name)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if publisher_name is not None:
            pulumi.set(__self__, "publisher_name", publisher_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="binaryName")
    def binary_name(self) -> Optional[str]:
        """
        The "OriginalName" field taken from the file's version resource
        """
        return pulumi.get(self, "binary_name")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[str]:
        """
        The product name taken from the file's version resource
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> Optional[str]:
        """
        The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        """
        return pulumi.get(self, "publisher_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The binary file version taken from the file's version resource
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RecommendationConfigurationPropertiesResponse(dict):
    """
    The type of IoT Security recommendation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recommendationType":
            suggest = "recommendation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecommendationConfigurationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecommendationConfigurationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecommendationConfigurationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 recommendation_type: str,
                 status: str):
        """
        The type of IoT Security recommendation.
        :param str recommendation_type: The type of IoT Security recommendation.
        :param str status: Recommendation status. When the recommendation status is disabled recommendations are not generated.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recommendation_type", recommendation_type)
        if status is None:
            status = 'Enabled'
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationType")
    def recommendation_type(self) -> str:
        """
        The type of IoT Security recommendation.
        """
        return pulumi.get(self, "recommendation_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Recommendation status. When the recommendation status is disabled recommendations are not generated.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RuleResultsPropertiesResponse(dict):
    """
    Rule results properties.
    """
    def __init__(__self__, *,
                 results: Optional[Sequence[Sequence[str]]] = None):
        """
        Rule results properties.
        :param Sequence[Sequence[str]] results: Expected results in the baseline.
        """
        if results is not None:
            pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter
    def results(self) -> Optional[Sequence[Sequence[str]]]:
        """
        Expected results in the baseline.
        """
        return pulumi.get(self, "results")


@pulumi.output_type
class ScopeElementResponse(dict):
    """
    A more specific scope used to identify the alerts to suppress.
    """
    def __init__(__self__, *,
                 field: Optional[str] = None):
        """
        A more specific scope used to identify the alerts to suppress.
        :param str field: The alert entity type to suppress by.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        The alert entity type to suppress by.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class SecurityAssessmentMetadataPartnerDataResponse(dict):
    """
    Describes the partner that created the assessment
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partnerName":
            suggest = "partner_name"
        elif key == "productName":
            suggest = "product_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityAssessmentMetadataPartnerDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityAssessmentMetadataPartnerDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityAssessmentMetadataPartnerDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partner_name: str,
                 secret: str,
                 product_name: Optional[str] = None):
        """
        Describes the partner that created the assessment
        :param str partner_name: Name of the company of the partner
        :param str secret: Secret to authenticate the partner and verify it created the assessment - write only
        :param str product_name: Name of the product of the partner that created the assessment
        """
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "secret", secret)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> str:
        """
        Name of the company of the partner
        """
        return pulumi.get(self, "partner_name")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        Secret to authenticate the partner and verify it created the assessment - write only
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[str]:
        """
        Name of the product of the partner that created the assessment
        """
        return pulumi.get(self, "product_name")


@pulumi.output_type
class SecurityAssessmentMetadataPropertiesResponse(dict):
    """
    Describes properties of an assessment metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assessmentType":
            suggest = "assessment_type"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "policyDefinitionId":
            suggest = "policy_definition_id"
        elif key == "implementationEffort":
            suggest = "implementation_effort"
        elif key == "partnerData":
            suggest = "partner_data"
        elif key == "remediationDescription":
            suggest = "remediation_description"
        elif key == "userImpact":
            suggest = "user_impact"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityAssessmentMetadataPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityAssessmentMetadataPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityAssessmentMetadataPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assessment_type: str,
                 display_name: str,
                 policy_definition_id: str,
                 severity: str,
                 categories: Optional[Sequence[str]] = None,
                 description: Optional[str] = None,
                 implementation_effort: Optional[str] = None,
                 partner_data: Optional['outputs.SecurityAssessmentMetadataPartnerDataResponse'] = None,
                 preview: Optional[bool] = None,
                 remediation_description: Optional[str] = None,
                 threats: Optional[Sequence[str]] = None,
                 user_impact: Optional[str] = None):
        """
        Describes properties of an assessment metadata.
        :param str assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
        :param str display_name: User friendly display name of the assessment
        :param str policy_definition_id: Azure resource ID of the policy definition that turns this assessment calculation on
        :param str severity: The severity level of the assessment
        :param str description: Human readable description of the assessment
        :param str implementation_effort: The implementation effort required to remediate this assessment
        :param 'SecurityAssessmentMetadataPartnerDataResponse' partner_data: Describes the partner that created the assessment
        :param bool preview: True if this assessment is in preview release status
        :param str remediation_description: Human readable description of what you should do to mitigate this security issue
        :param str user_impact: The user impact of the assessment
        """
        pulumi.set(__self__, "assessment_type", assessment_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "policy_definition_id", policy_definition_id)
        pulumi.set(__self__, "severity", severity)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if implementation_effort is not None:
            pulumi.set(__self__, "implementation_effort", implementation_effort)
        if partner_data is not None:
            pulumi.set(__self__, "partner_data", partner_data)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if remediation_description is not None:
            pulumi.set(__self__, "remediation_description", remediation_description)
        if threats is not None:
            pulumi.set(__self__, "threats", threats)
        if user_impact is not None:
            pulumi.set(__self__, "user_impact", user_impact)

    @property
    @pulumi.getter(name="assessmentType")
    def assessment_type(self) -> str:
        """
        BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
        """
        return pulumi.get(self, "assessment_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User friendly display name of the assessment
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="policyDefinitionId")
    def policy_definition_id(self) -> str:
        """
        Azure resource ID of the policy definition that turns this assessment calculation on
        """
        return pulumi.get(self, "policy_definition_id")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity level of the assessment
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Human readable description of the assessment
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="implementationEffort")
    def implementation_effort(self) -> Optional[str]:
        """
        The implementation effort required to remediate this assessment
        """
        return pulumi.get(self, "implementation_effort")

    @property
    @pulumi.getter(name="partnerData")
    def partner_data(self) -> Optional['outputs.SecurityAssessmentMetadataPartnerDataResponse']:
        """
        Describes the partner that created the assessment
        """
        return pulumi.get(self, "partner_data")

    @property
    @pulumi.getter
    def preview(self) -> Optional[bool]:
        """
        True if this assessment is in preview release status
        """
        return pulumi.get(self, "preview")

    @property
    @pulumi.getter(name="remediationDescription")
    def remediation_description(self) -> Optional[str]:
        """
        Human readable description of what you should do to mitigate this security issue
        """
        return pulumi.get(self, "remediation_description")

    @property
    @pulumi.getter
    def threats(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "threats")

    @property
    @pulumi.getter(name="userImpact")
    def user_impact(self) -> Optional[str]:
        """
        The user impact of the assessment
        """
        return pulumi.get(self, "user_impact")


@pulumi.output_type
class SecurityAssessmentPartnerDataResponse(dict):
    """
    Data regarding 3rd party partner integration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partnerName":
            suggest = "partner_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityAssessmentPartnerDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityAssessmentPartnerDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityAssessmentPartnerDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partner_name: str,
                 secret: str):
        """
        Data regarding 3rd party partner integration
        :param str partner_name: Name of the company of the partner
        :param str secret: secret to authenticate the partner - write only
        """
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> str:
        """
        Name of the company of the partner
        """
        return pulumi.get(self, "partner_name")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        secret to authenticate the partner - write only
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class SecurityContactPropertiesResponseAlertNotifications(dict):
    """
    Defines whether to send email notifications about new security alerts
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimalSeverity":
            suggest = "minimal_severity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityContactPropertiesResponseAlertNotifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityContactPropertiesResponseAlertNotifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityContactPropertiesResponseAlertNotifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minimal_severity: Optional[str] = None,
                 state: Optional[str] = None):
        """
        Defines whether to send email notifications about new security alerts
        :param str minimal_severity: Defines the minimal alert severity which will be sent as email notifications
        :param str state: Defines if email notifications will be sent about new security alerts
        """
        if minimal_severity is not None:
            pulumi.set(__self__, "minimal_severity", minimal_severity)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="minimalSeverity")
    def minimal_severity(self) -> Optional[str]:
        """
        Defines the minimal alert severity which will be sent as email notifications
        """
        return pulumi.get(self, "minimal_severity")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Defines if email notifications will be sent about new security alerts
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class SecurityContactPropertiesResponseNotificationsByRole(dict):
    """
    Defines whether to send email notifications from Azure Security Center to persons with specific RBAC roles on the subscription.
    """
    def __init__(__self__, *,
                 roles: Optional[Sequence[str]] = None,
                 state: Optional[str] = None):
        """
        Defines whether to send email notifications from Azure Security Center to persons with specific RBAC roles on the subscription.
        :param Sequence[str] roles: Defines which RBAC roles will get email notifications from Azure Security Center. List of allowed RBAC roles: 
        :param str state: Defines whether to send email notifications from Azure Security Center to persons with specific RBAC roles on the subscription.
        """
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def roles(self) -> Optional[Sequence[str]]:
        """
        Defines which RBAC roles will get email notifications from Azure Security Center. List of allowed RBAC roles: 
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Defines whether to send email notifications from Azure Security Center to persons with specific RBAC roles on the subscription.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ServicePrincipalPropertiesResponse(dict):
    """
    Details of the service principal.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePrincipalPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePrincipalPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePrincipalPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: Optional[str] = None,
                 secret: Optional[str] = None):
        """
        Details of the service principal.
        :param str application_id: Application ID of service principal.
        :param str secret: A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        Application ID of service principal.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def secret(self) -> Optional[str]:
        """
        A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class SuppressionAlertsScopeResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allOf":
            suggest = "all_of"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SuppressionAlertsScopeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SuppressionAlertsScopeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SuppressionAlertsScopeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_of: Sequence['outputs.ScopeElementResponse']):
        """
        :param Sequence['ScopeElementResponse'] all_of: All the conditions inside need to be true in order to suppress the alert
        """
        pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Sequence['outputs.ScopeElementResponse']:
        """
        All the conditions inside need to be true in order to suppress the alert
        """
        return pulumi.get(self, "all_of")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class ThresholdCustomAlertRuleResponse(dict):
    """
    A custom alert rule that checks if a value (depends on the custom alert type) is within the given range.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "maxThreshold":
            suggest = "max_threshold"
        elif key == "minThreshold":
            suggest = "min_threshold"
        elif key == "ruleType":
            suggest = "rule_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThresholdCustomAlertRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThresholdCustomAlertRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThresholdCustomAlertRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 is_enabled: bool,
                 max_threshold: int,
                 min_threshold: int,
                 rule_type: str):
        """
        A custom alert rule that checks if a value (depends on the custom alert type) is within the given range.
        :param str description: The description of the custom alert.
        :param str display_name: The display name of the custom alert.
        :param bool is_enabled: Status of the custom alert.
        :param int max_threshold: The maximum threshold.
        :param int min_threshold: The minimum threshold.
        :param str rule_type: The type of the custom alert rule.
               Expected value is 'ThresholdCustomAlertRule'.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "max_threshold", max_threshold)
        pulumi.set(__self__, "min_threshold", min_threshold)
        pulumi.set(__self__, "rule_type", 'ThresholdCustomAlertRule')

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the custom alert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the custom alert.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Status of the custom alert.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxThreshold")
    def max_threshold(self) -> int:
        """
        The maximum threshold.
        """
        return pulumi.get(self, "max_threshold")

    @property
    @pulumi.getter(name="minThreshold")
    def min_threshold(self) -> int:
        """
        The minimum threshold.
        """
        return pulumi.get(self, "min_threshold")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of the custom alert rule.
        Expected value is 'ThresholdCustomAlertRule'.
        """
        return pulumi.get(self, "rule_type")


@pulumi.output_type
class TimeWindowCustomAlertRuleResponse(dict):
    """
    A custom alert rule that checks if the number of activities (depends on the custom alert type) in a time window is within the given range.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "maxThreshold":
            suggest = "max_threshold"
        elif key == "minThreshold":
            suggest = "min_threshold"
        elif key == "ruleType":
            suggest = "rule_type"
        elif key == "timeWindowSize":
            suggest = "time_window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeWindowCustomAlertRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeWindowCustomAlertRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeWindowCustomAlertRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 is_enabled: bool,
                 max_threshold: int,
                 min_threshold: int,
                 rule_type: str,
                 time_window_size: str):
        """
        A custom alert rule that checks if the number of activities (depends on the custom alert type) in a time window is within the given range.
        :param str description: The description of the custom alert.
        :param str display_name: The display name of the custom alert.
        :param bool is_enabled: Status of the custom alert.
        :param int max_threshold: The maximum threshold.
        :param int min_threshold: The minimum threshold.
        :param str rule_type: The type of the custom alert rule.
               Expected value is 'TimeWindowCustomAlertRule'.
        :param str time_window_size: The time window size in iso8601 format.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "max_threshold", max_threshold)
        pulumi.set(__self__, "min_threshold", min_threshold)
        pulumi.set(__self__, "rule_type", 'TimeWindowCustomAlertRule')
        pulumi.set(__self__, "time_window_size", time_window_size)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the custom alert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the custom alert.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Status of the custom alert.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxThreshold")
    def max_threshold(self) -> int:
        """
        The maximum threshold.
        """
        return pulumi.get(self, "max_threshold")

    @property
    @pulumi.getter(name="minThreshold")
    def min_threshold(self) -> int:
        """
        The minimum threshold.
        """
        return pulumi.get(self, "min_threshold")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of the custom alert rule.
        Expected value is 'TimeWindowCustomAlertRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="timeWindowSize")
    def time_window_size(self) -> str:
        """
        The time window size in iso8601 format.
        """
        return pulumi.get(self, "time_window_size")


@pulumi.output_type
class UserDefinedResourcesPropertiesResponse(dict):
    """
    Properties of the IoT Security solution's user defined resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "querySubscriptions":
            suggest = "query_subscriptions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserDefinedResourcesPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserDefinedResourcesPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserDefinedResourcesPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query: str,
                 query_subscriptions: Sequence[str]):
        """
        Properties of the IoT Security solution's user defined resources.
        :param str query: Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs""
        :param Sequence[str] query_subscriptions: List of Azure subscription ids on which the user defined resources query should be executed.
        """
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "query_subscriptions", query_subscriptions)

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs""
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="querySubscriptions")
    def query_subscriptions(self) -> Sequence[str]:
        """
        List of Azure subscription ids on which the user defined resources query should be executed.
        """
        return pulumi.get(self, "query_subscriptions")


@pulumi.output_type
class UserRecommendationResponse(dict):
    """
    Represents a user that is recommended to be allowed for a certain rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recommendationAction":
            suggest = "recommendation_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserRecommendationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserRecommendationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserRecommendationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recommendation_action: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Represents a user that is recommended to be allowed for a certain rule
        :param str recommendation_action: The recommendation action of the machine or rule
        :param str username: Represents a user that is recommended to be allowed for a certain rule
        """
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[str]:
        """
        The recommendation action of the machine or rule
        """
        return pulumi.get(self, "recommendation_action")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Represents a user that is recommended to be allowed for a certain rule
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class VmRecommendationResponse(dict):
    """
    Represents a machine that is part of a machine group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationStatus":
            suggest = "configuration_status"
        elif key == "enforcementSupport":
            suggest = "enforcement_support"
        elif key == "recommendationAction":
            suggest = "recommendation_action"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmRecommendationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmRecommendationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmRecommendationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_status: Optional[str] = None,
                 enforcement_support: Optional[str] = None,
                 recommendation_action: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Represents a machine that is part of a machine group
        :param str configuration_status: The configuration status of the machines group or machine or rule
        :param str enforcement_support: The machine supportability of Enforce feature
        :param str recommendation_action: The recommendation action of the machine or rule
        :param str resource_id: The full resource id of the machine
        """
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if enforcement_support is not None:
            pulumi.set(__self__, "enforcement_support", enforcement_support)
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[str]:
        """
        The configuration status of the machines group or machine or rule
        """
        return pulumi.get(self, "configuration_status")

    @property
    @pulumi.getter(name="enforcementSupport")
    def enforcement_support(self) -> Optional[str]:
        """
        The machine supportability of Enforce feature
        """
        return pulumi.get(self, "enforcement_support")

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[str]:
        """
        The recommendation action of the machine or rule
        """
        return pulumi.get(self, "recommendation_action")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The full resource id of the machine
        """
        return pulumi.get(self, "resource_id")


