# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetActionGroupResult',
    'AwaitableGetActionGroupResult',
    'get_action_group',
]

@pulumi.output_type
class GetActionGroupResult:
    """
    An action group resource.
    """
    def __init__(__self__, automation_runbook_receivers=None, azure_app_push_receivers=None, email_receivers=None, enabled=None, group_short_name=None, id=None, itsm_receivers=None, location=None, name=None, sms_receivers=None, tags=None, type=None, webhook_receivers=None):
        if automation_runbook_receivers and not isinstance(automation_runbook_receivers, list):
            raise TypeError("Expected argument 'automation_runbook_receivers' to be a list")
        pulumi.set(__self__, "automation_runbook_receivers", automation_runbook_receivers)
        if azure_app_push_receivers and not isinstance(azure_app_push_receivers, list):
            raise TypeError("Expected argument 'azure_app_push_receivers' to be a list")
        pulumi.set(__self__, "azure_app_push_receivers", azure_app_push_receivers)
        if email_receivers and not isinstance(email_receivers, list):
            raise TypeError("Expected argument 'email_receivers' to be a list")
        pulumi.set(__self__, "email_receivers", email_receivers)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if group_short_name and not isinstance(group_short_name, str):
            raise TypeError("Expected argument 'group_short_name' to be a str")
        pulumi.set(__self__, "group_short_name", group_short_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if itsm_receivers and not isinstance(itsm_receivers, list):
            raise TypeError("Expected argument 'itsm_receivers' to be a list")
        pulumi.set(__self__, "itsm_receivers", itsm_receivers)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sms_receivers and not isinstance(sms_receivers, list):
            raise TypeError("Expected argument 'sms_receivers' to be a list")
        pulumi.set(__self__, "sms_receivers", sms_receivers)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if webhook_receivers and not isinstance(webhook_receivers, list):
            raise TypeError("Expected argument 'webhook_receivers' to be a list")
        pulumi.set(__self__, "webhook_receivers", webhook_receivers)

    @property
    @pulumi.getter(name="automationRunbookReceivers")
    def automation_runbook_receivers(self) -> Optional[Sequence['outputs.AutomationRunbookReceiverResponse']]:
        """
        The list of AutomationRunbook receivers that are part of this action group.
        """
        return pulumi.get(self, "automation_runbook_receivers")

    @property
    @pulumi.getter(name="azureAppPushReceivers")
    def azure_app_push_receivers(self) -> Optional[Sequence['outputs.AzureAppPushReceiverResponse']]:
        """
        The list of AzureAppPush receivers that are part of this action group.
        """
        return pulumi.get(self, "azure_app_push_receivers")

    @property
    @pulumi.getter(name="emailReceivers")
    def email_receivers(self) -> Optional[Sequence['outputs.EmailReceiverResponse']]:
        """
        The list of email receivers that are part of this action group.
        """
        return pulumi.get(self, "email_receivers")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="groupShortName")
    def group_short_name(self) -> str:
        """
        The short name of the action group. This will be used in SMS messages.
        """
        return pulumi.get(self, "group_short_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="itsmReceivers")
    def itsm_receivers(self) -> Optional[Sequence['outputs.ItsmReceiverResponse']]:
        """
        The list of ITSM receivers that are part of this action group.
        """
        return pulumi.get(self, "itsm_receivers")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Azure resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="smsReceivers")
    def sms_receivers(self) -> Optional[Sequence['outputs.SmsReceiverResponse']]:
        """
        The list of SMS receivers that are part of this action group.
        """
        return pulumi.get(self, "sms_receivers")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Azure resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="webhookReceivers")
    def webhook_receivers(self) -> Optional[Sequence['outputs.WebhookReceiverResponse']]:
        """
        The list of webhook receivers that are part of this action group.
        """
        return pulumi.get(self, "webhook_receivers")


class AwaitableGetActionGroupResult(GetActionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActionGroupResult(
            automation_runbook_receivers=self.automation_runbook_receivers,
            azure_app_push_receivers=self.azure_app_push_receivers,
            email_receivers=self.email_receivers,
            enabled=self.enabled,
            group_short_name=self.group_short_name,
            id=self.id,
            itsm_receivers=self.itsm_receivers,
            location=self.location,
            name=self.name,
            sms_receivers=self.sms_receivers,
            tags=self.tags,
            type=self.type,
            webhook_receivers=self.webhook_receivers)


def get_action_group(action_group_name: Optional[str] = None,
                     resource_group_name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActionGroupResult:
    """
    An action group resource.


    :param str action_group_name: The name of the action group.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['actionGroupName'] = action_group_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:insights/v20170401:getActionGroup', __args__, opts=opts, typ=GetActionGroupResult).value

    return AwaitableGetActionGroupResult(
        automation_runbook_receivers=__ret__.automation_runbook_receivers,
        azure_app_push_receivers=__ret__.azure_app_push_receivers,
        email_receivers=__ret__.email_receivers,
        enabled=__ret__.enabled,
        group_short_name=__ret__.group_short_name,
        id=__ret__.id,
        itsm_receivers=__ret__.itsm_receivers,
        location=__ret__.location,
        name=__ret__.name,
        sms_receivers=__ret__.sms_receivers,
        tags=__ret__.tags,
        type=__ret__.type,
        webhook_receivers=__ret__.webhook_receivers)
