# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AgentPoolMode',
    'AgentPoolType',
    'ConnectionStatus',
    'Expander',
    'ExtendedLocationTypes',
    'GPUInstanceProfile',
    'KubeletDiskType',
    'LicenseType',
    'LoadBalancerSku',
    'ManagedClusterSKUName',
    'ManagedClusterSKUTier',
    'NetworkMode',
    'NetworkPlugin',
    'NetworkPolicy',
    'OSDiskType',
    'OSSKU',
    'OSType',
    'OutboundType',
    'ResourceIdentityType',
    'ScaleSetEvictionPolicy',
    'ScaleSetPriority',
    'UpgradeChannel',
    'WeekDay',
]


class AgentPoolMode(str, Enum):
    """
    A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
    """
    SYSTEM = "System"
    USER = "User"


class AgentPoolType(str, Enum):
    """
    The type of Agent Pool.
    """
    VIRTUAL_MACHINE_SCALE_SETS = "VirtualMachineScaleSets"
    AVAILABILITY_SET = "AvailabilitySet"


class ConnectionStatus(str, Enum):
    """
    The private link service connection status.
    """
    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class Expander(str, Enum):
    """
    If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
    """
    LEAST_WASTE = "least-waste"
    MOST_PODS = "most-pods"
    PRIORITY = "priority"
    RANDOM = "random"


class ExtendedLocationTypes(str, Enum):
    """
    The type of the extended location.
    """
    EDGE_ZONE = "EdgeZone"


class GPUInstanceProfile(str, Enum):
    """
    GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
    """
    MIG1G = "MIG1g"
    MIG2G = "MIG2g"
    MIG3G = "MIG3g"
    MIG4G = "MIG4g"
    MIG7G = "MIG7g"


class KubeletDiskType(str, Enum):
    """
    Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
    """
    OS = "OS"
    TEMPORARY = "Temporary"


class LicenseType(str, Enum):
    """
    The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
    """
    NONE = "None"
    WINDOWS_SERVER = "Windows_Server"


class LoadBalancerSku(str, Enum):
    """
    The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
    """
    STANDARD = "standard"
    BASIC = "basic"


class ManagedClusterSKUName(str, Enum):
    """
    The name of a managed cluster SKU.
    """
    BASIC = "Basic"


class ManagedClusterSKUTier(str, Enum):
    """
    If not specified, the default is 'Free'. See [uptime SLA](https://docs.microsoft.com/azure/aks/uptime-sla) for more details.
    """
    PAID = "Paid"
    FREE = "Free"


class NetworkMode(str, Enum):
    """
    This cannot be specified if networkPlugin is anything other than 'azure'.
    """
    TRANSPARENT = "transparent"
    BRIDGE = "bridge"


class NetworkPlugin(str, Enum):
    """
    Network plugin used for building the Kubernetes network.
    """
    AZURE = "azure"
    KUBENET = "kubenet"


class NetworkPolicy(str, Enum):
    """
    Network policy used for building the Kubernetes network.
    """
    CALICO = "calico"
    AZURE = "azure"


class OSDiskType(str, Enum):
    """
    The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
    """
    MANAGED = "Managed"
    EPHEMERAL = "Ephemeral"


class OSSKU(str, Enum):
    """
    Specifies an OS SKU. This value must not be specified if OSType is Windows.
    """
    UBUNTU = "Ubuntu"
    CBL_MARINER = "CBLMariner"


class OSType(str, Enum):
    """
    The operating system type. The default is Linux.
    """
    LINUX = "Linux"
    WINDOWS = "Windows"


class OutboundType(str, Enum):
    """
    This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
    """
    LOAD_BALANCER = "loadBalancer"
    USER_DEFINED_ROUTING = "userDefinedRouting"


class ResourceIdentityType(str, Enum):
    """
    For more information see [use managed identities in AKS](https://docs.microsoft.com/azure/aks/use-managed-identity).
    """
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    NONE = "None"


class ScaleSetEvictionPolicy(str, Enum):
    """
    This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
    """
    DELETE = "Delete"
    DEALLOCATE = "Deallocate"


class ScaleSetPriority(str, Enum):
    """
    The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
    """
    SPOT = "Spot"
    REGULAR = "Regular"


class UpgradeChannel(str, Enum):
    """
    For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
    """
    RAPID = "rapid"
    STABLE = "stable"
    PATCH = "patch"
    NODE_IMAGE = "node-image"
    NONE = "none"


class WeekDay(str, Enum):
    """
    The day of the week.
    """
    SUNDAY = "Sunday"
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
