# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AclResponse',
    'AttributesResponse',
    'DiskResponse',
    'IscsiLunResponse',
    'SystemMetadataResponse',
    'TargetPortalGroupResponse',
]

@pulumi.output_type
class AclResponse(dict):
    """
    Access Control List (ACL) for an iSCSI target portal group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initiatorIqn":
            suggest = "initiator_iqn"
        elif key == "mappedLuns":
            suggest = "mapped_luns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initiator_iqn: str,
                 mapped_luns: Sequence[str],
                 password: str,
                 username: str):
        """
        Access Control List (ACL) for an iSCSI target portal group
        :param str initiator_iqn: iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client".
        :param Sequence[str] mapped_luns: List of LUN names mapped to the ACL.
        :param str password: Password for Challenge Handshake Authentication Protocol (CHAP) authentication.
        :param str username: Username for Challenge Handshake Authentication Protocol (CHAP) authentication.
        """
        pulumi.set(__self__, "initiator_iqn", initiator_iqn)
        pulumi.set(__self__, "mapped_luns", mapped_luns)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="initiatorIqn")
    def initiator_iqn(self) -> str:
        """
        iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client".
        """
        return pulumi.get(self, "initiator_iqn")

    @property
    @pulumi.getter(name="mappedLuns")
    def mapped_luns(self) -> Sequence[str]:
        """
        List of LUN names mapped to the ACL.
        """
        return pulumi.get(self, "mapped_luns")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for Challenge Handshake Authentication Protocol (CHAP) authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for Challenge Handshake Authentication Protocol (CHAP) authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class AttributesResponse(dict):
    """
    Attributes of a iSCSI target portal group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prodModeWriteProtect":
            suggest = "prod_mode_write_protect"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttributesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttributesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttributesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication: bool,
                 prod_mode_write_protect: bool):
        """
        Attributes of a iSCSI target portal group.
        :param bool authentication: Indicates whether or not authentication is enabled on the ACL.
        :param bool prod_mode_write_protect: Indicates whether or not write protect is enabled on the LUNs.
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "prod_mode_write_protect", prod_mode_write_protect)

    @property
    @pulumi.getter
    def authentication(self) -> bool:
        """
        Indicates whether or not authentication is enabled on the ACL.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="prodModeWriteProtect")
    def prod_mode_write_protect(self) -> bool:
        """
        Indicates whether or not write protect is enabled on the LUNs.
        """
        return pulumi.get(self, "prod_mode_write_protect")


@pulumi.output_type
class DiskResponse(dict):
    """
    Azure Managed Disk to attach to the Disk pool.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Azure Managed Disk to attach to the Disk pool.
        :param str id: Unique Azure Resource ID of the Managed Disk.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique Azure Resource ID of the Managed Disk.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class IscsiLunResponse(dict):
    """
    LUN to expose the Azure Managed Disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedDiskAzureResourceId":
            suggest = "managed_disk_azure_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IscsiLunResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IscsiLunResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IscsiLunResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_disk_azure_resource_id: str,
                 name: str):
        """
        LUN to expose the Azure Managed Disk.
        :param str managed_disk_azure_resource_id: Azure Resource ID of the Managed Disk.
        :param str name: User defined name for iSCSI LUN; example: "lun0"
        """
        pulumi.set(__self__, "managed_disk_azure_resource_id", managed_disk_azure_resource_id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="managedDiskAzureResourceId")
    def managed_disk_azure_resource_id(self) -> str:
        """
        Azure Resource ID of the Managed Disk.
        """
        return pulumi.get(self, "managed_disk_azure_resource_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        User defined name for iSCSI LUN; example: "lun0"
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SystemMetadataResponse(dict):
    """
    Resource metadata required by ARM RPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Resource metadata required by ARM RPC.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: A string identifier for the identity that created the resource.
        :param str created_by_type: The type of identity that created the resource: user, application, managedIdentity.
        :param str last_modified_at: The timestamp of resource last modification (UTC).
        :param str last_modified_by: A string identifier for the identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource: user, application, managedIdentity.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        A string identifier for the identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource: user, application, managedIdentity.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        A string identifier for the identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource: user, application, managedIdentity.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TargetPortalGroupResponse(dict):
    """
    Response properties for iSCSI target portal group.
    """
    def __init__(__self__, *,
                 acls: Sequence['outputs.AclResponse'],
                 attributes: 'outputs.AttributesResponse',
                 endpoints: Sequence[str],
                 luns: Sequence['outputs.IscsiLunResponse'],
                 port: int,
                 tag: int):
        """
        Response properties for iSCSI target portal group.
        :param Sequence['AclResponse'] acls: Access Control List (ACL) for an iSCSI target portal group.
        :param 'AttributesResponse' attributes: Attributes of an iSCSI target portal group.
        :param Sequence[str] endpoints: List of private IPv4 addresses to connect to the iSCSI target.
        :param Sequence['IscsiLunResponse'] luns: List of LUNs to be exposed through iSCSI target portal group.
        :param int port: The port used by iSCSI target portal group.
        :param int tag: The tag associated with the iSCSI target portal group.
        """
        pulumi.set(__self__, "acls", acls)
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "luns", luns)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def acls(self) -> Sequence['outputs.AclResponse']:
        """
        Access Control List (ACL) for an iSCSI target portal group.
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter
    def attributes(self) -> 'outputs.AttributesResponse':
        """
        Attributes of an iSCSI target portal group.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence[str]:
        """
        List of private IPv4 addresses to connect to the iSCSI target.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def luns(self) -> Sequence['outputs.IscsiLunResponse']:
        """
        List of LUNs to be exposed through iSCSI target portal group.
        """
        return pulumi.get(self, "luns")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port used by iSCSI target portal group.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def tag(self) -> int:
        """
        The tag associated with the iSCSI target portal group.
        """
        return pulumi.get(self, "tag")


