# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'ApplicationDeltaHealthPolicyArgs',
    'ApplicationHealthPolicyArgs',
    'ApplicationMetricDescriptionArgs',
    'ApplicationTypeVersionsCleanupPolicyArgs',
    'ApplicationUpgradePolicyArgs',
    'ApplicationUserAssignedIdentityArgs',
    'ArmApplicationHealthPolicyArgs',
    'ArmRollingUpgradeMonitoringPolicyArgs',
    'ArmServiceTypeHealthPolicyArgs',
    'AzureActiveDirectoryArgs',
    'CertificateDescriptionArgs',
    'ClientCertificateArgs',
    'ClientCertificateCommonNameArgs',
    'ClientCertificateThumbprintArgs',
    'ClusterHealthPolicyArgs',
    'ClusterUpgradeDeltaHealthPolicyArgs',
    'ClusterUpgradePolicyArgs',
    'DiagnosticsStorageAccountConfigArgs',
    'EndpointRangeDescriptionArgs',
    'LoadBalancingRuleArgs',
    'ManagedIdentityArgs',
    'NamedPartitionSchemeDescriptionArgs',
    'NodeTypeDescriptionArgs',
    'ServerCertificateCommonNameArgs',
    'ServerCertificateCommonNamesArgs',
    'ServiceCorrelationDescriptionArgs',
    'ServiceLoadMetricDescriptionArgs',
    'ServicePlacementPolicyDescriptionArgs',
    'ServiceTypeDeltaHealthPolicyArgs',
    'ServiceTypeHealthPolicyArgs',
    'SettingsParameterDescriptionArgs',
    'SettingsSectionDescriptionArgs',
    'SingletonPartitionSchemeDescriptionArgs',
    'SkuArgs',
    'SubResourceArgs',
    'UniformInt64RangePartitionSchemeDescriptionArgs',
    'VMSSExtensionArgs',
    'VaultCertificateArgs',
    'VaultSecretGroupArgs',
]

@pulumi.input_type
class ApplicationDeltaHealthPolicyArgs:
    def __init__(__self__, *,
                 default_service_type_delta_health_policy: Optional[pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']] = None,
                 service_type_delta_health_policies: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]]] = None):
        """
        Defines a delta health policy used to evaluate the health of an application or one of its child entities when upgrading the cluster.

        :param pulumi.Input['ServiceTypeDeltaHealthPolicyArgs'] default_service_type_delta_health_policy: The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]] service_type_delta_health_policies: The map with service type delta health policy per service type name. The map is empty by default.
        """
        if default_service_type_delta_health_policy is not None:
            pulumi.set(__self__, "default_service_type_delta_health_policy", default_service_type_delta_health_policy)
        if service_type_delta_health_policies is not None:
            pulumi.set(__self__, "service_type_delta_health_policies", service_type_delta_health_policies)

    @property
    @pulumi.getter(name="defaultServiceTypeDeltaHealthPolicy")
    def default_service_type_delta_health_policy(self) -> Optional[pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]:
        """
        The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
        """
        return pulumi.get(self, "default_service_type_delta_health_policy")

    @default_service_type_delta_health_policy.setter
    def default_service_type_delta_health_policy(self, value: Optional[pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]):
        pulumi.set(self, "default_service_type_delta_health_policy", value)

    @property
    @pulumi.getter(name="serviceTypeDeltaHealthPolicies")
    def service_type_delta_health_policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]]]:
        """
        The map with service type delta health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_delta_health_policies")

    @service_type_delta_health_policies.setter
    def service_type_delta_health_policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeDeltaHealthPolicyArgs']]]]):
        pulumi.set(self, "service_type_delta_health_policies", value)


@pulumi.input_type
class ApplicationHealthPolicyArgs:
    def __init__(__self__, *,
                 default_service_type_health_policy: Optional[pulumi.Input['ServiceTypeHealthPolicyArgs']] = None,
                 service_type_health_policies: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]]] = None):
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.

        :param pulumi.Input['ServiceTypeHealthPolicyArgs'] default_service_type_health_policy: The health policy used by default to evaluate the health of a service type.
        :param pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]] service_type_health_policies: The map with service type health policy per service type name. The map is empty by default.
        """
        if default_service_type_health_policy is not None:
            pulumi.set(__self__, "default_service_type_health_policy", default_service_type_health_policy)
        if service_type_health_policies is not None:
            pulumi.set(__self__, "service_type_health_policies", service_type_health_policies)

    @property
    @pulumi.getter(name="defaultServiceTypeHealthPolicy")
    def default_service_type_health_policy(self) -> Optional[pulumi.Input['ServiceTypeHealthPolicyArgs']]:
        """
        The health policy used by default to evaluate the health of a service type.
        """
        return pulumi.get(self, "default_service_type_health_policy")

    @default_service_type_health_policy.setter
    def default_service_type_health_policy(self, value: Optional[pulumi.Input['ServiceTypeHealthPolicyArgs']]):
        pulumi.set(self, "default_service_type_health_policy", value)

    @property
    @pulumi.getter(name="serviceTypeHealthPolicies")
    def service_type_health_policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]]]:
        """
        The map with service type health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_health_policies")

    @service_type_health_policies.setter
    def service_type_health_policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ServiceTypeHealthPolicyArgs']]]]):
        pulumi.set(self, "service_type_health_policies", value)


@pulumi.input_type
class ApplicationMetricDescriptionArgs:
    def __init__(__self__, *,
                 maximum_capacity: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reservation_capacity: Optional[pulumi.Input[float]] = None,
                 total_application_capacity: Optional[pulumi.Input[float]] = None):
        """
        Describes capacity information for a custom resource balancing metric. This can be used to limit the total consumption of this metric by the services of this application.

        :param pulumi.Input[float] maximum_capacity: The maximum node capacity for Service Fabric application.
               This is the maximum Load for an instance of this application on a single node. Even if the capacity of node is greater than this value, Service Fabric will limit the total load of services within the application on each node to this value.
               If set to zero, capacity for this metric is unlimited on each node.
               When creating a new application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
               When updating existing application with application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
        :param pulumi.Input[str] name: The name of the metric.
        :param pulumi.Input[float] reservation_capacity: The node reservation capacity for Service Fabric application.
               This is the amount of load which is reserved on nodes which have instances of this application.
               If MinimumNodes is specified, then the product of these values will be the capacity reserved in the cluster for the application.
               If set to zero, no capacity is reserved for this metric.
               When setting application capacity or when updating application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
        :param pulumi.Input[float] total_application_capacity: The total metric capacity for Service Fabric application.
               This is the total metric capacity for this application in the cluster. Service Fabric will try to limit the sum of loads of services within the application to this value.
               When creating a new application with application capacity defined, the product of MaximumNodes and MaximumCapacity must always be smaller than or equal to this value.
        """
        if maximum_capacity is not None:
            pulumi.set(__self__, "maximum_capacity", maximum_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reservation_capacity is not None:
            pulumi.set(__self__, "reservation_capacity", reservation_capacity)
        if total_application_capacity is not None:
            pulumi.set(__self__, "total_application_capacity", total_application_capacity)

    @property
    @pulumi.getter(name="maximumCapacity")
    def maximum_capacity(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum node capacity for Service Fabric application.
        This is the maximum Load for an instance of this application on a single node. Even if the capacity of node is greater than this value, Service Fabric will limit the total load of services within the application on each node to this value.
        If set to zero, capacity for this metric is unlimited on each node.
        When creating a new application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
        When updating existing application with application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
        """
        return pulumi.get(self, "maximum_capacity")

    @maximum_capacity.setter
    def maximum_capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "maximum_capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="reservationCapacity")
    def reservation_capacity(self) -> Optional[pulumi.Input[float]]:
        """
        The node reservation capacity for Service Fabric application.
        This is the amount of load which is reserved on nodes which have instances of this application.
        If MinimumNodes is specified, then the product of these values will be the capacity reserved in the cluster for the application.
        If set to zero, no capacity is reserved for this metric.
        When setting application capacity or when updating application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
        """
        return pulumi.get(self, "reservation_capacity")

    @reservation_capacity.setter
    def reservation_capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "reservation_capacity", value)

    @property
    @pulumi.getter(name="totalApplicationCapacity")
    def total_application_capacity(self) -> Optional[pulumi.Input[float]]:
        """
        The total metric capacity for Service Fabric application.
        This is the total metric capacity for this application in the cluster. Service Fabric will try to limit the sum of loads of services within the application to this value.
        When creating a new application with application capacity defined, the product of MaximumNodes and MaximumCapacity must always be smaller than or equal to this value.
        """
        return pulumi.get(self, "total_application_capacity")

    @total_application_capacity.setter
    def total_application_capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_application_capacity", value)


@pulumi.input_type
class ApplicationTypeVersionsCleanupPolicyArgs:
    def __init__(__self__, *,
                 max_unused_versions_to_keep: pulumi.Input[float]):
        """
        :param pulumi.Input[float] max_unused_versions_to_keep: Number of unused versions per application type to keep.
        """
        pulumi.set(__self__, "max_unused_versions_to_keep", max_unused_versions_to_keep)

    @property
    @pulumi.getter(name="maxUnusedVersionsToKeep")
    def max_unused_versions_to_keep(self) -> pulumi.Input[float]:
        """
        Number of unused versions per application type to keep.
        """
        return pulumi.get(self, "max_unused_versions_to_keep")

    @max_unused_versions_to_keep.setter
    def max_unused_versions_to_keep(self, value: pulumi.Input[float]):
        pulumi.set(self, "max_unused_versions_to_keep", value)


@pulumi.input_type
class ApplicationUpgradePolicyArgs:
    def __init__(__self__, *,
                 application_health_policy: Optional[pulumi.Input['ArmApplicationHealthPolicyArgs']] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 recreate_application: Optional[pulumi.Input[bool]] = None,
                 rolling_upgrade_monitoring_policy: Optional[pulumi.Input['ArmRollingUpgradeMonitoringPolicyArgs']] = None,
                 upgrade_mode: Optional[pulumi.Input[Union[str, 'RollingUpgradeMode']]] = None,
                 upgrade_replica_set_check_timeout: Optional[pulumi.Input[str]] = None):
        """
        Describes the policy for a monitored application upgrade.
        :param pulumi.Input['ArmApplicationHealthPolicyArgs'] application_health_policy: Defines a health policy used to evaluate the health of an application or one of its children entities.
        :param pulumi.Input[bool] force_restart: If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        :param pulumi.Input[bool] recreate_application: Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed and it will result in availability loss.
        :param pulumi.Input['ArmRollingUpgradeMonitoringPolicyArgs'] rolling_upgrade_monitoring_policy: The policy used for monitoring the application upgrade
        :param pulumi.Input[Union[str, 'RollingUpgradeMode']] upgrade_mode: The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored.
        :param pulumi.Input[str] upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
        """
        if application_health_policy is not None:
            pulumi.set(__self__, "application_health_policy", application_health_policy)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if recreate_application is not None:
            pulumi.set(__self__, "recreate_application", recreate_application)
        if rolling_upgrade_monitoring_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_monitoring_policy", rolling_upgrade_monitoring_policy)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)
        if upgrade_replica_set_check_timeout is not None:
            pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)

    @property
    @pulumi.getter(name="applicationHealthPolicy")
    def application_health_policy(self) -> Optional[pulumi.Input['ArmApplicationHealthPolicyArgs']]:
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.
        """
        return pulumi.get(self, "application_health_policy")

    @application_health_policy.setter
    def application_health_policy(self, value: Optional[pulumi.Input['ArmApplicationHealthPolicyArgs']]):
        pulumi.set(self, "application_health_policy", value)

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_restart", value)

    @property
    @pulumi.getter(name="recreateApplication")
    def recreate_application(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed and it will result in availability loss.
        """
        return pulumi.get(self, "recreate_application")

    @recreate_application.setter
    def recreate_application(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "recreate_application", value)

    @property
    @pulumi.getter(name="rollingUpgradeMonitoringPolicy")
    def rolling_upgrade_monitoring_policy(self) -> Optional[pulumi.Input['ArmRollingUpgradeMonitoringPolicyArgs']]:
        """
        The policy used for monitoring the application upgrade
        """
        return pulumi.get(self, "rolling_upgrade_monitoring_policy")

    @rolling_upgrade_monitoring_policy.setter
    def rolling_upgrade_monitoring_policy(self, value: Optional[pulumi.Input['ArmRollingUpgradeMonitoringPolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_monitoring_policy", value)

    @property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[pulumi.Input[Union[str, 'RollingUpgradeMode']]]:
        """
        The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored.
        """
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: Optional[pulumi.Input[Union[str, 'RollingUpgradeMode']]]):
        pulumi.set(self, "upgrade_mode", value)

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @upgrade_replica_set_check_timeout.setter
    def upgrade_replica_set_check_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_replica_set_check_timeout", value)


@pulumi.input_type
class ApplicationUserAssignedIdentityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 principal_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The friendly name of user assigned identity.
        :param pulumi.Input[str] principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The friendly name of user assigned identity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class ArmApplicationHealthPolicyArgs:
    def __init__(__self__, *,
                 consider_warning_as_error: Optional[pulumi.Input[bool]] = None,
                 default_service_type_health_policy: Optional[pulumi.Input['ArmServiceTypeHealthPolicyArgs']] = None,
                 max_percent_unhealthy_deployed_applications: Optional[pulumi.Input[int]] = None,
                 service_type_health_policy_map: Optional[pulumi.Input[Mapping[str, pulumi.Input['ArmServiceTypeHealthPolicyArgs']]]] = None):
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.

        :param pulumi.Input[bool] consider_warning_as_error: Indicates whether warnings are treated with the same severity as errors.
        :param pulumi.Input['ArmServiceTypeHealthPolicyArgs'] default_service_type_health_policy: The health policy used by default to evaluate the health of a service type.
        :param pulumi.Input[int] max_percent_unhealthy_deployed_applications: The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
               The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
               This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
               The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
        :param pulumi.Input[Mapping[str, pulumi.Input['ArmServiceTypeHealthPolicyArgs']]] service_type_health_policy_map: The map with service type health policy per service type name. The map is empty by default.
        """
        if consider_warning_as_error is None:
            consider_warning_as_error = False
        if consider_warning_as_error is not None:
            pulumi.set(__self__, "consider_warning_as_error", consider_warning_as_error)
        if default_service_type_health_policy is not None:
            pulumi.set(__self__, "default_service_type_health_policy", default_service_type_health_policy)
        if max_percent_unhealthy_deployed_applications is None:
            max_percent_unhealthy_deployed_applications = 0
        if max_percent_unhealthy_deployed_applications is not None:
            pulumi.set(__self__, "max_percent_unhealthy_deployed_applications", max_percent_unhealthy_deployed_applications)
        if service_type_health_policy_map is not None:
            pulumi.set(__self__, "service_type_health_policy_map", service_type_health_policy_map)

    @property
    @pulumi.getter(name="considerWarningAsError")
    def consider_warning_as_error(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether warnings are treated with the same severity as errors.
        """
        return pulumi.get(self, "consider_warning_as_error")

    @consider_warning_as_error.setter
    def consider_warning_as_error(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "consider_warning_as_error", value)

    @property
    @pulumi.getter(name="defaultServiceTypeHealthPolicy")
    def default_service_type_health_policy(self) -> Optional[pulumi.Input['ArmServiceTypeHealthPolicyArgs']]:
        """
        The health policy used by default to evaluate the health of a service type.
        """
        return pulumi.get(self, "default_service_type_health_policy")

    @default_service_type_health_policy.setter
    def default_service_type_health_policy(self, value: Optional[pulumi.Input['ArmServiceTypeHealthPolicyArgs']]):
        pulumi.set(self, "default_service_type_health_policy", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyDeployedApplications")
    def max_percent_unhealthy_deployed_applications(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
        The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
        This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
        The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
        """
        return pulumi.get(self, "max_percent_unhealthy_deployed_applications")

    @max_percent_unhealthy_deployed_applications.setter
    def max_percent_unhealthy_deployed_applications(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_deployed_applications", value)

    @property
    @pulumi.getter(name="serviceTypeHealthPolicyMap")
    def service_type_health_policy_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ArmServiceTypeHealthPolicyArgs']]]]:
        """
        The map with service type health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_health_policy_map")

    @service_type_health_policy_map.setter
    def service_type_health_policy_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ArmServiceTypeHealthPolicyArgs']]]]):
        pulumi.set(self, "service_type_health_policy_map", value)


@pulumi.input_type
class ArmRollingUpgradeMonitoringPolicyArgs:
    def __init__(__self__, *,
                 failure_action: Optional[pulumi.Input[Union[str, 'ArmUpgradeFailureAction']]] = None,
                 health_check_retry_timeout: Optional[pulumi.Input[str]] = None,
                 health_check_stable_duration: Optional[pulumi.Input[str]] = None,
                 health_check_wait_duration: Optional[pulumi.Input[str]] = None,
                 upgrade_domain_timeout: Optional[pulumi.Input[str]] = None,
                 upgrade_timeout: Optional[pulumi.Input[str]] = None):
        """
        The policy used for monitoring the application upgrade
        :param pulumi.Input[Union[str, 'ArmUpgradeFailureAction']] failure_action: The activation Mode of the service package
        :param pulumi.Input[str] health_check_retry_timeout: The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        :param pulumi.Input[str] health_check_stable_duration: The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        :param pulumi.Input[str] health_check_wait_duration: The amount of time to wait after completing an upgrade domain before applying health policies. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        :param pulumi.Input[str] upgrade_domain_timeout: The amount of time each upgrade domain has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        :param pulumi.Input[str] upgrade_timeout: The amount of time the overall upgrade has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if health_check_retry_timeout is not None:
            pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        if health_check_stable_duration is not None:
            pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        if health_check_wait_duration is not None:
            pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        if upgrade_domain_timeout is not None:
            pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        if upgrade_timeout is not None:
            pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[pulumi.Input[Union[str, 'ArmUpgradeFailureAction']]]:
        """
        The activation Mode of the service package
        """
        return pulumi.get(self, "failure_action")

    @failure_action.setter
    def failure_action(self, value: Optional[pulumi.Input[Union[str, 'ArmUpgradeFailureAction']]]):
        pulumi.set(self, "failure_action", value)

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @health_check_retry_timeout.setter
    def health_check_retry_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_retry_timeout", value)

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "health_check_stable_duration")

    @health_check_stable_duration.setter
    def health_check_stable_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_stable_duration", value)

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time to wait after completing an upgrade domain before applying health policies. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "health_check_wait_duration")

    @health_check_wait_duration.setter
    def health_check_wait_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_wait_duration", value)

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time each upgrade domain has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @upgrade_domain_timeout.setter
    def upgrade_domain_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_domain_timeout", value)

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time the overall upgrade has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "upgrade_timeout")

    @upgrade_timeout.setter
    def upgrade_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_timeout", value)


@pulumi.input_type
class ArmServiceTypeHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_unhealthy_partitions_per_service: Optional[pulumi.Input[int]] = None,
                 max_percent_unhealthy_replicas_per_partition: Optional[pulumi.Input[int]] = None,
                 max_percent_unhealthy_services: Optional[pulumi.Input[int]] = None):
        """
        Represents the health policy used to evaluate the health of services belonging to a service type.

        :param pulumi.Input[int] max_percent_unhealthy_partitions_per_service: The maximum percentage of partitions per service allowed to be unhealthy before your application is considered in error.
        :param pulumi.Input[int] max_percent_unhealthy_replicas_per_partition: The maximum percentage of replicas per partition allowed to be unhealthy before your application is considered in error.
        :param pulumi.Input[int] max_percent_unhealthy_services: The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        if max_percent_unhealthy_partitions_per_service is None:
            max_percent_unhealthy_partitions_per_service = 0
        if max_percent_unhealthy_partitions_per_service is not None:
            pulumi.set(__self__, "max_percent_unhealthy_partitions_per_service", max_percent_unhealthy_partitions_per_service)
        if max_percent_unhealthy_replicas_per_partition is None:
            max_percent_unhealthy_replicas_per_partition = 0
        if max_percent_unhealthy_replicas_per_partition is not None:
            pulumi.set(__self__, "max_percent_unhealthy_replicas_per_partition", max_percent_unhealthy_replicas_per_partition)
        if max_percent_unhealthy_services is None:
            max_percent_unhealthy_services = 0
        if max_percent_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_unhealthy_services", max_percent_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentUnhealthyPartitionsPerService")
    def max_percent_unhealthy_partitions_per_service(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percentage of partitions per service allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_partitions_per_service")

    @max_percent_unhealthy_partitions_per_service.setter
    def max_percent_unhealthy_partitions_per_service(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_partitions_per_service", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyReplicasPerPartition")
    def max_percent_unhealthy_replicas_per_partition(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percentage of replicas per partition allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_replicas_per_partition")

    @max_percent_unhealthy_replicas_per_partition.setter
    def max_percent_unhealthy_replicas_per_partition(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_replicas_per_partition", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyServices")
    def max_percent_unhealthy_services(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_services")

    @max_percent_unhealthy_services.setter
    def max_percent_unhealthy_services(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_services", value)


@pulumi.input_type
class AzureActiveDirectoryArgs:
    def __init__(__self__, *,
                 client_application: Optional[pulumi.Input[str]] = None,
                 cluster_application: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        The settings to enable AAD authentication on the cluster.
        :param pulumi.Input[str] client_application: Azure active directory client application id.
        :param pulumi.Input[str] cluster_application: Azure active directory cluster application id.
        :param pulumi.Input[str] tenant_id: Azure active directory tenant id.
        """
        if client_application is not None:
            pulumi.set(__self__, "client_application", client_application)
        if cluster_application is not None:
            pulumi.set(__self__, "cluster_application", cluster_application)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplication")
    def client_application(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory client application id.
        """
        return pulumi.get(self, "client_application")

    @client_application.setter
    def client_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_application", value)

    @property
    @pulumi.getter(name="clusterApplication")
    def cluster_application(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory cluster application id.
        """
        return pulumi.get(self, "cluster_application")

    @cluster_application.setter
    def cluster_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_application", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class CertificateDescriptionArgs:
    def __init__(__self__, *,
                 thumbprint: pulumi.Input[str],
                 thumbprint_secondary: Optional[pulumi.Input[str]] = None,
                 x509_store_name: Optional[pulumi.Input[str]] = None):
        """
        Describes the certificate details.
        :param pulumi.Input[str] thumbprint: Thumbprint of the primary certificate.
        :param pulumi.Input[str] thumbprint_secondary: Thumbprint of the secondary certificate.
        :param pulumi.Input[str] x509_store_name: The local certificate store location.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[str]:
        """
        Thumbprint of the primary certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[pulumi.Input[str]]:
        """
        Thumbprint of the secondary certificate.
        """
        return pulumi.get(self, "thumbprint_secondary")

    @thumbprint_secondary.setter
    def thumbprint_secondary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint_secondary", value)

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[pulumi.Input[str]]:
        """
        The local certificate store location.
        """
        return pulumi.get(self, "x509_store_name")

    @x509_store_name.setter
    def x509_store_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_store_name", value)


@pulumi.input_type
class ClientCertificateArgs:
    def __init__(__self__, *,
                 is_admin: pulumi.Input[bool],
                 common_name: Optional[pulumi.Input[str]] = None,
                 issuer_thumbprint: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Client Certificate definition.
        :param pulumi.Input[bool] is_admin: Whether the certificate is admin or not.
        :param pulumi.Input[str] common_name: Certificate Common name.
        :param pulumi.Input[str] issuer_thumbprint: Issuer thumbprint for the certificate. Only used together with CommonName.
        :param pulumi.Input[str] thumbprint: Certificate Thumbprint.
        """
        pulumi.set(__self__, "is_admin", is_admin)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if issuer_thumbprint is not None:
            pulumi.set(__self__, "issuer_thumbprint", issuer_thumbprint)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[bool]:
        """
        Whether the certificate is admin or not.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate Common name.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="issuerThumbprint")
    def issuer_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Issuer thumbprint for the certificate. Only used together with CommonName.
        """
        return pulumi.get(self, "issuer_thumbprint")

    @issuer_thumbprint.setter
    def issuer_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_thumbprint", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate Thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class ClientCertificateCommonNameArgs:
    def __init__(__self__, *,
                 certificate_common_name: pulumi.Input[str],
                 certificate_issuer_thumbprint: pulumi.Input[str],
                 is_admin: pulumi.Input[bool]):
        """
        Describes the client certificate details using common name.
        :param pulumi.Input[str] certificate_common_name: The common name of the client certificate.
        :param pulumi.Input[str] certificate_issuer_thumbprint: The issuer thumbprint of the client certificate.
        :param pulumi.Input[bool] is_admin: Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> pulumi.Input[str]:
        """
        The common name of the client certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @certificate_common_name.setter
    def certificate_common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_common_name", value)

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> pulumi.Input[str]:
        """
        The issuer thumbprint of the client certificate.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @certificate_issuer_thumbprint.setter
    def certificate_issuer_thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_issuer_thumbprint", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[bool]:
        """
        Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_admin", value)


@pulumi.input_type
class ClientCertificateThumbprintArgs:
    def __init__(__self__, *,
                 certificate_thumbprint: pulumi.Input[str],
                 is_admin: pulumi.Input[bool]):
        """
        Describes the client certificate details using thumbprint.
        :param pulumi.Input[str] certificate_thumbprint: The thumbprint of the client certificate.
        :param pulumi.Input[bool] is_admin: Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> pulumi.Input[str]:
        """
        The thumbprint of the client certificate.
        """
        return pulumi.get(self, "certificate_thumbprint")

    @certificate_thumbprint.setter
    def certificate_thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_thumbprint", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[bool]:
        """
        Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_admin", value)


@pulumi.input_type
class ClusterHealthPolicyArgs:
    def __init__(__self__, *,
                 application_health_policies: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationHealthPolicyArgs']]]] = None,
                 max_percent_unhealthy_applications: Optional[pulumi.Input[int]] = None,
                 max_percent_unhealthy_nodes: Optional[pulumi.Input[int]] = None):
        """
        Defines a health policy used to evaluate the health of the cluster or of a cluster node.

        :param pulumi.Input[Mapping[str, pulumi.Input['ApplicationHealthPolicyArgs']]] application_health_policies: Defines the application health policy map used to evaluate the health of an application or one of its children entities.
        :param pulumi.Input[int] max_percent_unhealthy_applications: The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
               
               The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
               If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
               This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
               The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
        :param pulumi.Input[int] max_percent_unhealthy_nodes: The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
               
               The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
               If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
               The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
               The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
               
               In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
        """
        if application_health_policies is not None:
            pulumi.set(__self__, "application_health_policies", application_health_policies)
        if max_percent_unhealthy_applications is None:
            max_percent_unhealthy_applications = 0
        if max_percent_unhealthy_applications is not None:
            pulumi.set(__self__, "max_percent_unhealthy_applications", max_percent_unhealthy_applications)
        if max_percent_unhealthy_nodes is None:
            max_percent_unhealthy_nodes = 0
        if max_percent_unhealthy_nodes is not None:
            pulumi.set(__self__, "max_percent_unhealthy_nodes", max_percent_unhealthy_nodes)

    @property
    @pulumi.getter(name="applicationHealthPolicies")
    def application_health_policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationHealthPolicyArgs']]]]:
        """
        Defines the application health policy map used to evaluate the health of an application or one of its children entities.
        """
        return pulumi.get(self, "application_health_policies")

    @application_health_policies.setter
    def application_health_policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationHealthPolicyArgs']]]]):
        pulumi.set(self, "application_health_policies", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyApplications")
    def max_percent_unhealthy_applications(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.

        The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
        If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
        This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
        The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
        """
        return pulumi.get(self, "max_percent_unhealthy_applications")

    @max_percent_unhealthy_applications.setter
    def max_percent_unhealthy_applications(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_applications", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyNodes")
    def max_percent_unhealthy_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.

        The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
        If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
        The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
        The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.

        In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
        """
        return pulumi.get(self, "max_percent_unhealthy_nodes")

    @max_percent_unhealthy_nodes.setter
    def max_percent_unhealthy_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_nodes", value)


@pulumi.input_type
class ClusterUpgradeDeltaHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_delta_unhealthy_applications: pulumi.Input[int],
                 max_percent_delta_unhealthy_nodes: pulumi.Input[int],
                 max_percent_upgrade_domain_delta_unhealthy_nodes: pulumi.Input[int],
                 application_delta_health_policies: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationDeltaHealthPolicyArgs']]]] = None):
        """
        Describes the delta health policies for the cluster upgrade.
        :param pulumi.Input[int] max_percent_delta_unhealthy_applications: The maximum allowed percentage of applications health degradation allowed during cluster upgrades.
               The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
        :param pulumi.Input[int] max_percent_delta_unhealthy_nodes: The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
               The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        :param pulumi.Input[int] max_percent_upgrade_domain_delta_unhealthy_nodes: The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
               The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
        :param pulumi.Input[Mapping[str, pulumi.Input['ApplicationDeltaHealthPolicyArgs']]] application_delta_health_policies: Defines the application delta health policy map used to evaluate the health of an application or one of its child entities when upgrading the cluster.
        """
        pulumi.set(__self__, "max_percent_delta_unhealthy_applications", max_percent_delta_unhealthy_applications)
        pulumi.set(__self__, "max_percent_delta_unhealthy_nodes", max_percent_delta_unhealthy_nodes)
        pulumi.set(__self__, "max_percent_upgrade_domain_delta_unhealthy_nodes", max_percent_upgrade_domain_delta_unhealthy_nodes)
        if application_delta_health_policies is not None:
            pulumi.set(__self__, "application_delta_health_policies", application_delta_health_policies)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyApplications")
    def max_percent_delta_unhealthy_applications(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of applications health degradation allowed during cluster upgrades.
        The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_applications")

    @max_percent_delta_unhealthy_applications.setter
    def max_percent_delta_unhealthy_applications(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_delta_unhealthy_applications", value)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyNodes")
    def max_percent_delta_unhealthy_nodes(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
        The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_nodes")

    @max_percent_delta_unhealthy_nodes.setter
    def max_percent_delta_unhealthy_nodes(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_delta_unhealthy_nodes", value)

    @property
    @pulumi.getter(name="maxPercentUpgradeDomainDeltaUnhealthyNodes")
    def max_percent_upgrade_domain_delta_unhealthy_nodes(self) -> pulumi.Input[int]:
        """
        The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
        The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_upgrade_domain_delta_unhealthy_nodes")

    @max_percent_upgrade_domain_delta_unhealthy_nodes.setter
    def max_percent_upgrade_domain_delta_unhealthy_nodes(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_upgrade_domain_delta_unhealthy_nodes", value)

    @property
    @pulumi.getter(name="applicationDeltaHealthPolicies")
    def application_delta_health_policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationDeltaHealthPolicyArgs']]]]:
        """
        Defines the application delta health policy map used to evaluate the health of an application or one of its child entities when upgrading the cluster.
        """
        return pulumi.get(self, "application_delta_health_policies")

    @application_delta_health_policies.setter
    def application_delta_health_policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApplicationDeltaHealthPolicyArgs']]]]):
        pulumi.set(self, "application_delta_health_policies", value)


@pulumi.input_type
class ClusterUpgradePolicyArgs:
    def __init__(__self__, *,
                 health_check_retry_timeout: pulumi.Input[str],
                 health_check_stable_duration: pulumi.Input[str],
                 health_check_wait_duration: pulumi.Input[str],
                 health_policy: pulumi.Input['ClusterHealthPolicyArgs'],
                 upgrade_domain_timeout: pulumi.Input[str],
                 upgrade_replica_set_check_timeout: pulumi.Input[str],
                 upgrade_timeout: pulumi.Input[str],
                 delta_health_policy: Optional[pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs']] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None):
        """
        Describes the policy used when upgrading the cluster.
        :param pulumi.Input[str] health_check_retry_timeout: The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input[str] health_check_stable_duration: The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input[str] health_check_wait_duration: The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input['ClusterHealthPolicyArgs'] health_policy: The cluster health policy used when upgrading the cluster.
        :param pulumi.Input[str] upgrade_domain_timeout: The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input[str] upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input[str] upgrade_timeout: The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs'] delta_health_policy: The cluster delta health policy used when upgrading the cluster.
        :param pulumi.Input[bool] force_restart: If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        pulumi.set(__self__, "health_policy", health_policy)
        pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)
        pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)
        if delta_health_policy is not None:
            pulumi.set(__self__, "delta_health_policy", delta_health_policy)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> pulumi.Input[str]:
        """
        The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @health_check_retry_timeout.setter
    def health_check_retry_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_retry_timeout", value)

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> pulumi.Input[str]:
        """
        The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_stable_duration")

    @health_check_stable_duration.setter
    def health_check_stable_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_stable_duration", value)

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> pulumi.Input[str]:
        """
        The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_wait_duration")

    @health_check_wait_duration.setter
    def health_check_wait_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_wait_duration", value)

    @property
    @pulumi.getter(name="healthPolicy")
    def health_policy(self) -> pulumi.Input['ClusterHealthPolicyArgs']:
        """
        The cluster health policy used when upgrading the cluster.
        """
        return pulumi.get(self, "health_policy")

    @health_policy.setter
    def health_policy(self, value: pulumi.Input['ClusterHealthPolicyArgs']):
        pulumi.set(self, "health_policy", value)

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> pulumi.Input[str]:
        """
        The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @upgrade_domain_timeout.setter
    def upgrade_domain_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_domain_timeout", value)

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> pulumi.Input[str]:
        """
        The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @upgrade_replica_set_check_timeout.setter
    def upgrade_replica_set_check_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_replica_set_check_timeout", value)

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> pulumi.Input[str]:
        """
        The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_timeout")

    @upgrade_timeout.setter
    def upgrade_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_timeout", value)

    @property
    @pulumi.getter(name="deltaHealthPolicy")
    def delta_health_policy(self) -> Optional[pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs']]:
        """
        The cluster delta health policy used when upgrading the cluster.
        """
        return pulumi.get(self, "delta_health_policy")

    @delta_health_policy.setter
    def delta_health_policy(self, value: Optional[pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs']]):
        pulumi.set(self, "delta_health_policy", value)

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_restart", value)


@pulumi.input_type
class DiagnosticsStorageAccountConfigArgs:
    def __init__(__self__, *,
                 blob_endpoint: pulumi.Input[str],
                 protected_account_key_name: pulumi.Input[str],
                 queue_endpoint: pulumi.Input[str],
                 storage_account_name: pulumi.Input[str],
                 table_endpoint: pulumi.Input[str],
                 protected_account_key_name2: Optional[pulumi.Input[str]] = None):
        """
        The storage account information for storing Service Fabric diagnostic logs.
        :param pulumi.Input[str] blob_endpoint: The blob endpoint of the azure storage account.
        :param pulumi.Input[str] protected_account_key_name: The protected diagnostics storage key name.
        :param pulumi.Input[str] queue_endpoint: The queue endpoint of the azure storage account.
        :param pulumi.Input[str] storage_account_name: The Azure storage account name.
        :param pulumi.Input[str] table_endpoint: The table endpoint of the azure storage account.
        :param pulumi.Input[str] protected_account_key_name2: The secondary protected diagnostics storage key name. If one of the storage account keys is rotated the cluster will fallback to using the other.
        """
        pulumi.set(__self__, "blob_endpoint", blob_endpoint)
        pulumi.set(__self__, "protected_account_key_name", protected_account_key_name)
        pulumi.set(__self__, "queue_endpoint", queue_endpoint)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "table_endpoint", table_endpoint)
        if protected_account_key_name2 is not None:
            pulumi.set(__self__, "protected_account_key_name2", protected_account_key_name2)

    @property
    @pulumi.getter(name="blobEndpoint")
    def blob_endpoint(self) -> pulumi.Input[str]:
        """
        The blob endpoint of the azure storage account.
        """
        return pulumi.get(self, "blob_endpoint")

    @blob_endpoint.setter
    def blob_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "blob_endpoint", value)

    @property
    @pulumi.getter(name="protectedAccountKeyName")
    def protected_account_key_name(self) -> pulumi.Input[str]:
        """
        The protected diagnostics storage key name.
        """
        return pulumi.get(self, "protected_account_key_name")

    @protected_account_key_name.setter
    def protected_account_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_account_key_name", value)

    @property
    @pulumi.getter(name="queueEndpoint")
    def queue_endpoint(self) -> pulumi.Input[str]:
        """
        The queue endpoint of the azure storage account.
        """
        return pulumi.get(self, "queue_endpoint")

    @queue_endpoint.setter
    def queue_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_endpoint", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[str]:
        """
        The Azure storage account name.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter(name="tableEndpoint")
    def table_endpoint(self) -> pulumi.Input[str]:
        """
        The table endpoint of the azure storage account.
        """
        return pulumi.get(self, "table_endpoint")

    @table_endpoint.setter
    def table_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_endpoint", value)

    @property
    @pulumi.getter(name="protectedAccountKeyName2")
    def protected_account_key_name2(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary protected diagnostics storage key name. If one of the storage account keys is rotated the cluster will fallback to using the other.
        """
        return pulumi.get(self, "protected_account_key_name2")

    @protected_account_key_name2.setter
    def protected_account_key_name2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_account_key_name2", value)


@pulumi.input_type
class EndpointRangeDescriptionArgs:
    def __init__(__self__, *,
                 end_port: pulumi.Input[int],
                 start_port: pulumi.Input[int]):
        """
        Port range details
        :param pulumi.Input[int] end_port: End port of a range of ports
        :param pulumi.Input[int] start_port: Starting port of a range of ports
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> pulumi.Input[int]:
        """
        End port of a range of ports
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> pulumi.Input[int]:
        """
        Starting port of a range of ports
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "start_port", value)


@pulumi.input_type
class LoadBalancingRuleArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[int],
                 frontend_port: pulumi.Input[int],
                 probe_protocol: pulumi.Input[Union[str, 'ProbeProtocol']],
                 protocol: pulumi.Input[Union[str, 'Protocol']],
                 probe_request_path: Optional[pulumi.Input[str]] = None):
        """
        Describes a load balancing rule.
        :param pulumi.Input[int] backend_port: The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        :param pulumi.Input[int] frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
        :param pulumi.Input[Union[str, 'ProbeProtocol']] probe_protocol: the reference to the load balancer probe used by the load balancing rule.
        :param pulumi.Input[Union[str, 'Protocol']] protocol: The reference to the transport protocol used by the load balancing rule.
        :param pulumi.Input[str] probe_request_path: The probe request path. Only supported for HTTP/HTTPS probes.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "probe_protocol", probe_protocol)
        pulumi.set(__self__, "protocol", protocol)
        if probe_request_path is not None:
            pulumi.set(__self__, "probe_request_path", probe_request_path)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[int]:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Input[int]:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="probeProtocol")
    def probe_protocol(self) -> pulumi.Input[Union[str, 'ProbeProtocol']]:
        """
        the reference to the load balancer probe used by the load balancing rule.
        """
        return pulumi.get(self, "probe_protocol")

    @probe_protocol.setter
    def probe_protocol(self, value: pulumi.Input[Union[str, 'ProbeProtocol']]):
        pulumi.set(self, "probe_protocol", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'Protocol']]:
        """
        The reference to the transport protocol used by the load balancing rule.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'Protocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="probeRequestPath")
    def probe_request_path(self) -> Optional[pulumi.Input[str]]:
        """
        The probe request path. Only supported for HTTP/HTTPS probes.
        """
        return pulumi.get(self, "probe_request_path")

    @probe_request_path.setter
    def probe_request_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "probe_request_path", value)


@pulumi.input_type
class ManagedIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ManagedIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Describes the managed identities for an Azure resource.
        :param pulumi.Input['ManagedIdentityType'] type: The type of managed identity for the resource.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ManagedIdentityType']]:
        """
        The type of managed identity for the resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ManagedIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class NamedPartitionSchemeDescriptionArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[int],
                 names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 partition_scheme: pulumi.Input[str]):
        """
        Describes the named partition scheme of the service.
        :param pulumi.Input[int] count: The number of partitions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: Array of size specified by the ‘count’ parameter, for the names of the partitions.
        :param pulumi.Input[str] partition_scheme: Enumerates the ways that a service can be partitioned.
               Expected value is 'Named'.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "partition_scheme", 'Named')

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[int]:
        """
        The number of partitions.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array of size specified by the ‘count’ parameter, for the names of the partitions.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter(name="partitionScheme")
    def partition_scheme(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'Named'.
        """
        return pulumi.get(self, "partition_scheme")

    @partition_scheme.setter
    def partition_scheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "partition_scheme", value)


@pulumi.input_type
class NodeTypeDescriptionArgs:
    def __init__(__self__, *,
                 client_connection_endpoint_port: pulumi.Input[int],
                 http_gateway_endpoint_port: pulumi.Input[int],
                 is_primary: pulumi.Input[bool],
                 name: pulumi.Input[str],
                 vm_instance_count: pulumi.Input[int],
                 application_ports: Optional[pulumi.Input['EndpointRangeDescriptionArgs']] = None,
                 capacities: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 durability_level: Optional[pulumi.Input[str]] = None,
                 ephemeral_ports: Optional[pulumi.Input['EndpointRangeDescriptionArgs']] = None,
                 placement_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 reverse_proxy_endpoint_port: Optional[pulumi.Input[int]] = None):
        """
        Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
        :param pulumi.Input[int] client_connection_endpoint_port: The TCP cluster management endpoint port.
        :param pulumi.Input[int] http_gateway_endpoint_port: The HTTP cluster management endpoint port.
        :param pulumi.Input[bool] is_primary: The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
        :param pulumi.Input[str] name: The name of the node type.
        :param pulumi.Input[int] vm_instance_count: The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
        :param pulumi.Input['EndpointRangeDescriptionArgs'] application_ports: The range of ports from which cluster assigned port to Service Fabric applications.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] capacities: The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        :param pulumi.Input[str] durability_level: The durability level of the node type. Learn about [DurabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).
               
                 - Bronze - No privileges. This is the default.
                 - Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
                 - Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on full node VM skus like D15_V2, G5 etc.
        :param pulumi.Input['EndpointRangeDescriptionArgs'] ephemeral_ports: The range of ephemeral ports that nodes in this node type should be configured with.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] placement_properties: The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        :param pulumi.Input[int] reverse_proxy_endpoint_port: The endpoint used by reverse proxy.
        """
        pulumi.set(__self__, "client_connection_endpoint_port", client_connection_endpoint_port)
        pulumi.set(__self__, "http_gateway_endpoint_port", http_gateway_endpoint_port)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vm_instance_count", vm_instance_count)
        if application_ports is not None:
            pulumi.set(__self__, "application_ports", application_ports)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if durability_level is not None:
            pulumi.set(__self__, "durability_level", durability_level)
        if ephemeral_ports is not None:
            pulumi.set(__self__, "ephemeral_ports", ephemeral_ports)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if reverse_proxy_endpoint_port is not None:
            pulumi.set(__self__, "reverse_proxy_endpoint_port", reverse_proxy_endpoint_port)

    @property
    @pulumi.getter(name="clientConnectionEndpointPort")
    def client_connection_endpoint_port(self) -> pulumi.Input[int]:
        """
        The TCP cluster management endpoint port.
        """
        return pulumi.get(self, "client_connection_endpoint_port")

    @client_connection_endpoint_port.setter
    def client_connection_endpoint_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "client_connection_endpoint_port", value)

    @property
    @pulumi.getter(name="httpGatewayEndpointPort")
    def http_gateway_endpoint_port(self) -> pulumi.Input[int]:
        """
        The HTTP cluster management endpoint port.
        """
        return pulumi.get(self, "http_gateway_endpoint_port")

    @http_gateway_endpoint_port.setter
    def http_gateway_endpoint_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "http_gateway_endpoint_port", value)

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> pulumi.Input[bool]:
        """
        The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
        """
        return pulumi.get(self, "is_primary")

    @is_primary.setter
    def is_primary(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_primary", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the node type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="vmInstanceCount")
    def vm_instance_count(self) -> pulumi.Input[int]:
        """
        The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
        """
        return pulumi.get(self, "vm_instance_count")

    @vm_instance_count.setter
    def vm_instance_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "vm_instance_count", value)

    @property
    @pulumi.getter(name="applicationPorts")
    def application_ports(self) -> Optional[pulumi.Input['EndpointRangeDescriptionArgs']]:
        """
        The range of ports from which cluster assigned port to Service Fabric applications.
        """
        return pulumi.get(self, "application_ports")

    @application_ports.setter
    def application_ports(self, value: Optional[pulumi.Input['EndpointRangeDescriptionArgs']]):
        pulumi.set(self, "application_ports", value)

    @property
    @pulumi.getter
    def capacities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        """
        return pulumi.get(self, "capacities")

    @capacities.setter
    def capacities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "capacities", value)

    @property
    @pulumi.getter(name="durabilityLevel")
    def durability_level(self) -> Optional[pulumi.Input[str]]:
        """
        The durability level of the node type. Learn about [DurabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).

          - Bronze - No privileges. This is the default.
          - Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
          - Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on full node VM skus like D15_V2, G5 etc.
        """
        return pulumi.get(self, "durability_level")

    @durability_level.setter
    def durability_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "durability_level", value)

    @property
    @pulumi.getter(name="ephemeralPorts")
    def ephemeral_ports(self) -> Optional[pulumi.Input['EndpointRangeDescriptionArgs']]:
        """
        The range of ephemeral ports that nodes in this node type should be configured with.
        """
        return pulumi.get(self, "ephemeral_ports")

    @ephemeral_ports.setter
    def ephemeral_ports(self, value: Optional[pulumi.Input['EndpointRangeDescriptionArgs']]):
        pulumi.set(self, "ephemeral_ports", value)

    @property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        """
        return pulumi.get(self, "placement_properties")

    @placement_properties.setter
    def placement_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "placement_properties", value)

    @property
    @pulumi.getter(name="reverseProxyEndpointPort")
    def reverse_proxy_endpoint_port(self) -> Optional[pulumi.Input[int]]:
        """
        The endpoint used by reverse proxy.
        """
        return pulumi.get(self, "reverse_proxy_endpoint_port")

    @reverse_proxy_endpoint_port.setter
    def reverse_proxy_endpoint_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reverse_proxy_endpoint_port", value)


@pulumi.input_type
class ServerCertificateCommonNameArgs:
    def __init__(__self__, *,
                 certificate_common_name: pulumi.Input[str],
                 certificate_issuer_thumbprint: pulumi.Input[str]):
        """
        Describes the server certificate details using common name.
        :param pulumi.Input[str] certificate_common_name: The common name of the server certificate.
        :param pulumi.Input[str] certificate_issuer_thumbprint: The issuer thumbprint of the server certificate.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> pulumi.Input[str]:
        """
        The common name of the server certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @certificate_common_name.setter
    def certificate_common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_common_name", value)

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> pulumi.Input[str]:
        """
        The issuer thumbprint of the server certificate.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @certificate_issuer_thumbprint.setter
    def certificate_issuer_thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_issuer_thumbprint", value)


@pulumi.input_type
class ServerCertificateCommonNamesArgs:
    def __init__(__self__, *,
                 common_names: Optional[pulumi.Input[Sequence[pulumi.Input['ServerCertificateCommonNameArgs']]]] = None,
                 x509_store_name: Optional[pulumi.Input[str]] = None):
        """
        Describes a list of server certificates referenced by common name that are used to secure the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ServerCertificateCommonNameArgs']]] common_names: The list of server certificates referenced by common name that are used to secure the cluster.
        :param pulumi.Input[str] x509_store_name: The local certificate store location.
        """
        if common_names is not None:
            pulumi.set(__self__, "common_names", common_names)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter(name="commonNames")
    def common_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerCertificateCommonNameArgs']]]]:
        """
        The list of server certificates referenced by common name that are used to secure the cluster.
        """
        return pulumi.get(self, "common_names")

    @common_names.setter
    def common_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerCertificateCommonNameArgs']]]]):
        pulumi.set(self, "common_names", value)

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[pulumi.Input[str]]:
        """
        The local certificate store location.
        """
        return pulumi.get(self, "x509_store_name")

    @x509_store_name.setter
    def x509_store_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_store_name", value)


@pulumi.input_type
class ServiceCorrelationDescriptionArgs:
    def __init__(__self__, *,
                 scheme: pulumi.Input[Union[str, 'ServiceCorrelationScheme']],
                 service_name: pulumi.Input[str]):
        """
        Creates a particular correlation between services.
        :param pulumi.Input[Union[str, 'ServiceCorrelationScheme']] scheme: The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
        :param pulumi.Input[str] service_name: The name of the service that the correlation relationship is established with.
        """
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def scheme(self) -> pulumi.Input[Union[str, 'ServiceCorrelationScheme']]:
        """
        The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: pulumi.Input[Union[str, 'ServiceCorrelationScheme']]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The name of the service that the correlation relationship is established with.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class ServiceLoadMetricDescriptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 default_load: Optional[pulumi.Input[int]] = None,
                 primary_default_load: Optional[pulumi.Input[int]] = None,
                 secondary_default_load: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[Union[str, 'ServiceLoadMetricWeight']]] = None):
        """
        Specifies a metric to load balance a service during runtime.
        :param pulumi.Input[str] name: The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
        :param pulumi.Input[int] default_load: Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
        :param pulumi.Input[int] primary_default_load: Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
        :param pulumi.Input[int] secondary_default_load: Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
        :param pulumi.Input[Union[str, 'ServiceLoadMetricWeight']] weight: The service load metric relative weight, compared to other metrics configured for this service, as a number.
        """
        pulumi.set(__self__, "name", name)
        if default_load is not None:
            pulumi.set(__self__, "default_load", default_load)
        if primary_default_load is not None:
            pulumi.set(__self__, "primary_default_load", primary_default_load)
        if secondary_default_load is not None:
            pulumi.set(__self__, "secondary_default_load", secondary_default_load)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="defaultLoad")
    def default_load(self) -> Optional[pulumi.Input[int]]:
        """
        Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
        """
        return pulumi.get(self, "default_load")

    @default_load.setter
    def default_load(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_load", value)

    @property
    @pulumi.getter(name="primaryDefaultLoad")
    def primary_default_load(self) -> Optional[pulumi.Input[int]]:
        """
        Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
        """
        return pulumi.get(self, "primary_default_load")

    @primary_default_load.setter
    def primary_default_load(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "primary_default_load", value)

    @property
    @pulumi.getter(name="secondaryDefaultLoad")
    def secondary_default_load(self) -> Optional[pulumi.Input[int]]:
        """
        Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
        """
        return pulumi.get(self, "secondary_default_load")

    @secondary_default_load.setter
    def secondary_default_load(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "secondary_default_load", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[Union[str, 'ServiceLoadMetricWeight']]]:
        """
        The service load metric relative weight, compared to other metrics configured for this service, as a number.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[Union[str, 'ServiceLoadMetricWeight']]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ServicePlacementPolicyDescriptionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ServicePlacementPolicyType']]):
        """
        Describes the policy to be used for placement of a Service Fabric service.
        :param pulumi.Input[Union[str, 'ServicePlacementPolicyType']] type: The type of placement policy for a service fabric service. Following are the possible values.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ServicePlacementPolicyType']]:
        """
        The type of placement policy for a service fabric service. Following are the possible values.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ServicePlacementPolicyType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceTypeDeltaHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_delta_unhealthy_services: Optional[pulumi.Input[int]] = None):
        """
        Represents the delta health policy used to evaluate the health of services belonging to a service type when upgrading the cluster.

        :param pulumi.Input[int] max_percent_delta_unhealthy_services: The maximum allowed percentage of services health degradation allowed during cluster upgrades.
               The delta is measured between the state of the services at the beginning of upgrade and the state of the services at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        if max_percent_delta_unhealthy_services is None:
            max_percent_delta_unhealthy_services = 0
        if max_percent_delta_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_delta_unhealthy_services", max_percent_delta_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyServices")
    def max_percent_delta_unhealthy_services(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed percentage of services health degradation allowed during cluster upgrades.
        The delta is measured between the state of the services at the beginning of upgrade and the state of the services at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_services")

    @max_percent_delta_unhealthy_services.setter
    def max_percent_delta_unhealthy_services(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_delta_unhealthy_services", value)


@pulumi.input_type
class ServiceTypeHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_unhealthy_services: Optional[pulumi.Input[int]] = None):
        """
        Represents the health policy used to evaluate the health of services belonging to a service type.

        :param pulumi.Input[int] max_percent_unhealthy_services: The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        if max_percent_unhealthy_services is None:
            max_percent_unhealthy_services = 0
        if max_percent_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_unhealthy_services", max_percent_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentUnhealthyServices")
    def max_percent_unhealthy_services(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_services")

    @max_percent_unhealthy_services.setter
    def max_percent_unhealthy_services(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_services", value)


@pulumi.input_type
class SettingsParameterDescriptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Describes a parameter in fabric settings of the cluster.
        :param pulumi.Input[str] name: The parameter name of fabric setting.
        :param pulumi.Input[str] value: The parameter value of fabric setting.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name of fabric setting.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The parameter value of fabric setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SettingsSectionDescriptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]):
        """
        Describes a section in the fabric settings of the cluster.
        :param pulumi.Input[str] name: The section name of the fabric settings.
        :param pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]] parameters: The collection of parameters in the section.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The section name of the fabric settings.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]:
        """
        The collection of parameters in the section.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class SingletonPartitionSchemeDescriptionArgs:
    def __init__(__self__, *,
                 partition_scheme: pulumi.Input[str]):
        """
        Describes the partition scheme of a singleton-partitioned, or non-partitioned service.
        :param pulumi.Input[str] partition_scheme: Enumerates the ways that a service can be partitioned.
               Expected value is 'Singleton'.
        """
        pulumi.set(__self__, "partition_scheme", 'Singleton')

    @property
    @pulumi.getter(name="partitionScheme")
    def partition_scheme(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'Singleton'.
        """
        return pulumi.get(self, "partition_scheme")

    @partition_scheme.setter
    def partition_scheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "partition_scheme", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        Sku definition
        :param pulumi.Input[str] name: Sku Name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Sku Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SubResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Azure resource identifier.
        :param pulumi.Input[str] id: Azure resource identifier.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure resource identifier.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class UniformInt64RangePartitionSchemeDescriptionArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[int],
                 high_key: pulumi.Input[str],
                 low_key: pulumi.Input[str],
                 partition_scheme: pulumi.Input[str]):
        """
        Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions.
        :param pulumi.Input[int] count: The number of partitions.
        :param pulumi.Input[str] high_key: String indicating the upper bound of the partition key range that
               should be split between the partition ‘count’
        :param pulumi.Input[str] low_key: String indicating the lower bound of the partition key range that
               should be split between the partition ‘count’
        :param pulumi.Input[str] partition_scheme: Enumerates the ways that a service can be partitioned.
               Expected value is 'UniformInt64Range'.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "high_key", high_key)
        pulumi.set(__self__, "low_key", low_key)
        pulumi.set(__self__, "partition_scheme", 'UniformInt64Range')

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[int]:
        """
        The number of partitions.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="highKey")
    def high_key(self) -> pulumi.Input[str]:
        """
        String indicating the upper bound of the partition key range that
        should be split between the partition ‘count’
        """
        return pulumi.get(self, "high_key")

    @high_key.setter
    def high_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "high_key", value)

    @property
    @pulumi.getter(name="lowKey")
    def low_key(self) -> pulumi.Input[str]:
        """
        String indicating the lower bound of the partition key range that
        should be split between the partition ‘count’
        """
        return pulumi.get(self, "low_key")

    @low_key.setter
    def low_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "low_key", value)

    @property
    @pulumi.getter(name="partitionScheme")
    def partition_scheme(self) -> pulumi.Input[str]:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'UniformInt64Range'.
        """
        return pulumi.get(self, "partition_scheme")

    @partition_scheme.setter
    def partition_scheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "partition_scheme", value)


@pulumi.input_type
class VMSSExtensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 publisher: pulumi.Input[str],
                 type: pulumi.Input[str],
                 type_handler_version: pulumi.Input[str],
                 auto_upgrade_minor_version: Optional[pulumi.Input[bool]] = None,
                 force_update_tag: Optional[pulumi.Input[str]] = None,
                 protected_settings: Optional[Any] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 settings: Optional[Any] = None):
        """
        Specifies set of extensions that should be installed onto the virtual machines.
        :param pulumi.Input[str] name: The name of the extension.
        :param pulumi.Input[str] publisher: The name of the extension handler publisher.
        :param pulumi.Input[str] type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param pulumi.Input[str] type_handler_version: Specifies the version of the script handler.
        :param pulumi.Input[bool] auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param pulumi.Input[str] force_update_tag: If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] provision_after_extensions: Collection of extension names after which this extension needs to be provisioned.
        :param Any settings: Json formatted public settings for the extension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> pulumi.Input[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "type_handler_version", value)

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[pulumi.Input[str]]:
        """
        If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @force_update_tag.setter
    def force_update_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_update_tag", value)

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[Any]):
        pulumi.set(self, "protected_settings", value)

    @property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @provision_after_extensions.setter
    def provision_after_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "provision_after_extensions", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[Any]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class VaultCertificateArgs:
    def __init__(__self__, *,
                 certificate_store: pulumi.Input[str],
                 certificate_url: pulumi.Input[str]):
        """
        Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
        :param pulumi.Input[str] certificate_store: For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name <UppercaseThumbprint>.crt for the X509 certificate file and <UppercaseThumbprint>.prv for private key. Both of these files are .pem formatted.
        :param pulumi.Input[str] certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        pulumi.set(__self__, "certificate_store", certificate_store)
        pulumi.set(__self__, "certificate_url", certificate_url)

    @property
    @pulumi.getter(name="certificateStore")
    def certificate_store(self) -> pulumi.Input[str]:
        """
        For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name <UppercaseThumbprint>.crt for the X509 certificate file and <UppercaseThumbprint>.prv for private key. Both of these files are .pem formatted.
        """
        return pulumi.get(self, "certificate_store")

    @certificate_store.setter
    def certificate_store(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_store", value)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> pulumi.Input[str]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        return pulumi.get(self, "certificate_url")

    @certificate_url.setter
    def certificate_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_url", value)


@pulumi.input_type
class VaultSecretGroupArgs:
    def __init__(__self__, *,
                 source_vault: pulumi.Input['SubResourceArgs'],
                 vault_certificates: pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]]):
        """
        Specifies set of certificates that should be installed onto the virtual machines.
        :param pulumi.Input['SubResourceArgs'] source_vault: The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        :param pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]] vault_certificates: The list of key vault references in SourceVault which contain certificates.
        """
        pulumi.set(__self__, "source_vault", source_vault)
        pulumi.set(__self__, "vault_certificates", vault_certificates)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> pulumi.Input['SubResourceArgs']:
        """
        The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: pulumi.Input['SubResourceArgs']):
        pulumi.set(self, "source_vault", value)

    @property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]]:
        """
        The list of key vault references in SourceVault which contain certificates.
        """
        return pulumi.get(self, "vault_certificates")

    @vault_certificates.setter
    def vault_certificates(self, value: pulumi.Input[Sequence[pulumi.Input['VaultCertificateArgs']]]):
        pulumi.set(self, "vault_certificates", value)


