# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CloudToDevicePropertiesArgs',
    'EnrichmentPropertiesArgs',
    'EventHubPropertiesArgs',
    'FallbackRoutePropertiesArgs',
    'FeedbackPropertiesArgs',
    'IotHubPropertiesArgs',
    'IotHubPropertiesDeviceStreamsArgs',
    'IotHubSkuInfoArgs',
    'IpFilterRuleArgs',
    'MessagingEndpointPropertiesArgs',
    'RoutePropertiesArgs',
    'RoutingEndpointsArgs',
    'RoutingEventHubPropertiesArgs',
    'RoutingPropertiesArgs',
    'RoutingServiceBusQueueEndpointPropertiesArgs',
    'RoutingServiceBusTopicEndpointPropertiesArgs',
    'RoutingStorageContainerPropertiesArgs',
    'SharedAccessSignatureAuthorizationRuleArgs',
    'StorageEndpointPropertiesArgs',
]

@pulumi.input_type
class CloudToDevicePropertiesArgs:
    def __init__(__self__, *,
                 default_ttl_as_iso8601: Optional[pulumi.Input[str]] = None,
                 feedback: Optional[pulumi.Input['FeedbackPropertiesArgs']] = None,
                 max_delivery_count: Optional[pulumi.Input[int]] = None):
        """
        The IoT hub cloud-to-device messaging properties.
        :param pulumi.Input[str] default_ttl_as_iso8601: The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :param pulumi.Input['FeedbackPropertiesArgs'] feedback: The properties of the feedback queue for cloud-to-device messages.
        :param pulumi.Input[int] max_delivery_count: The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        if default_ttl_as_iso8601 is not None:
            pulumi.set(__self__, "default_ttl_as_iso8601", default_ttl_as_iso8601)
        if feedback is not None:
            pulumi.set(__self__, "feedback", feedback)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)

    @property
    @pulumi.getter(name="defaultTtlAsIso8601")
    def default_ttl_as_iso8601(self) -> Optional[pulumi.Input[str]]:
        """
        The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "default_ttl_as_iso8601")

    @default_ttl_as_iso8601.setter
    def default_ttl_as_iso8601(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_ttl_as_iso8601", value)

    @property
    @pulumi.getter
    def feedback(self) -> Optional[pulumi.Input['FeedbackPropertiesArgs']]:
        """
        The properties of the feedback queue for cloud-to-device messages.
        """
        return pulumi.get(self, "feedback")

    @feedback.setter
    def feedback(self, value: Optional[pulumi.Input['FeedbackPropertiesArgs']]):
        pulumi.set(self, "feedback", value)

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[pulumi.Input[int]]:
        """
        The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_delivery_count", value)


@pulumi.input_type
class EnrichmentPropertiesArgs:
    def __init__(__self__, *,
                 endpoint_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The properties of an enrichment that your IoT hub applies to messages delivered to endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoint_names: The list of endpoints for which the enrichment is applied to the message.
        :param pulumi.Input[str] key: The key or name for the enrichment property.
        :param pulumi.Input[str] value: The value for the enrichment property.
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of endpoints for which the enrichment is applied to the message.
        """
        return pulumi.get(self, "endpoint_names")

    @endpoint_names.setter
    def endpoint_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "endpoint_names", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key or name for the enrichment property.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the enrichment property.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventHubPropertiesArgs:
    def __init__(__self__, *,
                 partition_count: Optional[pulumi.Input[int]] = None,
                 retention_time_in_days: Optional[pulumi.Input[float]] = None):
        """
        The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
        :param pulumi.Input[int] partition_count: The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        :param pulumi.Input[float] retention_time_in_days: The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
        """
        if partition_count is not None:
            pulumi.set(__self__, "partition_count", partition_count)
        if retention_time_in_days is not None:
            pulumi.set(__self__, "retention_time_in_days", retention_time_in_days)

    @property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        """
        return pulumi.get(self, "partition_count")

    @partition_count.setter
    def partition_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partition_count", value)

    @property
    @pulumi.getter(name="retentionTimeInDays")
    def retention_time_in_days(self) -> Optional[pulumi.Input[float]]:
        """
        The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
        """
        return pulumi.get(self, "retention_time_in_days")

    @retention_time_in_days.setter
    def retention_time_in_days(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "retention_time_in_days", value)


@pulumi.input_type
class FallbackRoutePropertiesArgs:
    def __init__(__self__, *,
                 endpoint_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 is_enabled: pulumi.Input[bool],
                 source: pulumi.Input[Union[str, 'RoutingSource']],
                 condition: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoint_names: The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed.
        :param pulumi.Input[bool] is_enabled: Used to specify whether the fallback route is enabled.
        :param pulumi.Input[Union[str, 'RoutingSource']] source: The source to which the routing rule is to be applied to. For example, DeviceMessages
        :param pulumi.Input[str] condition: The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        :param pulumi.Input[str] name: The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "source", source)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed.
        """
        return pulumi.get(self, "endpoint_names")

    @endpoint_names.setter
    def endpoint_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "endpoint_names", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Used to specify whether the fallback route is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[Union[str, 'RoutingSource']]:
        """
        The source to which the routing rule is to be applied to. For example, DeviceMessages
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[Union[str, 'RoutingSource']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class FeedbackPropertiesArgs:
    def __init__(__self__, *,
                 lock_duration_as_iso8601: Optional[pulumi.Input[str]] = None,
                 max_delivery_count: Optional[pulumi.Input[int]] = None,
                 ttl_as_iso8601: Optional[pulumi.Input[str]] = None):
        """
        The properties of the feedback queue for cloud-to-device messages.
        :param pulumi.Input[str] lock_duration_as_iso8601: The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :param pulumi.Input[int] max_delivery_count: The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :param pulumi.Input[str] ttl_as_iso8601: The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        if lock_duration_as_iso8601 is not None:
            pulumi.set(__self__, "lock_duration_as_iso8601", lock_duration_as_iso8601)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if ttl_as_iso8601 is not None:
            pulumi.set(__self__, "ttl_as_iso8601", ttl_as_iso8601)

    @property
    @pulumi.getter(name="lockDurationAsIso8601")
    def lock_duration_as_iso8601(self) -> Optional[pulumi.Input[str]]:
        """
        The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "lock_duration_as_iso8601")

    @lock_duration_as_iso8601.setter
    def lock_duration_as_iso8601(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_duration_as_iso8601", value)

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_delivery_count", value)

    @property
    @pulumi.getter(name="ttlAsIso8601")
    def ttl_as_iso8601(self) -> Optional[pulumi.Input[str]]:
        """
        The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "ttl_as_iso8601")

    @ttl_as_iso8601.setter
    def ttl_as_iso8601(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl_as_iso8601", value)


@pulumi.input_type
class IotHubPropertiesArgs:
    def __init__(__self__, *,
                 authorization_policies: Optional[pulumi.Input[Sequence[pulumi.Input['SharedAccessSignatureAuthorizationRuleArgs']]]] = None,
                 cloud_to_device: Optional[pulumi.Input['CloudToDevicePropertiesArgs']] = None,
                 comments: Optional[pulumi.Input[str]] = None,
                 device_streams: Optional[pulumi.Input['IotHubPropertiesDeviceStreamsArgs']] = None,
                 enable_file_upload_notifications: Optional[pulumi.Input[bool]] = None,
                 event_hub_endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input['EventHubPropertiesArgs']]]] = None,
                 features: Optional[pulumi.Input[Union[str, 'Capabilities']]] = None,
                 ip_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IpFilterRuleArgs']]]] = None,
                 messaging_endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input['MessagingEndpointPropertiesArgs']]]] = None,
                 routing: Optional[pulumi.Input['RoutingPropertiesArgs']] = None,
                 storage_endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input['StorageEndpointPropertiesArgs']]]] = None):
        """
        The properties of an IoT hub.
        :param pulumi.Input[Sequence[pulumi.Input['SharedAccessSignatureAuthorizationRuleArgs']]] authorization_policies: The shared access policies you can use to secure a connection to the IoT hub.
        :param pulumi.Input['CloudToDevicePropertiesArgs'] cloud_to_device: The IoT hub cloud-to-device messaging properties.
        :param pulumi.Input[str] comments: IoT hub comments.
        :param pulumi.Input['IotHubPropertiesDeviceStreamsArgs'] device_streams: The device streams properties of iothub.
        :param pulumi.Input[bool] enable_file_upload_notifications: If True, file upload notifications are enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input['EventHubPropertiesArgs']]] event_hub_endpoints: The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
        :param pulumi.Input[Union[str, 'Capabilities']] features: The capabilities and features enabled for the IoT hub.
        :param pulumi.Input[Sequence[pulumi.Input['IpFilterRuleArgs']]] ip_filter_rules: The IP filter rules.
        :param pulumi.Input[Mapping[str, pulumi.Input['MessagingEndpointPropertiesArgs']]] messaging_endpoints: The messaging endpoint properties for the file upload notification queue.
        :param pulumi.Input['RoutingPropertiesArgs'] routing: The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        :param pulumi.Input[Mapping[str, pulumi.Input['StorageEndpointPropertiesArgs']]] storage_endpoints: The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
        """
        if authorization_policies is not None:
            pulumi.set(__self__, "authorization_policies", authorization_policies)
        if cloud_to_device is not None:
            pulumi.set(__self__, "cloud_to_device", cloud_to_device)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if device_streams is not None:
            pulumi.set(__self__, "device_streams", device_streams)
        if enable_file_upload_notifications is not None:
            pulumi.set(__self__, "enable_file_upload_notifications", enable_file_upload_notifications)
        if event_hub_endpoints is not None:
            pulumi.set(__self__, "event_hub_endpoints", event_hub_endpoints)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if ip_filter_rules is not None:
            pulumi.set(__self__, "ip_filter_rules", ip_filter_rules)
        if messaging_endpoints is not None:
            pulumi.set(__self__, "messaging_endpoints", messaging_endpoints)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if storage_endpoints is not None:
            pulumi.set(__self__, "storage_endpoints", storage_endpoints)

    @property
    @pulumi.getter(name="authorizationPolicies")
    def authorization_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SharedAccessSignatureAuthorizationRuleArgs']]]]:
        """
        The shared access policies you can use to secure a connection to the IoT hub.
        """
        return pulumi.get(self, "authorization_policies")

    @authorization_policies.setter
    def authorization_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SharedAccessSignatureAuthorizationRuleArgs']]]]):
        pulumi.set(self, "authorization_policies", value)

    @property
    @pulumi.getter(name="cloudToDevice")
    def cloud_to_device(self) -> Optional[pulumi.Input['CloudToDevicePropertiesArgs']]:
        """
        The IoT hub cloud-to-device messaging properties.
        """
        return pulumi.get(self, "cloud_to_device")

    @cloud_to_device.setter
    def cloud_to_device(self, value: Optional[pulumi.Input['CloudToDevicePropertiesArgs']]):
        pulumi.set(self, "cloud_to_device", value)

    @property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[str]]:
        """
        IoT hub comments.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comments", value)

    @property
    @pulumi.getter(name="deviceStreams")
    def device_streams(self) -> Optional[pulumi.Input['IotHubPropertiesDeviceStreamsArgs']]:
        """
        The device streams properties of iothub.
        """
        return pulumi.get(self, "device_streams")

    @device_streams.setter
    def device_streams(self, value: Optional[pulumi.Input['IotHubPropertiesDeviceStreamsArgs']]):
        pulumi.set(self, "device_streams", value)

    @property
    @pulumi.getter(name="enableFileUploadNotifications")
    def enable_file_upload_notifications(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, file upload notifications are enabled.
        """
        return pulumi.get(self, "enable_file_upload_notifications")

    @enable_file_upload_notifications.setter
    def enable_file_upload_notifications(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_file_upload_notifications", value)

    @property
    @pulumi.getter(name="eventHubEndpoints")
    def event_hub_endpoints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['EventHubPropertiesArgs']]]]:
        """
        The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
        """
        return pulumi.get(self, "event_hub_endpoints")

    @event_hub_endpoints.setter
    def event_hub_endpoints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['EventHubPropertiesArgs']]]]):
        pulumi.set(self, "event_hub_endpoints", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Union[str, 'Capabilities']]]:
        """
        The capabilities and features enabled for the IoT hub.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Union[str, 'Capabilities']]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="ipFilterRules")
    def ip_filter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpFilterRuleArgs']]]]:
        """
        The IP filter rules.
        """
        return pulumi.get(self, "ip_filter_rules")

    @ip_filter_rules.setter
    def ip_filter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpFilterRuleArgs']]]]):
        pulumi.set(self, "ip_filter_rules", value)

    @property
    @pulumi.getter(name="messagingEndpoints")
    def messaging_endpoints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['MessagingEndpointPropertiesArgs']]]]:
        """
        The messaging endpoint properties for the file upload notification queue.
        """
        return pulumi.get(self, "messaging_endpoints")

    @messaging_endpoints.setter
    def messaging_endpoints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['MessagingEndpointPropertiesArgs']]]]):
        pulumi.set(self, "messaging_endpoints", value)

    @property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input['RoutingPropertiesArgs']]:
        """
        The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input['RoutingPropertiesArgs']]):
        pulumi.set(self, "routing", value)

    @property
    @pulumi.getter(name="storageEndpoints")
    def storage_endpoints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['StorageEndpointPropertiesArgs']]]]:
        """
        The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
        """
        return pulumi.get(self, "storage_endpoints")

    @storage_endpoints.setter
    def storage_endpoints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['StorageEndpointPropertiesArgs']]]]):
        pulumi.set(self, "storage_endpoints", value)


@pulumi.input_type
class IotHubPropertiesDeviceStreamsArgs:
    def __init__(__self__, *,
                 streaming_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The device streams properties of iothub.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] streaming_endpoints: List of Device Streams Endpoints.
        """
        if streaming_endpoints is not None:
            pulumi.set(__self__, "streaming_endpoints", streaming_endpoints)

    @property
    @pulumi.getter(name="streamingEndpoints")
    def streaming_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Device Streams Endpoints.
        """
        return pulumi.get(self, "streaming_endpoints")

    @streaming_endpoints.setter
    def streaming_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "streaming_endpoints", value)


@pulumi.input_type
class IotHubSkuInfoArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'IotHubSku']],
                 capacity: Optional[pulumi.Input[float]] = None):
        """
        Information about the SKU of the IoT hub.
        :param pulumi.Input[Union[str, 'IotHubSku']] name: The name of the SKU.
        :param pulumi.Input[float] capacity: The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'IotHubSku']]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'IotHubSku']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[float]]:
        """
        The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "capacity", value)


@pulumi.input_type
class IpFilterRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['IpFilterActionType'],
                 filter_name: pulumi.Input[str],
                 ip_mask: pulumi.Input[str]):
        """
        The IP filter rules for the IoT hub.
        :param pulumi.Input['IpFilterActionType'] action: The desired action for requests captured by this rule.
        :param pulumi.Input[str] filter_name: The name of the IP filter rule.
        :param pulumi.Input[str] ip_mask: A string that contains the IP address range in CIDR notation for the rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "filter_name", filter_name)
        pulumi.set(__self__, "ip_mask", ip_mask)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['IpFilterActionType']:
        """
        The desired action for requests captured by this rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['IpFilterActionType']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> pulumi.Input[str]:
        """
        The name of the IP filter rule.
        """
        return pulumi.get(self, "filter_name")

    @filter_name.setter
    def filter_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter_name", value)

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> pulumi.Input[str]:
        """
        A string that contains the IP address range in CIDR notation for the rule.
        """
        return pulumi.get(self, "ip_mask")

    @ip_mask.setter
    def ip_mask(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_mask", value)


@pulumi.input_type
class MessagingEndpointPropertiesArgs:
    def __init__(__self__, *,
                 lock_duration_as_iso8601: Optional[pulumi.Input[str]] = None,
                 max_delivery_count: Optional[pulumi.Input[int]] = None,
                 ttl_as_iso8601: Optional[pulumi.Input[str]] = None):
        """
        The properties of the messaging endpoints used by this IoT hub.
        :param pulumi.Input[str] lock_duration_as_iso8601: The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        :param pulumi.Input[int] max_delivery_count: The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        :param pulumi.Input[str] ttl_as_iso8601: The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        if lock_duration_as_iso8601 is not None:
            pulumi.set(__self__, "lock_duration_as_iso8601", lock_duration_as_iso8601)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if ttl_as_iso8601 is not None:
            pulumi.set(__self__, "ttl_as_iso8601", ttl_as_iso8601)

    @property
    @pulumi.getter(name="lockDurationAsIso8601")
    def lock_duration_as_iso8601(self) -> Optional[pulumi.Input[str]]:
        """
        The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        return pulumi.get(self, "lock_duration_as_iso8601")

    @lock_duration_as_iso8601.setter
    def lock_duration_as_iso8601(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_duration_as_iso8601", value)

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_delivery_count", value)

    @property
    @pulumi.getter(name="ttlAsIso8601")
    def ttl_as_iso8601(self) -> Optional[pulumi.Input[str]]:
        """
        The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        return pulumi.get(self, "ttl_as_iso8601")

    @ttl_as_iso8601.setter
    def ttl_as_iso8601(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl_as_iso8601", value)


@pulumi.input_type
class RoutePropertiesArgs:
    def __init__(__self__, *,
                 endpoint_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 is_enabled: pulumi.Input[bool],
                 name: pulumi.Input[str],
                 source: pulumi.Input[Union[str, 'RoutingSource']],
                 condition: Optional[pulumi.Input[str]] = None):
        """
        The properties of a routing rule that your IoT hub uses to route messages to endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoint_names: The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
        :param pulumi.Input[bool] is_enabled: Used to specify whether a route is enabled.
        :param pulumi.Input[str] name: The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        :param pulumi.Input[Union[str, 'RoutingSource']] source: The source that the routing rule is to be applied to, such as DeviceMessages.
        :param pulumi.Input[str] condition: The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
        """
        return pulumi.get(self, "endpoint_names")

    @endpoint_names.setter
    def endpoint_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "endpoint_names", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Used to specify whether a route is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[Union[str, 'RoutingSource']]:
        """
        The source that the routing rule is to be applied to, such as DeviceMessages.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[Union[str, 'RoutingSource']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)


@pulumi.input_type
class RoutingEndpointsArgs:
    def __init__(__self__, *,
                 event_hubs: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingEventHubPropertiesArgs']]]] = None,
                 service_bus_queues: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingServiceBusQueueEndpointPropertiesArgs']]]] = None,
                 service_bus_topics: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingServiceBusTopicEndpointPropertiesArgs']]]] = None,
                 storage_containers: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingStorageContainerPropertiesArgs']]]] = None):
        """
        The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingEventHubPropertiesArgs']]] event_hubs: The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingServiceBusQueueEndpointPropertiesArgs']]] service_bus_queues: The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingServiceBusTopicEndpointPropertiesArgs']]] service_bus_topics: The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingStorageContainerPropertiesArgs']]] storage_containers: The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
        """
        if event_hubs is not None:
            pulumi.set(__self__, "event_hubs", event_hubs)
        if service_bus_queues is not None:
            pulumi.set(__self__, "service_bus_queues", service_bus_queues)
        if service_bus_topics is not None:
            pulumi.set(__self__, "service_bus_topics", service_bus_topics)
        if storage_containers is not None:
            pulumi.set(__self__, "storage_containers", storage_containers)

    @property
    @pulumi.getter(name="eventHubs")
    def event_hubs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutingEventHubPropertiesArgs']]]]:
        """
        The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
        """
        return pulumi.get(self, "event_hubs")

    @event_hubs.setter
    def event_hubs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingEventHubPropertiesArgs']]]]):
        pulumi.set(self, "event_hubs", value)

    @property
    @pulumi.getter(name="serviceBusQueues")
    def service_bus_queues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutingServiceBusQueueEndpointPropertiesArgs']]]]:
        """
        The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
        """
        return pulumi.get(self, "service_bus_queues")

    @service_bus_queues.setter
    def service_bus_queues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingServiceBusQueueEndpointPropertiesArgs']]]]):
        pulumi.set(self, "service_bus_queues", value)

    @property
    @pulumi.getter(name="serviceBusTopics")
    def service_bus_topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutingServiceBusTopicEndpointPropertiesArgs']]]]:
        """
        The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
        """
        return pulumi.get(self, "service_bus_topics")

    @service_bus_topics.setter
    def service_bus_topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingServiceBusTopicEndpointPropertiesArgs']]]]):
        pulumi.set(self, "service_bus_topics", value)

    @property
    @pulumi.getter(name="storageContainers")
    def storage_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutingStorageContainerPropertiesArgs']]]]:
        """
        The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
        """
        return pulumi.get(self, "storage_containers")

    @storage_containers.setter
    def storage_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingStorageContainerPropertiesArgs']]]]):
        pulumi.set(self, "storage_containers", value)


@pulumi.input_type
class RoutingEventHubPropertiesArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[str],
                 name: pulumi.Input[str],
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None):
        """
        The properties related to an event hub endpoint.
        :param pulumi.Input[str] connection_string: The connection string of the event hub endpoint. 
        :param pulumi.Input[str] name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        :param pulumi.Input[str] resource_group: The name of the resource group of the event hub endpoint.
        :param pulumi.Input[str] subscription_id: The subscription identifier of the event hub endpoint.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "name", name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[str]:
        """
        The connection string of the event hub endpoint. 
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource group of the event hub endpoint.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription identifier of the event hub endpoint.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class RoutingPropertiesArgs:
    def __init__(__self__, *,
                 endpoints: Optional[pulumi.Input['RoutingEndpointsArgs']] = None,
                 enrichments: Optional[pulumi.Input[Sequence[pulumi.Input['EnrichmentPropertiesArgs']]]] = None,
                 fallback_route: Optional[pulumi.Input['FallbackRoutePropertiesArgs']] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['RoutePropertiesArgs']]]] = None):
        """
        The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        :param pulumi.Input['RoutingEndpointsArgs'] endpoints: The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
        :param pulumi.Input[Sequence[pulumi.Input['EnrichmentPropertiesArgs']]] enrichments: The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/iotmsgenrich
        :param pulumi.Input['FallbackRoutePropertiesArgs'] fallback_route: The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['RoutePropertiesArgs']]] routes: The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
        """
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enrichments is not None:
            pulumi.set(__self__, "enrichments", enrichments)
        if fallback_route is not None:
            pulumi.set(__self__, "fallback_route", fallback_route)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input['RoutingEndpointsArgs']]:
        """
        The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input['RoutingEndpointsArgs']]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def enrichments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnrichmentPropertiesArgs']]]]:
        """
        The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/iotmsgenrich
        """
        return pulumi.get(self, "enrichments")

    @enrichments.setter
    def enrichments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnrichmentPropertiesArgs']]]]):
        pulumi.set(self, "enrichments", value)

    @property
    @pulumi.getter(name="fallbackRoute")
    def fallback_route(self) -> Optional[pulumi.Input['FallbackRoutePropertiesArgs']]:
        """
        The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
        """
        return pulumi.get(self, "fallback_route")

    @fallback_route.setter
    def fallback_route(self, value: Optional[pulumi.Input['FallbackRoutePropertiesArgs']]):
        pulumi.set(self, "fallback_route", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutePropertiesArgs']]]]:
        """
        The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutePropertiesArgs']]]]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class RoutingServiceBusQueueEndpointPropertiesArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[str],
                 name: pulumi.Input[str],
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None):
        """
        The properties related to service bus queue endpoint types.
        :param pulumi.Input[str] connection_string: The connection string of the service bus queue endpoint.
        :param pulumi.Input[str] name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name.
        :param pulumi.Input[str] resource_group: The name of the resource group of the service bus queue endpoint.
        :param pulumi.Input[str] subscription_id: The subscription identifier of the service bus queue endpoint.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "name", name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[str]:
        """
        The connection string of the service bus queue endpoint.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource group of the service bus queue endpoint.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription identifier of the service bus queue endpoint.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class RoutingServiceBusTopicEndpointPropertiesArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[str],
                 name: pulumi.Input[str],
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None):
        """
        The properties related to service bus topic endpoint types.
        :param pulumi.Input[str] connection_string: The connection string of the service bus topic endpoint.
        :param pulumi.Input[str] name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name need not be the same as the actual topic name.
        :param pulumi.Input[str] resource_group: The name of the resource group of the service bus topic endpoint.
        :param pulumi.Input[str] subscription_id: The subscription identifier of the service bus topic endpoint.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "name", name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[str]:
        """
        The connection string of the service bus topic endpoint.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name need not be the same as the actual topic name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource group of the service bus topic endpoint.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription identifier of the service bus topic endpoint.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class RoutingStorageContainerPropertiesArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[str],
                 container_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 batch_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 file_name_format: Optional[pulumi.Input[str]] = None,
                 max_chunk_size_in_bytes: Optional[pulumi.Input[int]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None):
        """
        The properties related to a storage container endpoint.
        :param pulumi.Input[str] connection_string: The connection string of the storage account.
        :param pulumi.Input[str] container_name: The name of storage container in the storage account.
        :param pulumi.Input[str] name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        :param pulumi.Input[int] batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        :param pulumi.Input[str] encoding: Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
        :param pulumi.Input[str] file_name_format: File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
        :param pulumi.Input[int] max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        :param pulumi.Input[str] resource_group: The name of the resource group of the storage account.
        :param pulumi.Input[str] subscription_id: The subscription identifier of the storage account.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "name", name)
        if batch_frequency_in_seconds is not None:
            pulumi.set(__self__, "batch_frequency_in_seconds", batch_frequency_in_seconds)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_name_format is not None:
            pulumi.set(__self__, "file_name_format", file_name_format)
        if max_chunk_size_in_bytes is not None:
            pulumi.set(__self__, "max_chunk_size_in_bytes", max_chunk_size_in_bytes)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[str]:
        """
        The connection string of the storage account.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[str]:
        """
        The name of storage container in the storage account.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="batchFrequencyInSeconds")
    def batch_frequency_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        """
        return pulumi.get(self, "batch_frequency_in_seconds")

    @batch_frequency_in_seconds.setter
    def batch_frequency_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_frequency_in_seconds", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="fileNameFormat")
    def file_name_format(self) -> Optional[pulumi.Input[str]]:
        """
        File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
        """
        return pulumi.get(self, "file_name_format")

    @file_name_format.setter
    def file_name_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name_format", value)

    @property
    @pulumi.getter(name="maxChunkSizeInBytes")
    def max_chunk_size_in_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        """
        return pulumi.get(self, "max_chunk_size_in_bytes")

    @max_chunk_size_in_bytes.setter
    def max_chunk_size_in_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_chunk_size_in_bytes", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource group of the storage account.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription identifier of the storage account.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class SharedAccessSignatureAuthorizationRuleArgs:
    def __init__(__self__, *,
                 key_name: pulumi.Input[str],
                 rights: pulumi.Input['AccessRights'],
                 primary_key: Optional[pulumi.Input[str]] = None,
                 secondary_key: Optional[pulumi.Input[str]] = None):
        """
        The properties of an IoT hub shared access policy.
        :param pulumi.Input[str] key_name: The name of the shared access policy.
        :param pulumi.Input['AccessRights'] rights: The permissions assigned to the shared access policy.
        :param pulumi.Input[str] primary_key: The primary key.
        :param pulumi.Input[str] secondary_key: The secondary key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "rights", rights)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[str]:
        """
        The name of the shared access policy.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter
    def rights(self) -> pulumi.Input['AccessRights']:
        """
        The permissions assigned to the shared access policy.
        """
        return pulumi.get(self, "rights")

    @rights.setter
    def rights(self, value: pulumi.Input['AccessRights']):
        pulumi.set(self, "rights", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The primary key.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary key.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_key", value)


@pulumi.input_type
class StorageEndpointPropertiesArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[str],
                 container_name: pulumi.Input[str],
                 sas_ttl_as_iso8601: Optional[pulumi.Input[str]] = None):
        """
        The properties of the Azure Storage endpoint for file upload.
        :param pulumi.Input[str] connection_string: The connection string for the Azure Storage account to which files are uploaded.
        :param pulumi.Input[str] container_name: The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
        :param pulumi.Input[str] sas_ttl_as_iso8601: The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "container_name", container_name)
        if sas_ttl_as_iso8601 is not None:
            pulumi.set(__self__, "sas_ttl_as_iso8601", sas_ttl_as_iso8601)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[str]:
        """
        The connection string for the Azure Storage account to which files are uploaded.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[str]:
        """
        The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="sasTtlAsIso8601")
    def sas_ttl_as_iso8601(self) -> Optional[pulumi.Input[str]]:
        """
        The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
        """
        return pulumi.get(self, "sas_ttl_as_iso8601")

    @sas_ttl_as_iso8601.setter
    def sas_ttl_as_iso8601(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_ttl_as_iso8601", value)


