# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SessionHostConfigurationArgs', 'SessionHostConfiguration']

@pulumi.input_type
class SessionHostConfigurationArgs:
    def __init__(__self__, *,
                 host_pool_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 disk_type: Optional[pulumi.Input[Union[str, 'VirtualMachineDiskType']]] = None,
                 domain_info: Optional[pulumi.Input['DomainInfoPropertiesArgs']] = None,
                 image_info: Optional[pulumi.Input['ImageInfoPropertiesArgs']] = None,
                 v_m_size_id: Optional[pulumi.Input[str]] = None,
                 vm_custom_configuration_uri: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SessionHostConfiguration resource.
        :param pulumi.Input[str] host_pool_name: The name of the host pool within the specified resource group
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Union[str, 'VirtualMachineDiskType']] disk_type: The disk type used by virtual machine in hostpool session host.
        :param pulumi.Input['DomainInfoPropertiesArgs'] domain_info: Domain configurations of session hosts.
        :param pulumi.Input['ImageInfoPropertiesArgs'] image_info: Image configurations of HostPool.
        :param pulumi.Input[str] v_m_size_id: The id of the size of a virtual machine connected to a hostpool.
        :param pulumi.Input[str] vm_custom_configuration_uri: The uri to the storage blob containing scripts to be run on the virtual machine after provisioning.
        """
        pulumi.set(__self__, "host_pool_name", host_pool_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if domain_info is not None:
            pulumi.set(__self__, "domain_info", domain_info)
        if image_info is not None:
            pulumi.set(__self__, "image_info", image_info)
        if v_m_size_id is not None:
            pulumi.set(__self__, "v_m_size_id", v_m_size_id)
        if vm_custom_configuration_uri is not None:
            pulumi.set(__self__, "vm_custom_configuration_uri", vm_custom_configuration_uri)

    @property
    @pulumi.getter(name="hostPoolName")
    def host_pool_name(self) -> pulumi.Input[str]:
        """
        The name of the host pool within the specified resource group
        """
        return pulumi.get(self, "host_pool_name")

    @host_pool_name.setter
    def host_pool_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_pool_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[Union[str, 'VirtualMachineDiskType']]]:
        """
        The disk type used by virtual machine in hostpool session host.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[Union[str, 'VirtualMachineDiskType']]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="domainInfo")
    def domain_info(self) -> Optional[pulumi.Input['DomainInfoPropertiesArgs']]:
        """
        Domain configurations of session hosts.
        """
        return pulumi.get(self, "domain_info")

    @domain_info.setter
    def domain_info(self, value: Optional[pulumi.Input['DomainInfoPropertiesArgs']]):
        pulumi.set(self, "domain_info", value)

    @property
    @pulumi.getter(name="imageInfo")
    def image_info(self) -> Optional[pulumi.Input['ImageInfoPropertiesArgs']]:
        """
        Image configurations of HostPool.
        """
        return pulumi.get(self, "image_info")

    @image_info.setter
    def image_info(self, value: Optional[pulumi.Input['ImageInfoPropertiesArgs']]):
        pulumi.set(self, "image_info", value)

    @property
    @pulumi.getter(name="vMSizeId")
    def v_m_size_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the size of a virtual machine connected to a hostpool.
        """
        return pulumi.get(self, "v_m_size_id")

    @v_m_size_id.setter
    def v_m_size_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v_m_size_id", value)

    @property
    @pulumi.getter(name="vmCustomConfigurationUri")
    def vm_custom_configuration_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The uri to the storage blob containing scripts to be run on the virtual machine after provisioning.
        """
        return pulumi.get(self, "vm_custom_configuration_uri")

    @vm_custom_configuration_uri.setter
    def vm_custom_configuration_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_custom_configuration_uri", value)


class SessionHostConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_type: Optional[pulumi.Input[Union[str, 'VirtualMachineDiskType']]] = None,
                 domain_info: Optional[pulumi.Input[pulumi.InputType['DomainInfoPropertiesArgs']]] = None,
                 host_pool_name: Optional[pulumi.Input[str]] = None,
                 image_info: Optional[pulumi.Input[pulumi.InputType['ImageInfoPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 v_m_size_id: Optional[pulumi.Input[str]] = None,
                 vm_custom_configuration_uri: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a SessionHostConfiguration definition.
        API Version: 2021-05-13-preview.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'VirtualMachineDiskType']] disk_type: The disk type used by virtual machine in hostpool session host.
        :param pulumi.Input[pulumi.InputType['DomainInfoPropertiesArgs']] domain_info: Domain configurations of session hosts.
        :param pulumi.Input[str] host_pool_name: The name of the host pool within the specified resource group
        :param pulumi.Input[pulumi.InputType['ImageInfoPropertiesArgs']] image_info: Image configurations of HostPool.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] v_m_size_id: The id of the size of a virtual machine connected to a hostpool.
        :param pulumi.Input[str] vm_custom_configuration_uri: The uri to the storage blob containing scripts to be run on the virtual machine after provisioning.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SessionHostConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a SessionHostConfiguration definition.
        API Version: 2021-05-13-preview.

        :param str resource_name: The name of the resource.
        :param SessionHostConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SessionHostConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_type: Optional[pulumi.Input[Union[str, 'VirtualMachineDiskType']]] = None,
                 domain_info: Optional[pulumi.Input[pulumi.InputType['DomainInfoPropertiesArgs']]] = None,
                 host_pool_name: Optional[pulumi.Input[str]] = None,
                 image_info: Optional[pulumi.Input[pulumi.InputType['ImageInfoPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 v_m_size_id: Optional[pulumi.Input[str]] = None,
                 vm_custom_configuration_uri: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SessionHostConfigurationArgs.__new__(SessionHostConfigurationArgs)

            __props__.__dict__["disk_type"] = disk_type
            __props__.__dict__["domain_info"] = domain_info
            if host_pool_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_pool_name'")
            __props__.__dict__["host_pool_name"] = host_pool_name
            __props__.__dict__["image_info"] = image_info
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["v_m_size_id"] = v_m_size_id
            __props__.__dict__["vm_custom_configuration_uri"] = vm_custom_configuration_uri
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["version"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:desktopvirtualization:SessionHostConfiguration"), pulumi.Alias(type_="azure-native:desktopvirtualization/v20210513preview:SessionHostConfiguration"), pulumi.Alias(type_="azure-nextgen:desktopvirtualization/v20210513preview:SessionHostConfiguration")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SessionHostConfiguration, __self__).__init__(
            'azure-native:desktopvirtualization:SessionHostConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SessionHostConfiguration':
        """
        Get an existing SessionHostConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SessionHostConfigurationArgs.__new__(SessionHostConfigurationArgs)

        __props__.__dict__["disk_type"] = None
        __props__.__dict__["domain_info"] = None
        __props__.__dict__["image_info"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["v_m_size_id"] = None
        __props__.__dict__["version"] = None
        __props__.__dict__["vm_custom_configuration_uri"] = None
        return SessionHostConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Output[Optional[str]]:
        """
        The disk type used by virtual machine in hostpool session host.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="domainInfo")
    def domain_info(self) -> pulumi.Output[Optional['outputs.DomainInfoPropertiesResponse']]:
        """
        Domain configurations of session hosts.
        """
        return pulumi.get(self, "domain_info")

    @property
    @pulumi.getter(name="imageInfo")
    def image_info(self) -> pulumi.Output[Optional['outputs.ImageInfoPropertiesResponse']]:
        """
        Image configurations of HostPool.
        """
        return pulumi.get(self, "image_info")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vMSizeId")
    def v_m_size_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the size of a virtual machine connected to a hostpool.
        """
        return pulumi.get(self, "v_m_size_id")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The time when session host configuration was last modified and something was changed.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vmCustomConfigurationUri")
    def vm_custom_configuration_uri(self) -> pulumi.Output[Optional[str]]:
        """
        The uri to the storage blob containing scripts to be run on the virtual machine after provisioning.
        """
        return pulumi.get(self, "vm_custom_configuration_uri")

