# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AssessmentStatusArgs',
    'AzureResourceDetailsArgs',
    'JitNetworkAccessPolicyVirtualMachineArgs',
    'JitNetworkAccessPortRuleArgs',
    'JitNetworkAccessRequestArgs',
    'JitNetworkAccessRequestPortArgs',
    'JitNetworkAccessRequestVirtualMachineArgs',
    'OnPremiseResourceDetailsArgs',
    'OnPremiseSqlResourceDetailsArgs',
    'PathRecommendationArgs',
    'ProtectionModeArgs',
    'PublisherInfoArgs',
    'SecurityAssessmentMetadataPartnerDataArgs',
    'SecurityAssessmentMetadataPropertiesArgs',
    'SecurityAssessmentPartnerDataArgs',
    'UserRecommendationArgs',
    'VmRecommendationArgs',
]

@pulumi.input_type
class AssessmentStatusArgs:
    def __init__(__self__, *,
                 code: pulumi.Input[Union[str, 'AssessmentStatusCode']],
                 cause: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        The result of the assessment
        :param pulumi.Input[Union[str, 'AssessmentStatusCode']] code: Programmatic code for the status of the assessment
        :param pulumi.Input[str] cause: Programmatic code for the cause of the assessment status
        :param pulumi.Input[str] description: Human readable description of the assessment status
        """
        pulumi.set(__self__, "code", code)
        if cause is not None:
            pulumi.set(__self__, "cause", cause)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def code(self) -> pulumi.Input[Union[str, 'AssessmentStatusCode']]:
        """
        Programmatic code for the status of the assessment
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input[Union[str, 'AssessmentStatusCode']]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def cause(self) -> Optional[pulumi.Input[str]]:
        """
        Programmatic code for the cause of the assessment status
        """
        return pulumi.get(self, "cause")

    @cause.setter
    def cause(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cause", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description of the assessment status
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AzureResourceDetailsArgs:
    def __init__(__self__, *,
                 source: pulumi.Input[str]):
        """
        Details of the Azure resource that was assessed
        :param pulumi.Input[str] source: The platform where the assessed resource resides
               Expected value is 'Azure'.
        """
        pulumi.set(__self__, "source", 'Azure')

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The platform where the assessed resource resides
        Expected value is 'Azure'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class JitNetworkAccessPolicyVirtualMachineArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 ports: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]],
                 public_ip_address: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: Resource ID of the virtual machine that is linked to this policy
        :param pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]] ports: Port configurations for the virtual machine
        :param pulumi.Input[str] public_ip_address: Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]]:
        """
        Port configurations for the virtual machine
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)


@pulumi.input_type
class JitNetworkAccessPortRuleArgs:
    def __init__(__self__, *,
                 max_request_access_duration: pulumi.Input[str],
                 number: pulumi.Input[int],
                 protocol: pulumi.Input[Union[str, 'Protocol']],
                 allowed_source_address_prefix: Optional[pulumi.Input[str]] = None,
                 allowed_source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] max_request_access_duration: Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        :param pulumi.Input[str] allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        pulumi.set(__self__, "max_request_access_duration", max_request_access_duration)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "protocol", protocol)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)

    @property
    @pulumi.getter(name="maxRequestAccessDuration")
    def max_request_access_duration(self) -> pulumi.Input[str]:
        """
        Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        """
        return pulumi.get(self, "max_request_access_duration")

    @max_request_access_duration.setter
    def max_request_access_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "max_request_access_duration", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[int]:
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[int]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'Protocol']]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'Protocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @allowed_source_address_prefix.setter
    def allowed_source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_source_address_prefix", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")

    @allowed_source_address_prefixes.setter
    def allowed_source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_source_address_prefixes", value)


@pulumi.input_type
class JitNetworkAccessRequestArgs:
    def __init__(__self__, *,
                 requestor: pulumi.Input[str],
                 start_time_utc: pulumi.Input[str],
                 virtual_machines: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestVirtualMachineArgs']]],
                 justification: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] requestor: The identity of the person who made the request
        :param pulumi.Input[str] start_time_utc: The start time of the request in UTC
        :param pulumi.Input[str] justification: The justification for making the initiate request
        """
        pulumi.set(__self__, "requestor", requestor)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "virtual_machines", virtual_machines)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)

    @property
    @pulumi.getter
    def requestor(self) -> pulumi.Input[str]:
        """
        The identity of the person who made the request
        """
        return pulumi.get(self, "requestor")

    @requestor.setter
    def requestor(self, value: pulumi.Input[str]):
        pulumi.set(self, "requestor", value)

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> pulumi.Input[str]:
        """
        The start time of the request in UTC
        """
        return pulumi.get(self, "start_time_utc")

    @start_time_utc.setter
    def start_time_utc(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time_utc", value)

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestVirtualMachineArgs']]]:
        return pulumi.get(self, "virtual_machines")

    @virtual_machines.setter
    def virtual_machines(self, value: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestVirtualMachineArgs']]]):
        pulumi.set(self, "virtual_machines", value)

    @property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[str]]:
        """
        The justification for making the initiate request
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "justification", value)


@pulumi.input_type
class JitNetworkAccessRequestPortArgs:
    def __init__(__self__, *,
                 end_time_utc: pulumi.Input[str],
                 number: pulumi.Input[int],
                 status: pulumi.Input[Union[str, 'Status']],
                 status_reason: pulumi.Input[Union[str, 'StatusReason']],
                 allowed_source_address_prefix: Optional[pulumi.Input[str]] = None,
                 allowed_source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mapped_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] end_time_utc: The date & time at which the request ends in UTC
        :param pulumi.Input[Union[str, 'Status']] status: The status of the port
        :param pulumi.Input[Union[str, 'StatusReason']] status_reason: A description of why the `status` has its value
        :param pulumi.Input[str] allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        :param pulumi.Input[int] mapped_port: The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)
        if mapped_port is not None:
            pulumi.set(__self__, "mapped_port", mapped_port)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> pulumi.Input[str]:
        """
        The date & time at which the request ends in UTC
        """
        return pulumi.get(self, "end_time_utc")

    @end_time_utc.setter
    def end_time_utc(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_time_utc", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[int]:
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[int]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'Status']]:
        """
        The status of the port
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'Status']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Input[Union[str, 'StatusReason']]:
        """
        A description of why the `status` has its value
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: pulumi.Input[Union[str, 'StatusReason']]):
        pulumi.set(self, "status_reason", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @allowed_source_address_prefix.setter
    def allowed_source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_source_address_prefix", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")

    @allowed_source_address_prefixes.setter
    def allowed_source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_source_address_prefixes", value)

    @property
    @pulumi.getter(name="mappedPort")
    def mapped_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        return pulumi.get(self, "mapped_port")

    @mapped_port.setter
    def mapped_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mapped_port", value)


@pulumi.input_type
class JitNetworkAccessRequestVirtualMachineArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 ports: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]]):
        """
        :param pulumi.Input[str] id: Resource ID of the virtual machine that is linked to this policy
        :param pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]] ports: The ports that were opened for the virtual machine
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]]:
        """
        The ports that were opened for the virtual machine
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class OnPremiseResourceDetailsArgs:
    def __init__(__self__, *,
                 machine_name: pulumi.Input[str],
                 source: pulumi.Input[str],
                 source_computer_id: pulumi.Input[str],
                 vmuuid: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        Details of the On Premise resource that was assessed
        :param pulumi.Input[str] machine_name: The name of the machine
        :param pulumi.Input[str] source: The platform where the assessed resource resides
               Expected value is 'OnPremise'.
        :param pulumi.Input[str] source_computer_id: The oms agent Id installed on the machine
        :param pulumi.Input[str] vmuuid: The unique Id of the machine
        :param pulumi.Input[str] workspace_id: Azure resource Id of the workspace the machine is attached to
        """
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "source", 'OnPremise')
        pulumi.set(__self__, "source_computer_id", source_computer_id)
        pulumi.set(__self__, "vmuuid", vmuuid)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> pulumi.Input[str]:
        """
        The name of the machine
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The platform where the assessed resource resides
        Expected value is 'OnPremise'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceComputerId")
    def source_computer_id(self) -> pulumi.Input[str]:
        """
        The oms agent Id installed on the machine
        """
        return pulumi.get(self, "source_computer_id")

    @source_computer_id.setter
    def source_computer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_computer_id", value)

    @property
    @pulumi.getter
    def vmuuid(self) -> pulumi.Input[str]:
        """
        The unique Id of the machine
        """
        return pulumi.get(self, "vmuuid")

    @vmuuid.setter
    def vmuuid(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmuuid", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        Azure resource Id of the workspace the machine is attached to
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class OnPremiseSqlResourceDetailsArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 machine_name: pulumi.Input[str],
                 server_name: pulumi.Input[str],
                 source: pulumi.Input[str],
                 source_computer_id: pulumi.Input[str],
                 vmuuid: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        Details of the On Premise Sql resource that was assessed
        :param pulumi.Input[str] database_name: The Sql database name installed on the machine
        :param pulumi.Input[str] machine_name: The name of the machine
        :param pulumi.Input[str] server_name: The Sql server name installed on the machine
        :param pulumi.Input[str] source: The platform where the assessed resource resides
               Expected value is 'OnPremiseSql'.
        :param pulumi.Input[str] source_computer_id: The oms agent Id installed on the machine
        :param pulumi.Input[str] vmuuid: The unique Id of the machine
        :param pulumi.Input[str] workspace_id: Azure resource Id of the workspace the machine is attached to
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "source", 'OnPremiseSql')
        pulumi.set(__self__, "source_computer_id", source_computer_id)
        pulumi.set(__self__, "vmuuid", vmuuid)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The Sql database name installed on the machine
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> pulumi.Input[str]:
        """
        The name of the machine
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The Sql server name installed on the machine
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The platform where the assessed resource resides
        Expected value is 'OnPremiseSql'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceComputerId")
    def source_computer_id(self) -> pulumi.Input[str]:
        """
        The oms agent Id installed on the machine
        """
        return pulumi.get(self, "source_computer_id")

    @source_computer_id.setter
    def source_computer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_computer_id", value)

    @property
    @pulumi.getter
    def vmuuid(self) -> pulumi.Input[str]:
        """
        The unique Id of the machine
        """
        return pulumi.get(self, "vmuuid")

    @vmuuid.setter
    def vmuuid(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmuuid", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        Azure resource Id of the workspace the machine is attached to
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class PathRecommendationArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 common: Optional[pulumi.Input[bool]] = None,
                 configuration_status: Optional[pulumi.Input[str]] = None,
                 file_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 publisher_info: Optional[pulumi.Input['PublisherInfoArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_sids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 usernames: Optional[pulumi.Input[Sequence[pulumi.Input['UserRecommendationArgs']]]] = None):
        """
        Represents a path that is recommended to be allowed and its properties
        :param pulumi.Input[str] action: The recommendation action of the machine or rule
        :param pulumi.Input[bool] common: Whether the application is commonly run on the machine
        :param pulumi.Input[str] configuration_status: The configuration status of the machines group or machine or rule
        :param pulumi.Input[str] file_type: The type of the file (for Linux files - Executable is used)
        :param pulumi.Input[str] path: The full path of the file, or an identifier of the application
        :param pulumi.Input['PublisherInfoArgs'] publisher_info: Represents the publisher information of a process/rule
        :param pulumi.Input[str] type: The type of the rule to be allowed
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if common is not None:
            pulumi.set(__self__, "common", common)
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if publisher_info is not None:
            pulumi.set(__self__, "publisher_info", publisher_info)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_sids is not None:
            pulumi.set(__self__, "user_sids", user_sids)
        if usernames is not None:
            pulumi.set(__self__, "usernames", usernames)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation action of the machine or rule
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def common(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the application is commonly run on the machine
        """
        return pulumi.get(self, "common")

    @common.setter
    def common(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "common", value)

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration status of the machines group or machine or rule
        """
        return pulumi.get(self, "configuration_status")

    @configuration_status.setter
    def configuration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_status", value)

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the file (for Linux files - Executable is used)
        """
        return pulumi.get(self, "file_type")

    @file_type.setter
    def file_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The full path of the file, or an identifier of the application
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="publisherInfo")
    def publisher_info(self) -> Optional[pulumi.Input['PublisherInfoArgs']]:
        """
        Represents the publisher information of a process/rule
        """
        return pulumi.get(self, "publisher_info")

    @publisher_info.setter
    def publisher_info(self, value: Optional[pulumi.Input['PublisherInfoArgs']]):
        pulumi.set(self, "publisher_info", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the rule to be allowed
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userSids")
    def user_sids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "user_sids")

    @user_sids.setter
    def user_sids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_sids", value)

    @property
    @pulumi.getter
    def usernames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserRecommendationArgs']]]]:
        return pulumi.get(self, "usernames")

    @usernames.setter
    def usernames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserRecommendationArgs']]]]):
        pulumi.set(self, "usernames", value)


@pulumi.input_type
class ProtectionModeArgs:
    def __init__(__self__, *,
                 exe: Optional[pulumi.Input[str]] = None,
                 executable: Optional[pulumi.Input[str]] = None,
                 msi: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None):
        """
        The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
        :param pulumi.Input[str] exe: The application control policy enforcement/protection mode of the machine group
        :param pulumi.Input[str] executable: The application control policy enforcement/protection mode of the machine group
        :param pulumi.Input[str] msi: The application control policy enforcement/protection mode of the machine group
        :param pulumi.Input[str] script: The application control policy enforcement/protection mode of the machine group
        """
        if exe is not None:
            pulumi.set(__self__, "exe", exe)
        if executable is not None:
            pulumi.set(__self__, "executable", executable)
        if msi is not None:
            pulumi.set(__self__, "msi", msi)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def exe(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "exe")

    @exe.setter
    def exe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exe", value)

    @property
    @pulumi.getter
    def executable(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "executable")

    @executable.setter
    def executable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "executable", value)

    @property
    @pulumi.getter
    def msi(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "msi")

    @msi.setter
    def msi(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msi", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)


@pulumi.input_type
class PublisherInfoArgs:
    def __init__(__self__, *,
                 binary_name: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 publisher_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Represents the publisher information of a process/rule
        :param pulumi.Input[str] binary_name: The "OriginalName" field taken from the file's version resource
        :param pulumi.Input[str] product_name: The product name taken from the file's version resource
        :param pulumi.Input[str] publisher_name: The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        :param pulumi.Input[str] version: The binary file version taken from the file's version resource
        """
        if binary_name is not None:
            pulumi.set(__self__, "binary_name", binary_name)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if publisher_name is not None:
            pulumi.set(__self__, "publisher_name", publisher_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="binaryName")
    def binary_name(self) -> Optional[pulumi.Input[str]]:
        """
        The "OriginalName" field taken from the file's version resource
        """
        return pulumi.get(self, "binary_name")

    @binary_name.setter
    def binary_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binary_name", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        The product name taken from the file's version resource
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)

    @property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        """
        return pulumi.get(self, "publisher_name")

    @publisher_name.setter
    def publisher_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The binary file version taken from the file's version resource
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class SecurityAssessmentMetadataPartnerDataArgs:
    def __init__(__self__, *,
                 partner_name: pulumi.Input[str],
                 secret: pulumi.Input[str],
                 product_name: Optional[pulumi.Input[str]] = None):
        """
        Describes the partner that created the assessment
        :param pulumi.Input[str] partner_name: Name of the company of the partner
        :param pulumi.Input[str] secret: Secret to authenticate the partner and verify it created the assessment - write only
        :param pulumi.Input[str] product_name: Name of the product of the partner that created the assessment
        """
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "secret", secret)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> pulumi.Input[str]:
        """
        Name of the company of the partner
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        Secret to authenticate the partner and verify it created the assessment - write only
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the product of the partner that created the assessment
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)


@pulumi.input_type
class SecurityAssessmentMetadataPropertiesArgs:
    def __init__(__self__, *,
                 assessment_type: pulumi.Input[Union[str, 'AssessmentType']],
                 display_name: pulumi.Input[str],
                 severity: pulumi.Input[Union[str, 'Severity']],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Categories']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 implementation_effort: Optional[pulumi.Input[Union[str, 'ImplementationEffort']]] = None,
                 partner_data: Optional[pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs']] = None,
                 preview: Optional[pulumi.Input[bool]] = None,
                 remediation_description: Optional[pulumi.Input[str]] = None,
                 threats: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Threats']]]]] = None,
                 user_impact: Optional[pulumi.Input[Union[str, 'UserImpact']]] = None):
        """
        Describes properties of an assessment metadata.
        :param pulumi.Input[Union[str, 'AssessmentType']] assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
        :param pulumi.Input[str] display_name: User friendly display name of the assessment
        :param pulumi.Input[Union[str, 'Severity']] severity: The severity level of the assessment
        :param pulumi.Input[str] description: Human readable description of the assessment
        :param pulumi.Input[Union[str, 'ImplementationEffort']] implementation_effort: The implementation effort required to remediate this assessment
        :param pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs'] partner_data: Describes the partner that created the assessment
        :param pulumi.Input[bool] preview: True if this assessment is in preview release status
        :param pulumi.Input[str] remediation_description: Human readable description of what you should do to mitigate this security issue
        :param pulumi.Input[Union[str, 'UserImpact']] user_impact: The user impact of the assessment
        """
        pulumi.set(__self__, "assessment_type", assessment_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "severity", severity)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if implementation_effort is not None:
            pulumi.set(__self__, "implementation_effort", implementation_effort)
        if partner_data is not None:
            pulumi.set(__self__, "partner_data", partner_data)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if remediation_description is not None:
            pulumi.set(__self__, "remediation_description", remediation_description)
        if threats is not None:
            pulumi.set(__self__, "threats", threats)
        if user_impact is not None:
            pulumi.set(__self__, "user_impact", user_impact)

    @property
    @pulumi.getter(name="assessmentType")
    def assessment_type(self) -> pulumi.Input[Union[str, 'AssessmentType']]:
        """
        BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
        """
        return pulumi.get(self, "assessment_type")

    @assessment_type.setter
    def assessment_type(self, value: pulumi.Input[Union[str, 'AssessmentType']]):
        pulumi.set(self, "assessment_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        User friendly display name of the assessment
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[Union[str, 'Severity']]:
        """
        The severity level of the assessment
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[Union[str, 'Severity']]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Categories']]]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Categories']]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description of the assessment
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="implementationEffort")
    def implementation_effort(self) -> Optional[pulumi.Input[Union[str, 'ImplementationEffort']]]:
        """
        The implementation effort required to remediate this assessment
        """
        return pulumi.get(self, "implementation_effort")

    @implementation_effort.setter
    def implementation_effort(self, value: Optional[pulumi.Input[Union[str, 'ImplementationEffort']]]):
        pulumi.set(self, "implementation_effort", value)

    @property
    @pulumi.getter(name="partnerData")
    def partner_data(self) -> Optional[pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs']]:
        """
        Describes the partner that created the assessment
        """
        return pulumi.get(self, "partner_data")

    @partner_data.setter
    def partner_data(self, value: Optional[pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs']]):
        pulumi.set(self, "partner_data", value)

    @property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input[bool]]:
        """
        True if this assessment is in preview release status
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preview", value)

    @property
    @pulumi.getter(name="remediationDescription")
    def remediation_description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description of what you should do to mitigate this security issue
        """
        return pulumi.get(self, "remediation_description")

    @remediation_description.setter
    def remediation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remediation_description", value)

    @property
    @pulumi.getter
    def threats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Threats']]]]]:
        return pulumi.get(self, "threats")

    @threats.setter
    def threats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Threats']]]]]):
        pulumi.set(self, "threats", value)

    @property
    @pulumi.getter(name="userImpact")
    def user_impact(self) -> Optional[pulumi.Input[Union[str, 'UserImpact']]]:
        """
        The user impact of the assessment
        """
        return pulumi.get(self, "user_impact")

    @user_impact.setter
    def user_impact(self, value: Optional[pulumi.Input[Union[str, 'UserImpact']]]):
        pulumi.set(self, "user_impact", value)


@pulumi.input_type
class SecurityAssessmentPartnerDataArgs:
    def __init__(__self__, *,
                 partner_name: pulumi.Input[str],
                 secret: pulumi.Input[str]):
        """
        Data regarding 3rd party partner integration
        :param pulumi.Input[str] partner_name: Name of the company of the partner
        :param pulumi.Input[str] secret: secret to authenticate the partner - write only
        """
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> pulumi.Input[str]:
        """
        Name of the company of the partner
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        secret to authenticate the partner - write only
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class UserRecommendationArgs:
    def __init__(__self__, *,
                 recommendation_action: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Represents a user that is recommended to be allowed for a certain rule
        :param pulumi.Input[str] recommendation_action: The recommendation action of the machine or rule
        :param pulumi.Input[str] username: Represents a user that is recommended to be allowed for a certain rule
        """
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation action of the machine or rule
        """
        return pulumi.get(self, "recommendation_action")

    @recommendation_action.setter
    def recommendation_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recommendation_action", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Represents a user that is recommended to be allowed for a certain rule
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VmRecommendationArgs:
    def __init__(__self__, *,
                 configuration_status: Optional[pulumi.Input[str]] = None,
                 enforcement_support: Optional[pulumi.Input[str]] = None,
                 recommendation_action: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Represents a machine that is part of a machine group
        :param pulumi.Input[str] configuration_status: The configuration status of the machines group or machine or rule
        :param pulumi.Input[str] enforcement_support: The machine supportability of Enforce feature
        :param pulumi.Input[str] recommendation_action: The recommendation action of the machine or rule
        :param pulumi.Input[str] resource_id: The full resource id of the machine
        """
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if enforcement_support is not None:
            pulumi.set(__self__, "enforcement_support", enforcement_support)
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration status of the machines group or machine or rule
        """
        return pulumi.get(self, "configuration_status")

    @configuration_status.setter
    def configuration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_status", value)

    @property
    @pulumi.getter(name="enforcementSupport")
    def enforcement_support(self) -> Optional[pulumi.Input[str]]:
        """
        The machine supportability of Enforce feature
        """
        return pulumi.get(self, "enforcement_support")

    @enforcement_support.setter
    def enforcement_support(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enforcement_support", value)

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation action of the machine or rule
        """
        return pulumi.get(self, "recommendation_action")

    @recommendation_action.setter
    def recommendation_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recommendation_action", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource id of the machine
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


