# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'ArmRoleReceiverArgs',
    'AutomationRunbookReceiverArgs',
    'AzureAppPushReceiverArgs',
    'AzureFunctionReceiverArgs',
    'EmailReceiverArgs',
    'ItsmReceiverArgs',
    'LogicAppReceiverArgs',
    'SmsReceiverArgs',
    'VoiceReceiverArgs',
    'WebhookReceiverArgs',
]

@pulumi.input_type
class ArmRoleReceiverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 role_id: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An arm role receiver.
        :param pulumi.Input[str] name: The name of the arm role receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] role_id: The arm role id.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_id", role_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the arm role receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[str]:
        """
        The arm role id.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_id", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class AutomationRunbookReceiverArgs:
    def __init__(__self__, *,
                 automation_account_id: pulumi.Input[str],
                 is_global_runbook: pulumi.Input[bool],
                 runbook_name: pulumi.Input[str],
                 webhook_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None,
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        The Azure Automation Runbook notification receiver.
        :param pulumi.Input[str] automation_account_id: The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        :param pulumi.Input[bool] is_global_runbook: Indicates whether this instance is global runbook.
        :param pulumi.Input[str] runbook_name: The name for this runbook.
        :param pulumi.Input[str] webhook_resource_id: The resource id for webhook linked to this runbook.
        :param pulumi.Input[str] name: Indicates name of the webhook.
        :param pulumi.Input[str] service_uri: The URI where webhooks should be sent.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "automation_account_id", automation_account_id)
        pulumi.set(__self__, "is_global_runbook", is_global_runbook)
        pulumi.set(__self__, "runbook_name", runbook_name)
        pulumi.set(__self__, "webhook_resource_id", webhook_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> pulumi.Input[str]:
        """
        The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        """
        return pulumi.get(self, "automation_account_id")

    @automation_account_id.setter
    def automation_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "automation_account_id", value)

    @property
    @pulumi.getter(name="isGlobalRunbook")
    def is_global_runbook(self) -> pulumi.Input[bool]:
        """
        Indicates whether this instance is global runbook.
        """
        return pulumi.get(self, "is_global_runbook")

    @is_global_runbook.setter
    def is_global_runbook(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_global_runbook", value)

    @property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> pulumi.Input[str]:
        """
        The name for this runbook.
        """
        return pulumi.get(self, "runbook_name")

    @runbook_name.setter
    def runbook_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "runbook_name", value)

    @property
    @pulumi.getter(name="webhookResourceId")
    def webhook_resource_id(self) -> pulumi.Input[str]:
        """
        The resource id for webhook linked to this runbook.
        """
        return pulumi.get(self, "webhook_resource_id")

    @webhook_resource_id.setter
    def webhook_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "webhook_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates name of the webhook.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class AzureAppPushReceiverArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        The Azure mobile App push notification receiver.
        :param pulumi.Input[str] email_address: The email address registered for the Azure mobile app.
        :param pulumi.Input[str] name: The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address registered for the Azure mobile app.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureFunctionReceiverArgs:
    def __init__(__self__, *,
                 function_app_resource_id: pulumi.Input[str],
                 function_name: pulumi.Input[str],
                 http_trigger_url: pulumi.Input[str],
                 name: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An azure function receiver.
        :param pulumi.Input[str] function_app_resource_id: The azure resource id of the function app.
        :param pulumi.Input[str] function_name: The function name in the function app.
        :param pulumi.Input[str] http_trigger_url: The http trigger url where http request sent to.
        :param pulumi.Input[str] name: The name of the azure function receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "function_app_resource_id", function_app_resource_id)
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "http_trigger_url", http_trigger_url)
        pulumi.set(__self__, "name", name)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="functionAppResourceId")
    def function_app_resource_id(self) -> pulumi.Input[str]:
        """
        The azure resource id of the function app.
        """
        return pulumi.get(self, "function_app_resource_id")

    @function_app_resource_id.setter
    def function_app_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_app_resource_id", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        The function name in the function app.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="httpTriggerUrl")
    def http_trigger_url(self) -> pulumi.Input[str]:
        """
        The http trigger url where http request sent to.
        """
        return pulumi.get(self, "http_trigger_url")

    @http_trigger_url.setter
    def http_trigger_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "http_trigger_url", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the azure function receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class EmailReceiverArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An email receiver.
        :param pulumi.Input[str] email_address: The email address of this receiver.
        :param pulumi.Input[str] name: The name of the email receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address of this receiver.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the email receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class ItsmReceiverArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 region: pulumi.Input[str],
                 ticket_configuration: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        An Itsm receiver.
        :param pulumi.Input[str] connection_id: Unique identification of ITSM connection among multiple defined in above workspace.
        :param pulumi.Input[str] name: The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] region: Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        :param pulumi.Input[str] ticket_configuration: JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        :param pulumi.Input[str] workspace_id: OMS LA instance identifier.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "ticket_configuration", ticket_configuration)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[str]:
        """
        Unique identification of ITSM connection among multiple defined in above workspace.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ticketConfiguration")
    def ticket_configuration(self) -> pulumi.Input[str]:
        """
        JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        """
        return pulumi.get(self, "ticket_configuration")

    @ticket_configuration.setter
    def ticket_configuration(self, value: pulumi.Input[str]):
        pulumi.set(self, "ticket_configuration", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        OMS LA instance identifier.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class LogicAppReceiverArgs:
    def __init__(__self__, *,
                 callback_url: pulumi.Input[str],
                 name: pulumi.Input[str],
                 resource_id: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        A logic app receiver.
        :param pulumi.Input[str] callback_url: The callback url where http request sent to.
        :param pulumi.Input[str] name: The name of the logic app receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] resource_id: The azure resource id of the logic app receiver.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> pulumi.Input[str]:
        """
        The callback url where http request sent to.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "callback_url", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the logic app receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The azure resource id of the logic app receiver.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class SmsReceiverArgs:
    def __init__(__self__, *,
                 country_code: pulumi.Input[str],
                 name: pulumi.Input[str],
                 phone_number: pulumi.Input[str]):
        """
        An SMS receiver.
        :param pulumi.Input[str] country_code: The country code of the SMS receiver.
        :param pulumi.Input[str] name: The name of the SMS receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] phone_number: The phone number of the SMS receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Input[str]:
        """
        The country code of the SMS receiver.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SMS receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number of the SMS receiver.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class VoiceReceiverArgs:
    def __init__(__self__, *,
                 country_code: pulumi.Input[str],
                 name: pulumi.Input[str],
                 phone_number: pulumi.Input[str]):
        """
        A voice receiver.
        :param pulumi.Input[str] country_code: The country code of the voice receiver.
        :param pulumi.Input[str] name: The name of the voice receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] phone_number: The phone number of the voice receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Input[str]:
        """
        The country code of the voice receiver.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the voice receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number of the voice receiver.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class WebhookReceiverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 service_uri: pulumi.Input[str],
                 identifier_uri: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_aad_auth: Optional[pulumi.Input[bool]] = None,
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        A webhook receiver.
        :param pulumi.Input[str] name: The name of the webhook receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] service_uri: The URI where webhooks should be sent.
        :param pulumi.Input[str] identifier_uri: Indicates the identifier uri for aad auth.
        :param pulumi.Input[str] object_id: Indicates the webhook app object Id for aad auth.
        :param pulumi.Input[str] tenant_id: Indicates the tenant id for aad auth.
        :param pulumi.Input[bool] use_aad_auth: Indicates whether or not use AAD authentication.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_uri", service_uri)
        if identifier_uri is not None:
            pulumi.set(__self__, "identifier_uri", identifier_uri)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_aad_auth is None:
            use_aad_auth = False
        if use_aad_auth is not None:
            pulumi.set(__self__, "use_aad_auth", use_aad_auth)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the webhook receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Input[str]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="identifierUri")
    def identifier_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the identifier uri for aad auth.
        """
        return pulumi.get(self, "identifier_uri")

    @identifier_uri.setter
    def identifier_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier_uri", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the webhook app object Id for aad auth.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the tenant id for aad auth.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useAadAuth")
    def use_aad_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not use AAD authentication.
        """
        return pulumi.get(self, "use_aad_auth")

    @use_aad_auth.setter
    def use_aad_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_aad_auth", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


