# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SmbFileShareArgs', 'SmbFileShare']

@pulumi.input_type
class SmbFileShareArgs:
    def __init__(__self__, *,
                 gateway_arn: pulumi.Input[str],
                 location_arn: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 access_based_enumeration: Optional[pulumi.Input[bool]] = None,
                 admin_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_destination_arn: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[str]] = None,
                 bucket_region: Optional[pulumi.Input[str]] = None,
                 cache_attributes: Optional[pulumi.Input['SmbFileShareCacheAttributesArgs']] = None,
                 case_sensitivity: Optional[pulumi.Input[str]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 file_share_name: Optional[pulumi.Input[str]] = None,
                 guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
                 invalid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 notification_policy: Optional[pulumi.Input[str]] = None,
                 object_acl: Optional[pulumi.Input[str]] = None,
                 oplocks_enabled: Optional[pulumi.Input[bool]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 requester_pays: Optional[pulumi.Input[bool]] = None,
                 smb_acl_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 valid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_endpoint_dns_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SmbFileShare resource.
        :param pulumi.Input[str] gateway_arn: Amazon Resource Name (ARN) of the file gateway.
        :param pulumi.Input[str] location_arn: The ARN of the backed storage used for storing file data.
        :param pulumi.Input[str] role_arn: The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        :param pulumi.Input[bool] access_based_enumeration: The files and folders on this share will only be visible to users with read access. Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_user_lists: A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[str] audit_destination_arn: The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
        :param pulumi.Input[str] authentication: The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
        :param pulumi.Input[str] bucket_region: The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
        :param pulumi.Input['SmbFileShareCacheAttributesArgs'] cache_attributes: Refresh cache information. see Cache Attributes for more details.
        :param pulumi.Input[str] case_sensitivity: The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
        :param pulumi.Input[str] default_storage_class: The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        :param pulumi.Input[str] file_share_name: The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        :param pulumi.Input[bool] guess_mime_type_enabled: Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] invalid_user_lists: A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[bool] kms_encrypted: Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        :param pulumi.Input[str] notification_policy: The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        :param pulumi.Input[str] object_acl: Access Control List permission for S3 objects. Defaults to `private`.
        :param pulumi.Input[bool] oplocks_enabled: Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
        :param pulumi.Input[bool] read_only: Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        :param pulumi.Input[bool] requester_pays: Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        :param pulumi.Input[bool] smb_acl_enabled: Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] valid_user_lists: A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[str] vpc_endpoint_dns_name: The DNS name of the VPC endpoint for S3 private link.
        """
        pulumi.set(__self__, "gateway_arn", gateway_arn)
        pulumi.set(__self__, "location_arn", location_arn)
        pulumi.set(__self__, "role_arn", role_arn)
        if access_based_enumeration is not None:
            pulumi.set(__self__, "access_based_enumeration", access_based_enumeration)
        if admin_user_lists is not None:
            pulumi.set(__self__, "admin_user_lists", admin_user_lists)
        if audit_destination_arn is not None:
            pulumi.set(__self__, "audit_destination_arn", audit_destination_arn)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if bucket_region is not None:
            pulumi.set(__self__, "bucket_region", bucket_region)
        if cache_attributes is not None:
            pulumi.set(__self__, "cache_attributes", cache_attributes)
        if case_sensitivity is not None:
            pulumi.set(__self__, "case_sensitivity", case_sensitivity)
        if default_storage_class is not None:
            pulumi.set(__self__, "default_storage_class", default_storage_class)
        if file_share_name is not None:
            pulumi.set(__self__, "file_share_name", file_share_name)
        if guess_mime_type_enabled is not None:
            pulumi.set(__self__, "guess_mime_type_enabled", guess_mime_type_enabled)
        if invalid_user_lists is not None:
            pulumi.set(__self__, "invalid_user_lists", invalid_user_lists)
        if kms_encrypted is not None:
            pulumi.set(__self__, "kms_encrypted", kms_encrypted)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if notification_policy is not None:
            pulumi.set(__self__, "notification_policy", notification_policy)
        if object_acl is not None:
            pulumi.set(__self__, "object_acl", object_acl)
        if oplocks_enabled is not None:
            pulumi.set(__self__, "oplocks_enabled", oplocks_enabled)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if requester_pays is not None:
            pulumi.set(__self__, "requester_pays", requester_pays)
        if smb_acl_enabled is not None:
            pulumi.set(__self__, "smb_acl_enabled", smb_acl_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if valid_user_lists is not None:
            pulumi.set(__self__, "valid_user_lists", valid_user_lists)
        if vpc_endpoint_dns_name is not None:
            pulumi.set(__self__, "vpc_endpoint_dns_name", vpc_endpoint_dns_name)

    @property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name (ARN) of the file gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @gateway_arn.setter
    def gateway_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_arn", value)

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the backed storage used for storing file data.
        """
        return pulumi.get(self, "location_arn")

    @location_arn.setter
    def location_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "location_arn", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="accessBasedEnumeration")
    def access_based_enumeration(self) -> Optional[pulumi.Input[bool]]:
        """
        The files and folders on this share will only be visible to users with read access. Default value is `false`.
        """
        return pulumi.get(self, "access_based_enumeration")

    @access_based_enumeration.setter
    def access_based_enumeration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "access_based_enumeration", value)

    @property
    @pulumi.getter(name="adminUserLists")
    def admin_user_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        """
        return pulumi.get(self, "admin_user_lists")

    @admin_user_lists.setter
    def admin_user_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admin_user_lists", value)

    @property
    @pulumi.getter(name="auditDestinationArn")
    def audit_destination_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
        """
        return pulumi.get(self, "audit_destination_arn")

    @audit_destination_arn.setter
    def audit_destination_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_destination_arn", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[str]]:
        """
        The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_region", value)

    @property
    @pulumi.getter(name="cacheAttributes")
    def cache_attributes(self) -> Optional[pulumi.Input['SmbFileShareCacheAttributesArgs']]:
        """
        Refresh cache information. see Cache Attributes for more details.
        """
        return pulumi.get(self, "cache_attributes")

    @cache_attributes.setter
    def cache_attributes(self, value: Optional[pulumi.Input['SmbFileShareCacheAttributesArgs']]):
        pulumi.set(self, "cache_attributes", value)

    @property
    @pulumi.getter(name="caseSensitivity")
    def case_sensitivity(self) -> Optional[pulumi.Input[str]]:
        """
        The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
        """
        return pulumi.get(self, "case_sensitivity")

    @case_sensitivity.setter
    def case_sensitivity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "case_sensitivity", value)

    @property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        """
        return pulumi.get(self, "default_storage_class")

    @default_storage_class.setter
    def default_storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_storage_class", value)

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        """
        return pulumi.get(self, "file_share_name")

    @file_share_name.setter
    def file_share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_name", value)

    @property
    @pulumi.getter(name="guessMimeTypeEnabled")
    def guess_mime_type_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        """
        return pulumi.get(self, "guess_mime_type_enabled")

    @guess_mime_type_enabled.setter
    def guess_mime_type_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "guess_mime_type_enabled", value)

    @property
    @pulumi.getter(name="invalidUserLists")
    def invalid_user_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        """
        return pulumi.get(self, "invalid_user_lists")

    @invalid_user_lists.setter
    def invalid_user_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "invalid_user_lists", value)

    @property
    @pulumi.getter(name="kmsEncrypted")
    def kms_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        """
        return pulumi.get(self, "kms_encrypted")

    @kms_encrypted.setter
    def kms_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kms_encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="notificationPolicy")
    def notification_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        """
        return pulumi.get(self, "notification_policy")

    @notification_policy.setter
    def notification_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_policy", value)

    @property
    @pulumi.getter(name="objectAcl")
    def object_acl(self) -> Optional[pulumi.Input[str]]:
        """
        Access Control List permission for S3 objects. Defaults to `private`.
        """
        return pulumi.get(self, "object_acl")

    @object_acl.setter
    def object_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_acl", value)

    @property
    @pulumi.getter(name="oplocksEnabled")
    def oplocks_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
        """
        return pulumi.get(self, "oplocks_enabled")

    @oplocks_enabled.setter
    def oplocks_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "oplocks_enabled", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        """
        return pulumi.get(self, "requester_pays")

    @requester_pays.setter
    def requester_pays(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requester_pays", value)

    @property
    @pulumi.getter(name="smbAclEnabled")
    def smb_acl_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
        """
        return pulumi.get(self, "smb_acl_enabled")

    @smb_acl_enabled.setter
    def smb_acl_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "smb_acl_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="validUserLists")
    def valid_user_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
        """
        return pulumi.get(self, "valid_user_lists")

    @valid_user_lists.setter
    def valid_user_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "valid_user_lists", value)

    @property
    @pulumi.getter(name="vpcEndpointDnsName")
    def vpc_endpoint_dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name of the VPC endpoint for S3 private link.
        """
        return pulumi.get(self, "vpc_endpoint_dns_name")

    @vpc_endpoint_dns_name.setter
    def vpc_endpoint_dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_endpoint_dns_name", value)


@pulumi.input_type
class _SmbFileShareState:
    def __init__(__self__, *,
                 access_based_enumeration: Optional[pulumi.Input[bool]] = None,
                 admin_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 audit_destination_arn: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[str]] = None,
                 bucket_region: Optional[pulumi.Input[str]] = None,
                 cache_attributes: Optional[pulumi.Input['SmbFileShareCacheAttributesArgs']] = None,
                 case_sensitivity: Optional[pulumi.Input[str]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 file_share_name: Optional[pulumi.Input[str]] = None,
                 fileshare_id: Optional[pulumi.Input[str]] = None,
                 gateway_arn: Optional[pulumi.Input[str]] = None,
                 guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
                 invalid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 location_arn: Optional[pulumi.Input[str]] = None,
                 notification_policy: Optional[pulumi.Input[str]] = None,
                 object_acl: Optional[pulumi.Input[str]] = None,
                 oplocks_enabled: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 requester_pays: Optional[pulumi.Input[bool]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 smb_acl_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 valid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_endpoint_dns_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SmbFileShare resources.
        :param pulumi.Input[bool] access_based_enumeration: The files and folders on this share will only be visible to users with read access. Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_user_lists: A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the SMB File Share.
        :param pulumi.Input[str] audit_destination_arn: The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
        :param pulumi.Input[str] authentication: The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
        :param pulumi.Input[str] bucket_region: The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
        :param pulumi.Input['SmbFileShareCacheAttributesArgs'] cache_attributes: Refresh cache information. see Cache Attributes for more details.
        :param pulumi.Input[str] case_sensitivity: The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
        :param pulumi.Input[str] default_storage_class: The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        :param pulumi.Input[str] file_share_name: The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        :param pulumi.Input[str] fileshare_id: ID of the SMB File Share.
        :param pulumi.Input[str] gateway_arn: Amazon Resource Name (ARN) of the file gateway.
        :param pulumi.Input[bool] guess_mime_type_enabled: Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] invalid_user_lists: A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[bool] kms_encrypted: Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        :param pulumi.Input[str] location_arn: The ARN of the backed storage used for storing file data.
        :param pulumi.Input[str] notification_policy: The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        :param pulumi.Input[str] object_acl: Access Control List permission for S3 objects. Defaults to `private`.
        :param pulumi.Input[bool] oplocks_enabled: Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
        :param pulumi.Input[str] path: File share path used by the NFS client to identify the mount point.
        :param pulumi.Input[bool] read_only: Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        :param pulumi.Input[bool] requester_pays: Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        :param pulumi.Input[str] role_arn: The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        :param pulumi.Input[bool] smb_acl_enabled: Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] valid_user_lists: A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[str] vpc_endpoint_dns_name: The DNS name of the VPC endpoint for S3 private link.
        """
        if access_based_enumeration is not None:
            pulumi.set(__self__, "access_based_enumeration", access_based_enumeration)
        if admin_user_lists is not None:
            pulumi.set(__self__, "admin_user_lists", admin_user_lists)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if audit_destination_arn is not None:
            pulumi.set(__self__, "audit_destination_arn", audit_destination_arn)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if bucket_region is not None:
            pulumi.set(__self__, "bucket_region", bucket_region)
        if cache_attributes is not None:
            pulumi.set(__self__, "cache_attributes", cache_attributes)
        if case_sensitivity is not None:
            pulumi.set(__self__, "case_sensitivity", case_sensitivity)
        if default_storage_class is not None:
            pulumi.set(__self__, "default_storage_class", default_storage_class)
        if file_share_name is not None:
            pulumi.set(__self__, "file_share_name", file_share_name)
        if fileshare_id is not None:
            pulumi.set(__self__, "fileshare_id", fileshare_id)
        if gateway_arn is not None:
            pulumi.set(__self__, "gateway_arn", gateway_arn)
        if guess_mime_type_enabled is not None:
            pulumi.set(__self__, "guess_mime_type_enabled", guess_mime_type_enabled)
        if invalid_user_lists is not None:
            pulumi.set(__self__, "invalid_user_lists", invalid_user_lists)
        if kms_encrypted is not None:
            pulumi.set(__self__, "kms_encrypted", kms_encrypted)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if location_arn is not None:
            pulumi.set(__self__, "location_arn", location_arn)
        if notification_policy is not None:
            pulumi.set(__self__, "notification_policy", notification_policy)
        if object_acl is not None:
            pulumi.set(__self__, "object_acl", object_acl)
        if oplocks_enabled is not None:
            pulumi.set(__self__, "oplocks_enabled", oplocks_enabled)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if requester_pays is not None:
            pulumi.set(__self__, "requester_pays", requester_pays)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if smb_acl_enabled is not None:
            pulumi.set(__self__, "smb_acl_enabled", smb_acl_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if valid_user_lists is not None:
            pulumi.set(__self__, "valid_user_lists", valid_user_lists)
        if vpc_endpoint_dns_name is not None:
            pulumi.set(__self__, "vpc_endpoint_dns_name", vpc_endpoint_dns_name)

    @property
    @pulumi.getter(name="accessBasedEnumeration")
    def access_based_enumeration(self) -> Optional[pulumi.Input[bool]]:
        """
        The files and folders on this share will only be visible to users with read access. Default value is `false`.
        """
        return pulumi.get(self, "access_based_enumeration")

    @access_based_enumeration.setter
    def access_based_enumeration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "access_based_enumeration", value)

    @property
    @pulumi.getter(name="adminUserLists")
    def admin_user_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        """
        return pulumi.get(self, "admin_user_lists")

    @admin_user_lists.setter
    def admin_user_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admin_user_lists", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the SMB File Share.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="auditDestinationArn")
    def audit_destination_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
        """
        return pulumi.get(self, "audit_destination_arn")

    @audit_destination_arn.setter
    def audit_destination_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_destination_arn", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[str]]:
        """
        The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_region", value)

    @property
    @pulumi.getter(name="cacheAttributes")
    def cache_attributes(self) -> Optional[pulumi.Input['SmbFileShareCacheAttributesArgs']]:
        """
        Refresh cache information. see Cache Attributes for more details.
        """
        return pulumi.get(self, "cache_attributes")

    @cache_attributes.setter
    def cache_attributes(self, value: Optional[pulumi.Input['SmbFileShareCacheAttributesArgs']]):
        pulumi.set(self, "cache_attributes", value)

    @property
    @pulumi.getter(name="caseSensitivity")
    def case_sensitivity(self) -> Optional[pulumi.Input[str]]:
        """
        The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
        """
        return pulumi.get(self, "case_sensitivity")

    @case_sensitivity.setter
    def case_sensitivity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "case_sensitivity", value)

    @property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        """
        return pulumi.get(self, "default_storage_class")

    @default_storage_class.setter
    def default_storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_storage_class", value)

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        """
        return pulumi.get(self, "file_share_name")

    @file_share_name.setter
    def file_share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_name", value)

    @property
    @pulumi.getter(name="fileshareId")
    def fileshare_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the SMB File Share.
        """
        return pulumi.get(self, "fileshare_id")

    @fileshare_id.setter
    def fileshare_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fileshare_id", value)

    @property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the file gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @gateway_arn.setter
    def gateway_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_arn", value)

    @property
    @pulumi.getter(name="guessMimeTypeEnabled")
    def guess_mime_type_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        """
        return pulumi.get(self, "guess_mime_type_enabled")

    @guess_mime_type_enabled.setter
    def guess_mime_type_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "guess_mime_type_enabled", value)

    @property
    @pulumi.getter(name="invalidUserLists")
    def invalid_user_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        """
        return pulumi.get(self, "invalid_user_lists")

    @invalid_user_lists.setter
    def invalid_user_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "invalid_user_lists", value)

    @property
    @pulumi.getter(name="kmsEncrypted")
    def kms_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        """
        return pulumi.get(self, "kms_encrypted")

    @kms_encrypted.setter
    def kms_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kms_encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the backed storage used for storing file data.
        """
        return pulumi.get(self, "location_arn")

    @location_arn.setter
    def location_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_arn", value)

    @property
    @pulumi.getter(name="notificationPolicy")
    def notification_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        """
        return pulumi.get(self, "notification_policy")

    @notification_policy.setter
    def notification_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_policy", value)

    @property
    @pulumi.getter(name="objectAcl")
    def object_acl(self) -> Optional[pulumi.Input[str]]:
        """
        Access Control List permission for S3 objects. Defaults to `private`.
        """
        return pulumi.get(self, "object_acl")

    @object_acl.setter
    def object_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_acl", value)

    @property
    @pulumi.getter(name="oplocksEnabled")
    def oplocks_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
        """
        return pulumi.get(self, "oplocks_enabled")

    @oplocks_enabled.setter
    def oplocks_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "oplocks_enabled", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        File share path used by the NFS client to identify the mount point.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        """
        return pulumi.get(self, "requester_pays")

    @requester_pays.setter
    def requester_pays(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requester_pays", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="smbAclEnabled")
    def smb_acl_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
        """
        return pulumi.get(self, "smb_acl_enabled")

    @smb_acl_enabled.setter
    def smb_acl_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "smb_acl_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="validUserLists")
    def valid_user_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
        """
        return pulumi.get(self, "valid_user_lists")

    @valid_user_lists.setter
    def valid_user_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "valid_user_lists", value)

    @property
    @pulumi.getter(name="vpcEndpointDnsName")
    def vpc_endpoint_dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name of the VPC endpoint for S3 private link.
        """
        return pulumi.get(self, "vpc_endpoint_dns_name")

    @vpc_endpoint_dns_name.setter
    def vpc_endpoint_dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_endpoint_dns_name", value)


class SmbFileShare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_based_enumeration: Optional[pulumi.Input[bool]] = None,
                 admin_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_destination_arn: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[str]] = None,
                 bucket_region: Optional[pulumi.Input[str]] = None,
                 cache_attributes: Optional[pulumi.Input[pulumi.InputType['SmbFileShareCacheAttributesArgs']]] = None,
                 case_sensitivity: Optional[pulumi.Input[str]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 file_share_name: Optional[pulumi.Input[str]] = None,
                 gateway_arn: Optional[pulumi.Input[str]] = None,
                 guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
                 invalid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 location_arn: Optional[pulumi.Input[str]] = None,
                 notification_policy: Optional[pulumi.Input[str]] = None,
                 object_acl: Optional[pulumi.Input[str]] = None,
                 oplocks_enabled: Optional[pulumi.Input[bool]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 requester_pays: Optional[pulumi.Input[bool]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 smb_acl_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 valid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_endpoint_dns_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an AWS Storage Gateway SMB File Share.

        ## Example Usage
        ### Active Directory Authentication

        > **NOTE:** The gateway must have already joined the Active Directory domain prior to SMB file share creation. e.g. via "SMB Settings" in the AWS Storage Gateway console or `smb_active_directory_settings` in the `storagegateway.Gateway` resource.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.SmbFileShare("example",
            authentication="ActiveDirectory",
            gateway_arn=aws_storagegateway_gateway["example"]["arn"],
            location_arn=aws_s3_bucket["example"]["arn"],
            role_arn=aws_iam_role["example"]["arn"])
        ```
        ### Guest Authentication

        > **NOTE:** The gateway must have already had the SMB guest password set prior to SMB file share creation. e.g. via "SMB Settings" in the AWS Storage Gateway console or `smb_guest_password` in the `storagegateway.Gateway` resource.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.SmbFileShare("example",
            authentication="GuestAccess",
            gateway_arn=aws_storagegateway_gateway["example"]["arn"],
            location_arn=aws_s3_bucket["example"]["arn"],
            role_arn=aws_iam_role["example"]["arn"])
        ```

        ## Import

        `aws_storagegateway_smb_file_share` can be imported by using the SMB File Share Amazon Resource Name (ARN), e.g.,

        ```sh
         $ pulumi import aws:storagegateway/smbFileShare:SmbFileShare example arn:aws:storagegateway:us-east-1:123456789012:share/share-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] access_based_enumeration: The files and folders on this share will only be visible to users with read access. Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_user_lists: A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[str] audit_destination_arn: The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
        :param pulumi.Input[str] authentication: The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
        :param pulumi.Input[str] bucket_region: The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
        :param pulumi.Input[pulumi.InputType['SmbFileShareCacheAttributesArgs']] cache_attributes: Refresh cache information. see Cache Attributes for more details.
        :param pulumi.Input[str] case_sensitivity: The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
        :param pulumi.Input[str] default_storage_class: The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        :param pulumi.Input[str] file_share_name: The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        :param pulumi.Input[str] gateway_arn: Amazon Resource Name (ARN) of the file gateway.
        :param pulumi.Input[bool] guess_mime_type_enabled: Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] invalid_user_lists: A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[bool] kms_encrypted: Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        :param pulumi.Input[str] location_arn: The ARN of the backed storage used for storing file data.
        :param pulumi.Input[str] notification_policy: The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        :param pulumi.Input[str] object_acl: Access Control List permission for S3 objects. Defaults to `private`.
        :param pulumi.Input[bool] oplocks_enabled: Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
        :param pulumi.Input[bool] read_only: Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        :param pulumi.Input[bool] requester_pays: Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        :param pulumi.Input[str] role_arn: The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        :param pulumi.Input[bool] smb_acl_enabled: Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] valid_user_lists: A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[str] vpc_endpoint_dns_name: The DNS name of the VPC endpoint for S3 private link.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SmbFileShareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Storage Gateway SMB File Share.

        ## Example Usage
        ### Active Directory Authentication

        > **NOTE:** The gateway must have already joined the Active Directory domain prior to SMB file share creation. e.g. via "SMB Settings" in the AWS Storage Gateway console or `smb_active_directory_settings` in the `storagegateway.Gateway` resource.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.SmbFileShare("example",
            authentication="ActiveDirectory",
            gateway_arn=aws_storagegateway_gateway["example"]["arn"],
            location_arn=aws_s3_bucket["example"]["arn"],
            role_arn=aws_iam_role["example"]["arn"])
        ```
        ### Guest Authentication

        > **NOTE:** The gateway must have already had the SMB guest password set prior to SMB file share creation. e.g. via "SMB Settings" in the AWS Storage Gateway console or `smb_guest_password` in the `storagegateway.Gateway` resource.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.SmbFileShare("example",
            authentication="GuestAccess",
            gateway_arn=aws_storagegateway_gateway["example"]["arn"],
            location_arn=aws_s3_bucket["example"]["arn"],
            role_arn=aws_iam_role["example"]["arn"])
        ```

        ## Import

        `aws_storagegateway_smb_file_share` can be imported by using the SMB File Share Amazon Resource Name (ARN), e.g.,

        ```sh
         $ pulumi import aws:storagegateway/smbFileShare:SmbFileShare example arn:aws:storagegateway:us-east-1:123456789012:share/share-12345678
        ```

        :param str resource_name: The name of the resource.
        :param SmbFileShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SmbFileShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_based_enumeration: Optional[pulumi.Input[bool]] = None,
                 admin_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_destination_arn: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[str]] = None,
                 bucket_region: Optional[pulumi.Input[str]] = None,
                 cache_attributes: Optional[pulumi.Input[pulumi.InputType['SmbFileShareCacheAttributesArgs']]] = None,
                 case_sensitivity: Optional[pulumi.Input[str]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 file_share_name: Optional[pulumi.Input[str]] = None,
                 gateway_arn: Optional[pulumi.Input[str]] = None,
                 guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
                 invalid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 location_arn: Optional[pulumi.Input[str]] = None,
                 notification_policy: Optional[pulumi.Input[str]] = None,
                 object_acl: Optional[pulumi.Input[str]] = None,
                 oplocks_enabled: Optional[pulumi.Input[bool]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 requester_pays: Optional[pulumi.Input[bool]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 smb_acl_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 valid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_endpoint_dns_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SmbFileShareArgs.__new__(SmbFileShareArgs)

            __props__.__dict__["access_based_enumeration"] = access_based_enumeration
            __props__.__dict__["admin_user_lists"] = admin_user_lists
            __props__.__dict__["audit_destination_arn"] = audit_destination_arn
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["bucket_region"] = bucket_region
            __props__.__dict__["cache_attributes"] = cache_attributes
            __props__.__dict__["case_sensitivity"] = case_sensitivity
            __props__.__dict__["default_storage_class"] = default_storage_class
            __props__.__dict__["file_share_name"] = file_share_name
            if gateway_arn is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_arn'")
            __props__.__dict__["gateway_arn"] = gateway_arn
            __props__.__dict__["guess_mime_type_enabled"] = guess_mime_type_enabled
            __props__.__dict__["invalid_user_lists"] = invalid_user_lists
            __props__.__dict__["kms_encrypted"] = kms_encrypted
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            if location_arn is None and not opts.urn:
                raise TypeError("Missing required property 'location_arn'")
            __props__.__dict__["location_arn"] = location_arn
            __props__.__dict__["notification_policy"] = notification_policy
            __props__.__dict__["object_acl"] = object_acl
            __props__.__dict__["oplocks_enabled"] = oplocks_enabled
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["requester_pays"] = requester_pays
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["smb_acl_enabled"] = smb_acl_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["valid_user_lists"] = valid_user_lists
            __props__.__dict__["vpc_endpoint_dns_name"] = vpc_endpoint_dns_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["fileshare_id"] = None
            __props__.__dict__["path"] = None
            __props__.__dict__["tags_all"] = None
        super(SmbFileShare, __self__).__init__(
            'aws:storagegateway/smbFileShare:SmbFileShare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_based_enumeration: Optional[pulumi.Input[bool]] = None,
            admin_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            audit_destination_arn: Optional[pulumi.Input[str]] = None,
            authentication: Optional[pulumi.Input[str]] = None,
            bucket_region: Optional[pulumi.Input[str]] = None,
            cache_attributes: Optional[pulumi.Input[pulumi.InputType['SmbFileShareCacheAttributesArgs']]] = None,
            case_sensitivity: Optional[pulumi.Input[str]] = None,
            default_storage_class: Optional[pulumi.Input[str]] = None,
            file_share_name: Optional[pulumi.Input[str]] = None,
            fileshare_id: Optional[pulumi.Input[str]] = None,
            gateway_arn: Optional[pulumi.Input[str]] = None,
            guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
            invalid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            kms_encrypted: Optional[pulumi.Input[bool]] = None,
            kms_key_arn: Optional[pulumi.Input[str]] = None,
            location_arn: Optional[pulumi.Input[str]] = None,
            notification_policy: Optional[pulumi.Input[str]] = None,
            object_acl: Optional[pulumi.Input[str]] = None,
            oplocks_enabled: Optional[pulumi.Input[bool]] = None,
            path: Optional[pulumi.Input[str]] = None,
            read_only: Optional[pulumi.Input[bool]] = None,
            requester_pays: Optional[pulumi.Input[bool]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            smb_acl_enabled: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            valid_user_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vpc_endpoint_dns_name: Optional[pulumi.Input[str]] = None) -> 'SmbFileShare':
        """
        Get an existing SmbFileShare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] access_based_enumeration: The files and folders on this share will only be visible to users with read access. Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_user_lists: A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the SMB File Share.
        :param pulumi.Input[str] audit_destination_arn: The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
        :param pulumi.Input[str] authentication: The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
        :param pulumi.Input[str] bucket_region: The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
        :param pulumi.Input[pulumi.InputType['SmbFileShareCacheAttributesArgs']] cache_attributes: Refresh cache information. see Cache Attributes for more details.
        :param pulumi.Input[str] case_sensitivity: The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
        :param pulumi.Input[str] default_storage_class: The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        :param pulumi.Input[str] file_share_name: The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        :param pulumi.Input[str] fileshare_id: ID of the SMB File Share.
        :param pulumi.Input[str] gateway_arn: Amazon Resource Name (ARN) of the file gateway.
        :param pulumi.Input[bool] guess_mime_type_enabled: Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] invalid_user_lists: A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[bool] kms_encrypted: Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        :param pulumi.Input[str] location_arn: The ARN of the backed storage used for storing file data.
        :param pulumi.Input[str] notification_policy: The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        :param pulumi.Input[str] object_acl: Access Control List permission for S3 objects. Defaults to `private`.
        :param pulumi.Input[bool] oplocks_enabled: Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
        :param pulumi.Input[str] path: File share path used by the NFS client to identify the mount point.
        :param pulumi.Input[bool] read_only: Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        :param pulumi.Input[bool] requester_pays: Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        :param pulumi.Input[str] role_arn: The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        :param pulumi.Input[bool] smb_acl_enabled: Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] valid_user_lists: A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
        :param pulumi.Input[str] vpc_endpoint_dns_name: The DNS name of the VPC endpoint for S3 private link.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SmbFileShareState.__new__(_SmbFileShareState)

        __props__.__dict__["access_based_enumeration"] = access_based_enumeration
        __props__.__dict__["admin_user_lists"] = admin_user_lists
        __props__.__dict__["arn"] = arn
        __props__.__dict__["audit_destination_arn"] = audit_destination_arn
        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["bucket_region"] = bucket_region
        __props__.__dict__["cache_attributes"] = cache_attributes
        __props__.__dict__["case_sensitivity"] = case_sensitivity
        __props__.__dict__["default_storage_class"] = default_storage_class
        __props__.__dict__["file_share_name"] = file_share_name
        __props__.__dict__["fileshare_id"] = fileshare_id
        __props__.__dict__["gateway_arn"] = gateway_arn
        __props__.__dict__["guess_mime_type_enabled"] = guess_mime_type_enabled
        __props__.__dict__["invalid_user_lists"] = invalid_user_lists
        __props__.__dict__["kms_encrypted"] = kms_encrypted
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["location_arn"] = location_arn
        __props__.__dict__["notification_policy"] = notification_policy
        __props__.__dict__["object_acl"] = object_acl
        __props__.__dict__["oplocks_enabled"] = oplocks_enabled
        __props__.__dict__["path"] = path
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["requester_pays"] = requester_pays
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["smb_acl_enabled"] = smb_acl_enabled
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["valid_user_lists"] = valid_user_lists
        __props__.__dict__["vpc_endpoint_dns_name"] = vpc_endpoint_dns_name
        return SmbFileShare(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessBasedEnumeration")
    def access_based_enumeration(self) -> pulumi.Output[Optional[bool]]:
        """
        The files and folders on this share will only be visible to users with read access. Default value is `false`.
        """
        return pulumi.get(self, "access_based_enumeration")

    @property
    @pulumi.getter(name="adminUserLists")
    def admin_user_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        """
        return pulumi.get(self, "admin_user_lists")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the SMB File Share.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="auditDestinationArn")
    def audit_destination_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
        """
        return pulumi.get(self, "audit_destination_arn")

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output[Optional[str]]:
        """
        The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> pulumi.Output[Optional[str]]:
        """
        The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
        """
        return pulumi.get(self, "bucket_region")

    @property
    @pulumi.getter(name="cacheAttributes")
    def cache_attributes(self) -> pulumi.Output[Optional['outputs.SmbFileShareCacheAttributes']]:
        """
        Refresh cache information. see Cache Attributes for more details.
        """
        return pulumi.get(self, "cache_attributes")

    @property
    @pulumi.getter(name="caseSensitivity")
    def case_sensitivity(self) -> pulumi.Output[Optional[str]]:
        """
        The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
        """
        return pulumi.get(self, "case_sensitivity")

    @property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> pulumi.Output[Optional[str]]:
        """
        The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        """
        return pulumi.get(self, "default_storage_class")

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> pulumi.Output[str]:
        """
        The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        """
        return pulumi.get(self, "file_share_name")

    @property
    @pulumi.getter(name="fileshareId")
    def fileshare_id(self) -> pulumi.Output[str]:
        """
        ID of the SMB File Share.
        """
        return pulumi.get(self, "fileshare_id")

    @property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the file gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @property
    @pulumi.getter(name="guessMimeTypeEnabled")
    def guess_mime_type_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        """
        return pulumi.get(self, "guess_mime_type_enabled")

    @property
    @pulumi.getter(name="invalidUserLists")
    def invalid_user_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
        """
        return pulumi.get(self, "invalid_user_lists")

    @property
    @pulumi.getter(name="kmsEncrypted")
    def kms_encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        """
        return pulumi.get(self, "kms_encrypted")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the backed storage used for storing file data.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="notificationPolicy")
    def notification_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        """
        return pulumi.get(self, "notification_policy")

    @property
    @pulumi.getter(name="objectAcl")
    def object_acl(self) -> pulumi.Output[Optional[str]]:
        """
        Access Control List permission for S3 objects. Defaults to `private`.
        """
        return pulumi.get(self, "object_acl")

    @property
    @pulumi.getter(name="oplocksEnabled")
    def oplocks_enabled(self) -> pulumi.Output[bool]:
        """
        Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
        """
        return pulumi.get(self, "oplocks_enabled")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        File share path used by the NFS client to identify the mount point.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        """
        return pulumi.get(self, "requester_pays")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="smbAclEnabled")
    def smb_acl_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
        """
        return pulumi.get(self, "smb_acl_enabled")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="validUserLists")
    def valid_user_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
        """
        return pulumi.get(self, "valid_user_lists")

    @property
    @pulumi.getter(name="vpcEndpointDnsName")
    def vpc_endpoint_dns_name(self) -> pulumi.Output[Optional[str]]:
        """
        The DNS name of the VPC endpoint for S3 private link.
        """
        return pulumi.get(self, "vpc_endpoint_dns_name")

