# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NfsFileShareArgs', 'NfsFileShare']

@pulumi.input_type
class NfsFileShareArgs:
    def __init__(__self__, *,
                 client_lists: pulumi.Input[Sequence[pulumi.Input[str]]],
                 gateway_arn: pulumi.Input[str],
                 location_arn: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 audit_destination_arn: Optional[pulumi.Input[str]] = None,
                 cache_attributes: Optional[pulumi.Input['NfsFileShareCacheAttributesArgs']] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 file_share_name: Optional[pulumi.Input[str]] = None,
                 guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
                 kms_encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 nfs_file_share_defaults: Optional[pulumi.Input['NfsFileShareNfsFileShareDefaultsArgs']] = None,
                 notification_policy: Optional[pulumi.Input[str]] = None,
                 object_acl: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 requester_pays: Optional[pulumi.Input[bool]] = None,
                 squash: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a NfsFileShare resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_lists: The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0.0.0.0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
        :param pulumi.Input[str] gateway_arn: Amazon Resource Name (ARN) of the file gateway.
        :param pulumi.Input[str] location_arn: The ARN of the backed storage used for storing file data.
        :param pulumi.Input[str] role_arn: The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        :param pulumi.Input[str] audit_destination_arn: The Amazon Resource Name (ARN) of the storage used for audit logs.
        :param pulumi.Input['NfsFileShareCacheAttributesArgs'] cache_attributes: Refresh cache information. see Cache Attributes for more details.
        :param pulumi.Input[str] default_storage_class: The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        :param pulumi.Input[str] file_share_name: The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        :param pulumi.Input[bool] guess_mime_type_enabled: Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        :param pulumi.Input[bool] kms_encrypted: Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        :param pulumi.Input['NfsFileShareNfsFileShareDefaultsArgs'] nfs_file_share_defaults: Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
        :param pulumi.Input[str] notification_policy: The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        :param pulumi.Input[str] object_acl: Access Control List permission for S3 objects. Defaults to `private`.
        :param pulumi.Input[bool] read_only: Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        :param pulumi.Input[bool] requester_pays: Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        :param pulumi.Input[str] squash: Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "client_lists", client_lists)
        pulumi.set(__self__, "gateway_arn", gateway_arn)
        pulumi.set(__self__, "location_arn", location_arn)
        pulumi.set(__self__, "role_arn", role_arn)
        if audit_destination_arn is not None:
            pulumi.set(__self__, "audit_destination_arn", audit_destination_arn)
        if cache_attributes is not None:
            pulumi.set(__self__, "cache_attributes", cache_attributes)
        if default_storage_class is not None:
            pulumi.set(__self__, "default_storage_class", default_storage_class)
        if file_share_name is not None:
            pulumi.set(__self__, "file_share_name", file_share_name)
        if guess_mime_type_enabled is not None:
            pulumi.set(__self__, "guess_mime_type_enabled", guess_mime_type_enabled)
        if kms_encrypted is not None:
            pulumi.set(__self__, "kms_encrypted", kms_encrypted)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if nfs_file_share_defaults is not None:
            pulumi.set(__self__, "nfs_file_share_defaults", nfs_file_share_defaults)
        if notification_policy is not None:
            pulumi.set(__self__, "notification_policy", notification_policy)
        if object_acl is not None:
            pulumi.set(__self__, "object_acl", object_acl)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if requester_pays is not None:
            pulumi.set(__self__, "requester_pays", requester_pays)
        if squash is not None:
            pulumi.set(__self__, "squash", squash)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clientLists")
    def client_lists(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0.0.0.0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
        """
        return pulumi.get(self, "client_lists")

    @client_lists.setter
    def client_lists(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "client_lists", value)

    @property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name (ARN) of the file gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @gateway_arn.setter
    def gateway_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_arn", value)

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the backed storage used for storing file data.
        """
        return pulumi.get(self, "location_arn")

    @location_arn.setter
    def location_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "location_arn", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="auditDestinationArn")
    def audit_destination_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the storage used for audit logs.
        """
        return pulumi.get(self, "audit_destination_arn")

    @audit_destination_arn.setter
    def audit_destination_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_destination_arn", value)

    @property
    @pulumi.getter(name="cacheAttributes")
    def cache_attributes(self) -> Optional[pulumi.Input['NfsFileShareCacheAttributesArgs']]:
        """
        Refresh cache information. see Cache Attributes for more details.
        """
        return pulumi.get(self, "cache_attributes")

    @cache_attributes.setter
    def cache_attributes(self, value: Optional[pulumi.Input['NfsFileShareCacheAttributesArgs']]):
        pulumi.set(self, "cache_attributes", value)

    @property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        """
        return pulumi.get(self, "default_storage_class")

    @default_storage_class.setter
    def default_storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_storage_class", value)

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        """
        return pulumi.get(self, "file_share_name")

    @file_share_name.setter
    def file_share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_name", value)

    @property
    @pulumi.getter(name="guessMimeTypeEnabled")
    def guess_mime_type_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        """
        return pulumi.get(self, "guess_mime_type_enabled")

    @guess_mime_type_enabled.setter
    def guess_mime_type_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "guess_mime_type_enabled", value)

    @property
    @pulumi.getter(name="kmsEncrypted")
    def kms_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        """
        return pulumi.get(self, "kms_encrypted")

    @kms_encrypted.setter
    def kms_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kms_encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="nfsFileShareDefaults")
    def nfs_file_share_defaults(self) -> Optional[pulumi.Input['NfsFileShareNfsFileShareDefaultsArgs']]:
        """
        Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
        """
        return pulumi.get(self, "nfs_file_share_defaults")

    @nfs_file_share_defaults.setter
    def nfs_file_share_defaults(self, value: Optional[pulumi.Input['NfsFileShareNfsFileShareDefaultsArgs']]):
        pulumi.set(self, "nfs_file_share_defaults", value)

    @property
    @pulumi.getter(name="notificationPolicy")
    def notification_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        """
        return pulumi.get(self, "notification_policy")

    @notification_policy.setter
    def notification_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_policy", value)

    @property
    @pulumi.getter(name="objectAcl")
    def object_acl(self) -> Optional[pulumi.Input[str]]:
        """
        Access Control List permission for S3 objects. Defaults to `private`.
        """
        return pulumi.get(self, "object_acl")

    @object_acl.setter
    def object_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_acl", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        """
        return pulumi.get(self, "requester_pays")

    @requester_pays.setter
    def requester_pays(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requester_pays", value)

    @property
    @pulumi.getter
    def squash(self) -> Optional[pulumi.Input[str]]:
        """
        Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
        """
        return pulumi.get(self, "squash")

    @squash.setter
    def squash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NfsFileShareState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 audit_destination_arn: Optional[pulumi.Input[str]] = None,
                 cache_attributes: Optional[pulumi.Input['NfsFileShareCacheAttributesArgs']] = None,
                 client_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 file_share_name: Optional[pulumi.Input[str]] = None,
                 fileshare_id: Optional[pulumi.Input[str]] = None,
                 gateway_arn: Optional[pulumi.Input[str]] = None,
                 guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
                 kms_encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 location_arn: Optional[pulumi.Input[str]] = None,
                 nfs_file_share_defaults: Optional[pulumi.Input['NfsFileShareNfsFileShareDefaultsArgs']] = None,
                 notification_policy: Optional[pulumi.Input[str]] = None,
                 object_acl: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 requester_pays: Optional[pulumi.Input[bool]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 squash: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering NfsFileShare resources.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the NFS File Share.
        :param pulumi.Input[str] audit_destination_arn: The Amazon Resource Name (ARN) of the storage used for audit logs.
        :param pulumi.Input['NfsFileShareCacheAttributesArgs'] cache_attributes: Refresh cache information. see Cache Attributes for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_lists: The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0.0.0.0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
        :param pulumi.Input[str] default_storage_class: The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        :param pulumi.Input[str] file_share_name: The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        :param pulumi.Input[str] fileshare_id: ID of the NFS File Share.
        :param pulumi.Input[str] gateway_arn: Amazon Resource Name (ARN) of the file gateway.
        :param pulumi.Input[bool] guess_mime_type_enabled: Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        :param pulumi.Input[bool] kms_encrypted: Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        :param pulumi.Input[str] location_arn: The ARN of the backed storage used for storing file data.
        :param pulumi.Input['NfsFileShareNfsFileShareDefaultsArgs'] nfs_file_share_defaults: Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
        :param pulumi.Input[str] notification_policy: The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        :param pulumi.Input[str] object_acl: Access Control List permission for S3 objects. Defaults to `private`.
        :param pulumi.Input[str] path: File share path used by the NFS client to identify the mount point.
        :param pulumi.Input[bool] read_only: Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        :param pulumi.Input[bool] requester_pays: Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        :param pulumi.Input[str] role_arn: The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        :param pulumi.Input[str] squash: Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if audit_destination_arn is not None:
            pulumi.set(__self__, "audit_destination_arn", audit_destination_arn)
        if cache_attributes is not None:
            pulumi.set(__self__, "cache_attributes", cache_attributes)
        if client_lists is not None:
            pulumi.set(__self__, "client_lists", client_lists)
        if default_storage_class is not None:
            pulumi.set(__self__, "default_storage_class", default_storage_class)
        if file_share_name is not None:
            pulumi.set(__self__, "file_share_name", file_share_name)
        if fileshare_id is not None:
            pulumi.set(__self__, "fileshare_id", fileshare_id)
        if gateway_arn is not None:
            pulumi.set(__self__, "gateway_arn", gateway_arn)
        if guess_mime_type_enabled is not None:
            pulumi.set(__self__, "guess_mime_type_enabled", guess_mime_type_enabled)
        if kms_encrypted is not None:
            pulumi.set(__self__, "kms_encrypted", kms_encrypted)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if location_arn is not None:
            pulumi.set(__self__, "location_arn", location_arn)
        if nfs_file_share_defaults is not None:
            pulumi.set(__self__, "nfs_file_share_defaults", nfs_file_share_defaults)
        if notification_policy is not None:
            pulumi.set(__self__, "notification_policy", notification_policy)
        if object_acl is not None:
            pulumi.set(__self__, "object_acl", object_acl)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if requester_pays is not None:
            pulumi.set(__self__, "requester_pays", requester_pays)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if squash is not None:
            pulumi.set(__self__, "squash", squash)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the NFS File Share.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="auditDestinationArn")
    def audit_destination_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the storage used for audit logs.
        """
        return pulumi.get(self, "audit_destination_arn")

    @audit_destination_arn.setter
    def audit_destination_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_destination_arn", value)

    @property
    @pulumi.getter(name="cacheAttributes")
    def cache_attributes(self) -> Optional[pulumi.Input['NfsFileShareCacheAttributesArgs']]:
        """
        Refresh cache information. see Cache Attributes for more details.
        """
        return pulumi.get(self, "cache_attributes")

    @cache_attributes.setter
    def cache_attributes(self, value: Optional[pulumi.Input['NfsFileShareCacheAttributesArgs']]):
        pulumi.set(self, "cache_attributes", value)

    @property
    @pulumi.getter(name="clientLists")
    def client_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0.0.0.0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
        """
        return pulumi.get(self, "client_lists")

    @client_lists.setter
    def client_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_lists", value)

    @property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        """
        return pulumi.get(self, "default_storage_class")

    @default_storage_class.setter
    def default_storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_storage_class", value)

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        """
        return pulumi.get(self, "file_share_name")

    @file_share_name.setter
    def file_share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_name", value)

    @property
    @pulumi.getter(name="fileshareId")
    def fileshare_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the NFS File Share.
        """
        return pulumi.get(self, "fileshare_id")

    @fileshare_id.setter
    def fileshare_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fileshare_id", value)

    @property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the file gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @gateway_arn.setter
    def gateway_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_arn", value)

    @property
    @pulumi.getter(name="guessMimeTypeEnabled")
    def guess_mime_type_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        """
        return pulumi.get(self, "guess_mime_type_enabled")

    @guess_mime_type_enabled.setter
    def guess_mime_type_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "guess_mime_type_enabled", value)

    @property
    @pulumi.getter(name="kmsEncrypted")
    def kms_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        """
        return pulumi.get(self, "kms_encrypted")

    @kms_encrypted.setter
    def kms_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kms_encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the backed storage used for storing file data.
        """
        return pulumi.get(self, "location_arn")

    @location_arn.setter
    def location_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_arn", value)

    @property
    @pulumi.getter(name="nfsFileShareDefaults")
    def nfs_file_share_defaults(self) -> Optional[pulumi.Input['NfsFileShareNfsFileShareDefaultsArgs']]:
        """
        Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
        """
        return pulumi.get(self, "nfs_file_share_defaults")

    @nfs_file_share_defaults.setter
    def nfs_file_share_defaults(self, value: Optional[pulumi.Input['NfsFileShareNfsFileShareDefaultsArgs']]):
        pulumi.set(self, "nfs_file_share_defaults", value)

    @property
    @pulumi.getter(name="notificationPolicy")
    def notification_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        """
        return pulumi.get(self, "notification_policy")

    @notification_policy.setter
    def notification_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_policy", value)

    @property
    @pulumi.getter(name="objectAcl")
    def object_acl(self) -> Optional[pulumi.Input[str]]:
        """
        Access Control List permission for S3 objects. Defaults to `private`.
        """
        return pulumi.get(self, "object_acl")

    @object_acl.setter
    def object_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_acl", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        File share path used by the NFS client to identify the mount point.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        """
        return pulumi.get(self, "requester_pays")

    @requester_pays.setter
    def requester_pays(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requester_pays", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def squash(self) -> Optional[pulumi.Input[str]]:
        """
        Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
        """
        return pulumi.get(self, "squash")

    @squash.setter
    def squash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class NfsFileShare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_destination_arn: Optional[pulumi.Input[str]] = None,
                 cache_attributes: Optional[pulumi.Input[pulumi.InputType['NfsFileShareCacheAttributesArgs']]] = None,
                 client_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 file_share_name: Optional[pulumi.Input[str]] = None,
                 gateway_arn: Optional[pulumi.Input[str]] = None,
                 guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
                 kms_encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 location_arn: Optional[pulumi.Input[str]] = None,
                 nfs_file_share_defaults: Optional[pulumi.Input[pulumi.InputType['NfsFileShareNfsFileShareDefaultsArgs']]] = None,
                 notification_policy: Optional[pulumi.Input[str]] = None,
                 object_acl: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 requester_pays: Optional[pulumi.Input[bool]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 squash: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages an AWS Storage Gateway NFS File Share.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.NfsFileShare("example",
            client_lists=["0.0.0.0/0"],
            gateway_arn=aws_storagegateway_gateway["example"]["arn"],
            location_arn=aws_s3_bucket["example"]["arn"],
            role_arn=aws_iam_role["example"]["arn"])
        ```

        ## Import

        `aws_storagegateway_nfs_file_share` can be imported by using the NFS File Share Amazon Resource Name (ARN), e.g.,

        ```sh
         $ pulumi import aws:storagegateway/nfsFileShare:NfsFileShare example arn:aws:storagegateway:us-east-1:123456789012:share/share-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audit_destination_arn: The Amazon Resource Name (ARN) of the storage used for audit logs.
        :param pulumi.Input[pulumi.InputType['NfsFileShareCacheAttributesArgs']] cache_attributes: Refresh cache information. see Cache Attributes for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_lists: The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0.0.0.0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
        :param pulumi.Input[str] default_storage_class: The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        :param pulumi.Input[str] file_share_name: The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        :param pulumi.Input[str] gateway_arn: Amazon Resource Name (ARN) of the file gateway.
        :param pulumi.Input[bool] guess_mime_type_enabled: Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        :param pulumi.Input[bool] kms_encrypted: Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        :param pulumi.Input[str] location_arn: The ARN of the backed storage used for storing file data.
        :param pulumi.Input[pulumi.InputType['NfsFileShareNfsFileShareDefaultsArgs']] nfs_file_share_defaults: Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
        :param pulumi.Input[str] notification_policy: The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        :param pulumi.Input[str] object_acl: Access Control List permission for S3 objects. Defaults to `private`.
        :param pulumi.Input[bool] read_only: Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        :param pulumi.Input[bool] requester_pays: Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        :param pulumi.Input[str] role_arn: The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        :param pulumi.Input[str] squash: Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NfsFileShareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Storage Gateway NFS File Share.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.NfsFileShare("example",
            client_lists=["0.0.0.0/0"],
            gateway_arn=aws_storagegateway_gateway["example"]["arn"],
            location_arn=aws_s3_bucket["example"]["arn"],
            role_arn=aws_iam_role["example"]["arn"])
        ```

        ## Import

        `aws_storagegateway_nfs_file_share` can be imported by using the NFS File Share Amazon Resource Name (ARN), e.g.,

        ```sh
         $ pulumi import aws:storagegateway/nfsFileShare:NfsFileShare example arn:aws:storagegateway:us-east-1:123456789012:share/share-12345678
        ```

        :param str resource_name: The name of the resource.
        :param NfsFileShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NfsFileShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_destination_arn: Optional[pulumi.Input[str]] = None,
                 cache_attributes: Optional[pulumi.Input[pulumi.InputType['NfsFileShareCacheAttributesArgs']]] = None,
                 client_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 file_share_name: Optional[pulumi.Input[str]] = None,
                 gateway_arn: Optional[pulumi.Input[str]] = None,
                 guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
                 kms_encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 location_arn: Optional[pulumi.Input[str]] = None,
                 nfs_file_share_defaults: Optional[pulumi.Input[pulumi.InputType['NfsFileShareNfsFileShareDefaultsArgs']]] = None,
                 notification_policy: Optional[pulumi.Input[str]] = None,
                 object_acl: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 requester_pays: Optional[pulumi.Input[bool]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 squash: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NfsFileShareArgs.__new__(NfsFileShareArgs)

            __props__.__dict__["audit_destination_arn"] = audit_destination_arn
            __props__.__dict__["cache_attributes"] = cache_attributes
            if client_lists is None and not opts.urn:
                raise TypeError("Missing required property 'client_lists'")
            __props__.__dict__["client_lists"] = client_lists
            __props__.__dict__["default_storage_class"] = default_storage_class
            __props__.__dict__["file_share_name"] = file_share_name
            if gateway_arn is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_arn'")
            __props__.__dict__["gateway_arn"] = gateway_arn
            __props__.__dict__["guess_mime_type_enabled"] = guess_mime_type_enabled
            __props__.__dict__["kms_encrypted"] = kms_encrypted
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            if location_arn is None and not opts.urn:
                raise TypeError("Missing required property 'location_arn'")
            __props__.__dict__["location_arn"] = location_arn
            __props__.__dict__["nfs_file_share_defaults"] = nfs_file_share_defaults
            __props__.__dict__["notification_policy"] = notification_policy
            __props__.__dict__["object_acl"] = object_acl
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["requester_pays"] = requester_pays
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["squash"] = squash
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["fileshare_id"] = None
            __props__.__dict__["path"] = None
            __props__.__dict__["tags_all"] = None
        super(NfsFileShare, __self__).__init__(
            'aws:storagegateway/nfsFileShare:NfsFileShare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            audit_destination_arn: Optional[pulumi.Input[str]] = None,
            cache_attributes: Optional[pulumi.Input[pulumi.InputType['NfsFileShareCacheAttributesArgs']]] = None,
            client_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            default_storage_class: Optional[pulumi.Input[str]] = None,
            file_share_name: Optional[pulumi.Input[str]] = None,
            fileshare_id: Optional[pulumi.Input[str]] = None,
            gateway_arn: Optional[pulumi.Input[str]] = None,
            guess_mime_type_enabled: Optional[pulumi.Input[bool]] = None,
            kms_encrypted: Optional[pulumi.Input[bool]] = None,
            kms_key_arn: Optional[pulumi.Input[str]] = None,
            location_arn: Optional[pulumi.Input[str]] = None,
            nfs_file_share_defaults: Optional[pulumi.Input[pulumi.InputType['NfsFileShareNfsFileShareDefaultsArgs']]] = None,
            notification_policy: Optional[pulumi.Input[str]] = None,
            object_acl: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            read_only: Optional[pulumi.Input[bool]] = None,
            requester_pays: Optional[pulumi.Input[bool]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            squash: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'NfsFileShare':
        """
        Get an existing NfsFileShare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the NFS File Share.
        :param pulumi.Input[str] audit_destination_arn: The Amazon Resource Name (ARN) of the storage used for audit logs.
        :param pulumi.Input[pulumi.InputType['NfsFileShareCacheAttributesArgs']] cache_attributes: Refresh cache information. see Cache Attributes for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_lists: The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0.0.0.0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
        :param pulumi.Input[str] default_storage_class: The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        :param pulumi.Input[str] file_share_name: The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        :param pulumi.Input[str] fileshare_id: ID of the NFS File Share.
        :param pulumi.Input[str] gateway_arn: Amazon Resource Name (ARN) of the file gateway.
        :param pulumi.Input[bool] guess_mime_type_enabled: Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        :param pulumi.Input[bool] kms_encrypted: Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        :param pulumi.Input[str] location_arn: The ARN of the backed storage used for storing file data.
        :param pulumi.Input[pulumi.InputType['NfsFileShareNfsFileShareDefaultsArgs']] nfs_file_share_defaults: Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
        :param pulumi.Input[str] notification_policy: The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        :param pulumi.Input[str] object_acl: Access Control List permission for S3 objects. Defaults to `private`.
        :param pulumi.Input[str] path: File share path used by the NFS client to identify the mount point.
        :param pulumi.Input[bool] read_only: Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        :param pulumi.Input[bool] requester_pays: Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        :param pulumi.Input[str] role_arn: The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        :param pulumi.Input[str] squash: Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NfsFileShareState.__new__(_NfsFileShareState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["audit_destination_arn"] = audit_destination_arn
        __props__.__dict__["cache_attributes"] = cache_attributes
        __props__.__dict__["client_lists"] = client_lists
        __props__.__dict__["default_storage_class"] = default_storage_class
        __props__.__dict__["file_share_name"] = file_share_name
        __props__.__dict__["fileshare_id"] = fileshare_id
        __props__.__dict__["gateway_arn"] = gateway_arn
        __props__.__dict__["guess_mime_type_enabled"] = guess_mime_type_enabled
        __props__.__dict__["kms_encrypted"] = kms_encrypted
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["location_arn"] = location_arn
        __props__.__dict__["nfs_file_share_defaults"] = nfs_file_share_defaults
        __props__.__dict__["notification_policy"] = notification_policy
        __props__.__dict__["object_acl"] = object_acl
        __props__.__dict__["path"] = path
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["requester_pays"] = requester_pays
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["squash"] = squash
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return NfsFileShare(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the NFS File Share.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="auditDestinationArn")
    def audit_destination_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the storage used for audit logs.
        """
        return pulumi.get(self, "audit_destination_arn")

    @property
    @pulumi.getter(name="cacheAttributes")
    def cache_attributes(self) -> pulumi.Output[Optional['outputs.NfsFileShareCacheAttributes']]:
        """
        Refresh cache information. see Cache Attributes for more details.
        """
        return pulumi.get(self, "cache_attributes")

    @property
    @pulumi.getter(name="clientLists")
    def client_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0.0.0.0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
        """
        return pulumi.get(self, "client_lists")

    @property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> pulumi.Output[Optional[str]]:
        """
        The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
        """
        return pulumi.get(self, "default_storage_class")

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> pulumi.Output[str]:
        """
        The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
        """
        return pulumi.get(self, "file_share_name")

    @property
    @pulumi.getter(name="fileshareId")
    def fileshare_id(self) -> pulumi.Output[str]:
        """
        ID of the NFS File Share.
        """
        return pulumi.get(self, "fileshare_id")

    @property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the file gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @property
    @pulumi.getter(name="guessMimeTypeEnabled")
    def guess_mime_type_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
        """
        return pulumi.get(self, "guess_mime_type_enabled")

    @property
    @pulumi.getter(name="kmsEncrypted")
    def kms_encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
        """
        return pulumi.get(self, "kms_encrypted")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the backed storage used for storing file data.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="nfsFileShareDefaults")
    def nfs_file_share_defaults(self) -> pulumi.Output[Optional['outputs.NfsFileShareNfsFileShareDefaults']]:
        """
        Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
        """
        return pulumi.get(self, "nfs_file_share_defaults")

    @property
    @pulumi.getter(name="notificationPolicy")
    def notification_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
        """
        return pulumi.get(self, "notification_policy")

    @property
    @pulumi.getter(name="objectAcl")
    def object_acl(self) -> pulumi.Output[Optional[str]]:
        """
        Access Control List permission for S3 objects. Defaults to `private`.
        """
        return pulumi.get(self, "object_acl")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        File share path used by the NFS client to identify the mount point.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
        """
        return pulumi.get(self, "requester_pays")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def squash(self) -> pulumi.Output[Optional[str]]:
        """
        Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
        """
        return pulumi.get(self, "squash")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

