# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['IdentityNotificationTopicArgs', 'IdentityNotificationTopic']

@pulumi.input_type
class IdentityNotificationTopicArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input[str],
                 notification_type: pulumi.Input[str],
                 include_original_headers: Optional[pulumi.Input[bool]] = None,
                 topic_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IdentityNotificationTopic resource.
        :param pulumi.Input[str] identity: The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        :param pulumi.Input[str] notification_type: The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: *Bounce*, *Complaint* or *Delivery*.
        :param pulumi.Input[bool] include_original_headers: Whether SES should include original email headers in SNS notifications of this type. *false* by default.
        :param pulumi.Input[str] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to "" (an empty string) to disable publishing.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "notification_type", notification_type)
        if include_original_headers is not None:
            pulumi.set(__self__, "include_original_headers", include_original_headers)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Input[str]:
        """
        The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> pulumi.Input[str]:
        """
        The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: *Bounce*, *Complaint* or *Delivery*.
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "notification_type", value)

    @property
    @pulumi.getter(name="includeOriginalHeaders")
    def include_original_headers(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SES should include original email headers in SNS notifications of this type. *false* by default.
        """
        return pulumi.get(self, "include_original_headers")

    @include_original_headers.setter
    def include_original_headers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_original_headers", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to "" (an empty string) to disable publishing.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class _IdentityNotificationTopicState:
    def __init__(__self__, *,
                 identity: Optional[pulumi.Input[str]] = None,
                 include_original_headers: Optional[pulumi.Input[bool]] = None,
                 notification_type: Optional[pulumi.Input[str]] = None,
                 topic_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IdentityNotificationTopic resources.
        :param pulumi.Input[str] identity: The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        :param pulumi.Input[bool] include_original_headers: Whether SES should include original email headers in SNS notifications of this type. *false* by default.
        :param pulumi.Input[str] notification_type: The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: *Bounce*, *Complaint* or *Delivery*.
        :param pulumi.Input[str] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to "" (an empty string) to disable publishing.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if include_original_headers is not None:
            pulumi.set(__self__, "include_original_headers", include_original_headers)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[str]]:
        """
        The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="includeOriginalHeaders")
    def include_original_headers(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SES should include original email headers in SNS notifications of this type. *false* by default.
        """
        return pulumi.get(self, "include_original_headers")

    @include_original_headers.setter
    def include_original_headers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_original_headers", value)

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: *Bounce*, *Complaint* or *Delivery*.
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_type", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to "" (an empty string) to disable publishing.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)


class IdentityNotificationTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[str]] = None,
                 include_original_headers: Optional[pulumi.Input[bool]] = None,
                 notification_type: Optional[pulumi.Input[str]] = None,
                 topic_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing SES Identity Notification Topics

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.ses.IdentityNotificationTopic("test",
            topic_arn=aws_sns_topic["example"]["arn"],
            notification_type="Bounce",
            identity=aws_ses_domain_identity["example"]["domain"],
            include_original_headers=True)
        ```

        ## Import

        Identity Notification Topics can be imported using ID of the record. The ID is made up as IDENTITY|TYPE where IDENTITY is the SES Identity and TYPE is the Notification Type.

        ```sh
         $ pulumi import aws:ses/identityNotificationTopic:IdentityNotificationTopic test 'example.com|Bounce'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] identity: The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        :param pulumi.Input[bool] include_original_headers: Whether SES should include original email headers in SNS notifications of this type. *false* by default.
        :param pulumi.Input[str] notification_type: The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: *Bounce*, *Complaint* or *Delivery*.
        :param pulumi.Input[str] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to "" (an empty string) to disable publishing.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityNotificationTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing SES Identity Notification Topics

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.ses.IdentityNotificationTopic("test",
            topic_arn=aws_sns_topic["example"]["arn"],
            notification_type="Bounce",
            identity=aws_ses_domain_identity["example"]["domain"],
            include_original_headers=True)
        ```

        ## Import

        Identity Notification Topics can be imported using ID of the record. The ID is made up as IDENTITY|TYPE where IDENTITY is the SES Identity and TYPE is the Notification Type.

        ```sh
         $ pulumi import aws:ses/identityNotificationTopic:IdentityNotificationTopic test 'example.com|Bounce'
        ```

        :param str resource_name: The name of the resource.
        :param IdentityNotificationTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityNotificationTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[str]] = None,
                 include_original_headers: Optional[pulumi.Input[bool]] = None,
                 notification_type: Optional[pulumi.Input[str]] = None,
                 topic_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityNotificationTopicArgs.__new__(IdentityNotificationTopicArgs)

            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["include_original_headers"] = include_original_headers
            if notification_type is None and not opts.urn:
                raise TypeError("Missing required property 'notification_type'")
            __props__.__dict__["notification_type"] = notification_type
            __props__.__dict__["topic_arn"] = topic_arn
        super(IdentityNotificationTopic, __self__).__init__(
            'aws:ses/identityNotificationTopic:IdentityNotificationTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identity: Optional[pulumi.Input[str]] = None,
            include_original_headers: Optional[pulumi.Input[bool]] = None,
            notification_type: Optional[pulumi.Input[str]] = None,
            topic_arn: Optional[pulumi.Input[str]] = None) -> 'IdentityNotificationTopic':
        """
        Get an existing IdentityNotificationTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] identity: The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        :param pulumi.Input[bool] include_original_headers: Whether SES should include original email headers in SNS notifications of this type. *false* by default.
        :param pulumi.Input[str] notification_type: The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: *Bounce*, *Complaint* or *Delivery*.
        :param pulumi.Input[str] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to "" (an empty string) to disable publishing.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityNotificationTopicState.__new__(_IdentityNotificationTopicState)

        __props__.__dict__["identity"] = identity
        __props__.__dict__["include_original_headers"] = include_original_headers
        __props__.__dict__["notification_type"] = notification_type
        __props__.__dict__["topic_arn"] = topic_arn
        return IdentityNotificationTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[str]:
        """
        The identity for which the Amazon SNS topic will be set. You can specify an identity by using its name or by using its Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="includeOriginalHeaders")
    def include_original_headers(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether SES should include original email headers in SNS notifications of this type. *false* by default.
        """
        return pulumi.get(self, "include_original_headers")

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> pulumi.Output[str]:
        """
        The type of notifications that will be published to the specified Amazon SNS topic. Valid Values: *Bounce*, *Complaint* or *Delivery*.
        """
        return pulumi.get(self, "notification_type")

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic. Can be set to "" (an empty string) to disable publishing.
        """
        return pulumi.get(self, "topic_arn")

