# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObjectCopyArgs', 'ObjectCopy']

@pulumi.input_type
class ObjectCopyArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 key: pulumi.Input[str],
                 source: pulumi.Input[str],
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket_key_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 copy_if_match: Optional[pulumi.Input[str]] = None,
                 copy_if_modified_since: Optional[pulumi.Input[str]] = None,
                 copy_if_none_match: Optional[pulumi.Input[str]] = None,
                 copy_if_unmodified_since: Optional[pulumi.Input[str]] = None,
                 customer_algorithm: Optional[pulumi.Input[str]] = None,
                 customer_key: Optional[pulumi.Input[str]] = None,
                 customer_key_md5: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 expected_source_bucket_owner: Optional[pulumi.Input[str]] = None,
                 expires: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectCopyGrantArgs']]]] = None,
                 kms_encryption_context: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_directive: Optional[pulumi.Input[str]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[str]] = None,
                 object_lock_mode: Optional[pulumi.Input[str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[str]] = None,
                 request_payer: Optional[pulumi.Input[str]] = None,
                 server_side_encryption: Optional[pulumi.Input[str]] = None,
                 source_customer_algorithm: Optional[pulumi.Input[str]] = None,
                 source_customer_key: Optional[pulumi.Input[str]] = None,
                 source_customer_key_md5: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 tagging_directive: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 website_redirect: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ObjectCopy resource.
        :param pulumi.Input[str] bucket: Name of the bucket to put the file in.
        :param pulumi.Input[str] key: Name of the object once it is in the bucket.
        :param pulumi.Input[str] source: Specifies the source object for the copy operation. You specify the value in one of two formats. For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (`/`). For example, `testbucket/test1.json`. For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, `arn:aws:s3:us-west-2:9999912999:accesspoint/my-access-point/object/testbucket/test1.json`.
        :param pulumi.Input[str] acl: [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Defaults to `private`. Valid values are `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Conflicts with `grant`.
        :param pulumi.Input[str] cache_control: Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[str] content_disposition: Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[str] content_language: Language the content is in e.g., en-US or en-GB.
        :param pulumi.Input[str] content_type: Standard MIME type describing the format of the object data, e.g., `application/octet-stream`. All Valid MIME Types are valid for this input.
        :param pulumi.Input[str] copy_if_match: Copies the object if its entity tag (ETag) matches the specified tag.
        :param pulumi.Input[str] copy_if_modified_since: Copies the object if it has been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[str] copy_if_none_match: Copies the object if its entity tag (ETag) is different than the specified ETag.
        :param pulumi.Input[str] copy_if_unmodified_since: Copies the object if it hasn't been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[str] customer_algorithm: Specifies the algorithm to use to when encrypting the object (for example, AES256).
        :param pulumi.Input[str] customer_key: Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header.
        :param pulumi.Input[str] customer_key_md5: Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        :param pulumi.Input[str] expected_bucket_owner: Account id of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[str] expected_source_bucket_owner: Account id of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[str] expires: Date and time at which the object is no longer cacheable, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[bool] force_destroy: Allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectCopyGrantArgs']]] grants: Configuration block for header grants. Documented below. Conflicts with `acl`.
        :param pulumi.Input[str] kms_encryption_context: Specifies the AWS KMS Encryption Context to use for object encryption. The value is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.
        :param pulumi.Input[str] kms_key_id: Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified **ARN** of the KMS Key. If using `kms.Key`, use the exported `arn` attribute: `kms_key_id = aws_kms_key.foo.arn`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: A map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        :param pulumi.Input[str] metadata_directive: Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request. Valid values are `COPY` and `REPLACE`.
        :param pulumi.Input[str] object_lock_legal_hold_status: The [legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        :param pulumi.Input[str] object_lock_mode: The object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param pulumi.Input[str] object_lock_retain_until_date: The date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        :param pulumi.Input[str] request_payer: Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the Amazon S3 Developer Guide. If included, the only valid value is `requester`.
        :param pulumi.Input[str] server_side_encryption: Specifies server-side encryption of the object in S3. Valid values are `AES256` and `aws:kms`.
        :param pulumi.Input[str] source_customer_algorithm: Specifies the algorithm to use when decrypting the source object (for example, AES256).
        :param pulumi.Input[str] source_customer_key: Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
        :param pulumi.Input[str] source_customer_key_md5: Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        :param pulumi.Input[str] storage_class: Specifies the desired [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html#AmazonS3-CopyObject-request-header-StorageClass) for the object. Defaults to `STANDARD`.
        :param pulumi.Input[str] tagging_directive: Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request. Valid values are `COPY` and `REPLACE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] website_redirect: Specifies a target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "source", source)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if copy_if_match is not None:
            pulumi.set(__self__, "copy_if_match", copy_if_match)
        if copy_if_modified_since is not None:
            pulumi.set(__self__, "copy_if_modified_since", copy_if_modified_since)
        if copy_if_none_match is not None:
            pulumi.set(__self__, "copy_if_none_match", copy_if_none_match)
        if copy_if_unmodified_since is not None:
            pulumi.set(__self__, "copy_if_unmodified_since", copy_if_unmodified_since)
        if customer_algorithm is not None:
            pulumi.set(__self__, "customer_algorithm", customer_algorithm)
        if customer_key is not None:
            pulumi.set(__self__, "customer_key", customer_key)
        if customer_key_md5 is not None:
            pulumi.set(__self__, "customer_key_md5", customer_key_md5)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if expected_source_bucket_owner is not None:
            pulumi.set(__self__, "expected_source_bucket_owner", expected_source_bucket_owner)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_directive is not None:
            pulumi.set(__self__, "metadata_directive", metadata_directive)
        if object_lock_legal_hold_status is not None:
            pulumi.set(__self__, "object_lock_legal_hold_status", object_lock_legal_hold_status)
        if object_lock_mode is not None:
            pulumi.set(__self__, "object_lock_mode", object_lock_mode)
        if object_lock_retain_until_date is not None:
            pulumi.set(__self__, "object_lock_retain_until_date", object_lock_retain_until_date)
        if request_payer is not None:
            pulumi.set(__self__, "request_payer", request_payer)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if source_customer_algorithm is not None:
            pulumi.set(__self__, "source_customer_algorithm", source_customer_algorithm)
        if source_customer_key is not None:
            pulumi.set(__self__, "source_customer_key", source_customer_key)
        if source_customer_key_md5 is not None:
            pulumi.set(__self__, "source_customer_key_md5", source_customer_key_md5)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tagging_directive is not None:
            pulumi.set(__self__, "tagging_directive", tagging_directive)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if website_redirect is not None:
            pulumi.set(__self__, "website_redirect", website_redirect)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Name of the bucket to put the file in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        Specifies the source object for the copy operation. You specify the value in one of two formats. For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (`/`). For example, `testbucket/test1.json`. For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, `arn:aws:s3:us-west-2:9999912999:accesspoint/my-access-point/object/testbucket/test1.json`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Defaults to `private`. Valid values are `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Conflicts with `grant`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "bucket_key_enabled")

    @bucket_key_enabled.setter
    def bucket_key_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bucket_key_enabled", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_encoding", value)

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[str]]:
        """
        Language the content is in e.g., en-US or en-GB.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_language", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Standard MIME type describing the format of the object data, e.g., `application/octet-stream`. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="copyIfMatch")
    def copy_if_match(self) -> Optional[pulumi.Input[str]]:
        """
        Copies the object if its entity tag (ETag) matches the specified tag.
        """
        return pulumi.get(self, "copy_if_match")

    @copy_if_match.setter
    def copy_if_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copy_if_match", value)

    @property
    @pulumi.getter(name="copyIfModifiedSince")
    def copy_if_modified_since(self) -> Optional[pulumi.Input[str]]:
        """
        Copies the object if it has been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "copy_if_modified_since")

    @copy_if_modified_since.setter
    def copy_if_modified_since(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copy_if_modified_since", value)

    @property
    @pulumi.getter(name="copyIfNoneMatch")
    def copy_if_none_match(self) -> Optional[pulumi.Input[str]]:
        """
        Copies the object if its entity tag (ETag) is different than the specified ETag.
        """
        return pulumi.get(self, "copy_if_none_match")

    @copy_if_none_match.setter
    def copy_if_none_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copy_if_none_match", value)

    @property
    @pulumi.getter(name="copyIfUnmodifiedSince")
    def copy_if_unmodified_since(self) -> Optional[pulumi.Input[str]]:
        """
        Copies the object if it hasn't been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "copy_if_unmodified_since")

    @copy_if_unmodified_since.setter
    def copy_if_unmodified_since(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copy_if_unmodified_since", value)

    @property
    @pulumi.getter(name="customerAlgorithm")
    def customer_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the algorithm to use to when encrypting the object (for example, AES256).
        """
        return pulumi.get(self, "customer_algorithm")

    @customer_algorithm.setter
    def customer_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_algorithm", value)

    @property
    @pulumi.getter(name="customerKey")
    def customer_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header.
        """
        return pulumi.get(self, "customer_key")

    @customer_key.setter
    def customer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_key", value)

    @property
    @pulumi.getter(name="customerKeyMd5")
    def customer_key_md5(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        """
        return pulumi.get(self, "customer_key_md5")

    @customer_key_md5.setter
    def customer_key_md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_key_md5", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        Account id of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @property
    @pulumi.getter(name="expectedSourceBucketOwner")
    def expected_source_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        Account id of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        """
        return pulumi.get(self, "expected_source_bucket_owner")

    @expected_source_bucket_owner.setter
    def expected_source_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_source_bucket_owner", value)

    @property
    @pulumi.getter
    def expires(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time at which the object is no longer cacheable, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "expires")

    @expires.setter
    def expires(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectCopyGrantArgs']]]]:
        """
        Configuration block for header grants. Documented below. Conflicts with `acl`.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectCopyGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the AWS KMS Encryption Context to use for object encryption. The value is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified **ARN** of the KMS Key. If using `kms.Key`, use the exported `arn` attribute: `kms_key_id = aws_kms_key.foo.arn`
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataDirective")
    def metadata_directive(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request. Valid values are `COPY` and `REPLACE`.
        """
        return pulumi.get(self, "metadata_directive")

    @metadata_directive.setter
    def metadata_directive(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_directive", value)

    @property
    @pulumi.getter(name="objectLockLegalHoldStatus")
    def object_lock_legal_hold_status(self) -> Optional[pulumi.Input[str]]:
        """
        The [legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        """
        return pulumi.get(self, "object_lock_legal_hold_status")

    @object_lock_legal_hold_status.setter
    def object_lock_legal_hold_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_lock_legal_hold_status", value)

    @property
    @pulumi.getter(name="objectLockMode")
    def object_lock_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "object_lock_mode")

    @object_lock_mode.setter
    def object_lock_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_lock_mode", value)

    @property
    @pulumi.getter(name="objectLockRetainUntilDate")
    def object_lock_retain_until_date(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        """
        return pulumi.get(self, "object_lock_retain_until_date")

    @object_lock_retain_until_date.setter
    def object_lock_retain_until_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_lock_retain_until_date", value)

    @property
    @pulumi.getter(name="requestPayer")
    def request_payer(self) -> Optional[pulumi.Input[str]]:
        """
        Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the Amazon S3 Developer Guide. If included, the only valid value is `requester`.
        """
        return pulumi.get(self, "request_payer")

    @request_payer.setter
    def request_payer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_payer", value)

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies server-side encryption of the object in S3. Valid values are `AES256` and `aws:kms`.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_side_encryption", value)

    @property
    @pulumi.getter(name="sourceCustomerAlgorithm")
    def source_customer_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the algorithm to use when decrypting the source object (for example, AES256).
        """
        return pulumi.get(self, "source_customer_algorithm")

    @source_customer_algorithm.setter
    def source_customer_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_customer_algorithm", value)

    @property
    @pulumi.getter(name="sourceCustomerKey")
    def source_customer_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
        """
        return pulumi.get(self, "source_customer_key")

    @source_customer_key.setter
    def source_customer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_customer_key", value)

    @property
    @pulumi.getter(name="sourceCustomerKeyMd5")
    def source_customer_key_md5(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        """
        return pulumi.get(self, "source_customer_key_md5")

    @source_customer_key_md5.setter
    def source_customer_key_md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_customer_key_md5", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the desired [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html#AmazonS3-CopyObject-request-header-StorageClass) for the object. Defaults to `STANDARD`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter(name="taggingDirective")
    def tagging_directive(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request. Valid values are `COPY` and `REPLACE`.
        """
        return pulumi.get(self, "tagging_directive")

    @tagging_directive.setter
    def tagging_directive(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tagging_directive", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="websiteRedirect")
    def website_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
        """
        return pulumi.get(self, "website_redirect")

    @website_redirect.setter
    def website_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "website_redirect", value)


@pulumi.input_type
class _ObjectCopyState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 bucket_key_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 copy_if_match: Optional[pulumi.Input[str]] = None,
                 copy_if_modified_since: Optional[pulumi.Input[str]] = None,
                 copy_if_none_match: Optional[pulumi.Input[str]] = None,
                 copy_if_unmodified_since: Optional[pulumi.Input[str]] = None,
                 customer_algorithm: Optional[pulumi.Input[str]] = None,
                 customer_key: Optional[pulumi.Input[str]] = None,
                 customer_key_md5: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 expected_source_bucket_owner: Optional[pulumi.Input[str]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 expires: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectCopyGrantArgs']]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 last_modified: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_directive: Optional[pulumi.Input[str]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[str]] = None,
                 object_lock_mode: Optional[pulumi.Input[str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[str]] = None,
                 request_charged: Optional[pulumi.Input[bool]] = None,
                 request_payer: Optional[pulumi.Input[str]] = None,
                 server_side_encryption: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_customer_algorithm: Optional[pulumi.Input[str]] = None,
                 source_customer_key: Optional[pulumi.Input[str]] = None,
                 source_customer_key_md5: Optional[pulumi.Input[str]] = None,
                 source_version_id: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 tagging_directive: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 website_redirect: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ObjectCopy resources.
        :param pulumi.Input[str] acl: [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Defaults to `private`. Valid values are `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Conflicts with `grant`.
        :param pulumi.Input[str] bucket: Name of the bucket to put the file in.
        :param pulumi.Input[str] cache_control: Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[str] content_disposition: Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[str] content_language: Language the content is in e.g., en-US or en-GB.
        :param pulumi.Input[str] content_type: Standard MIME type describing the format of the object data, e.g., `application/octet-stream`. All Valid MIME Types are valid for this input.
        :param pulumi.Input[str] copy_if_match: Copies the object if its entity tag (ETag) matches the specified tag.
        :param pulumi.Input[str] copy_if_modified_since: Copies the object if it has been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[str] copy_if_none_match: Copies the object if its entity tag (ETag) is different than the specified ETag.
        :param pulumi.Input[str] copy_if_unmodified_since: Copies the object if it hasn't been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[str] customer_algorithm: Specifies the algorithm to use to when encrypting the object (for example, AES256).
        :param pulumi.Input[str] customer_key: Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header.
        :param pulumi.Input[str] customer_key_md5: Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        :param pulumi.Input[str] etag: The ETag generated for the object (an MD5 sum of the object content). For plaintext objects or objects encrypted with an AWS-managed key, the hash is an MD5 digest of the object data. For objects encrypted with a KMS key or objects created by either the Multipart Upload or Part Copy operation, the hash is not an MD5 digest, regardless of the method of encryption. More information on possible values can be found on [Common Response Headers](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonResponseHeaders.html).
        :param pulumi.Input[str] expected_bucket_owner: Account id of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[str] expected_source_bucket_owner: Account id of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[str] expiration: If the object expiration is configured, this attribute will be set.
        :param pulumi.Input[str] expires: Date and time at which the object is no longer cacheable, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[bool] force_destroy: Allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectCopyGrantArgs']]] grants: Configuration block for header grants. Documented below. Conflicts with `acl`.
        :param pulumi.Input[str] key: Name of the object once it is in the bucket.
        :param pulumi.Input[str] kms_encryption_context: Specifies the AWS KMS Encryption Context to use for object encryption. The value is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.
        :param pulumi.Input[str] kms_key_id: Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified **ARN** of the KMS Key. If using `kms.Key`, use the exported `arn` attribute: `kms_key_id = aws_kms_key.foo.arn`
        :param pulumi.Input[str] last_modified: Returns the date that the object was last modified, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: A map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        :param pulumi.Input[str] metadata_directive: Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request. Valid values are `COPY` and `REPLACE`.
        :param pulumi.Input[str] object_lock_legal_hold_status: The [legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        :param pulumi.Input[str] object_lock_mode: The object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param pulumi.Input[str] object_lock_retain_until_date: The date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        :param pulumi.Input[bool] request_charged: If present, indicates that the requester was successfully charged for the request.
        :param pulumi.Input[str] request_payer: Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the Amazon S3 Developer Guide. If included, the only valid value is `requester`.
        :param pulumi.Input[str] server_side_encryption: Specifies server-side encryption of the object in S3. Valid values are `AES256` and `aws:kms`.
        :param pulumi.Input[str] source: Specifies the source object for the copy operation. You specify the value in one of two formats. For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (`/`). For example, `testbucket/test1.json`. For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, `arn:aws:s3:us-west-2:9999912999:accesspoint/my-access-point/object/testbucket/test1.json`.
        :param pulumi.Input[str] source_customer_algorithm: Specifies the algorithm to use when decrypting the source object (for example, AES256).
        :param pulumi.Input[str] source_customer_key: Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
        :param pulumi.Input[str] source_customer_key_md5: Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        :param pulumi.Input[str] source_version_id: Version of the copied object in the source bucket.
        :param pulumi.Input[str] storage_class: Specifies the desired [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html#AmazonS3-CopyObject-request-header-StorageClass) for the object. Defaults to `STANDARD`.
        :param pulumi.Input[str] tagging_directive: Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request. Valid values are `COPY` and `REPLACE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[str] version_id: Version ID of the newly created copy.
        :param pulumi.Input[str] website_redirect: Specifies a target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if copy_if_match is not None:
            pulumi.set(__self__, "copy_if_match", copy_if_match)
        if copy_if_modified_since is not None:
            pulumi.set(__self__, "copy_if_modified_since", copy_if_modified_since)
        if copy_if_none_match is not None:
            pulumi.set(__self__, "copy_if_none_match", copy_if_none_match)
        if copy_if_unmodified_since is not None:
            pulumi.set(__self__, "copy_if_unmodified_since", copy_if_unmodified_since)
        if customer_algorithm is not None:
            pulumi.set(__self__, "customer_algorithm", customer_algorithm)
        if customer_key is not None:
            pulumi.set(__self__, "customer_key", customer_key)
        if customer_key_md5 is not None:
            pulumi.set(__self__, "customer_key_md5", customer_key_md5)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if expected_source_bucket_owner is not None:
            pulumi.set(__self__, "expected_source_bucket_owner", expected_source_bucket_owner)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_directive is not None:
            pulumi.set(__self__, "metadata_directive", metadata_directive)
        if object_lock_legal_hold_status is not None:
            pulumi.set(__self__, "object_lock_legal_hold_status", object_lock_legal_hold_status)
        if object_lock_mode is not None:
            pulumi.set(__self__, "object_lock_mode", object_lock_mode)
        if object_lock_retain_until_date is not None:
            pulumi.set(__self__, "object_lock_retain_until_date", object_lock_retain_until_date)
        if request_charged is not None:
            pulumi.set(__self__, "request_charged", request_charged)
        if request_payer is not None:
            pulumi.set(__self__, "request_payer", request_payer)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_customer_algorithm is not None:
            pulumi.set(__self__, "source_customer_algorithm", source_customer_algorithm)
        if source_customer_key is not None:
            pulumi.set(__self__, "source_customer_key", source_customer_key)
        if source_customer_key_md5 is not None:
            pulumi.set(__self__, "source_customer_key_md5", source_customer_key_md5)
        if source_version_id is not None:
            pulumi.set(__self__, "source_version_id", source_version_id)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tagging_directive is not None:
            pulumi.set(__self__, "tagging_directive", tagging_directive)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if website_redirect is not None:
            pulumi.set(__self__, "website_redirect", website_redirect)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Defaults to `private`. Valid values are `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Conflicts with `grant`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the bucket to put the file in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "bucket_key_enabled")

    @bucket_key_enabled.setter
    def bucket_key_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bucket_key_enabled", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_encoding", value)

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[str]]:
        """
        Language the content is in e.g., en-US or en-GB.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_language", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Standard MIME type describing the format of the object data, e.g., `application/octet-stream`. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="copyIfMatch")
    def copy_if_match(self) -> Optional[pulumi.Input[str]]:
        """
        Copies the object if its entity tag (ETag) matches the specified tag.
        """
        return pulumi.get(self, "copy_if_match")

    @copy_if_match.setter
    def copy_if_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copy_if_match", value)

    @property
    @pulumi.getter(name="copyIfModifiedSince")
    def copy_if_modified_since(self) -> Optional[pulumi.Input[str]]:
        """
        Copies the object if it has been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "copy_if_modified_since")

    @copy_if_modified_since.setter
    def copy_if_modified_since(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copy_if_modified_since", value)

    @property
    @pulumi.getter(name="copyIfNoneMatch")
    def copy_if_none_match(self) -> Optional[pulumi.Input[str]]:
        """
        Copies the object if its entity tag (ETag) is different than the specified ETag.
        """
        return pulumi.get(self, "copy_if_none_match")

    @copy_if_none_match.setter
    def copy_if_none_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copy_if_none_match", value)

    @property
    @pulumi.getter(name="copyIfUnmodifiedSince")
    def copy_if_unmodified_since(self) -> Optional[pulumi.Input[str]]:
        """
        Copies the object if it hasn't been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "copy_if_unmodified_since")

    @copy_if_unmodified_since.setter
    def copy_if_unmodified_since(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copy_if_unmodified_since", value)

    @property
    @pulumi.getter(name="customerAlgorithm")
    def customer_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the algorithm to use to when encrypting the object (for example, AES256).
        """
        return pulumi.get(self, "customer_algorithm")

    @customer_algorithm.setter
    def customer_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_algorithm", value)

    @property
    @pulumi.getter(name="customerKey")
    def customer_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header.
        """
        return pulumi.get(self, "customer_key")

    @customer_key.setter
    def customer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_key", value)

    @property
    @pulumi.getter(name="customerKeyMd5")
    def customer_key_md5(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        """
        return pulumi.get(self, "customer_key_md5")

    @customer_key_md5.setter
    def customer_key_md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_key_md5", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The ETag generated for the object (an MD5 sum of the object content). For plaintext objects or objects encrypted with an AWS-managed key, the hash is an MD5 digest of the object data. For objects encrypted with a KMS key or objects created by either the Multipart Upload or Part Copy operation, the hash is not an MD5 digest, regardless of the method of encryption. More information on possible values can be found on [Common Response Headers](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonResponseHeaders.html).
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        Account id of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @property
    @pulumi.getter(name="expectedSourceBucketOwner")
    def expected_source_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        Account id of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        """
        return pulumi.get(self, "expected_source_bucket_owner")

    @expected_source_bucket_owner.setter
    def expected_source_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_source_bucket_owner", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[str]]:
        """
        If the object expiration is configured, this attribute will be set.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def expires(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time at which the object is no longer cacheable, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "expires")

    @expires.setter
    def expires(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectCopyGrantArgs']]]]:
        """
        Configuration block for header grants. Documented below. Conflicts with `acl`.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectCopyGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the AWS KMS Encryption Context to use for object encryption. The value is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified **ARN** of the KMS Key. If using `kms.Key`, use the exported `arn` attribute: `kms_key_id = aws_kms_key.foo.arn`
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[str]]:
        """
        Returns the date that the object was last modified, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataDirective")
    def metadata_directive(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request. Valid values are `COPY` and `REPLACE`.
        """
        return pulumi.get(self, "metadata_directive")

    @metadata_directive.setter
    def metadata_directive(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_directive", value)

    @property
    @pulumi.getter(name="objectLockLegalHoldStatus")
    def object_lock_legal_hold_status(self) -> Optional[pulumi.Input[str]]:
        """
        The [legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        """
        return pulumi.get(self, "object_lock_legal_hold_status")

    @object_lock_legal_hold_status.setter
    def object_lock_legal_hold_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_lock_legal_hold_status", value)

    @property
    @pulumi.getter(name="objectLockMode")
    def object_lock_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "object_lock_mode")

    @object_lock_mode.setter
    def object_lock_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_lock_mode", value)

    @property
    @pulumi.getter(name="objectLockRetainUntilDate")
    def object_lock_retain_until_date(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        """
        return pulumi.get(self, "object_lock_retain_until_date")

    @object_lock_retain_until_date.setter
    def object_lock_retain_until_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_lock_retain_until_date", value)

    @property
    @pulumi.getter(name="requestCharged")
    def request_charged(self) -> Optional[pulumi.Input[bool]]:
        """
        If present, indicates that the requester was successfully charged for the request.
        """
        return pulumi.get(self, "request_charged")

    @request_charged.setter
    def request_charged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_charged", value)

    @property
    @pulumi.getter(name="requestPayer")
    def request_payer(self) -> Optional[pulumi.Input[str]]:
        """
        Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the Amazon S3 Developer Guide. If included, the only valid value is `requester`.
        """
        return pulumi.get(self, "request_payer")

    @request_payer.setter
    def request_payer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_payer", value)

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies server-side encryption of the object in S3. Valid values are `AES256` and `aws:kms`.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_side_encryption", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the source object for the copy operation. You specify the value in one of two formats. For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (`/`). For example, `testbucket/test1.json`. For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, `arn:aws:s3:us-west-2:9999912999:accesspoint/my-access-point/object/testbucket/test1.json`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceCustomerAlgorithm")
    def source_customer_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the algorithm to use when decrypting the source object (for example, AES256).
        """
        return pulumi.get(self, "source_customer_algorithm")

    @source_customer_algorithm.setter
    def source_customer_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_customer_algorithm", value)

    @property
    @pulumi.getter(name="sourceCustomerKey")
    def source_customer_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
        """
        return pulumi.get(self, "source_customer_key")

    @source_customer_key.setter
    def source_customer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_customer_key", value)

    @property
    @pulumi.getter(name="sourceCustomerKeyMd5")
    def source_customer_key_md5(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        """
        return pulumi.get(self, "source_customer_key_md5")

    @source_customer_key_md5.setter
    def source_customer_key_md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_customer_key_md5", value)

    @property
    @pulumi.getter(name="sourceVersionId")
    def source_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the copied object in the source bucket.
        """
        return pulumi.get(self, "source_version_id")

    @source_version_id.setter
    def source_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version_id", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the desired [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html#AmazonS3-CopyObject-request-header-StorageClass) for the object. Defaults to `STANDARD`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter(name="taggingDirective")
    def tagging_directive(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request. Valid values are `COPY` and `REPLACE`.
        """
        return pulumi.get(self, "tagging_directive")

    @tagging_directive.setter
    def tagging_directive(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tagging_directive", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        Version ID of the newly created copy.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="websiteRedirect")
    def website_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
        """
        return pulumi.get(self, "website_redirect")

    @website_redirect.setter
    def website_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "website_redirect", value)


class ObjectCopy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 bucket_key_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 copy_if_match: Optional[pulumi.Input[str]] = None,
                 copy_if_modified_since: Optional[pulumi.Input[str]] = None,
                 copy_if_none_match: Optional[pulumi.Input[str]] = None,
                 copy_if_unmodified_since: Optional[pulumi.Input[str]] = None,
                 customer_algorithm: Optional[pulumi.Input[str]] = None,
                 customer_key: Optional[pulumi.Input[str]] = None,
                 customer_key_md5: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 expected_source_bucket_owner: Optional[pulumi.Input[str]] = None,
                 expires: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectCopyGrantArgs']]]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_directive: Optional[pulumi.Input[str]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[str]] = None,
                 object_lock_mode: Optional[pulumi.Input[str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[str]] = None,
                 request_payer: Optional[pulumi.Input[str]] = None,
                 server_side_encryption: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_customer_algorithm: Optional[pulumi.Input[str]] = None,
                 source_customer_key: Optional[pulumi.Input[str]] = None,
                 source_customer_key_md5: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 tagging_directive: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 website_redirect: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource for copying an S3 object.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.s3.ObjectCopy("test",
            bucket="destination_bucket",
            grants=[aws.s3.ObjectCopyGrantArgs(
                permissions=["READ"],
                type="Group",
                uri="http://acs.amazonaws.com/groups/global/AllUsers",
            )],
            key="destination_key",
            source="source_bucket/source_key")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Defaults to `private`. Valid values are `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Conflicts with `grant`.
        :param pulumi.Input[str] bucket: Name of the bucket to put the file in.
        :param pulumi.Input[str] cache_control: Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[str] content_disposition: Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[str] content_language: Language the content is in e.g., en-US or en-GB.
        :param pulumi.Input[str] content_type: Standard MIME type describing the format of the object data, e.g., `application/octet-stream`. All Valid MIME Types are valid for this input.
        :param pulumi.Input[str] copy_if_match: Copies the object if its entity tag (ETag) matches the specified tag.
        :param pulumi.Input[str] copy_if_modified_since: Copies the object if it has been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[str] copy_if_none_match: Copies the object if its entity tag (ETag) is different than the specified ETag.
        :param pulumi.Input[str] copy_if_unmodified_since: Copies the object if it hasn't been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[str] customer_algorithm: Specifies the algorithm to use to when encrypting the object (for example, AES256).
        :param pulumi.Input[str] customer_key: Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header.
        :param pulumi.Input[str] customer_key_md5: Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        :param pulumi.Input[str] expected_bucket_owner: Account id of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[str] expected_source_bucket_owner: Account id of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[str] expires: Date and time at which the object is no longer cacheable, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[bool] force_destroy: Allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectCopyGrantArgs']]]] grants: Configuration block for header grants. Documented below. Conflicts with `acl`.
        :param pulumi.Input[str] key: Name of the object once it is in the bucket.
        :param pulumi.Input[str] kms_encryption_context: Specifies the AWS KMS Encryption Context to use for object encryption. The value is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.
        :param pulumi.Input[str] kms_key_id: Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified **ARN** of the KMS Key. If using `kms.Key`, use the exported `arn` attribute: `kms_key_id = aws_kms_key.foo.arn`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: A map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        :param pulumi.Input[str] metadata_directive: Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request. Valid values are `COPY` and `REPLACE`.
        :param pulumi.Input[str] object_lock_legal_hold_status: The [legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        :param pulumi.Input[str] object_lock_mode: The object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param pulumi.Input[str] object_lock_retain_until_date: The date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        :param pulumi.Input[str] request_payer: Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the Amazon S3 Developer Guide. If included, the only valid value is `requester`.
        :param pulumi.Input[str] server_side_encryption: Specifies server-side encryption of the object in S3. Valid values are `AES256` and `aws:kms`.
        :param pulumi.Input[str] source: Specifies the source object for the copy operation. You specify the value in one of two formats. For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (`/`). For example, `testbucket/test1.json`. For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, `arn:aws:s3:us-west-2:9999912999:accesspoint/my-access-point/object/testbucket/test1.json`.
        :param pulumi.Input[str] source_customer_algorithm: Specifies the algorithm to use when decrypting the source object (for example, AES256).
        :param pulumi.Input[str] source_customer_key: Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
        :param pulumi.Input[str] source_customer_key_md5: Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        :param pulumi.Input[str] storage_class: Specifies the desired [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html#AmazonS3-CopyObject-request-header-StorageClass) for the object. Defaults to `STANDARD`.
        :param pulumi.Input[str] tagging_directive: Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request. Valid values are `COPY` and `REPLACE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] website_redirect: Specifies a target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectCopyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for copying an S3 object.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.s3.ObjectCopy("test",
            bucket="destination_bucket",
            grants=[aws.s3.ObjectCopyGrantArgs(
                permissions=["READ"],
                type="Group",
                uri="http://acs.amazonaws.com/groups/global/AllUsers",
            )],
            key="destination_key",
            source="source_bucket/source_key")
        ```

        :param str resource_name: The name of the resource.
        :param ObjectCopyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectCopyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 bucket_key_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 copy_if_match: Optional[pulumi.Input[str]] = None,
                 copy_if_modified_since: Optional[pulumi.Input[str]] = None,
                 copy_if_none_match: Optional[pulumi.Input[str]] = None,
                 copy_if_unmodified_since: Optional[pulumi.Input[str]] = None,
                 customer_algorithm: Optional[pulumi.Input[str]] = None,
                 customer_key: Optional[pulumi.Input[str]] = None,
                 customer_key_md5: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 expected_source_bucket_owner: Optional[pulumi.Input[str]] = None,
                 expires: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectCopyGrantArgs']]]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_directive: Optional[pulumi.Input[str]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[str]] = None,
                 object_lock_mode: Optional[pulumi.Input[str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[str]] = None,
                 request_payer: Optional[pulumi.Input[str]] = None,
                 server_side_encryption: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_customer_algorithm: Optional[pulumi.Input[str]] = None,
                 source_customer_key: Optional[pulumi.Input[str]] = None,
                 source_customer_key_md5: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 tagging_directive: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 website_redirect: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectCopyArgs.__new__(ObjectCopyArgs)

            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["bucket_key_enabled"] = bucket_key_enabled
            __props__.__dict__["cache_control"] = cache_control
            __props__.__dict__["content_disposition"] = content_disposition
            __props__.__dict__["content_encoding"] = content_encoding
            __props__.__dict__["content_language"] = content_language
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["copy_if_match"] = copy_if_match
            __props__.__dict__["copy_if_modified_since"] = copy_if_modified_since
            __props__.__dict__["copy_if_none_match"] = copy_if_none_match
            __props__.__dict__["copy_if_unmodified_since"] = copy_if_unmodified_since
            __props__.__dict__["customer_algorithm"] = customer_algorithm
            __props__.__dict__["customer_key"] = customer_key
            __props__.__dict__["customer_key_md5"] = customer_key_md5
            __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
            __props__.__dict__["expected_source_bucket_owner"] = expected_source_bucket_owner
            __props__.__dict__["expires"] = expires
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["grants"] = grants
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metadata_directive"] = metadata_directive
            __props__.__dict__["object_lock_legal_hold_status"] = object_lock_legal_hold_status
            __props__.__dict__["object_lock_mode"] = object_lock_mode
            __props__.__dict__["object_lock_retain_until_date"] = object_lock_retain_until_date
            __props__.__dict__["request_payer"] = request_payer
            __props__.__dict__["server_side_encryption"] = server_side_encryption
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["source_customer_algorithm"] = source_customer_algorithm
            __props__.__dict__["source_customer_key"] = source_customer_key
            __props__.__dict__["source_customer_key_md5"] = source_customer_key_md5
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["tagging_directive"] = tagging_directive
            __props__.__dict__["tags"] = tags
            __props__.__dict__["website_redirect"] = website_redirect
            __props__.__dict__["etag"] = None
            __props__.__dict__["expiration"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["request_charged"] = None
            __props__.__dict__["source_version_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["version_id"] = None
        super(ObjectCopy, __self__).__init__(
            'aws:s3/objectCopy:ObjectCopy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[str]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            bucket_key_enabled: Optional[pulumi.Input[bool]] = None,
            cache_control: Optional[pulumi.Input[str]] = None,
            content_disposition: Optional[pulumi.Input[str]] = None,
            content_encoding: Optional[pulumi.Input[str]] = None,
            content_language: Optional[pulumi.Input[str]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            copy_if_match: Optional[pulumi.Input[str]] = None,
            copy_if_modified_since: Optional[pulumi.Input[str]] = None,
            copy_if_none_match: Optional[pulumi.Input[str]] = None,
            copy_if_unmodified_since: Optional[pulumi.Input[str]] = None,
            customer_algorithm: Optional[pulumi.Input[str]] = None,
            customer_key: Optional[pulumi.Input[str]] = None,
            customer_key_md5: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            expected_bucket_owner: Optional[pulumi.Input[str]] = None,
            expected_source_bucket_owner: Optional[pulumi.Input[str]] = None,
            expiration: Optional[pulumi.Input[str]] = None,
            expires: Optional[pulumi.Input[str]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectCopyGrantArgs']]]]] = None,
            key: Optional[pulumi.Input[str]] = None,
            kms_encryption_context: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            last_modified: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            metadata_directive: Optional[pulumi.Input[str]] = None,
            object_lock_legal_hold_status: Optional[pulumi.Input[str]] = None,
            object_lock_mode: Optional[pulumi.Input[str]] = None,
            object_lock_retain_until_date: Optional[pulumi.Input[str]] = None,
            request_charged: Optional[pulumi.Input[bool]] = None,
            request_payer: Optional[pulumi.Input[str]] = None,
            server_side_encryption: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            source_customer_algorithm: Optional[pulumi.Input[str]] = None,
            source_customer_key: Optional[pulumi.Input[str]] = None,
            source_customer_key_md5: Optional[pulumi.Input[str]] = None,
            source_version_id: Optional[pulumi.Input[str]] = None,
            storage_class: Optional[pulumi.Input[str]] = None,
            tagging_directive: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            version_id: Optional[pulumi.Input[str]] = None,
            website_redirect: Optional[pulumi.Input[str]] = None) -> 'ObjectCopy':
        """
        Get an existing ObjectCopy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Defaults to `private`. Valid values are `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Conflicts with `grant`.
        :param pulumi.Input[str] bucket: Name of the bucket to put the file in.
        :param pulumi.Input[str] cache_control: Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[str] content_disposition: Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[str] content_language: Language the content is in e.g., en-US or en-GB.
        :param pulumi.Input[str] content_type: Standard MIME type describing the format of the object data, e.g., `application/octet-stream`. All Valid MIME Types are valid for this input.
        :param pulumi.Input[str] copy_if_match: Copies the object if its entity tag (ETag) matches the specified tag.
        :param pulumi.Input[str] copy_if_modified_since: Copies the object if it has been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[str] copy_if_none_match: Copies the object if its entity tag (ETag) is different than the specified ETag.
        :param pulumi.Input[str] copy_if_unmodified_since: Copies the object if it hasn't been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[str] customer_algorithm: Specifies the algorithm to use to when encrypting the object (for example, AES256).
        :param pulumi.Input[str] customer_key: Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header.
        :param pulumi.Input[str] customer_key_md5: Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        :param pulumi.Input[str] etag: The ETag generated for the object (an MD5 sum of the object content). For plaintext objects or objects encrypted with an AWS-managed key, the hash is an MD5 digest of the object data. For objects encrypted with a KMS key or objects created by either the Multipart Upload or Part Copy operation, the hash is not an MD5 digest, regardless of the method of encryption. More information on possible values can be found on [Common Response Headers](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonResponseHeaders.html).
        :param pulumi.Input[str] expected_bucket_owner: Account id of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[str] expected_source_bucket_owner: Account id of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[str] expiration: If the object expiration is configured, this attribute will be set.
        :param pulumi.Input[str] expires: Date and time at which the object is no longer cacheable, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[bool] force_destroy: Allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectCopyGrantArgs']]]] grants: Configuration block for header grants. Documented below. Conflicts with `acl`.
        :param pulumi.Input[str] key: Name of the object once it is in the bucket.
        :param pulumi.Input[str] kms_encryption_context: Specifies the AWS KMS Encryption Context to use for object encryption. The value is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.
        :param pulumi.Input[str] kms_key_id: Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified **ARN** of the KMS Key. If using `kms.Key`, use the exported `arn` attribute: `kms_key_id = aws_kms_key.foo.arn`
        :param pulumi.Input[str] last_modified: Returns the date that the object was last modified, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: A map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        :param pulumi.Input[str] metadata_directive: Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request. Valid values are `COPY` and `REPLACE`.
        :param pulumi.Input[str] object_lock_legal_hold_status: The [legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        :param pulumi.Input[str] object_lock_mode: The object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param pulumi.Input[str] object_lock_retain_until_date: The date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        :param pulumi.Input[bool] request_charged: If present, indicates that the requester was successfully charged for the request.
        :param pulumi.Input[str] request_payer: Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the Amazon S3 Developer Guide. If included, the only valid value is `requester`.
        :param pulumi.Input[str] server_side_encryption: Specifies server-side encryption of the object in S3. Valid values are `AES256` and `aws:kms`.
        :param pulumi.Input[str] source: Specifies the source object for the copy operation. You specify the value in one of two formats. For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (`/`). For example, `testbucket/test1.json`. For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, `arn:aws:s3:us-west-2:9999912999:accesspoint/my-access-point/object/testbucket/test1.json`.
        :param pulumi.Input[str] source_customer_algorithm: Specifies the algorithm to use when decrypting the source object (for example, AES256).
        :param pulumi.Input[str] source_customer_key: Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
        :param pulumi.Input[str] source_customer_key_md5: Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        :param pulumi.Input[str] source_version_id: Version of the copied object in the source bucket.
        :param pulumi.Input[str] storage_class: Specifies the desired [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html#AmazonS3-CopyObject-request-header-StorageClass) for the object. Defaults to `STANDARD`.
        :param pulumi.Input[str] tagging_directive: Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request. Valid values are `COPY` and `REPLACE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[str] version_id: Version ID of the newly created copy.
        :param pulumi.Input[str] website_redirect: Specifies a target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectCopyState.__new__(_ObjectCopyState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["bucket_key_enabled"] = bucket_key_enabled
        __props__.__dict__["cache_control"] = cache_control
        __props__.__dict__["content_disposition"] = content_disposition
        __props__.__dict__["content_encoding"] = content_encoding
        __props__.__dict__["content_language"] = content_language
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["copy_if_match"] = copy_if_match
        __props__.__dict__["copy_if_modified_since"] = copy_if_modified_since
        __props__.__dict__["copy_if_none_match"] = copy_if_none_match
        __props__.__dict__["copy_if_unmodified_since"] = copy_if_unmodified_since
        __props__.__dict__["customer_algorithm"] = customer_algorithm
        __props__.__dict__["customer_key"] = customer_key
        __props__.__dict__["customer_key_md5"] = customer_key_md5
        __props__.__dict__["etag"] = etag
        __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
        __props__.__dict__["expected_source_bucket_owner"] = expected_source_bucket_owner
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["expires"] = expires
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["grants"] = grants
        __props__.__dict__["key"] = key
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_directive"] = metadata_directive
        __props__.__dict__["object_lock_legal_hold_status"] = object_lock_legal_hold_status
        __props__.__dict__["object_lock_mode"] = object_lock_mode
        __props__.__dict__["object_lock_retain_until_date"] = object_lock_retain_until_date
        __props__.__dict__["request_charged"] = request_charged
        __props__.__dict__["request_payer"] = request_payer
        __props__.__dict__["server_side_encryption"] = server_side_encryption
        __props__.__dict__["source"] = source
        __props__.__dict__["source_customer_algorithm"] = source_customer_algorithm
        __props__.__dict__["source_customer_key"] = source_customer_key
        __props__.__dict__["source_customer_key_md5"] = source_customer_key_md5
        __props__.__dict__["source_version_id"] = source_version_id
        __props__.__dict__["storage_class"] = storage_class
        __props__.__dict__["tagging_directive"] = tagging_directive
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["website_redirect"] = website_redirect
        return ObjectCopy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[str]]:
        """
        [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Defaults to `private`. Valid values are `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Conflicts with `grant`.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        Name of the bucket to put the file in.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "bucket_key_enabled")

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> pulumi.Output[str]:
        """
        Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        """
        return pulumi.get(self, "cache_control")

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> pulumi.Output[str]:
        """
        Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        """
        return pulumi.get(self, "content_disposition")

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> pulumi.Output[str]:
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        """
        return pulumi.get(self, "content_encoding")

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> pulumi.Output[str]:
        """
        Language the content is in e.g., en-US or en-GB.
        """
        return pulumi.get(self, "content_language")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[str]:
        """
        Standard MIME type describing the format of the object data, e.g., `application/octet-stream`. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="copyIfMatch")
    def copy_if_match(self) -> pulumi.Output[Optional[str]]:
        """
        Copies the object if its entity tag (ETag) matches the specified tag.
        """
        return pulumi.get(self, "copy_if_match")

    @property
    @pulumi.getter(name="copyIfModifiedSince")
    def copy_if_modified_since(self) -> pulumi.Output[Optional[str]]:
        """
        Copies the object if it has been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "copy_if_modified_since")

    @property
    @pulumi.getter(name="copyIfNoneMatch")
    def copy_if_none_match(self) -> pulumi.Output[Optional[str]]:
        """
        Copies the object if its entity tag (ETag) is different than the specified ETag.
        """
        return pulumi.get(self, "copy_if_none_match")

    @property
    @pulumi.getter(name="copyIfUnmodifiedSince")
    def copy_if_unmodified_since(self) -> pulumi.Output[Optional[str]]:
        """
        Copies the object if it hasn't been modified since the specified time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "copy_if_unmodified_since")

    @property
    @pulumi.getter(name="customerAlgorithm")
    def customer_algorithm(self) -> pulumi.Output[str]:
        """
        Specifies the algorithm to use to when encrypting the object (for example, AES256).
        """
        return pulumi.get(self, "customer_algorithm")

    @property
    @pulumi.getter(name="customerKey")
    def customer_key(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header.
        """
        return pulumi.get(self, "customer_key")

    @property
    @pulumi.getter(name="customerKeyMd5")
    def customer_key_md5(self) -> pulumi.Output[str]:
        """
        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        """
        return pulumi.get(self, "customer_key_md5")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The ETag generated for the object (an MD5 sum of the object content). For plaintext objects or objects encrypted with an AWS-managed key, the hash is an MD5 digest of the object data. For objects encrypted with a KMS key or objects created by either the Multipart Upload or Part Copy operation, the hash is not an MD5 digest, regardless of the method of encryption. More information on possible values can be found on [Common Response Headers](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonResponseHeaders.html).
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> pulumi.Output[Optional[str]]:
        """
        Account id of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @property
    @pulumi.getter(name="expectedSourceBucketOwner")
    def expected_source_bucket_owner(self) -> pulumi.Output[Optional[str]]:
        """
        Account id of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        """
        return pulumi.get(self, "expected_source_bucket_owner")

    @property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[str]:
        """
        If the object expiration is configured, this attribute will be set.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def expires(self) -> pulumi.Output[Optional[str]]:
        """
        Date and time at which the object is no longer cacheable, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def grants(self) -> pulumi.Output[Optional[Sequence['outputs.ObjectCopyGrant']]]:
        """
        Configuration block for header grants. Documented below. Conflicts with `acl`.
        """
        return pulumi.get(self, "grants")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[str]:
        """
        Specifies the AWS KMS Encryption Context to use for object encryption. The value is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.
        """
        return pulumi.get(self, "kms_encryption_context")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified **ARN** of the KMS Key. If using `kms.Key`, use the exported `arn` attribute: `kms_key_id = aws_kms_key.foo.arn`
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        Returns the date that the object was last modified, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metadataDirective")
    def metadata_directive(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request. Valid values are `COPY` and `REPLACE`.
        """
        return pulumi.get(self, "metadata_directive")

    @property
    @pulumi.getter(name="objectLockLegalHoldStatus")
    def object_lock_legal_hold_status(self) -> pulumi.Output[str]:
        """
        The [legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        """
        return pulumi.get(self, "object_lock_legal_hold_status")

    @property
    @pulumi.getter(name="objectLockMode")
    def object_lock_mode(self) -> pulumi.Output[str]:
        """
        The object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "object_lock_mode")

    @property
    @pulumi.getter(name="objectLockRetainUntilDate")
    def object_lock_retain_until_date(self) -> pulumi.Output[str]:
        """
        The date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        """
        return pulumi.get(self, "object_lock_retain_until_date")

    @property
    @pulumi.getter(name="requestCharged")
    def request_charged(self) -> pulumi.Output[bool]:
        """
        If present, indicates that the requester was successfully charged for the request.
        """
        return pulumi.get(self, "request_charged")

    @property
    @pulumi.getter(name="requestPayer")
    def request_payer(self) -> pulumi.Output[Optional[str]]:
        """
        Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the Amazon S3 Developer Guide. If included, the only valid value is `requester`.
        """
        return pulumi.get(self, "request_payer")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> pulumi.Output[str]:
        """
        Specifies server-side encryption of the object in S3. Valid values are `AES256` and `aws:kms`.
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        Specifies the source object for the copy operation. You specify the value in one of two formats. For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (`/`). For example, `testbucket/test1.json`. For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, `arn:aws:s3:us-west-2:9999912999:accesspoint/my-access-point/object/testbucket/test1.json`.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceCustomerAlgorithm")
    def source_customer_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the algorithm to use when decrypting the source object (for example, AES256).
        """
        return pulumi.get(self, "source_customer_algorithm")

    @property
    @pulumi.getter(name="sourceCustomerKey")
    def source_customer_key(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
        """
        return pulumi.get(self, "source_customer_key")

    @property
    @pulumi.getter(name="sourceCustomerKeyMd5")
    def source_customer_key_md5(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
        """
        return pulumi.get(self, "source_customer_key_md5")

    @property
    @pulumi.getter(name="sourceVersionId")
    def source_version_id(self) -> pulumi.Output[str]:
        """
        Version of the copied object in the source bucket.
        """
        return pulumi.get(self, "source_version_id")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[str]:
        """
        Specifies the desired [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html#AmazonS3-CopyObject-request-header-StorageClass) for the object. Defaults to `STANDARD`.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="taggingDirective")
    def tagging_directive(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request. Valid values are `COPY` and `REPLACE`.
        """
        return pulumi.get(self, "tagging_directive")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        Version ID of the newly created copy.
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="websiteRedirect")
    def website_redirect(self) -> pulumi.Output[str]:
        """
        Specifies a target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
        """
        return pulumi.get(self, "website_redirect")

