# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketAclV2Args', 'BucketAclV2']

@pulumi.input_type
class BucketAclV2Args:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 access_control_policy: Optional[pulumi.Input['BucketAclV2AccessControlPolicyArgs']] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BucketAclV2 resource.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input['BucketAclV2AccessControlPolicyArgs'] access_control_policy: A configuration block that sets the ACL permissions for an object per grantee documented below.
        :param pulumi.Input[str] acl: The canned ACL to apply to the bucket.
        :param pulumi.Input[str] expected_bucket_owner: The account ID of the expected bucket owner.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_policy is not None:
            pulumi.set(__self__, "access_control_policy", access_control_policy)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="accessControlPolicy")
    def access_control_policy(self) -> Optional[pulumi.Input['BucketAclV2AccessControlPolicyArgs']]:
        """
        A configuration block that sets the ACL permissions for an object per grantee documented below.
        """
        return pulumi.get(self, "access_control_policy")

    @access_control_policy.setter
    def access_control_policy(self, value: Optional[pulumi.Input['BucketAclV2AccessControlPolicyArgs']]):
        pulumi.set(self, "access_control_policy", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The canned ACL to apply to the bucket.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_bucket_owner", value)


@pulumi.input_type
class _BucketAclV2State:
    def __init__(__self__, *,
                 access_control_policy: Optional[pulumi.Input['BucketAclV2AccessControlPolicyArgs']] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BucketAclV2 resources.
        :param pulumi.Input['BucketAclV2AccessControlPolicyArgs'] access_control_policy: A configuration block that sets the ACL permissions for an object per grantee documented below.
        :param pulumi.Input[str] acl: The canned ACL to apply to the bucket.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[str] expected_bucket_owner: The account ID of the expected bucket owner.
        """
        if access_control_policy is not None:
            pulumi.set(__self__, "access_control_policy", access_control_policy)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)

    @property
    @pulumi.getter(name="accessControlPolicy")
    def access_control_policy(self) -> Optional[pulumi.Input['BucketAclV2AccessControlPolicyArgs']]:
        """
        A configuration block that sets the ACL permissions for an object per grantee documented below.
        """
        return pulumi.get(self, "access_control_policy")

    @access_control_policy.setter
    def access_control_policy(self, value: Optional[pulumi.Input['BucketAclV2AccessControlPolicyArgs']]):
        pulumi.set(self, "access_control_policy", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The canned ACL to apply to the bucket.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_bucket_owner", value)


class BucketAclV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_policy: Optional[pulumi.Input[pulumi.InputType['BucketAclV2AccessControlPolicyArgs']]] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### With ACL

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketV2("example")
        example_bucket_acl = aws.s3.BucketAclV2("exampleBucketAcl",
            bucket=example.id,
            acl="private")
        ```
        ### With Grants

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.s3.get_canonical_user_id()
        example_bucket_v2 = aws.s3.BucketV2("exampleBucketV2")
        example_bucket_acl_v2 = aws.s3.BucketAclV2("exampleBucketAclV2",
            bucket=example_bucket_v2.id,
            access_control_policy=aws.s3.BucketAclV2AccessControlPolicyArgs(
                grants=[
                    aws.s3.BucketAclV2AccessControlPolicyGrantArgs(
                        grantee=aws.s3.BucketAclV2AccessControlPolicyGrantGranteeArgs(
                            id=current.id,
                            type="CanonicalUser",
                        ),
                        permission="READ",
                    ),
                    aws.s3.BucketAclV2AccessControlPolicyGrantArgs(
                        grantee=aws.s3.BucketAclV2AccessControlPolicyGrantGranteeArgs(
                            type="Group",
                            uri="http://acs.amazonaws.com/groups/s3/LogDelivery",
                        ),
                        permission="READ_ACP",
                    ),
                ],
                owner=aws.s3.BucketAclV2AccessControlPolicyOwnerArgs(
                    id=current.id,
                ),
            ))
        ```

        ## Import

        S3 bucket ACL can be imported in one of four ways. If the owner (account ID) of the source bucket is the _same_ account used to configure the Terraform AWS Provider, and the source bucket is **not configured** with a [canned ACL][1] (i.e. predefined grant), the S3 bucket ACL resource should be imported using the `bucket` e.g.,

        ```sh
         $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name
        ```

         If the owner (account ID) of the source bucket is the _same_ account used to configure the Terraform AWS Provider, and the source bucket is **configured** with a [canned ACL][1] (i.e. predefined grant), the S3 bucket ACL resource should be imported using the `bucket` and `acl` separated by a comma (`,`), e.g.

        ```sh
         $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,private
        ```

         If the owner (account ID) of the source bucket _differs_ from the account used to configure the Terraform AWS Provider, and the source bucket is **not configured** with a [canned ACL][1] (i.e. predefined grant), the S3 bucket ACL resource should be imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`) e.g.,

        ```sh
         $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,123456789012
        ```

         If the owner (account ID) of the source bucket _differs_ from the account used to configure the Terraform AWS Provider, and the source bucket is **configured** with a [canned ACL][1] (i.e. predefined grant), the S3 bucket ACL resource should be imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`), e.g.,

        ```sh
         $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,123456789012,private
        ```

         [1]https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['BucketAclV2AccessControlPolicyArgs']] access_control_policy: A configuration block that sets the ACL permissions for an object per grantee documented below.
        :param pulumi.Input[str] acl: The canned ACL to apply to the bucket.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[str] expected_bucket_owner: The account ID of the expected bucket owner.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketAclV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### With ACL

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketV2("example")
        example_bucket_acl = aws.s3.BucketAclV2("exampleBucketAcl",
            bucket=example.id,
            acl="private")
        ```
        ### With Grants

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.s3.get_canonical_user_id()
        example_bucket_v2 = aws.s3.BucketV2("exampleBucketV2")
        example_bucket_acl_v2 = aws.s3.BucketAclV2("exampleBucketAclV2",
            bucket=example_bucket_v2.id,
            access_control_policy=aws.s3.BucketAclV2AccessControlPolicyArgs(
                grants=[
                    aws.s3.BucketAclV2AccessControlPolicyGrantArgs(
                        grantee=aws.s3.BucketAclV2AccessControlPolicyGrantGranteeArgs(
                            id=current.id,
                            type="CanonicalUser",
                        ),
                        permission="READ",
                    ),
                    aws.s3.BucketAclV2AccessControlPolicyGrantArgs(
                        grantee=aws.s3.BucketAclV2AccessControlPolicyGrantGranteeArgs(
                            type="Group",
                            uri="http://acs.amazonaws.com/groups/s3/LogDelivery",
                        ),
                        permission="READ_ACP",
                    ),
                ],
                owner=aws.s3.BucketAclV2AccessControlPolicyOwnerArgs(
                    id=current.id,
                ),
            ))
        ```

        ## Import

        S3 bucket ACL can be imported in one of four ways. If the owner (account ID) of the source bucket is the _same_ account used to configure the Terraform AWS Provider, and the source bucket is **not configured** with a [canned ACL][1] (i.e. predefined grant), the S3 bucket ACL resource should be imported using the `bucket` e.g.,

        ```sh
         $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name
        ```

         If the owner (account ID) of the source bucket is the _same_ account used to configure the Terraform AWS Provider, and the source bucket is **configured** with a [canned ACL][1] (i.e. predefined grant), the S3 bucket ACL resource should be imported using the `bucket` and `acl` separated by a comma (`,`), e.g.

        ```sh
         $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,private
        ```

         If the owner (account ID) of the source bucket _differs_ from the account used to configure the Terraform AWS Provider, and the source bucket is **not configured** with a [canned ACL][1] (i.e. predefined grant), the S3 bucket ACL resource should be imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`) e.g.,

        ```sh
         $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,123456789012
        ```

         If the owner (account ID) of the source bucket _differs_ from the account used to configure the Terraform AWS Provider, and the source bucket is **configured** with a [canned ACL][1] (i.e. predefined grant), the S3 bucket ACL resource should be imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`), e.g.,

        ```sh
         $ pulumi import aws:s3/bucketAclV2:BucketAclV2 example bucket-name,123456789012,private
        ```

         [1]https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl

        :param str resource_name: The name of the resource.
        :param BucketAclV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketAclV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_policy: Optional[pulumi.Input[pulumi.InputType['BucketAclV2AccessControlPolicyArgs']]] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketAclV2Args.__new__(BucketAclV2Args)

            __props__.__dict__["access_control_policy"] = access_control_policy
            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
        super(BucketAclV2, __self__).__init__(
            'aws:s3/bucketAclV2:BucketAclV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_control_policy: Optional[pulumi.Input[pulumi.InputType['BucketAclV2AccessControlPolicyArgs']]] = None,
            acl: Optional[pulumi.Input[str]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            expected_bucket_owner: Optional[pulumi.Input[str]] = None) -> 'BucketAclV2':
        """
        Get an existing BucketAclV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['BucketAclV2AccessControlPolicyArgs']] access_control_policy: A configuration block that sets the ACL permissions for an object per grantee documented below.
        :param pulumi.Input[str] acl: The canned ACL to apply to the bucket.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[str] expected_bucket_owner: The account ID of the expected bucket owner.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketAclV2State.__new__(_BucketAclV2State)

        __props__.__dict__["access_control_policy"] = access_control_policy
        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
        return BucketAclV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessControlPolicy")
    def access_control_policy(self) -> pulumi.Output['outputs.BucketAclV2AccessControlPolicy']:
        """
        A configuration block that sets the ACL permissions for an object per grantee documented below.
        """
        return pulumi.get(self, "access_control_policy")

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[str]]:
        """
        The canned ACL to apply to the bucket.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> pulumi.Output[Optional[str]]:
        """
        The account ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

