# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ResolverFirewallRuleArgs', 'ResolverFirewallRule']

@pulumi.input_type
class ResolverFirewallRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 firewall_domain_list_id: pulumi.Input[str],
                 firewall_rule_group_id: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 block_override_dns_type: Optional[pulumi.Input[str]] = None,
                 block_override_domain: Optional[pulumi.Input[str]] = None,
                 block_override_ttl: Optional[pulumi.Input[int]] = None,
                 block_response: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ResolverFirewallRule resource.
        :param pulumi.Input[str] action: The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
        :param pulumi.Input[str] firewall_domain_list_id: The ID of the domain list that you want to use in the rule.
        :param pulumi.Input[str] firewall_rule_group_id: The unique identifier of the firewall rule group where you want to create the rule.
        :param pulumi.Input[int] priority: The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
        :param pulumi.Input[str] block_override_dns_type: The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
        :param pulumi.Input[str] block_override_domain: The custom DNS record to send back in response to the query.
        :param pulumi.Input[int] block_override_ttl: The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
        :param pulumi.Input[str] block_response: The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
        :param pulumi.Input[str] name: A name that lets you identify the rule, to manage and use it.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "firewall_domain_list_id", firewall_domain_list_id)
        pulumi.set(__self__, "firewall_rule_group_id", firewall_rule_group_id)
        pulumi.set(__self__, "priority", priority)
        if block_override_dns_type is not None:
            pulumi.set(__self__, "block_override_dns_type", block_override_dns_type)
        if block_override_domain is not None:
            pulumi.set(__self__, "block_override_domain", block_override_domain)
        if block_override_ttl is not None:
            pulumi.set(__self__, "block_override_ttl", block_override_ttl)
        if block_response is not None:
            pulumi.set(__self__, "block_response", block_response)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="firewallDomainListId")
    def firewall_domain_list_id(self) -> pulumi.Input[str]:
        """
        The ID of the domain list that you want to use in the rule.
        """
        return pulumi.get(self, "firewall_domain_list_id")

    @firewall_domain_list_id.setter
    def firewall_domain_list_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "firewall_domain_list_id", value)

    @property
    @pulumi.getter(name="firewallRuleGroupId")
    def firewall_rule_group_id(self) -> pulumi.Input[str]:
        """
        The unique identifier of the firewall rule group where you want to create the rule.
        """
        return pulumi.get(self, "firewall_rule_group_id")

    @firewall_rule_group_id.setter
    def firewall_rule_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "firewall_rule_group_id", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="blockOverrideDnsType")
    def block_override_dns_type(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
        """
        return pulumi.get(self, "block_override_dns_type")

    @block_override_dns_type.setter
    def block_override_dns_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_override_dns_type", value)

    @property
    @pulumi.getter(name="blockOverrideDomain")
    def block_override_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The custom DNS record to send back in response to the query.
        """
        return pulumi.get(self, "block_override_domain")

    @block_override_domain.setter
    def block_override_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_override_domain", value)

    @property
    @pulumi.getter(name="blockOverrideTtl")
    def block_override_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
        """
        return pulumi.get(self, "block_override_ttl")

    @block_override_ttl.setter
    def block_override_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "block_override_ttl", value)

    @property
    @pulumi.getter(name="blockResponse")
    def block_response(self) -> Optional[pulumi.Input[str]]:
        """
        The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
        """
        return pulumi.get(self, "block_response")

    @block_response.setter
    def block_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_response", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name that lets you identify the rule, to manage and use it.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ResolverFirewallRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 block_override_dns_type: Optional[pulumi.Input[str]] = None,
                 block_override_domain: Optional[pulumi.Input[str]] = None,
                 block_override_ttl: Optional[pulumi.Input[int]] = None,
                 block_response: Optional[pulumi.Input[str]] = None,
                 firewall_domain_list_id: Optional[pulumi.Input[str]] = None,
                 firewall_rule_group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ResolverFirewallRule resources.
        :param pulumi.Input[str] action: The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
        :param pulumi.Input[str] block_override_dns_type: The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
        :param pulumi.Input[str] block_override_domain: The custom DNS record to send back in response to the query.
        :param pulumi.Input[int] block_override_ttl: The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
        :param pulumi.Input[str] block_response: The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
        :param pulumi.Input[str] firewall_domain_list_id: The ID of the domain list that you want to use in the rule.
        :param pulumi.Input[str] firewall_rule_group_id: The unique identifier of the firewall rule group where you want to create the rule.
        :param pulumi.Input[str] name: A name that lets you identify the rule, to manage and use it.
        :param pulumi.Input[int] priority: The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if block_override_dns_type is not None:
            pulumi.set(__self__, "block_override_dns_type", block_override_dns_type)
        if block_override_domain is not None:
            pulumi.set(__self__, "block_override_domain", block_override_domain)
        if block_override_ttl is not None:
            pulumi.set(__self__, "block_override_ttl", block_override_ttl)
        if block_response is not None:
            pulumi.set(__self__, "block_response", block_response)
        if firewall_domain_list_id is not None:
            pulumi.set(__self__, "firewall_domain_list_id", firewall_domain_list_id)
        if firewall_rule_group_id is not None:
            pulumi.set(__self__, "firewall_rule_group_id", firewall_rule_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="blockOverrideDnsType")
    def block_override_dns_type(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
        """
        return pulumi.get(self, "block_override_dns_type")

    @block_override_dns_type.setter
    def block_override_dns_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_override_dns_type", value)

    @property
    @pulumi.getter(name="blockOverrideDomain")
    def block_override_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The custom DNS record to send back in response to the query.
        """
        return pulumi.get(self, "block_override_domain")

    @block_override_domain.setter
    def block_override_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_override_domain", value)

    @property
    @pulumi.getter(name="blockOverrideTtl")
    def block_override_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
        """
        return pulumi.get(self, "block_override_ttl")

    @block_override_ttl.setter
    def block_override_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "block_override_ttl", value)

    @property
    @pulumi.getter(name="blockResponse")
    def block_response(self) -> Optional[pulumi.Input[str]]:
        """
        The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
        """
        return pulumi.get(self, "block_response")

    @block_response.setter
    def block_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_response", value)

    @property
    @pulumi.getter(name="firewallDomainListId")
    def firewall_domain_list_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the domain list that you want to use in the rule.
        """
        return pulumi.get(self, "firewall_domain_list_id")

    @firewall_domain_list_id.setter
    def firewall_domain_list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_domain_list_id", value)

    @property
    @pulumi.getter(name="firewallRuleGroupId")
    def firewall_rule_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the firewall rule group where you want to create the rule.
        """
        return pulumi.get(self, "firewall_rule_group_id")

    @firewall_rule_group_id.setter
    def firewall_rule_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_rule_group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name that lets you identify the rule, to manage and use it.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)


class ResolverFirewallRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 block_override_dns_type: Optional[pulumi.Input[str]] = None,
                 block_override_domain: Optional[pulumi.Input[str]] = None,
                 block_override_ttl: Optional[pulumi.Input[int]] = None,
                 block_response: Optional[pulumi.Input[str]] = None,
                 firewall_domain_list_id: Optional[pulumi.Input[str]] = None,
                 firewall_rule_group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Route 53 Resolver DNS Firewall rule resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_resolver_firewall_domain_list = aws.route53.ResolverFirewallDomainList("exampleResolverFirewallDomainList",
            domains=["example.com"],
            tags={})
        example_resolver_firewall_rule_group = aws.route53.ResolverFirewallRuleGroup("exampleResolverFirewallRuleGroup", tags={})
        example_resolver_firewall_rule = aws.route53.ResolverFirewallRule("exampleResolverFirewallRule",
            action="BLOCK",
            block_override_dns_type="CNAME",
            block_override_domain="example.com",
            block_override_ttl=1,
            block_response="OVERRIDE",
            firewall_domain_list_id=example_resolver_firewall_domain_list.id,
            firewall_rule_group_id=example_resolver_firewall_rule_group.id,
            priority=100)
        ```

        ## Import

         Route 53 Resolver DNS Firewall rules can be imported using the Route 53 Resolver DNS Firewall rule group ID and domain list ID separated by ':', e.g.,

        ```sh
         $ pulumi import aws:route53/resolverFirewallRule:ResolverFirewallRule example rslvr-frg-0123456789abcdef:rslvr-fdl-0123456789abcdef
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
        :param pulumi.Input[str] block_override_dns_type: The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
        :param pulumi.Input[str] block_override_domain: The custom DNS record to send back in response to the query.
        :param pulumi.Input[int] block_override_ttl: The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
        :param pulumi.Input[str] block_response: The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
        :param pulumi.Input[str] firewall_domain_list_id: The ID of the domain list that you want to use in the rule.
        :param pulumi.Input[str] firewall_rule_group_id: The unique identifier of the firewall rule group where you want to create the rule.
        :param pulumi.Input[str] name: A name that lets you identify the rule, to manage and use it.
        :param pulumi.Input[int] priority: The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResolverFirewallRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Route 53 Resolver DNS Firewall rule resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_resolver_firewall_domain_list = aws.route53.ResolverFirewallDomainList("exampleResolverFirewallDomainList",
            domains=["example.com"],
            tags={})
        example_resolver_firewall_rule_group = aws.route53.ResolverFirewallRuleGroup("exampleResolverFirewallRuleGroup", tags={})
        example_resolver_firewall_rule = aws.route53.ResolverFirewallRule("exampleResolverFirewallRule",
            action="BLOCK",
            block_override_dns_type="CNAME",
            block_override_domain="example.com",
            block_override_ttl=1,
            block_response="OVERRIDE",
            firewall_domain_list_id=example_resolver_firewall_domain_list.id,
            firewall_rule_group_id=example_resolver_firewall_rule_group.id,
            priority=100)
        ```

        ## Import

         Route 53 Resolver DNS Firewall rules can be imported using the Route 53 Resolver DNS Firewall rule group ID and domain list ID separated by ':', e.g.,

        ```sh
         $ pulumi import aws:route53/resolverFirewallRule:ResolverFirewallRule example rslvr-frg-0123456789abcdef:rslvr-fdl-0123456789abcdef
        ```

        :param str resource_name: The name of the resource.
        :param ResolverFirewallRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResolverFirewallRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 block_override_dns_type: Optional[pulumi.Input[str]] = None,
                 block_override_domain: Optional[pulumi.Input[str]] = None,
                 block_override_ttl: Optional[pulumi.Input[int]] = None,
                 block_response: Optional[pulumi.Input[str]] = None,
                 firewall_domain_list_id: Optional[pulumi.Input[str]] = None,
                 firewall_rule_group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResolverFirewallRuleArgs.__new__(ResolverFirewallRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["block_override_dns_type"] = block_override_dns_type
            __props__.__dict__["block_override_domain"] = block_override_domain
            __props__.__dict__["block_override_ttl"] = block_override_ttl
            __props__.__dict__["block_response"] = block_response
            if firewall_domain_list_id is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_domain_list_id'")
            __props__.__dict__["firewall_domain_list_id"] = firewall_domain_list_id
            if firewall_rule_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_rule_group_id'")
            __props__.__dict__["firewall_rule_group_id"] = firewall_rule_group_id
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
        super(ResolverFirewallRule, __self__).__init__(
            'aws:route53/resolverFirewallRule:ResolverFirewallRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            block_override_dns_type: Optional[pulumi.Input[str]] = None,
            block_override_domain: Optional[pulumi.Input[str]] = None,
            block_override_ttl: Optional[pulumi.Input[int]] = None,
            block_response: Optional[pulumi.Input[str]] = None,
            firewall_domain_list_id: Optional[pulumi.Input[str]] = None,
            firewall_rule_group_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None) -> 'ResolverFirewallRule':
        """
        Get an existing ResolverFirewallRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
        :param pulumi.Input[str] block_override_dns_type: The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
        :param pulumi.Input[str] block_override_domain: The custom DNS record to send back in response to the query.
        :param pulumi.Input[int] block_override_ttl: The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
        :param pulumi.Input[str] block_response: The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
        :param pulumi.Input[str] firewall_domain_list_id: The ID of the domain list that you want to use in the rule.
        :param pulumi.Input[str] firewall_rule_group_id: The unique identifier of the firewall rule group where you want to create the rule.
        :param pulumi.Input[str] name: A name that lets you identify the rule, to manage and use it.
        :param pulumi.Input[int] priority: The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResolverFirewallRuleState.__new__(_ResolverFirewallRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["block_override_dns_type"] = block_override_dns_type
        __props__.__dict__["block_override_domain"] = block_override_domain
        __props__.__dict__["block_override_ttl"] = block_override_ttl
        __props__.__dict__["block_response"] = block_response
        __props__.__dict__["firewall_domain_list_id"] = firewall_domain_list_id
        __props__.__dict__["firewall_rule_group_id"] = firewall_rule_group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        return ResolverFirewallRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="blockOverrideDnsType")
    def block_override_dns_type(self) -> pulumi.Output[Optional[str]]:
        """
        The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
        """
        return pulumi.get(self, "block_override_dns_type")

    @property
    @pulumi.getter(name="blockOverrideDomain")
    def block_override_domain(self) -> pulumi.Output[Optional[str]]:
        """
        The custom DNS record to send back in response to the query.
        """
        return pulumi.get(self, "block_override_domain")

    @property
    @pulumi.getter(name="blockOverrideTtl")
    def block_override_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
        """
        return pulumi.get(self, "block_override_ttl")

    @property
    @pulumi.getter(name="blockResponse")
    def block_response(self) -> pulumi.Output[Optional[str]]:
        """
        The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
        """
        return pulumi.get(self, "block_response")

    @property
    @pulumi.getter(name="firewallDomainListId")
    def firewall_domain_list_id(self) -> pulumi.Output[str]:
        """
        The ID of the domain list that you want to use in the rule.
        """
        return pulumi.get(self, "firewall_domain_list_id")

    @property
    @pulumi.getter(name="firewallRuleGroupId")
    def firewall_rule_group_id(self) -> pulumi.Output[str]:
        """
        The unique identifier of the firewall rule group where you want to create the rule.
        """
        return pulumi.get(self, "firewall_rule_group_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A name that lets you identify the rule, to manage and use it.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
        """
        return pulumi.get(self, "priority")

