# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DeviceAwsLocation',
    'DeviceLocation',
    'LinkBandwidth',
    'SiteLocation',
    'GetDeviceAwsLocationResult',
    'GetDeviceLocationResult',
    'GetLinkBandwidthResult',
    'GetSiteLocationResult',
]

@pulumi.output_type
class DeviceAwsLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetArn":
            suggest = "subnet_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceAwsLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceAwsLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceAwsLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_arn: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str subnet_arn: The Amazon Resource Name (ARN) of the subnet that the device is located in.
        :param str zone: The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
        if subnet_arn is not None:
            pulumi.set(__self__, "subnet_arn", subnet_arn)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the subnet that the device is located in.
        """
        return pulumi.get(self, "subnet_arn")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DeviceLocation(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 latitude: Optional[str] = None,
                 longitude: Optional[str] = None):
        """
        :param str address: The physical address.
        :param str latitude: The latitude.
        :param str longitude: The longitude.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The physical address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def latitude(self) -> Optional[str]:
        """
        The latitude.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> Optional[str]:
        """
        The longitude.
        """
        return pulumi.get(self, "longitude")


@pulumi.output_type
class LinkBandwidth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadSpeed":
            suggest = "download_speed"
        elif key == "uploadSpeed":
            suggest = "upload_speed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkBandwidth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkBandwidth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkBandwidth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_speed: Optional[int] = None,
                 upload_speed: Optional[int] = None):
        """
        :param int download_speed: Download speed in Mbps.
        :param int upload_speed: Upload speed in Mbps.
        """
        if download_speed is not None:
            pulumi.set(__self__, "download_speed", download_speed)
        if upload_speed is not None:
            pulumi.set(__self__, "upload_speed", upload_speed)

    @property
    @pulumi.getter(name="downloadSpeed")
    def download_speed(self) -> Optional[int]:
        """
        Download speed in Mbps.
        """
        return pulumi.get(self, "download_speed")

    @property
    @pulumi.getter(name="uploadSpeed")
    def upload_speed(self) -> Optional[int]:
        """
        Upload speed in Mbps.
        """
        return pulumi.get(self, "upload_speed")


@pulumi.output_type
class SiteLocation(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 latitude: Optional[str] = None,
                 longitude: Optional[str] = None):
        """
        :param str address: Address of the location.
        :param str latitude: Latitude of the location.
        :param str longitude: Longitude of the location.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Address of the location.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def latitude(self) -> Optional[str]:
        """
        Latitude of the location.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> Optional[str]:
        """
        Longitude of the location.
        """
        return pulumi.get(self, "longitude")


@pulumi.output_type
class GetDeviceAwsLocationResult(dict):
    def __init__(__self__, *,
                 subnet_arn: str,
                 zone: str):
        """
        :param str subnet_arn: The Amazon Resource Name (ARN) of the subnet that the device is located in.
        :param str zone: The Zone that the device is located in.
        """
        pulumi.set(__self__, "subnet_arn", subnet_arn)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the subnet that the device is located in.
        """
        return pulumi.get(self, "subnet_arn")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The Zone that the device is located in.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDeviceLocationResult(dict):
    def __init__(__self__, *,
                 address: str,
                 latitude: str,
                 longitude: str):
        """
        :param str address: The physical address.
        :param str latitude: The latitude.
        :param str longitude: The longitude.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The physical address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def latitude(self) -> str:
        """
        The latitude.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> str:
        """
        The longitude.
        """
        return pulumi.get(self, "longitude")


@pulumi.output_type
class GetLinkBandwidthResult(dict):
    def __init__(__self__, *,
                 download_speed: int,
                 upload_speed: int):
        """
        :param int download_speed: Download speed in Mbps.
        :param int upload_speed: Upload speed in Mbps.
        """
        pulumi.set(__self__, "download_speed", download_speed)
        pulumi.set(__self__, "upload_speed", upload_speed)

    @property
    @pulumi.getter(name="downloadSpeed")
    def download_speed(self) -> int:
        """
        Download speed in Mbps.
        """
        return pulumi.get(self, "download_speed")

    @property
    @pulumi.getter(name="uploadSpeed")
    def upload_speed(self) -> int:
        """
        Upload speed in Mbps.
        """
        return pulumi.get(self, "upload_speed")


@pulumi.output_type
class GetSiteLocationResult(dict):
    def __init__(__self__, *,
                 address: str,
                 latitude: str,
                 longitude: str):
        """
        :param str address: Address of the location.
        :param str latitude: Latitude of the location.
        :param str longitude: Longitude of the location.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Address of the location.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def latitude(self) -> str:
        """
        Latitude of the location.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> str:
        """
        Longitude of the location.
        """
        return pulumi.get(self, "longitude")


