# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLinkResult',
    'AwaitableGetLinkResult',
    'get_link',
    'get_link_output',
]

@pulumi.output_type
class GetLinkResult:
    """
    A collection of values returned by getLink.
    """
    def __init__(__self__, arn=None, bandwidths=None, description=None, global_network_id=None, id=None, link_id=None, provider_name=None, site_id=None, tags=None, type=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if bandwidths and not isinstance(bandwidths, list):
            raise TypeError("Expected argument 'bandwidths' to be a list")
        pulumi.set(__self__, "bandwidths", bandwidths)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if global_network_id and not isinstance(global_network_id, str):
            raise TypeError("Expected argument 'global_network_id' to be a str")
        pulumi.set(__self__, "global_network_id", global_network_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if link_id and not isinstance(link_id, str):
            raise TypeError("Expected argument 'link_id' to be a str")
        pulumi.set(__self__, "link_id", link_id)
        if provider_name and not isinstance(provider_name, str):
            raise TypeError("Expected argument 'provider_name' to be a str")
        pulumi.set(__self__, "provider_name", provider_name)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the link.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def bandwidths(self) -> Sequence['outputs.GetLinkBandwidthResult']:
        """
        The upload speed and download speed of the link as documented below
        """
        return pulumi.get(self, "bandwidths")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the link.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> str:
        return pulumi.get(self, "global_network_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkId")
    def link_id(self) -> str:
        return pulumi.get(self, "link_id")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> str:
        """
        The provider of the link.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        The ID of the site.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Key-value tags for the link.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the link.
        """
        return pulumi.get(self, "type")


class AwaitableGetLinkResult(GetLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLinkResult(
            arn=self.arn,
            bandwidths=self.bandwidths,
            description=self.description,
            global_network_id=self.global_network_id,
            id=self.id,
            link_id=self.link_id,
            provider_name=self.provider_name,
            site_id=self.site_id,
            tags=self.tags,
            type=self.type)


def get_link(global_network_id: Optional[str] = None,
             link_id: Optional[str] = None,
             tags: Optional[Mapping[str, str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLinkResult:
    """
    Retrieve information about a link.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_link(global_network_id=var["global_network_id"],
        link_id=var["link_id"])
    ```


    :param str global_network_id: The ID of the Global Network of the link to retrieve.
    :param str link_id: The id of the specific link to retrieve.
    :param Mapping[str, str] tags: Key-value tags for the link.
    """
    __args__ = dict()
    __args__['globalNetworkId'] = global_network_id
    __args__['linkId'] = link_id
    __args__['tags'] = tags
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:networkmanager/getLink:getLink', __args__, opts=opts, typ=GetLinkResult).value

    return AwaitableGetLinkResult(
        arn=__ret__.arn,
        bandwidths=__ret__.bandwidths,
        description=__ret__.description,
        global_network_id=__ret__.global_network_id,
        id=__ret__.id,
        link_id=__ret__.link_id,
        provider_name=__ret__.provider_name,
        site_id=__ret__.site_id,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_link)
def get_link_output(global_network_id: Optional[pulumi.Input[str]] = None,
                    link_id: Optional[pulumi.Input[str]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLinkResult]:
    """
    Retrieve information about a link.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_link(global_network_id=var["global_network_id"],
        link_id=var["link_id"])
    ```


    :param str global_network_id: The ID of the Global Network of the link to retrieve.
    :param str link_id: The id of the specific link to retrieve.
    :param Mapping[str, str] tags: Key-value tags for the link.
    """
    ...
