# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 broker_node_group_info: pulumi.Input['ClusterBrokerNodeGroupInfoArgs'],
                 kafka_version: pulumi.Input[str],
                 number_of_broker_nodes: pulumi.Input[int],
                 client_authentication: Optional[pulumi.Input['ClusterClientAuthenticationArgs']] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 configuration_info: Optional[pulumi.Input['ClusterConfigurationInfoArgs']] = None,
                 encryption_info: Optional[pulumi.Input['ClusterEncryptionInfoArgs']] = None,
                 enhanced_monitoring: Optional[pulumi.Input[str]] = None,
                 logging_info: Optional[pulumi.Input['ClusterLoggingInfoArgs']] = None,
                 open_monitoring: Optional[pulumi.Input['ClusterOpenMonitoringArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['ClusterBrokerNodeGroupInfoArgs'] broker_node_group_info: Configuration block for the broker nodes of the Kafka cluster.
        :param pulumi.Input[str] kafka_version: Specify the desired Kafka software version.
        :param pulumi.Input[int] number_of_broker_nodes: The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
        :param pulumi.Input['ClusterClientAuthenticationArgs'] client_authentication: Configuration block for specifying a client authentication. See below.
        :param pulumi.Input[str] cluster_name: Name of the MSK cluster.
        :param pulumi.Input['ClusterConfigurationInfoArgs'] configuration_info: Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
        :param pulumi.Input['ClusterEncryptionInfoArgs'] encryption_info: Configuration block for specifying encryption. See below.
        :param pulumi.Input[str] enhanced_monitoring: Specify the desired enhanced MSK CloudWatch monitoring level.  See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
        :param pulumi.Input['ClusterLoggingInfoArgs'] logging_info: Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
        :param pulumi.Input['ClusterOpenMonitoringArgs'] open_monitoring: Configuration block for JMX and Node monitoring for the MSK cluster. See below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "broker_node_group_info", broker_node_group_info)
        pulumi.set(__self__, "kafka_version", kafka_version)
        pulumi.set(__self__, "number_of_broker_nodes", number_of_broker_nodes)
        if client_authentication is not None:
            pulumi.set(__self__, "client_authentication", client_authentication)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if configuration_info is not None:
            pulumi.set(__self__, "configuration_info", configuration_info)
        if encryption_info is not None:
            pulumi.set(__self__, "encryption_info", encryption_info)
        if enhanced_monitoring is not None:
            pulumi.set(__self__, "enhanced_monitoring", enhanced_monitoring)
        if logging_info is not None:
            pulumi.set(__self__, "logging_info", logging_info)
        if open_monitoring is not None:
            pulumi.set(__self__, "open_monitoring", open_monitoring)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="brokerNodeGroupInfo")
    def broker_node_group_info(self) -> pulumi.Input['ClusterBrokerNodeGroupInfoArgs']:
        """
        Configuration block for the broker nodes of the Kafka cluster.
        """
        return pulumi.get(self, "broker_node_group_info")

    @broker_node_group_info.setter
    def broker_node_group_info(self, value: pulumi.Input['ClusterBrokerNodeGroupInfoArgs']):
        pulumi.set(self, "broker_node_group_info", value)

    @property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> pulumi.Input[str]:
        """
        Specify the desired Kafka software version.
        """
        return pulumi.get(self, "kafka_version")

    @kafka_version.setter
    def kafka_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "kafka_version", value)

    @property
    @pulumi.getter(name="numberOfBrokerNodes")
    def number_of_broker_nodes(self) -> pulumi.Input[int]:
        """
        The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
        """
        return pulumi.get(self, "number_of_broker_nodes")

    @number_of_broker_nodes.setter
    def number_of_broker_nodes(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_broker_nodes", value)

    @property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> Optional[pulumi.Input['ClusterClientAuthenticationArgs']]:
        """
        Configuration block for specifying a client authentication. See below.
        """
        return pulumi.get(self, "client_authentication")

    @client_authentication.setter
    def client_authentication(self, value: Optional[pulumi.Input['ClusterClientAuthenticationArgs']]):
        pulumi.set(self, "client_authentication", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the MSK cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="configurationInfo")
    def configuration_info(self) -> Optional[pulumi.Input['ClusterConfigurationInfoArgs']]:
        """
        Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
        """
        return pulumi.get(self, "configuration_info")

    @configuration_info.setter
    def configuration_info(self, value: Optional[pulumi.Input['ClusterConfigurationInfoArgs']]):
        pulumi.set(self, "configuration_info", value)

    @property
    @pulumi.getter(name="encryptionInfo")
    def encryption_info(self) -> Optional[pulumi.Input['ClusterEncryptionInfoArgs']]:
        """
        Configuration block for specifying encryption. See below.
        """
        return pulumi.get(self, "encryption_info")

    @encryption_info.setter
    def encryption_info(self, value: Optional[pulumi.Input['ClusterEncryptionInfoArgs']]):
        pulumi.set(self, "encryption_info", value)

    @property
    @pulumi.getter(name="enhancedMonitoring")
    def enhanced_monitoring(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the desired enhanced MSK CloudWatch monitoring level.  See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
        """
        return pulumi.get(self, "enhanced_monitoring")

    @enhanced_monitoring.setter
    def enhanced_monitoring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enhanced_monitoring", value)

    @property
    @pulumi.getter(name="loggingInfo")
    def logging_info(self) -> Optional[pulumi.Input['ClusterLoggingInfoArgs']]:
        """
        Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
        """
        return pulumi.get(self, "logging_info")

    @logging_info.setter
    def logging_info(self, value: Optional[pulumi.Input['ClusterLoggingInfoArgs']]):
        pulumi.set(self, "logging_info", value)

    @property
    @pulumi.getter(name="openMonitoring")
    def open_monitoring(self) -> Optional[pulumi.Input['ClusterOpenMonitoringArgs']]:
        """
        Configuration block for JMX and Node monitoring for the MSK cluster. See below.
        """
        return pulumi.get(self, "open_monitoring")

    @open_monitoring.setter
    def open_monitoring(self, value: Optional[pulumi.Input['ClusterOpenMonitoringArgs']]):
        pulumi.set(self, "open_monitoring", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 bootstrap_brokers: Optional[pulumi.Input[str]] = None,
                 bootstrap_brokers_sasl_iam: Optional[pulumi.Input[str]] = None,
                 bootstrap_brokers_sasl_scram: Optional[pulumi.Input[str]] = None,
                 bootstrap_brokers_tls: Optional[pulumi.Input[str]] = None,
                 broker_node_group_info: Optional[pulumi.Input['ClusterBrokerNodeGroupInfoArgs']] = None,
                 client_authentication: Optional[pulumi.Input['ClusterClientAuthenticationArgs']] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 configuration_info: Optional[pulumi.Input['ClusterConfigurationInfoArgs']] = None,
                 current_version: Optional[pulumi.Input[str]] = None,
                 encryption_info: Optional[pulumi.Input['ClusterEncryptionInfoArgs']] = None,
                 enhanced_monitoring: Optional[pulumi.Input[str]] = None,
                 kafka_version: Optional[pulumi.Input[str]] = None,
                 logging_info: Optional[pulumi.Input['ClusterLoggingInfoArgs']] = None,
                 number_of_broker_nodes: Optional[pulumi.Input[int]] = None,
                 open_monitoring: Optional[pulumi.Input['ClusterOpenMonitoringArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zookeeper_connect_string: Optional[pulumi.Input[str]] = None,
                 zookeeper_connect_string_tls: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
        :param pulumi.Input[str] bootstrap_brokers: Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
        :param pulumi.Input[str] bootstrap_brokers_sasl_iam: One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        :param pulumi.Input[str] bootstrap_brokers_sasl_scram: One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        :param pulumi.Input[str] bootstrap_brokers_tls: One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        :param pulumi.Input['ClusterBrokerNodeGroupInfoArgs'] broker_node_group_info: Configuration block for the broker nodes of the Kafka cluster.
        :param pulumi.Input['ClusterClientAuthenticationArgs'] client_authentication: Configuration block for specifying a client authentication. See below.
        :param pulumi.Input[str] cluster_name: Name of the MSK cluster.
        :param pulumi.Input['ClusterConfigurationInfoArgs'] configuration_info: Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
        :param pulumi.Input[str] current_version: Current version of the MSK Cluster used for updates, e.g., `K13V1IB3VIYZZH`
               * `encryption_info.0.encryption_at_rest_kms_key_arn` - The ARN of the KMS key used for encryption at rest of the broker data volumes.
        :param pulumi.Input['ClusterEncryptionInfoArgs'] encryption_info: Configuration block for specifying encryption. See below.
        :param pulumi.Input[str] enhanced_monitoring: Specify the desired enhanced MSK CloudWatch monitoring level.  See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
        :param pulumi.Input[str] kafka_version: Specify the desired Kafka software version.
        :param pulumi.Input['ClusterLoggingInfoArgs'] logging_info: Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
        :param pulumi.Input[int] number_of_broker_nodes: The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
        :param pulumi.Input['ClusterOpenMonitoringArgs'] open_monitoring: Configuration block for JMX and Node monitoring for the MSK cluster. See below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] zookeeper_connect_string: A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        :param pulumi.Input[str] zookeeper_connect_string_tls: A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bootstrap_brokers is not None:
            pulumi.set(__self__, "bootstrap_brokers", bootstrap_brokers)
        if bootstrap_brokers_sasl_iam is not None:
            pulumi.set(__self__, "bootstrap_brokers_sasl_iam", bootstrap_brokers_sasl_iam)
        if bootstrap_brokers_sasl_scram is not None:
            pulumi.set(__self__, "bootstrap_brokers_sasl_scram", bootstrap_brokers_sasl_scram)
        if bootstrap_brokers_tls is not None:
            pulumi.set(__self__, "bootstrap_brokers_tls", bootstrap_brokers_tls)
        if broker_node_group_info is not None:
            pulumi.set(__self__, "broker_node_group_info", broker_node_group_info)
        if client_authentication is not None:
            pulumi.set(__self__, "client_authentication", client_authentication)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if configuration_info is not None:
            pulumi.set(__self__, "configuration_info", configuration_info)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if encryption_info is not None:
            pulumi.set(__self__, "encryption_info", encryption_info)
        if enhanced_monitoring is not None:
            pulumi.set(__self__, "enhanced_monitoring", enhanced_monitoring)
        if kafka_version is not None:
            pulumi.set(__self__, "kafka_version", kafka_version)
        if logging_info is not None:
            pulumi.set(__self__, "logging_info", logging_info)
        if number_of_broker_nodes is not None:
            pulumi.set(__self__, "number_of_broker_nodes", number_of_broker_nodes)
        if open_monitoring is not None:
            pulumi.set(__self__, "open_monitoring", open_monitoring)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if zookeeper_connect_string is not None:
            pulumi.set(__self__, "zookeeper_connect_string", zookeeper_connect_string)
        if zookeeper_connect_string_tls is not None:
            pulumi.set(__self__, "zookeeper_connect_string_tls", zookeeper_connect_string_tls)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="bootstrapBrokers")
    def bootstrap_brokers(self) -> Optional[pulumi.Input[str]]:
        """
        Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers")

    @bootstrap_brokers.setter
    def bootstrap_brokers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_brokers", value)

    @property
    @pulumi.getter(name="bootstrapBrokersSaslIam")
    def bootstrap_brokers_sasl_iam(self) -> Optional[pulumi.Input[str]]:
        """
        One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_sasl_iam")

    @bootstrap_brokers_sasl_iam.setter
    def bootstrap_brokers_sasl_iam(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_brokers_sasl_iam", value)

    @property
    @pulumi.getter(name="bootstrapBrokersSaslScram")
    def bootstrap_brokers_sasl_scram(self) -> Optional[pulumi.Input[str]]:
        """
        One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_sasl_scram")

    @bootstrap_brokers_sasl_scram.setter
    def bootstrap_brokers_sasl_scram(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_brokers_sasl_scram", value)

    @property
    @pulumi.getter(name="bootstrapBrokersTls")
    def bootstrap_brokers_tls(self) -> Optional[pulumi.Input[str]]:
        """
        One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_tls")

    @bootstrap_brokers_tls.setter
    def bootstrap_brokers_tls(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_brokers_tls", value)

    @property
    @pulumi.getter(name="brokerNodeGroupInfo")
    def broker_node_group_info(self) -> Optional[pulumi.Input['ClusterBrokerNodeGroupInfoArgs']]:
        """
        Configuration block for the broker nodes of the Kafka cluster.
        """
        return pulumi.get(self, "broker_node_group_info")

    @broker_node_group_info.setter
    def broker_node_group_info(self, value: Optional[pulumi.Input['ClusterBrokerNodeGroupInfoArgs']]):
        pulumi.set(self, "broker_node_group_info", value)

    @property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> Optional[pulumi.Input['ClusterClientAuthenticationArgs']]:
        """
        Configuration block for specifying a client authentication. See below.
        """
        return pulumi.get(self, "client_authentication")

    @client_authentication.setter
    def client_authentication(self, value: Optional[pulumi.Input['ClusterClientAuthenticationArgs']]):
        pulumi.set(self, "client_authentication", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the MSK cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="configurationInfo")
    def configuration_info(self) -> Optional[pulumi.Input['ClusterConfigurationInfoArgs']]:
        """
        Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
        """
        return pulumi.get(self, "configuration_info")

    @configuration_info.setter
    def configuration_info(self, value: Optional[pulumi.Input['ClusterConfigurationInfoArgs']]):
        pulumi.set(self, "configuration_info", value)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[str]]:
        """
        Current version of the MSK Cluster used for updates, e.g., `K13V1IB3VIYZZH`
        * `encryption_info.0.encryption_at_rest_kms_key_arn` - The ARN of the KMS key used for encryption at rest of the broker data volumes.
        """
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_version", value)

    @property
    @pulumi.getter(name="encryptionInfo")
    def encryption_info(self) -> Optional[pulumi.Input['ClusterEncryptionInfoArgs']]:
        """
        Configuration block for specifying encryption. See below.
        """
        return pulumi.get(self, "encryption_info")

    @encryption_info.setter
    def encryption_info(self, value: Optional[pulumi.Input['ClusterEncryptionInfoArgs']]):
        pulumi.set(self, "encryption_info", value)

    @property
    @pulumi.getter(name="enhancedMonitoring")
    def enhanced_monitoring(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the desired enhanced MSK CloudWatch monitoring level.  See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
        """
        return pulumi.get(self, "enhanced_monitoring")

    @enhanced_monitoring.setter
    def enhanced_monitoring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enhanced_monitoring", value)

    @property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the desired Kafka software version.
        """
        return pulumi.get(self, "kafka_version")

    @kafka_version.setter
    def kafka_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_version", value)

    @property
    @pulumi.getter(name="loggingInfo")
    def logging_info(self) -> Optional[pulumi.Input['ClusterLoggingInfoArgs']]:
        """
        Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
        """
        return pulumi.get(self, "logging_info")

    @logging_info.setter
    def logging_info(self, value: Optional[pulumi.Input['ClusterLoggingInfoArgs']]):
        pulumi.set(self, "logging_info", value)

    @property
    @pulumi.getter(name="numberOfBrokerNodes")
    def number_of_broker_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
        """
        return pulumi.get(self, "number_of_broker_nodes")

    @number_of_broker_nodes.setter
    def number_of_broker_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_broker_nodes", value)

    @property
    @pulumi.getter(name="openMonitoring")
    def open_monitoring(self) -> Optional[pulumi.Input['ClusterOpenMonitoringArgs']]:
        """
        Configuration block for JMX and Node monitoring for the MSK cluster. See below.
        """
        return pulumi.get(self, "open_monitoring")

    @open_monitoring.setter
    def open_monitoring(self, value: Optional[pulumi.Input['ClusterOpenMonitoringArgs']]):
        pulumi.set(self, "open_monitoring", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="zookeeperConnectString")
    def zookeeper_connect_string(self) -> Optional[pulumi.Input[str]]:
        """
        A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        """
        return pulumi.get(self, "zookeeper_connect_string")

    @zookeeper_connect_string.setter
    def zookeeper_connect_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zookeeper_connect_string", value)

    @property
    @pulumi.getter(name="zookeeperConnectStringTls")
    def zookeeper_connect_string_tls(self) -> Optional[pulumi.Input[str]]:
        """
        A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        """
        return pulumi.get(self, "zookeeper_connect_string_tls")

    @zookeeper_connect_string_tls.setter
    def zookeeper_connect_string_tls(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zookeeper_connect_string_tls", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broker_node_group_info: Optional[pulumi.Input[pulumi.InputType['ClusterBrokerNodeGroupInfoArgs']]] = None,
                 client_authentication: Optional[pulumi.Input[pulumi.InputType['ClusterClientAuthenticationArgs']]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 configuration_info: Optional[pulumi.Input[pulumi.InputType['ClusterConfigurationInfoArgs']]] = None,
                 encryption_info: Optional[pulumi.Input[pulumi.InputType['ClusterEncryptionInfoArgs']]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[str]] = None,
                 kafka_version: Optional[pulumi.Input[str]] = None,
                 logging_info: Optional[pulumi.Input[pulumi.InputType['ClusterLoggingInfoArgs']]] = None,
                 number_of_broker_nodes: Optional[pulumi.Input[int]] = None,
                 open_monitoring: Optional[pulumi.Input[pulumi.InputType['ClusterOpenMonitoringArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages AWS Managed Streaming for Kafka cluster

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        vpc = aws.ec2.Vpc("vpc", cidr_block="192.168.0.0/22")
        azs = aws.get_availability_zones(state="available")
        subnet_az1 = aws.ec2.Subnet("subnetAz1",
            availability_zone=azs.names[0],
            cidr_block="192.168.0.0/24",
            vpc_id=vpc.id)
        subnet_az2 = aws.ec2.Subnet("subnetAz2",
            availability_zone=azs.names[1],
            cidr_block="192.168.1.0/24",
            vpc_id=vpc.id)
        subnet_az3 = aws.ec2.Subnet("subnetAz3",
            availability_zone=azs.names[2],
            cidr_block="192.168.2.0/24",
            vpc_id=vpc.id)
        sg = aws.ec2.SecurityGroup("sg", vpc_id=vpc.id)
        kms = aws.kms.Key("kms", description="example")
        test = aws.cloudwatch.LogGroup("test")
        bucket = aws.s3.BucketV2("bucket")
        bucket_acl = aws.s3.BucketAclV2("bucketAcl",
            bucket=bucket.id,
            acl="private")
        firehose_role = aws.iam.Role("firehoseRole", assume_role_policy=\"\"\"{
        "Version": "2012-10-17",
        "Statement": [
          {
            "Action": "sts:AssumeRole",
            "Principal": {
              "Service": "firehose.amazonaws.com"
            },
            "Effect": "Allow",
            "Sid": ""
          }
          ]
        }
        \"\"\")
        test_stream = aws.kinesis.FirehoseDeliveryStream("testStream",
            destination="s3",
            s3_configuration=aws.kinesis.FirehoseDeliveryStreamS3ConfigurationArgs(
                role_arn=firehose_role.arn,
                bucket_arn=bucket.arn,
            ),
            tags={
                "LogDeliveryEnabled": "placeholder",
            })
        example = aws.msk.Cluster("example",
            kafka_version="2.4.1",
            number_of_broker_nodes=3,
            broker_node_group_info=aws.msk.ClusterBrokerNodeGroupInfoArgs(
                instance_type="kafka.m5.large",
                ebs_volume_size=1000,
                client_subnets=[
                    subnet_az1.id,
                    subnet_az2.id,
                    subnet_az3.id,
                ],
                security_groups=[sg.id],
            ),
            encryption_info=aws.msk.ClusterEncryptionInfoArgs(
                encryption_at_rest_kms_key_arn=kms.arn,
            ),
            open_monitoring=aws.msk.ClusterOpenMonitoringArgs(
                prometheus=aws.msk.ClusterOpenMonitoringPrometheusArgs(
                    jmx_exporter=aws.msk.ClusterOpenMonitoringPrometheusJmxExporterArgs(
                        enabled_in_broker=True,
                    ),
                    node_exporter=aws.msk.ClusterOpenMonitoringPrometheusNodeExporterArgs(
                        enabled_in_broker=True,
                    ),
                ),
            ),
            logging_info=aws.msk.ClusterLoggingInfoArgs(
                broker_logs=aws.msk.ClusterLoggingInfoBrokerLogsArgs(
                    cloudwatch_logs=aws.msk.ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs(
                        enabled=True,
                        log_group=test.name,
                    ),
                    firehose=aws.msk.ClusterLoggingInfoBrokerLogsFirehoseArgs(
                        enabled=True,
                        delivery_stream=test_stream.name,
                    ),
                    s3=aws.msk.ClusterLoggingInfoBrokerLogsS3Args(
                        enabled=True,
                        bucket=bucket.id,
                        prefix="logs/msk-",
                    ),
                ),
            ),
            tags={
                "foo": "bar",
            })
        pulumi.export("zookeeperConnectString", example.zookeeper_connect_string)
        pulumi.export("bootstrapBrokersTls", example.bootstrap_brokers_tls)
        ```

        ## Import

        MSK clusters can be imported using the cluster `arn`, e.g.,

        ```sh
         $ pulumi import aws:msk/cluster:Cluster example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClusterBrokerNodeGroupInfoArgs']] broker_node_group_info: Configuration block for the broker nodes of the Kafka cluster.
        :param pulumi.Input[pulumi.InputType['ClusterClientAuthenticationArgs']] client_authentication: Configuration block for specifying a client authentication. See below.
        :param pulumi.Input[str] cluster_name: Name of the MSK cluster.
        :param pulumi.Input[pulumi.InputType['ClusterConfigurationInfoArgs']] configuration_info: Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
        :param pulumi.Input[pulumi.InputType['ClusterEncryptionInfoArgs']] encryption_info: Configuration block for specifying encryption. See below.
        :param pulumi.Input[str] enhanced_monitoring: Specify the desired enhanced MSK CloudWatch monitoring level.  See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
        :param pulumi.Input[str] kafka_version: Specify the desired Kafka software version.
        :param pulumi.Input[pulumi.InputType['ClusterLoggingInfoArgs']] logging_info: Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
        :param pulumi.Input[int] number_of_broker_nodes: The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
        :param pulumi.Input[pulumi.InputType['ClusterOpenMonitoringArgs']] open_monitoring: Configuration block for JMX and Node monitoring for the MSK cluster. See below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages AWS Managed Streaming for Kafka cluster

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        vpc = aws.ec2.Vpc("vpc", cidr_block="192.168.0.0/22")
        azs = aws.get_availability_zones(state="available")
        subnet_az1 = aws.ec2.Subnet("subnetAz1",
            availability_zone=azs.names[0],
            cidr_block="192.168.0.0/24",
            vpc_id=vpc.id)
        subnet_az2 = aws.ec2.Subnet("subnetAz2",
            availability_zone=azs.names[1],
            cidr_block="192.168.1.0/24",
            vpc_id=vpc.id)
        subnet_az3 = aws.ec2.Subnet("subnetAz3",
            availability_zone=azs.names[2],
            cidr_block="192.168.2.0/24",
            vpc_id=vpc.id)
        sg = aws.ec2.SecurityGroup("sg", vpc_id=vpc.id)
        kms = aws.kms.Key("kms", description="example")
        test = aws.cloudwatch.LogGroup("test")
        bucket = aws.s3.BucketV2("bucket")
        bucket_acl = aws.s3.BucketAclV2("bucketAcl",
            bucket=bucket.id,
            acl="private")
        firehose_role = aws.iam.Role("firehoseRole", assume_role_policy=\"\"\"{
        "Version": "2012-10-17",
        "Statement": [
          {
            "Action": "sts:AssumeRole",
            "Principal": {
              "Service": "firehose.amazonaws.com"
            },
            "Effect": "Allow",
            "Sid": ""
          }
          ]
        }
        \"\"\")
        test_stream = aws.kinesis.FirehoseDeliveryStream("testStream",
            destination="s3",
            s3_configuration=aws.kinesis.FirehoseDeliveryStreamS3ConfigurationArgs(
                role_arn=firehose_role.arn,
                bucket_arn=bucket.arn,
            ),
            tags={
                "LogDeliveryEnabled": "placeholder",
            })
        example = aws.msk.Cluster("example",
            kafka_version="2.4.1",
            number_of_broker_nodes=3,
            broker_node_group_info=aws.msk.ClusterBrokerNodeGroupInfoArgs(
                instance_type="kafka.m5.large",
                ebs_volume_size=1000,
                client_subnets=[
                    subnet_az1.id,
                    subnet_az2.id,
                    subnet_az3.id,
                ],
                security_groups=[sg.id],
            ),
            encryption_info=aws.msk.ClusterEncryptionInfoArgs(
                encryption_at_rest_kms_key_arn=kms.arn,
            ),
            open_monitoring=aws.msk.ClusterOpenMonitoringArgs(
                prometheus=aws.msk.ClusterOpenMonitoringPrometheusArgs(
                    jmx_exporter=aws.msk.ClusterOpenMonitoringPrometheusJmxExporterArgs(
                        enabled_in_broker=True,
                    ),
                    node_exporter=aws.msk.ClusterOpenMonitoringPrometheusNodeExporterArgs(
                        enabled_in_broker=True,
                    ),
                ),
            ),
            logging_info=aws.msk.ClusterLoggingInfoArgs(
                broker_logs=aws.msk.ClusterLoggingInfoBrokerLogsArgs(
                    cloudwatch_logs=aws.msk.ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs(
                        enabled=True,
                        log_group=test.name,
                    ),
                    firehose=aws.msk.ClusterLoggingInfoBrokerLogsFirehoseArgs(
                        enabled=True,
                        delivery_stream=test_stream.name,
                    ),
                    s3=aws.msk.ClusterLoggingInfoBrokerLogsS3Args(
                        enabled=True,
                        bucket=bucket.id,
                        prefix="logs/msk-",
                    ),
                ),
            ),
            tags={
                "foo": "bar",
            })
        pulumi.export("zookeeperConnectString", example.zookeeper_connect_string)
        pulumi.export("bootstrapBrokersTls", example.bootstrap_brokers_tls)
        ```

        ## Import

        MSK clusters can be imported using the cluster `arn`, e.g.,

        ```sh
         $ pulumi import aws:msk/cluster:Cluster example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broker_node_group_info: Optional[pulumi.Input[pulumi.InputType['ClusterBrokerNodeGroupInfoArgs']]] = None,
                 client_authentication: Optional[pulumi.Input[pulumi.InputType['ClusterClientAuthenticationArgs']]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 configuration_info: Optional[pulumi.Input[pulumi.InputType['ClusterConfigurationInfoArgs']]] = None,
                 encryption_info: Optional[pulumi.Input[pulumi.InputType['ClusterEncryptionInfoArgs']]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[str]] = None,
                 kafka_version: Optional[pulumi.Input[str]] = None,
                 logging_info: Optional[pulumi.Input[pulumi.InputType['ClusterLoggingInfoArgs']]] = None,
                 number_of_broker_nodes: Optional[pulumi.Input[int]] = None,
                 open_monitoring: Optional[pulumi.Input[pulumi.InputType['ClusterOpenMonitoringArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if broker_node_group_info is None and not opts.urn:
                raise TypeError("Missing required property 'broker_node_group_info'")
            __props__.__dict__["broker_node_group_info"] = broker_node_group_info
            __props__.__dict__["client_authentication"] = client_authentication
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["configuration_info"] = configuration_info
            __props__.__dict__["encryption_info"] = encryption_info
            __props__.__dict__["enhanced_monitoring"] = enhanced_monitoring
            if kafka_version is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_version'")
            __props__.__dict__["kafka_version"] = kafka_version
            __props__.__dict__["logging_info"] = logging_info
            if number_of_broker_nodes is None and not opts.urn:
                raise TypeError("Missing required property 'number_of_broker_nodes'")
            __props__.__dict__["number_of_broker_nodes"] = number_of_broker_nodes
            __props__.__dict__["open_monitoring"] = open_monitoring
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["bootstrap_brokers"] = None
            __props__.__dict__["bootstrap_brokers_sasl_iam"] = None
            __props__.__dict__["bootstrap_brokers_sasl_scram"] = None
            __props__.__dict__["bootstrap_brokers_tls"] = None
            __props__.__dict__["current_version"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["zookeeper_connect_string"] = None
            __props__.__dict__["zookeeper_connect_string_tls"] = None
        super(Cluster, __self__).__init__(
            'aws:msk/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            bootstrap_brokers: Optional[pulumi.Input[str]] = None,
            bootstrap_brokers_sasl_iam: Optional[pulumi.Input[str]] = None,
            bootstrap_brokers_sasl_scram: Optional[pulumi.Input[str]] = None,
            bootstrap_brokers_tls: Optional[pulumi.Input[str]] = None,
            broker_node_group_info: Optional[pulumi.Input[pulumi.InputType['ClusterBrokerNodeGroupInfoArgs']]] = None,
            client_authentication: Optional[pulumi.Input[pulumi.InputType['ClusterClientAuthenticationArgs']]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            configuration_info: Optional[pulumi.Input[pulumi.InputType['ClusterConfigurationInfoArgs']]] = None,
            current_version: Optional[pulumi.Input[str]] = None,
            encryption_info: Optional[pulumi.Input[pulumi.InputType['ClusterEncryptionInfoArgs']]] = None,
            enhanced_monitoring: Optional[pulumi.Input[str]] = None,
            kafka_version: Optional[pulumi.Input[str]] = None,
            logging_info: Optional[pulumi.Input[pulumi.InputType['ClusterLoggingInfoArgs']]] = None,
            number_of_broker_nodes: Optional[pulumi.Input[int]] = None,
            open_monitoring: Optional[pulumi.Input[pulumi.InputType['ClusterOpenMonitoringArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            zookeeper_connect_string: Optional[pulumi.Input[str]] = None,
            zookeeper_connect_string_tls: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
        :param pulumi.Input[str] bootstrap_brokers: Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
        :param pulumi.Input[str] bootstrap_brokers_sasl_iam: One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        :param pulumi.Input[str] bootstrap_brokers_sasl_scram: One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        :param pulumi.Input[str] bootstrap_brokers_tls: One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        :param pulumi.Input[pulumi.InputType['ClusterBrokerNodeGroupInfoArgs']] broker_node_group_info: Configuration block for the broker nodes of the Kafka cluster.
        :param pulumi.Input[pulumi.InputType['ClusterClientAuthenticationArgs']] client_authentication: Configuration block for specifying a client authentication. See below.
        :param pulumi.Input[str] cluster_name: Name of the MSK cluster.
        :param pulumi.Input[pulumi.InputType['ClusterConfigurationInfoArgs']] configuration_info: Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
        :param pulumi.Input[str] current_version: Current version of the MSK Cluster used for updates, e.g., `K13V1IB3VIYZZH`
               * `encryption_info.0.encryption_at_rest_kms_key_arn` - The ARN of the KMS key used for encryption at rest of the broker data volumes.
        :param pulumi.Input[pulumi.InputType['ClusterEncryptionInfoArgs']] encryption_info: Configuration block for specifying encryption. See below.
        :param pulumi.Input[str] enhanced_monitoring: Specify the desired enhanced MSK CloudWatch monitoring level.  See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
        :param pulumi.Input[str] kafka_version: Specify the desired Kafka software version.
        :param pulumi.Input[pulumi.InputType['ClusterLoggingInfoArgs']] logging_info: Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
        :param pulumi.Input[int] number_of_broker_nodes: The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
        :param pulumi.Input[pulumi.InputType['ClusterOpenMonitoringArgs']] open_monitoring: Configuration block for JMX and Node monitoring for the MSK cluster. See below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] zookeeper_connect_string: A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        :param pulumi.Input[str] zookeeper_connect_string_tls: A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["bootstrap_brokers"] = bootstrap_brokers
        __props__.__dict__["bootstrap_brokers_sasl_iam"] = bootstrap_brokers_sasl_iam
        __props__.__dict__["bootstrap_brokers_sasl_scram"] = bootstrap_brokers_sasl_scram
        __props__.__dict__["bootstrap_brokers_tls"] = bootstrap_brokers_tls
        __props__.__dict__["broker_node_group_info"] = broker_node_group_info
        __props__.__dict__["client_authentication"] = client_authentication
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["configuration_info"] = configuration_info
        __props__.__dict__["current_version"] = current_version
        __props__.__dict__["encryption_info"] = encryption_info
        __props__.__dict__["enhanced_monitoring"] = enhanced_monitoring
        __props__.__dict__["kafka_version"] = kafka_version
        __props__.__dict__["logging_info"] = logging_info
        __props__.__dict__["number_of_broker_nodes"] = number_of_broker_nodes
        __props__.__dict__["open_monitoring"] = open_monitoring
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["zookeeper_connect_string"] = zookeeper_connect_string
        __props__.__dict__["zookeeper_connect_string_tls"] = zookeeper_connect_string_tls
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bootstrapBrokers")
    def bootstrap_brokers(self) -> pulumi.Output[str]:
        """
        Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers")

    @property
    @pulumi.getter(name="bootstrapBrokersSaslIam")
    def bootstrap_brokers_sasl_iam(self) -> pulumi.Output[str]:
        """
        One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_sasl_iam")

    @property
    @pulumi.getter(name="bootstrapBrokersSaslScram")
    def bootstrap_brokers_sasl_scram(self) -> pulumi.Output[str]:
        """
        One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_sasl_scram")

    @property
    @pulumi.getter(name="bootstrapBrokersTls")
    def bootstrap_brokers_tls(self) -> pulumi.Output[str]:
        """
        One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_tls")

    @property
    @pulumi.getter(name="brokerNodeGroupInfo")
    def broker_node_group_info(self) -> pulumi.Output['outputs.ClusterBrokerNodeGroupInfo']:
        """
        Configuration block for the broker nodes of the Kafka cluster.
        """
        return pulumi.get(self, "broker_node_group_info")

    @property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> pulumi.Output[Optional['outputs.ClusterClientAuthentication']]:
        """
        Configuration block for specifying a client authentication. See below.
        """
        return pulumi.get(self, "client_authentication")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        Name of the MSK cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="configurationInfo")
    def configuration_info(self) -> pulumi.Output[Optional['outputs.ClusterConfigurationInfo']]:
        """
        Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
        """
        return pulumi.get(self, "configuration_info")

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> pulumi.Output[str]:
        """
        Current version of the MSK Cluster used for updates, e.g., `K13V1IB3VIYZZH`
        * `encryption_info.0.encryption_at_rest_kms_key_arn` - The ARN of the KMS key used for encryption at rest of the broker data volumes.
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter(name="encryptionInfo")
    def encryption_info(self) -> pulumi.Output[Optional['outputs.ClusterEncryptionInfo']]:
        """
        Configuration block for specifying encryption. See below.
        """
        return pulumi.get(self, "encryption_info")

    @property
    @pulumi.getter(name="enhancedMonitoring")
    def enhanced_monitoring(self) -> pulumi.Output[Optional[str]]:
        """
        Specify the desired enhanced MSK CloudWatch monitoring level.  See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
        """
        return pulumi.get(self, "enhanced_monitoring")

    @property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> pulumi.Output[str]:
        """
        Specify the desired Kafka software version.
        """
        return pulumi.get(self, "kafka_version")

    @property
    @pulumi.getter(name="loggingInfo")
    def logging_info(self) -> pulumi.Output[Optional['outputs.ClusterLoggingInfo']]:
        """
        Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
        """
        return pulumi.get(self, "logging_info")

    @property
    @pulumi.getter(name="numberOfBrokerNodes")
    def number_of_broker_nodes(self) -> pulumi.Output[int]:
        """
        The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
        """
        return pulumi.get(self, "number_of_broker_nodes")

    @property
    @pulumi.getter(name="openMonitoring")
    def open_monitoring(self) -> pulumi.Output[Optional['outputs.ClusterOpenMonitoring']]:
        """
        Configuration block for JMX and Node monitoring for the MSK cluster. See below.
        """
        return pulumi.get(self, "open_monitoring")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="zookeeperConnectString")
    def zookeeper_connect_string(self) -> pulumi.Output[str]:
        """
        A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        """
        return pulumi.get(self, "zookeeper_connect_string")

    @property
    @pulumi.getter(name="zookeeperConnectStringTls")
    def zookeeper_connect_string_tls(self) -> pulumi.Output[str]:
        """
        A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        """
        return pulumi.get(self, "zookeeper_connect_string_tls")

