# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ClusterClusterEndpointArgs',
    'ClusterShardArgs',
    'ClusterShardNodeArgs',
    'ClusterShardNodeEndpointArgs',
    'ParameterGroupParameterArgs',
    'SnapshotClusterConfigurationArgs',
    'UserAuthenticationModeArgs',
]

@pulumi.input_type
class ClusterClusterEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: DNS hostname of the node.
        :param pulumi.Input[int] port: The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        DNS hostname of the node.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ClusterShardArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeArgs']]]] = None,
                 num_nodes: Optional[pulumi.Input[int]] = None,
                 slots: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of this node.
               * `endpoint`
        :param pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeArgs']]] nodes: Set of nodes in this shard.
        :param pulumi.Input[int] num_nodes: Number of individual nodes in this shard.
        :param pulumi.Input[str] slots: Keyspace for this shard. Example: `0-16383`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if num_nodes is not None:
            pulumi.set(__self__, "num_nodes", num_nodes)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this node.
        * `endpoint`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeArgs']]]]:
        """
        Set of nodes in this shard.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        Number of individual nodes in this shard.
        """
        return pulumi.get(self, "num_nodes")

    @num_nodes.setter
    def num_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_nodes", value)

    @property
    @pulumi.getter
    def slots(self) -> Optional[pulumi.Input[str]]:
        """
        Keyspace for this shard. Example: `0-16383`.
        """
        return pulumi.get(self, "slots")

    @slots.setter
    def slots(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slots", value)


@pulumi.input_type
class ClusterShardNodeArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeEndpointArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] availability_zone: The Availability Zone in which the node resides.
        :param pulumi.Input[str] create_time: The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
        :param pulumi.Input[str] name: Name of this node.
               * `endpoint`
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Availability Zone in which the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeEndpointArgs']]]]:
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this node.
        * `endpoint`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ClusterShardNodeEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: DNS hostname of the node.
        :param pulumi.Input[int] port: The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        DNS hostname of the node.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ParameterGroupParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the parameter.
        :param pulumi.Input[str] value: The value of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SnapshotClusterConfigurationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 num_shards: Optional[pulumi.Input[int]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 snapshot_window: Optional[pulumi.Input[str]] = None,
                 subnet_group_name: Optional[pulumi.Input[str]] = None,
                 topic_arn: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: Description for the cluster.
        :param pulumi.Input[str] engine_version: Version number of the Redis engine used by the cluster.
        :param pulumi.Input[str] maintenance_window: The weekly time range during which maintenance on the cluster is performed.
        :param pulumi.Input[str] name: Name of the cluster.
        :param pulumi.Input[str] node_type: Compute and memory capacity of the nodes in the cluster.
        :param pulumi.Input[int] num_shards: Number of shards in the cluster.
        :param pulumi.Input[str] parameter_group_name: Name of the parameter group associated with the cluster.
        :param pulumi.Input[int] port: Port number on which the cluster accepts connections.
        :param pulumi.Input[int] snapshot_retention_limit: Number of days for which MemoryDB retains automatic snapshots before deleting them.
        :param pulumi.Input[str] snapshot_window: The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
        :param pulumi.Input[str] subnet_group_name: Name of the subnet group used by the cluster.
        :param pulumi.Input[str] topic_arn: ARN of the SNS topic to which cluster notifications are sent.
        :param pulumi.Input[str] vpc_id: The VPC in which the cluster exists.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if num_shards is not None:
            pulumi.set(__self__, "num_shards", num_shards)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if subnet_group_name is not None:
            pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version number of the Redis engine used by the cluster.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        The weekly time range during which maintenance on the cluster is performed.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        Compute and memory capacity of the nodes in the cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[pulumi.Input[int]]:
        """
        Number of shards in the cluster.
        """
        return pulumi.get(self, "num_shards")

    @num_shards.setter
    def num_shards(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_shards", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the parameter group associated with the cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number on which the cluster accepts connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days for which MemoryDB retains automatic snapshots before deleting them.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[str]]:
        """
        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
        """
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_window", value)

    @property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the subnet group used by the cluster.
        """
        return pulumi.get(self, "subnet_group_name")

    @subnet_group_name.setter
    def subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_group_name", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the SNS topic to which cluster notifications are sent.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC in which the cluster exists.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class UserAuthenticationModeArgs:
    def __init__(__self__, *,
                 passwords: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 password_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] passwords: The set of passwords used for authentication. You can create up to two passwords for each user.
        :param pulumi.Input[str] type: Indicates whether the user requires a password to authenticate. Must be set to `password`.
        :param pulumi.Input[int] password_count: The number of passwords belonging to the user.
        """
        pulumi.set(__self__, "passwords", passwords)
        pulumi.set(__self__, "type", type)
        if password_count is not None:
            pulumi.set(__self__, "password_count", password_count)

    @property
    @pulumi.getter
    def passwords(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The set of passwords used for authentication. You can create up to two passwords for each user.
        """
        return pulumi.get(self, "passwords")

    @passwords.setter
    def passwords(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "passwords", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates whether the user requires a password to authenticate. Must be set to `password`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="passwordCount")
    def password_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of passwords belonging to the user.
        """
        return pulumi.get(self, "password_count")

    @password_count.setter
    def password_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "password_count", value)


