# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SigningCertificateArgs', 'SigningCertificate']

@pulumi.input_type
class SigningCertificateArgs:
    def __init__(__self__, *,
                 certificate_body: pulumi.Input[str],
                 user_name: pulumi.Input[str],
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SigningCertificate resource.
        :param pulumi.Input[str] certificate_body: The contents of the signing certificate in PEM-encoded format.
        :param pulumi.Input[str] user_name: The name of the user the signing certificate is for.
        :param pulumi.Input[str] status: The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
        """
        pulumi.set(__self__, "certificate_body", certificate_body)
        pulumi.set(__self__, "user_name", user_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> pulumi.Input[str]:
        """
        The contents of the signing certificate in PEM-encoded format.
        """
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_body", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        The name of the user the signing certificate is for.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _SigningCertificateState:
    def __init__(__self__, *,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SigningCertificate resources.
        :param pulumi.Input[str] certificate_body: The contents of the signing certificate in PEM-encoded format.
        :param pulumi.Input[str] certificate_id: The ID for the signing certificate.
        :param pulumi.Input[str] status: The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
        :param pulumi.Input[str] user_name: The name of the user the signing certificate is for.
        """
        if certificate_body is not None:
            pulumi.set(__self__, "certificate_body", certificate_body)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> Optional[pulumi.Input[str]]:
        """
        The contents of the signing certificate in PEM-encoded format.
        """
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_body", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for the signing certificate.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user the signing certificate is for.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


class SigningCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        IAM Signing Certificates can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:iam/signingCertificate:SigningCertificate certificate IDIDIDIDID:user-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_body: The contents of the signing certificate in PEM-encoded format.
        :param pulumi.Input[str] status: The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
        :param pulumi.Input[str] user_name: The name of the user the signing certificate is for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SigningCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        IAM Signing Certificates can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:iam/signingCertificate:SigningCertificate certificate IDIDIDIDID:user-name
        ```

        :param str resource_name: The name of the resource.
        :param SigningCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SigningCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SigningCertificateArgs.__new__(SigningCertificateArgs)

            if certificate_body is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_body'")
            __props__.__dict__["certificate_body"] = certificate_body
            __props__.__dict__["status"] = status
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["certificate_id"] = None
        super(SigningCertificate, __self__).__init__(
            'aws:iam/signingCertificate:SigningCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_body: Optional[pulumi.Input[str]] = None,
            certificate_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None) -> 'SigningCertificate':
        """
        Get an existing SigningCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_body: The contents of the signing certificate in PEM-encoded format.
        :param pulumi.Input[str] certificate_id: The ID for the signing certificate.
        :param pulumi.Input[str] status: The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
        :param pulumi.Input[str] user_name: The name of the user the signing certificate is for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SigningCertificateState.__new__(_SigningCertificateState)

        __props__.__dict__["certificate_body"] = certificate_body
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["status"] = status
        __props__.__dict__["user_name"] = user_name
        return SigningCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> pulumi.Output[str]:
        """
        The contents of the signing certificate in PEM-encoded format.
        """
        return pulumi.get(self, "certificate_body")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[str]:
        """
        The ID for the signing certificate.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        The name of the user the signing certificate is for.
        """
        return pulumi.get(self, "user_name")

