# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CatalogDatabaseCreateTableDefaultPermission',
    'CatalogDatabaseCreateTableDefaultPermissionPrincipal',
    'CatalogDatabaseTargetDatabase',
    'CatalogTablePartitionIndex',
    'CatalogTablePartitionKey',
    'CatalogTableStorageDescriptor',
    'CatalogTableStorageDescriptorColumn',
    'CatalogTableStorageDescriptorSchemaReference',
    'CatalogTableStorageDescriptorSchemaReferenceSchemaId',
    'CatalogTableStorageDescriptorSerDeInfo',
    'CatalogTableStorageDescriptorSkewedInfo',
    'CatalogTableStorageDescriptorSortColumn',
    'CatalogTableTargetTable',
    'ClassifierCsvClassifier',
    'ClassifierGrokClassifier',
    'ClassifierJsonClassifier',
    'ClassifierXmlClassifier',
    'ConnectionPhysicalConnectionRequirements',
    'CrawlerCatalogTarget',
    'CrawlerDeltaTarget',
    'CrawlerDynamodbTarget',
    'CrawlerJdbcTarget',
    'CrawlerLineageConfiguration',
    'CrawlerMongodbTarget',
    'CrawlerRecrawlPolicy',
    'CrawlerS3Target',
    'CrawlerSchemaChangePolicy',
    'DataCatalogEncryptionSettingsDataCatalogEncryptionSettings',
    'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption',
    'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest',
    'JobCommand',
    'JobExecutionProperty',
    'JobNotificationProperty',
    'MLTransformInputRecordTable',
    'MLTransformParameters',
    'MLTransformParametersFindMatchesParameters',
    'MLTransformSchema',
    'PartitionIndexPartitionIndex',
    'PartitionStorageDescriptor',
    'PartitionStorageDescriptorColumn',
    'PartitionStorageDescriptorSerDeInfo',
    'PartitionStorageDescriptorSkewedInfo',
    'PartitionStorageDescriptorSortColumn',
    'SecurityConfigurationEncryptionConfiguration',
    'SecurityConfigurationEncryptionConfigurationCloudwatchEncryption',
    'SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption',
    'SecurityConfigurationEncryptionConfigurationS3Encryption',
    'TriggerAction',
    'TriggerActionNotificationProperty',
    'TriggerEventBatchingCondition',
    'TriggerPredicate',
    'TriggerPredicateCondition',
    'UserDefinedFunctionResourceUri',
    'GetConnectionPhysicalConnectionRequirementResult',
    'GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingResult',
    'GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryptionResult',
    'GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingEncryptionAtRestResult',
    'GetScriptDagEdgeResult',
    'GetScriptDagNodeResult',
    'GetScriptDagNodeArgResult',
]

@pulumi.output_type
class CatalogDatabaseCreateTableDefaultPermission(dict):
    def __init__(__self__, *,
                 permissions: Optional[Sequence[str]] = None,
                 principal: Optional['outputs.CatalogDatabaseCreateTableDefaultPermissionPrincipal'] = None):
        """
        :param Sequence[str] permissions: The permissions that are granted to the principal.
        :param 'CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs' principal: The principal who is granted permissions.. See `principal` below.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[str]]:
        """
        The permissions that are granted to the principal.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> Optional['outputs.CatalogDatabaseCreateTableDefaultPermissionPrincipal']:
        """
        The principal who is granted permissions.. See `principal` below.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class CatalogDatabaseCreateTableDefaultPermissionPrincipal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakePrincipalIdentifier":
            suggest = "data_lake_principal_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogDatabaseCreateTableDefaultPermissionPrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogDatabaseCreateTableDefaultPermissionPrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogDatabaseCreateTableDefaultPermissionPrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_principal_identifier: Optional[str] = None):
        """
        :param str data_lake_principal_identifier: An identifier for the Lake Formation principal.
        """
        if data_lake_principal_identifier is not None:
            pulumi.set(__self__, "data_lake_principal_identifier", data_lake_principal_identifier)

    @property
    @pulumi.getter(name="dataLakePrincipalIdentifier")
    def data_lake_principal_identifier(self) -> Optional[str]:
        """
        An identifier for the Lake Formation principal.
        """
        return pulumi.get(self, "data_lake_principal_identifier")


@pulumi.output_type
class CatalogDatabaseTargetDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogDatabaseTargetDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogDatabaseTargetDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogDatabaseTargetDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: str,
                 database_name: str):
        """
        :param str catalog_id: ID of the Data Catalog in which the database resides.
        :param str database_name: Name of the catalog database.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        ID of the Data Catalog in which the database resides.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the catalog database.
        """
        return pulumi.get(self, "database_name")


@pulumi.output_type
class CatalogTablePartitionIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "indexStatus":
            suggest = "index_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogTablePartitionIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogTablePartitionIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogTablePartitionIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: str,
                 keys: Sequence[str],
                 index_status: Optional[str] = None):
        """
        :param str index_name: Name of the partition index.
        :param Sequence[str] keys: Keys for the partition index.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "keys", keys)
        if index_status is not None:
            pulumi.set(__self__, "index_status", index_status)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> str:
        """
        Name of the partition index.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        Keys for the partition index.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="indexStatus")
    def index_status(self) -> Optional[str]:
        return pulumi.get(self, "index_status")


@pulumi.output_type
class CatalogTablePartitionKey(dict):
    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: Name of the target table.
        :param str comment: Free-form text comment.
        :param str type: Datatype of data in the Column.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        Free-form text comment.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Datatype of data in the Column.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CatalogTableStorageDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketColumns":
            suggest = "bucket_columns"
        elif key == "inputFormat":
            suggest = "input_format"
        elif key == "numberOfBuckets":
            suggest = "number_of_buckets"
        elif key == "outputFormat":
            suggest = "output_format"
        elif key == "schemaReference":
            suggest = "schema_reference"
        elif key == "serDeInfo":
            suggest = "ser_de_info"
        elif key == "skewedInfo":
            suggest = "skewed_info"
        elif key == "sortColumns":
            suggest = "sort_columns"
        elif key == "storedAsSubDirectories":
            suggest = "stored_as_sub_directories"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogTableStorageDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogTableStorageDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogTableStorageDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_columns: Optional[Sequence[str]] = None,
                 columns: Optional[Sequence['outputs.CatalogTableStorageDescriptorColumn']] = None,
                 compressed: Optional[bool] = None,
                 input_format: Optional[str] = None,
                 location: Optional[str] = None,
                 number_of_buckets: Optional[int] = None,
                 output_format: Optional[str] = None,
                 parameters: Optional[Mapping[str, str]] = None,
                 schema_reference: Optional['outputs.CatalogTableStorageDescriptorSchemaReference'] = None,
                 ser_de_info: Optional['outputs.CatalogTableStorageDescriptorSerDeInfo'] = None,
                 skewed_info: Optional['outputs.CatalogTableStorageDescriptorSkewedInfo'] = None,
                 sort_columns: Optional[Sequence['outputs.CatalogTableStorageDescriptorSortColumn']] = None,
                 stored_as_sub_directories: Optional[bool] = None):
        """
        :param Sequence[str] bucket_columns: List of reducer grouping columns, clustering columns, and bucketing columns in the table.
        :param Sequence['CatalogTableStorageDescriptorColumnArgs'] columns: Configuration block for columns in the table. See `columns` below.
        :param bool compressed: Whether the data in the table is compressed.
        :param str input_format: Input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
        :param str location: Physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
        :param int number_of_buckets: Must be specified if the table contains any dimension columns.
        :param str output_format: Output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
        :param Mapping[str, str] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param 'CatalogTableStorageDescriptorSchemaReferenceArgs' schema_reference: Object that references a schema stored in the AWS Glue Schema Registry. When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference. See Schema Reference below.
        :param 'CatalogTableStorageDescriptorSerDeInfoArgs' ser_de_info: Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
        :param 'CatalogTableStorageDescriptorSkewedInfoArgs' skewed_info: Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
        :param Sequence['CatalogTableStorageDescriptorSortColumnArgs'] sort_columns: Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
        :param bool stored_as_sub_directories: Whether the table data is stored in subdirectories.
        """
        if bucket_columns is not None:
            pulumi.set(__self__, "bucket_columns", bucket_columns)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if compressed is not None:
            pulumi.set(__self__, "compressed", compressed)
        if input_format is not None:
            pulumi.set(__self__, "input_format", input_format)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if number_of_buckets is not None:
            pulumi.set(__self__, "number_of_buckets", number_of_buckets)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schema_reference is not None:
            pulumi.set(__self__, "schema_reference", schema_reference)
        if ser_de_info is not None:
            pulumi.set(__self__, "ser_de_info", ser_de_info)
        if skewed_info is not None:
            pulumi.set(__self__, "skewed_info", skewed_info)
        if sort_columns is not None:
            pulumi.set(__self__, "sort_columns", sort_columns)
        if stored_as_sub_directories is not None:
            pulumi.set(__self__, "stored_as_sub_directories", stored_as_sub_directories)

    @property
    @pulumi.getter(name="bucketColumns")
    def bucket_columns(self) -> Optional[Sequence[str]]:
        """
        List of reducer grouping columns, clustering columns, and bucketing columns in the table.
        """
        return pulumi.get(self, "bucket_columns")

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.CatalogTableStorageDescriptorColumn']]:
        """
        Configuration block for columns in the table. See `columns` below.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def compressed(self) -> Optional[bool]:
        """
        Whether the data in the table is compressed.
        """
        return pulumi.get(self, "compressed")

    @property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> Optional[str]:
        """
        Input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
        """
        return pulumi.get(self, "input_format")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="numberOfBuckets")
    def number_of_buckets(self) -> Optional[int]:
        """
        Must be specified if the table contains any dimension columns.
        """
        return pulumi.get(self, "number_of_buckets")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[str]:
        """
        Output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
        """
        return pulumi.get(self, "output_format")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="schemaReference")
    def schema_reference(self) -> Optional['outputs.CatalogTableStorageDescriptorSchemaReference']:
        """
        Object that references a schema stored in the AWS Glue Schema Registry. When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference. See Schema Reference below.
        """
        return pulumi.get(self, "schema_reference")

    @property
    @pulumi.getter(name="serDeInfo")
    def ser_de_info(self) -> Optional['outputs.CatalogTableStorageDescriptorSerDeInfo']:
        """
        Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
        """
        return pulumi.get(self, "ser_de_info")

    @property
    @pulumi.getter(name="skewedInfo")
    def skewed_info(self) -> Optional['outputs.CatalogTableStorageDescriptorSkewedInfo']:
        """
        Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
        """
        return pulumi.get(self, "skewed_info")

    @property
    @pulumi.getter(name="sortColumns")
    def sort_columns(self) -> Optional[Sequence['outputs.CatalogTableStorageDescriptorSortColumn']]:
        """
        Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
        """
        return pulumi.get(self, "sort_columns")

    @property
    @pulumi.getter(name="storedAsSubDirectories")
    def stored_as_sub_directories(self) -> Optional[bool]:
        """
        Whether the table data is stored in subdirectories.
        """
        return pulumi.get(self, "stored_as_sub_directories")


@pulumi.output_type
class CatalogTableStorageDescriptorColumn(dict):
    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None,
                 parameters: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        :param str name: Name of the target table.
        :param str comment: Free-form text comment.
        :param Mapping[str, str] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param str type: Datatype of data in the Column.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        Free-form text comment.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Datatype of data in the Column.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CatalogTableStorageDescriptorSchemaReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemaVersionNumber":
            suggest = "schema_version_number"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "schemaVersionId":
            suggest = "schema_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogTableStorageDescriptorSchemaReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogTableStorageDescriptorSchemaReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogTableStorageDescriptorSchemaReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema_version_number: int,
                 schema_id: Optional['outputs.CatalogTableStorageDescriptorSchemaReferenceSchemaId'] = None,
                 schema_version_id: Optional[str] = None):
        """
        :param int schema_version_number: Version number of the schema.
        :param 'CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs' schema_id: Configuration block that contains schema identity fields. Either this or the `schema_version_id` has to be provided. See `schema_id` below.
        :param str schema_version_id: Unique ID assigned to a version of the schema. Either this or the `schema_id` has to be provided.
        """
        pulumi.set(__self__, "schema_version_number", schema_version_number)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if schema_version_id is not None:
            pulumi.set(__self__, "schema_version_id", schema_version_id)

    @property
    @pulumi.getter(name="schemaVersionNumber")
    def schema_version_number(self) -> int:
        """
        Version number of the schema.
        """
        return pulumi.get(self, "schema_version_number")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional['outputs.CatalogTableStorageDescriptorSchemaReferenceSchemaId']:
        """
        Configuration block that contains schema identity fields. Either this or the `schema_version_id` has to be provided. See `schema_id` below.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="schemaVersionId")
    def schema_version_id(self) -> Optional[str]:
        """
        Unique ID assigned to a version of the schema. Either this or the `schema_id` has to be provided.
        """
        return pulumi.get(self, "schema_version_id")


@pulumi.output_type
class CatalogTableStorageDescriptorSchemaReferenceSchemaId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryName":
            suggest = "registry_name"
        elif key == "schemaArn":
            suggest = "schema_arn"
        elif key == "schemaName":
            suggest = "schema_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogTableStorageDescriptorSchemaReferenceSchemaId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogTableStorageDescriptorSchemaReferenceSchemaId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogTableStorageDescriptorSchemaReferenceSchemaId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_name: Optional[str] = None,
                 schema_arn: Optional[str] = None,
                 schema_name: Optional[str] = None):
        """
        :param str registry_name: Name of the schema registry that contains the schema. Must be provided when `schema_name` is specified and conflicts with `schema_arn`.
        :param str schema_arn: ARN of the schema. One of `schema_arn` or `schema_name` has to be provided.
        :param str schema_name: Name of the schema. One of `schema_arn` or `schema_name` has to be provided.
        """
        if registry_name is not None:
            pulumi.set(__self__, "registry_name", registry_name)
        if schema_arn is not None:
            pulumi.set(__self__, "schema_arn", schema_arn)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[str]:
        """
        Name of the schema registry that contains the schema. Must be provided when `schema_name` is specified and conflicts with `schema_arn`.
        """
        return pulumi.get(self, "registry_name")

    @property
    @pulumi.getter(name="schemaArn")
    def schema_arn(self) -> Optional[str]:
        """
        ARN of the schema. One of `schema_arn` or `schema_name` has to be provided.
        """
        return pulumi.get(self, "schema_arn")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        Name of the schema. One of `schema_arn` or `schema_name` has to be provided.
        """
        return pulumi.get(self, "schema_name")


@pulumi.output_type
class CatalogTableStorageDescriptorSerDeInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serializationLibrary":
            suggest = "serialization_library"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogTableStorageDescriptorSerDeInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogTableStorageDescriptorSerDeInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogTableStorageDescriptorSerDeInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 parameters: Optional[Mapping[str, str]] = None,
                 serialization_library: Optional[str] = None):
        """
        :param str name: Name of the target table.
        :param Mapping[str, str] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param str serialization_library: Usually the class that implements the SerDe. An example is `org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if serialization_library is not None:
            pulumi.set(__self__, "serialization_library", serialization_library)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="serializationLibrary")
    def serialization_library(self) -> Optional[str]:
        """
        Usually the class that implements the SerDe. An example is `org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe`.
        """
        return pulumi.get(self, "serialization_library")


@pulumi.output_type
class CatalogTableStorageDescriptorSkewedInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "skewedColumnNames":
            suggest = "skewed_column_names"
        elif key == "skewedColumnValueLocationMaps":
            suggest = "skewed_column_value_location_maps"
        elif key == "skewedColumnValues":
            suggest = "skewed_column_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogTableStorageDescriptorSkewedInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogTableStorageDescriptorSkewedInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogTableStorageDescriptorSkewedInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 skewed_column_names: Optional[Sequence[str]] = None,
                 skewed_column_value_location_maps: Optional[Mapping[str, str]] = None,
                 skewed_column_values: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] skewed_column_names: List of names of columns that contain skewed values.
        :param Mapping[str, str] skewed_column_value_location_maps: List of values that appear so frequently as to be considered skewed.
        :param Sequence[str] skewed_column_values: Map of skewed values to the columns that contain them.
        """
        if skewed_column_names is not None:
            pulumi.set(__self__, "skewed_column_names", skewed_column_names)
        if skewed_column_value_location_maps is not None:
            pulumi.set(__self__, "skewed_column_value_location_maps", skewed_column_value_location_maps)
        if skewed_column_values is not None:
            pulumi.set(__self__, "skewed_column_values", skewed_column_values)

    @property
    @pulumi.getter(name="skewedColumnNames")
    def skewed_column_names(self) -> Optional[Sequence[str]]:
        """
        List of names of columns that contain skewed values.
        """
        return pulumi.get(self, "skewed_column_names")

    @property
    @pulumi.getter(name="skewedColumnValueLocationMaps")
    def skewed_column_value_location_maps(self) -> Optional[Mapping[str, str]]:
        """
        List of values that appear so frequently as to be considered skewed.
        """
        return pulumi.get(self, "skewed_column_value_location_maps")

    @property
    @pulumi.getter(name="skewedColumnValues")
    def skewed_column_values(self) -> Optional[Sequence[str]]:
        """
        Map of skewed values to the columns that contain them.
        """
        return pulumi.get(self, "skewed_column_values")


@pulumi.output_type
class CatalogTableStorageDescriptorSortColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sortOrder":
            suggest = "sort_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogTableStorageDescriptorSortColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogTableStorageDescriptorSortColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogTableStorageDescriptorSortColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: str,
                 sort_order: int):
        """
        :param str column: Name of the column.
        :param int sort_order: Whether the column is sorted in ascending (`1`) or descending order (`0`).
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "sort_order", sort_order)

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        Name of the column.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> int:
        """
        Whether the column is sorted in ascending (`1`) or descending order (`0`).
        """
        return pulumi.get(self, "sort_order")


@pulumi.output_type
class CatalogTableTargetTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CatalogTableTargetTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CatalogTableTargetTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CatalogTableTargetTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: str,
                 database_name: str,
                 name: str):
        """
        :param str catalog_id: ID of the Data Catalog in which the table resides.
        :param str database_name: Name of the catalog database that contains the target table.
        :param str name: Name of the target table.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        ID of the Data Catalog in which the table resides.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the catalog database that contains the target table.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ClassifierCsvClassifier(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSingleColumn":
            suggest = "allow_single_column"
        elif key == "containsHeader":
            suggest = "contains_header"
        elif key == "disableValueTrimming":
            suggest = "disable_value_trimming"
        elif key == "quoteSymbol":
            suggest = "quote_symbol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassifierCsvClassifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassifierCsvClassifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassifierCsvClassifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_single_column: Optional[bool] = None,
                 contains_header: Optional[str] = None,
                 delimiter: Optional[str] = None,
                 disable_value_trimming: Optional[bool] = None,
                 headers: Optional[Sequence[str]] = None,
                 quote_symbol: Optional[str] = None):
        """
        :param bool allow_single_column: Enables the processing of files that contain only one column.
        :param str contains_header: Indicates whether the CSV file contains a header. This can be one of "ABSENT", "PRESENT", or "UNKNOWN".
        :param str delimiter: The delimiter used in the Csv to separate columns.
        :param bool disable_value_trimming: Specifies whether to trim column values.
        :param Sequence[str] headers: A list of strings representing column names.
        :param str quote_symbol: A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.
        """
        if allow_single_column is not None:
            pulumi.set(__self__, "allow_single_column", allow_single_column)
        if contains_header is not None:
            pulumi.set(__self__, "contains_header", contains_header)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if disable_value_trimming is not None:
            pulumi.set(__self__, "disable_value_trimming", disable_value_trimming)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if quote_symbol is not None:
            pulumi.set(__self__, "quote_symbol", quote_symbol)

    @property
    @pulumi.getter(name="allowSingleColumn")
    def allow_single_column(self) -> Optional[bool]:
        """
        Enables the processing of files that contain only one column.
        """
        return pulumi.get(self, "allow_single_column")

    @property
    @pulumi.getter(name="containsHeader")
    def contains_header(self) -> Optional[str]:
        """
        Indicates whether the CSV file contains a header. This can be one of "ABSENT", "PRESENT", or "UNKNOWN".
        """
        return pulumi.get(self, "contains_header")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        The delimiter used in the Csv to separate columns.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="disableValueTrimming")
    def disable_value_trimming(self) -> Optional[bool]:
        """
        Specifies whether to trim column values.
        """
        return pulumi.get(self, "disable_value_trimming")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[str]]:
        """
        A list of strings representing column names.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="quoteSymbol")
    def quote_symbol(self) -> Optional[str]:
        """
        A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.
        """
        return pulumi.get(self, "quote_symbol")


@pulumi.output_type
class ClassifierGrokClassifier(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "grokPattern":
            suggest = "grok_pattern"
        elif key == "customPatterns":
            suggest = "custom_patterns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassifierGrokClassifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassifierGrokClassifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassifierGrokClassifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification: str,
                 grok_pattern: str,
                 custom_patterns: Optional[str] = None):
        """
        :param str classification: An identifier of the data format that the classifier matches.
        :param str grok_pattern: The grok pattern used by this classifier.
        :param str custom_patterns: Custom grok patterns used by this classifier.
        """
        pulumi.set(__self__, "classification", classification)
        pulumi.set(__self__, "grok_pattern", grok_pattern)
        if custom_patterns is not None:
            pulumi.set(__self__, "custom_patterns", custom_patterns)

    @property
    @pulumi.getter
    def classification(self) -> str:
        """
        An identifier of the data format that the classifier matches.
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter(name="grokPattern")
    def grok_pattern(self) -> str:
        """
        The grok pattern used by this classifier.
        """
        return pulumi.get(self, "grok_pattern")

    @property
    @pulumi.getter(name="customPatterns")
    def custom_patterns(self) -> Optional[str]:
        """
        Custom grok patterns used by this classifier.
        """
        return pulumi.get(self, "custom_patterns")


@pulumi.output_type
class ClassifierJsonClassifier(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassifierJsonClassifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassifierJsonClassifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassifierJsonClassifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: str):
        """
        :param str json_path: A `JsonPath` string defining the JSON data for the classifier to classify. AWS Glue supports a subset of `JsonPath`, as described in [Writing JsonPath Custom Classifiers](https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
        """
        pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> str:
        """
        A `JsonPath` string defining the JSON data for the classifier to classify. AWS Glue supports a subset of `JsonPath`, as described in [Writing JsonPath Custom Classifiers](https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class ClassifierXmlClassifier(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rowTag":
            suggest = "row_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassifierXmlClassifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassifierXmlClassifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassifierXmlClassifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification: str,
                 row_tag: str):
        """
        :param str classification: An identifier of the data format that the classifier matches.
        :param str row_tag: The XML tag designating the element that contains each record in an XML document being parsed. Note that this cannot identify a self-closing element (closed by `/>`). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, `<row item_a="A" item_b="B"></row>` is okay, but `<row item_a="A" item_b="B" />` is not).
        """
        pulumi.set(__self__, "classification", classification)
        pulumi.set(__self__, "row_tag", row_tag)

    @property
    @pulumi.getter
    def classification(self) -> str:
        """
        An identifier of the data format that the classifier matches.
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter(name="rowTag")
    def row_tag(self) -> str:
        """
        The XML tag designating the element that contains each record in an XML document being parsed. Note that this cannot identify a self-closing element (closed by `/>`). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, `<row item_a="A" item_b="B"></row>` is okay, but `<row item_a="A" item_b="B" />` is not).
        """
        return pulumi.get(self, "row_tag")


@pulumi.output_type
class ConnectionPhysicalConnectionRequirements(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "securityGroupIdLists":
            suggest = "security_group_id_lists"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionPhysicalConnectionRequirements. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionPhysicalConnectionRequirements.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionPhysicalConnectionRequirements.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[str] = None,
                 security_group_id_lists: Optional[Sequence[str]] = None,
                 subnet_id: Optional[str] = None):
        """
        :param str availability_zone: The availability zone of the connection. This field is redundant and implied by `subnet_id`, but is currently an api requirement.
        :param Sequence[str] security_group_id_lists: The security group ID list used by the connection.
        :param str subnet_id: The subnet ID used by the connection.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if security_group_id_lists is not None:
            pulumi.set(__self__, "security_group_id_lists", security_group_id_lists)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        The availability zone of the connection. This field is redundant and implied by `subnet_id`, but is currently an api requirement.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="securityGroupIdLists")
    def security_group_id_lists(self) -> Optional[Sequence[str]]:
        """
        The security group ID list used by the connection.
        """
        return pulumi.get(self, "security_group_id_lists")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The subnet ID used by the connection.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class CrawlerCatalogTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerCatalogTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerCatalogTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerCatalogTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 tables: Sequence[str]):
        """
        :param str database_name: The name of the Glue database to be synchronized.
        :param Sequence[str] tables: A list of catalog tables to be synchronized.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of the Glue database to be synchronized.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def tables(self) -> Sequence[str]:
        """
        A list of catalog tables to be synchronized.
        """
        return pulumi.get(self, "tables")


@pulumi.output_type
class CrawlerDeltaTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"
        elif key == "deltaTables":
            suggest = "delta_tables"
        elif key == "writeManifest":
            suggest = "write_manifest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerDeltaTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerDeltaTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerDeltaTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: str,
                 delta_tables: Sequence[str],
                 write_manifest: bool):
        """
        :param str connection_name: The name of the connection to use to connect to the Delta table target.
        :param Sequence[str] delta_tables: A list of the Amazon S3 paths to the Delta tables.
        :param bool write_manifest: Specifies whether to write the manifest files to the Delta table path.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "delta_tables", delta_tables)
        pulumi.set(__self__, "write_manifest", write_manifest)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> str:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="deltaTables")
    def delta_tables(self) -> Sequence[str]:
        """
        A list of the Amazon S3 paths to the Delta tables.
        """
        return pulumi.get(self, "delta_tables")

    @property
    @pulumi.getter(name="writeManifest")
    def write_manifest(self) -> bool:
        """
        Specifies whether to write the manifest files to the Delta table path.
        """
        return pulumi.get(self, "write_manifest")


@pulumi.output_type
class CrawlerDynamodbTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanAll":
            suggest = "scan_all"
        elif key == "scanRate":
            suggest = "scan_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerDynamodbTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerDynamodbTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerDynamodbTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 scan_all: Optional[bool] = None,
                 scan_rate: Optional[float] = None):
        """
        :param str path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        :param bool scan_all: Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
        :param float scan_rate: The percentage of the configured read capacity units to use by the AWS Glue crawler. The valid values are null or a value between 0.1 to 1.5.
        """
        pulumi.set(__self__, "path", path)
        if scan_all is not None:
            pulumi.set(__self__, "scan_all", scan_all)
        if scan_rate is not None:
            pulumi.set(__self__, "scan_rate", scan_rate)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="scanAll")
    def scan_all(self) -> Optional[bool]:
        """
        Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
        """
        return pulumi.get(self, "scan_all")

    @property
    @pulumi.getter(name="scanRate")
    def scan_rate(self) -> Optional[float]:
        """
        The percentage of the configured read capacity units to use by the AWS Glue crawler. The valid values are null or a value between 0.1 to 1.5.
        """
        return pulumi.get(self, "scan_rate")


@pulumi.output_type
class CrawlerJdbcTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerJdbcTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerJdbcTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerJdbcTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: str,
                 path: str,
                 exclusions: Optional[Sequence[str]] = None):
        """
        :param str connection_name: The name of the connection to use to connect to the Delta table target.
        :param str path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        :param Sequence[str] exclusions: A list of glob patterns used to exclude from the crawl.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "path", path)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> str:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence[str]]:
        """
        A list of glob patterns used to exclude from the crawl.
        """
        return pulumi.get(self, "exclusions")


@pulumi.output_type
class CrawlerLineageConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crawlerLineageSettings":
            suggest = "crawler_lineage_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerLineageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerLineageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerLineageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crawler_lineage_settings: Optional[str] = None):
        """
        :param str crawler_lineage_settings: Specifies whether data lineage is enabled for the crawler. Valid values are: `ENABLE` and `DISABLE`. Default value is `Disable`.
        """
        if crawler_lineage_settings is not None:
            pulumi.set(__self__, "crawler_lineage_settings", crawler_lineage_settings)

    @property
    @pulumi.getter(name="crawlerLineageSettings")
    def crawler_lineage_settings(self) -> Optional[str]:
        """
        Specifies whether data lineage is enabled for the crawler. Valid values are: `ENABLE` and `DISABLE`. Default value is `Disable`.
        """
        return pulumi.get(self, "crawler_lineage_settings")


@pulumi.output_type
class CrawlerMongodbTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"
        elif key == "scanAll":
            suggest = "scan_all"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerMongodbTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerMongodbTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerMongodbTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_name: str,
                 path: str,
                 scan_all: Optional[bool] = None):
        """
        :param str connection_name: The name of the connection to use to connect to the Delta table target.
        :param str path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        :param bool scan_all: Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "path", path)
        if scan_all is not None:
            pulumi.set(__self__, "scan_all", scan_all)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> str:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="scanAll")
    def scan_all(self) -> Optional[bool]:
        """
        Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
        """
        return pulumi.get(self, "scan_all")


@pulumi.output_type
class CrawlerRecrawlPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recrawlBehavior":
            suggest = "recrawl_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerRecrawlPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerRecrawlPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerRecrawlPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recrawl_behavior: Optional[str] = None):
        """
        :param str recrawl_behavior: Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. Valid Values are: `CRAWL_EVERYTHING` and `CRAWL_NEW_FOLDERS_ONLY`. Default value is `CRAWL_EVERYTHING`.
        """
        if recrawl_behavior is not None:
            pulumi.set(__self__, "recrawl_behavior", recrawl_behavior)

    @property
    @pulumi.getter(name="recrawlBehavior")
    def recrawl_behavior(self) -> Optional[str]:
        """
        Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. Valid Values are: `CRAWL_EVERYTHING` and `CRAWL_NEW_FOLDERS_ONLY`. Default value is `CRAWL_EVERYTHING`.
        """
        return pulumi.get(self, "recrawl_behavior")


@pulumi.output_type
class CrawlerS3Target(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionName":
            suggest = "connection_name"
        elif key == "dlqEventQueueArn":
            suggest = "dlq_event_queue_arn"
        elif key == "eventQueueArn":
            suggest = "event_queue_arn"
        elif key == "sampleSize":
            suggest = "sample_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerS3Target. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerS3Target.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerS3Target.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 connection_name: Optional[str] = None,
                 dlq_event_queue_arn: Optional[str] = None,
                 event_queue_arn: Optional[str] = None,
                 exclusions: Optional[Sequence[str]] = None,
                 sample_size: Optional[int] = None):
        """
        :param str path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        :param str connection_name: The name of the connection to use to connect to the Delta table target.
        :param str dlq_event_queue_arn: The ARN of the dead-letter SQS queue.
        :param str event_queue_arn: The ARN of the SQS queue to receive S3 notifications from.
        :param Sequence[str] exclusions: A list of glob patterns used to exclude from the crawl.
        :param int sample_size: Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
        """
        pulumi.set(__self__, "path", path)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if dlq_event_queue_arn is not None:
            pulumi.set(__self__, "dlq_event_queue_arn", dlq_event_queue_arn)
        if event_queue_arn is not None:
            pulumi.set(__self__, "event_queue_arn", event_queue_arn)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[str]:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="dlqEventQueueArn")
    def dlq_event_queue_arn(self) -> Optional[str]:
        """
        The ARN of the dead-letter SQS queue.
        """
        return pulumi.get(self, "dlq_event_queue_arn")

    @property
    @pulumi.getter(name="eventQueueArn")
    def event_queue_arn(self) -> Optional[str]:
        """
        The ARN of the SQS queue to receive S3 notifications from.
        """
        return pulumi.get(self, "event_queue_arn")

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence[str]]:
        """
        A list of glob patterns used to exclude from the crawl.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[int]:
        """
        Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
        """
        return pulumi.get(self, "sample_size")


@pulumi.output_type
class CrawlerSchemaChangePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteBehavior":
            suggest = "delete_behavior"
        elif key == "updateBehavior":
            suggest = "update_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrawlerSchemaChangePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrawlerSchemaChangePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrawlerSchemaChangePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_behavior: Optional[str] = None,
                 update_behavior: Optional[str] = None):
        """
        :param str delete_behavior: The deletion behavior when the crawler finds a deleted object. Valid values: `LOG`, `DELETE_FROM_DATABASE`, or `DEPRECATE_IN_DATABASE`. Defaults to `DEPRECATE_IN_DATABASE`.
        :param str update_behavior: The update behavior when the crawler finds a changed schema. Valid values: `LOG` or `UPDATE_IN_DATABASE`. Defaults to `UPDATE_IN_DATABASE`.
        """
        if delete_behavior is not None:
            pulumi.set(__self__, "delete_behavior", delete_behavior)
        if update_behavior is not None:
            pulumi.set(__self__, "update_behavior", update_behavior)

    @property
    @pulumi.getter(name="deleteBehavior")
    def delete_behavior(self) -> Optional[str]:
        """
        The deletion behavior when the crawler finds a deleted object. Valid values: `LOG`, `DELETE_FROM_DATABASE`, or `DEPRECATE_IN_DATABASE`. Defaults to `DEPRECATE_IN_DATABASE`.
        """
        return pulumi.get(self, "delete_behavior")

    @property
    @pulumi.getter(name="updateBehavior")
    def update_behavior(self) -> Optional[str]:
        """
        The update behavior when the crawler finds a changed schema. Valid values: `LOG` or `UPDATE_IN_DATABASE`. Defaults to `UPDATE_IN_DATABASE`.
        """
        return pulumi.get(self, "update_behavior")


@pulumi.output_type
class DataCatalogEncryptionSettingsDataCatalogEncryptionSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionPasswordEncryption":
            suggest = "connection_password_encryption"
        elif key == "encryptionAtRest":
            suggest = "encryption_at_rest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCatalogEncryptionSettingsDataCatalogEncryptionSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_password_encryption: 'outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption',
                 encryption_at_rest: 'outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest'):
        """
        :param 'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs' connection_password_encryption: When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
        :param 'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs' encryption_at_rest: Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
        """
        pulumi.set(__self__, "connection_password_encryption", connection_password_encryption)
        pulumi.set(__self__, "encryption_at_rest", encryption_at_rest)

    @property
    @pulumi.getter(name="connectionPasswordEncryption")
    def connection_password_encryption(self) -> 'outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption':
        """
        When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
        """
        return pulumi.get(self, "connection_password_encryption")

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> 'outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest':
        """
        Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
        """
        return pulumi.get(self, "encryption_at_rest")


@pulumi.output_type
class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "returnConnectionPasswordEncrypted":
            suggest = "return_connection_password_encrypted"
        elif key == "awsKmsKeyId":
            suggest = "aws_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 return_connection_password_encrypted: bool,
                 aws_kms_key_id: Optional[str] = None):
        """
        :param bool return_connection_password_encrypted: When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
        :param str aws_kms_key_id: A KMS key ARN that is used to encrypt the connection password. If connection password protection is enabled, the caller of CreateConnection and UpdateConnection needs at least `kms:Encrypt` permission on the specified AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
        """
        pulumi.set(__self__, "return_connection_password_encrypted", return_connection_password_encrypted)
        if aws_kms_key_id is not None:
            pulumi.set(__self__, "aws_kms_key_id", aws_kms_key_id)

    @property
    @pulumi.getter(name="returnConnectionPasswordEncrypted")
    def return_connection_password_encrypted(self) -> bool:
        """
        When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
        """
        return pulumi.get(self, "return_connection_password_encrypted")

    @property
    @pulumi.getter(name="awsKmsKeyId")
    def aws_kms_key_id(self) -> Optional[str]:
        """
        A KMS key ARN that is used to encrypt the connection password. If connection password protection is enabled, the caller of CreateConnection and UpdateConnection needs at least `kms:Encrypt` permission on the specified AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
        """
        return pulumi.get(self, "aws_kms_key_id")


@pulumi.output_type
class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogEncryptionMode":
            suggest = "catalog_encryption_mode"
        elif key == "sseAwsKmsKeyId":
            suggest = "sse_aws_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_encryption_mode: str,
                 sse_aws_kms_key_id: Optional[str] = None):
        """
        :param str catalog_encryption_mode: The encryption-at-rest mode for encrypting Data Catalog data. Valid values are `DISABLED` and `SSE-KMS`.
        :param str sse_aws_kms_key_id: The ARN of the AWS KMS key to use for encryption at rest.
        """
        pulumi.set(__self__, "catalog_encryption_mode", catalog_encryption_mode)
        if sse_aws_kms_key_id is not None:
            pulumi.set(__self__, "sse_aws_kms_key_id", sse_aws_kms_key_id)

    @property
    @pulumi.getter(name="catalogEncryptionMode")
    def catalog_encryption_mode(self) -> str:
        """
        The encryption-at-rest mode for encrypting Data Catalog data. Valid values are `DISABLED` and `SSE-KMS`.
        """
        return pulumi.get(self, "catalog_encryption_mode")

    @property
    @pulumi.getter(name="sseAwsKmsKeyId")
    def sse_aws_kms_key_id(self) -> Optional[str]:
        """
        The ARN of the AWS KMS key to use for encryption at rest.
        """
        return pulumi.get(self, "sse_aws_kms_key_id")


@pulumi.output_type
class JobCommand(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptLocation":
            suggest = "script_location"
        elif key == "pythonVersion":
            suggest = "python_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCommand. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCommand.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCommand.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script_location: str,
                 name: Optional[str] = None,
                 python_version: Optional[str] = None):
        """
        :param str script_location: Specifies the S3 path to a script that executes a job.
        :param str name: The name of the job command. Defaults to `glueetl`. Use `pythonshell` for Python Shell Job Type, or `gluestreaming` for Streaming Job Type. `max_capacity` needs to be set if `pythonshell` is chosen.
        :param str python_version: The Python version being used to execute a Python shell job. Allowed values are 2 or 3.
        """
        pulumi.set(__self__, "script_location", script_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)

    @property
    @pulumi.getter(name="scriptLocation")
    def script_location(self) -> str:
        """
        Specifies the S3 path to a script that executes a job.
        """
        return pulumi.get(self, "script_location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the job command. Defaults to `glueetl`. Use `pythonshell` for Python Shell Job Type, or `gluestreaming` for Streaming Job Type. `max_capacity` needs to be set if `pythonshell` is chosen.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[str]:
        """
        The Python version being used to execute a Python shell job. Allowed values are 2 or 3.
        """
        return pulumi.get(self, "python_version")


@pulumi.output_type
class JobExecutionProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrentRuns":
            suggest = "max_concurrent_runs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobExecutionProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobExecutionProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobExecutionProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrent_runs: Optional[int] = None):
        """
        :param int max_concurrent_runs: The maximum number of concurrent runs allowed for a job. The default is 1.
        """
        if max_concurrent_runs is not None:
            pulumi.set(__self__, "max_concurrent_runs", max_concurrent_runs)

    @property
    @pulumi.getter(name="maxConcurrentRuns")
    def max_concurrent_runs(self) -> Optional[int]:
        """
        The maximum number of concurrent runs allowed for a job. The default is 1.
        """
        return pulumi.get(self, "max_concurrent_runs")


@pulumi.output_type
class JobNotificationProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notifyDelayAfter":
            suggest = "notify_delay_after"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobNotificationProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobNotificationProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobNotificationProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notify_delay_after: Optional[int] = None):
        """
        :param int notify_delay_after: After a job run starts, the number of minutes to wait before sending a job run delay notification.
        """
        if notify_delay_after is not None:
            pulumi.set(__self__, "notify_delay_after", notify_delay_after)

    @property
    @pulumi.getter(name="notifyDelayAfter")
    def notify_delay_after(self) -> Optional[int]:
        """
        After a job run starts, the number of minutes to wait before sending a job run delay notification.
        """
        return pulumi.get(self, "notify_delay_after")


@pulumi.output_type
class MLTransformInputRecordTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "catalogId":
            suggest = "catalog_id"
        elif key == "connectionName":
            suggest = "connection_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLTransformInputRecordTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLTransformInputRecordTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLTransformInputRecordTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 table_name: str,
                 catalog_id: Optional[str] = None,
                 connection_name: Optional[str] = None):
        """
        :param str database_name: A database name in the AWS Glue Data Catalog.
        :param str table_name: A table name in the AWS Glue Data Catalog.
        :param str catalog_id: A unique identifier for the AWS Glue Data Catalog.
        :param str connection_name: The name of the connection to the AWS Glue Data Catalog.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        A database name in the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        A table name in the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        A unique identifier for the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[str]:
        """
        The name of the connection to the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "connection_name")


@pulumi.output_type
class MLTransformParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "findMatchesParameters":
            suggest = "find_matches_parameters"
        elif key == "transformType":
            suggest = "transform_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLTransformParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLTransformParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLTransformParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 find_matches_parameters: 'outputs.MLTransformParametersFindMatchesParameters',
                 transform_type: str):
        """
        :param 'MLTransformParametersFindMatchesParametersArgs' find_matches_parameters: The parameters for the find matches algorithm. see Find Matches Parameters.
        :param str transform_type: The type of machine learning transform. For information about the types of machine learning transforms, see [Creating Machine Learning Transforms](http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
        """
        pulumi.set(__self__, "find_matches_parameters", find_matches_parameters)
        pulumi.set(__self__, "transform_type", transform_type)

    @property
    @pulumi.getter(name="findMatchesParameters")
    def find_matches_parameters(self) -> 'outputs.MLTransformParametersFindMatchesParameters':
        """
        The parameters for the find matches algorithm. see Find Matches Parameters.
        """
        return pulumi.get(self, "find_matches_parameters")

    @property
    @pulumi.getter(name="transformType")
    def transform_type(self) -> str:
        """
        The type of machine learning transform. For information about the types of machine learning transforms, see [Creating Machine Learning Transforms](http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
        """
        return pulumi.get(self, "transform_type")


@pulumi.output_type
class MLTransformParametersFindMatchesParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accuracyCostTradeOff":
            suggest = "accuracy_cost_trade_off"
        elif key == "enforceProvidedLabels":
            suggest = "enforce_provided_labels"
        elif key == "precisionRecallTradeOff":
            suggest = "precision_recall_trade_off"
        elif key == "primaryKeyColumnName":
            suggest = "primary_key_column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLTransformParametersFindMatchesParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLTransformParametersFindMatchesParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLTransformParametersFindMatchesParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accuracy_cost_trade_off: Optional[float] = None,
                 enforce_provided_labels: Optional[bool] = None,
                 precision_recall_trade_off: Optional[float] = None,
                 primary_key_column_name: Optional[str] = None):
        """
        :param float accuracy_cost_trade_off: The value that is selected when tuning your transform for a balance between accuracy and cost.
        :param bool enforce_provided_labels: The value to switch on or off to force the output to match the provided labels from users.
        :param float precision_recall_trade_off: The value selected when tuning your transform for a balance between precision and recall.
        :param str primary_key_column_name: The name of a column that uniquely identifies rows in the source table.
        """
        if accuracy_cost_trade_off is not None:
            pulumi.set(__self__, "accuracy_cost_trade_off", accuracy_cost_trade_off)
        if enforce_provided_labels is not None:
            pulumi.set(__self__, "enforce_provided_labels", enforce_provided_labels)
        if precision_recall_trade_off is not None:
            pulumi.set(__self__, "precision_recall_trade_off", precision_recall_trade_off)
        if primary_key_column_name is not None:
            pulumi.set(__self__, "primary_key_column_name", primary_key_column_name)

    @property
    @pulumi.getter(name="accuracyCostTradeOff")
    def accuracy_cost_trade_off(self) -> Optional[float]:
        """
        The value that is selected when tuning your transform for a balance between accuracy and cost.
        """
        return pulumi.get(self, "accuracy_cost_trade_off")

    @property
    @pulumi.getter(name="enforceProvidedLabels")
    def enforce_provided_labels(self) -> Optional[bool]:
        """
        The value to switch on or off to force the output to match the provided labels from users.
        """
        return pulumi.get(self, "enforce_provided_labels")

    @property
    @pulumi.getter(name="precisionRecallTradeOff")
    def precision_recall_trade_off(self) -> Optional[float]:
        """
        The value selected when tuning your transform for a balance between precision and recall.
        """
        return pulumi.get(self, "precision_recall_trade_off")

    @property
    @pulumi.getter(name="primaryKeyColumnName")
    def primary_key_column_name(self) -> Optional[str]:
        """
        The name of a column that uniquely identifies rows in the source table.
        """
        return pulumi.get(self, "primary_key_column_name")


@pulumi.output_type
class MLTransformSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLTransformSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLTransformSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLTransformSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str data_type: The type of data in the column.
        :param str name: The name you assign to this ML Transform. It must be unique in your account.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The type of data in the column.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name you assign to this ML Transform. It must be unique in your account.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PartitionIndexPartitionIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "indexStatus":
            suggest = "index_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PartitionIndexPartitionIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PartitionIndexPartitionIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PartitionIndexPartitionIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: Optional[str] = None,
                 index_status: Optional[str] = None,
                 keys: Optional[Sequence[str]] = None):
        """
        :param str index_name: Name of the partition index.
        :param Sequence[str] keys: Keys for the partition index.
        """
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)
        if index_status is not None:
            pulumi.set(__self__, "index_status", index_status)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        """
        Name of the partition index.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="indexStatus")
    def index_status(self) -> Optional[str]:
        return pulumi.get(self, "index_status")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        Keys for the partition index.
        """
        return pulumi.get(self, "keys")


@pulumi.output_type
class PartitionStorageDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketColumns":
            suggest = "bucket_columns"
        elif key == "inputFormat":
            suggest = "input_format"
        elif key == "numberOfBuckets":
            suggest = "number_of_buckets"
        elif key == "outputFormat":
            suggest = "output_format"
        elif key == "serDeInfo":
            suggest = "ser_de_info"
        elif key == "skewedInfo":
            suggest = "skewed_info"
        elif key == "sortColumns":
            suggest = "sort_columns"
        elif key == "storedAsSubDirectories":
            suggest = "stored_as_sub_directories"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PartitionStorageDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PartitionStorageDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PartitionStorageDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_columns: Optional[Sequence[str]] = None,
                 columns: Optional[Sequence['outputs.PartitionStorageDescriptorColumn']] = None,
                 compressed: Optional[bool] = None,
                 input_format: Optional[str] = None,
                 location: Optional[str] = None,
                 number_of_buckets: Optional[int] = None,
                 output_format: Optional[str] = None,
                 parameters: Optional[Mapping[str, str]] = None,
                 ser_de_info: Optional['outputs.PartitionStorageDescriptorSerDeInfo'] = None,
                 skewed_info: Optional['outputs.PartitionStorageDescriptorSkewedInfo'] = None,
                 sort_columns: Optional[Sequence['outputs.PartitionStorageDescriptorSortColumn']] = None,
                 stored_as_sub_directories: Optional[bool] = None):
        """
        :param Sequence[str] bucket_columns: A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
        :param Sequence['PartitionStorageDescriptorColumnArgs'] columns: A list of the Columns in the table.
        :param bool compressed: True if the data in the table is compressed, or False if not.
        :param str input_format: The input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
        :param str location: The physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
        :param int number_of_buckets: Must be specified if the table contains any dimension columns.
        :param str output_format: The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
        :param Mapping[str, str] parameters: A map of initialization parameters for the SerDe, in key-value form.
        :param 'PartitionStorageDescriptorSerDeInfoArgs' ser_de_info: Serialization/deserialization (SerDe) information.
        :param 'PartitionStorageDescriptorSkewedInfoArgs' skewed_info: Information about values that appear very frequently in a column (skewed values).
        :param Sequence['PartitionStorageDescriptorSortColumnArgs'] sort_columns: A list of Order objects specifying the sort order of each bucket in the table.
        :param bool stored_as_sub_directories: True if the table data is stored in subdirectories, or False if not.
        """
        if bucket_columns is not None:
            pulumi.set(__self__, "bucket_columns", bucket_columns)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if compressed is not None:
            pulumi.set(__self__, "compressed", compressed)
        if input_format is not None:
            pulumi.set(__self__, "input_format", input_format)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if number_of_buckets is not None:
            pulumi.set(__self__, "number_of_buckets", number_of_buckets)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if ser_de_info is not None:
            pulumi.set(__self__, "ser_de_info", ser_de_info)
        if skewed_info is not None:
            pulumi.set(__self__, "skewed_info", skewed_info)
        if sort_columns is not None:
            pulumi.set(__self__, "sort_columns", sort_columns)
        if stored_as_sub_directories is not None:
            pulumi.set(__self__, "stored_as_sub_directories", stored_as_sub_directories)

    @property
    @pulumi.getter(name="bucketColumns")
    def bucket_columns(self) -> Optional[Sequence[str]]:
        """
        A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
        """
        return pulumi.get(self, "bucket_columns")

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.PartitionStorageDescriptorColumn']]:
        """
        A list of the Columns in the table.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def compressed(self) -> Optional[bool]:
        """
        True if the data in the table is compressed, or False if not.
        """
        return pulumi.get(self, "compressed")

    @property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> Optional[str]:
        """
        The input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
        """
        return pulumi.get(self, "input_format")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="numberOfBuckets")
    def number_of_buckets(self) -> Optional[int]:
        """
        Must be specified if the table contains any dimension columns.
        """
        return pulumi.get(self, "number_of_buckets")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[str]:
        """
        The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
        """
        return pulumi.get(self, "output_format")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        A map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="serDeInfo")
    def ser_de_info(self) -> Optional['outputs.PartitionStorageDescriptorSerDeInfo']:
        """
        Serialization/deserialization (SerDe) information.
        """
        return pulumi.get(self, "ser_de_info")

    @property
    @pulumi.getter(name="skewedInfo")
    def skewed_info(self) -> Optional['outputs.PartitionStorageDescriptorSkewedInfo']:
        """
        Information about values that appear very frequently in a column (skewed values).
        """
        return pulumi.get(self, "skewed_info")

    @property
    @pulumi.getter(name="sortColumns")
    def sort_columns(self) -> Optional[Sequence['outputs.PartitionStorageDescriptorSortColumn']]:
        """
        A list of Order objects specifying the sort order of each bucket in the table.
        """
        return pulumi.get(self, "sort_columns")

    @property
    @pulumi.getter(name="storedAsSubDirectories")
    def stored_as_sub_directories(self) -> Optional[bool]:
        """
        True if the table data is stored in subdirectories, or False if not.
        """
        return pulumi.get(self, "stored_as_sub_directories")


@pulumi.output_type
class PartitionStorageDescriptorColumn(dict):
    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: Name of the SerDe.
        :param str comment: Free-form text comment.
        :param str type: The datatype of data in the Column.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the SerDe.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        Free-form text comment.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The datatype of data in the Column.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PartitionStorageDescriptorSerDeInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serializationLibrary":
            suggest = "serialization_library"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PartitionStorageDescriptorSerDeInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PartitionStorageDescriptorSerDeInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PartitionStorageDescriptorSerDeInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 parameters: Optional[Mapping[str, str]] = None,
                 serialization_library: Optional[str] = None):
        """
        :param str name: Name of the SerDe.
        :param Mapping[str, str] parameters: A map of initialization parameters for the SerDe, in key-value form.
        :param str serialization_library: Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if serialization_library is not None:
            pulumi.set(__self__, "serialization_library", serialization_library)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the SerDe.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        A map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="serializationLibrary")
    def serialization_library(self) -> Optional[str]:
        """
        Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
        """
        return pulumi.get(self, "serialization_library")


@pulumi.output_type
class PartitionStorageDescriptorSkewedInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "skewedColumnNames":
            suggest = "skewed_column_names"
        elif key == "skewedColumnValueLocationMaps":
            suggest = "skewed_column_value_location_maps"
        elif key == "skewedColumnValues":
            suggest = "skewed_column_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PartitionStorageDescriptorSkewedInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PartitionStorageDescriptorSkewedInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PartitionStorageDescriptorSkewedInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 skewed_column_names: Optional[Sequence[str]] = None,
                 skewed_column_value_location_maps: Optional[Mapping[str, str]] = None,
                 skewed_column_values: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] skewed_column_names: A list of names of columns that contain skewed values.
        :param Mapping[str, str] skewed_column_value_location_maps: A list of values that appear so frequently as to be considered skewed.
        :param Sequence[str] skewed_column_values: A map of skewed values to the columns that contain them.
        """
        if skewed_column_names is not None:
            pulumi.set(__self__, "skewed_column_names", skewed_column_names)
        if skewed_column_value_location_maps is not None:
            pulumi.set(__self__, "skewed_column_value_location_maps", skewed_column_value_location_maps)
        if skewed_column_values is not None:
            pulumi.set(__self__, "skewed_column_values", skewed_column_values)

    @property
    @pulumi.getter(name="skewedColumnNames")
    def skewed_column_names(self) -> Optional[Sequence[str]]:
        """
        A list of names of columns that contain skewed values.
        """
        return pulumi.get(self, "skewed_column_names")

    @property
    @pulumi.getter(name="skewedColumnValueLocationMaps")
    def skewed_column_value_location_maps(self) -> Optional[Mapping[str, str]]:
        """
        A list of values that appear so frequently as to be considered skewed.
        """
        return pulumi.get(self, "skewed_column_value_location_maps")

    @property
    @pulumi.getter(name="skewedColumnValues")
    def skewed_column_values(self) -> Optional[Sequence[str]]:
        """
        A map of skewed values to the columns that contain them.
        """
        return pulumi.get(self, "skewed_column_values")


@pulumi.output_type
class PartitionStorageDescriptorSortColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sortOrder":
            suggest = "sort_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PartitionStorageDescriptorSortColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PartitionStorageDescriptorSortColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PartitionStorageDescriptorSortColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: str,
                 sort_order: int):
        """
        :param str column: The name of the column.
        :param int sort_order: Indicates that the column is sorted in ascending order (== 1), or in descending order (==0).
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "sort_order", sort_order)

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        The name of the column.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> int:
        """
        Indicates that the column is sorted in ascending order (== 1), or in descending order (==0).
        """
        return pulumi.get(self, "sort_order")


@pulumi.output_type
class SecurityConfigurationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchEncryption":
            suggest = "cloudwatch_encryption"
        elif key == "jobBookmarksEncryption":
            suggest = "job_bookmarks_encryption"
        elif key == "s3Encryption":
            suggest = "s3_encryption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityConfigurationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityConfigurationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityConfigurationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_encryption: 'outputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryption',
                 job_bookmarks_encryption: 'outputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption',
                 s3_encryption: 'outputs.SecurityConfigurationEncryptionConfigurationS3Encryption'):
        """
        :param 'SecurityConfigurationEncryptionConfigurationS3EncryptionArgs' s3_encryption: A `s3_encryption ` block as described below, which contains encryption configuration for S3 data.
        """
        pulumi.set(__self__, "cloudwatch_encryption", cloudwatch_encryption)
        pulumi.set(__self__, "job_bookmarks_encryption", job_bookmarks_encryption)
        pulumi.set(__self__, "s3_encryption", s3_encryption)

    @property
    @pulumi.getter(name="cloudwatchEncryption")
    def cloudwatch_encryption(self) -> 'outputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryption':
        return pulumi.get(self, "cloudwatch_encryption")

    @property
    @pulumi.getter(name="jobBookmarksEncryption")
    def job_bookmarks_encryption(self) -> 'outputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption':
        return pulumi.get(self, "job_bookmarks_encryption")

    @property
    @pulumi.getter(name="s3Encryption")
    def s3_encryption(self) -> 'outputs.SecurityConfigurationEncryptionConfigurationS3Encryption':
        """
        A `s3_encryption ` block as described below, which contains encryption configuration for S3 data.
        """
        return pulumi.get(self, "s3_encryption")


@pulumi.output_type
class SecurityConfigurationEncryptionConfigurationCloudwatchEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchEncryptionMode":
            suggest = "cloudwatch_encryption_mode"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityConfigurationEncryptionConfigurationCloudwatchEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityConfigurationEncryptionConfigurationCloudwatchEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityConfigurationEncryptionConfigurationCloudwatchEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_encryption_mode: Optional[str] = None,
                 kms_key_arn: Optional[str] = None):
        """
        :param str cloudwatch_encryption_mode: Encryption mode to use for CloudWatch data. Valid values: `DISABLED`, `SSE-KMS`. Default value: `DISABLED`.
        :param str kms_key_arn: Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        if cloudwatch_encryption_mode is not None:
            pulumi.set(__self__, "cloudwatch_encryption_mode", cloudwatch_encryption_mode)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="cloudwatchEncryptionMode")
    def cloudwatch_encryption_mode(self) -> Optional[str]:
        """
        Encryption mode to use for CloudWatch data. Valid values: `DISABLED`, `SSE-KMS`. Default value: `DISABLED`.
        """
        return pulumi.get(self, "cloudwatch_encryption_mode")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobBookmarksEncryptionMode":
            suggest = "job_bookmarks_encryption_mode"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityConfigurationEncryptionConfigurationJobBookmarksEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_bookmarks_encryption_mode: Optional[str] = None,
                 kms_key_arn: Optional[str] = None):
        """
        :param str job_bookmarks_encryption_mode: Encryption mode to use for job bookmarks data. Valid values: `CSE-KMS`, `DISABLED`. Default value: `DISABLED`.
        :param str kms_key_arn: Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        if job_bookmarks_encryption_mode is not None:
            pulumi.set(__self__, "job_bookmarks_encryption_mode", job_bookmarks_encryption_mode)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="jobBookmarksEncryptionMode")
    def job_bookmarks_encryption_mode(self) -> Optional[str]:
        """
        Encryption mode to use for job bookmarks data. Valid values: `CSE-KMS`, `DISABLED`. Default value: `DISABLED`.
        """
        return pulumi.get(self, "job_bookmarks_encryption_mode")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class SecurityConfigurationEncryptionConfigurationS3Encryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "s3EncryptionMode":
            suggest = "s3_encryption_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityConfigurationEncryptionConfigurationS3Encryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityConfigurationEncryptionConfigurationS3Encryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityConfigurationEncryptionConfigurationS3Encryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_arn: Optional[str] = None,
                 s3_encryption_mode: Optional[str] = None):
        """
        :param str kms_key_arn: Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        :param str s3_encryption_mode: Encryption mode to use for S3 data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-S3`. Default value: `DISABLED`.
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if s3_encryption_mode is not None:
            pulumi.set(__self__, "s3_encryption_mode", s3_encryption_mode)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="s3EncryptionMode")
    def s3_encryption_mode(self) -> Optional[str]:
        """
        Encryption mode to use for S3 data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-S3`. Default value: `DISABLED`.
        """
        return pulumi.get(self, "s3_encryption_mode")


@pulumi.output_type
class TriggerAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crawlerName":
            suggest = "crawler_name"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "notificationProperty":
            suggest = "notification_property"
        elif key == "securityConfiguration":
            suggest = "security_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arguments: Optional[Mapping[str, str]] = None,
                 crawler_name: Optional[str] = None,
                 job_name: Optional[str] = None,
                 notification_property: Optional['outputs.TriggerActionNotificationProperty'] = None,
                 security_configuration: Optional[str] = None,
                 timeout: Optional[int] = None):
        """
        :param Mapping[str, str] arguments: Arguments to be passed to the job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.
        :param str crawler_name: The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
        :param str job_name: The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
        :param 'TriggerActionNotificationPropertyArgs' notification_property: Specifies configuration properties of a job run notification. See Notification Property details below.
        :param str security_configuration: The name of the Security Configuration structure to be used with this action.
        :param int timeout: The job run timeout in minutes. It overrides the timeout value of the job.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if crawler_name is not None:
            pulumi.set(__self__, "crawler_name", crawler_name)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if notification_property is not None:
            pulumi.set(__self__, "notification_property", notification_property)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Mapping[str, str]]:
        """
        Arguments to be passed to the job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="crawlerName")
    def crawler_name(self) -> Optional[str]:
        """
        The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
        """
        return pulumi.get(self, "crawler_name")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[str]:
        """
        The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> Optional['outputs.TriggerActionNotificationProperty']:
        """
        Specifies configuration properties of a job run notification. See Notification Property details below.
        """
        return pulumi.get(self, "notification_property")

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[str]:
        """
        The name of the Security Configuration structure to be used with this action.
        """
        return pulumi.get(self, "security_configuration")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The job run timeout in minutes. It overrides the timeout value of the job.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class TriggerActionNotificationProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notifyDelayAfter":
            suggest = "notify_delay_after"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerActionNotificationProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerActionNotificationProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerActionNotificationProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notify_delay_after: Optional[int] = None):
        """
        :param int notify_delay_after: After a job run starts, the number of minutes to wait before sending a job run delay notification.
        """
        if notify_delay_after is not None:
            pulumi.set(__self__, "notify_delay_after", notify_delay_after)

    @property
    @pulumi.getter(name="notifyDelayAfter")
    def notify_delay_after(self) -> Optional[int]:
        """
        After a job run starts, the number of minutes to wait before sending a job run delay notification.
        """
        return pulumi.get(self, "notify_delay_after")


@pulumi.output_type
class TriggerEventBatchingCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSize":
            suggest = "batch_size"
        elif key == "batchWindow":
            suggest = "batch_window"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerEventBatchingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerEventBatchingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerEventBatchingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size: int,
                 batch_window: Optional[int] = None):
        """
        :param int batch_size: Number of events that must be received from Amazon EventBridge before EventBridge  event trigger fires.
        :param int batch_window: Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received. Default value is `900`.
        """
        pulumi.set(__self__, "batch_size", batch_size)
        if batch_window is not None:
            pulumi.set(__self__, "batch_window", batch_window)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> int:
        """
        Number of events that must be received from Amazon EventBridge before EventBridge  event trigger fires.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="batchWindow")
    def batch_window(self) -> Optional[int]:
        """
        Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received. Default value is `900`.
        """
        return pulumi.get(self, "batch_window")


@pulumi.output_type
class TriggerPredicate(dict):
    def __init__(__self__, *,
                 conditions: Sequence['outputs.TriggerPredicateCondition'],
                 logical: Optional[str] = None):
        """
        :param Sequence['TriggerPredicateConditionArgs'] conditions: A list of the conditions that determine when the trigger will fire. See Conditions.
        :param str logical: How to handle multiple conditions. Defaults to `AND`. Valid values are `AND` or `ANY`.
        """
        pulumi.set(__self__, "conditions", conditions)
        if logical is not None:
            pulumi.set(__self__, "logical", logical)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.TriggerPredicateCondition']:
        """
        A list of the conditions that determine when the trigger will fire. See Conditions.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def logical(self) -> Optional[str]:
        """
        How to handle multiple conditions. Defaults to `AND`. Valid values are `AND` or `ANY`.
        """
        return pulumi.get(self, "logical")


@pulumi.output_type
class TriggerPredicateCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crawlState":
            suggest = "crawl_state"
        elif key == "crawlerName":
            suggest = "crawler_name"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "logicalOperator":
            suggest = "logical_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerPredicateCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerPredicateCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerPredicateCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crawl_state: Optional[str] = None,
                 crawler_name: Optional[str] = None,
                 job_name: Optional[str] = None,
                 logical_operator: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param str crawl_state: The condition crawl state. Currently, the values supported are `RUNNING`, `SUCCEEDED`, `CANCELLED`, and `FAILED`. If this is specified, `crawler_name` must also be specified. Conflicts with `state`.
        :param str crawler_name: The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
        :param str job_name: The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
        :param str logical_operator: A logical operator. Defaults to `EQUALS`.
        :param str state: The condition job state. Currently, the values supported are `SUCCEEDED`, `STOPPED`, `TIMEOUT` and `FAILED`. If this is specified, `job_name` must also be specified. Conflicts with `crawler_state`.
        """
        if crawl_state is not None:
            pulumi.set(__self__, "crawl_state", crawl_state)
        if crawler_name is not None:
            pulumi.set(__self__, "crawler_name", crawler_name)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if logical_operator is not None:
            pulumi.set(__self__, "logical_operator", logical_operator)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="crawlState")
    def crawl_state(self) -> Optional[str]:
        """
        The condition crawl state. Currently, the values supported are `RUNNING`, `SUCCEEDED`, `CANCELLED`, and `FAILED`. If this is specified, `crawler_name` must also be specified. Conflicts with `state`.
        """
        return pulumi.get(self, "crawl_state")

    @property
    @pulumi.getter(name="crawlerName")
    def crawler_name(self) -> Optional[str]:
        """
        The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
        """
        return pulumi.get(self, "crawler_name")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[str]:
        """
        The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="logicalOperator")
    def logical_operator(self) -> Optional[str]:
        """
        A logical operator. Defaults to `EQUALS`.
        """
        return pulumi.get(self, "logical_operator")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The condition job state. Currently, the values supported are `SUCCEEDED`, `STOPPED`, `TIMEOUT` and `FAILED`. If this is specified, `job_name` must also be specified. Conflicts with `crawler_state`.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class UserDefinedFunctionResourceUri(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserDefinedFunctionResourceUri. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserDefinedFunctionResourceUri.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserDefinedFunctionResourceUri.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: str,
                 uri: str):
        """
        :param str resource_type: The type of the resource. can be one of `JAR`, `FILE`, and `ARCHIVE`.
        :param str uri: The URI for accessing the resource.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of the resource. can be one of `JAR`, `FILE`, and `ARCHIVE`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI for accessing the resource.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetConnectionPhysicalConnectionRequirementResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 security_group_id_lists: Sequence[str],
                 subnet_id: str):
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "security_group_id_lists", security_group_id_lists)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="securityGroupIdLists")
    def security_group_id_lists(self) -> Sequence[str]:
        return pulumi.get(self, "security_group_id_lists")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingResult(dict):
    def __init__(__self__, *,
                 connection_password_encryptions: Sequence['outputs.GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryptionResult'],
                 encryption_at_rests: Sequence['outputs.GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingEncryptionAtRestResult']):
        """
        :param Sequence['GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryptionArgs'] connection_password_encryptions: When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
        :param Sequence['GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingEncryptionAtRestArgs'] encryption_at_rests: Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
        """
        pulumi.set(__self__, "connection_password_encryptions", connection_password_encryptions)
        pulumi.set(__self__, "encryption_at_rests", encryption_at_rests)

    @property
    @pulumi.getter(name="connectionPasswordEncryptions")
    def connection_password_encryptions(self) -> Sequence['outputs.GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryptionResult']:
        """
        When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
        """
        return pulumi.get(self, "connection_password_encryptions")

    @property
    @pulumi.getter(name="encryptionAtRests")
    def encryption_at_rests(self) -> Sequence['outputs.GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingEncryptionAtRestResult']:
        """
        Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
        """
        return pulumi.get(self, "encryption_at_rests")


@pulumi.output_type
class GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryptionResult(dict):
    def __init__(__self__, *,
                 aws_kms_key_id: str,
                 return_connection_password_encrypted: bool):
        """
        :param str aws_kms_key_id: A KMS key ARN that is used to encrypt the connection password.
        :param bool return_connection_password_encrypted: When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
        """
        pulumi.set(__self__, "aws_kms_key_id", aws_kms_key_id)
        pulumi.set(__self__, "return_connection_password_encrypted", return_connection_password_encrypted)

    @property
    @pulumi.getter(name="awsKmsKeyId")
    def aws_kms_key_id(self) -> str:
        """
        A KMS key ARN that is used to encrypt the connection password.
        """
        return pulumi.get(self, "aws_kms_key_id")

    @property
    @pulumi.getter(name="returnConnectionPasswordEncrypted")
    def return_connection_password_encrypted(self) -> bool:
        """
        When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
        """
        return pulumi.get(self, "return_connection_password_encrypted")


@pulumi.output_type
class GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingEncryptionAtRestResult(dict):
    def __init__(__self__, *,
                 catalog_encryption_mode: str,
                 sse_aws_kms_key_id: str):
        """
        :param str catalog_encryption_mode: The encryption-at-rest mode for encrypting Data Catalog data.
        :param str sse_aws_kms_key_id: The ARN of the AWS KMS key to use for encryption at rest.
        """
        pulumi.set(__self__, "catalog_encryption_mode", catalog_encryption_mode)
        pulumi.set(__self__, "sse_aws_kms_key_id", sse_aws_kms_key_id)

    @property
    @pulumi.getter(name="catalogEncryptionMode")
    def catalog_encryption_mode(self) -> str:
        """
        The encryption-at-rest mode for encrypting Data Catalog data.
        """
        return pulumi.get(self, "catalog_encryption_mode")

    @property
    @pulumi.getter(name="sseAwsKmsKeyId")
    def sse_aws_kms_key_id(self) -> str:
        """
        The ARN of the AWS KMS key to use for encryption at rest.
        """
        return pulumi.get(self, "sse_aws_kms_key_id")


@pulumi.output_type
class GetScriptDagEdgeResult(dict):
    def __init__(__self__, *,
                 source: str,
                 target: str,
                 target_parameter: Optional[str] = None):
        """
        :param str source: The ID of the node at which the edge starts.
        :param str target: The ID of the node at which the edge ends.
        :param str target_parameter: The target of the edge.
        """
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if target_parameter is not None:
            pulumi.set(__self__, "target_parameter", target_parameter)

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The ID of the node at which the edge starts.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The ID of the node at which the edge ends.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="targetParameter")
    def target_parameter(self) -> Optional[str]:
        """
        The target of the edge.
        """
        return pulumi.get(self, "target_parameter")


@pulumi.output_type
class GetScriptDagNodeResult(dict):
    def __init__(__self__, *,
                 args: Sequence['outputs.GetScriptDagNodeArgResult'],
                 id: str,
                 node_type: str,
                 line_number: Optional[int] = None):
        """
        :param Sequence['GetScriptDagNodeArgArgs'] args: Nested configuration an argument or property of a node. Defined below.
        :param str id: A node identifier that is unique within the node's graph.
        :param str node_type: The type of node this is.
        :param int line_number: The line number of the node.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "node_type", node_type)
        if line_number is not None:
            pulumi.set(__self__, "line_number", line_number)

    @property
    @pulumi.getter
    def args(self) -> Sequence['outputs.GetScriptDagNodeArgResult']:
        """
        Nested configuration an argument or property of a node. Defined below.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A node identifier that is unique within the node's graph.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        The type of node this is.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="lineNumber")
    def line_number(self) -> Optional[int]:
        """
        The line number of the node.
        """
        return pulumi.get(self, "line_number")


@pulumi.output_type
class GetScriptDagNodeArgResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 param: Optional[bool] = None):
        """
        :param str name: The name of the argument or property.
        :param str value: The value of the argument or property.
        :param bool param: Boolean if the value is used as a parameter. Defaults to `false`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if param is not None:
            pulumi.set(__self__, "param", param)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the argument or property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the argument or property.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def param(self) -> Optional[bool]:
        """
        Boolean if the value is used as a parameter. Defaults to `false`.
        """
        return pulumi.get(self, "param")


