# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'CatalogDatabaseCreateTableDefaultPermissionArgs',
    'CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs',
    'CatalogDatabaseTargetDatabaseArgs',
    'CatalogTablePartitionIndexArgs',
    'CatalogTablePartitionKeyArgs',
    'CatalogTableStorageDescriptorArgs',
    'CatalogTableStorageDescriptorColumnArgs',
    'CatalogTableStorageDescriptorSchemaReferenceArgs',
    'CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs',
    'CatalogTableStorageDescriptorSerDeInfoArgs',
    'CatalogTableStorageDescriptorSkewedInfoArgs',
    'CatalogTableStorageDescriptorSortColumnArgs',
    'CatalogTableTargetTableArgs',
    'ClassifierCsvClassifierArgs',
    'ClassifierGrokClassifierArgs',
    'ClassifierJsonClassifierArgs',
    'ClassifierXmlClassifierArgs',
    'ConnectionPhysicalConnectionRequirementsArgs',
    'CrawlerCatalogTargetArgs',
    'CrawlerDeltaTargetArgs',
    'CrawlerDynamodbTargetArgs',
    'CrawlerJdbcTargetArgs',
    'CrawlerLineageConfigurationArgs',
    'CrawlerMongodbTargetArgs',
    'CrawlerRecrawlPolicyArgs',
    'CrawlerS3TargetArgs',
    'CrawlerSchemaChangePolicyArgs',
    'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs',
    'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs',
    'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs',
    'JobCommandArgs',
    'JobExecutionPropertyArgs',
    'JobNotificationPropertyArgs',
    'MLTransformInputRecordTableArgs',
    'MLTransformParametersArgs',
    'MLTransformParametersFindMatchesParametersArgs',
    'MLTransformSchemaArgs',
    'PartitionIndexPartitionIndexArgs',
    'PartitionStorageDescriptorArgs',
    'PartitionStorageDescriptorColumnArgs',
    'PartitionStorageDescriptorSerDeInfoArgs',
    'PartitionStorageDescriptorSkewedInfoArgs',
    'PartitionStorageDescriptorSortColumnArgs',
    'SecurityConfigurationEncryptionConfigurationArgs',
    'SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs',
    'SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs',
    'SecurityConfigurationEncryptionConfigurationS3EncryptionArgs',
    'TriggerActionArgs',
    'TriggerActionNotificationPropertyArgs',
    'TriggerEventBatchingConditionArgs',
    'TriggerPredicateArgs',
    'TriggerPredicateConditionArgs',
    'UserDefinedFunctionResourceUriArgs',
    'GetScriptDagEdgeArgs',
    'GetScriptDagNodeArgs',
    'GetScriptDagNodeArgArgs',
]

@pulumi.input_type
class CatalogDatabaseCreateTableDefaultPermissionArgs:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 principal: Optional[pulumi.Input['CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: The permissions that are granted to the principal.
        :param pulumi.Input['CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs'] principal: The principal who is granted permissions.. See `principal` below.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The permissions that are granted to the principal.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input['CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs']]:
        """
        The principal who is granted permissions.. See `principal` below.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input['CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs']]):
        pulumi.set(self, "principal", value)


@pulumi.input_type
class CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs:
    def __init__(__self__, *,
                 data_lake_principal_identifier: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data_lake_principal_identifier: An identifier for the Lake Formation principal.
        """
        if data_lake_principal_identifier is not None:
            pulumi.set(__self__, "data_lake_principal_identifier", data_lake_principal_identifier)

    @property
    @pulumi.getter(name="dataLakePrincipalIdentifier")
    def data_lake_principal_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the Lake Formation principal.
        """
        return pulumi.get(self, "data_lake_principal_identifier")

    @data_lake_principal_identifier.setter
    def data_lake_principal_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_lake_principal_identifier", value)


@pulumi.input_type
class CatalogDatabaseTargetDatabaseArgs:
    def __init__(__self__, *,
                 catalog_id: pulumi.Input[str],
                 database_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] catalog_id: ID of the Data Catalog in which the database resides.
        :param pulumi.Input[str] database_name: Name of the catalog database.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Input[str]:
        """
        ID of the Data Catalog in which the database resides.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        Name of the catalog database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)


@pulumi.input_type
class CatalogTablePartitionIndexArgs:
    def __init__(__self__, *,
                 index_name: pulumi.Input[str],
                 keys: pulumi.Input[Sequence[pulumi.Input[str]]],
                 index_status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] index_name: Name of the partition index.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: Keys for the partition index.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "keys", keys)
        if index_status is not None:
            pulumi.set(__self__, "index_status", index_status)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> pulumi.Input[str]:
        """
        Name of the partition index.
        """
        return pulumi.get(self, "index_name")

    @index_name.setter
    def index_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "index_name", value)

    @property
    @pulumi.getter
    def keys(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Keys for the partition index.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="indexStatus")
    def index_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "index_status")

    @index_status.setter
    def index_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_status", value)


@pulumi.input_type
class CatalogTablePartitionKeyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the target table.
        :param pulumi.Input[str] comment: Free-form text comment.
        :param pulumi.Input[str] type: Datatype of data in the Column.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Free-form text comment.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Datatype of data in the Column.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class CatalogTableStorageDescriptorArgs:
    def __init__(__self__, *,
                 bucket_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTableStorageDescriptorColumnArgs']]]] = None,
                 compressed: Optional[pulumi.Input[bool]] = None,
                 input_format: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 number_of_buckets: Optional[pulumi.Input[int]] = None,
                 output_format: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 schema_reference: Optional[pulumi.Input['CatalogTableStorageDescriptorSchemaReferenceArgs']] = None,
                 ser_de_info: Optional[pulumi.Input['CatalogTableStorageDescriptorSerDeInfoArgs']] = None,
                 skewed_info: Optional[pulumi.Input['CatalogTableStorageDescriptorSkewedInfoArgs']] = None,
                 sort_columns: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTableStorageDescriptorSortColumnArgs']]]] = None,
                 stored_as_sub_directories: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bucket_columns: List of reducer grouping columns, clustering columns, and bucketing columns in the table.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTableStorageDescriptorColumnArgs']]] columns: Configuration block for columns in the table. See `columns` below.
        :param pulumi.Input[bool] compressed: Whether the data in the table is compressed.
        :param pulumi.Input[str] input_format: Input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
        :param pulumi.Input[str] location: Physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
        :param pulumi.Input[int] number_of_buckets: Must be specified if the table contains any dimension columns.
        :param pulumi.Input[str] output_format: Output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param pulumi.Input['CatalogTableStorageDescriptorSchemaReferenceArgs'] schema_reference: Object that references a schema stored in the AWS Glue Schema Registry. When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference. See Schema Reference below.
        :param pulumi.Input['CatalogTableStorageDescriptorSerDeInfoArgs'] ser_de_info: Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
        :param pulumi.Input['CatalogTableStorageDescriptorSkewedInfoArgs'] skewed_info: Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTableStorageDescriptorSortColumnArgs']]] sort_columns: Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
        :param pulumi.Input[bool] stored_as_sub_directories: Whether the table data is stored in subdirectories.
        """
        if bucket_columns is not None:
            pulumi.set(__self__, "bucket_columns", bucket_columns)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if compressed is not None:
            pulumi.set(__self__, "compressed", compressed)
        if input_format is not None:
            pulumi.set(__self__, "input_format", input_format)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if number_of_buckets is not None:
            pulumi.set(__self__, "number_of_buckets", number_of_buckets)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schema_reference is not None:
            pulumi.set(__self__, "schema_reference", schema_reference)
        if ser_de_info is not None:
            pulumi.set(__self__, "ser_de_info", ser_de_info)
        if skewed_info is not None:
            pulumi.set(__self__, "skewed_info", skewed_info)
        if sort_columns is not None:
            pulumi.set(__self__, "sort_columns", sort_columns)
        if stored_as_sub_directories is not None:
            pulumi.set(__self__, "stored_as_sub_directories", stored_as_sub_directories)

    @property
    @pulumi.getter(name="bucketColumns")
    def bucket_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of reducer grouping columns, clustering columns, and bucketing columns in the table.
        """
        return pulumi.get(self, "bucket_columns")

    @bucket_columns.setter
    def bucket_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bucket_columns", value)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTableStorageDescriptorColumnArgs']]]]:
        """
        Configuration block for columns in the table. See `columns` below.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTableStorageDescriptorColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter
    def compressed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the data in the table is compressed.
        """
        return pulumi.get(self, "compressed")

    @compressed.setter
    def compressed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compressed", value)

    @property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> Optional[pulumi.Input[str]]:
        """
        Input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
        """
        return pulumi.get(self, "input_format")

    @input_format.setter
    def input_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_format", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="numberOfBuckets")
    def number_of_buckets(self) -> Optional[pulumi.Input[int]]:
        """
        Must be specified if the table contains any dimension columns.
        """
        return pulumi.get(self, "number_of_buckets")

    @number_of_buckets.setter
    def number_of_buckets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_buckets", value)

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[pulumi.Input[str]]:
        """
        Output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_format", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="schemaReference")
    def schema_reference(self) -> Optional[pulumi.Input['CatalogTableStorageDescriptorSchemaReferenceArgs']]:
        """
        Object that references a schema stored in the AWS Glue Schema Registry. When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference. See Schema Reference below.
        """
        return pulumi.get(self, "schema_reference")

    @schema_reference.setter
    def schema_reference(self, value: Optional[pulumi.Input['CatalogTableStorageDescriptorSchemaReferenceArgs']]):
        pulumi.set(self, "schema_reference", value)

    @property
    @pulumi.getter(name="serDeInfo")
    def ser_de_info(self) -> Optional[pulumi.Input['CatalogTableStorageDescriptorSerDeInfoArgs']]:
        """
        Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
        """
        return pulumi.get(self, "ser_de_info")

    @ser_de_info.setter
    def ser_de_info(self, value: Optional[pulumi.Input['CatalogTableStorageDescriptorSerDeInfoArgs']]):
        pulumi.set(self, "ser_de_info", value)

    @property
    @pulumi.getter(name="skewedInfo")
    def skewed_info(self) -> Optional[pulumi.Input['CatalogTableStorageDescriptorSkewedInfoArgs']]:
        """
        Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
        """
        return pulumi.get(self, "skewed_info")

    @skewed_info.setter
    def skewed_info(self, value: Optional[pulumi.Input['CatalogTableStorageDescriptorSkewedInfoArgs']]):
        pulumi.set(self, "skewed_info", value)

    @property
    @pulumi.getter(name="sortColumns")
    def sort_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTableStorageDescriptorSortColumnArgs']]]]:
        """
        Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
        """
        return pulumi.get(self, "sort_columns")

    @sort_columns.setter
    def sort_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTableStorageDescriptorSortColumnArgs']]]]):
        pulumi.set(self, "sort_columns", value)

    @property
    @pulumi.getter(name="storedAsSubDirectories")
    def stored_as_sub_directories(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the table data is stored in subdirectories.
        """
        return pulumi.get(self, "stored_as_sub_directories")

    @stored_as_sub_directories.setter
    def stored_as_sub_directories(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stored_as_sub_directories", value)


@pulumi.input_type
class CatalogTableStorageDescriptorColumnArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the target table.
        :param pulumi.Input[str] comment: Free-form text comment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param pulumi.Input[str] type: Datatype of data in the Column.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Free-form text comment.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Datatype of data in the Column.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class CatalogTableStorageDescriptorSchemaReferenceArgs:
    def __init__(__self__, *,
                 schema_version_number: pulumi.Input[int],
                 schema_id: Optional[pulumi.Input['CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs']] = None,
                 schema_version_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] schema_version_number: Version number of the schema.
        :param pulumi.Input['CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs'] schema_id: Configuration block that contains schema identity fields. Either this or the `schema_version_id` has to be provided. See `schema_id` below.
        :param pulumi.Input[str] schema_version_id: Unique ID assigned to a version of the schema. Either this or the `schema_id` has to be provided.
        """
        pulumi.set(__self__, "schema_version_number", schema_version_number)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if schema_version_id is not None:
            pulumi.set(__self__, "schema_version_id", schema_version_id)

    @property
    @pulumi.getter(name="schemaVersionNumber")
    def schema_version_number(self) -> pulumi.Input[int]:
        """
        Version number of the schema.
        """
        return pulumi.get(self, "schema_version_number")

    @schema_version_number.setter
    def schema_version_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "schema_version_number", value)

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[pulumi.Input['CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs']]:
        """
        Configuration block that contains schema identity fields. Either this or the `schema_version_id` has to be provided. See `schema_id` below.
        """
        return pulumi.get(self, "schema_id")

    @schema_id.setter
    def schema_id(self, value: Optional[pulumi.Input['CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs']]):
        pulumi.set(self, "schema_id", value)

    @property
    @pulumi.getter(name="schemaVersionId")
    def schema_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique ID assigned to a version of the schema. Either this or the `schema_id` has to be provided.
        """
        return pulumi.get(self, "schema_version_id")

    @schema_version_id.setter
    def schema_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_version_id", value)


@pulumi.input_type
class CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs:
    def __init__(__self__, *,
                 registry_name: Optional[pulumi.Input[str]] = None,
                 schema_arn: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] registry_name: Name of the schema registry that contains the schema. Must be provided when `schema_name` is specified and conflicts with `schema_arn`.
        :param pulumi.Input[str] schema_arn: ARN of the schema. One of `schema_arn` or `schema_name` has to be provided.
        :param pulumi.Input[str] schema_name: Name of the schema. One of `schema_arn` or `schema_name` has to be provided.
        """
        if registry_name is not None:
            pulumi.set(__self__, "registry_name", registry_name)
        if schema_arn is not None:
            pulumi.set(__self__, "schema_arn", schema_arn)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the schema registry that contains the schema. Must be provided when `schema_name` is specified and conflicts with `schema_arn`.
        """
        return pulumi.get(self, "registry_name")

    @registry_name.setter
    def registry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_name", value)

    @property
    @pulumi.getter(name="schemaArn")
    def schema_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the schema. One of `schema_arn` or `schema_name` has to be provided.
        """
        return pulumi.get(self, "schema_arn")

    @schema_arn.setter
    def schema_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_arn", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the schema. One of `schema_arn` or `schema_name` has to be provided.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)


@pulumi.input_type
class CatalogTableStorageDescriptorSerDeInfoArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 serialization_library: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the target table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param pulumi.Input[str] serialization_library: Usually the class that implements the SerDe. An example is `org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if serialization_library is not None:
            pulumi.set(__self__, "serialization_library", serialization_library)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="serializationLibrary")
    def serialization_library(self) -> Optional[pulumi.Input[str]]:
        """
        Usually the class that implements the SerDe. An example is `org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe`.
        """
        return pulumi.get(self, "serialization_library")

    @serialization_library.setter
    def serialization_library(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serialization_library", value)


@pulumi.input_type
class CatalogTableStorageDescriptorSkewedInfoArgs:
    def __init__(__self__, *,
                 skewed_column_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skewed_column_value_location_maps: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 skewed_column_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] skewed_column_names: List of names of columns that contain skewed values.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] skewed_column_value_location_maps: List of values that appear so frequently as to be considered skewed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] skewed_column_values: Map of skewed values to the columns that contain them.
        """
        if skewed_column_names is not None:
            pulumi.set(__self__, "skewed_column_names", skewed_column_names)
        if skewed_column_value_location_maps is not None:
            pulumi.set(__self__, "skewed_column_value_location_maps", skewed_column_value_location_maps)
        if skewed_column_values is not None:
            pulumi.set(__self__, "skewed_column_values", skewed_column_values)

    @property
    @pulumi.getter(name="skewedColumnNames")
    def skewed_column_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of names of columns that contain skewed values.
        """
        return pulumi.get(self, "skewed_column_names")

    @skewed_column_names.setter
    def skewed_column_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "skewed_column_names", value)

    @property
    @pulumi.getter(name="skewedColumnValueLocationMaps")
    def skewed_column_value_location_maps(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        List of values that appear so frequently as to be considered skewed.
        """
        return pulumi.get(self, "skewed_column_value_location_maps")

    @skewed_column_value_location_maps.setter
    def skewed_column_value_location_maps(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "skewed_column_value_location_maps", value)

    @property
    @pulumi.getter(name="skewedColumnValues")
    def skewed_column_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Map of skewed values to the columns that contain them.
        """
        return pulumi.get(self, "skewed_column_values")

    @skewed_column_values.setter
    def skewed_column_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "skewed_column_values", value)


@pulumi.input_type
class CatalogTableStorageDescriptorSortColumnArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[str],
                 sort_order: pulumi.Input[int]):
        """
        :param pulumi.Input[str] column: Name of the column.
        :param pulumi.Input[int] sort_order: Whether the column is sorted in ascending (`1`) or descending order (`0`).
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "sort_order", sort_order)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[str]:
        """
        Name of the column.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[str]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> pulumi.Input[int]:
        """
        Whether the column is sorted in ascending (`1`) or descending order (`0`).
        """
        return pulumi.get(self, "sort_order")

    @sort_order.setter
    def sort_order(self, value: pulumi.Input[int]):
        pulumi.set(self, "sort_order", value)


@pulumi.input_type
class CatalogTableTargetTableArgs:
    def __init__(__self__, *,
                 catalog_id: pulumi.Input[str],
                 database_name: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] catalog_id: ID of the Data Catalog in which the table resides.
        :param pulumi.Input[str] database_name: Name of the catalog database that contains the target table.
        :param pulumi.Input[str] name: Name of the target table.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Input[str]:
        """
        ID of the Data Catalog in which the table resides.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        Name of the catalog database that contains the target table.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ClassifierCsvClassifierArgs:
    def __init__(__self__, *,
                 allow_single_column: Optional[pulumi.Input[bool]] = None,
                 contains_header: Optional[pulumi.Input[str]] = None,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 disable_value_trimming: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 quote_symbol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] allow_single_column: Enables the processing of files that contain only one column.
        :param pulumi.Input[str] contains_header: Indicates whether the CSV file contains a header. This can be one of "ABSENT", "PRESENT", or "UNKNOWN".
        :param pulumi.Input[str] delimiter: The delimiter used in the Csv to separate columns.
        :param pulumi.Input[bool] disable_value_trimming: Specifies whether to trim column values.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] headers: A list of strings representing column names.
        :param pulumi.Input[str] quote_symbol: A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.
        """
        if allow_single_column is not None:
            pulumi.set(__self__, "allow_single_column", allow_single_column)
        if contains_header is not None:
            pulumi.set(__self__, "contains_header", contains_header)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if disable_value_trimming is not None:
            pulumi.set(__self__, "disable_value_trimming", disable_value_trimming)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if quote_symbol is not None:
            pulumi.set(__self__, "quote_symbol", quote_symbol)

    @property
    @pulumi.getter(name="allowSingleColumn")
    def allow_single_column(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables the processing of files that contain only one column.
        """
        return pulumi.get(self, "allow_single_column")

    @allow_single_column.setter
    def allow_single_column(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_single_column", value)

    @property
    @pulumi.getter(name="containsHeader")
    def contains_header(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the CSV file contains a header. This can be one of "ABSENT", "PRESENT", or "UNKNOWN".
        """
        return pulumi.get(self, "contains_header")

    @contains_header.setter
    def contains_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contains_header", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        The delimiter used in the Csv to separate columns.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="disableValueTrimming")
    def disable_value_trimming(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to trim column values.
        """
        return pulumi.get(self, "disable_value_trimming")

    @disable_value_trimming.setter
    def disable_value_trimming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_value_trimming", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of strings representing column names.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="quoteSymbol")
    def quote_symbol(self) -> Optional[pulumi.Input[str]]:
        """
        A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.
        """
        return pulumi.get(self, "quote_symbol")

    @quote_symbol.setter
    def quote_symbol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quote_symbol", value)


@pulumi.input_type
class ClassifierGrokClassifierArgs:
    def __init__(__self__, *,
                 classification: pulumi.Input[str],
                 grok_pattern: pulumi.Input[str],
                 custom_patterns: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] classification: An identifier of the data format that the classifier matches.
        :param pulumi.Input[str] grok_pattern: The grok pattern used by this classifier.
        :param pulumi.Input[str] custom_patterns: Custom grok patterns used by this classifier.
        """
        pulumi.set(__self__, "classification", classification)
        pulumi.set(__self__, "grok_pattern", grok_pattern)
        if custom_patterns is not None:
            pulumi.set(__self__, "custom_patterns", custom_patterns)

    @property
    @pulumi.getter
    def classification(self) -> pulumi.Input[str]:
        """
        An identifier of the data format that the classifier matches.
        """
        return pulumi.get(self, "classification")

    @classification.setter
    def classification(self, value: pulumi.Input[str]):
        pulumi.set(self, "classification", value)

    @property
    @pulumi.getter(name="grokPattern")
    def grok_pattern(self) -> pulumi.Input[str]:
        """
        The grok pattern used by this classifier.
        """
        return pulumi.get(self, "grok_pattern")

    @grok_pattern.setter
    def grok_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "grok_pattern", value)

    @property
    @pulumi.getter(name="customPatterns")
    def custom_patterns(self) -> Optional[pulumi.Input[str]]:
        """
        Custom grok patterns used by this classifier.
        """
        return pulumi.get(self, "custom_patterns")

    @custom_patterns.setter
    def custom_patterns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_patterns", value)


@pulumi.input_type
class ClassifierJsonClassifierArgs:
    def __init__(__self__, *,
                 json_path: pulumi.Input[str]):
        """
        :param pulumi.Input[str] json_path: A `JsonPath` string defining the JSON data for the classifier to classify. AWS Glue supports a subset of `JsonPath`, as described in [Writing JsonPath Custom Classifiers](https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
        """
        pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> pulumi.Input[str]:
        """
        A `JsonPath` string defining the JSON data for the classifier to classify. AWS Glue supports a subset of `JsonPath`, as described in [Writing JsonPath Custom Classifiers](https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
        """
        return pulumi.get(self, "json_path")

    @json_path.setter
    def json_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "json_path", value)


@pulumi.input_type
class ClassifierXmlClassifierArgs:
    def __init__(__self__, *,
                 classification: pulumi.Input[str],
                 row_tag: pulumi.Input[str]):
        """
        :param pulumi.Input[str] classification: An identifier of the data format that the classifier matches.
        :param pulumi.Input[str] row_tag: The XML tag designating the element that contains each record in an XML document being parsed. Note that this cannot identify a self-closing element (closed by `/>`). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, `<row item_a="A" item_b="B"></row>` is okay, but `<row item_a="A" item_b="B" />` is not).
        """
        pulumi.set(__self__, "classification", classification)
        pulumi.set(__self__, "row_tag", row_tag)

    @property
    @pulumi.getter
    def classification(self) -> pulumi.Input[str]:
        """
        An identifier of the data format that the classifier matches.
        """
        return pulumi.get(self, "classification")

    @classification.setter
    def classification(self, value: pulumi.Input[str]):
        pulumi.set(self, "classification", value)

    @property
    @pulumi.getter(name="rowTag")
    def row_tag(self) -> pulumi.Input[str]:
        """
        The XML tag designating the element that contains each record in an XML document being parsed. Note that this cannot identify a self-closing element (closed by `/>`). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, `<row item_a="A" item_b="B"></row>` is okay, but `<row item_a="A" item_b="B" />` is not).
        """
        return pulumi.get(self, "row_tag")

    @row_tag.setter
    def row_tag(self, value: pulumi.Input[str]):
        pulumi.set(self, "row_tag", value)


@pulumi.input_type
class ConnectionPhysicalConnectionRequirementsArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 security_group_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] availability_zone: The availability zone of the connection. This field is redundant and implied by `subnet_id`, but is currently an api requirement.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_id_lists: The security group ID list used by the connection.
        :param pulumi.Input[str] subnet_id: The subnet ID used by the connection.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if security_group_id_lists is not None:
            pulumi.set(__self__, "security_group_id_lists", security_group_id_lists)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The availability zone of the connection. This field is redundant and implied by `subnet_id`, but is currently an api requirement.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="securityGroupIdLists")
    def security_group_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The security group ID list used by the connection.
        """
        return pulumi.get(self, "security_group_id_lists")

    @security_group_id_lists.setter
    def security_group_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_id_lists", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet ID used by the connection.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class CrawlerCatalogTargetArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 tables: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] database_name: The name of the Glue database to be synchronized.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tables: A list of catalog tables to be synchronized.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The name of the Glue database to be synchronized.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def tables(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of catalog tables to be synchronized.
        """
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "tables", value)


@pulumi.input_type
class CrawlerDeltaTargetArgs:
    def __init__(__self__, *,
                 connection_name: pulumi.Input[str],
                 delta_tables: pulumi.Input[Sequence[pulumi.Input[str]]],
                 write_manifest: pulumi.Input[bool]):
        """
        :param pulumi.Input[str] connection_name: The name of the connection to use to connect to the Delta table target.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delta_tables: A list of the Amazon S3 paths to the Delta tables.
        :param pulumi.Input[bool] write_manifest: Specifies whether to write the manifest files to the Delta table path.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "delta_tables", delta_tables)
        pulumi.set(__self__, "write_manifest", write_manifest)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="deltaTables")
    def delta_tables(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of the Amazon S3 paths to the Delta tables.
        """
        return pulumi.get(self, "delta_tables")

    @delta_tables.setter
    def delta_tables(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "delta_tables", value)

    @property
    @pulumi.getter(name="writeManifest")
    def write_manifest(self) -> pulumi.Input[bool]:
        """
        Specifies whether to write the manifest files to the Delta table path.
        """
        return pulumi.get(self, "write_manifest")

    @write_manifest.setter
    def write_manifest(self, value: pulumi.Input[bool]):
        pulumi.set(self, "write_manifest", value)


@pulumi.input_type
class CrawlerDynamodbTargetArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 scan_all: Optional[pulumi.Input[bool]] = None,
                 scan_rate: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        :param pulumi.Input[bool] scan_all: Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
        :param pulumi.Input[float] scan_rate: The percentage of the configured read capacity units to use by the AWS Glue crawler. The valid values are null or a value between 0.1 to 1.5.
        """
        pulumi.set(__self__, "path", path)
        if scan_all is not None:
            pulumi.set(__self__, "scan_all", scan_all)
        if scan_rate is not None:
            pulumi.set(__self__, "scan_rate", scan_rate)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="scanAll")
    def scan_all(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
        """
        return pulumi.get(self, "scan_all")

    @scan_all.setter
    def scan_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scan_all", value)

    @property
    @pulumi.getter(name="scanRate")
    def scan_rate(self) -> Optional[pulumi.Input[float]]:
        """
        The percentage of the configured read capacity units to use by the AWS Glue crawler. The valid values are null or a value between 0.1 to 1.5.
        """
        return pulumi.get(self, "scan_rate")

    @scan_rate.setter
    def scan_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scan_rate", value)


@pulumi.input_type
class CrawlerJdbcTargetArgs:
    def __init__(__self__, *,
                 connection_name: pulumi.Input[str],
                 path: pulumi.Input[str],
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] connection_name: The name of the connection to use to connect to the Delta table target.
        :param pulumi.Input[str] path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusions: A list of glob patterns used to exclude from the crawl.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "path", path)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of glob patterns used to exclude from the crawl.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusions", value)


@pulumi.input_type
class CrawlerLineageConfigurationArgs:
    def __init__(__self__, *,
                 crawler_lineage_settings: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] crawler_lineage_settings: Specifies whether data lineage is enabled for the crawler. Valid values are: `ENABLE` and `DISABLE`. Default value is `Disable`.
        """
        if crawler_lineage_settings is not None:
            pulumi.set(__self__, "crawler_lineage_settings", crawler_lineage_settings)

    @property
    @pulumi.getter(name="crawlerLineageSettings")
    def crawler_lineage_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether data lineage is enabled for the crawler. Valid values are: `ENABLE` and `DISABLE`. Default value is `Disable`.
        """
        return pulumi.get(self, "crawler_lineage_settings")

    @crawler_lineage_settings.setter
    def crawler_lineage_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crawler_lineage_settings", value)


@pulumi.input_type
class CrawlerMongodbTargetArgs:
    def __init__(__self__, *,
                 connection_name: pulumi.Input[str],
                 path: pulumi.Input[str],
                 scan_all: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] connection_name: The name of the connection to use to connect to the Delta table target.
        :param pulumi.Input[str] path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        :param pulumi.Input[bool] scan_all: Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "path", path)
        if scan_all is not None:
            pulumi.set(__self__, "scan_all", scan_all)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="scanAll")
    def scan_all(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
        """
        return pulumi.get(self, "scan_all")

    @scan_all.setter
    def scan_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scan_all", value)


@pulumi.input_type
class CrawlerRecrawlPolicyArgs:
    def __init__(__self__, *,
                 recrawl_behavior: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] recrawl_behavior: Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. Valid Values are: `CRAWL_EVERYTHING` and `CRAWL_NEW_FOLDERS_ONLY`. Default value is `CRAWL_EVERYTHING`.
        """
        if recrawl_behavior is not None:
            pulumi.set(__self__, "recrawl_behavior", recrawl_behavior)

    @property
    @pulumi.getter(name="recrawlBehavior")
    def recrawl_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. Valid Values are: `CRAWL_EVERYTHING` and `CRAWL_NEW_FOLDERS_ONLY`. Default value is `CRAWL_EVERYTHING`.
        """
        return pulumi.get(self, "recrawl_behavior")

    @recrawl_behavior.setter
    def recrawl_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recrawl_behavior", value)


@pulumi.input_type
class CrawlerS3TargetArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 connection_name: Optional[pulumi.Input[str]] = None,
                 dlq_event_queue_arn: Optional[pulumi.Input[str]] = None,
                 event_queue_arn: Optional[pulumi.Input[str]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sample_size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        :param pulumi.Input[str] connection_name: The name of the connection to use to connect to the Delta table target.
        :param pulumi.Input[str] dlq_event_queue_arn: The ARN of the dead-letter SQS queue.
        :param pulumi.Input[str] event_queue_arn: The ARN of the SQS queue to receive S3 notifications from.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusions: A list of glob patterns used to exclude from the crawl.
        :param pulumi.Input[int] sample_size: Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
        """
        pulumi.set(__self__, "path", path)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if dlq_event_queue_arn is not None:
            pulumi.set(__self__, "dlq_event_queue_arn", dlq_event_queue_arn)
        if event_queue_arn is not None:
            pulumi.set(__self__, "event_queue_arn", event_queue_arn)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="dlqEventQueueArn")
    def dlq_event_queue_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the dead-letter SQS queue.
        """
        return pulumi.get(self, "dlq_event_queue_arn")

    @dlq_event_queue_arn.setter
    def dlq_event_queue_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dlq_event_queue_arn", value)

    @property
    @pulumi.getter(name="eventQueueArn")
    def event_queue_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the SQS queue to receive S3 notifications from.
        """
        return pulumi.get(self, "event_queue_arn")

    @event_queue_arn.setter
    def event_queue_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_queue_arn", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of glob patterns used to exclude from the crawl.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
        """
        return pulumi.get(self, "sample_size")

    @sample_size.setter
    def sample_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sample_size", value)


@pulumi.input_type
class CrawlerSchemaChangePolicyArgs:
    def __init__(__self__, *,
                 delete_behavior: Optional[pulumi.Input[str]] = None,
                 update_behavior: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] delete_behavior: The deletion behavior when the crawler finds a deleted object. Valid values: `LOG`, `DELETE_FROM_DATABASE`, or `DEPRECATE_IN_DATABASE`. Defaults to `DEPRECATE_IN_DATABASE`.
        :param pulumi.Input[str] update_behavior: The update behavior when the crawler finds a changed schema. Valid values: `LOG` or `UPDATE_IN_DATABASE`. Defaults to `UPDATE_IN_DATABASE`.
        """
        if delete_behavior is not None:
            pulumi.set(__self__, "delete_behavior", delete_behavior)
        if update_behavior is not None:
            pulumi.set(__self__, "update_behavior", update_behavior)

    @property
    @pulumi.getter(name="deleteBehavior")
    def delete_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        The deletion behavior when the crawler finds a deleted object. Valid values: `LOG`, `DELETE_FROM_DATABASE`, or `DEPRECATE_IN_DATABASE`. Defaults to `DEPRECATE_IN_DATABASE`.
        """
        return pulumi.get(self, "delete_behavior")

    @delete_behavior.setter
    def delete_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_behavior", value)

    @property
    @pulumi.getter(name="updateBehavior")
    def update_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        The update behavior when the crawler finds a changed schema. Valid values: `LOG` or `UPDATE_IN_DATABASE`. Defaults to `UPDATE_IN_DATABASE`.
        """
        return pulumi.get(self, "update_behavior")

    @update_behavior.setter
    def update_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_behavior", value)


@pulumi.input_type
class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs:
    def __init__(__self__, *,
                 connection_password_encryption: pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs'],
                 encryption_at_rest: pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs']):
        """
        :param pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs'] connection_password_encryption: When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
        :param pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs'] encryption_at_rest: Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
        """
        pulumi.set(__self__, "connection_password_encryption", connection_password_encryption)
        pulumi.set(__self__, "encryption_at_rest", encryption_at_rest)

    @property
    @pulumi.getter(name="connectionPasswordEncryption")
    def connection_password_encryption(self) -> pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs']:
        """
        When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
        """
        return pulumi.get(self, "connection_password_encryption")

    @connection_password_encryption.setter
    def connection_password_encryption(self, value: pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs']):
        pulumi.set(self, "connection_password_encryption", value)

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs']:
        """
        Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
        """
        return pulumi.get(self, "encryption_at_rest")

    @encryption_at_rest.setter
    def encryption_at_rest(self, value: pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs']):
        pulumi.set(self, "encryption_at_rest", value)


@pulumi.input_type
class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs:
    def __init__(__self__, *,
                 return_connection_password_encrypted: pulumi.Input[bool],
                 aws_kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] return_connection_password_encrypted: When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
        :param pulumi.Input[str] aws_kms_key_id: A KMS key ARN that is used to encrypt the connection password. If connection password protection is enabled, the caller of CreateConnection and UpdateConnection needs at least `kms:Encrypt` permission on the specified AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
        """
        pulumi.set(__self__, "return_connection_password_encrypted", return_connection_password_encrypted)
        if aws_kms_key_id is not None:
            pulumi.set(__self__, "aws_kms_key_id", aws_kms_key_id)

    @property
    @pulumi.getter(name="returnConnectionPasswordEncrypted")
    def return_connection_password_encrypted(self) -> pulumi.Input[bool]:
        """
        When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
        """
        return pulumi.get(self, "return_connection_password_encrypted")

    @return_connection_password_encrypted.setter
    def return_connection_password_encrypted(self, value: pulumi.Input[bool]):
        pulumi.set(self, "return_connection_password_encrypted", value)

    @property
    @pulumi.getter(name="awsKmsKeyId")
    def aws_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        A KMS key ARN that is used to encrypt the connection password. If connection password protection is enabled, the caller of CreateConnection and UpdateConnection needs at least `kms:Encrypt` permission on the specified AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
        """
        return pulumi.get(self, "aws_kms_key_id")

    @aws_kms_key_id.setter
    def aws_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_kms_key_id", value)


@pulumi.input_type
class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs:
    def __init__(__self__, *,
                 catalog_encryption_mode: pulumi.Input[str],
                 sse_aws_kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] catalog_encryption_mode: The encryption-at-rest mode for encrypting Data Catalog data. Valid values are `DISABLED` and `SSE-KMS`.
        :param pulumi.Input[str] sse_aws_kms_key_id: The ARN of the AWS KMS key to use for encryption at rest.
        """
        pulumi.set(__self__, "catalog_encryption_mode", catalog_encryption_mode)
        if sse_aws_kms_key_id is not None:
            pulumi.set(__self__, "sse_aws_kms_key_id", sse_aws_kms_key_id)

    @property
    @pulumi.getter(name="catalogEncryptionMode")
    def catalog_encryption_mode(self) -> pulumi.Input[str]:
        """
        The encryption-at-rest mode for encrypting Data Catalog data. Valid values are `DISABLED` and `SSE-KMS`.
        """
        return pulumi.get(self, "catalog_encryption_mode")

    @catalog_encryption_mode.setter
    def catalog_encryption_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "catalog_encryption_mode", value)

    @property
    @pulumi.getter(name="sseAwsKmsKeyId")
    def sse_aws_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS KMS key to use for encryption at rest.
        """
        return pulumi.get(self, "sse_aws_kms_key_id")

    @sse_aws_kms_key_id.setter
    def sse_aws_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sse_aws_kms_key_id", value)


@pulumi.input_type
class JobCommandArgs:
    def __init__(__self__, *,
                 script_location: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 python_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] script_location: Specifies the S3 path to a script that executes a job.
        :param pulumi.Input[str] name: The name of the job command. Defaults to `glueetl`. Use `pythonshell` for Python Shell Job Type, or `gluestreaming` for Streaming Job Type. `max_capacity` needs to be set if `pythonshell` is chosen.
        :param pulumi.Input[str] python_version: The Python version being used to execute a Python shell job. Allowed values are 2 or 3.
        """
        pulumi.set(__self__, "script_location", script_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)

    @property
    @pulumi.getter(name="scriptLocation")
    def script_location(self) -> pulumi.Input[str]:
        """
        Specifies the S3 path to a script that executes a job.
        """
        return pulumi.get(self, "script_location")

    @script_location.setter
    def script_location(self, value: pulumi.Input[str]):
        pulumi.set(self, "script_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the job command. Defaults to `glueetl`. Use `pythonshell` for Python Shell Job Type, or `gluestreaming` for Streaming Job Type. `max_capacity` needs to be set if `pythonshell` is chosen.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Python version being used to execute a Python shell job. Allowed values are 2 or 3.
        """
        return pulumi.get(self, "python_version")

    @python_version.setter
    def python_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "python_version", value)


@pulumi.input_type
class JobExecutionPropertyArgs:
    def __init__(__self__, *,
                 max_concurrent_runs: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_concurrent_runs: The maximum number of concurrent runs allowed for a job. The default is 1.
        """
        if max_concurrent_runs is not None:
            pulumi.set(__self__, "max_concurrent_runs", max_concurrent_runs)

    @property
    @pulumi.getter(name="maxConcurrentRuns")
    def max_concurrent_runs(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of concurrent runs allowed for a job. The default is 1.
        """
        return pulumi.get(self, "max_concurrent_runs")

    @max_concurrent_runs.setter
    def max_concurrent_runs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_runs", value)


@pulumi.input_type
class JobNotificationPropertyArgs:
    def __init__(__self__, *,
                 notify_delay_after: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] notify_delay_after: After a job run starts, the number of minutes to wait before sending a job run delay notification.
        """
        if notify_delay_after is not None:
            pulumi.set(__self__, "notify_delay_after", notify_delay_after)

    @property
    @pulumi.getter(name="notifyDelayAfter")
    def notify_delay_after(self) -> Optional[pulumi.Input[int]]:
        """
        After a job run starts, the number of minutes to wait before sending a job run delay notification.
        """
        return pulumi.get(self, "notify_delay_after")

    @notify_delay_after.setter
    def notify_delay_after(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notify_delay_after", value)


@pulumi.input_type
class MLTransformInputRecordTableArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] database_name: A database name in the AWS Glue Data Catalog.
        :param pulumi.Input[str] table_name: A table name in the AWS Glue Data Catalog.
        :param pulumi.Input[str] catalog_id: A unique identifier for the AWS Glue Data Catalog.
        :param pulumi.Input[str] connection_name: The name of the connection to the AWS Glue Data Catalog.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        A database name in the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        A table name in the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection to the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)


@pulumi.input_type
class MLTransformParametersArgs:
    def __init__(__self__, *,
                 find_matches_parameters: pulumi.Input['MLTransformParametersFindMatchesParametersArgs'],
                 transform_type: pulumi.Input[str]):
        """
        :param pulumi.Input['MLTransformParametersFindMatchesParametersArgs'] find_matches_parameters: The parameters for the find matches algorithm. see Find Matches Parameters.
        :param pulumi.Input[str] transform_type: The type of machine learning transform. For information about the types of machine learning transforms, see [Creating Machine Learning Transforms](http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
        """
        pulumi.set(__self__, "find_matches_parameters", find_matches_parameters)
        pulumi.set(__self__, "transform_type", transform_type)

    @property
    @pulumi.getter(name="findMatchesParameters")
    def find_matches_parameters(self) -> pulumi.Input['MLTransformParametersFindMatchesParametersArgs']:
        """
        The parameters for the find matches algorithm. see Find Matches Parameters.
        """
        return pulumi.get(self, "find_matches_parameters")

    @find_matches_parameters.setter
    def find_matches_parameters(self, value: pulumi.Input['MLTransformParametersFindMatchesParametersArgs']):
        pulumi.set(self, "find_matches_parameters", value)

    @property
    @pulumi.getter(name="transformType")
    def transform_type(self) -> pulumi.Input[str]:
        """
        The type of machine learning transform. For information about the types of machine learning transforms, see [Creating Machine Learning Transforms](http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
        """
        return pulumi.get(self, "transform_type")

    @transform_type.setter
    def transform_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "transform_type", value)


@pulumi.input_type
class MLTransformParametersFindMatchesParametersArgs:
    def __init__(__self__, *,
                 accuracy_cost_trade_off: Optional[pulumi.Input[float]] = None,
                 enforce_provided_labels: Optional[pulumi.Input[bool]] = None,
                 precision_recall_trade_off: Optional[pulumi.Input[float]] = None,
                 primary_key_column_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[float] accuracy_cost_trade_off: The value that is selected when tuning your transform for a balance between accuracy and cost.
        :param pulumi.Input[bool] enforce_provided_labels: The value to switch on or off to force the output to match the provided labels from users.
        :param pulumi.Input[float] precision_recall_trade_off: The value selected when tuning your transform for a balance between precision and recall.
        :param pulumi.Input[str] primary_key_column_name: The name of a column that uniquely identifies rows in the source table.
        """
        if accuracy_cost_trade_off is not None:
            pulumi.set(__self__, "accuracy_cost_trade_off", accuracy_cost_trade_off)
        if enforce_provided_labels is not None:
            pulumi.set(__self__, "enforce_provided_labels", enforce_provided_labels)
        if precision_recall_trade_off is not None:
            pulumi.set(__self__, "precision_recall_trade_off", precision_recall_trade_off)
        if primary_key_column_name is not None:
            pulumi.set(__self__, "primary_key_column_name", primary_key_column_name)

    @property
    @pulumi.getter(name="accuracyCostTradeOff")
    def accuracy_cost_trade_off(self) -> Optional[pulumi.Input[float]]:
        """
        The value that is selected when tuning your transform for a balance between accuracy and cost.
        """
        return pulumi.get(self, "accuracy_cost_trade_off")

    @accuracy_cost_trade_off.setter
    def accuracy_cost_trade_off(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "accuracy_cost_trade_off", value)

    @property
    @pulumi.getter(name="enforceProvidedLabels")
    def enforce_provided_labels(self) -> Optional[pulumi.Input[bool]]:
        """
        The value to switch on or off to force the output to match the provided labels from users.
        """
        return pulumi.get(self, "enforce_provided_labels")

    @enforce_provided_labels.setter
    def enforce_provided_labels(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce_provided_labels", value)

    @property
    @pulumi.getter(name="precisionRecallTradeOff")
    def precision_recall_trade_off(self) -> Optional[pulumi.Input[float]]:
        """
        The value selected when tuning your transform for a balance between precision and recall.
        """
        return pulumi.get(self, "precision_recall_trade_off")

    @precision_recall_trade_off.setter
    def precision_recall_trade_off(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "precision_recall_trade_off", value)

    @property
    @pulumi.getter(name="primaryKeyColumnName")
    def primary_key_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a column that uniquely identifies rows in the source table.
        """
        return pulumi.get(self, "primary_key_column_name")

    @primary_key_column_name.setter
    def primary_key_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key_column_name", value)


@pulumi.input_type
class MLTransformSchemaArgs:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data_type: The type of data in the column.
        :param pulumi.Input[str] name: The name you assign to this ML Transform. It must be unique in your account.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of data in the column.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you assign to this ML Transform. It must be unique in your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PartitionIndexPartitionIndexArgs:
    def __init__(__self__, *,
                 index_name: Optional[pulumi.Input[str]] = None,
                 index_status: Optional[pulumi.Input[str]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] index_name: Name of the partition index.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: Keys for the partition index.
        """
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)
        if index_status is not None:
            pulumi.set(__self__, "index_status", index_status)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the partition index.
        """
        return pulumi.get(self, "index_name")

    @index_name.setter
    def index_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_name", value)

    @property
    @pulumi.getter(name="indexStatus")
    def index_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "index_status")

    @index_status.setter
    def index_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_status", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Keys for the partition index.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)


@pulumi.input_type
class PartitionStorageDescriptorArgs:
    def __init__(__self__, *,
                 bucket_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['PartitionStorageDescriptorColumnArgs']]]] = None,
                 compressed: Optional[pulumi.Input[bool]] = None,
                 input_format: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 number_of_buckets: Optional[pulumi.Input[int]] = None,
                 output_format: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ser_de_info: Optional[pulumi.Input['PartitionStorageDescriptorSerDeInfoArgs']] = None,
                 skewed_info: Optional[pulumi.Input['PartitionStorageDescriptorSkewedInfoArgs']] = None,
                 sort_columns: Optional[pulumi.Input[Sequence[pulumi.Input['PartitionStorageDescriptorSortColumnArgs']]]] = None,
                 stored_as_sub_directories: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bucket_columns: A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
        :param pulumi.Input[Sequence[pulumi.Input['PartitionStorageDescriptorColumnArgs']]] columns: A list of the Columns in the table.
        :param pulumi.Input[bool] compressed: True if the data in the table is compressed, or False if not.
        :param pulumi.Input[str] input_format: The input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
        :param pulumi.Input[str] location: The physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
        :param pulumi.Input[int] number_of_buckets: Must be specified if the table contains any dimension columns.
        :param pulumi.Input[str] output_format: The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: A map of initialization parameters for the SerDe, in key-value form.
        :param pulumi.Input['PartitionStorageDescriptorSerDeInfoArgs'] ser_de_info: Serialization/deserialization (SerDe) information.
        :param pulumi.Input['PartitionStorageDescriptorSkewedInfoArgs'] skewed_info: Information about values that appear very frequently in a column (skewed values).
        :param pulumi.Input[Sequence[pulumi.Input['PartitionStorageDescriptorSortColumnArgs']]] sort_columns: A list of Order objects specifying the sort order of each bucket in the table.
        :param pulumi.Input[bool] stored_as_sub_directories: True if the table data is stored in subdirectories, or False if not.
        """
        if bucket_columns is not None:
            pulumi.set(__self__, "bucket_columns", bucket_columns)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if compressed is not None:
            pulumi.set(__self__, "compressed", compressed)
        if input_format is not None:
            pulumi.set(__self__, "input_format", input_format)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if number_of_buckets is not None:
            pulumi.set(__self__, "number_of_buckets", number_of_buckets)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if ser_de_info is not None:
            pulumi.set(__self__, "ser_de_info", ser_de_info)
        if skewed_info is not None:
            pulumi.set(__self__, "skewed_info", skewed_info)
        if sort_columns is not None:
            pulumi.set(__self__, "sort_columns", sort_columns)
        if stored_as_sub_directories is not None:
            pulumi.set(__self__, "stored_as_sub_directories", stored_as_sub_directories)

    @property
    @pulumi.getter(name="bucketColumns")
    def bucket_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
        """
        return pulumi.get(self, "bucket_columns")

    @bucket_columns.setter
    def bucket_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bucket_columns", value)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PartitionStorageDescriptorColumnArgs']]]]:
        """
        A list of the Columns in the table.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PartitionStorageDescriptorColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter
    def compressed(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the data in the table is compressed, or False if not.
        """
        return pulumi.get(self, "compressed")

    @compressed.setter
    def compressed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compressed", value)

    @property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> Optional[pulumi.Input[str]]:
        """
        The input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
        """
        return pulumi.get(self, "input_format")

    @input_format.setter
    def input_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_format", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="numberOfBuckets")
    def number_of_buckets(self) -> Optional[pulumi.Input[int]]:
        """
        Must be specified if the table contains any dimension columns.
        """
        return pulumi.get(self, "number_of_buckets")

    @number_of_buckets.setter
    def number_of_buckets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_buckets", value)

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[pulumi.Input[str]]:
        """
        The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_format", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="serDeInfo")
    def ser_de_info(self) -> Optional[pulumi.Input['PartitionStorageDescriptorSerDeInfoArgs']]:
        """
        Serialization/deserialization (SerDe) information.
        """
        return pulumi.get(self, "ser_de_info")

    @ser_de_info.setter
    def ser_de_info(self, value: Optional[pulumi.Input['PartitionStorageDescriptorSerDeInfoArgs']]):
        pulumi.set(self, "ser_de_info", value)

    @property
    @pulumi.getter(name="skewedInfo")
    def skewed_info(self) -> Optional[pulumi.Input['PartitionStorageDescriptorSkewedInfoArgs']]:
        """
        Information about values that appear very frequently in a column (skewed values).
        """
        return pulumi.get(self, "skewed_info")

    @skewed_info.setter
    def skewed_info(self, value: Optional[pulumi.Input['PartitionStorageDescriptorSkewedInfoArgs']]):
        pulumi.set(self, "skewed_info", value)

    @property
    @pulumi.getter(name="sortColumns")
    def sort_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PartitionStorageDescriptorSortColumnArgs']]]]:
        """
        A list of Order objects specifying the sort order of each bucket in the table.
        """
        return pulumi.get(self, "sort_columns")

    @sort_columns.setter
    def sort_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PartitionStorageDescriptorSortColumnArgs']]]]):
        pulumi.set(self, "sort_columns", value)

    @property
    @pulumi.getter(name="storedAsSubDirectories")
    def stored_as_sub_directories(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the table data is stored in subdirectories, or False if not.
        """
        return pulumi.get(self, "stored_as_sub_directories")

    @stored_as_sub_directories.setter
    def stored_as_sub_directories(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stored_as_sub_directories", value)


@pulumi.input_type
class PartitionStorageDescriptorColumnArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the SerDe.
        :param pulumi.Input[str] comment: Free-form text comment.
        :param pulumi.Input[str] type: The datatype of data in the Column.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the SerDe.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Free-form text comment.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The datatype of data in the Column.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PartitionStorageDescriptorSerDeInfoArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 serialization_library: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the SerDe.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: A map of initialization parameters for the SerDe, in key-value form.
        :param pulumi.Input[str] serialization_library: Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if serialization_library is not None:
            pulumi.set(__self__, "serialization_library", serialization_library)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SerDe.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="serializationLibrary")
    def serialization_library(self) -> Optional[pulumi.Input[str]]:
        """
        Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
        """
        return pulumi.get(self, "serialization_library")

    @serialization_library.setter
    def serialization_library(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serialization_library", value)


@pulumi.input_type
class PartitionStorageDescriptorSkewedInfoArgs:
    def __init__(__self__, *,
                 skewed_column_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skewed_column_value_location_maps: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 skewed_column_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] skewed_column_names: A list of names of columns that contain skewed values.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] skewed_column_value_location_maps: A list of values that appear so frequently as to be considered skewed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] skewed_column_values: A map of skewed values to the columns that contain them.
        """
        if skewed_column_names is not None:
            pulumi.set(__self__, "skewed_column_names", skewed_column_names)
        if skewed_column_value_location_maps is not None:
            pulumi.set(__self__, "skewed_column_value_location_maps", skewed_column_value_location_maps)
        if skewed_column_values is not None:
            pulumi.set(__self__, "skewed_column_values", skewed_column_values)

    @property
    @pulumi.getter(name="skewedColumnNames")
    def skewed_column_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of names of columns that contain skewed values.
        """
        return pulumi.get(self, "skewed_column_names")

    @skewed_column_names.setter
    def skewed_column_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "skewed_column_names", value)

    @property
    @pulumi.getter(name="skewedColumnValueLocationMaps")
    def skewed_column_value_location_maps(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A list of values that appear so frequently as to be considered skewed.
        """
        return pulumi.get(self, "skewed_column_value_location_maps")

    @skewed_column_value_location_maps.setter
    def skewed_column_value_location_maps(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "skewed_column_value_location_maps", value)

    @property
    @pulumi.getter(name="skewedColumnValues")
    def skewed_column_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A map of skewed values to the columns that contain them.
        """
        return pulumi.get(self, "skewed_column_values")

    @skewed_column_values.setter
    def skewed_column_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "skewed_column_values", value)


@pulumi.input_type
class PartitionStorageDescriptorSortColumnArgs:
    def __init__(__self__, *,
                 column: pulumi.Input[str],
                 sort_order: pulumi.Input[int]):
        """
        :param pulumi.Input[str] column: The name of the column.
        :param pulumi.Input[int] sort_order: Indicates that the column is sorted in ascending order (== 1), or in descending order (==0).
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "sort_order", sort_order)

    @property
    @pulumi.getter
    def column(self) -> pulumi.Input[str]:
        """
        The name of the column.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: pulumi.Input[str]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> pulumi.Input[int]:
        """
        Indicates that the column is sorted in ascending order (== 1), or in descending order (==0).
        """
        return pulumi.get(self, "sort_order")

    @sort_order.setter
    def sort_order(self, value: pulumi.Input[int]):
        pulumi.set(self, "sort_order", value)


@pulumi.input_type
class SecurityConfigurationEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 cloudwatch_encryption: pulumi.Input['SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs'],
                 job_bookmarks_encryption: pulumi.Input['SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs'],
                 s3_encryption: pulumi.Input['SecurityConfigurationEncryptionConfigurationS3EncryptionArgs']):
        """
        :param pulumi.Input['SecurityConfigurationEncryptionConfigurationS3EncryptionArgs'] s3_encryption: A `s3_encryption ` block as described below, which contains encryption configuration for S3 data.
        """
        pulumi.set(__self__, "cloudwatch_encryption", cloudwatch_encryption)
        pulumi.set(__self__, "job_bookmarks_encryption", job_bookmarks_encryption)
        pulumi.set(__self__, "s3_encryption", s3_encryption)

    @property
    @pulumi.getter(name="cloudwatchEncryption")
    def cloudwatch_encryption(self) -> pulumi.Input['SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs']:
        return pulumi.get(self, "cloudwatch_encryption")

    @cloudwatch_encryption.setter
    def cloudwatch_encryption(self, value: pulumi.Input['SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs']):
        pulumi.set(self, "cloudwatch_encryption", value)

    @property
    @pulumi.getter(name="jobBookmarksEncryption")
    def job_bookmarks_encryption(self) -> pulumi.Input['SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs']:
        return pulumi.get(self, "job_bookmarks_encryption")

    @job_bookmarks_encryption.setter
    def job_bookmarks_encryption(self, value: pulumi.Input['SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs']):
        pulumi.set(self, "job_bookmarks_encryption", value)

    @property
    @pulumi.getter(name="s3Encryption")
    def s3_encryption(self) -> pulumi.Input['SecurityConfigurationEncryptionConfigurationS3EncryptionArgs']:
        """
        A `s3_encryption ` block as described below, which contains encryption configuration for S3 data.
        """
        return pulumi.get(self, "s3_encryption")

    @s3_encryption.setter
    def s3_encryption(self, value: pulumi.Input['SecurityConfigurationEncryptionConfigurationS3EncryptionArgs']):
        pulumi.set(self, "s3_encryption", value)


@pulumi.input_type
class SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs:
    def __init__(__self__, *,
                 cloudwatch_encryption_mode: Optional[pulumi.Input[str]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cloudwatch_encryption_mode: Encryption mode to use for CloudWatch data. Valid values: `DISABLED`, `SSE-KMS`. Default value: `DISABLED`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        if cloudwatch_encryption_mode is not None:
            pulumi.set(__self__, "cloudwatch_encryption_mode", cloudwatch_encryption_mode)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="cloudwatchEncryptionMode")
    def cloudwatch_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Encryption mode to use for CloudWatch data. Valid values: `DISABLED`, `SSE-KMS`. Default value: `DISABLED`.
        """
        return pulumi.get(self, "cloudwatch_encryption_mode")

    @cloudwatch_encryption_mode.setter
    def cloudwatch_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch_encryption_mode", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


@pulumi.input_type
class SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs:
    def __init__(__self__, *,
                 job_bookmarks_encryption_mode: Optional[pulumi.Input[str]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] job_bookmarks_encryption_mode: Encryption mode to use for job bookmarks data. Valid values: `CSE-KMS`, `DISABLED`. Default value: `DISABLED`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        if job_bookmarks_encryption_mode is not None:
            pulumi.set(__self__, "job_bookmarks_encryption_mode", job_bookmarks_encryption_mode)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="jobBookmarksEncryptionMode")
    def job_bookmarks_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Encryption mode to use for job bookmarks data. Valid values: `CSE-KMS`, `DISABLED`. Default value: `DISABLED`.
        """
        return pulumi.get(self, "job_bookmarks_encryption_mode")

    @job_bookmarks_encryption_mode.setter
    def job_bookmarks_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_bookmarks_encryption_mode", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


@pulumi.input_type
class SecurityConfigurationEncryptionConfigurationS3EncryptionArgs:
    def __init__(__self__, *,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 s3_encryption_mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        :param pulumi.Input[str] s3_encryption_mode: Encryption mode to use for S3 data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-S3`. Default value: `DISABLED`.
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if s3_encryption_mode is not None:
            pulumi.set(__self__, "s3_encryption_mode", s3_encryption_mode)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="s3EncryptionMode")
    def s3_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Encryption mode to use for S3 data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-S3`. Default value: `DISABLED`.
        """
        return pulumi.get(self, "s3_encryption_mode")

    @s3_encryption_mode.setter
    def s3_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_encryption_mode", value)


@pulumi.input_type
class TriggerActionArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 crawler_name: Optional[pulumi.Input[str]] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 notification_property: Optional[pulumi.Input['TriggerActionNotificationPropertyArgs']] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] arguments: Arguments to be passed to the job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.
        :param pulumi.Input[str] crawler_name: The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
        :param pulumi.Input[str] job_name: The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
        :param pulumi.Input['TriggerActionNotificationPropertyArgs'] notification_property: Specifies configuration properties of a job run notification. See Notification Property details below.
        :param pulumi.Input[str] security_configuration: The name of the Security Configuration structure to be used with this action.
        :param pulumi.Input[int] timeout: The job run timeout in minutes. It overrides the timeout value of the job.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if crawler_name is not None:
            pulumi.set(__self__, "crawler_name", crawler_name)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if notification_property is not None:
            pulumi.set(__self__, "notification_property", notification_property)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Arguments to be passed to the job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="crawlerName")
    def crawler_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
        """
        return pulumi.get(self, "crawler_name")

    @crawler_name.setter
    def crawler_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crawler_name", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> Optional[pulumi.Input['TriggerActionNotificationPropertyArgs']]:
        """
        Specifies configuration properties of a job run notification. See Notification Property details below.
        """
        return pulumi.get(self, "notification_property")

    @notification_property.setter
    def notification_property(self, value: Optional[pulumi.Input['TriggerActionNotificationPropertyArgs']]):
        pulumi.set(self, "notification_property", value)

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Security Configuration structure to be used with this action.
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_configuration", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The job run timeout in minutes. It overrides the timeout value of the job.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class TriggerActionNotificationPropertyArgs:
    def __init__(__self__, *,
                 notify_delay_after: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] notify_delay_after: After a job run starts, the number of minutes to wait before sending a job run delay notification.
        """
        if notify_delay_after is not None:
            pulumi.set(__self__, "notify_delay_after", notify_delay_after)

    @property
    @pulumi.getter(name="notifyDelayAfter")
    def notify_delay_after(self) -> Optional[pulumi.Input[int]]:
        """
        After a job run starts, the number of minutes to wait before sending a job run delay notification.
        """
        return pulumi.get(self, "notify_delay_after")

    @notify_delay_after.setter
    def notify_delay_after(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notify_delay_after", value)


@pulumi.input_type
class TriggerEventBatchingConditionArgs:
    def __init__(__self__, *,
                 batch_size: pulumi.Input[int],
                 batch_window: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] batch_size: Number of events that must be received from Amazon EventBridge before EventBridge  event trigger fires.
        :param pulumi.Input[int] batch_window: Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received. Default value is `900`.
        """
        pulumi.set(__self__, "batch_size", batch_size)
        if batch_window is not None:
            pulumi.set(__self__, "batch_window", batch_window)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> pulumi.Input[int]:
        """
        Number of events that must be received from Amazon EventBridge before EventBridge  event trigger fires.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter(name="batchWindow")
    def batch_window(self) -> Optional[pulumi.Input[int]]:
        """
        Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received. Default value is `900`.
        """
        return pulumi.get(self, "batch_window")

    @batch_window.setter
    def batch_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_window", value)


@pulumi.input_type
class TriggerPredicateArgs:
    def __init__(__self__, *,
                 conditions: pulumi.Input[Sequence[pulumi.Input['TriggerPredicateConditionArgs']]],
                 logical: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['TriggerPredicateConditionArgs']]] conditions: A list of the conditions that determine when the trigger will fire. See Conditions.
        :param pulumi.Input[str] logical: How to handle multiple conditions. Defaults to `AND`. Valid values are `AND` or `ANY`.
        """
        pulumi.set(__self__, "conditions", conditions)
        if logical is not None:
            pulumi.set(__self__, "logical", logical)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['TriggerPredicateConditionArgs']]]:
        """
        A list of the conditions that determine when the trigger will fire. See Conditions.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['TriggerPredicateConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def logical(self) -> Optional[pulumi.Input[str]]:
        """
        How to handle multiple conditions. Defaults to `AND`. Valid values are `AND` or `ANY`.
        """
        return pulumi.get(self, "logical")

    @logical.setter
    def logical(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical", value)


@pulumi.input_type
class TriggerPredicateConditionArgs:
    def __init__(__self__, *,
                 crawl_state: Optional[pulumi.Input[str]] = None,
                 crawler_name: Optional[pulumi.Input[str]] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 logical_operator: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] crawl_state: The condition crawl state. Currently, the values supported are `RUNNING`, `SUCCEEDED`, `CANCELLED`, and `FAILED`. If this is specified, `crawler_name` must also be specified. Conflicts with `state`.
        :param pulumi.Input[str] crawler_name: The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
        :param pulumi.Input[str] job_name: The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
        :param pulumi.Input[str] logical_operator: A logical operator. Defaults to `EQUALS`.
        :param pulumi.Input[str] state: The condition job state. Currently, the values supported are `SUCCEEDED`, `STOPPED`, `TIMEOUT` and `FAILED`. If this is specified, `job_name` must also be specified. Conflicts with `crawler_state`.
        """
        if crawl_state is not None:
            pulumi.set(__self__, "crawl_state", crawl_state)
        if crawler_name is not None:
            pulumi.set(__self__, "crawler_name", crawler_name)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if logical_operator is not None:
            pulumi.set(__self__, "logical_operator", logical_operator)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="crawlState")
    def crawl_state(self) -> Optional[pulumi.Input[str]]:
        """
        The condition crawl state. Currently, the values supported are `RUNNING`, `SUCCEEDED`, `CANCELLED`, and `FAILED`. If this is specified, `crawler_name` must also be specified. Conflicts with `state`.
        """
        return pulumi.get(self, "crawl_state")

    @crawl_state.setter
    def crawl_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crawl_state", value)

    @property
    @pulumi.getter(name="crawlerName")
    def crawler_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
        """
        return pulumi.get(self, "crawler_name")

    @crawler_name.setter
    def crawler_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crawler_name", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="logicalOperator")
    def logical_operator(self) -> Optional[pulumi.Input[str]]:
        """
        A logical operator. Defaults to `EQUALS`.
        """
        return pulumi.get(self, "logical_operator")

    @logical_operator.setter
    def logical_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical_operator", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The condition job state. Currently, the values supported are `SUCCEEDED`, `STOPPED`, `TIMEOUT` and `FAILED`. If this is specified, `job_name` must also be specified. Conflicts with `crawler_state`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class UserDefinedFunctionResourceUriArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 uri: pulumi.Input[str]):
        """
        :param pulumi.Input[str] resource_type: The type of the resource. can be one of `JAR`, `FILE`, and `ARCHIVE`.
        :param pulumi.Input[str] uri: The URI for accessing the resource.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The type of the resource. can be one of `JAR`, `FILE`, and `ARCHIVE`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The URI for accessing the resource.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GetScriptDagEdgeArgs:
    def __init__(__self__, *,
                 source: str,
                 target: str,
                 target_parameter: Optional[str] = None):
        """
        :param str source: The ID of the node at which the edge starts.
        :param str target: The ID of the node at which the edge ends.
        :param str target_parameter: The target of the edge.
        """
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if target_parameter is not None:
            pulumi.set(__self__, "target_parameter", target_parameter)

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The ID of the node at which the edge starts.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: str):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The ID of the node at which the edge ends.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: str):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="targetParameter")
    def target_parameter(self) -> Optional[str]:
        """
        The target of the edge.
        """
        return pulumi.get(self, "target_parameter")

    @target_parameter.setter
    def target_parameter(self, value: Optional[str]):
        pulumi.set(self, "target_parameter", value)


@pulumi.input_type
class GetScriptDagNodeArgs:
    def __init__(__self__, *,
                 args: Sequence['GetScriptDagNodeArgArgs'],
                 id: str,
                 node_type: str,
                 line_number: Optional[int] = None):
        """
        :param Sequence['GetScriptDagNodeArgArgs'] args: Nested configuration an argument or property of a node. Defined below.
        :param str id: A node identifier that is unique within the node's graph.
        :param str node_type: The type of node this is.
        :param int line_number: The line number of the node.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "node_type", node_type)
        if line_number is not None:
            pulumi.set(__self__, "line_number", line_number)

    @property
    @pulumi.getter
    def args(self) -> Sequence['GetScriptDagNodeArgArgs']:
        """
        Nested configuration an argument or property of a node. Defined below.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Sequence['GetScriptDagNodeArgArgs']):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A node identifier that is unique within the node's graph.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        The type of node this is.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: str):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="lineNumber")
    def line_number(self) -> Optional[int]:
        """
        The line number of the node.
        """
        return pulumi.get(self, "line_number")

    @line_number.setter
    def line_number(self, value: Optional[int]):
        pulumi.set(self, "line_number", value)


@pulumi.input_type
class GetScriptDagNodeArgArgs:
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 param: Optional[bool] = None):
        """
        :param str name: The name of the argument or property.
        :param str value: The value of the argument or property.
        :param bool param: Boolean if the value is used as a parameter. Defaults to `false`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if param is not None:
            pulumi.set(__self__, "param", param)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the argument or property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the argument or property.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: str):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def param(self) -> Optional[bool]:
        """
        Boolean if the value is used as a parameter. Defaults to `false`.
        """
        return pulumi.get(self, "param")

    @param.setter
    def param(self, value: Optional[bool]):
        pulumi.set(self, "param", value)


