# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DataRepositoryAssociationS3',
    'DataRepositoryAssociationS3AutoExportPolicy',
    'DataRepositoryAssociationS3AutoImportPolicy',
    'LustreFileSystemLogConfiguration',
    'OntapFileSystemDiskIopsConfiguration',
    'OntapFileSystemEndpoint',
    'OntapFileSystemEndpointIntercluster',
    'OntapFileSystemEndpointManagement',
    'OntapStorageVirtualMachineActiveDirectoryConfiguration',
    'OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration',
    'OntapStorageVirtualMachineEndpoint',
    'OntapStorageVirtualMachineEndpointIscse',
    'OntapStorageVirtualMachineEndpointManagement',
    'OntapStorageVirtualMachineEndpointNf',
    'OntapStorageVirtualMachineEndpointSmb',
    'OntapVolumeTieringPolicy',
    'OpenZfsFileSystemDiskIopsConfiguration',
    'OpenZfsFileSystemRootVolumeConfiguration',
    'OpenZfsFileSystemRootVolumeConfigurationNfsExports',
    'OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfiguration',
    'OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota',
    'OpenZfsVolumeNfsExports',
    'OpenZfsVolumeNfsExportsClientConfiguration',
    'OpenZfsVolumeOriginSnapshot',
    'OpenZfsVolumeUserAndGroupQuota',
    'WindowsFileSystemAuditLogConfiguration',
    'WindowsFileSystemSelfManagedActiveDirectory',
]

@pulumi.output_type
class DataRepositoryAssociationS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoExportPolicy":
            suggest = "auto_export_policy"
        elif key == "autoImportPolicy":
            suggest = "auto_import_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataRepositoryAssociationS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataRepositoryAssociationS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataRepositoryAssociationS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_export_policy: Optional['outputs.DataRepositoryAssociationS3AutoExportPolicy'] = None,
                 auto_import_policy: Optional['outputs.DataRepositoryAssociationS3AutoImportPolicy'] = None):
        """
        :param 'DataRepositoryAssociationS3AutoExportPolicyArgs' auto_export_policy: Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
        :param 'DataRepositoryAssociationS3AutoImportPolicyArgs' auto_import_policy: Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
        """
        if auto_export_policy is not None:
            pulumi.set(__self__, "auto_export_policy", auto_export_policy)
        if auto_import_policy is not None:
            pulumi.set(__self__, "auto_import_policy", auto_import_policy)

    @property
    @pulumi.getter(name="autoExportPolicy")
    def auto_export_policy(self) -> Optional['outputs.DataRepositoryAssociationS3AutoExportPolicy']:
        """
        Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
        """
        return pulumi.get(self, "auto_export_policy")

    @property
    @pulumi.getter(name="autoImportPolicy")
    def auto_import_policy(self) -> Optional['outputs.DataRepositoryAssociationS3AutoImportPolicy']:
        """
        Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
        """
        return pulumi.get(self, "auto_import_policy")


@pulumi.output_type
class DataRepositoryAssociationS3AutoExportPolicy(dict):
    def __init__(__self__, *,
                 events: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] events: A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence[str]]:
        """
        A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class DataRepositoryAssociationS3AutoImportPolicy(dict):
    def __init__(__self__, *,
                 events: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] events: A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence[str]]:
        """
        A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class LustreFileSystemLogConfiguration(dict):
    def __init__(__self__, *,
                 destination: Optional[str] = None,
                 level: Optional[str] = None):
        """
        :param str destination: The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
        :param str level: Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class OntapFileSystemDiskIopsConfiguration(dict):
    def __init__(__self__, *,
                 iops: Optional[int] = None,
                 mode: Optional[str] = None):
        """
        :param int iops: - The total number of SSD IOPS provisioned for the file system.
        :param str mode: - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        - The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class OntapFileSystemEndpoint(dict):
    def __init__(__self__, *,
                 interclusters: Optional[Sequence['outputs.OntapFileSystemEndpointIntercluster']] = None,
                 managements: Optional[Sequence['outputs.OntapFileSystemEndpointManagement']] = None):
        """
        :param Sequence['OntapFileSystemEndpointInterclusterArgs'] interclusters: An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        :param Sequence['OntapFileSystemEndpointManagementArgs'] managements: An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        if interclusters is not None:
            pulumi.set(__self__, "interclusters", interclusters)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)

    @property
    @pulumi.getter
    def interclusters(self) -> Optional[Sequence['outputs.OntapFileSystemEndpointIntercluster']]:
        """
        An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        """
        return pulumi.get(self, "interclusters")

    @property
    @pulumi.getter
    def managements(self) -> Optional[Sequence['outputs.OntapFileSystemEndpointManagement']]:
        """
        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        return pulumi.get(self, "managements")


@pulumi.output_type
class OntapFileSystemEndpointIntercluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapFileSystemEndpointIntercluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapFileSystemEndpointIntercluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapFileSystemEndpointIntercluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapFileSystemEndpointManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapFileSystemEndpointManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapFileSystemEndpointManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapFileSystemEndpointManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapStorageVirtualMachineActiveDirectoryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "netbiosName":
            suggest = "netbios_name"
        elif key == "selfManagedActiveDirectoryConfiguration":
            suggest = "self_managed_active_directory_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineActiveDirectoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineActiveDirectoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineActiveDirectoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 netbios_name: Optional[str] = None,
                 self_managed_active_directory_configuration: Optional['outputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration'] = None):
        """
        :param str netbios_name: The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. It is limited to 15 characters because of standard NetBIOS naming limits.
        """
        if netbios_name is not None:
            pulumi.set(__self__, "netbios_name", netbios_name)
        if self_managed_active_directory_configuration is not None:
            pulumi.set(__self__, "self_managed_active_directory_configuration", self_managed_active_directory_configuration)

    @property
    @pulumi.getter(name="netbiosName")
    def netbios_name(self) -> Optional[str]:
        """
        The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. It is limited to 15 characters because of standard NetBIOS naming limits.
        """
        return pulumi.get(self, "netbios_name")

    @property
    @pulumi.getter(name="selfManagedActiveDirectoryConfiguration")
    def self_managed_active_directory_configuration(self) -> Optional['outputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration']:
        return pulumi.get(self, "self_managed_active_directory_configuration")


@pulumi.output_type
class OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsIps":
            suggest = "dns_ips"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "fileSystemAdministratorsGroup":
            suggest = "file_system_administrators_group"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_ips: Sequence[str],
                 domain_name: str,
                 password: str,
                 username: str,
                 file_system_administrators_group: Optional[str] = None,
                 organizational_unit_distinguished_name: Optional[str] = None):
        """
        :param Sequence[str] dns_ips: A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        :param str domain_name: The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        :param str password: The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param str username: The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param str file_system_administrators_group: The name of the domain group whose members are granted administrative privileges for the SVM. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        :param str organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the SVM. If none is provided, the SVM is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Sequence[str]:
        """
        A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        """
        return pulumi.get(self, "dns_ips")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[str]:
        """
        The name of the domain group whose members are granted administrative privileges for the SVM. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[str]:
        """
        The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the SVM. If none is provided, the SVM is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")


@pulumi.output_type
class OntapStorageVirtualMachineEndpoint(dict):
    def __init__(__self__, *,
                 iscses: Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointIscse']] = None,
                 managements: Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointManagement']] = None,
                 nfs: Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointNf']] = None,
                 smbs: Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointSmb']] = None):
        """
        :param Sequence['OntapStorageVirtualMachineEndpointIscseArgs'] iscses: An endpoint for accessing data on your storage virtual machine via iSCSI protocol. See Endpoint.
        :param Sequence['OntapStorageVirtualMachineEndpointManagementArgs'] managements: An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        :param Sequence['OntapStorageVirtualMachineEndpointNfArgs'] nfs: An endpoint for accessing data on your storage virtual machine via NFS protocol. See Endpoint.
        :param Sequence['OntapStorageVirtualMachineEndpointSmbArgs'] smbs: An endpoint for accessing data on your storage virtual machine via SMB protocol. This is only set if an active_directory_configuration has been set. See Endpoint.
        """
        if iscses is not None:
            pulumi.set(__self__, "iscses", iscses)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if smbs is not None:
            pulumi.set(__self__, "smbs", smbs)

    @property
    @pulumi.getter
    def iscses(self) -> Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointIscse']]:
        """
        An endpoint for accessing data on your storage virtual machine via iSCSI protocol. See Endpoint.
        """
        return pulumi.get(self, "iscses")

    @property
    @pulumi.getter
    def managements(self) -> Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointManagement']]:
        """
        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        return pulumi.get(self, "managements")

    @property
    @pulumi.getter
    def nfs(self) -> Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointNf']]:
        """
        An endpoint for accessing data on your storage virtual machine via NFS protocol. See Endpoint.
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter
    def smbs(self) -> Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointSmb']]:
        """
        An endpoint for accessing data on your storage virtual machine via SMB protocol. This is only set if an active_directory_configuration has been set. See Endpoint.
        """
        return pulumi.get(self, "smbs")


@pulumi.output_type
class OntapStorageVirtualMachineEndpointIscse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineEndpointIscse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineEndpointIscse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineEndpointIscse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapStorageVirtualMachineEndpointManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineEndpointManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineEndpointManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineEndpointManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapStorageVirtualMachineEndpointNf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineEndpointNf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineEndpointNf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineEndpointNf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapStorageVirtualMachineEndpointSmb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineEndpointSmb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineEndpointSmb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineEndpointSmb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapVolumeTieringPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolingPeriod":
            suggest = "cooling_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapVolumeTieringPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapVolumeTieringPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapVolumeTieringPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooling_period: Optional[int] = None,
                 name: Optional[str] = None):
        """
        :param str name: Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        if cooling_period is not None:
            pulumi.set(__self__, "cooling_period", cooling_period)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="coolingPeriod")
    def cooling_period(self) -> Optional[int]:
        return pulumi.get(self, "cooling_period")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OpenZfsFileSystemDiskIopsConfiguration(dict):
    def __init__(__self__, *,
                 iops: Optional[int] = None,
                 mode: Optional[str] = None):
        """
        :param int iops: - The total number of SSD IOPS provisioned for the file system.
        :param str mode: - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        - The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class OpenZfsFileSystemRootVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyTagsToSnapshots":
            suggest = "copy_tags_to_snapshots"
        elif key == "dataCompressionType":
            suggest = "data_compression_type"
        elif key == "nfsExports":
            suggest = "nfs_exports"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "userAndGroupQuotas":
            suggest = "user_and_group_quotas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsFileSystemRootVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsFileSystemRootVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsFileSystemRootVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_tags_to_snapshots: Optional[bool] = None,
                 data_compression_type: Optional[str] = None,
                 nfs_exports: Optional['outputs.OpenZfsFileSystemRootVolumeConfigurationNfsExports'] = None,
                 read_only: Optional[bool] = None,
                 user_and_group_quotas: Optional[Sequence['outputs.OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota']] = None):
        """
        :param bool copy_tags_to_snapshots: - A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param str data_compression_type: - Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param 'OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs' nfs_exports: - NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        :param bool read_only: - specifies whether the volume is read-only. Default is false.
        :param Sequence['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs'] user_and_group_quotas: - Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[bool]:
        """
        - A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[str]:
        """
        - Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional['outputs.OpenZfsFileSystemRootVolumeConfigurationNfsExports']:
        """
        - NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        """
        return pulumi.get(self, "nfs_exports")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        - specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[Sequence['outputs.OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota']]:
        """
        - Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        return pulumi.get(self, "user_and_group_quotas")


@pulumi.output_type
class OpenZfsFileSystemRootVolumeConfigurationNfsExports(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConfigurations":
            suggest = "client_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsFileSystemRootVolumeConfigurationNfsExports. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsFileSystemRootVolumeConfigurationNfsExports.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsFileSystemRootVolumeConfigurationNfsExports.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_configurations: Sequence['outputs.OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfiguration']):
        """
        :param Sequence['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs'] client_configurations: - A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> Sequence['outputs.OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfiguration']:
        """
        - A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        return pulumi.get(self, "client_configurations")


@pulumi.output_type
class OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfiguration(dict):
    def __init__(__self__, *,
                 clients: str,
                 options: Sequence[str]):
        """
        :param str clients: - A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        :param Sequence[str] options: -  The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> str:
        """
        - A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        """
        return pulumi.get(self, "clients")

    @property
    @pulumi.getter
    def options(self) -> Sequence[str]:
        """
        -  The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageCapacityQuotaGib":
            suggest = "storage_capacity_quota_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: int,
                 storage_capacity_quota_gib: int,
                 type: str):
        """
        :param int id: - The ID of the user or group. Valid values between `0` and `2147483647`
        :param int storage_capacity_quota_gib: - The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        - The ID of the user or group. Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> int:
        """
        - The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class OpenZfsVolumeNfsExports(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConfigurations":
            suggest = "client_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsVolumeNfsExports. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsVolumeNfsExports.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsVolumeNfsExports.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_configurations: Sequence['outputs.OpenZfsVolumeNfsExportsClientConfiguration']):
        """
        :param Sequence['OpenZfsVolumeNfsExportsClientConfigurationArgs'] client_configurations: - A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> Sequence['outputs.OpenZfsVolumeNfsExportsClientConfiguration']:
        """
        - A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        return pulumi.get(self, "client_configurations")


@pulumi.output_type
class OpenZfsVolumeNfsExportsClientConfiguration(dict):
    def __init__(__self__, *,
                 clients: str,
                 options: Sequence[str]):
        """
        :param str clients: - A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        :param Sequence[str] options: -  The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> str:
        """
        - A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        """
        return pulumi.get(self, "clients")

    @property
    @pulumi.getter
    def options(self) -> Sequence[str]:
        """
        -  The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class OpenZfsVolumeOriginSnapshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyStrategy":
            suggest = "copy_strategy"
        elif key == "snapshotArn":
            suggest = "snapshot_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsVolumeOriginSnapshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsVolumeOriginSnapshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsVolumeOriginSnapshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_strategy: str,
                 snapshot_arn: str):
        pulumi.set(__self__, "copy_strategy", copy_strategy)
        pulumi.set(__self__, "snapshot_arn", snapshot_arn)

    @property
    @pulumi.getter(name="copyStrategy")
    def copy_strategy(self) -> str:
        return pulumi.get(self, "copy_strategy")

    @property
    @pulumi.getter(name="snapshotArn")
    def snapshot_arn(self) -> str:
        return pulumi.get(self, "snapshot_arn")


@pulumi.output_type
class OpenZfsVolumeUserAndGroupQuota(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageCapacityQuotaGib":
            suggest = "storage_capacity_quota_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsVolumeUserAndGroupQuota. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsVolumeUserAndGroupQuota.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsVolumeUserAndGroupQuota.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: int,
                 storage_capacity_quota_gib: int,
                 type: str):
        """
        :param int id: - The ID of the user or group. Valid values between `0` and `2147483647`
        :param int storage_capacity_quota_gib: - The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        - The ID of the user or group. Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> int:
        """
        - The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class WindowsFileSystemAuditLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogDestination":
            suggest = "audit_log_destination"
        elif key == "fileAccessAuditLogLevel":
            suggest = "file_access_audit_log_level"
        elif key == "fileShareAccessAuditLogLevel":
            suggest = "file_share_access_audit_log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsFileSystemAuditLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsFileSystemAuditLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsFileSystemAuditLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_destination: Optional[str] = None,
                 file_access_audit_log_level: Optional[str] = None,
                 file_share_access_audit_log_level: Optional[str] = None):
        """
        :param str audit_log_destination: The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        :param str file_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        :param str file_share_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        if audit_log_destination is not None:
            pulumi.set(__self__, "audit_log_destination", audit_log_destination)
        if file_access_audit_log_level is not None:
            pulumi.set(__self__, "file_access_audit_log_level", file_access_audit_log_level)
        if file_share_access_audit_log_level is not None:
            pulumi.set(__self__, "file_share_access_audit_log_level", file_share_access_audit_log_level)

    @property
    @pulumi.getter(name="auditLogDestination")
    def audit_log_destination(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        """
        return pulumi.get(self, "audit_log_destination")

    @property
    @pulumi.getter(name="fileAccessAuditLogLevel")
    def file_access_audit_log_level(self) -> Optional[str]:
        """
        Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_access_audit_log_level")

    @property
    @pulumi.getter(name="fileShareAccessAuditLogLevel")
    def file_share_access_audit_log_level(self) -> Optional[str]:
        """
        Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_share_access_audit_log_level")


@pulumi.output_type
class WindowsFileSystemSelfManagedActiveDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsIps":
            suggest = "dns_ips"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "fileSystemAdministratorsGroup":
            suggest = "file_system_administrators_group"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsFileSystemSelfManagedActiveDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsFileSystemSelfManagedActiveDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsFileSystemSelfManagedActiveDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_ips: Sequence[str],
                 domain_name: str,
                 password: str,
                 username: str,
                 file_system_administrators_group: Optional[str] = None,
                 organizational_unit_distinguished_name: Optional[str] = None):
        """
        :param Sequence[str] dns_ips: A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        :param str domain_name: The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        :param str password: The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param str username: The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param str file_system_administrators_group: The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        :param str organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Sequence[str]:
        """
        A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        """
        return pulumi.get(self, "dns_ips")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[str]:
        """
        The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[str]:
        """
        The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")


