# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 release_label: pulumi.Input[str],
                 service_role: pulumi.Input[str],
                 additional_info: Optional[pulumi.Input[str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_termination_policy: Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']] = None,
                 autoscaling_role: Optional[pulumi.Input[str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]] = None,
                 configurations: Optional[pulumi.Input[str]] = None,
                 configurations_json: Optional[pulumi.Input[str]] = None,
                 core_instance_fleet: Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']] = None,
                 core_instance_group: Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']] = None,
                 custom_ami_id: Optional[pulumi.Input[str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
                 ec2_attributes: Optional[pulumi.Input['ClusterEc2AttributesArgs']] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
                 kerberos_attributes: Optional[pulumi.Input['ClusterKerberosAttributesArgs']] = None,
                 log_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_uri: Optional[pulumi.Input[str]] = None,
                 master_instance_fleet: Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']] = None,
                 master_instance_group: Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[str]] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] release_label: Release label for the Amazon EMR release.
        :param pulumi.Input[str] service_role: IAM role that will be assumed by the Amazon EMR service to access AWS resources.
        :param pulumi.Input[str] additional_info: JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore this provider cannot detect drift from the actual EMR cluster if its value is changed outside this provider.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applications: List of applications for the cluster. Valid values are: `Flink`, `Hadoop`, `Hive`, `Mahout`, `Pig`, `Spark`, and `JupyterHub` (as of EMR 5.14.0). Case insensitive.
        :param pulumi.Input['ClusterAutoTerminationPolicyArgs'] auto_termination_policy: An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        :param pulumi.Input[str] autoscaling_role: IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]] bootstrap_actions: Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        :param pulumi.Input[str] configurations: Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param pulumi.Input[str] configurations_json: JSON string for supplying list of configurations for the EMR cluster.
        :param pulumi.Input['ClusterCoreInstanceFleetArgs'] core_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input['ClusterCoreInstanceGroupArgs'] core_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        :param pulumi.Input[str] custom_ami_id: Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        :param pulumi.Input[int] ebs_root_volume_size: Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        :param pulumi.Input['ClusterEc2AttributesArgs'] ec2_attributes: Attributes for the EC2 instances running the job flow. See below.
        :param pulumi.Input[bool] keep_job_flow_alive_when_no_steps: Switch on/off run cluster with no steps or when all steps are complete (default is on)
        :param pulumi.Input['ClusterKerberosAttributesArgs'] kerberos_attributes: Kerberos configuration for the cluster. See below.
        :param pulumi.Input[str] log_encryption_kms_key_id: AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        :param pulumi.Input[str] log_uri: S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        :param pulumi.Input['ClusterMasterInstanceFleetArgs'] master_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input['ClusterMasterInstanceGroupArgs'] master_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        :param pulumi.Input[str] name: Name of the step.
        :param pulumi.Input[str] scale_down_behavior: Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        :param pulumi.Input[str] security_configuration: Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        :param pulumi.Input[int] step_concurrency_level: Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        :param pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]] steps: List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[bool] termination_protection: Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        :param pulumi.Input[bool] visible_to_all_users: Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
        """
        pulumi.set(__self__, "release_label", release_label)
        pulumi.set(__self__, "service_role", service_role)
        if additional_info is not None:
            pulumi.set(__self__, "additional_info", additional_info)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if auto_termination_policy is not None:
            pulumi.set(__self__, "auto_termination_policy", auto_termination_policy)
        if autoscaling_role is not None:
            pulumi.set(__self__, "autoscaling_role", autoscaling_role)
        if bootstrap_actions is not None:
            pulumi.set(__self__, "bootstrap_actions", bootstrap_actions)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if configurations_json is not None:
            pulumi.set(__self__, "configurations_json", configurations_json)
        if core_instance_fleet is not None:
            pulumi.set(__self__, "core_instance_fleet", core_instance_fleet)
        if core_instance_group is not None:
            pulumi.set(__self__, "core_instance_group", core_instance_group)
        if custom_ami_id is not None:
            pulumi.set(__self__, "custom_ami_id", custom_ami_id)
        if ebs_root_volume_size is not None:
            pulumi.set(__self__, "ebs_root_volume_size", ebs_root_volume_size)
        if ec2_attributes is not None:
            pulumi.set(__self__, "ec2_attributes", ec2_attributes)
        if keep_job_flow_alive_when_no_steps is not None:
            pulumi.set(__self__, "keep_job_flow_alive_when_no_steps", keep_job_flow_alive_when_no_steps)
        if kerberos_attributes is not None:
            pulumi.set(__self__, "kerberos_attributes", kerberos_attributes)
        if log_encryption_kms_key_id is not None:
            pulumi.set(__self__, "log_encryption_kms_key_id", log_encryption_kms_key_id)
        if log_uri is not None:
            pulumi.set(__self__, "log_uri", log_uri)
        if master_instance_fleet is not None:
            pulumi.set(__self__, "master_instance_fleet", master_instance_fleet)
        if master_instance_group is not None:
            pulumi.set(__self__, "master_instance_group", master_instance_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scale_down_behavior is not None:
            pulumi.set(__self__, "scale_down_behavior", scale_down_behavior)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if step_concurrency_level is not None:
            pulumi.set(__self__, "step_concurrency_level", step_concurrency_level)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)
        if visible_to_all_users is not None:
            pulumi.set(__self__, "visible_to_all_users", visible_to_all_users)

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Input[str]:
        """
        Release label for the Amazon EMR release.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "release_label", value)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Input[str]:
        """
        IAM role that will be assumed by the Amazon EMR service to access AWS resources.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_role", value)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Optional[pulumi.Input[str]]:
        """
        JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore this provider cannot detect drift from the actual EMR cluster if its value is changed outside this provider.
        """
        return pulumi.get(self, "additional_info")

    @additional_info.setter
    def additional_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_info", value)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of applications for the cluster. Valid values are: `Flink`, `Hadoop`, `Hive`, `Mahout`, `Pig`, `Spark`, and `JupyterHub` (as of EMR 5.14.0). Case insensitive.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter(name="autoTerminationPolicy")
    def auto_termination_policy(self) -> Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']]:
        """
        An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        """
        return pulumi.get(self, "auto_termination_policy")

    @auto_termination_policy.setter
    def auto_termination_policy(self, value: Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']]):
        pulumi.set(self, "auto_termination_policy", value)

    @property
    @pulumi.getter(name="autoscalingRole")
    def autoscaling_role(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        """
        return pulumi.get(self, "autoscaling_role")

    @autoscaling_role.setter
    def autoscaling_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autoscaling_role", value)

    @property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]:
        """
        Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        """
        return pulumi.get(self, "bootstrap_actions")

    @bootstrap_actions.setter
    def bootstrap_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]):
        pulumi.set(self, "bootstrap_actions", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="configurationsJson")
    def configurations_json(self) -> Optional[pulumi.Input[str]]:
        """
        JSON string for supplying list of configurations for the EMR cluster.
        """
        return pulumi.get(self, "configurations_json")

    @configurations_json.setter
    def configurations_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configurations_json", value)

    @property
    @pulumi.getter(name="coreInstanceFleet")
    def core_instance_fleet(self) -> Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']]:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "core_instance_fleet")

    @core_instance_fleet.setter
    def core_instance_fleet(self, value: Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']]):
        pulumi.set(self, "core_instance_fleet", value)

    @property
    @pulumi.getter(name="coreInstanceGroup")
    def core_instance_group(self) -> Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']]:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        """
        return pulumi.get(self, "core_instance_group")

    @core_instance_group.setter
    def core_instance_group(self, value: Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']]):
        pulumi.set(self, "core_instance_group", value)

    @property
    @pulumi.getter(name="customAmiId")
    def custom_ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        """
        return pulumi.get(self, "custom_ami_id")

    @custom_ami_id.setter
    def custom_ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_ami_id", value)

    @property
    @pulumi.getter(name="ebsRootVolumeSize")
    def ebs_root_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        """
        return pulumi.get(self, "ebs_root_volume_size")

    @ebs_root_volume_size.setter
    def ebs_root_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ebs_root_volume_size", value)

    @property
    @pulumi.getter(name="ec2Attributes")
    def ec2_attributes(self) -> Optional[pulumi.Input['ClusterEc2AttributesArgs']]:
        """
        Attributes for the EC2 instances running the job flow. See below.
        """
        return pulumi.get(self, "ec2_attributes")

    @ec2_attributes.setter
    def ec2_attributes(self, value: Optional[pulumi.Input['ClusterEc2AttributesArgs']]):
        pulumi.set(self, "ec2_attributes", value)

    @property
    @pulumi.getter(name="keepJobFlowAliveWhenNoSteps")
    def keep_job_flow_alive_when_no_steps(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch on/off run cluster with no steps or when all steps are complete (default is on)
        """
        return pulumi.get(self, "keep_job_flow_alive_when_no_steps")

    @keep_job_flow_alive_when_no_steps.setter
    def keep_job_flow_alive_when_no_steps(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_job_flow_alive_when_no_steps", value)

    @property
    @pulumi.getter(name="kerberosAttributes")
    def kerberos_attributes(self) -> Optional[pulumi.Input['ClusterKerberosAttributesArgs']]:
        """
        Kerberos configuration for the cluster. See below.
        """
        return pulumi.get(self, "kerberos_attributes")

    @kerberos_attributes.setter
    def kerberos_attributes(self, value: Optional[pulumi.Input['ClusterKerberosAttributesArgs']]):
        pulumi.set(self, "kerberos_attributes", value)

    @property
    @pulumi.getter(name="logEncryptionKmsKeyId")
    def log_encryption_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        """
        return pulumi.get(self, "log_encryption_kms_key_id")

    @log_encryption_kms_key_id.setter
    def log_encryption_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_encryption_kms_key_id", value)

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> Optional[pulumi.Input[str]]:
        """
        S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        """
        return pulumi.get(self, "log_uri")

    @log_uri.setter
    def log_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_uri", value)

    @property
    @pulumi.getter(name="masterInstanceFleet")
    def master_instance_fleet(self) -> Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']]:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "master_instance_fleet")

    @master_instance_fleet.setter
    def master_instance_fleet(self, value: Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']]):
        pulumi.set(self, "master_instance_fleet", value)

    @property
    @pulumi.getter(name="masterInstanceGroup")
    def master_instance_group(self) -> Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']]:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        """
        return pulumi.get(self, "master_instance_group")

    @master_instance_group.setter
    def master_instance_group(self, value: Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']]):
        pulumi.set(self, "master_instance_group", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the step.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="scaleDownBehavior")
    def scale_down_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        """
        return pulumi.get(self, "scale_down_behavior")

    @scale_down_behavior.setter
    def scale_down_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_behavior", value)

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_configuration", value)

    @property
    @pulumi.getter(name="stepConcurrencyLevel")
    def step_concurrency_level(self) -> Optional[pulumi.Input[int]]:
        """
        Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        """
        return pulumi.get(self, "step_concurrency_level")

    @step_concurrency_level.setter
    def step_concurrency_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "step_concurrency_level", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]]:
        """
        List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)

    @property
    @pulumi.getter(name="visibleToAllUsers")
    def visible_to_all_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
        """
        return pulumi.get(self, "visible_to_all_users")

    @visible_to_all_users.setter
    def visible_to_all_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "visible_to_all_users", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 additional_info: Optional[pulumi.Input[str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_termination_policy: Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']] = None,
                 autoscaling_role: Optional[pulumi.Input[str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]] = None,
                 cluster_state: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[str]] = None,
                 configurations_json: Optional[pulumi.Input[str]] = None,
                 core_instance_fleet: Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']] = None,
                 core_instance_group: Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']] = None,
                 custom_ami_id: Optional[pulumi.Input[str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
                 ec2_attributes: Optional[pulumi.Input['ClusterEc2AttributesArgs']] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
                 kerberos_attributes: Optional[pulumi.Input['ClusterKerberosAttributesArgs']] = None,
                 log_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_uri: Optional[pulumi.Input[str]] = None,
                 master_instance_fleet: Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']] = None,
                 master_instance_group: Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']] = None,
                 master_public_dns: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_label: Optional[pulumi.Input[str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[str]] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[str] additional_info: JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore this provider cannot detect drift from the actual EMR cluster if its value is changed outside this provider.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applications: List of applications for the cluster. Valid values are: `Flink`, `Hadoop`, `Hive`, `Mahout`, `Pig`, `Spark`, and `JupyterHub` (as of EMR 5.14.0). Case insensitive.
        :param pulumi.Input['ClusterAutoTerminationPolicyArgs'] auto_termination_policy: An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        :param pulumi.Input[str] autoscaling_role: IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]] bootstrap_actions: Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        :param pulumi.Input[str] configurations: Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param pulumi.Input[str] configurations_json: JSON string for supplying list of configurations for the EMR cluster.
        :param pulumi.Input['ClusterCoreInstanceFleetArgs'] core_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input['ClusterCoreInstanceGroupArgs'] core_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        :param pulumi.Input[str] custom_ami_id: Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        :param pulumi.Input[int] ebs_root_volume_size: Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        :param pulumi.Input['ClusterEc2AttributesArgs'] ec2_attributes: Attributes for the EC2 instances running the job flow. See below.
        :param pulumi.Input[bool] keep_job_flow_alive_when_no_steps: Switch on/off run cluster with no steps or when all steps are complete (default is on)
        :param pulumi.Input['ClusterKerberosAttributesArgs'] kerberos_attributes: Kerberos configuration for the cluster. See below.
        :param pulumi.Input[str] log_encryption_kms_key_id: AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        :param pulumi.Input[str] log_uri: S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        :param pulumi.Input['ClusterMasterInstanceFleetArgs'] master_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input['ClusterMasterInstanceGroupArgs'] master_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        :param pulumi.Input[str] master_public_dns: The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.
        :param pulumi.Input[str] name: Name of the step.
        :param pulumi.Input[str] release_label: Release label for the Amazon EMR release.
        :param pulumi.Input[str] scale_down_behavior: Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        :param pulumi.Input[str] security_configuration: Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        :param pulumi.Input[str] service_role: IAM role that will be assumed by the Amazon EMR service to access AWS resources.
        :param pulumi.Input[int] step_concurrency_level: Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        :param pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]] steps: List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[bool] termination_protection: Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        :param pulumi.Input[bool] visible_to_all_users: Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
        """
        if additional_info is not None:
            pulumi.set(__self__, "additional_info", additional_info)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_termination_policy is not None:
            pulumi.set(__self__, "auto_termination_policy", auto_termination_policy)
        if autoscaling_role is not None:
            pulumi.set(__self__, "autoscaling_role", autoscaling_role)
        if bootstrap_actions is not None:
            pulumi.set(__self__, "bootstrap_actions", bootstrap_actions)
        if cluster_state is not None:
            pulumi.set(__self__, "cluster_state", cluster_state)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if configurations_json is not None:
            pulumi.set(__self__, "configurations_json", configurations_json)
        if core_instance_fleet is not None:
            pulumi.set(__self__, "core_instance_fleet", core_instance_fleet)
        if core_instance_group is not None:
            pulumi.set(__self__, "core_instance_group", core_instance_group)
        if custom_ami_id is not None:
            pulumi.set(__self__, "custom_ami_id", custom_ami_id)
        if ebs_root_volume_size is not None:
            pulumi.set(__self__, "ebs_root_volume_size", ebs_root_volume_size)
        if ec2_attributes is not None:
            pulumi.set(__self__, "ec2_attributes", ec2_attributes)
        if keep_job_flow_alive_when_no_steps is not None:
            pulumi.set(__self__, "keep_job_flow_alive_when_no_steps", keep_job_flow_alive_when_no_steps)
        if kerberos_attributes is not None:
            pulumi.set(__self__, "kerberos_attributes", kerberos_attributes)
        if log_encryption_kms_key_id is not None:
            pulumi.set(__self__, "log_encryption_kms_key_id", log_encryption_kms_key_id)
        if log_uri is not None:
            pulumi.set(__self__, "log_uri", log_uri)
        if master_instance_fleet is not None:
            pulumi.set(__self__, "master_instance_fleet", master_instance_fleet)
        if master_instance_group is not None:
            pulumi.set(__self__, "master_instance_group", master_instance_group)
        if master_public_dns is not None:
            pulumi.set(__self__, "master_public_dns", master_public_dns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if release_label is not None:
            pulumi.set(__self__, "release_label", release_label)
        if scale_down_behavior is not None:
            pulumi.set(__self__, "scale_down_behavior", scale_down_behavior)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if step_concurrency_level is not None:
            pulumi.set(__self__, "step_concurrency_level", step_concurrency_level)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)
        if visible_to_all_users is not None:
            pulumi.set(__self__, "visible_to_all_users", visible_to_all_users)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Optional[pulumi.Input[str]]:
        """
        JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore this provider cannot detect drift from the actual EMR cluster if its value is changed outside this provider.
        """
        return pulumi.get(self, "additional_info")

    @additional_info.setter
    def additional_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_info", value)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of applications for the cluster. Valid values are: `Flink`, `Hadoop`, `Hive`, `Mahout`, `Pig`, `Spark`, and `JupyterHub` (as of EMR 5.14.0). Case insensitive.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoTerminationPolicy")
    def auto_termination_policy(self) -> Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']]:
        """
        An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        """
        return pulumi.get(self, "auto_termination_policy")

    @auto_termination_policy.setter
    def auto_termination_policy(self, value: Optional[pulumi.Input['ClusterAutoTerminationPolicyArgs']]):
        pulumi.set(self, "auto_termination_policy", value)

    @property
    @pulumi.getter(name="autoscalingRole")
    def autoscaling_role(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        """
        return pulumi.get(self, "autoscaling_role")

    @autoscaling_role.setter
    def autoscaling_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autoscaling_role", value)

    @property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]:
        """
        Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        """
        return pulumi.get(self, "bootstrap_actions")

    @bootstrap_actions.setter
    def bootstrap_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]):
        pulumi.set(self, "bootstrap_actions", value)

    @property
    @pulumi.getter(name="clusterState")
    def cluster_state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_state")

    @cluster_state.setter
    def cluster_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_state", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="configurationsJson")
    def configurations_json(self) -> Optional[pulumi.Input[str]]:
        """
        JSON string for supplying list of configurations for the EMR cluster.
        """
        return pulumi.get(self, "configurations_json")

    @configurations_json.setter
    def configurations_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configurations_json", value)

    @property
    @pulumi.getter(name="coreInstanceFleet")
    def core_instance_fleet(self) -> Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']]:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "core_instance_fleet")

    @core_instance_fleet.setter
    def core_instance_fleet(self, value: Optional[pulumi.Input['ClusterCoreInstanceFleetArgs']]):
        pulumi.set(self, "core_instance_fleet", value)

    @property
    @pulumi.getter(name="coreInstanceGroup")
    def core_instance_group(self) -> Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']]:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        """
        return pulumi.get(self, "core_instance_group")

    @core_instance_group.setter
    def core_instance_group(self, value: Optional[pulumi.Input['ClusterCoreInstanceGroupArgs']]):
        pulumi.set(self, "core_instance_group", value)

    @property
    @pulumi.getter(name="customAmiId")
    def custom_ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        """
        return pulumi.get(self, "custom_ami_id")

    @custom_ami_id.setter
    def custom_ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_ami_id", value)

    @property
    @pulumi.getter(name="ebsRootVolumeSize")
    def ebs_root_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        """
        return pulumi.get(self, "ebs_root_volume_size")

    @ebs_root_volume_size.setter
    def ebs_root_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ebs_root_volume_size", value)

    @property
    @pulumi.getter(name="ec2Attributes")
    def ec2_attributes(self) -> Optional[pulumi.Input['ClusterEc2AttributesArgs']]:
        """
        Attributes for the EC2 instances running the job flow. See below.
        """
        return pulumi.get(self, "ec2_attributes")

    @ec2_attributes.setter
    def ec2_attributes(self, value: Optional[pulumi.Input['ClusterEc2AttributesArgs']]):
        pulumi.set(self, "ec2_attributes", value)

    @property
    @pulumi.getter(name="keepJobFlowAliveWhenNoSteps")
    def keep_job_flow_alive_when_no_steps(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch on/off run cluster with no steps or when all steps are complete (default is on)
        """
        return pulumi.get(self, "keep_job_flow_alive_when_no_steps")

    @keep_job_flow_alive_when_no_steps.setter
    def keep_job_flow_alive_when_no_steps(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_job_flow_alive_when_no_steps", value)

    @property
    @pulumi.getter(name="kerberosAttributes")
    def kerberos_attributes(self) -> Optional[pulumi.Input['ClusterKerberosAttributesArgs']]:
        """
        Kerberos configuration for the cluster. See below.
        """
        return pulumi.get(self, "kerberos_attributes")

    @kerberos_attributes.setter
    def kerberos_attributes(self, value: Optional[pulumi.Input['ClusterKerberosAttributesArgs']]):
        pulumi.set(self, "kerberos_attributes", value)

    @property
    @pulumi.getter(name="logEncryptionKmsKeyId")
    def log_encryption_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        """
        return pulumi.get(self, "log_encryption_kms_key_id")

    @log_encryption_kms_key_id.setter
    def log_encryption_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_encryption_kms_key_id", value)

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> Optional[pulumi.Input[str]]:
        """
        S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        """
        return pulumi.get(self, "log_uri")

    @log_uri.setter
    def log_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_uri", value)

    @property
    @pulumi.getter(name="masterInstanceFleet")
    def master_instance_fleet(self) -> Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']]:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "master_instance_fleet")

    @master_instance_fleet.setter
    def master_instance_fleet(self, value: Optional[pulumi.Input['ClusterMasterInstanceFleetArgs']]):
        pulumi.set(self, "master_instance_fleet", value)

    @property
    @pulumi.getter(name="masterInstanceGroup")
    def master_instance_group(self) -> Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']]:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        """
        return pulumi.get(self, "master_instance_group")

    @master_instance_group.setter
    def master_instance_group(self, value: Optional[pulumi.Input['ClusterMasterInstanceGroupArgs']]):
        pulumi.set(self, "master_instance_group", value)

    @property
    @pulumi.getter(name="masterPublicDns")
    def master_public_dns(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.
        """
        return pulumi.get(self, "master_public_dns")

    @master_public_dns.setter
    def master_public_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_public_dns", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the step.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> Optional[pulumi.Input[str]]:
        """
        Release label for the Amazon EMR release.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_label", value)

    @property
    @pulumi.getter(name="scaleDownBehavior")
    def scale_down_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        """
        return pulumi.get(self, "scale_down_behavior")

    @scale_down_behavior.setter
    def scale_down_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_behavior", value)

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_configuration", value)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role that will be assumed by the Amazon EMR service to access AWS resources.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_role", value)

    @property
    @pulumi.getter(name="stepConcurrencyLevel")
    def step_concurrency_level(self) -> Optional[pulumi.Input[int]]:
        """
        Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        """
        return pulumi.get(self, "step_concurrency_level")

    @step_concurrency_level.setter
    def step_concurrency_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "step_concurrency_level", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]]:
        """
        List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStepArgs']]]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)

    @property
    @pulumi.getter(name="visibleToAllUsers")
    def visible_to_all_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
        """
        return pulumi.get(self, "visible_to_all_users")

    @visible_to_all_users.setter
    def visible_to_all_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "visible_to_all_users", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_info: Optional[pulumi.Input[str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_termination_policy: Optional[pulumi.Input[pulumi.InputType['ClusterAutoTerminationPolicyArgs']]] = None,
                 autoscaling_role: Optional[pulumi.Input[str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapActionArgs']]]]] = None,
                 configurations: Optional[pulumi.Input[str]] = None,
                 configurations_json: Optional[pulumi.Input[str]] = None,
                 core_instance_fleet: Optional[pulumi.Input[pulumi.InputType['ClusterCoreInstanceFleetArgs']]] = None,
                 core_instance_group: Optional[pulumi.Input[pulumi.InputType['ClusterCoreInstanceGroupArgs']]] = None,
                 custom_ami_id: Optional[pulumi.Input[str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
                 ec2_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterEc2AttributesArgs']]] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
                 kerberos_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterKerberosAttributesArgs']]] = None,
                 log_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_uri: Optional[pulumi.Input[str]] = None,
                 master_instance_fleet: Optional[pulumi.Input[pulumi.InputType['ClusterMasterInstanceFleetArgs']]] = None,
                 master_instance_group: Optional[pulumi.Input[pulumi.InputType['ClusterMasterInstanceGroupArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_label: Optional[pulumi.Input[str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[str]] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterStepArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides an Elastic MapReduce Cluster, a web service that makes it easy to process large amounts of data efficiently. See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/elastic-mapreduce/) for more information.

        To configure [Instance Groups](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for [task nodes](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-task), see the `emr.InstanceGroup` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        cluster = aws.emr.Cluster("cluster",
            release_label="emr-4.6.0",
            applications=["Spark"],
            additional_info=\"\"\"{
          "instanceAwsClientConfiguration": {
            "proxyPort": 8099,
            "proxyHost": "myproxy.example.com"
          }
        }
        \"\"\",
            termination_protection=False,
            keep_job_flow_alive_when_no_steps=True,
            ec2_attributes=aws.emr.ClusterEc2AttributesArgs(
                subnet_id=aws_subnet["main"]["id"],
                emr_managed_master_security_group=aws_security_group["sg"]["id"],
                emr_managed_slave_security_group=aws_security_group["sg"]["id"],
                instance_profile=aws_iam_instance_profile["emr_profile"]["arn"],
            ),
            master_instance_group=aws.emr.ClusterMasterInstanceGroupArgs(
                instance_type="m4.large",
            ),
            core_instance_group=aws.emr.ClusterCoreInstanceGroupArgs(
                instance_type="c4.large",
                instance_count=1,
                ebs_configs=[aws.emr.ClusterCoreInstanceGroupEbsConfigArgs(
                    size=40,
                    type="gp2",
                    volumes_per_instance=1,
                )],
                bid_price="0.30",
                autoscaling_policy=\"\"\"{
        "Constraints": {
          "MinCapacity": 1,
          "MaxCapacity": 2
        },
        "Rules": [
          {
            "Name": "ScaleOutMemoryPercentage",
            "Description": "Scale out if YARNMemoryAvailablePercentage is less than 15",
            "Action": {
              "SimpleScalingPolicyConfiguration": {
                "AdjustmentType": "CHANGE_IN_CAPACITY",
                "ScalingAdjustment": 1,
                "CoolDown": 300
              }
            },
            "Trigger": {
              "CloudWatchAlarmDefinition": {
                "ComparisonOperator": "LESS_THAN",
                "EvaluationPeriods": 1,
                "MetricName": "YARNMemoryAvailablePercentage",
                "Namespace": "AWS/ElasticMapReduce",
                "Period": 300,
                "Statistic": "AVERAGE",
                "Threshold": 15.0,
                "Unit": "PERCENT"
              }
            }
          }
        ]
        }
        \"\"\",
            ),
            ebs_root_volume_size=100,
            tags={
                "role": "rolename",
                "env": "env",
            },
            bootstrap_actions=[aws.emr.ClusterBootstrapActionArgs(
                path="s3://elasticmapreduce/bootstrap-actions/run-if",
                name="runif",
                args=[
                    "instance.isMaster=true",
                    "echo running on master node",
                ],
            )],
            configurations_json=\"\"\"  [
            {
              "Classification": "hadoop-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            },
            {
              "Classification": "spark-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            }
          ]
        \"\"\",
            service_role=aws_iam_role["iam_emr_service_role"]["arn"])
        ```

        The `emr.Cluster` resource typically requires two IAM roles, one for the EMR Cluster to use as a service, and another to place on your Cluster Instances to interact with AWS from those instances. The suggested role policy template for the EMR service is `AmazonElasticMapReduceRole`, and `AmazonElasticMapReduceforEC2Role` for the EC2 profile. See the [Getting Started](https://docs.aws.amazon.com/ElasticMapReduce/latest/ManagementGuide/emr-gs-launch-sample-cluster.html) guide for more information on these IAM roles.
        ### Instance Fleet

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.Cluster("example",
            master_instance_fleet=aws.emr.ClusterMasterInstanceFleetArgs(
                instance_type_configs=[aws.emr.ClusterMasterInstanceFleetInstanceTypeConfigArgs(
                    instance_type="m4.xlarge",
                )],
                target_on_demand_capacity=1,
            ),
            core_instance_fleet=aws.emr.ClusterCoreInstanceFleetArgs(
                instance_type_configs=[
                    aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigArgs(
                        bid_price_as_percentage_of_on_demand_price=80,
                        ebs_configs=[aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs(
                            size=100,
                            type="gp2",
                            volumes_per_instance=1,
                        )],
                        instance_type="m3.xlarge",
                        weighted_capacity=1,
                    ),
                    aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigArgs(
                        bid_price_as_percentage_of_on_demand_price=100,
                        ebs_configs=[aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs(
                            size=100,
                            type="gp2",
                            volumes_per_instance=1,
                        )],
                        instance_type="m4.xlarge",
                        weighted_capacity=1,
                    ),
                    aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigArgs(
                        bid_price_as_percentage_of_on_demand_price=100,
                        ebs_configs=[aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs(
                            size=100,
                            type="gp2",
                            volumes_per_instance=1,
                        )],
                        instance_type="m4.2xlarge",
                        weighted_capacity=2,
                    ),
                ],
                launch_specifications=aws.emr.ClusterCoreInstanceFleetLaunchSpecificationsArgs(
                    spot_specifications=[aws.emr.ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs(
                        allocation_strategy="capacity-optimized",
                        block_duration_minutes=0,
                        timeout_action="SWITCH_TO_ON_DEMAND",
                        timeout_duration_minutes=10,
                    )],
                ),
                name="core fleet",
                target_on_demand_capacity=2,
                target_spot_capacity=2,
            ))
        task = aws.emr.InstanceFleet("task",
            cluster_id=example.id,
            instance_type_configs=[
                aws.emr.InstanceFleetInstanceTypeConfigArgs(
                    bid_price_as_percentage_of_on_demand_price=100,
                    ebs_configs=[aws.emr.InstanceFleetInstanceTypeConfigEbsConfigArgs(
                        size=100,
                        type="gp2",
                        volumes_per_instance=1,
                    )],
                    instance_type="m4.xlarge",
                    weighted_capacity=1,
                ),
                aws.emr.InstanceFleetInstanceTypeConfigArgs(
                    bid_price_as_percentage_of_on_demand_price=100,
                    ebs_configs=[aws.emr.InstanceFleetInstanceTypeConfigEbsConfigArgs(
                        size=100,
                        type="gp2",
                        volumes_per_instance=1,
                    )],
                    instance_type="m4.2xlarge",
                    weighted_capacity=2,
                ),
            ],
            launch_specifications=aws.emr.InstanceFleetLaunchSpecificationsArgs(
                spot_specifications=[aws.emr.InstanceFleetLaunchSpecificationsSpotSpecificationArgs(
                    allocation_strategy="capacity-optimized",
                    block_duration_minutes=0,
                    timeout_action="TERMINATE_CLUSTER",
                    timeout_duration_minutes=10,
                )],
            ),
            target_on_demand_capacity=1,
            target_spot_capacity=1)
        ```
        ### Enable Debug Logging

        [Debug logging in EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-debugging.html) is implemented as a step. It is highly recommended that you utilize the resource options configuration with `ignoreChanges` if other steps are being managed outside of this provider.

        ```python
        import pulumi
        import pulumi_aws as aws

        # ... other configuration ...
        example = aws.emr.Cluster("example", steps=[aws.emr.ClusterStepArgs(
            action_on_failure="TERMINATE_CLUSTER",
            name="Setup Hadoop Debugging",
            hadoop_jar_step=aws.emr.ClusterStepHadoopJarStepArgs(
                jar="command-runner.jar",
                args=["state-pusher-script"],
            ),
        )])
        ```
        ### Multiple Node Master Instance Group

        Available in EMR version 5.23.0 and later, an EMR Cluster can be launched with three master nodes for high availability. Additional information about this functionality and its requirements can be found in the [EMR Management Guide](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-ha.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        # This configuration is for illustrative purposes and highlights
        # only relevant configurations for working with this functionality.
        # Map public IP on launch must be enabled for public (Internet accessible) subnets
        # ... other configuration ...
        example_subnet = aws.ec2.Subnet("exampleSubnet", map_public_ip_on_launch=True)
        # ... other configuration ...
        example_cluster = aws.emr.Cluster("exampleCluster",
            release_label="emr-5.24.1",
            termination_protection=True,
            ec2_attributes=aws.emr.ClusterEc2AttributesArgs(
                subnet_id=example_subnet.id,
            ),
            master_instance_group=aws.emr.ClusterMasterInstanceGroupArgs(
                instance_count=3,
            ),
            core_instance_group=aws.emr.ClusterCoreInstanceGroupArgs())
        ```
        ### Bootable Cluster

        **NOTE:** This configuration demonstrates a minimal configuration needed to boot an example EMR Cluster. It is not meant to display best practices. As with all examples, use at your own risk.

        ```python
        import pulumi
        import pulumi_aws as aws

        main_vpc = aws.ec2.Vpc("mainVpc",
            cidr_block="168.31.0.0/16",
            enable_dns_hostnames=True,
            tags={
                "name": "emr_test",
            })
        main_subnet = aws.ec2.Subnet("mainSubnet",
            vpc_id=main_vpc.id,
            cidr_block="168.31.0.0/20",
            tags={
                "name": "emr_test",
            })
        # IAM role for EMR Service
        iam_emr_service_role = aws.iam.Role("iamEmrServiceRole", assume_role_policy=\"\"\"{
          "Version": "2008-10-17",
          "Statement": [
            {
              "Sid": "",
              "Effect": "Allow",
              "Principal": {
                "Service": "elasticmapreduce.amazonaws.com"
              },
              "Action": "sts:AssumeRole"
            }
          ]
        }
        \"\"\")
        # IAM Role for EC2 Instance Profile
        iam_emr_profile_role = aws.iam.Role("iamEmrProfileRole", assume_role_policy=\"\"\"{
          "Version": "2008-10-17",
          "Statement": [
            {
              "Sid": "",
              "Effect": "Allow",
              "Principal": {
                "Service": "ec2.amazonaws.com"
              },
              "Action": "sts:AssumeRole"
            }
          ]
        }
        \"\"\")
        emr_profile = aws.iam.InstanceProfile("emrProfile", role=iam_emr_profile_role.name)
        cluster = aws.emr.Cluster("cluster",
            release_label="emr-4.6.0",
            applications=["Spark"],
            ec2_attributes=aws.emr.ClusterEc2AttributesArgs(
                subnet_id=main_subnet.id,
                emr_managed_master_security_group=aws_security_group["allow_all"]["id"],
                emr_managed_slave_security_group=aws_security_group["allow_all"]["id"],
                instance_profile=emr_profile.arn,
            ),
            master_instance_group=aws.emr.ClusterMasterInstanceGroupArgs(
                instance_type="m5.xlarge",
            ),
            core_instance_group=aws.emr.ClusterCoreInstanceGroupArgs(
                instance_count=1,
                instance_type="m5.xlarge",
            ),
            tags={
                "role": "rolename",
                "dns_zone": "env_zone",
                "env": "env",
                "name": "name-env",
            },
            bootstrap_actions=[aws.emr.ClusterBootstrapActionArgs(
                path="s3://elasticmapreduce/bootstrap-actions/run-if",
                name="runif",
                args=[
                    "instance.isMaster=true",
                    "echo running on master node",
                ],
            )],
            configurations_json=\"\"\"  [
            {
              "Classification": "hadoop-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            },
            {
              "Classification": "spark-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            }
          ]
        \"\"\",
            service_role=iam_emr_service_role.arn)
        allow_access = aws.ec2.SecurityGroup("allowAccess",
            description="Allow inbound traffic",
            vpc_id=main_vpc.id,
            ingress=[aws.ec2.SecurityGroupIngressArgs(
                from_port=0,
                to_port=0,
                protocol="-1",
                cidr_blocks=main_vpc.cidr_block,
            )],
            egress=[aws.ec2.SecurityGroupEgressArgs(
                from_port=0,
                to_port=0,
                protocol="-1",
                cidr_blocks=["0.0.0.0/0"],
            )],
            tags={
                "name": "emr_test",
            },
            opts=pulumi.ResourceOptions(depends_on=[main_subnet]))
        gw = aws.ec2.InternetGateway("gw", vpc_id=main_vpc.id)
        route_table = aws.ec2.RouteTable("routeTable",
            vpc_id=main_vpc.id,
            routes=[aws.ec2.RouteTableRouteArgs(
                cidr_block="0.0.0.0/0",
                gateway_id=gw.id,
            )])
        main_route_table_association = aws.ec2.MainRouteTableAssociation("mainRouteTableAssociation",
            vpc_id=main_vpc.id,
            route_table_id=route_table.id)
        ###
        iam_emr_service_policy = aws.iam.RolePolicy("iamEmrServicePolicy",
            role=iam_emr_service_role.id,
            policy=\"\"\"{
            "Version": "2012-10-17",
            "Statement": [{
                "Effect": "Allow",
                "Resource": "*",
                "Action": [
                    "ec2:AuthorizeSecurityGroupEgress",
                    "ec2:AuthorizeSecurityGroupIngress",
                    "ec2:CancelSpotInstanceRequests",
                    "ec2:CreateNetworkInterface",
                    "ec2:CreateSecurityGroup",
                    "ec2:CreateTags",
                    "ec2:DeleteNetworkInterface",
                    "ec2:DeleteSecurityGroup",
                    "ec2:DeleteTags",
                    "ec2:DescribeAvailabilityZones",
                    "ec2:DescribeAccountAttributes",
                    "ec2:DescribeDhcpOptions",
                    "ec2:DescribeInstanceStatus",
                    "ec2:DescribeInstances",
                    "ec2:DescribeKeyPairs",
                    "ec2:DescribeNetworkAcls",
                    "ec2:DescribeNetworkInterfaces",
                    "ec2:DescribePrefixLists",
                    "ec2:DescribeRouteTables",
                    "ec2:DescribeSecurityGroups",
                    "ec2:DescribeSpotInstanceRequests",
                    "ec2:DescribeSpotPriceHistory",
                    "ec2:DescribeSubnets",
                    "ec2:DescribeVpcAttribute",
                    "ec2:DescribeVpcEndpoints",
                    "ec2:DescribeVpcEndpointServices",
                    "ec2:DescribeVpcs",
                    "ec2:DetachNetworkInterface",
                    "ec2:ModifyImageAttribute",
                    "ec2:ModifyInstanceAttribute",
                    "ec2:RequestSpotInstances",
                    "ec2:RevokeSecurityGroupEgress",
                    "ec2:RunInstances",
                    "ec2:TerminateInstances",
                    "ec2:DeleteVolume",
                    "ec2:DescribeVolumeStatus",
                    "ec2:DescribeVolumes",
                    "ec2:DetachVolume",
                    "iam:GetRole",
                    "iam:GetRolePolicy",
                    "iam:ListInstanceProfiles",
                    "iam:ListRolePolicies",
                    "iam:PassRole",
                    "s3:CreateBucket",
                    "s3:Get*",
                    "s3:List*",
                    "sdb:BatchPutAttributes",
                    "sdb:Select",
                    "sqs:CreateQueue",
                    "sqs:Delete*",
                    "sqs:GetQueue*",
                    "sqs:PurgeQueue",
                    "sqs:ReceiveMessage"
                ]
            }]
        }
        \"\"\")
        iam_emr_profile_policy = aws.iam.RolePolicy("iamEmrProfilePolicy",
            role=iam_emr_profile_role.id,
            policy=\"\"\"{
            "Version": "2012-10-17",
            "Statement": [{
                "Effect": "Allow",
                "Resource": "*",
                "Action": [
                    "cloudwatch:*",
                    "dynamodb:*",
                    "ec2:Describe*",
                    "elasticmapreduce:Describe*",
                    "elasticmapreduce:ListBootstrapActions",
                    "elasticmapreduce:ListClusters",
                    "elasticmapreduce:ListInstanceGroups",
                    "elasticmapreduce:ListInstances",
                    "elasticmapreduce:ListSteps",
                    "kinesis:CreateStream",
                    "kinesis:DeleteStream",
                    "kinesis:DescribeStream",
                    "kinesis:GetRecords",
                    "kinesis:GetShardIterator",
                    "kinesis:MergeShards",
                    "kinesis:PutRecord",
                    "kinesis:SplitShard",
                    "rds:Describe*",
                    "s3:*",
                    "sdb:*",
                    "sns:*",
                    "sqs:*"
                ]
            }]
        }
        \"\"\")
        ```

        ## Import

        EMR clusters can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:emr/cluster:Cluster cluster j-123456ABCDEF
        ```

         Since the API does not return the actual values for Kerberos configurations, environments with those configurations will need to use the resource options configuration block `ignoreChanges` argument available to all provider resources to prevent perpetual differences, e.g. terraform resource "aws_emr_cluster" "example" {

        # ... other configuration ...

         lifecycle {

         ignore_changes = [kerberos_attributes]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] additional_info: JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore this provider cannot detect drift from the actual EMR cluster if its value is changed outside this provider.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applications: List of applications for the cluster. Valid values are: `Flink`, `Hadoop`, `Hive`, `Mahout`, `Pig`, `Spark`, and `JupyterHub` (as of EMR 5.14.0). Case insensitive.
        :param pulumi.Input[pulumi.InputType['ClusterAutoTerminationPolicyArgs']] auto_termination_policy: An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        :param pulumi.Input[str] autoscaling_role: IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapActionArgs']]]] bootstrap_actions: Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        :param pulumi.Input[str] configurations: Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param pulumi.Input[str] configurations_json: JSON string for supplying list of configurations for the EMR cluster.
        :param pulumi.Input[pulumi.InputType['ClusterCoreInstanceFleetArgs']] core_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input[pulumi.InputType['ClusterCoreInstanceGroupArgs']] core_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        :param pulumi.Input[str] custom_ami_id: Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        :param pulumi.Input[int] ebs_root_volume_size: Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        :param pulumi.Input[pulumi.InputType['ClusterEc2AttributesArgs']] ec2_attributes: Attributes for the EC2 instances running the job flow. See below.
        :param pulumi.Input[bool] keep_job_flow_alive_when_no_steps: Switch on/off run cluster with no steps or when all steps are complete (default is on)
        :param pulumi.Input[pulumi.InputType['ClusterKerberosAttributesArgs']] kerberos_attributes: Kerberos configuration for the cluster. See below.
        :param pulumi.Input[str] log_encryption_kms_key_id: AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        :param pulumi.Input[str] log_uri: S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        :param pulumi.Input[pulumi.InputType['ClusterMasterInstanceFleetArgs']] master_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input[pulumi.InputType['ClusterMasterInstanceGroupArgs']] master_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        :param pulumi.Input[str] name: Name of the step.
        :param pulumi.Input[str] release_label: Release label for the Amazon EMR release.
        :param pulumi.Input[str] scale_down_behavior: Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        :param pulumi.Input[str] security_configuration: Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        :param pulumi.Input[str] service_role: IAM role that will be assumed by the Amazon EMR service to access AWS resources.
        :param pulumi.Input[int] step_concurrency_level: Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterStepArgs']]]] steps: List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[bool] termination_protection: Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        :param pulumi.Input[bool] visible_to_all_users: Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic MapReduce Cluster, a web service that makes it easy to process large amounts of data efficiently. See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/elastic-mapreduce/) for more information.

        To configure [Instance Groups](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for [task nodes](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-task), see the `emr.InstanceGroup` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        cluster = aws.emr.Cluster("cluster",
            release_label="emr-4.6.0",
            applications=["Spark"],
            additional_info=\"\"\"{
          "instanceAwsClientConfiguration": {
            "proxyPort": 8099,
            "proxyHost": "myproxy.example.com"
          }
        }
        \"\"\",
            termination_protection=False,
            keep_job_flow_alive_when_no_steps=True,
            ec2_attributes=aws.emr.ClusterEc2AttributesArgs(
                subnet_id=aws_subnet["main"]["id"],
                emr_managed_master_security_group=aws_security_group["sg"]["id"],
                emr_managed_slave_security_group=aws_security_group["sg"]["id"],
                instance_profile=aws_iam_instance_profile["emr_profile"]["arn"],
            ),
            master_instance_group=aws.emr.ClusterMasterInstanceGroupArgs(
                instance_type="m4.large",
            ),
            core_instance_group=aws.emr.ClusterCoreInstanceGroupArgs(
                instance_type="c4.large",
                instance_count=1,
                ebs_configs=[aws.emr.ClusterCoreInstanceGroupEbsConfigArgs(
                    size=40,
                    type="gp2",
                    volumes_per_instance=1,
                )],
                bid_price="0.30",
                autoscaling_policy=\"\"\"{
        "Constraints": {
          "MinCapacity": 1,
          "MaxCapacity": 2
        },
        "Rules": [
          {
            "Name": "ScaleOutMemoryPercentage",
            "Description": "Scale out if YARNMemoryAvailablePercentage is less than 15",
            "Action": {
              "SimpleScalingPolicyConfiguration": {
                "AdjustmentType": "CHANGE_IN_CAPACITY",
                "ScalingAdjustment": 1,
                "CoolDown": 300
              }
            },
            "Trigger": {
              "CloudWatchAlarmDefinition": {
                "ComparisonOperator": "LESS_THAN",
                "EvaluationPeriods": 1,
                "MetricName": "YARNMemoryAvailablePercentage",
                "Namespace": "AWS/ElasticMapReduce",
                "Period": 300,
                "Statistic": "AVERAGE",
                "Threshold": 15.0,
                "Unit": "PERCENT"
              }
            }
          }
        ]
        }
        \"\"\",
            ),
            ebs_root_volume_size=100,
            tags={
                "role": "rolename",
                "env": "env",
            },
            bootstrap_actions=[aws.emr.ClusterBootstrapActionArgs(
                path="s3://elasticmapreduce/bootstrap-actions/run-if",
                name="runif",
                args=[
                    "instance.isMaster=true",
                    "echo running on master node",
                ],
            )],
            configurations_json=\"\"\"  [
            {
              "Classification": "hadoop-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            },
            {
              "Classification": "spark-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            }
          ]
        \"\"\",
            service_role=aws_iam_role["iam_emr_service_role"]["arn"])
        ```

        The `emr.Cluster` resource typically requires two IAM roles, one for the EMR Cluster to use as a service, and another to place on your Cluster Instances to interact with AWS from those instances. The suggested role policy template for the EMR service is `AmazonElasticMapReduceRole`, and `AmazonElasticMapReduceforEC2Role` for the EC2 profile. See the [Getting Started](https://docs.aws.amazon.com/ElasticMapReduce/latest/ManagementGuide/emr-gs-launch-sample-cluster.html) guide for more information on these IAM roles.
        ### Instance Fleet

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.Cluster("example",
            master_instance_fleet=aws.emr.ClusterMasterInstanceFleetArgs(
                instance_type_configs=[aws.emr.ClusterMasterInstanceFleetInstanceTypeConfigArgs(
                    instance_type="m4.xlarge",
                )],
                target_on_demand_capacity=1,
            ),
            core_instance_fleet=aws.emr.ClusterCoreInstanceFleetArgs(
                instance_type_configs=[
                    aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigArgs(
                        bid_price_as_percentage_of_on_demand_price=80,
                        ebs_configs=[aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs(
                            size=100,
                            type="gp2",
                            volumes_per_instance=1,
                        )],
                        instance_type="m3.xlarge",
                        weighted_capacity=1,
                    ),
                    aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigArgs(
                        bid_price_as_percentage_of_on_demand_price=100,
                        ebs_configs=[aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs(
                            size=100,
                            type="gp2",
                            volumes_per_instance=1,
                        )],
                        instance_type="m4.xlarge",
                        weighted_capacity=1,
                    ),
                    aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigArgs(
                        bid_price_as_percentage_of_on_demand_price=100,
                        ebs_configs=[aws.emr.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs(
                            size=100,
                            type="gp2",
                            volumes_per_instance=1,
                        )],
                        instance_type="m4.2xlarge",
                        weighted_capacity=2,
                    ),
                ],
                launch_specifications=aws.emr.ClusterCoreInstanceFleetLaunchSpecificationsArgs(
                    spot_specifications=[aws.emr.ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs(
                        allocation_strategy="capacity-optimized",
                        block_duration_minutes=0,
                        timeout_action="SWITCH_TO_ON_DEMAND",
                        timeout_duration_minutes=10,
                    )],
                ),
                name="core fleet",
                target_on_demand_capacity=2,
                target_spot_capacity=2,
            ))
        task = aws.emr.InstanceFleet("task",
            cluster_id=example.id,
            instance_type_configs=[
                aws.emr.InstanceFleetInstanceTypeConfigArgs(
                    bid_price_as_percentage_of_on_demand_price=100,
                    ebs_configs=[aws.emr.InstanceFleetInstanceTypeConfigEbsConfigArgs(
                        size=100,
                        type="gp2",
                        volumes_per_instance=1,
                    )],
                    instance_type="m4.xlarge",
                    weighted_capacity=1,
                ),
                aws.emr.InstanceFleetInstanceTypeConfigArgs(
                    bid_price_as_percentage_of_on_demand_price=100,
                    ebs_configs=[aws.emr.InstanceFleetInstanceTypeConfigEbsConfigArgs(
                        size=100,
                        type="gp2",
                        volumes_per_instance=1,
                    )],
                    instance_type="m4.2xlarge",
                    weighted_capacity=2,
                ),
            ],
            launch_specifications=aws.emr.InstanceFleetLaunchSpecificationsArgs(
                spot_specifications=[aws.emr.InstanceFleetLaunchSpecificationsSpotSpecificationArgs(
                    allocation_strategy="capacity-optimized",
                    block_duration_minutes=0,
                    timeout_action="TERMINATE_CLUSTER",
                    timeout_duration_minutes=10,
                )],
            ),
            target_on_demand_capacity=1,
            target_spot_capacity=1)
        ```
        ### Enable Debug Logging

        [Debug logging in EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-debugging.html) is implemented as a step. It is highly recommended that you utilize the resource options configuration with `ignoreChanges` if other steps are being managed outside of this provider.

        ```python
        import pulumi
        import pulumi_aws as aws

        # ... other configuration ...
        example = aws.emr.Cluster("example", steps=[aws.emr.ClusterStepArgs(
            action_on_failure="TERMINATE_CLUSTER",
            name="Setup Hadoop Debugging",
            hadoop_jar_step=aws.emr.ClusterStepHadoopJarStepArgs(
                jar="command-runner.jar",
                args=["state-pusher-script"],
            ),
        )])
        ```
        ### Multiple Node Master Instance Group

        Available in EMR version 5.23.0 and later, an EMR Cluster can be launched with three master nodes for high availability. Additional information about this functionality and its requirements can be found in the [EMR Management Guide](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-ha.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        # This configuration is for illustrative purposes and highlights
        # only relevant configurations for working with this functionality.
        # Map public IP on launch must be enabled for public (Internet accessible) subnets
        # ... other configuration ...
        example_subnet = aws.ec2.Subnet("exampleSubnet", map_public_ip_on_launch=True)
        # ... other configuration ...
        example_cluster = aws.emr.Cluster("exampleCluster",
            release_label="emr-5.24.1",
            termination_protection=True,
            ec2_attributes=aws.emr.ClusterEc2AttributesArgs(
                subnet_id=example_subnet.id,
            ),
            master_instance_group=aws.emr.ClusterMasterInstanceGroupArgs(
                instance_count=3,
            ),
            core_instance_group=aws.emr.ClusterCoreInstanceGroupArgs())
        ```
        ### Bootable Cluster

        **NOTE:** This configuration demonstrates a minimal configuration needed to boot an example EMR Cluster. It is not meant to display best practices. As with all examples, use at your own risk.

        ```python
        import pulumi
        import pulumi_aws as aws

        main_vpc = aws.ec2.Vpc("mainVpc",
            cidr_block="168.31.0.0/16",
            enable_dns_hostnames=True,
            tags={
                "name": "emr_test",
            })
        main_subnet = aws.ec2.Subnet("mainSubnet",
            vpc_id=main_vpc.id,
            cidr_block="168.31.0.0/20",
            tags={
                "name": "emr_test",
            })
        # IAM role for EMR Service
        iam_emr_service_role = aws.iam.Role("iamEmrServiceRole", assume_role_policy=\"\"\"{
          "Version": "2008-10-17",
          "Statement": [
            {
              "Sid": "",
              "Effect": "Allow",
              "Principal": {
                "Service": "elasticmapreduce.amazonaws.com"
              },
              "Action": "sts:AssumeRole"
            }
          ]
        }
        \"\"\")
        # IAM Role for EC2 Instance Profile
        iam_emr_profile_role = aws.iam.Role("iamEmrProfileRole", assume_role_policy=\"\"\"{
          "Version": "2008-10-17",
          "Statement": [
            {
              "Sid": "",
              "Effect": "Allow",
              "Principal": {
                "Service": "ec2.amazonaws.com"
              },
              "Action": "sts:AssumeRole"
            }
          ]
        }
        \"\"\")
        emr_profile = aws.iam.InstanceProfile("emrProfile", role=iam_emr_profile_role.name)
        cluster = aws.emr.Cluster("cluster",
            release_label="emr-4.6.0",
            applications=["Spark"],
            ec2_attributes=aws.emr.ClusterEc2AttributesArgs(
                subnet_id=main_subnet.id,
                emr_managed_master_security_group=aws_security_group["allow_all"]["id"],
                emr_managed_slave_security_group=aws_security_group["allow_all"]["id"],
                instance_profile=emr_profile.arn,
            ),
            master_instance_group=aws.emr.ClusterMasterInstanceGroupArgs(
                instance_type="m5.xlarge",
            ),
            core_instance_group=aws.emr.ClusterCoreInstanceGroupArgs(
                instance_count=1,
                instance_type="m5.xlarge",
            ),
            tags={
                "role": "rolename",
                "dns_zone": "env_zone",
                "env": "env",
                "name": "name-env",
            },
            bootstrap_actions=[aws.emr.ClusterBootstrapActionArgs(
                path="s3://elasticmapreduce/bootstrap-actions/run-if",
                name="runif",
                args=[
                    "instance.isMaster=true",
                    "echo running on master node",
                ],
            )],
            configurations_json=\"\"\"  [
            {
              "Classification": "hadoop-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            },
            {
              "Classification": "spark-env",
              "Configurations": [
                {
                  "Classification": "export",
                  "Properties": {
                    "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
                  }
                }
              ],
              "Properties": {}
            }
          ]
        \"\"\",
            service_role=iam_emr_service_role.arn)
        allow_access = aws.ec2.SecurityGroup("allowAccess",
            description="Allow inbound traffic",
            vpc_id=main_vpc.id,
            ingress=[aws.ec2.SecurityGroupIngressArgs(
                from_port=0,
                to_port=0,
                protocol="-1",
                cidr_blocks=main_vpc.cidr_block,
            )],
            egress=[aws.ec2.SecurityGroupEgressArgs(
                from_port=0,
                to_port=0,
                protocol="-1",
                cidr_blocks=["0.0.0.0/0"],
            )],
            tags={
                "name": "emr_test",
            },
            opts=pulumi.ResourceOptions(depends_on=[main_subnet]))
        gw = aws.ec2.InternetGateway("gw", vpc_id=main_vpc.id)
        route_table = aws.ec2.RouteTable("routeTable",
            vpc_id=main_vpc.id,
            routes=[aws.ec2.RouteTableRouteArgs(
                cidr_block="0.0.0.0/0",
                gateway_id=gw.id,
            )])
        main_route_table_association = aws.ec2.MainRouteTableAssociation("mainRouteTableAssociation",
            vpc_id=main_vpc.id,
            route_table_id=route_table.id)
        ###
        iam_emr_service_policy = aws.iam.RolePolicy("iamEmrServicePolicy",
            role=iam_emr_service_role.id,
            policy=\"\"\"{
            "Version": "2012-10-17",
            "Statement": [{
                "Effect": "Allow",
                "Resource": "*",
                "Action": [
                    "ec2:AuthorizeSecurityGroupEgress",
                    "ec2:AuthorizeSecurityGroupIngress",
                    "ec2:CancelSpotInstanceRequests",
                    "ec2:CreateNetworkInterface",
                    "ec2:CreateSecurityGroup",
                    "ec2:CreateTags",
                    "ec2:DeleteNetworkInterface",
                    "ec2:DeleteSecurityGroup",
                    "ec2:DeleteTags",
                    "ec2:DescribeAvailabilityZones",
                    "ec2:DescribeAccountAttributes",
                    "ec2:DescribeDhcpOptions",
                    "ec2:DescribeInstanceStatus",
                    "ec2:DescribeInstances",
                    "ec2:DescribeKeyPairs",
                    "ec2:DescribeNetworkAcls",
                    "ec2:DescribeNetworkInterfaces",
                    "ec2:DescribePrefixLists",
                    "ec2:DescribeRouteTables",
                    "ec2:DescribeSecurityGroups",
                    "ec2:DescribeSpotInstanceRequests",
                    "ec2:DescribeSpotPriceHistory",
                    "ec2:DescribeSubnets",
                    "ec2:DescribeVpcAttribute",
                    "ec2:DescribeVpcEndpoints",
                    "ec2:DescribeVpcEndpointServices",
                    "ec2:DescribeVpcs",
                    "ec2:DetachNetworkInterface",
                    "ec2:ModifyImageAttribute",
                    "ec2:ModifyInstanceAttribute",
                    "ec2:RequestSpotInstances",
                    "ec2:RevokeSecurityGroupEgress",
                    "ec2:RunInstances",
                    "ec2:TerminateInstances",
                    "ec2:DeleteVolume",
                    "ec2:DescribeVolumeStatus",
                    "ec2:DescribeVolumes",
                    "ec2:DetachVolume",
                    "iam:GetRole",
                    "iam:GetRolePolicy",
                    "iam:ListInstanceProfiles",
                    "iam:ListRolePolicies",
                    "iam:PassRole",
                    "s3:CreateBucket",
                    "s3:Get*",
                    "s3:List*",
                    "sdb:BatchPutAttributes",
                    "sdb:Select",
                    "sqs:CreateQueue",
                    "sqs:Delete*",
                    "sqs:GetQueue*",
                    "sqs:PurgeQueue",
                    "sqs:ReceiveMessage"
                ]
            }]
        }
        \"\"\")
        iam_emr_profile_policy = aws.iam.RolePolicy("iamEmrProfilePolicy",
            role=iam_emr_profile_role.id,
            policy=\"\"\"{
            "Version": "2012-10-17",
            "Statement": [{
                "Effect": "Allow",
                "Resource": "*",
                "Action": [
                    "cloudwatch:*",
                    "dynamodb:*",
                    "ec2:Describe*",
                    "elasticmapreduce:Describe*",
                    "elasticmapreduce:ListBootstrapActions",
                    "elasticmapreduce:ListClusters",
                    "elasticmapreduce:ListInstanceGroups",
                    "elasticmapreduce:ListInstances",
                    "elasticmapreduce:ListSteps",
                    "kinesis:CreateStream",
                    "kinesis:DeleteStream",
                    "kinesis:DescribeStream",
                    "kinesis:GetRecords",
                    "kinesis:GetShardIterator",
                    "kinesis:MergeShards",
                    "kinesis:PutRecord",
                    "kinesis:SplitShard",
                    "rds:Describe*",
                    "s3:*",
                    "sdb:*",
                    "sns:*",
                    "sqs:*"
                ]
            }]
        }
        \"\"\")
        ```

        ## Import

        EMR clusters can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:emr/cluster:Cluster cluster j-123456ABCDEF
        ```

         Since the API does not return the actual values for Kerberos configurations, environments with those configurations will need to use the resource options configuration block `ignoreChanges` argument available to all provider resources to prevent perpetual differences, e.g. terraform resource "aws_emr_cluster" "example" {

        # ... other configuration ...

         lifecycle {

         ignore_changes = [kerberos_attributes]

         } }

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_info: Optional[pulumi.Input[str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_termination_policy: Optional[pulumi.Input[pulumi.InputType['ClusterAutoTerminationPolicyArgs']]] = None,
                 autoscaling_role: Optional[pulumi.Input[str]] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapActionArgs']]]]] = None,
                 configurations: Optional[pulumi.Input[str]] = None,
                 configurations_json: Optional[pulumi.Input[str]] = None,
                 core_instance_fleet: Optional[pulumi.Input[pulumi.InputType['ClusterCoreInstanceFleetArgs']]] = None,
                 core_instance_group: Optional[pulumi.Input[pulumi.InputType['ClusterCoreInstanceGroupArgs']]] = None,
                 custom_ami_id: Optional[pulumi.Input[str]] = None,
                 ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
                 ec2_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterEc2AttributesArgs']]] = None,
                 keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
                 kerberos_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterKerberosAttributesArgs']]] = None,
                 log_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_uri: Optional[pulumi.Input[str]] = None,
                 master_instance_fleet: Optional[pulumi.Input[pulumi.InputType['ClusterMasterInstanceFleetArgs']]] = None,
                 master_instance_group: Optional[pulumi.Input[pulumi.InputType['ClusterMasterInstanceGroupArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_label: Optional[pulumi.Input[str]] = None,
                 scale_down_behavior: Optional[pulumi.Input[str]] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 step_concurrency_level: Optional[pulumi.Input[int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterStepArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 visible_to_all_users: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["additional_info"] = additional_info
            __props__.__dict__["applications"] = applications
            __props__.__dict__["auto_termination_policy"] = auto_termination_policy
            __props__.__dict__["autoscaling_role"] = autoscaling_role
            __props__.__dict__["bootstrap_actions"] = bootstrap_actions
            __props__.__dict__["configurations"] = configurations
            __props__.__dict__["configurations_json"] = configurations_json
            __props__.__dict__["core_instance_fleet"] = core_instance_fleet
            __props__.__dict__["core_instance_group"] = core_instance_group
            __props__.__dict__["custom_ami_id"] = custom_ami_id
            __props__.__dict__["ebs_root_volume_size"] = ebs_root_volume_size
            __props__.__dict__["ec2_attributes"] = ec2_attributes
            __props__.__dict__["keep_job_flow_alive_when_no_steps"] = keep_job_flow_alive_when_no_steps
            __props__.__dict__["kerberos_attributes"] = kerberos_attributes
            __props__.__dict__["log_encryption_kms_key_id"] = log_encryption_kms_key_id
            __props__.__dict__["log_uri"] = log_uri
            __props__.__dict__["master_instance_fleet"] = master_instance_fleet
            __props__.__dict__["master_instance_group"] = master_instance_group
            __props__.__dict__["name"] = name
            if release_label is None and not opts.urn:
                raise TypeError("Missing required property 'release_label'")
            __props__.__dict__["release_label"] = release_label
            __props__.__dict__["scale_down_behavior"] = scale_down_behavior
            __props__.__dict__["security_configuration"] = security_configuration
            if service_role is None and not opts.urn:
                raise TypeError("Missing required property 'service_role'")
            __props__.__dict__["service_role"] = service_role
            __props__.__dict__["step_concurrency_level"] = step_concurrency_level
            __props__.__dict__["steps"] = steps
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_protection"] = termination_protection
            __props__.__dict__["visible_to_all_users"] = visible_to_all_users
            __props__.__dict__["arn"] = None
            __props__.__dict__["cluster_state"] = None
            __props__.__dict__["master_public_dns"] = None
            __props__.__dict__["tags_all"] = None
        super(Cluster, __self__).__init__(
            'aws:emr/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_info: Optional[pulumi.Input[str]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_termination_policy: Optional[pulumi.Input[pulumi.InputType['ClusterAutoTerminationPolicyArgs']]] = None,
            autoscaling_role: Optional[pulumi.Input[str]] = None,
            bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapActionArgs']]]]] = None,
            cluster_state: Optional[pulumi.Input[str]] = None,
            configurations: Optional[pulumi.Input[str]] = None,
            configurations_json: Optional[pulumi.Input[str]] = None,
            core_instance_fleet: Optional[pulumi.Input[pulumi.InputType['ClusterCoreInstanceFleetArgs']]] = None,
            core_instance_group: Optional[pulumi.Input[pulumi.InputType['ClusterCoreInstanceGroupArgs']]] = None,
            custom_ami_id: Optional[pulumi.Input[str]] = None,
            ebs_root_volume_size: Optional[pulumi.Input[int]] = None,
            ec2_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterEc2AttributesArgs']]] = None,
            keep_job_flow_alive_when_no_steps: Optional[pulumi.Input[bool]] = None,
            kerberos_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterKerberosAttributesArgs']]] = None,
            log_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
            log_uri: Optional[pulumi.Input[str]] = None,
            master_instance_fleet: Optional[pulumi.Input[pulumi.InputType['ClusterMasterInstanceFleetArgs']]] = None,
            master_instance_group: Optional[pulumi.Input[pulumi.InputType['ClusterMasterInstanceGroupArgs']]] = None,
            master_public_dns: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            release_label: Optional[pulumi.Input[str]] = None,
            scale_down_behavior: Optional[pulumi.Input[str]] = None,
            security_configuration: Optional[pulumi.Input[str]] = None,
            service_role: Optional[pulumi.Input[str]] = None,
            step_concurrency_level: Optional[pulumi.Input[int]] = None,
            steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterStepArgs']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            termination_protection: Optional[pulumi.Input[bool]] = None,
            visible_to_all_users: Optional[pulumi.Input[bool]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] additional_info: JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore this provider cannot detect drift from the actual EMR cluster if its value is changed outside this provider.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applications: List of applications for the cluster. Valid values are: `Flink`, `Hadoop`, `Hive`, `Mahout`, `Pig`, `Spark`, and `JupyterHub` (as of EMR 5.14.0). Case insensitive.
        :param pulumi.Input[pulumi.InputType['ClusterAutoTerminationPolicyArgs']] auto_termination_policy: An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        :param pulumi.Input[str] autoscaling_role: IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapActionArgs']]]] bootstrap_actions: Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        :param pulumi.Input[str] configurations: Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param pulumi.Input[str] configurations_json: JSON string for supplying list of configurations for the EMR cluster.
        :param pulumi.Input[pulumi.InputType['ClusterCoreInstanceFleetArgs']] core_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input[pulumi.InputType['ClusterCoreInstanceGroupArgs']] core_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        :param pulumi.Input[str] custom_ami_id: Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        :param pulumi.Input[int] ebs_root_volume_size: Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        :param pulumi.Input[pulumi.InputType['ClusterEc2AttributesArgs']] ec2_attributes: Attributes for the EC2 instances running the job flow. See below.
        :param pulumi.Input[bool] keep_job_flow_alive_when_no_steps: Switch on/off run cluster with no steps or when all steps are complete (default is on)
        :param pulumi.Input[pulumi.InputType['ClusterKerberosAttributesArgs']] kerberos_attributes: Kerberos configuration for the cluster. See below.
        :param pulumi.Input[str] log_encryption_kms_key_id: AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        :param pulumi.Input[str] log_uri: S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        :param pulumi.Input[pulumi.InputType['ClusterMasterInstanceFleetArgs']] master_instance_fleet: Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        :param pulumi.Input[pulumi.InputType['ClusterMasterInstanceGroupArgs']] master_instance_group: Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        :param pulumi.Input[str] master_public_dns: The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.
        :param pulumi.Input[str] name: Name of the step.
        :param pulumi.Input[str] release_label: Release label for the Amazon EMR release.
        :param pulumi.Input[str] scale_down_behavior: Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        :param pulumi.Input[str] security_configuration: Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        :param pulumi.Input[str] service_role: IAM role that will be assumed by the Amazon EMR service to access AWS resources.
        :param pulumi.Input[int] step_concurrency_level: Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterStepArgs']]]] steps: List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[bool] termination_protection: Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        :param pulumi.Input[bool] visible_to_all_users: Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["additional_info"] = additional_info
        __props__.__dict__["applications"] = applications
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_termination_policy"] = auto_termination_policy
        __props__.__dict__["autoscaling_role"] = autoscaling_role
        __props__.__dict__["bootstrap_actions"] = bootstrap_actions
        __props__.__dict__["cluster_state"] = cluster_state
        __props__.__dict__["configurations"] = configurations
        __props__.__dict__["configurations_json"] = configurations_json
        __props__.__dict__["core_instance_fleet"] = core_instance_fleet
        __props__.__dict__["core_instance_group"] = core_instance_group
        __props__.__dict__["custom_ami_id"] = custom_ami_id
        __props__.__dict__["ebs_root_volume_size"] = ebs_root_volume_size
        __props__.__dict__["ec2_attributes"] = ec2_attributes
        __props__.__dict__["keep_job_flow_alive_when_no_steps"] = keep_job_flow_alive_when_no_steps
        __props__.__dict__["kerberos_attributes"] = kerberos_attributes
        __props__.__dict__["log_encryption_kms_key_id"] = log_encryption_kms_key_id
        __props__.__dict__["log_uri"] = log_uri
        __props__.__dict__["master_instance_fleet"] = master_instance_fleet
        __props__.__dict__["master_instance_group"] = master_instance_group
        __props__.__dict__["master_public_dns"] = master_public_dns
        __props__.__dict__["name"] = name
        __props__.__dict__["release_label"] = release_label
        __props__.__dict__["scale_down_behavior"] = scale_down_behavior
        __props__.__dict__["security_configuration"] = security_configuration
        __props__.__dict__["service_role"] = service_role
        __props__.__dict__["step_concurrency_level"] = step_concurrency_level
        __props__.__dict__["steps"] = steps
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["termination_protection"] = termination_protection
        __props__.__dict__["visible_to_all_users"] = visible_to_all_users
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> pulumi.Output[Optional[str]]:
        """
        JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore this provider cannot detect drift from the actual EMR cluster if its value is changed outside this provider.
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of applications for the cluster. Valid values are: `Flink`, `Hadoop`, `Hive`, `Mahout`, `Pig`, `Spark`, and `JupyterHub` (as of EMR 5.14.0). Case insensitive.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoTerminationPolicy")
    def auto_termination_policy(self) -> pulumi.Output[Optional['outputs.ClusterAutoTerminationPolicy']]:
        """
        An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
        """
        return pulumi.get(self, "auto_termination_policy")

    @property
    @pulumi.getter(name="autoscalingRole")
    def autoscaling_role(self) -> pulumi.Output[Optional[str]]:
        """
        IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
        """
        return pulumi.get(self, "autoscaling_role")

    @property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterBootstrapAction']]]:
        """
        Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
        """
        return pulumi.get(self, "bootstrap_actions")

    @property
    @pulumi.getter(name="clusterState")
    def cluster_state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cluster_state")

    @property
    @pulumi.getter
    def configurations(self) -> pulumi.Output[Optional[str]]:
        """
        Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="configurationsJson")
    def configurations_json(self) -> pulumi.Output[Optional[str]]:
        """
        JSON string for supplying list of configurations for the EMR cluster.
        """
        return pulumi.get(self, "configurations_json")

    @property
    @pulumi.getter(name="coreInstanceFleet")
    def core_instance_fleet(self) -> pulumi.Output['outputs.ClusterCoreInstanceFleet']:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "core_instance_fleet")

    @property
    @pulumi.getter(name="coreInstanceGroup")
    def core_instance_group(self) -> pulumi.Output['outputs.ClusterCoreInstanceGroup']:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
        """
        return pulumi.get(self, "core_instance_group")

    @property
    @pulumi.getter(name="customAmiId")
    def custom_ami_id(self) -> pulumi.Output[Optional[str]]:
        """
        Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
        """
        return pulumi.get(self, "custom_ami_id")

    @property
    @pulumi.getter(name="ebsRootVolumeSize")
    def ebs_root_volume_size(self) -> pulumi.Output[Optional[int]]:
        """
        Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
        """
        return pulumi.get(self, "ebs_root_volume_size")

    @property
    @pulumi.getter(name="ec2Attributes")
    def ec2_attributes(self) -> pulumi.Output[Optional['outputs.ClusterEc2Attributes']]:
        """
        Attributes for the EC2 instances running the job flow. See below.
        """
        return pulumi.get(self, "ec2_attributes")

    @property
    @pulumi.getter(name="keepJobFlowAliveWhenNoSteps")
    def keep_job_flow_alive_when_no_steps(self) -> pulumi.Output[bool]:
        """
        Switch on/off run cluster with no steps or when all steps are complete (default is on)
        """
        return pulumi.get(self, "keep_job_flow_alive_when_no_steps")

    @property
    @pulumi.getter(name="kerberosAttributes")
    def kerberos_attributes(self) -> pulumi.Output[Optional['outputs.ClusterKerberosAttributes']]:
        """
        Kerberos configuration for the cluster. See below.
        """
        return pulumi.get(self, "kerberos_attributes")

    @property
    @pulumi.getter(name="logEncryptionKmsKeyId")
    def log_encryption_kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
        """
        return pulumi.get(self, "log_encryption_kms_key_id")

    @property
    @pulumi.getter(name="logUri")
    def log_uri(self) -> pulumi.Output[Optional[str]]:
        """
        S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
        """
        return pulumi.get(self, "log_uri")

    @property
    @pulumi.getter(name="masterInstanceFleet")
    def master_instance_fleet(self) -> pulumi.Output['outputs.ClusterMasterInstanceFleet']:
        """
        Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
        """
        return pulumi.get(self, "master_instance_fleet")

    @property
    @pulumi.getter(name="masterInstanceGroup")
    def master_instance_group(self) -> pulumi.Output['outputs.ClusterMasterInstanceGroup']:
        """
        Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
        """
        return pulumi.get(self, "master_instance_group")

    @property
    @pulumi.getter(name="masterPublicDns")
    def master_public_dns(self) -> pulumi.Output[str]:
        """
        The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.
        """
        return pulumi.get(self, "master_public_dns")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the step.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Output[str]:
        """
        Release label for the Amazon EMR release.
        """
        return pulumi.get(self, "release_label")

    @property
    @pulumi.getter(name="scaleDownBehavior")
    def scale_down_behavior(self) -> pulumi.Output[str]:
        """
        Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
        """
        return pulumi.get(self, "scale_down_behavior")

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> pulumi.Output[Optional[str]]:
        """
        Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
        """
        return pulumi.get(self, "security_configuration")

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Output[str]:
        """
        IAM role that will be assumed by the Amazon EMR service to access AWS resources.
        """
        return pulumi.get(self, "service_role")

    @property
    @pulumi.getter(name="stepConcurrencyLevel")
    def step_concurrency_level(self) -> pulumi.Output[Optional[int]]:
        """
        Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
        """
        return pulumi.get(self, "step_concurrency_level")

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Sequence['outputs.ClusterStep']]:
        """
        List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[bool]:
        """
        Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
        """
        return pulumi.get(self, "termination_protection")

    @property
    @pulumi.getter(name="visibleToAllUsers")
    def visible_to_all_users(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
        """
        return pulumi.get(self, "visible_to_all_users")

