# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNodeGroupResult',
    'AwaitableGetNodeGroupResult',
    'get_node_group',
    'get_node_group_output',
]

@pulumi.output_type
class GetNodeGroupResult:
    """
    A collection of values returned by getNodeGroup.
    """
    def __init__(__self__, ami_type=None, arn=None, cluster_name=None, disk_size=None, id=None, instance_types=None, labels=None, node_group_name=None, node_role_arn=None, release_version=None, remote_accesses=None, resources=None, scaling_configs=None, status=None, subnet_ids=None, tags=None, taints=None, version=None):
        if ami_type and not isinstance(ami_type, str):
            raise TypeError("Expected argument 'ami_type' to be a str")
        pulumi.set(__self__, "ami_type", ami_type)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if disk_size and not isinstance(disk_size, int):
            raise TypeError("Expected argument 'disk_size' to be a int")
        pulumi.set(__self__, "disk_size", disk_size)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_types and not isinstance(instance_types, list):
            raise TypeError("Expected argument 'instance_types' to be a list")
        pulumi.set(__self__, "instance_types", instance_types)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if node_group_name and not isinstance(node_group_name, str):
            raise TypeError("Expected argument 'node_group_name' to be a str")
        pulumi.set(__self__, "node_group_name", node_group_name)
        if node_role_arn and not isinstance(node_role_arn, str):
            raise TypeError("Expected argument 'node_role_arn' to be a str")
        pulumi.set(__self__, "node_role_arn", node_role_arn)
        if release_version and not isinstance(release_version, str):
            raise TypeError("Expected argument 'release_version' to be a str")
        pulumi.set(__self__, "release_version", release_version)
        if remote_accesses and not isinstance(remote_accesses, list):
            raise TypeError("Expected argument 'remote_accesses' to be a list")
        pulumi.set(__self__, "remote_accesses", remote_accesses)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if scaling_configs and not isinstance(scaling_configs, list):
            raise TypeError("Expected argument 'scaling_configs' to be a list")
        pulumi.set(__self__, "scaling_configs", scaling_configs)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if taints and not isinstance(taints, list):
            raise TypeError("Expected argument 'taints' to be a list")
        pulumi.set(__self__, "taints", taints)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> str:
        """
        Type of Amazon Machine Image (AMI) associated with the EKS Node Group.
        """
        return pulumi.get(self, "ami_type")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the EKS Node Group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> int:
        """
        Disk size in GiB for worker nodes.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Sequence[str]:
        """
        Set of instance types associated with the EKS Node Group.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> str:
        return pulumi.get(self, "node_group_name")

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
        """
        return pulumi.get(self, "node_role_arn")

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> str:
        """
        AMI version of the EKS Node Group.
        """
        return pulumi.get(self, "release_version")

    @property
    @pulumi.getter(name="remoteAccesses")
    def remote_accesses(self) -> Sequence['outputs.GetNodeGroupRemoteAccessResult']:
        """
        Configuration block with remote access settings.
        """
        return pulumi.get(self, "remote_accesses")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetNodeGroupResourceResult']:
        """
        List of objects containing information about underlying resources.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="scalingConfigs")
    def scaling_configs(self) -> Sequence['outputs.GetNodeGroupScalingConfigResult']:
        """
        Configuration block with scaling settings.
        """
        return pulumi.get(self, "scaling_configs")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the EKS Node Group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        Identifiers of EC2 Subnets to associate with the EKS Node Group.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.GetNodeGroupTaintResult']:
        """
        List of objects containing information about taints applied to the nodes in the EKS Node Group.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Kubernetes version.
        """
        return pulumi.get(self, "version")


class AwaitableGetNodeGroupResult(GetNodeGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodeGroupResult(
            ami_type=self.ami_type,
            arn=self.arn,
            cluster_name=self.cluster_name,
            disk_size=self.disk_size,
            id=self.id,
            instance_types=self.instance_types,
            labels=self.labels,
            node_group_name=self.node_group_name,
            node_role_arn=self.node_role_arn,
            release_version=self.release_version,
            remote_accesses=self.remote_accesses,
            resources=self.resources,
            scaling_configs=self.scaling_configs,
            status=self.status,
            subnet_ids=self.subnet_ids,
            tags=self.tags,
            taints=self.taints,
            version=self.version)


def get_node_group(cluster_name: Optional[str] = None,
                   node_group_name: Optional[str] = None,
                   tags: Optional[Mapping[str, str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodeGroupResult:
    """
    Retrieve information about an EKS Node Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_node_group(cluster_name="example",
        node_group_name="example")
    ```


    :param str cluster_name: The name of the cluster.
    :param str node_group_name: The name of the node group.
    :param Mapping[str, str] tags: Key-value map of resource tags.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['nodeGroupName'] = node_group_name
    __args__['tags'] = tags
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:eks/getNodeGroup:getNodeGroup', __args__, opts=opts, typ=GetNodeGroupResult).value

    return AwaitableGetNodeGroupResult(
        ami_type=__ret__.ami_type,
        arn=__ret__.arn,
        cluster_name=__ret__.cluster_name,
        disk_size=__ret__.disk_size,
        id=__ret__.id,
        instance_types=__ret__.instance_types,
        labels=__ret__.labels,
        node_group_name=__ret__.node_group_name,
        node_role_arn=__ret__.node_role_arn,
        release_version=__ret__.release_version,
        remote_accesses=__ret__.remote_accesses,
        resources=__ret__.resources,
        scaling_configs=__ret__.scaling_configs,
        status=__ret__.status,
        subnet_ids=__ret__.subnet_ids,
        tags=__ret__.tags,
        taints=__ret__.taints,
        version=__ret__.version)


@_utilities.lift_output_func(get_node_group)
def get_node_group_output(cluster_name: Optional[pulumi.Input[str]] = None,
                          node_group_name: Optional[pulumi.Input[str]] = None,
                          tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNodeGroupResult]:
    """
    Retrieve information about an EKS Node Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_node_group(cluster_name="example",
        node_group_name="example")
    ```


    :param str cluster_name: The name of the cluster.
    :param str node_group_name: The name of the node group.
    :param Mapping[str, str] tags: Key-value map of resource tags.
    """
    ...
