# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 availability_zone_name: Optional[pulumi.Input[str]] = None,
                 creation_token: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLifecyclePolicyArgs']]]] = None,
                 performance_mode: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input[str] availability_zone_name: the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
        :param pulumi.Input[str] creation_token: A unique name (a maximum of 64 characters are allowed)
               used as reference when creating the Elastic File System to ensure idempotent file
               system creation. By default generated by this provider. See [Elastic File System]
               (http://docs.aws.amazon.com/efs/latest/ug/) user guide for more information.
        :param pulumi.Input[bool] encrypted: If true, the disk will be encrypted.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
        :param pulumi.Input[Sequence[pulumi.Input['FileSystemLifecyclePolicyArgs']]] lifecycle_policies: A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
        :param pulumi.Input[str] performance_mode: The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
        :param pulumi.Input[float] provisioned_throughput_in_mibps: The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] throughput_mode: Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
        """
        if availability_zone_name is not None:
            pulumi.set(__self__, "availability_zone_name", availability_zone_name)
        if creation_token is not None:
            pulumi.set(__self__, "creation_token", creation_token)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lifecycle_policies is not None:
            pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        if performance_mode is not None:
            pulumi.set(__self__, "performance_mode", performance_mode)
        if provisioned_throughput_in_mibps is not None:
            pulumi.set(__self__, "provisioned_throughput_in_mibps", provisioned_throughput_in_mibps)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput_mode is not None:
            pulumi.set(__self__, "throughput_mode", throughput_mode)

    @property
    @pulumi.getter(name="availabilityZoneName")
    def availability_zone_name(self) -> Optional[pulumi.Input[str]]:
        """
        the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
        """
        return pulumi.get(self, "availability_zone_name")

    @availability_zone_name.setter
    def availability_zone_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_name", value)

    @property
    @pulumi.getter(name="creationToken")
    def creation_token(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name (a maximum of 64 characters are allowed)
        used as reference when creating the Elastic File System to ensure idempotent file
        system creation. By default generated by this provider. See [Elastic File System]
        (http://docs.aws.amazon.com/efs/latest/ug/) user guide for more information.
        """
        return pulumi.get(self, "creation_token")

    @creation_token.setter
    def creation_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_token", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the disk will be encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLifecyclePolicyArgs']]]]:
        """
        A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
        """
        return pulumi.get(self, "lifecycle_policies")

    @lifecycle_policies.setter
    def lifecycle_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLifecyclePolicyArgs']]]]):
        pulumi.set(self, "lifecycle_policies", value)

    @property
    @pulumi.getter(name="performanceMode")
    def performance_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
        """
        return pulumi.get(self, "performance_mode")

    @performance_mode.setter
    def performance_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_mode", value)

    @property
    @pulumi.getter(name="provisionedThroughputInMibps")
    def provisioned_throughput_in_mibps(self) -> Optional[pulumi.Input[float]]:
        """
        The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        """
        return pulumi.get(self, "provisioned_throughput_in_mibps")

    @provisioned_throughput_in_mibps.setter
    def provisioned_throughput_in_mibps(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "provisioned_throughput_in_mibps", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
        """
        return pulumi.get(self, "throughput_mode")

    @throughput_mode.setter
    def throughput_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throughput_mode", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 availability_zone_name: Optional[pulumi.Input[str]] = None,
                 creation_token: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLifecyclePolicyArgs']]]] = None,
                 number_of_mount_targets: Optional[pulumi.Input[int]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 performance_mode: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
                 size_in_bytes: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSizeInByteArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[str] availability_zone_id: The identifier of the Availability Zone in which the file system's One Zone storage classes exist.
        :param pulumi.Input[str] availability_zone_name: the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
        :param pulumi.Input[str] creation_token: A unique name (a maximum of 64 characters are allowed)
               used as reference when creating the Elastic File System to ensure idempotent file
               system creation. By default generated by this provider. See [Elastic File System]
               (http://docs.aws.amazon.com/efs/latest/ug/) user guide for more information.
        :param pulumi.Input[str] dns_name: The DNS name for the filesystem per [documented convention](http://docs.aws.amazon.com/efs/latest/ug/mounting-fs-mount-cmd-dns-name.html).
        :param pulumi.Input[bool] encrypted: If true, the disk will be encrypted.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
        :param pulumi.Input[Sequence[pulumi.Input['FileSystemLifecyclePolicyArgs']]] lifecycle_policies: A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
        :param pulumi.Input[int] number_of_mount_targets: The current number of mount targets that the file system has.
        :param pulumi.Input[str] owner_id: The AWS account that created the file system. If the file system was createdby an IAM user, the parent account to which the user belongs is the owner.
        :param pulumi.Input[str] performance_mode: The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
        :param pulumi.Input[float] provisioned_throughput_in_mibps: The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        :param pulumi.Input[Sequence[pulumi.Input['FileSystemSizeInByteArgs']]] size_in_bytes: The latest known metered size (in bytes) of data stored in the file system, the value is not the exact size that the file system was at any point in time. See Size In Bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] throughput_mode: Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if availability_zone_name is not None:
            pulumi.set(__self__, "availability_zone_name", availability_zone_name)
        if creation_token is not None:
            pulumi.set(__self__, "creation_token", creation_token)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lifecycle_policies is not None:
            pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        if number_of_mount_targets is not None:
            pulumi.set(__self__, "number_of_mount_targets", number_of_mount_targets)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if performance_mode is not None:
            pulumi.set(__self__, "performance_mode", performance_mode)
        if provisioned_throughput_in_mibps is not None:
            pulumi.set(__self__, "provisioned_throughput_in_mibps", provisioned_throughput_in_mibps)
        if size_in_bytes is not None:
            pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if throughput_mode is not None:
            pulumi.set(__self__, "throughput_mode", throughput_mode)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the Availability Zone in which the file system's One Zone storage classes exist.
        """
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_id", value)

    @property
    @pulumi.getter(name="availabilityZoneName")
    def availability_zone_name(self) -> Optional[pulumi.Input[str]]:
        """
        the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
        """
        return pulumi.get(self, "availability_zone_name")

    @availability_zone_name.setter
    def availability_zone_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_name", value)

    @property
    @pulumi.getter(name="creationToken")
    def creation_token(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name (a maximum of 64 characters are allowed)
        used as reference when creating the Elastic File System to ensure idempotent file
        system creation. By default generated by this provider. See [Elastic File System]
        (http://docs.aws.amazon.com/efs/latest/ug/) user guide for more information.
        """
        return pulumi.get(self, "creation_token")

    @creation_token.setter
    def creation_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_token", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name for the filesystem per [documented convention](http://docs.aws.amazon.com/efs/latest/ug/mounting-fs-mount-cmd-dns-name.html).
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the disk will be encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLifecyclePolicyArgs']]]]:
        """
        A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
        """
        return pulumi.get(self, "lifecycle_policies")

    @lifecycle_policies.setter
    def lifecycle_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemLifecyclePolicyArgs']]]]):
        pulumi.set(self, "lifecycle_policies", value)

    @property
    @pulumi.getter(name="numberOfMountTargets")
    def number_of_mount_targets(self) -> Optional[pulumi.Input[int]]:
        """
        The current number of mount targets that the file system has.
        """
        return pulumi.get(self, "number_of_mount_targets")

    @number_of_mount_targets.setter
    def number_of_mount_targets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_mount_targets", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS account that created the file system. If the file system was createdby an IAM user, the parent account to which the user belongs is the owner.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="performanceMode")
    def performance_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
        """
        return pulumi.get(self, "performance_mode")

    @performance_mode.setter
    def performance_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_mode", value)

    @property
    @pulumi.getter(name="provisionedThroughputInMibps")
    def provisioned_throughput_in_mibps(self) -> Optional[pulumi.Input[float]]:
        """
        The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        """
        return pulumi.get(self, "provisioned_throughput_in_mibps")

    @provisioned_throughput_in_mibps.setter
    def provisioned_throughput_in_mibps(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "provisioned_throughput_in_mibps", value)

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSizeInByteArgs']]]]:
        """
        The latest known metered size (in bytes) of data stored in the file system, the value is not the exact size that the file system was at any point in time. See Size In Bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @size_in_bytes.setter
    def size_in_bytes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSizeInByteArgs']]]]):
        pulumi.set(self, "size_in_bytes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
        """
        return pulumi.get(self, "throughput_mode")

    @throughput_mode.setter
    def throughput_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throughput_mode", value)


class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_name: Optional[pulumi.Input[str]] = None,
                 creation_token: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileSystemLifecyclePolicyArgs']]]]] = None,
                 performance_mode: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Elastic File System (EFS) File System resource.

        ## Example Usage
        ### EFS File System w/ tags

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.efs.FileSystem("foo", tags={
            "Name": "MyProduct",
        })
        ```
        ### Using lifecycle policy

        ```python
        import pulumi
        import pulumi_aws as aws

        foo_with_lifecyle_policy = aws.efs.FileSystem("fooWithLifecylePolicy", lifecycle_policies=[aws.efs.FileSystemLifecyclePolicyArgs(
            transition_to_ia="AFTER_30_DAYS",
        )])
        ```

        ## Import

        The EFS file systems can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:efs/fileSystem:FileSystem foo fs-6fa144c6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone_name: the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
        :param pulumi.Input[str] creation_token: A unique name (a maximum of 64 characters are allowed)
               used as reference when creating the Elastic File System to ensure idempotent file
               system creation. By default generated by this provider. See [Elastic File System]
               (http://docs.aws.amazon.com/efs/latest/ug/) user guide for more information.
        :param pulumi.Input[bool] encrypted: If true, the disk will be encrypted.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileSystemLifecyclePolicyArgs']]]] lifecycle_policies: A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
        :param pulumi.Input[str] performance_mode: The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
        :param pulumi.Input[float] provisioned_throughput_in_mibps: The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] throughput_mode: Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FileSystemArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic File System (EFS) File System resource.

        ## Example Usage
        ### EFS File System w/ tags

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.efs.FileSystem("foo", tags={
            "Name": "MyProduct",
        })
        ```
        ### Using lifecycle policy

        ```python
        import pulumi
        import pulumi_aws as aws

        foo_with_lifecyle_policy = aws.efs.FileSystem("fooWithLifecylePolicy", lifecycle_policies=[aws.efs.FileSystemLifecyclePolicyArgs(
            transition_to_ia="AFTER_30_DAYS",
        )])
        ```

        ## Import

        The EFS file systems can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:efs/fileSystem:FileSystem foo fs-6fa144c6
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_name: Optional[pulumi.Input[str]] = None,
                 creation_token: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileSystemLifecyclePolicyArgs']]]]] = None,
                 performance_mode: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            __props__.__dict__["availability_zone_name"] = availability_zone_name
            __props__.__dict__["creation_token"] = creation_token
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["lifecycle_policies"] = lifecycle_policies
            __props__.__dict__["performance_mode"] = performance_mode
            __props__.__dict__["provisioned_throughput_in_mibps"] = provisioned_throughput_in_mibps
            __props__.__dict__["tags"] = tags
            __props__.__dict__["throughput_mode"] = throughput_mode
            __props__.__dict__["arn"] = None
            __props__.__dict__["availability_zone_id"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["number_of_mount_targets"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["size_in_bytes"] = None
            __props__.__dict__["tags_all"] = None
        super(FileSystem, __self__).__init__(
            'aws:efs/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            availability_zone_id: Optional[pulumi.Input[str]] = None,
            availability_zone_name: Optional[pulumi.Input[str]] = None,
            creation_token: Optional[pulumi.Input[str]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            encrypted: Optional[pulumi.Input[bool]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileSystemLifecyclePolicyArgs']]]]] = None,
            number_of_mount_targets: Optional[pulumi.Input[int]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            performance_mode: Optional[pulumi.Input[str]] = None,
            provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
            size_in_bytes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileSystemSizeInByteArgs']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            throughput_mode: Optional[pulumi.Input[str]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[str] availability_zone_id: The identifier of the Availability Zone in which the file system's One Zone storage classes exist.
        :param pulumi.Input[str] availability_zone_name: the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
        :param pulumi.Input[str] creation_token: A unique name (a maximum of 64 characters are allowed)
               used as reference when creating the Elastic File System to ensure idempotent file
               system creation. By default generated by this provider. See [Elastic File System]
               (http://docs.aws.amazon.com/efs/latest/ug/) user guide for more information.
        :param pulumi.Input[str] dns_name: The DNS name for the filesystem per [documented convention](http://docs.aws.amazon.com/efs/latest/ug/mounting-fs-mount-cmd-dns-name.html).
        :param pulumi.Input[bool] encrypted: If true, the disk will be encrypted.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileSystemLifecyclePolicyArgs']]]] lifecycle_policies: A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
        :param pulumi.Input[int] number_of_mount_targets: The current number of mount targets that the file system has.
        :param pulumi.Input[str] owner_id: The AWS account that created the file system. If the file system was createdby an IAM user, the parent account to which the user belongs is the owner.
        :param pulumi.Input[str] performance_mode: The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
        :param pulumi.Input[float] provisioned_throughput_in_mibps: The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileSystemSizeInByteArgs']]]] size_in_bytes: The latest known metered size (in bytes) of data stored in the file system, the value is not the exact size that the file system was at any point in time. See Size In Bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] throughput_mode: Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone_id"] = availability_zone_id
        __props__.__dict__["availability_zone_name"] = availability_zone_name
        __props__.__dict__["creation_token"] = creation_token
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["lifecycle_policies"] = lifecycle_policies
        __props__.__dict__["number_of_mount_targets"] = number_of_mount_targets
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["performance_mode"] = performance_mode
        __props__.__dict__["provisioned_throughput_in_mibps"] = provisioned_throughput_in_mibps
        __props__.__dict__["size_in_bytes"] = size_in_bytes
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["throughput_mode"] = throughput_mode
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> pulumi.Output[str]:
        """
        The identifier of the Availability Zone in which the file system's One Zone storage classes exist.
        """
        return pulumi.get(self, "availability_zone_id")

    @property
    @pulumi.getter(name="availabilityZoneName")
    def availability_zone_name(self) -> pulumi.Output[str]:
        """
        the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
        """
        return pulumi.get(self, "availability_zone_name")

    @property
    @pulumi.getter(name="creationToken")
    def creation_token(self) -> pulumi.Output[str]:
        """
        A unique name (a maximum of 64 characters are allowed)
        used as reference when creating the Elastic File System to ensure idempotent file
        system creation. By default generated by this provider. See [Elastic File System]
        (http://docs.aws.amazon.com/efs/latest/ug/) user guide for more information.
        """
        return pulumi.get(self, "creation_token")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The DNS name for the filesystem per [documented convention](http://docs.aws.amazon.com/efs/latest/ug/mounting-fs-mount-cmd-dns-name.html).
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[bool]:
        """
        If true, the disk will be encrypted.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> pulumi.Output[Optional[Sequence['outputs.FileSystemLifecyclePolicy']]]:
        """
        A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
        """
        return pulumi.get(self, "lifecycle_policies")

    @property
    @pulumi.getter(name="numberOfMountTargets")
    def number_of_mount_targets(self) -> pulumi.Output[int]:
        """
        The current number of mount targets that the file system has.
        """
        return pulumi.get(self, "number_of_mount_targets")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        The AWS account that created the file system. If the file system was createdby an IAM user, the parent account to which the user belongs is the owner.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="performanceMode")
    def performance_mode(self) -> pulumi.Output[str]:
        """
        The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
        """
        return pulumi.get(self, "performance_mode")

    @property
    @pulumi.getter(name="provisionedThroughputInMibps")
    def provisioned_throughput_in_mibps(self) -> pulumi.Output[Optional[float]]:
        """
        The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        """
        return pulumi.get(self, "provisioned_throughput_in_mibps")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> pulumi.Output[Sequence['outputs.FileSystemSizeInByte']]:
        """
        The latest known metered size (in bytes) of data stored in the file system, the value is not the exact size that the file system was at any point in time. See Size In Bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
        """
        return pulumi.get(self, "throughput_mode")

