# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConnectPeerResult',
    'AwaitableGetConnectPeerResult',
    'get_connect_peer',
    'get_connect_peer_output',
]

@pulumi.output_type
class GetConnectPeerResult:
    """
    A collection of values returned by getConnectPeer.
    """
    def __init__(__self__, arn=None, bgp_asn=None, filters=None, id=None, inside_cidr_blocks=None, peer_address=None, tags=None, transit_gateway_address=None, transit_gateway_attachment_id=None, transit_gateway_connect_peer_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if bgp_asn and not isinstance(bgp_asn, str):
            raise TypeError("Expected argument 'bgp_asn' to be a str")
        pulumi.set(__self__, "bgp_asn", bgp_asn)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inside_cidr_blocks and not isinstance(inside_cidr_blocks, list):
            raise TypeError("Expected argument 'inside_cidr_blocks' to be a list")
        pulumi.set(__self__, "inside_cidr_blocks", inside_cidr_blocks)
        if peer_address and not isinstance(peer_address, str):
            raise TypeError("Expected argument 'peer_address' to be a str")
        pulumi.set(__self__, "peer_address", peer_address)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if transit_gateway_address and not isinstance(transit_gateway_address, str):
            raise TypeError("Expected argument 'transit_gateway_address' to be a str")
        pulumi.set(__self__, "transit_gateway_address", transit_gateway_address)
        if transit_gateway_attachment_id and not isinstance(transit_gateway_attachment_id, str):
            raise TypeError("Expected argument 'transit_gateway_attachment_id' to be a str")
        pulumi.set(__self__, "transit_gateway_attachment_id", transit_gateway_attachment_id)
        if transit_gateway_connect_peer_id and not isinstance(transit_gateway_connect_peer_id, str):
            raise TypeError("Expected argument 'transit_gateway_connect_peer_id' to be a str")
        pulumi.set(__self__, "transit_gateway_connect_peer_id", transit_gateway_connect_peer_id)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        EC2 Transit Gateway Connect Peer ARN
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bgpAsn")
    def bgp_asn(self) -> str:
        """
        The BGP ASN number assigned customer device
        """
        return pulumi.get(self, "bgp_asn")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetConnectPeerFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="insideCidrBlocks")
    def inside_cidr_blocks(self) -> Sequence[str]:
        """
        The CIDR blocks that will be used for addressing within the tunnel.
        """
        return pulumi.get(self, "inside_cidr_blocks")

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> str:
        """
        The IP addressed assigned to customer device, which is used as tunnel endpoint
        """
        return pulumi.get(self, "peer_address")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Key-value tags for the EC2 Transit Gateway Connect Peer
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transitGatewayAddress")
    def transit_gateway_address(self) -> str:
        """
        The IP address assigned to Transit Gateway, which is used as tunnel endpoint.
        """
        return pulumi.get(self, "transit_gateway_address")

    @property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> str:
        """
        The Transit Gateway Connect
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @property
    @pulumi.getter(name="transitGatewayConnectPeerId")
    def transit_gateway_connect_peer_id(self) -> str:
        return pulumi.get(self, "transit_gateway_connect_peer_id")


class AwaitableGetConnectPeerResult(GetConnectPeerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectPeerResult(
            arn=self.arn,
            bgp_asn=self.bgp_asn,
            filters=self.filters,
            id=self.id,
            inside_cidr_blocks=self.inside_cidr_blocks,
            peer_address=self.peer_address,
            tags=self.tags,
            transit_gateway_address=self.transit_gateway_address,
            transit_gateway_attachment_id=self.transit_gateway_attachment_id,
            transit_gateway_connect_peer_id=self.transit_gateway_connect_peer_id)


def get_connect_peer(filters: Optional[Sequence[pulumi.InputType['GetConnectPeerFilterArgs']]] = None,
                     tags: Optional[Mapping[str, str]] = None,
                     transit_gateway_connect_peer_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectPeerResult:
    """
    Get information on an EC2 Transit Gateway Connect Peer.

    ## Example Usage
    ### By Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_connect_peer(filters=[aws.ec2transitgateway.GetConnectPeerFilterArgs(
        name="transit-gateway-attachment-id",
        values=["tgw-attach-12345678"],
    )])
    ```
    ### By Identifier

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_connect_peer(transit_gateway_connect_peer_id="tgw-connect-peer-12345678")
    ```


    :param Sequence[pulumi.InputType['GetConnectPeerFilterArgs']] filters: One or more configuration blocks containing name-values filters. Detailed below.
    :param Mapping[str, str] tags: Key-value tags for the EC2 Transit Gateway Connect Peer
    :param str transit_gateway_connect_peer_id: Identifier of the EC2 Transit Gateway Connect Peer.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['tags'] = tags
    __args__['transitGatewayConnectPeerId'] = transit_gateway_connect_peer_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:ec2transitgateway/getConnectPeer:getConnectPeer', __args__, opts=opts, typ=GetConnectPeerResult).value

    return AwaitableGetConnectPeerResult(
        arn=__ret__.arn,
        bgp_asn=__ret__.bgp_asn,
        filters=__ret__.filters,
        id=__ret__.id,
        inside_cidr_blocks=__ret__.inside_cidr_blocks,
        peer_address=__ret__.peer_address,
        tags=__ret__.tags,
        transit_gateway_address=__ret__.transit_gateway_address,
        transit_gateway_attachment_id=__ret__.transit_gateway_attachment_id,
        transit_gateway_connect_peer_id=__ret__.transit_gateway_connect_peer_id)


@_utilities.lift_output_func(get_connect_peer)
def get_connect_peer_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetConnectPeerFilterArgs']]]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                            transit_gateway_connect_peer_id: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectPeerResult]:
    """
    Get information on an EC2 Transit Gateway Connect Peer.

    ## Example Usage
    ### By Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_connect_peer(filters=[aws.ec2transitgateway.GetConnectPeerFilterArgs(
        name="transit-gateway-attachment-id",
        values=["tgw-attach-12345678"],
    )])
    ```
    ### By Identifier

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_connect_peer(transit_gateway_connect_peer_id="tgw-connect-peer-12345678")
    ```


    :param Sequence[pulumi.InputType['GetConnectPeerFilterArgs']] filters: One or more configuration blocks containing name-values filters. Detailed below.
    :param Mapping[str, str] tags: Key-value tags for the EC2 Transit Gateway Connect Peer
    :param str transit_gateway_connect_peer_id: Identifier of the EC2 Transit Gateway Connect Peer.
    """
    ...
