# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SubnetArgs', 'Subnet']

@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
                 enable_dns64: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 ipv6_native: Optional[pulumi.Input[bool]] = None,
                 map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 outpost_arn: Optional[pulumi.Input[str]] = None,
                 private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Subnet resource.
        :param pulumi.Input[str] vpc_id: The VPC ID.
        :param pulumi.Input[bool] assign_ipv6_address_on_creation: Specify true to indicate
               that network interfaces created in the specified subnet should be
               assigned an IPv6 address. Default is `false`
        :param pulumi.Input[str] availability_zone: AZ for the subnet.
        :param pulumi.Input[str] availability_zone_id: AZ ID of the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
        :param pulumi.Input[str] cidr_block: The IPv4 CIDR block for the subnet.
        :param pulumi.Input[str] customer_owned_ipv4_pool: The customer owned IPv4 address pool. Typically used with the `map_customer_owned_ip_on_launch` argument. The `outpost_arn` argument must be specified when configured.
        :param pulumi.Input[bool] enable_dns64: Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. Default: `false`.
        :param pulumi.Input[bool] enable_resource_name_dns_a_record_on_launch: Indicates whether to respond to DNS queries for instance hostnames with DNS A records. Default: `false`.
        :param pulumi.Input[bool] enable_resource_name_dns_aaaa_record_on_launch: Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records. Default: `false`.
        :param pulumi.Input[str] ipv6_cidr_block: The IPv6 network range for the subnet,
               in CIDR notation. The subnet size must use a /64 prefix length.
        :param pulumi.Input[bool] ipv6_native: Indicates whether to create an IPv6-only subnet. Default: `false`.
        :param pulumi.Input[bool] map_customer_owned_ip_on_launch: Specify `true` to indicate that network interfaces created in the subnet should be assigned a customer owned IP address. The `customer_owned_ipv4_pool` and `outpost_arn` arguments must be specified when set to `true`. Default is `false`.
        :param pulumi.Input[bool] map_public_ip_on_launch: Specify true to indicate
               that instances launched into the subnet should be assigned
               a public IP address. Default is `false`.
        :param pulumi.Input[str] outpost_arn: The Amazon Resource Name (ARN) of the Outpost.
        :param pulumi.Input[str] private_dns_hostname_type_on_launch: The type of hostnames to assign to instances in the subnet at launch. For IPv6-only subnets, an instance DNS name must be based on the instance ID. For dual-stack and IPv4-only subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name`, `resource-name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if assign_ipv6_address_on_creation is not None:
            pulumi.set(__self__, "assign_ipv6_address_on_creation", assign_ipv6_address_on_creation)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if customer_owned_ipv4_pool is not None:
            pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if enable_dns64 is not None:
            pulumi.set(__self__, "enable_dns64", enable_dns64)
        if enable_resource_name_dns_a_record_on_launch is not None:
            pulumi.set(__self__, "enable_resource_name_dns_a_record_on_launch", enable_resource_name_dns_a_record_on_launch)
        if enable_resource_name_dns_aaaa_record_on_launch is not None:
            pulumi.set(__self__, "enable_resource_name_dns_aaaa_record_on_launch", enable_resource_name_dns_aaaa_record_on_launch)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_native is not None:
            pulumi.set(__self__, "ipv6_native", ipv6_native)
        if map_customer_owned_ip_on_launch is not None:
            pulumi.set(__self__, "map_customer_owned_ip_on_launch", map_customer_owned_ip_on_launch)
        if map_public_ip_on_launch is not None:
            pulumi.set(__self__, "map_public_ip_on_launch", map_public_ip_on_launch)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if private_dns_hostname_type_on_launch is not None:
            pulumi.set(__self__, "private_dns_hostname_type_on_launch", private_dns_hostname_type_on_launch)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="assignIpv6AddressOnCreation")
    def assign_ipv6_address_on_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify true to indicate
        that network interfaces created in the specified subnet should be
        assigned an IPv6 address. Default is `false`
        """
        return pulumi.get(self, "assign_ipv6_address_on_creation")

    @assign_ipv6_address_on_creation.setter
    def assign_ipv6_address_on_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assign_ipv6_address_on_creation", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        AZ for the subnet.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        AZ ID of the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
        """
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_id", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 CIDR block for the subnet.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> Optional[pulumi.Input[str]]:
        """
        The customer owned IPv4 address pool. Typically used with the `map_customer_owned_ip_on_launch` argument. The `outpost_arn` argument must be specified when configured.
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @customer_owned_ipv4_pool.setter
    def customer_owned_ipv4_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_owned_ipv4_pool", value)

    @property
    @pulumi.getter(name="enableDns64")
    def enable_dns64(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. Default: `false`.
        """
        return pulumi.get(self, "enable_dns64")

    @enable_dns64.setter
    def enable_dns64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dns64", value)

    @property
    @pulumi.getter(name="enableResourceNameDnsARecordOnLaunch")
    def enable_resource_name_dns_a_record_on_launch(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to respond to DNS queries for instance hostnames with DNS A records. Default: `false`.
        """
        return pulumi.get(self, "enable_resource_name_dns_a_record_on_launch")

    @enable_resource_name_dns_a_record_on_launch.setter
    def enable_resource_name_dns_a_record_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_resource_name_dns_a_record_on_launch", value)

    @property
    @pulumi.getter(name="enableResourceNameDnsAaaaRecordOnLaunch")
    def enable_resource_name_dns_aaaa_record_on_launch(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records. Default: `false`.
        """
        return pulumi.get(self, "enable_resource_name_dns_aaaa_record_on_launch")

    @enable_resource_name_dns_aaaa_record_on_launch.setter
    def enable_resource_name_dns_aaaa_record_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_resource_name_dns_aaaa_record_on_launch", value)

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 network range for the subnet,
        in CIDR notation. The subnet size must use a /64 prefix length.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @property
    @pulumi.getter(name="ipv6Native")
    def ipv6_native(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to create an IPv6-only subnet. Default: `false`.
        """
        return pulumi.get(self, "ipv6_native")

    @ipv6_native.setter
    def ipv6_native(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_native", value)

    @property
    @pulumi.getter(name="mapCustomerOwnedIpOnLaunch")
    def map_customer_owned_ip_on_launch(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify `true` to indicate that network interfaces created in the subnet should be assigned a customer owned IP address. The `customer_owned_ipv4_pool` and `outpost_arn` arguments must be specified when set to `true`. Default is `false`.
        """
        return pulumi.get(self, "map_customer_owned_ip_on_launch")

    @map_customer_owned_ip_on_launch.setter
    def map_customer_owned_ip_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "map_customer_owned_ip_on_launch", value)

    @property
    @pulumi.getter(name="mapPublicIpOnLaunch")
    def map_public_ip_on_launch(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify true to indicate
        that instances launched into the subnet should be assigned
        a public IP address. Default is `false`.
        """
        return pulumi.get(self, "map_public_ip_on_launch")

    @map_public_ip_on_launch.setter
    def map_public_ip_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "map_public_ip_on_launch", value)

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Outpost.
        """
        return pulumi.get(self, "outpost_arn")

    @outpost_arn.setter
    def outpost_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outpost_arn", value)

    @property
    @pulumi.getter(name="privateDnsHostnameTypeOnLaunch")
    def private_dns_hostname_type_on_launch(self) -> Optional[pulumi.Input[str]]:
        """
        The type of hostnames to assign to instances in the subnet at launch. For IPv6-only subnets, an instance DNS name must be based on the instance ID. For dual-stack and IPv4-only subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name`, `resource-name`.
        """
        return pulumi.get(self, "private_dns_hostname_type_on_launch")

    @private_dns_hostname_type_on_launch.setter
    def private_dns_hostname_type_on_launch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns_hostname_type_on_launch", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SubnetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
                 enable_dns64: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 ipv6_cidr_block_association_id: Optional[pulumi.Input[str]] = None,
                 ipv6_native: Optional[pulumi.Input[bool]] = None,
                 map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 outpost_arn: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Subnet resources.
        :param pulumi.Input[str] arn: The ARN of the subnet.
        :param pulumi.Input[bool] assign_ipv6_address_on_creation: Specify true to indicate
               that network interfaces created in the specified subnet should be
               assigned an IPv6 address. Default is `false`
        :param pulumi.Input[str] availability_zone: AZ for the subnet.
        :param pulumi.Input[str] availability_zone_id: AZ ID of the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
        :param pulumi.Input[str] cidr_block: The IPv4 CIDR block for the subnet.
        :param pulumi.Input[str] customer_owned_ipv4_pool: The customer owned IPv4 address pool. Typically used with the `map_customer_owned_ip_on_launch` argument. The `outpost_arn` argument must be specified when configured.
        :param pulumi.Input[bool] enable_dns64: Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. Default: `false`.
        :param pulumi.Input[bool] enable_resource_name_dns_a_record_on_launch: Indicates whether to respond to DNS queries for instance hostnames with DNS A records. Default: `false`.
        :param pulumi.Input[bool] enable_resource_name_dns_aaaa_record_on_launch: Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records. Default: `false`.
        :param pulumi.Input[str] ipv6_cidr_block: The IPv6 network range for the subnet,
               in CIDR notation. The subnet size must use a /64 prefix length.
        :param pulumi.Input[str] ipv6_cidr_block_association_id: The association ID for the IPv6 CIDR block.
        :param pulumi.Input[bool] ipv6_native: Indicates whether to create an IPv6-only subnet. Default: `false`.
        :param pulumi.Input[bool] map_customer_owned_ip_on_launch: Specify `true` to indicate that network interfaces created in the subnet should be assigned a customer owned IP address. The `customer_owned_ipv4_pool` and `outpost_arn` arguments must be specified when set to `true`. Default is `false`.
        :param pulumi.Input[bool] map_public_ip_on_launch: Specify true to indicate
               that instances launched into the subnet should be assigned
               a public IP address. Default is `false`.
        :param pulumi.Input[str] outpost_arn: The Amazon Resource Name (ARN) of the Outpost.
        :param pulumi.Input[str] owner_id: The ID of the AWS account that owns the subnet.
        :param pulumi.Input[str] private_dns_hostname_type_on_launch: The type of hostnames to assign to instances in the subnet at launch. For IPv6-only subnets, an instance DNS name must be based on the instance ID. For dual-stack and IPv4-only subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name`, `resource-name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[str] vpc_id: The VPC ID.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if assign_ipv6_address_on_creation is not None:
            pulumi.set(__self__, "assign_ipv6_address_on_creation", assign_ipv6_address_on_creation)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if customer_owned_ipv4_pool is not None:
            pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if enable_dns64 is not None:
            pulumi.set(__self__, "enable_dns64", enable_dns64)
        if enable_resource_name_dns_a_record_on_launch is not None:
            pulumi.set(__self__, "enable_resource_name_dns_a_record_on_launch", enable_resource_name_dns_a_record_on_launch)
        if enable_resource_name_dns_aaaa_record_on_launch is not None:
            pulumi.set(__self__, "enable_resource_name_dns_aaaa_record_on_launch", enable_resource_name_dns_aaaa_record_on_launch)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_cidr_block_association_id is not None:
            pulumi.set(__self__, "ipv6_cidr_block_association_id", ipv6_cidr_block_association_id)
        if ipv6_native is not None:
            pulumi.set(__self__, "ipv6_native", ipv6_native)
        if map_customer_owned_ip_on_launch is not None:
            pulumi.set(__self__, "map_customer_owned_ip_on_launch", map_customer_owned_ip_on_launch)
        if map_public_ip_on_launch is not None:
            pulumi.set(__self__, "map_public_ip_on_launch", map_public_ip_on_launch)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if private_dns_hostname_type_on_launch is not None:
            pulumi.set(__self__, "private_dns_hostname_type_on_launch", private_dns_hostname_type_on_launch)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the subnet.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="assignIpv6AddressOnCreation")
    def assign_ipv6_address_on_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify true to indicate
        that network interfaces created in the specified subnet should be
        assigned an IPv6 address. Default is `false`
        """
        return pulumi.get(self, "assign_ipv6_address_on_creation")

    @assign_ipv6_address_on_creation.setter
    def assign_ipv6_address_on_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assign_ipv6_address_on_creation", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        AZ for the subnet.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        AZ ID of the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
        """
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_id", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 CIDR block for the subnet.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> Optional[pulumi.Input[str]]:
        """
        The customer owned IPv4 address pool. Typically used with the `map_customer_owned_ip_on_launch` argument. The `outpost_arn` argument must be specified when configured.
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @customer_owned_ipv4_pool.setter
    def customer_owned_ipv4_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_owned_ipv4_pool", value)

    @property
    @pulumi.getter(name="enableDns64")
    def enable_dns64(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. Default: `false`.
        """
        return pulumi.get(self, "enable_dns64")

    @enable_dns64.setter
    def enable_dns64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dns64", value)

    @property
    @pulumi.getter(name="enableResourceNameDnsARecordOnLaunch")
    def enable_resource_name_dns_a_record_on_launch(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to respond to DNS queries for instance hostnames with DNS A records. Default: `false`.
        """
        return pulumi.get(self, "enable_resource_name_dns_a_record_on_launch")

    @enable_resource_name_dns_a_record_on_launch.setter
    def enable_resource_name_dns_a_record_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_resource_name_dns_a_record_on_launch", value)

    @property
    @pulumi.getter(name="enableResourceNameDnsAaaaRecordOnLaunch")
    def enable_resource_name_dns_aaaa_record_on_launch(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records. Default: `false`.
        """
        return pulumi.get(self, "enable_resource_name_dns_aaaa_record_on_launch")

    @enable_resource_name_dns_aaaa_record_on_launch.setter
    def enable_resource_name_dns_aaaa_record_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_resource_name_dns_aaaa_record_on_launch", value)

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 network range for the subnet,
        in CIDR notation. The subnet size must use a /64 prefix length.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @property
    @pulumi.getter(name="ipv6CidrBlockAssociationId")
    def ipv6_cidr_block_association_id(self) -> Optional[pulumi.Input[str]]:
        """
        The association ID for the IPv6 CIDR block.
        """
        return pulumi.get(self, "ipv6_cidr_block_association_id")

    @ipv6_cidr_block_association_id.setter
    def ipv6_cidr_block_association_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_block_association_id", value)

    @property
    @pulumi.getter(name="ipv6Native")
    def ipv6_native(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to create an IPv6-only subnet. Default: `false`.
        """
        return pulumi.get(self, "ipv6_native")

    @ipv6_native.setter
    def ipv6_native(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_native", value)

    @property
    @pulumi.getter(name="mapCustomerOwnedIpOnLaunch")
    def map_customer_owned_ip_on_launch(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify `true` to indicate that network interfaces created in the subnet should be assigned a customer owned IP address. The `customer_owned_ipv4_pool` and `outpost_arn` arguments must be specified when set to `true`. Default is `false`.
        """
        return pulumi.get(self, "map_customer_owned_ip_on_launch")

    @map_customer_owned_ip_on_launch.setter
    def map_customer_owned_ip_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "map_customer_owned_ip_on_launch", value)

    @property
    @pulumi.getter(name="mapPublicIpOnLaunch")
    def map_public_ip_on_launch(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify true to indicate
        that instances launched into the subnet should be assigned
        a public IP address. Default is `false`.
        """
        return pulumi.get(self, "map_public_ip_on_launch")

    @map_public_ip_on_launch.setter
    def map_public_ip_on_launch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "map_public_ip_on_launch", value)

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Outpost.
        """
        return pulumi.get(self, "outpost_arn")

    @outpost_arn.setter
    def outpost_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outpost_arn", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AWS account that owns the subnet.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="privateDnsHostnameTypeOnLaunch")
    def private_dns_hostname_type_on_launch(self) -> Optional[pulumi.Input[str]]:
        """
        The type of hostnames to assign to instances in the subnet at launch. For IPv6-only subnets, an instance DNS name must be based on the instance ID. For dual-stack and IPv4-only subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name`, `resource-name`.
        """
        return pulumi.get(self, "private_dns_hostname_type_on_launch")

    @private_dns_hostname_type_on_launch.setter
    def private_dns_hostname_type_on_launch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns_hostname_type_on_launch", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Subnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
                 enable_dns64: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 ipv6_native: Optional[pulumi.Input[bool]] = None,
                 map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 outpost_arn: Optional[pulumi.Input[str]] = None,
                 private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an VPC subnet resource.

        > **NOTE:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), subnets associated with Lambda Functions can take up to 45 minutes to successfully delete.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Subnet("main",
            vpc_id=aws_vpc["main"]["id"],
            cidr_block="10.0.1.0/24",
            tags={
                "Name": "Main",
            })
        ```
        ### Subnets In Secondary VPC CIDR Blocks

        When managing subnets in one of a VPC's secondary CIDR blocks created using a `ec2.VpcIpv4CidrBlockAssociation`
        resource, it is recommended to reference that resource's `vpc_id` attribute to ensure correct dependency ordering.

        ```python
        import pulumi
        import pulumi_aws as aws

        secondary_cidr = aws.ec2.VpcIpv4CidrBlockAssociation("secondaryCidr",
            vpc_id=aws_vpc["main"]["id"],
            cidr_block="172.2.0.0/16")
        in_secondary_cidr = aws.ec2.Subnet("inSecondaryCidr",
            vpc_id=secondary_cidr.vpc_id,
            cidr_block="172.2.0.0/24")
        ```

        ## Import

        Subnets can be imported using the `subnet id`, e.g.,

        ```sh
         $ pulumi import aws:ec2/subnet:Subnet public_subnet subnet-9d4a7b6c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] assign_ipv6_address_on_creation: Specify true to indicate
               that network interfaces created in the specified subnet should be
               assigned an IPv6 address. Default is `false`
        :param pulumi.Input[str] availability_zone: AZ for the subnet.
        :param pulumi.Input[str] availability_zone_id: AZ ID of the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
        :param pulumi.Input[str] cidr_block: The IPv4 CIDR block for the subnet.
        :param pulumi.Input[str] customer_owned_ipv4_pool: The customer owned IPv4 address pool. Typically used with the `map_customer_owned_ip_on_launch` argument. The `outpost_arn` argument must be specified when configured.
        :param pulumi.Input[bool] enable_dns64: Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. Default: `false`.
        :param pulumi.Input[bool] enable_resource_name_dns_a_record_on_launch: Indicates whether to respond to DNS queries for instance hostnames with DNS A records. Default: `false`.
        :param pulumi.Input[bool] enable_resource_name_dns_aaaa_record_on_launch: Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records. Default: `false`.
        :param pulumi.Input[str] ipv6_cidr_block: The IPv6 network range for the subnet,
               in CIDR notation. The subnet size must use a /64 prefix length.
        :param pulumi.Input[bool] ipv6_native: Indicates whether to create an IPv6-only subnet. Default: `false`.
        :param pulumi.Input[bool] map_customer_owned_ip_on_launch: Specify `true` to indicate that network interfaces created in the subnet should be assigned a customer owned IP address. The `customer_owned_ipv4_pool` and `outpost_arn` arguments must be specified when set to `true`. Default is `false`.
        :param pulumi.Input[bool] map_public_ip_on_launch: Specify true to indicate
               that instances launched into the subnet should be assigned
               a public IP address. Default is `false`.
        :param pulumi.Input[str] outpost_arn: The Amazon Resource Name (ARN) of the Outpost.
        :param pulumi.Input[str] private_dns_hostname_type_on_launch: The type of hostnames to assign to instances in the subnet at launch. For IPv6-only subnets, an instance DNS name must be based on the instance ID. For dual-stack and IPv4-only subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name`, `resource-name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] vpc_id: The VPC ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an VPC subnet resource.

        > **NOTE:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), subnets associated with Lambda Functions can take up to 45 minutes to successfully delete.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Subnet("main",
            vpc_id=aws_vpc["main"]["id"],
            cidr_block="10.0.1.0/24",
            tags={
                "Name": "Main",
            })
        ```
        ### Subnets In Secondary VPC CIDR Blocks

        When managing subnets in one of a VPC's secondary CIDR blocks created using a `ec2.VpcIpv4CidrBlockAssociation`
        resource, it is recommended to reference that resource's `vpc_id` attribute to ensure correct dependency ordering.

        ```python
        import pulumi
        import pulumi_aws as aws

        secondary_cidr = aws.ec2.VpcIpv4CidrBlockAssociation("secondaryCidr",
            vpc_id=aws_vpc["main"]["id"],
            cidr_block="172.2.0.0/16")
        in_secondary_cidr = aws.ec2.Subnet("inSecondaryCidr",
            vpc_id=secondary_cidr.vpc_id,
            cidr_block="172.2.0.0/24")
        ```

        ## Import

        Subnets can be imported using the `subnet id`, e.g.,

        ```sh
         $ pulumi import aws:ec2/subnet:Subnet public_subnet subnet-9d4a7b6c
        ```

        :param str resource_name: The name of the resource.
        :param SubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
                 enable_dns64: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 ipv6_native: Optional[pulumi.Input[bool]] = None,
                 map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
                 outpost_arn: Optional[pulumi.Input[str]] = None,
                 private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetArgs.__new__(SubnetArgs)

            __props__.__dict__["assign_ipv6_address_on_creation"] = assign_ipv6_address_on_creation
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["availability_zone_id"] = availability_zone_id
            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["customer_owned_ipv4_pool"] = customer_owned_ipv4_pool
            __props__.__dict__["enable_dns64"] = enable_dns64
            __props__.__dict__["enable_resource_name_dns_a_record_on_launch"] = enable_resource_name_dns_a_record_on_launch
            __props__.__dict__["enable_resource_name_dns_aaaa_record_on_launch"] = enable_resource_name_dns_aaaa_record_on_launch
            __props__.__dict__["ipv6_cidr_block"] = ipv6_cidr_block
            __props__.__dict__["ipv6_native"] = ipv6_native
            __props__.__dict__["map_customer_owned_ip_on_launch"] = map_customer_owned_ip_on_launch
            __props__.__dict__["map_public_ip_on_launch"] = map_public_ip_on_launch
            __props__.__dict__["outpost_arn"] = outpost_arn
            __props__.__dict__["private_dns_hostname_type_on_launch"] = private_dns_hostname_type_on_launch
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["ipv6_cidr_block_association_id"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["tags_all"] = None
        super(Subnet, __self__).__init__(
            'aws:ec2/subnet:Subnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            assign_ipv6_address_on_creation: Optional[pulumi.Input[bool]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            availability_zone_id: Optional[pulumi.Input[str]] = None,
            cidr_block: Optional[pulumi.Input[str]] = None,
            customer_owned_ipv4_pool: Optional[pulumi.Input[str]] = None,
            enable_dns64: Optional[pulumi.Input[bool]] = None,
            enable_resource_name_dns_a_record_on_launch: Optional[pulumi.Input[bool]] = None,
            enable_resource_name_dns_aaaa_record_on_launch: Optional[pulumi.Input[bool]] = None,
            ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
            ipv6_cidr_block_association_id: Optional[pulumi.Input[str]] = None,
            ipv6_native: Optional[pulumi.Input[bool]] = None,
            map_customer_owned_ip_on_launch: Optional[pulumi.Input[bool]] = None,
            map_public_ip_on_launch: Optional[pulumi.Input[bool]] = None,
            outpost_arn: Optional[pulumi.Input[str]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            private_dns_hostname_type_on_launch: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Subnet':
        """
        Get an existing Subnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the subnet.
        :param pulumi.Input[bool] assign_ipv6_address_on_creation: Specify true to indicate
               that network interfaces created in the specified subnet should be
               assigned an IPv6 address. Default is `false`
        :param pulumi.Input[str] availability_zone: AZ for the subnet.
        :param pulumi.Input[str] availability_zone_id: AZ ID of the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
        :param pulumi.Input[str] cidr_block: The IPv4 CIDR block for the subnet.
        :param pulumi.Input[str] customer_owned_ipv4_pool: The customer owned IPv4 address pool. Typically used with the `map_customer_owned_ip_on_launch` argument. The `outpost_arn` argument must be specified when configured.
        :param pulumi.Input[bool] enable_dns64: Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. Default: `false`.
        :param pulumi.Input[bool] enable_resource_name_dns_a_record_on_launch: Indicates whether to respond to DNS queries for instance hostnames with DNS A records. Default: `false`.
        :param pulumi.Input[bool] enable_resource_name_dns_aaaa_record_on_launch: Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records. Default: `false`.
        :param pulumi.Input[str] ipv6_cidr_block: The IPv6 network range for the subnet,
               in CIDR notation. The subnet size must use a /64 prefix length.
        :param pulumi.Input[str] ipv6_cidr_block_association_id: The association ID for the IPv6 CIDR block.
        :param pulumi.Input[bool] ipv6_native: Indicates whether to create an IPv6-only subnet. Default: `false`.
        :param pulumi.Input[bool] map_customer_owned_ip_on_launch: Specify `true` to indicate that network interfaces created in the subnet should be assigned a customer owned IP address. The `customer_owned_ipv4_pool` and `outpost_arn` arguments must be specified when set to `true`. Default is `false`.
        :param pulumi.Input[bool] map_public_ip_on_launch: Specify true to indicate
               that instances launched into the subnet should be assigned
               a public IP address. Default is `false`.
        :param pulumi.Input[str] outpost_arn: The Amazon Resource Name (ARN) of the Outpost.
        :param pulumi.Input[str] owner_id: The ID of the AWS account that owns the subnet.
        :param pulumi.Input[str] private_dns_hostname_type_on_launch: The type of hostnames to assign to instances in the subnet at launch. For IPv6-only subnets, an instance DNS name must be based on the instance ID. For dual-stack and IPv4-only subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name`, `resource-name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[str] vpc_id: The VPC ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetState.__new__(_SubnetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["assign_ipv6_address_on_creation"] = assign_ipv6_address_on_creation
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["availability_zone_id"] = availability_zone_id
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["customer_owned_ipv4_pool"] = customer_owned_ipv4_pool
        __props__.__dict__["enable_dns64"] = enable_dns64
        __props__.__dict__["enable_resource_name_dns_a_record_on_launch"] = enable_resource_name_dns_a_record_on_launch
        __props__.__dict__["enable_resource_name_dns_aaaa_record_on_launch"] = enable_resource_name_dns_aaaa_record_on_launch
        __props__.__dict__["ipv6_cidr_block"] = ipv6_cidr_block
        __props__.__dict__["ipv6_cidr_block_association_id"] = ipv6_cidr_block_association_id
        __props__.__dict__["ipv6_native"] = ipv6_native
        __props__.__dict__["map_customer_owned_ip_on_launch"] = map_customer_owned_ip_on_launch
        __props__.__dict__["map_public_ip_on_launch"] = map_public_ip_on_launch
        __props__.__dict__["outpost_arn"] = outpost_arn
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["private_dns_hostname_type_on_launch"] = private_dns_hostname_type_on_launch
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_id"] = vpc_id
        return Subnet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the subnet.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assignIpv6AddressOnCreation")
    def assign_ipv6_address_on_creation(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify true to indicate
        that network interfaces created in the specified subnet should be
        assigned an IPv6 address. Default is `false`
        """
        return pulumi.get(self, "assign_ipv6_address_on_creation")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        AZ for the subnet.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> pulumi.Output[str]:
        """
        AZ ID of the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
        """
        return pulumi.get(self, "availability_zone_id")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv4 CIDR block for the subnet.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> pulumi.Output[Optional[str]]:
        """
        The customer owned IPv4 address pool. Typically used with the `map_customer_owned_ip_on_launch` argument. The `outpost_arn` argument must be specified when configured.
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @property
    @pulumi.getter(name="enableDns64")
    def enable_dns64(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. Default: `false`.
        """
        return pulumi.get(self, "enable_dns64")

    @property
    @pulumi.getter(name="enableResourceNameDnsARecordOnLaunch")
    def enable_resource_name_dns_a_record_on_launch(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to respond to DNS queries for instance hostnames with DNS A records. Default: `false`.
        """
        return pulumi.get(self, "enable_resource_name_dns_a_record_on_launch")

    @property
    @pulumi.getter(name="enableResourceNameDnsAaaaRecordOnLaunch")
    def enable_resource_name_dns_aaaa_record_on_launch(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records. Default: `false`.
        """
        return pulumi.get(self, "enable_resource_name_dns_aaaa_record_on_launch")

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv6 network range for the subnet,
        in CIDR notation. The subnet size must use a /64 prefix length.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @property
    @pulumi.getter(name="ipv6CidrBlockAssociationId")
    def ipv6_cidr_block_association_id(self) -> pulumi.Output[str]:
        """
        The association ID for the IPv6 CIDR block.
        """
        return pulumi.get(self, "ipv6_cidr_block_association_id")

    @property
    @pulumi.getter(name="ipv6Native")
    def ipv6_native(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to create an IPv6-only subnet. Default: `false`.
        """
        return pulumi.get(self, "ipv6_native")

    @property
    @pulumi.getter(name="mapCustomerOwnedIpOnLaunch")
    def map_customer_owned_ip_on_launch(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify `true` to indicate that network interfaces created in the subnet should be assigned a customer owned IP address. The `customer_owned_ipv4_pool` and `outpost_arn` arguments must be specified when set to `true`. Default is `false`.
        """
        return pulumi.get(self, "map_customer_owned_ip_on_launch")

    @property
    @pulumi.getter(name="mapPublicIpOnLaunch")
    def map_public_ip_on_launch(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify true to indicate
        that instances launched into the subnet should be assigned
        a public IP address. Default is `false`.
        """
        return pulumi.get(self, "map_public_ip_on_launch")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the Outpost.
        """
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        The ID of the AWS account that owns the subnet.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="privateDnsHostnameTypeOnLaunch")
    def private_dns_hostname_type_on_launch(self) -> pulumi.Output[str]:
        """
        The type of hostnames to assign to instances in the subnet at launch. For IPv6-only subnets, an instance DNS name must be based on the instance ID. For dual-stack and IPv4-only subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name`, `resource-name`.
        """
        return pulumi.get(self, "private_dns_hostname_type_on_launch")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

