# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 ami: Optional[pulumi.Input[str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 cpu_threads_per_core: Optional[pulumi.Input[int]] = None,
                 credit_specification: Optional[pulumi.Input['InstanceCreditSpecificationArgs']] = None,
                 disable_api_termination: Optional[pulumi.Input[bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 enclave_options: Optional[pulumi.Input['InstanceEnclaveOptionsArgs']] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]] = None,
                 get_password_data: Optional[pulumi.Input[bool]] = None,
                 hibernation: Optional[pulumi.Input[bool]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input['InstanceLaunchTemplateArgs']] = None,
                 metadata_options: Optional[pulumi.Input['InstanceMetadataOptionsArgs']] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 placement_partition_number: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 root_block_device: Optional[pulumi.Input['InstanceRootBlockDeviceArgs']] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenancy: Optional[pulumi.Input[Union[str, 'Tenancy']]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_data_base64: Optional[pulumi.Input[str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[str] availability_zone: AZ to start the instance in.
        :param pulumi.Input['InstanceCapacityReservationSpecificationArgs'] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[int] cpu_core_count: Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
        :param pulumi.Input[int] cpu_threads_per_core: If set to to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
        :param pulumi.Input['InstanceCreditSpecificationArgs'] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. the provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input['InstanceEnclaveOptionsArgs'] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_type: The instance type to use for the instance. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[int] ipv6_address_count: A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input['InstanceLaunchTemplateArgs'] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template.
               See Launch Template Specification below for more details.
        :param pulumi.Input['InstanceMetadataOptionsArgs'] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[int] placement_partition_number: The number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input['InstanceRootBlockDeviceArgs'] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_private_ips: A list of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of security group names to associate with.
        :param pulumi.Input[bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union[str, 'Tenancy']] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware. The host tenancy is not supported for the import-instance command.
        :param pulumi.Input[str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] volume_tags: A map of tags to assign, at instance-creation time, to root and EBS volumes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of security group IDs to associate with.
        """
        if ami is not None:
            pulumi.set(__self__, "ami", ami)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if capacity_reservation_specification is not None:
            pulumi.set(__self__, "capacity_reservation_specification", capacity_reservation_specification)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if cpu_threads_per_core is not None:
            pulumi.set(__self__, "cpu_threads_per_core", cpu_threads_per_core)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if disable_api_termination is not None:
            pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if enclave_options is not None:
            pulumi.set(__self__, "enclave_options", enclave_options)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if get_password_data is not None:
            pulumi.set(__self__, "get_password_data", get_password_data)
        if hibernation is not None:
            pulumi.set(__self__, "hibernation", hibernation)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if instance_initiated_shutdown_behavior is not None:
            pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if placement_partition_number is not None:
            pulumi.set(__self__, "placement_partition_number", placement_partition_number)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if root_block_device is not None:
            pulumi.set(__self__, "root_block_device", root_block_device)
        if secondary_private_ips is not None:
            pulumi.set(__self__, "secondary_private_ips", secondary_private_ips)
        if security_groups is not None:
            warnings.warn("""Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""", DeprecationWarning)
            pulumi.log.warn("""security_groups is deprecated: Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""")
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_data_base64 is not None:
            pulumi.set(__self__, "user_data_base64", user_data_base64)
        if volume_tags is not None:
            pulumi.set(__self__, "volume_tags", volume_tags)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter
    def ami(self) -> Optional[pulumi.Input[str]]:
        """
        AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        """
        return pulumi.get(self, "ami")

    @ami.setter
    def ami(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami", value)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to associate a public IP address with an instance in a VPC.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        AZ to start the instance in.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']]:
        """
        Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @capacity_reservation_specification.setter
    def capacity_reservation_specification(self, value: Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']]):
        pulumi.set(self, "capacity_reservation_specification", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="cpuThreadsPerCore")
    def cpu_threads_per_core(self) -> Optional[pulumi.Input[int]]:
        """
        If set to to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
        """
        return pulumi.get(self, "cpu_threads_per_core")

    @cpu_threads_per_core.setter
    def cpu_threads_per_core(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_threads_per_core", value)

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input['InstanceCreditSpecificationArgs']]:
        """
        Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. the provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input['InstanceCreditSpecificationArgs']]):
        pulumi.set(self, "credit_specification", value)

    @property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        """
        return pulumi.get(self, "disable_api_termination")

    @disable_api_termination.setter
    def disable_api_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_api_termination", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]:
        """
        One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> Optional[pulumi.Input['InstanceEnclaveOptionsArgs']]:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @enclave_options.setter
    def enclave_options(self, value: Optional[pulumi.Input['InstanceEnclaveOptionsArgs']]):
        pulumi.set(self, "enclave_options", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]:
        """
        One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter(name="getPasswordData")
    def get_password_data(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "get_password_data")

    @get_password_data.setter
    def get_password_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "get_password_data", value)

    @property
    @pulumi.getter
    def hibernation(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the launched EC2 instance will support hibernation.
        """
        return pulumi.get(self, "hibernation")

    @hibernation.setter
    def hibernation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hibernation", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @instance_initiated_shutdown_behavior.setter
    def instance_initiated_shutdown_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_initiated_shutdown_behavior", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[Union[str, 'InstanceType']]]:
        """
        The instance type to use for the instance. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[Union[str, 'InstanceType']]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['InstanceLaunchTemplateArgs']]:
        """
        Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template.
        See Launch Template Specification below for more details.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['InstanceLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['InstanceMetadataOptionsArgs']]:
        """
        Customize the metadata options of the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['InstanceMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]:
        """
        Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[str]]:
        """
        Placement Group to start the instance in.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="placementPartitionNumber")
    def placement_partition_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        """
        return pulumi.get(self, "placement_partition_number")

    @placement_partition_number.setter
    def placement_partition_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "placement_partition_number", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP address to associate with the instance in a VPC.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="rootBlockDevice")
    def root_block_device(self) -> Optional[pulumi.Input['InstanceRootBlockDeviceArgs']]:
        """
        Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        """
        return pulumi.get(self, "root_block_device")

    @root_block_device.setter
    def root_block_device(self, value: Optional[pulumi.Input['InstanceRootBlockDeviceArgs']]):
        pulumi.set(self, "root_block_device", value)

    @property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        """
        return pulumi.get(self, "secondary_private_ips")

    @secondary_private_ips.setter
    def secondary_private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secondary_private_ips", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group names to associate with.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "source_dest_check", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC Subnet ID to launch in.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[Union[str, 'Tenancy']]]:
        """
        Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware. The host tenancy is not supported for the import-instance command.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[Union[str, 'Tenancy']]]):
        pulumi.set(self, "tenancy", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> Optional[pulumi.Input[str]]:
        """
        Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "user_data_base64")

    @user_data_base64.setter
    def user_data_base64(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data_base64", value)

    @property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign, at instance-creation time, to root and EBS volumes.
        """
        return pulumi.get(self, "volume_tags")

    @volume_tags.setter
    def volume_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "volume_tags", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group IDs to associate with.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 ami: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 cpu_threads_per_core: Optional[pulumi.Input[int]] = None,
                 credit_specification: Optional[pulumi.Input['InstanceCreditSpecificationArgs']] = None,
                 disable_api_termination: Optional[pulumi.Input[bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 enclave_options: Optional[pulumi.Input['InstanceEnclaveOptionsArgs']] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]] = None,
                 get_password_data: Optional[pulumi.Input[bool]] = None,
                 hibernation: Optional[pulumi.Input[bool]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[str]] = None,
                 instance_state: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input['InstanceLaunchTemplateArgs']] = None,
                 metadata_options: Optional[pulumi.Input['InstanceMetadataOptionsArgs']] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]] = None,
                 outpost_arn: Optional[pulumi.Input[str]] = None,
                 password_data: Optional[pulumi.Input[str]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 placement_partition_number: Optional[pulumi.Input[int]] = None,
                 primary_network_interface_id: Optional[pulumi.Input[str]] = None,
                 private_dns: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 public_dns: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 root_block_device: Optional[pulumi.Input['InstanceRootBlockDeviceArgs']] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenancy: Optional[pulumi.Input[Union[str, 'Tenancy']]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_data_base64: Optional[pulumi.Input[str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[str] arn: The ARN of the instance.
        :param pulumi.Input[bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[str] availability_zone: AZ to start the instance in.
        :param pulumi.Input['InstanceCapacityReservationSpecificationArgs'] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[int] cpu_core_count: Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
        :param pulumi.Input[int] cpu_threads_per_core: If set to to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
        :param pulumi.Input['InstanceCreditSpecificationArgs'] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. the provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input['InstanceEnclaveOptionsArgs'] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[str] instance_state: The state of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_type: The instance type to use for the instance. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[int] ipv6_address_count: A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input['InstanceLaunchTemplateArgs'] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template.
               See Launch Template Specification below for more details.
        :param pulumi.Input['InstanceMetadataOptionsArgs'] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[str] outpost_arn: The ARN of the Outpost the instance is assigned to.
        :param pulumi.Input[str] password_data: Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[int] placement_partition_number: The number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[str] primary_network_interface_id: The ID of the instance's primary network interface.
        :param pulumi.Input[str] private_dns: The private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[str] public_dns: The public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[str] public_ip: The public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip` as this field will change after the EIP is attached.
        :param pulumi.Input['InstanceRootBlockDeviceArgs'] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_private_ips: A list of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of security group names to associate with.
        :param pulumi.Input[bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider.
        :param pulumi.Input[Union[str, 'Tenancy']] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware. The host tenancy is not supported for the import-instance command.
        :param pulumi.Input[str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] volume_tags: A map of tags to assign, at instance-creation time, to root and EBS volumes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of security group IDs to associate with.
        """
        if ami is not None:
            pulumi.set(__self__, "ami", ami)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if capacity_reservation_specification is not None:
            pulumi.set(__self__, "capacity_reservation_specification", capacity_reservation_specification)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if cpu_threads_per_core is not None:
            pulumi.set(__self__, "cpu_threads_per_core", cpu_threads_per_core)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if disable_api_termination is not None:
            pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if enclave_options is not None:
            pulumi.set(__self__, "enclave_options", enclave_options)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if get_password_data is not None:
            pulumi.set(__self__, "get_password_data", get_password_data)
        if hibernation is not None:
            pulumi.set(__self__, "hibernation", hibernation)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if instance_initiated_shutdown_behavior is not None:
            pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_state is not None:
            pulumi.set(__self__, "instance_state", instance_state)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if password_data is not None:
            pulumi.set(__self__, "password_data", password_data)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if placement_partition_number is not None:
            pulumi.set(__self__, "placement_partition_number", placement_partition_number)
        if primary_network_interface_id is not None:
            pulumi.set(__self__, "primary_network_interface_id", primary_network_interface_id)
        if private_dns is not None:
            pulumi.set(__self__, "private_dns", private_dns)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_dns is not None:
            pulumi.set(__self__, "public_dns", public_dns)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if root_block_device is not None:
            pulumi.set(__self__, "root_block_device", root_block_device)
        if secondary_private_ips is not None:
            pulumi.set(__self__, "secondary_private_ips", secondary_private_ips)
        if security_groups is not None:
            warnings.warn("""Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""", DeprecationWarning)
            pulumi.log.warn("""security_groups is deprecated: Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""")
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_data_base64 is not None:
            pulumi.set(__self__, "user_data_base64", user_data_base64)
        if volume_tags is not None:
            pulumi.set(__self__, "volume_tags", volume_tags)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter
    def ami(self) -> Optional[pulumi.Input[str]]:
        """
        AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        """
        return pulumi.get(self, "ami")

    @ami.setter
    def ami(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the instance.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to associate a public IP address with an instance in a VPC.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        AZ to start the instance in.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']]:
        """
        Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @capacity_reservation_specification.setter
    def capacity_reservation_specification(self, value: Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']]):
        pulumi.set(self, "capacity_reservation_specification", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="cpuThreadsPerCore")
    def cpu_threads_per_core(self) -> Optional[pulumi.Input[int]]:
        """
        If set to to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
        """
        return pulumi.get(self, "cpu_threads_per_core")

    @cpu_threads_per_core.setter
    def cpu_threads_per_core(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_threads_per_core", value)

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input['InstanceCreditSpecificationArgs']]:
        """
        Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. the provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input['InstanceCreditSpecificationArgs']]):
        pulumi.set(self, "credit_specification", value)

    @property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        """
        return pulumi.get(self, "disable_api_termination")

    @disable_api_termination.setter
    def disable_api_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_api_termination", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]:
        """
        One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> Optional[pulumi.Input['InstanceEnclaveOptionsArgs']]:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @enclave_options.setter
    def enclave_options(self, value: Optional[pulumi.Input['InstanceEnclaveOptionsArgs']]):
        pulumi.set(self, "enclave_options", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]:
        """
        One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter(name="getPasswordData")
    def get_password_data(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "get_password_data")

    @get_password_data.setter
    def get_password_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "get_password_data", value)

    @property
    @pulumi.getter
    def hibernation(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the launched EC2 instance will support hibernation.
        """
        return pulumi.get(self, "hibernation")

    @hibernation.setter
    def hibernation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hibernation", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @instance_initiated_shutdown_behavior.setter
    def instance_initiated_shutdown_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_initiated_shutdown_behavior", value)

    @property
    @pulumi.getter(name="instanceState")
    def instance_state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
        """
        return pulumi.get(self, "instance_state")

    @instance_state.setter
    def instance_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_state", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[Union[str, 'InstanceType']]]:
        """
        The instance type to use for the instance. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[Union[str, 'InstanceType']]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['InstanceLaunchTemplateArgs']]:
        """
        Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template.
        See Launch Template Specification below for more details.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['InstanceLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['InstanceMetadataOptionsArgs']]:
        """
        Customize the metadata options of the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['InstanceMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]:
        """
        Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Outpost the instance is assigned to.
        """
        return pulumi.get(self, "outpost_arn")

    @outpost_arn.setter
    def outpost_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outpost_arn", value)

    @property
    @pulumi.getter(name="passwordData")
    def password_data(self) -> Optional[pulumi.Input[str]]:
        """
        Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "password_data")

    @password_data.setter
    def password_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_data", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[str]]:
        """
        Placement Group to start the instance in.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="placementPartitionNumber")
    def placement_partition_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        """
        return pulumi.get(self, "placement_partition_number")

    @placement_partition_number.setter
    def placement_partition_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "placement_partition_number", value)

    @property
    @pulumi.getter(name="primaryNetworkInterfaceId")
    def primary_network_interface_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance's primary network interface.
        """
        return pulumi.get(self, "primary_network_interface_id")

    @primary_network_interface_id.setter
    def primary_network_interface_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_network_interface_id", value)

    @property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> Optional[pulumi.Input[str]]:
        """
        The private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "private_dns")

    @private_dns.setter
    def private_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP address to associate with the instance in a VPC.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> Optional[pulumi.Input[str]]:
        """
        The public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "public_dns")

    @public_dns.setter
    def public_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_dns", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip` as this field will change after the EIP is attached.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="rootBlockDevice")
    def root_block_device(self) -> Optional[pulumi.Input['InstanceRootBlockDeviceArgs']]:
        """
        Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        """
        return pulumi.get(self, "root_block_device")

    @root_block_device.setter
    def root_block_device(self, value: Optional[pulumi.Input['InstanceRootBlockDeviceArgs']]):
        pulumi.set(self, "root_block_device", value)

    @property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        """
        return pulumi.get(self, "secondary_private_ips")

    @secondary_private_ips.setter
    def secondary_private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secondary_private_ips", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group names to associate with.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "source_dest_check", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC Subnet ID to launch in.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[Union[str, 'Tenancy']]]:
        """
        Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware. The host tenancy is not supported for the import-instance command.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[Union[str, 'Tenancy']]]):
        pulumi.set(self, "tenancy", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> Optional[pulumi.Input[str]]:
        """
        Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "user_data_base64")

    @user_data_base64.setter
    def user_data_base64(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data_base64", value)

    @property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign, at instance-creation time, to root and EBS volumes.
        """
        return pulumi.get(self, "volume_tags")

    @volume_tags.setter
    def volume_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "volume_tags", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group IDs to associate with.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami: Optional[pulumi.Input[str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input[pulumi.InputType['InstanceCapacityReservationSpecificationArgs']]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 cpu_threads_per_core: Optional[pulumi.Input[int]] = None,
                 credit_specification: Optional[pulumi.Input[pulumi.InputType['InstanceCreditSpecificationArgs']]] = None,
                 disable_api_termination: Optional[pulumi.Input[bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEbsBlockDeviceArgs']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 enclave_options: Optional[pulumi.Input[pulumi.InputType['InstanceEnclaveOptionsArgs']]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEphemeralBlockDeviceArgs']]]]] = None,
                 get_password_data: Optional[pulumi.Input[bool]] = None,
                 hibernation: Optional[pulumi.Input[bool]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input[pulumi.InputType['InstanceLaunchTemplateArgs']]] = None,
                 metadata_options: Optional[pulumi.Input[pulumi.InputType['InstanceMetadataOptionsArgs']]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkInterfaceArgs']]]]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 placement_partition_number: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 root_block_device: Optional[pulumi.Input[pulumi.InputType['InstanceRootBlockDeviceArgs']]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenancy: Optional[pulumi.Input[Union[str, 'Tenancy']]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_data_base64: Optional[pulumi.Input[str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides an EC2 instance resource. This allows instances to be created, updated, and deleted.

        ## Example Usage
        ### Basic Example Using AMI Lookup

        ```python
        import pulumi
        import pulumi_aws as aws

        ubuntu = aws.ec2.get_ami(most_recent=True,
            filters=[
                aws.ec2.GetAmiFilterArgs(
                    name="name",
                    values=["ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-*"],
                ),
                aws.ec2.GetAmiFilterArgs(
                    name="virtualization-type",
                    values=["hvm"],
                ),
            ],
            owners=["099720109477"])
        web = aws.ec2.Instance("web",
            ami=ubuntu.id,
            instance_type="t3.micro",
            tags={
                "Name": "HelloWorld",
            })
        ```
        ### Network and Credit Specification Example

        ```python
        import pulumi
        import pulumi_aws as aws

        my_vpc = aws.ec2.Vpc("myVpc",
            cidr_block="172.16.0.0/16",
            tags={
                "Name": "tf-example",
            })
        my_subnet = aws.ec2.Subnet("mySubnet",
            vpc_id=my_vpc.id,
            cidr_block="172.16.10.0/24",
            availability_zone="us-west-2a",
            tags={
                "Name": "tf-example",
            })
        foo_network_interface = aws.ec2.NetworkInterface("fooNetworkInterface",
            subnet_id=my_subnet.id,
            private_ips=["172.16.10.100"],
            tags={
                "Name": "primary_network_interface",
            })
        foo_instance = aws.ec2.Instance("fooInstance",
            ami="ami-005e54dee72cc1d00",
            instance_type="t2.micro",
            network_interfaces=[aws.ec2.InstanceNetworkInterfaceArgs(
                network_interface_id=foo_network_interface.id,
                device_index=0,
            )],
            credit_specification=aws.ec2.InstanceCreditSpecificationArgs(
                cpu_credits="unlimited",
            ))
        ```

        ## Import

        Instances can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:ec2/instance:Instance web i-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[str] availability_zone: AZ to start the instance in.
        :param pulumi.Input[pulumi.InputType['InstanceCapacityReservationSpecificationArgs']] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[int] cpu_core_count: Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
        :param pulumi.Input[int] cpu_threads_per_core: If set to to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
        :param pulumi.Input[pulumi.InputType['InstanceCreditSpecificationArgs']] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. the provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEbsBlockDeviceArgs']]]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[pulumi.InputType['InstanceEnclaveOptionsArgs']] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEphemeralBlockDeviceArgs']]]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_type: The instance type to use for the instance. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[int] ipv6_address_count: A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input[pulumi.InputType['InstanceLaunchTemplateArgs']] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template.
               See Launch Template Specification below for more details.
        :param pulumi.Input[pulumi.InputType['InstanceMetadataOptionsArgs']] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkInterfaceArgs']]]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[int] placement_partition_number: The number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[pulumi.InputType['InstanceRootBlockDeviceArgs']] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_private_ips: A list of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of security group names to associate with.
        :param pulumi.Input[bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union[str, 'Tenancy']] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware. The host tenancy is not supported for the import-instance command.
        :param pulumi.Input[str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] volume_tags: A map of tags to assign, at instance-creation time, to root and EBS volumes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of security group IDs to associate with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EC2 instance resource. This allows instances to be created, updated, and deleted.

        ## Example Usage
        ### Basic Example Using AMI Lookup

        ```python
        import pulumi
        import pulumi_aws as aws

        ubuntu = aws.ec2.get_ami(most_recent=True,
            filters=[
                aws.ec2.GetAmiFilterArgs(
                    name="name",
                    values=["ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-*"],
                ),
                aws.ec2.GetAmiFilterArgs(
                    name="virtualization-type",
                    values=["hvm"],
                ),
            ],
            owners=["099720109477"])
        web = aws.ec2.Instance("web",
            ami=ubuntu.id,
            instance_type="t3.micro",
            tags={
                "Name": "HelloWorld",
            })
        ```
        ### Network and Credit Specification Example

        ```python
        import pulumi
        import pulumi_aws as aws

        my_vpc = aws.ec2.Vpc("myVpc",
            cidr_block="172.16.0.0/16",
            tags={
                "Name": "tf-example",
            })
        my_subnet = aws.ec2.Subnet("mySubnet",
            vpc_id=my_vpc.id,
            cidr_block="172.16.10.0/24",
            availability_zone="us-west-2a",
            tags={
                "Name": "tf-example",
            })
        foo_network_interface = aws.ec2.NetworkInterface("fooNetworkInterface",
            subnet_id=my_subnet.id,
            private_ips=["172.16.10.100"],
            tags={
                "Name": "primary_network_interface",
            })
        foo_instance = aws.ec2.Instance("fooInstance",
            ami="ami-005e54dee72cc1d00",
            instance_type="t2.micro",
            network_interfaces=[aws.ec2.InstanceNetworkInterfaceArgs(
                network_interface_id=foo_network_interface.id,
                device_index=0,
            )],
            credit_specification=aws.ec2.InstanceCreditSpecificationArgs(
                cpu_credits="unlimited",
            ))
        ```

        ## Import

        Instances can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:ec2/instance:Instance web i-12345678
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami: Optional[pulumi.Input[str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input[pulumi.InputType['InstanceCapacityReservationSpecificationArgs']]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 cpu_threads_per_core: Optional[pulumi.Input[int]] = None,
                 credit_specification: Optional[pulumi.Input[pulumi.InputType['InstanceCreditSpecificationArgs']]] = None,
                 disable_api_termination: Optional[pulumi.Input[bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEbsBlockDeviceArgs']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 enclave_options: Optional[pulumi.Input[pulumi.InputType['InstanceEnclaveOptionsArgs']]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEphemeralBlockDeviceArgs']]]]] = None,
                 get_password_data: Optional[pulumi.Input[bool]] = None,
                 hibernation: Optional[pulumi.Input[bool]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input[pulumi.InputType['InstanceLaunchTemplateArgs']]] = None,
                 metadata_options: Optional[pulumi.Input[pulumi.InputType['InstanceMetadataOptionsArgs']]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkInterfaceArgs']]]]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 placement_partition_number: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 root_block_device: Optional[pulumi.Input[pulumi.InputType['InstanceRootBlockDeviceArgs']]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenancy: Optional[pulumi.Input[Union[str, 'Tenancy']]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_data_base64: Optional[pulumi.Input[str]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["ami"] = ami
            __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["capacity_reservation_specification"] = capacity_reservation_specification
            __props__.__dict__["cpu_core_count"] = cpu_core_count
            __props__.__dict__["cpu_threads_per_core"] = cpu_threads_per_core
            __props__.__dict__["credit_specification"] = credit_specification
            __props__.__dict__["disable_api_termination"] = disable_api_termination
            __props__.__dict__["ebs_block_devices"] = ebs_block_devices
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["enclave_options"] = enclave_options
            __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
            __props__.__dict__["get_password_data"] = get_password_data
            __props__.__dict__["hibernation"] = hibernation
            __props__.__dict__["host_id"] = host_id
            __props__.__dict__["iam_instance_profile"] = iam_instance_profile
            __props__.__dict__["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["ipv6_addresses"] = ipv6_addresses
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["launch_template"] = launch_template
            __props__.__dict__["metadata_options"] = metadata_options
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["placement_group"] = placement_group
            __props__.__dict__["placement_partition_number"] = placement_partition_number
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["root_block_device"] = root_block_device
            __props__.__dict__["secondary_private_ips"] = secondary_private_ips
            if security_groups is not None and not opts.urn:
                warnings.warn("""Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""", DeprecationWarning)
                pulumi.log.warn("""security_groups is deprecated: Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""")
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["source_dest_check"] = source_dest_check
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenancy"] = tenancy
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["user_data_base64"] = user_data_base64
            __props__.__dict__["volume_tags"] = volume_tags
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["arn"] = None
            __props__.__dict__["instance_state"] = None
            __props__.__dict__["outpost_arn"] = None
            __props__.__dict__["password_data"] = None
            __props__.__dict__["primary_network_interface_id"] = None
            __props__.__dict__["private_dns"] = None
            __props__.__dict__["public_dns"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["tags_all"] = None
        super(Instance, __self__).__init__(
            'aws:ec2/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ami: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            capacity_reservation_specification: Optional[pulumi.Input[pulumi.InputType['InstanceCapacityReservationSpecificationArgs']]] = None,
            cpu_core_count: Optional[pulumi.Input[int]] = None,
            cpu_threads_per_core: Optional[pulumi.Input[int]] = None,
            credit_specification: Optional[pulumi.Input[pulumi.InputType['InstanceCreditSpecificationArgs']]] = None,
            disable_api_termination: Optional[pulumi.Input[bool]] = None,
            ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEbsBlockDeviceArgs']]]]] = None,
            ebs_optimized: Optional[pulumi.Input[bool]] = None,
            enclave_options: Optional[pulumi.Input[pulumi.InputType['InstanceEnclaveOptionsArgs']]] = None,
            ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEphemeralBlockDeviceArgs']]]]] = None,
            get_password_data: Optional[pulumi.Input[bool]] = None,
            hibernation: Optional[pulumi.Input[bool]] = None,
            host_id: Optional[pulumi.Input[str]] = None,
            iam_instance_profile: Optional[pulumi.Input[str]] = None,
            instance_initiated_shutdown_behavior: Optional[pulumi.Input[str]] = None,
            instance_state: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
            ipv6_address_count: Optional[pulumi.Input[int]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            key_name: Optional[pulumi.Input[str]] = None,
            launch_template: Optional[pulumi.Input[pulumi.InputType['InstanceLaunchTemplateArgs']]] = None,
            metadata_options: Optional[pulumi.Input[pulumi.InputType['InstanceMetadataOptionsArgs']]] = None,
            monitoring: Optional[pulumi.Input[bool]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkInterfaceArgs']]]]] = None,
            outpost_arn: Optional[pulumi.Input[str]] = None,
            password_data: Optional[pulumi.Input[str]] = None,
            placement_group: Optional[pulumi.Input[str]] = None,
            placement_partition_number: Optional[pulumi.Input[int]] = None,
            primary_network_interface_id: Optional[pulumi.Input[str]] = None,
            private_dns: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            public_dns: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            root_block_device: Optional[pulumi.Input[pulumi.InputType['InstanceRootBlockDeviceArgs']]] = None,
            secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            source_dest_check: Optional[pulumi.Input[bool]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenancy: Optional[pulumi.Input[Union[str, 'Tenancy']]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            user_data_base64: Optional[pulumi.Input[str]] = None,
            volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[str] arn: The ARN of the instance.
        :param pulumi.Input[bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[str] availability_zone: AZ to start the instance in.
        :param pulumi.Input[pulumi.InputType['InstanceCapacityReservationSpecificationArgs']] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[int] cpu_core_count: Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
        :param pulumi.Input[int] cpu_threads_per_core: If set to to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
        :param pulumi.Input[pulumi.InputType['InstanceCreditSpecificationArgs']] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. the provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEbsBlockDeviceArgs']]]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[pulumi.InputType['InstanceEnclaveOptionsArgs']] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEphemeralBlockDeviceArgs']]]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[str] instance_state: The state of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_type: The instance type to use for the instance. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[int] ipv6_address_count: A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input[pulumi.InputType['InstanceLaunchTemplateArgs']] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template.
               See Launch Template Specification below for more details.
        :param pulumi.Input[pulumi.InputType['InstanceMetadataOptionsArgs']] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkInterfaceArgs']]]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[str] outpost_arn: The ARN of the Outpost the instance is assigned to.
        :param pulumi.Input[str] password_data: Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[int] placement_partition_number: The number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[str] primary_network_interface_id: The ID of the instance's primary network interface.
        :param pulumi.Input[str] private_dns: The private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[str] public_dns: The public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[str] public_ip: The public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip` as this field will change after the EIP is attached.
        :param pulumi.Input[pulumi.InputType['InstanceRootBlockDeviceArgs']] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_private_ips: A list of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of security group names to associate with.
        :param pulumi.Input[bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider.
        :param pulumi.Input[Union[str, 'Tenancy']] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware. The host tenancy is not supported for the import-instance command.
        :param pulumi.Input[str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] volume_tags: A map of tags to assign, at instance-creation time, to root and EBS volumes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of security group IDs to associate with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["ami"] = ami
        __props__.__dict__["arn"] = arn
        __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["capacity_reservation_specification"] = capacity_reservation_specification
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["cpu_threads_per_core"] = cpu_threads_per_core
        __props__.__dict__["credit_specification"] = credit_specification
        __props__.__dict__["disable_api_termination"] = disable_api_termination
        __props__.__dict__["ebs_block_devices"] = ebs_block_devices
        __props__.__dict__["ebs_optimized"] = ebs_optimized
        __props__.__dict__["enclave_options"] = enclave_options
        __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
        __props__.__dict__["get_password_data"] = get_password_data
        __props__.__dict__["hibernation"] = hibernation
        __props__.__dict__["host_id"] = host_id
        __props__.__dict__["iam_instance_profile"] = iam_instance_profile
        __props__.__dict__["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
        __props__.__dict__["instance_state"] = instance_state
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ipv6_address_count"] = ipv6_address_count
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["launch_template"] = launch_template
        __props__.__dict__["metadata_options"] = metadata_options
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["outpost_arn"] = outpost_arn
        __props__.__dict__["password_data"] = password_data
        __props__.__dict__["placement_group"] = placement_group
        __props__.__dict__["placement_partition_number"] = placement_partition_number
        __props__.__dict__["primary_network_interface_id"] = primary_network_interface_id
        __props__.__dict__["private_dns"] = private_dns
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_dns"] = public_dns
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["root_block_device"] = root_block_device
        __props__.__dict__["secondary_private_ips"] = secondary_private_ips
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["source_dest_check"] = source_dest_check
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tenancy"] = tenancy
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["user_data_base64"] = user_data_base64
        __props__.__dict__["volume_tags"] = volume_tags
        __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def ami(self) -> pulumi.Output[str]:
        """
        AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        """
        return pulumi.get(self, "ami")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the instance.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> pulumi.Output[bool]:
        """
        Whether to associate a public IP address with an instance in a VPC.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        AZ to start the instance in.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> pulumi.Output['outputs.InstanceCapacityReservationSpecification']:
        """
        Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[int]:
        """
        Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="cpuThreadsPerCore")
    def cpu_threads_per_core(self) -> pulumi.Output[int]:
        """
        If set to to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
        """
        return pulumi.get(self, "cpu_threads_per_core")

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> pulumi.Output[Optional['outputs.InstanceCreditSpecification']]:
        """
        Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. the provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        """
        return pulumi.get(self, "credit_specification")

    @property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> pulumi.Output[bool]:
        """
        If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        """
        return pulumi.get(self, "disable_api_termination")

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> pulumi.Output[Sequence['outputs.InstanceEbsBlockDevice']]:
        """
        One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ebs_block_devices")

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[bool]:
        """
        If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        """
        return pulumi.get(self, "ebs_optimized")

    @property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> pulumi.Output['outputs.InstanceEnclaveOptions']:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> pulumi.Output[Sequence['outputs.InstanceEphemeralBlockDevice']]:
        """
        One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @property
    @pulumi.getter(name="getPasswordData")
    def get_password_data(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "get_password_data")

    @property
    @pulumi.getter
    def hibernation(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the launched EC2 instance will support hibernation.
        """
        return pulumi.get(self, "hibernation")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[str]:
        """
        ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> pulumi.Output[Optional[str]]:
        """
        IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        """
        return pulumi.get(self, "iam_instance_profile")

    @property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> pulumi.Output[str]:
        """
        Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @property
    @pulumi.getter(name="instanceState")
    def instance_state(self) -> pulumi.Output[str]:
        """
        The state of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
        """
        return pulumi.get(self, "instance_state")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The instance type to use for the instance. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[int]:
        """
        A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[str]:
        """
        Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output[Optional['outputs.InstanceLaunchTemplate']]:
        """
        Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template.
        See Launch Template Specification below for more details.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> pulumi.Output['outputs.InstanceMetadataOptions']:
        """
        Customize the metadata options of the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[bool]:
        """
        If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.InstanceNetworkInterface']]:
        """
        Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the Outpost the instance is assigned to.
        """
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter(name="passwordData")
    def password_data(self) -> pulumi.Output[str]:
        """
        Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "password_data")

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> pulumi.Output[str]:
        """
        Placement Group to start the instance in.
        """
        return pulumi.get(self, "placement_group")

    @property
    @pulumi.getter(name="placementPartitionNumber")
    def placement_partition_number(self) -> pulumi.Output[int]:
        """
        The number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        """
        return pulumi.get(self, "placement_partition_number")

    @property
    @pulumi.getter(name="primaryNetworkInterfaceId")
    def primary_network_interface_id(self) -> pulumi.Output[str]:
        """
        The ID of the instance's primary network interface.
        """
        return pulumi.get(self, "primary_network_interface_id")

    @property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> pulumi.Output[str]:
        """
        The private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "private_dns")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        Private IP address to associate with the instance in a VPC.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> pulumi.Output[str]:
        """
        The public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "public_dns")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        The public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip` as this field will change after the EIP is attached.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="rootBlockDevice")
    def root_block_device(self) -> pulumi.Output['outputs.InstanceRootBlockDevice']:
        """
        Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        """
        return pulumi.get(self, "root_block_device")

    @property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        """
        return pulumi.get(self, "secondary_private_ips")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of security group names to associate with.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> pulumi.Output[Optional[bool]]:
        """
        Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        """
        return pulumi.get(self, "source_dest_check")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        VPC Subnet ID to launch in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def tenancy(self) -> pulumi.Output[str]:
        """
        Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware. The host tenancy is not supported for the import-instance command.
        """
        return pulumi.get(self, "tenancy")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[str]:
        """
        User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> pulumi.Output[str]:
        """
        Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "user_data_base64")

    @property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign, at instance-creation time, to root and EBS volumes.
        """
        return pulumi.get(self, "volume_tags")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of security group IDs to associate with.
        """
        return pulumi.get(self, "vpc_security_group_ids")

