# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedPrefixListResult',
    'AwaitableGetManagedPrefixListResult',
    'get_managed_prefix_list',
    'get_managed_prefix_list_output',
]

@pulumi.output_type
class GetManagedPrefixListResult:
    """
    A collection of values returned by getManagedPrefixList.
    """
    def __init__(__self__, address_family=None, arn=None, entries=None, filters=None, id=None, max_entries=None, name=None, owner_id=None, tags=None, version=None):
        if address_family and not isinstance(address_family, str):
            raise TypeError("Expected argument 'address_family' to be a str")
        pulumi.set(__self__, "address_family", address_family)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_entries and not isinstance(max_entries, int):
            raise TypeError("Expected argument 'max_entries' to be a int")
        pulumi.set(__self__, "max_entries", max_entries)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> str:
        """
        The address family of the prefix list. Valid values are `IPv4` and `IPv6`.
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the selected prefix list.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetManagedPrefixListEntryResult']:
        """
        The set of entries in this prefix list. Each entry is an object with `cidr` and `description`.
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedPrefixListFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the selected prefix list.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxEntries")
    def max_entries(self) -> int:
        """
        When then prefix list is managed, the maximum number of entries it supports, or null otherwise.
        """
        return pulumi.get(self, "max_entries")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the selected prefix list.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> str:
        """
        The Account ID of the owner of a customer-managed prefix list, or `AWS` otherwise.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        A map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> int:
        return pulumi.get(self, "version")


class AwaitableGetManagedPrefixListResult(GetManagedPrefixListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedPrefixListResult(
            address_family=self.address_family,
            arn=self.arn,
            entries=self.entries,
            filters=self.filters,
            id=self.id,
            max_entries=self.max_entries,
            name=self.name,
            owner_id=self.owner_id,
            tags=self.tags,
            version=self.version)


def get_managed_prefix_list(filters: Optional[Sequence[pulumi.InputType['GetManagedPrefixListFilterArgs']]] = None,
                            id: Optional[str] = None,
                            name: Optional[str] = None,
                            tags: Optional[Mapping[str, str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedPrefixListResult:
    """
    `ec2.ManagedPrefixList` provides details about a specific AWS prefix list or
    customer-managed prefix list in the current region.

    ## Example Usage
    ### Find the regional DynamoDB prefix list

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.get_region()
    example = aws.ec2.get_managed_prefix_list(name=f"com.amazonaws.{current.name}.dynamodb")
    ```
    ### Find a managed prefix list using filters

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_managed_prefix_list(filters=[aws.ec2.GetManagedPrefixListFilterArgs(
        name="prefix-list-name",
        values=["my-prefix-list"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetManagedPrefixListFilterArgs']] filters: Configuration block(s) for filtering. Detailed below.
    :param str id: The ID of the prefix list to select.
    :param str name: The name of the filter field. Valid values can be found in the EC2 [DescribeManagedPrefixLists](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeManagedPrefixLists.html) API Reference.
    :param Mapping[str, str] tags: A map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['tags'] = tags
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:ec2/getManagedPrefixList:getManagedPrefixList', __args__, opts=opts, typ=GetManagedPrefixListResult).value

    return AwaitableGetManagedPrefixListResult(
        address_family=__ret__.address_family,
        arn=__ret__.arn,
        entries=__ret__.entries,
        filters=__ret__.filters,
        id=__ret__.id,
        max_entries=__ret__.max_entries,
        name=__ret__.name,
        owner_id=__ret__.owner_id,
        tags=__ret__.tags,
        version=__ret__.version)


@_utilities.lift_output_func(get_managed_prefix_list)
def get_managed_prefix_list_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedPrefixListFilterArgs']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[str]]] = None,
                                   name: Optional[pulumi.Input[Optional[str]]] = None,
                                   tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedPrefixListResult]:
    """
    `ec2.ManagedPrefixList` provides details about a specific AWS prefix list or
    customer-managed prefix list in the current region.

    ## Example Usage
    ### Find the regional DynamoDB prefix list

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.get_region()
    example = aws.ec2.get_managed_prefix_list(name=f"com.amazonaws.{current.name}.dynamodb")
    ```
    ### Find a managed prefix list using filters

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_managed_prefix_list(filters=[aws.ec2.GetManagedPrefixListFilterArgs(
        name="prefix-list-name",
        values=["my-prefix-list"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetManagedPrefixListFilterArgs']] filters: Configuration block(s) for filtering. Detailed below.
    :param str id: The ID of the prefix list to select.
    :param str name: The name of the filter field. Valid values can be found in the EC2 [DescribeManagedPrefixLists](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeManagedPrefixLists.html) API Reference.
    :param Mapping[str, str] tags: A map of tags assigned to the resource.
    """
    ...
