# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKeyPairResult',
    'AwaitableGetKeyPairResult',
    'get_key_pair',
    'get_key_pair_output',
]

@pulumi.output_type
class GetKeyPairResult:
    """
    A collection of values returned by getKeyPair.
    """
    def __init__(__self__, arn=None, filters=None, fingerprint=None, id=None, key_name=None, key_pair_id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_name and not isinstance(key_name, str):
            raise TypeError("Expected argument 'key_name' to be a str")
        pulumi.set(__self__, "key_name", key_name)
        if key_pair_id and not isinstance(key_pair_id, str):
            raise TypeError("Expected argument 'key_pair_id' to be a str")
        pulumi.set(__self__, "key_pair_id", key_pair_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the Key Pair.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetKeyPairFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        The SHA-1 digest of the DER encoded private key.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> Optional[str]:
        return pulumi.get(self, "key_pair_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Any tags assigned to the Key Pair.
        """
        return pulumi.get(self, "tags")


class AwaitableGetKeyPairResult(GetKeyPairResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyPairResult(
            arn=self.arn,
            filters=self.filters,
            fingerprint=self.fingerprint,
            id=self.id,
            key_name=self.key_name,
            key_pair_id=self.key_pair_id,
            tags=self.tags)


def get_key_pair(filters: Optional[Sequence[pulumi.InputType['GetKeyPairFilterArgs']]] = None,
                 key_name: Optional[str] = None,
                 key_pair_id: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyPairResult:
    """
    Use this data source to get information about a specific EC2 Key Pair.

    ## Example Usage

    The following example shows how to get a EC2 Key Pair from its name.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_key_pair(key_name="test",
        filters=[aws.ec2.GetKeyPairFilterArgs(
            name="tag:Component",
            values=["web"],
        )])
    pulumi.export("fingerprint", example.fingerprint)
    pulumi.export("name", example.key_name)
    pulumi.export("id", example.id)
    ```


    :param Sequence[pulumi.InputType['GetKeyPairFilterArgs']] filters: Custom filter block as described below.
    :param str key_name: The Key Pair name.
    :param str key_pair_id: The Key Pair ID.
    :param Mapping[str, str] tags: Any tags assigned to the Key Pair.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['keyName'] = key_name
    __args__['keyPairId'] = key_pair_id
    __args__['tags'] = tags
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:ec2/getKeyPair:getKeyPair', __args__, opts=opts, typ=GetKeyPairResult).value

    return AwaitableGetKeyPairResult(
        arn=__ret__.arn,
        filters=__ret__.filters,
        fingerprint=__ret__.fingerprint,
        id=__ret__.id,
        key_name=__ret__.key_name,
        key_pair_id=__ret__.key_pair_id,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_key_pair)
def get_key_pair_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetKeyPairFilterArgs']]]]] = None,
                        key_name: Optional[pulumi.Input[Optional[str]]] = None,
                        key_pair_id: Optional[pulumi.Input[Optional[str]]] = None,
                        tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKeyPairResult]:
    """
    Use this data source to get information about a specific EC2 Key Pair.

    ## Example Usage

    The following example shows how to get a EC2 Key Pair from its name.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_key_pair(key_name="test",
        filters=[aws.ec2.GetKeyPairFilterArgs(
            name="tag:Component",
            values=["web"],
        )])
    pulumi.export("fingerprint", example.fingerprint)
    pulumi.export("name", example.key_name)
    pulumi.export("id", example.id)
    ```


    :param Sequence[pulumi.InputType['GetKeyPairFilterArgs']] filters: Custom filter block as described below.
    :param str key_name: The Key Pair name.
    :param str key_pair_id: The Key Pair ID.
    :param Mapping[str, str] tags: Any tags assigned to the Key Pair.
    """
    ...
