# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSnapshotIdsResult',
    'AwaitableGetSnapshotIdsResult',
    'get_snapshot_ids',
    'get_snapshot_ids_output',
]

@pulumi.output_type
class GetSnapshotIdsResult:
    """
    A collection of values returned by getSnapshotIds.
    """
    def __init__(__self__, filters=None, id=None, ids=None, owners=None, restorable_by_user_ids=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if owners and not isinstance(owners, list):
            raise TypeError("Expected argument 'owners' to be a list")
        pulumi.set(__self__, "owners", owners)
        if restorable_by_user_ids and not isinstance(restorable_by_user_ids, list):
            raise TypeError("Expected argument 'restorable_by_user_ids' to be a list")
        pulumi.set(__self__, "restorable_by_user_ids", restorable_by_user_ids)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSnapshotIdsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        Set of EBS snapshot IDs, sorted by creation time in descending order.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def owners(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "owners")

    @property
    @pulumi.getter(name="restorableByUserIds")
    def restorable_by_user_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "restorable_by_user_ids")


class AwaitableGetSnapshotIdsResult(GetSnapshotIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnapshotIdsResult(
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            owners=self.owners,
            restorable_by_user_ids=self.restorable_by_user_ids)


def get_snapshot_ids(filters: Optional[Sequence[pulumi.InputType['GetSnapshotIdsFilterArgs']]] = None,
                     owners: Optional[Sequence[str]] = None,
                     restorable_by_user_ids: Optional[Sequence[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnapshotIdsResult:
    """
    Use this data source to get a list of EBS Snapshot IDs matching the specified
    criteria.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    ebs_volumes = aws.ebs.get_snapshot_ids(filters=[
            aws.ebs.GetSnapshotIdsFilterArgs(
                name="volume-size",
                values=["40"],
            ),
            aws.ebs.GetSnapshotIdsFilterArgs(
                name="tag:Name",
                values=["Example"],
            ),
        ],
        owners=["self"])
    ```


    :param Sequence[pulumi.InputType['GetSnapshotIdsFilterArgs']] filters: One or more name/value pairs to filter off of. There are
           several valid keys, for a full reference, check out
           [describe-volumes in the AWS CLI reference][1].
    :param Sequence[str] owners: Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
    :param Sequence[str] restorable_by_user_ids: One or more AWS accounts IDs that can create volumes from the snapshot.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['owners'] = owners
    __args__['restorableByUserIds'] = restorable_by_user_ids
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:ebs/getSnapshotIds:getSnapshotIds', __args__, opts=opts, typ=GetSnapshotIdsResult).value

    return AwaitableGetSnapshotIdsResult(
        filters=__ret__.filters,
        id=__ret__.id,
        ids=__ret__.ids,
        owners=__ret__.owners,
        restorable_by_user_ids=__ret__.restorable_by_user_ids)


@_utilities.lift_output_func(get_snapshot_ids)
def get_snapshot_ids_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSnapshotIdsFilterArgs']]]]] = None,
                            owners: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            restorable_by_user_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSnapshotIdsResult]:
    """
    Use this data source to get a list of EBS Snapshot IDs matching the specified
    criteria.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    ebs_volumes = aws.ebs.get_snapshot_ids(filters=[
            aws.ebs.GetSnapshotIdsFilterArgs(
                name="volume-size",
                values=["40"],
            ),
            aws.ebs.GetSnapshotIdsFilterArgs(
                name="tag:Name",
                values=["Example"],
            ),
        ],
        owners=["self"])
    ```


    :param Sequence[pulumi.InputType['GetSnapshotIdsFilterArgs']] filters: One or more name/value pairs to filter off of. There are
           several valid keys, for a full reference, check out
           [describe-volumes in the AWS CLI reference][1].
    :param Sequence[str] owners: Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
    :param Sequence[str] restorable_by_user_ids: One or more AWS accounts IDs that can create volumes from the snapshot.
    """
    ...
