# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BotAssociationLexBot',
    'HoursOfOperationConfig',
    'HoursOfOperationConfigEndTime',
    'HoursOfOperationConfigStartTime',
    'QueueOutboundCallerConfig',
    'QuickConnectQuickConnectConfig',
    'QuickConnectQuickConnectConfigPhoneConfig',
    'QuickConnectQuickConnectConfigQueueConfig',
    'QuickConnectQuickConnectConfigUserConfig',
    'RoutingProfileMediaConcurrency',
    'RoutingProfileQueueConfig',
    'RoutingProfileQueueConfigsAssociated',
    'UserHierarchyStructureHierarchyStructure',
    'UserHierarchyStructureHierarchyStructureLevelFive',
    'UserHierarchyStructureHierarchyStructureLevelFour',
    'UserHierarchyStructureHierarchyStructureLevelOne',
    'UserHierarchyStructureHierarchyStructureLevelThree',
    'UserHierarchyStructureHierarchyStructureLevelTwo',
    'GetBotAssociationLexBotResult',
    'GetHoursOfOperationConfigResult',
    'GetHoursOfOperationConfigEndTimeResult',
    'GetHoursOfOperationConfigStartTimeResult',
    'GetQueueOutboundCallerConfigResult',
    'GetQuickConnectQuickConnectConfigResult',
    'GetQuickConnectQuickConnectConfigPhoneConfigResult',
    'GetQuickConnectQuickConnectConfigQueueConfigResult',
    'GetQuickConnectQuickConnectConfigUserConfigResult',
]

@pulumi.output_type
class BotAssociationLexBot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lexRegion":
            suggest = "lex_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAssociationLexBot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAssociationLexBot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAssociationLexBot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 lex_region: Optional[str] = None):
        """
        :param str name: The name of the Amazon Lex (V1) bot.
        :param str lex_region: The Region that the Amazon Lex (V1) bot was created in. Defaults to current region.
        """
        pulumi.set(__self__, "name", name)
        if lex_region is not None:
            pulumi.set(__self__, "lex_region", lex_region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Amazon Lex (V1) bot.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="lexRegion")
    def lex_region(self) -> Optional[str]:
        """
        The Region that the Amazon Lex (V1) bot was created in. Defaults to current region.
        """
        return pulumi.get(self, "lex_region")


@pulumi.output_type
class HoursOfOperationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoursOfOperationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoursOfOperationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoursOfOperationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: str,
                 end_time: 'outputs.HoursOfOperationConfigEndTime',
                 start_time: 'outputs.HoursOfOperationConfigStartTime'):
        """
        :param str day: Specifies the day that the hours of operation applies to.
        :param 'HoursOfOperationConfigEndTimeArgs' end_time: A end time block specifies the time that your contact center closes. The `end_time` is documented below.
        :param 'HoursOfOperationConfigStartTimeArgs' start_time: A start time block specifies the time that your contact center opens. The `start_time` is documented below.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        Specifies the day that the hours of operation applies to.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> 'outputs.HoursOfOperationConfigEndTime':
        """
        A end time block specifies the time that your contact center closes. The `end_time` is documented below.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.HoursOfOperationConfigStartTime':
        """
        A start time block specifies the time that your contact center opens. The `start_time` is documented below.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class HoursOfOperationConfigEndTime(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: int):
        """
        :param int hours: Specifies the hour of closing.
        :param int minutes: Specifies the minute of closing.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Specifies the hour of closing.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Specifies the minute of closing.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class HoursOfOperationConfigStartTime(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: int):
        """
        :param int hours: Specifies the hour of opening.
        :param int minutes: Specifies the minute of opening.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Specifies the hour of opening.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Specifies the minute of opening.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class QueueOutboundCallerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outboundCallerIdName":
            suggest = "outbound_caller_id_name"
        elif key == "outboundCallerIdNumberId":
            suggest = "outbound_caller_id_number_id"
        elif key == "outboundFlowId":
            suggest = "outbound_flow_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueueOutboundCallerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueueOutboundCallerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueueOutboundCallerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 outbound_caller_id_name: Optional[str] = None,
                 outbound_caller_id_number_id: Optional[str] = None,
                 outbound_flow_id: Optional[str] = None):
        """
        :param str outbound_caller_id_name: Specifies the caller ID name.
        :param str outbound_caller_id_number_id: Specifies the caller ID number.
        :param str outbound_flow_id: Specifies outbound whisper flow to be used during an outbound call.
        """
        if outbound_caller_id_name is not None:
            pulumi.set(__self__, "outbound_caller_id_name", outbound_caller_id_name)
        if outbound_caller_id_number_id is not None:
            pulumi.set(__self__, "outbound_caller_id_number_id", outbound_caller_id_number_id)
        if outbound_flow_id is not None:
            pulumi.set(__self__, "outbound_flow_id", outbound_flow_id)

    @property
    @pulumi.getter(name="outboundCallerIdName")
    def outbound_caller_id_name(self) -> Optional[str]:
        """
        Specifies the caller ID name.
        """
        return pulumi.get(self, "outbound_caller_id_name")

    @property
    @pulumi.getter(name="outboundCallerIdNumberId")
    def outbound_caller_id_number_id(self) -> Optional[str]:
        """
        Specifies the caller ID number.
        """
        return pulumi.get(self, "outbound_caller_id_number_id")

    @property
    @pulumi.getter(name="outboundFlowId")
    def outbound_flow_id(self) -> Optional[str]:
        """
        Specifies outbound whisper flow to be used during an outbound call.
        """
        return pulumi.get(self, "outbound_flow_id")


@pulumi.output_type
class QuickConnectQuickConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quickConnectType":
            suggest = "quick_connect_type"
        elif key == "phoneConfigs":
            suggest = "phone_configs"
        elif key == "queueConfigs":
            suggest = "queue_configs"
        elif key == "userConfigs":
            suggest = "user_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quick_connect_type: str,
                 phone_configs: Optional[Sequence['outputs.QuickConnectQuickConnectConfigPhoneConfig']] = None,
                 queue_configs: Optional[Sequence['outputs.QuickConnectQuickConnectConfigQueueConfig']] = None,
                 user_configs: Optional[Sequence['outputs.QuickConnectQuickConnectConfigUserConfig']] = None):
        """
        :param str quick_connect_type: Specifies the configuration type of the quick connect. valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
        :param Sequence['QuickConnectQuickConnectConfigPhoneConfigArgs'] phone_configs: Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
        :param Sequence['QuickConnectQuickConnectConfigQueueConfigArgs'] queue_configs: Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
        :param Sequence['QuickConnectQuickConnectConfigUserConfigArgs'] user_configs: Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
        """
        pulumi.set(__self__, "quick_connect_type", quick_connect_type)
        if phone_configs is not None:
            pulumi.set(__self__, "phone_configs", phone_configs)
        if queue_configs is not None:
            pulumi.set(__self__, "queue_configs", queue_configs)
        if user_configs is not None:
            pulumi.set(__self__, "user_configs", user_configs)

    @property
    @pulumi.getter(name="quickConnectType")
    def quick_connect_type(self) -> str:
        """
        Specifies the configuration type of the quick connect. valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
        """
        return pulumi.get(self, "quick_connect_type")

    @property
    @pulumi.getter(name="phoneConfigs")
    def phone_configs(self) -> Optional[Sequence['outputs.QuickConnectQuickConnectConfigPhoneConfig']]:
        """
        Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
        """
        return pulumi.get(self, "phone_configs")

    @property
    @pulumi.getter(name="queueConfigs")
    def queue_configs(self) -> Optional[Sequence['outputs.QuickConnectQuickConnectConfigQueueConfig']]:
        """
        Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
        """
        return pulumi.get(self, "queue_configs")

    @property
    @pulumi.getter(name="userConfigs")
    def user_configs(self) -> Optional[Sequence['outputs.QuickConnectQuickConnectConfigUserConfig']]:
        """
        Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
        """
        return pulumi.get(self, "user_configs")


@pulumi.output_type
class QuickConnectQuickConnectConfigPhoneConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQuickConnectConfigPhoneConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQuickConnectConfigPhoneConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQuickConnectConfigPhoneConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phone_number: str):
        """
        :param str phone_number: Specifies the phone number in in E.164 format.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        Specifies the phone number in in E.164 format.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class QuickConnectQuickConnectConfigQueueConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactFlowId":
            suggest = "contact_flow_id"
        elif key == "queueId":
            suggest = "queue_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQuickConnectConfigQueueConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQuickConnectConfigQueueConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQuickConnectConfigQueueConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_flow_id: str,
                 queue_id: str):
        """
        :param str contact_flow_id: Specifies the identifier of the contact flow.
        :param str queue_id: Specifies the identifier for the queue.
        """
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        pulumi.set(__self__, "queue_id", queue_id)

    @property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> str:
        """
        Specifies the identifier of the contact flow.
        """
        return pulumi.get(self, "contact_flow_id")

    @property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> str:
        """
        Specifies the identifier for the queue.
        """
        return pulumi.get(self, "queue_id")


@pulumi.output_type
class QuickConnectQuickConnectConfigUserConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactFlowId":
            suggest = "contact_flow_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQuickConnectConfigUserConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQuickConnectConfigUserConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQuickConnectConfigUserConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_flow_id: str,
                 user_id: str):
        """
        :param str contact_flow_id: Specifies the identifier of the contact flow.
        :param str user_id: Specifies the identifier for the user.
        """
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> str:
        """
        Specifies the identifier of the contact flow.
        """
        return pulumi.get(self, "contact_flow_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Specifies the identifier for the user.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class RoutingProfileMediaConcurrency(dict):
    def __init__(__self__, *,
                 channel: str,
                 concurrency: int):
        """
        :param str channel: Specifies the channels that agents can handle in the Contact Control Panel (CCP). Valid values are `VOICE`, `CHAT`, `TASK`.
        :param int concurrency: Specifies the number of contacts an agent can have on a channel simultaneously. Valid Range for `VOICE`: Minimum value of 1. Maximum value of 1. Valid Range for `CHAT`: Minimum value of 1. Maximum value of 10. Valid Range for `TASK`: Minimum value of 1. Maximum value of 10.
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "concurrency", concurrency)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        Specifies the channels that agents can handle in the Contact Control Panel (CCP). Valid values are `VOICE`, `CHAT`, `TASK`.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def concurrency(self) -> int:
        """
        Specifies the number of contacts an agent can have on a channel simultaneously. Valid Range for `VOICE`: Minimum value of 1. Maximum value of 1. Valid Range for `CHAT`: Minimum value of 1. Maximum value of 10. Valid Range for `TASK`: Minimum value of 1. Maximum value of 10.
        """
        return pulumi.get(self, "concurrency")


@pulumi.output_type
class RoutingProfileQueueConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueId":
            suggest = "queue_id"
        elif key == "queueArn":
            suggest = "queue_arn"
        elif key == "queueName":
            suggest = "queue_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingProfileQueueConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingProfileQueueConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingProfileQueueConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel: str,
                 delay: int,
                 priority: int,
                 queue_id: str,
                 queue_arn: Optional[str] = None,
                 queue_name: Optional[str] = None):
        """
        :param str channel: Specifies the channels agents can handle in the Contact Control Panel (CCP) for this routing profile. Valid values are `VOICE`, `CHAT`, `TASK`.
        :param int delay: Specifies the delay, in seconds, that a contact should be in the queue before they are routed to an available agent
        :param int priority: Specifies the order in which contacts are to be handled for the queue.
        :param str queue_id: Specifies the identifier for the queue.
        :param str queue_arn: Specifies the ARN for the queue.
        :param str queue_name: Specifies the name for the queue.
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "delay", delay)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "queue_id", queue_id)
        if queue_arn is not None:
            pulumi.set(__self__, "queue_arn", queue_arn)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        Specifies the channels agents can handle in the Contact Control Panel (CCP) for this routing profile. Valid values are `VOICE`, `CHAT`, `TASK`.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def delay(self) -> int:
        """
        Specifies the delay, in seconds, that a contact should be in the queue before they are routed to an available agent
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Specifies the order in which contacts are to be handled for the queue.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> str:
        """
        Specifies the identifier for the queue.
        """
        return pulumi.get(self, "queue_id")

    @property
    @pulumi.getter(name="queueArn")
    def queue_arn(self) -> Optional[str]:
        """
        Specifies the ARN for the queue.
        """
        return pulumi.get(self, "queue_arn")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        Specifies the name for the queue.
        """
        return pulumi.get(self, "queue_name")


@pulumi.output_type
class RoutingProfileQueueConfigsAssociated(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueArn":
            suggest = "queue_arn"
        elif key == "queueId":
            suggest = "queue_id"
        elif key == "queueName":
            suggest = "queue_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingProfileQueueConfigsAssociated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingProfileQueueConfigsAssociated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingProfileQueueConfigsAssociated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel: Optional[str] = None,
                 delay: Optional[int] = None,
                 priority: Optional[int] = None,
                 queue_arn: Optional[str] = None,
                 queue_id: Optional[str] = None,
                 queue_name: Optional[str] = None):
        """
        :param str channel: Specifies the channels that agents can handle in the Contact Control Panel (CCP). Valid values are `VOICE`, `CHAT`, `TASK`.
        :param int delay: Specifies the delay, in seconds, that a contact should be in the queue before they are routed to an available agent
        :param int priority: Specifies the order in which contacts are to be handled for the queue.
        :param str queue_arn: Specifies the ARN for the queue.
        :param str queue_id: Specifies the identifier for the queue.
        :param str queue_name: Specifies the name for the queue.
        """
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if queue_arn is not None:
            pulumi.set(__self__, "queue_arn", queue_arn)
        if queue_id is not None:
            pulumi.set(__self__, "queue_id", queue_id)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)

    @property
    @pulumi.getter
    def channel(self) -> Optional[str]:
        """
        Specifies the channels that agents can handle in the Contact Control Panel (CCP). Valid values are `VOICE`, `CHAT`, `TASK`.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def delay(self) -> Optional[int]:
        """
        Specifies the delay, in seconds, that a contact should be in the queue before they are routed to an available agent
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Specifies the order in which contacts are to be handled for the queue.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="queueArn")
    def queue_arn(self) -> Optional[str]:
        """
        Specifies the ARN for the queue.
        """
        return pulumi.get(self, "queue_arn")

    @property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> Optional[str]:
        """
        Specifies the identifier for the queue.
        """
        return pulumi.get(self, "queue_id")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        Specifies the name for the queue.
        """
        return pulumi.get(self, "queue_name")


@pulumi.output_type
class UserHierarchyStructureHierarchyStructure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "levelFive":
            suggest = "level_five"
        elif key == "levelFour":
            suggest = "level_four"
        elif key == "levelOne":
            suggest = "level_one"
        elif key == "levelThree":
            suggest = "level_three"
        elif key == "levelTwo":
            suggest = "level_two"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserHierarchyStructureHierarchyStructure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserHierarchyStructureHierarchyStructure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserHierarchyStructureHierarchyStructure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 level_five: Optional['outputs.UserHierarchyStructureHierarchyStructureLevelFive'] = None,
                 level_four: Optional['outputs.UserHierarchyStructureHierarchyStructureLevelFour'] = None,
                 level_one: Optional['outputs.UserHierarchyStructureHierarchyStructureLevelOne'] = None,
                 level_three: Optional['outputs.UserHierarchyStructureHierarchyStructureLevelThree'] = None,
                 level_two: Optional['outputs.UserHierarchyStructureHierarchyStructureLevelTwo'] = None):
        """
        :param 'UserHierarchyStructureHierarchyStructureLevelFiveArgs' level_five: A block that defines the details of level five. The level block is documented below.
        :param 'UserHierarchyStructureHierarchyStructureLevelFourArgs' level_four: A block that defines the details of level four. The level block is documented below.
        :param 'UserHierarchyStructureHierarchyStructureLevelOneArgs' level_one: A block that defines the details of level one. The level block is documented below.
        :param 'UserHierarchyStructureHierarchyStructureLevelThreeArgs' level_three: A block that defines the details of level three. The level block is documented below.
        :param 'UserHierarchyStructureHierarchyStructureLevelTwoArgs' level_two: A block that defines the details of level two. The level block is documented below.
        """
        if level_five is not None:
            pulumi.set(__self__, "level_five", level_five)
        if level_four is not None:
            pulumi.set(__self__, "level_four", level_four)
        if level_one is not None:
            pulumi.set(__self__, "level_one", level_one)
        if level_three is not None:
            pulumi.set(__self__, "level_three", level_three)
        if level_two is not None:
            pulumi.set(__self__, "level_two", level_two)

    @property
    @pulumi.getter(name="levelFive")
    def level_five(self) -> Optional['outputs.UserHierarchyStructureHierarchyStructureLevelFive']:
        """
        A block that defines the details of level five. The level block is documented below.
        """
        return pulumi.get(self, "level_five")

    @property
    @pulumi.getter(name="levelFour")
    def level_four(self) -> Optional['outputs.UserHierarchyStructureHierarchyStructureLevelFour']:
        """
        A block that defines the details of level four. The level block is documented below.
        """
        return pulumi.get(self, "level_four")

    @property
    @pulumi.getter(name="levelOne")
    def level_one(self) -> Optional['outputs.UserHierarchyStructureHierarchyStructureLevelOne']:
        """
        A block that defines the details of level one. The level block is documented below.
        """
        return pulumi.get(self, "level_one")

    @property
    @pulumi.getter(name="levelThree")
    def level_three(self) -> Optional['outputs.UserHierarchyStructureHierarchyStructureLevelThree']:
        """
        A block that defines the details of level three. The level block is documented below.
        """
        return pulumi.get(self, "level_three")

    @property
    @pulumi.getter(name="levelTwo")
    def level_two(self) -> Optional['outputs.UserHierarchyStructureHierarchyStructureLevelTwo']:
        """
        A block that defines the details of level two. The level block is documented below.
        """
        return pulumi.get(self, "level_two")


@pulumi.output_type
class UserHierarchyStructureHierarchyStructureLevelFive(dict):
    def __init__(__self__, *,
                 name: str,
                 arn: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: The name of the user hierarchy level. Must not be more than 50 characters.
        :param str arn: The Amazon Resource Name (ARN) of the hierarchy level.
        :param str id: The identifier of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user hierarchy level. Must not be more than 50 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The identifier of the hierarchy level.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class UserHierarchyStructureHierarchyStructureLevelFour(dict):
    def __init__(__self__, *,
                 name: str,
                 arn: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: The name of the user hierarchy level. Must not be more than 50 characters.
        :param str arn: The Amazon Resource Name (ARN) of the hierarchy level.
        :param str id: The identifier of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user hierarchy level. Must not be more than 50 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The identifier of the hierarchy level.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class UserHierarchyStructureHierarchyStructureLevelOne(dict):
    def __init__(__self__, *,
                 name: str,
                 arn: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: The name of the user hierarchy level. Must not be more than 50 characters.
        :param str arn: The Amazon Resource Name (ARN) of the hierarchy level.
        :param str id: The identifier of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user hierarchy level. Must not be more than 50 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The identifier of the hierarchy level.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class UserHierarchyStructureHierarchyStructureLevelThree(dict):
    def __init__(__self__, *,
                 name: str,
                 arn: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: The name of the user hierarchy level. Must not be more than 50 characters.
        :param str arn: The Amazon Resource Name (ARN) of the hierarchy level.
        :param str id: The identifier of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user hierarchy level. Must not be more than 50 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The identifier of the hierarchy level.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class UserHierarchyStructureHierarchyStructureLevelTwo(dict):
    def __init__(__self__, *,
                 name: str,
                 arn: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str name: The name of the user hierarchy level. Must not be more than 50 characters.
        :param str arn: The Amazon Resource Name (ARN) of the hierarchy level.
        :param str id: The identifier of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user hierarchy level. Must not be more than 50 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The identifier of the hierarchy level.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetBotAssociationLexBotResult(dict):
    def __init__(__self__, *,
                 lex_region: str,
                 name: str):
        """
        :param str lex_region: The Region that the Amazon Lex (V1) bot was created in.
        :param str name: The name of the Amazon Lex (V1) bot.
        """
        pulumi.set(__self__, "lex_region", lex_region)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="lexRegion")
    def lex_region(self) -> str:
        """
        The Region that the Amazon Lex (V1) bot was created in.
        """
        return pulumi.get(self, "lex_region")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Amazon Lex (V1) bot.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetHoursOfOperationConfigResult(dict):
    def __init__(__self__, *,
                 day: str,
                 end_times: Sequence['outputs.GetHoursOfOperationConfigEndTimeResult'],
                 start_times: Sequence['outputs.GetHoursOfOperationConfigStartTimeResult']):
        """
        :param str day: Specifies the day that the hours of operation applies to.
        :param Sequence['GetHoursOfOperationConfigEndTimeArgs'] end_times: A end time block specifies the time that your contact center closes. The `end_time` is documented below.
        :param Sequence['GetHoursOfOperationConfigStartTimeArgs'] start_times: A start time block specifies the time that your contact center opens. The `start_time` is documented below.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "end_times", end_times)
        pulumi.set(__self__, "start_times", start_times)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        Specifies the day that the hours of operation applies to.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="endTimes")
    def end_times(self) -> Sequence['outputs.GetHoursOfOperationConfigEndTimeResult']:
        """
        A end time block specifies the time that your contact center closes. The `end_time` is documented below.
        """
        return pulumi.get(self, "end_times")

    @property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.GetHoursOfOperationConfigStartTimeResult']:
        """
        A start time block specifies the time that your contact center opens. The `start_time` is documented below.
        """
        return pulumi.get(self, "start_times")


@pulumi.output_type
class GetHoursOfOperationConfigEndTimeResult(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: int):
        """
        :param int hours: Specifies the hour of opening.
        :param int minutes: Specifies the minute of opening.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Specifies the hour of opening.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Specifies the minute of opening.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class GetHoursOfOperationConfigStartTimeResult(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: int):
        """
        :param int hours: Specifies the hour of opening.
        :param int minutes: Specifies the minute of opening.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Specifies the hour of opening.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Specifies the minute of opening.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class GetQueueOutboundCallerConfigResult(dict):
    def __init__(__self__, *,
                 outbound_caller_id_name: str,
                 outbound_caller_id_number_id: str,
                 outbound_flow_id: str):
        """
        :param str outbound_caller_id_name: Specifies the caller ID name.
        :param str outbound_caller_id_number_id: Specifies the caller ID number.
        :param str outbound_flow_id: Specifies the outbound whisper flow to be used during an outbound call.
        """
        pulumi.set(__self__, "outbound_caller_id_name", outbound_caller_id_name)
        pulumi.set(__self__, "outbound_caller_id_number_id", outbound_caller_id_number_id)
        pulumi.set(__self__, "outbound_flow_id", outbound_flow_id)

    @property
    @pulumi.getter(name="outboundCallerIdName")
    def outbound_caller_id_name(self) -> str:
        """
        Specifies the caller ID name.
        """
        return pulumi.get(self, "outbound_caller_id_name")

    @property
    @pulumi.getter(name="outboundCallerIdNumberId")
    def outbound_caller_id_number_id(self) -> str:
        """
        Specifies the caller ID number.
        """
        return pulumi.get(self, "outbound_caller_id_number_id")

    @property
    @pulumi.getter(name="outboundFlowId")
    def outbound_flow_id(self) -> str:
        """
        Specifies the outbound whisper flow to be used during an outbound call.
        """
        return pulumi.get(self, "outbound_flow_id")


@pulumi.output_type
class GetQuickConnectQuickConnectConfigResult(dict):
    def __init__(__self__, *,
                 phone_configs: Sequence['outputs.GetQuickConnectQuickConnectConfigPhoneConfigResult'],
                 queue_configs: Sequence['outputs.GetQuickConnectQuickConnectConfigQueueConfigResult'],
                 quick_connect_type: str,
                 user_configs: Sequence['outputs.GetQuickConnectQuickConnectConfigUserConfigResult']):
        """
        :param Sequence['GetQuickConnectQuickConnectConfigPhoneConfigArgs'] phone_configs: Specifies the phone configuration of the Quick Connect. This is returned only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
        :param Sequence['GetQuickConnectQuickConnectConfigQueueConfigArgs'] queue_configs: Specifies the queue configuration of the Quick Connect. This is returned only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
        :param str quick_connect_type: Specifies the configuration type of the Quick Connect. Valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
        :param Sequence['GetQuickConnectQuickConnectConfigUserConfigArgs'] user_configs: Specifies the user configuration of the Quick Connect. This is returned only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
        """
        pulumi.set(__self__, "phone_configs", phone_configs)
        pulumi.set(__self__, "queue_configs", queue_configs)
        pulumi.set(__self__, "quick_connect_type", quick_connect_type)
        pulumi.set(__self__, "user_configs", user_configs)

    @property
    @pulumi.getter(name="phoneConfigs")
    def phone_configs(self) -> Sequence['outputs.GetQuickConnectQuickConnectConfigPhoneConfigResult']:
        """
        Specifies the phone configuration of the Quick Connect. This is returned only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
        """
        return pulumi.get(self, "phone_configs")

    @property
    @pulumi.getter(name="queueConfigs")
    def queue_configs(self) -> Sequence['outputs.GetQuickConnectQuickConnectConfigQueueConfigResult']:
        """
        Specifies the queue configuration of the Quick Connect. This is returned only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
        """
        return pulumi.get(self, "queue_configs")

    @property
    @pulumi.getter(name="quickConnectType")
    def quick_connect_type(self) -> str:
        """
        Specifies the configuration type of the Quick Connect. Valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
        """
        return pulumi.get(self, "quick_connect_type")

    @property
    @pulumi.getter(name="userConfigs")
    def user_configs(self) -> Sequence['outputs.GetQuickConnectQuickConnectConfigUserConfigResult']:
        """
        Specifies the user configuration of the Quick Connect. This is returned only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
        """
        return pulumi.get(self, "user_configs")


@pulumi.output_type
class GetQuickConnectQuickConnectConfigPhoneConfigResult(dict):
    def __init__(__self__, *,
                 phone_number: str):
        """
        :param str phone_number: Specifies the phone number in in E.164 format.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        Specifies the phone number in in E.164 format.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class GetQuickConnectQuickConnectConfigQueueConfigResult(dict):
    def __init__(__self__, *,
                 contact_flow_id: str,
                 queue_id: str):
        """
        :param str contact_flow_id: Specifies the identifier of the contact flow.
        :param str queue_id: Specifies the identifier for the queue.
        """
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        pulumi.set(__self__, "queue_id", queue_id)

    @property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> str:
        """
        Specifies the identifier of the contact flow.
        """
        return pulumi.get(self, "contact_flow_id")

    @property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> str:
        """
        Specifies the identifier for the queue.
        """
        return pulumi.get(self, "queue_id")


@pulumi.output_type
class GetQuickConnectQuickConnectConfigUserConfigResult(dict):
    def __init__(__self__, *,
                 contact_flow_id: str,
                 user_id: str):
        """
        :param str contact_flow_id: Specifies the identifier of the contact flow.
        :param str user_id: Specifies the identifier for the user.
        """
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> str:
        """
        Specifies the identifier of the contact flow.
        """
        return pulumi.get(self, "contact_flow_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Specifies the identifier for the user.
        """
        return pulumi.get(self, "user_id")


