# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetQueueResult',
    'AwaitableGetQueueResult',
    'get_queue',
    'get_queue_output',
]

@pulumi.output_type
class GetQueueResult:
    """
    A collection of values returned by getQueue.
    """
    def __init__(__self__, arn=None, description=None, hours_of_operation_id=None, id=None, instance_id=None, max_contacts=None, name=None, outbound_caller_configs=None, queue_id=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if hours_of_operation_id and not isinstance(hours_of_operation_id, str):
            raise TypeError("Expected argument 'hours_of_operation_id' to be a str")
        pulumi.set(__self__, "hours_of_operation_id", hours_of_operation_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if max_contacts and not isinstance(max_contacts, int):
            raise TypeError("Expected argument 'max_contacts' to be a int")
        pulumi.set(__self__, "max_contacts", max_contacts)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outbound_caller_configs and not isinstance(outbound_caller_configs, list):
            raise TypeError("Expected argument 'outbound_caller_configs' to be a list")
        pulumi.set(__self__, "outbound_caller_configs", outbound_caller_configs)
        if queue_id and not isinstance(queue_id, str):
            raise TypeError("Expected argument 'queue_id' to be a str")
        pulumi.set(__self__, "queue_id", queue_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Queue.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Specifies the description of the Queue.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hoursOfOperationId")
    def hours_of_operation_id(self) -> str:
        """
        Specifies the identifier of the Hours of Operation.
        """
        return pulumi.get(self, "hours_of_operation_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="maxContacts")
    def max_contacts(self) -> int:
        """
        Specifies the maximum number of contacts that can be in the queue before it is considered full. Minimum value of 0.
        """
        return pulumi.get(self, "max_contacts")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundCallerConfigs")
    def outbound_caller_configs(self) -> Sequence['outputs.GetQueueOutboundCallerConfigResult']:
        """
        A block that defines the outbound caller ID name, number, and outbound whisper flow. The Outbound Caller Config block is documented below.
        """
        return pulumi.get(self, "outbound_caller_configs")

    @property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> str:
        """
        The identifier for the Queue.
        """
        return pulumi.get(self, "queue_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Specifies the description of the Queue. Values are `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        A map of tags assigned to the Queue.
        """
        return pulumi.get(self, "tags")


class AwaitableGetQueueResult(GetQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueResult(
            arn=self.arn,
            description=self.description,
            hours_of_operation_id=self.hours_of_operation_id,
            id=self.id,
            instance_id=self.instance_id,
            max_contacts=self.max_contacts,
            name=self.name,
            outbound_caller_configs=self.outbound_caller_configs,
            queue_id=self.queue_id,
            status=self.status,
            tags=self.tags)


def get_queue(instance_id: Optional[str] = None,
              name: Optional[str] = None,
              queue_id: Optional[str] = None,
              tags: Optional[Mapping[str, str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueResult:
    """
    Provides details about a specific Amazon Connect Queue.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `queue_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        queue_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param str instance_id: Reference to the hosting Amazon Connect Instance
    :param str name: Returns information on a specific Queue by name
    :param str queue_id: Returns information on a specific Queue by Queue id
    :param Mapping[str, str] tags: A map of tags assigned to the Queue.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['queueId'] = queue_id
    __args__['tags'] = tags
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:connect/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult).value

    return AwaitableGetQueueResult(
        arn=__ret__.arn,
        description=__ret__.description,
        hours_of_operation_id=__ret__.hours_of_operation_id,
        id=__ret__.id,
        instance_id=__ret__.instance_id,
        max_contacts=__ret__.max_contacts,
        name=__ret__.name,
        outbound_caller_configs=__ret__.outbound_caller_configs,
        queue_id=__ret__.queue_id,
        status=__ret__.status,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_queue)
def get_queue_output(instance_id: Optional[pulumi.Input[str]] = None,
                     name: Optional[pulumi.Input[Optional[str]]] = None,
                     queue_id: Optional[pulumi.Input[Optional[str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQueueResult]:
    """
    Provides details about a specific Amazon Connect Queue.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `queue_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        queue_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param str instance_id: Reference to the hosting Amazon Connect Instance
    :param str name: Returns information on a specific Queue by name
    :param str queue_id: Returns information on a specific Queue by Queue id
    :param Mapping[str, str] tags: A map of tags assigned to the Queue.
    """
    ...
