# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['UserPoolUICustomizationArgs', 'UserPoolUICustomization']

@pulumi.input_type
class UserPoolUICustomizationArgs:
    def __init__(__self__, *,
                 user_pool_id: pulumi.Input[str],
                 client_id: Optional[pulumi.Input[str]] = None,
                 css: Optional[pulumi.Input[str]] = None,
                 image_file: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a UserPoolUICustomization resource.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool.
        :param pulumi.Input[str] client_id: The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
        :param pulumi.Input[str] css: The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
        :param pulumi.Input[str] image_file: The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if css is not None:
            pulumi.set(__self__, "css", css)
        if image_file is not None:
            pulumi.set(__self__, "image_file", image_file)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[str]:
        """
        The user pool ID for the user pool.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def css(self) -> Optional[pulumi.Input[str]]:
        """
        The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
        """
        return pulumi.get(self, "css")

    @css.setter
    def css(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "css", value)

    @property
    @pulumi.getter(name="imageFile")
    def image_file(self) -> Optional[pulumi.Input[str]]:
        """
        The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
        """
        return pulumi.get(self, "image_file")

    @image_file.setter
    def image_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_file", value)


@pulumi.input_type
class _UserPoolUICustomizationState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 creation_date: Optional[pulumi.Input[str]] = None,
                 css: Optional[pulumi.Input[str]] = None,
                 css_version: Optional[pulumi.Input[str]] = None,
                 image_file: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 last_modified_date: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UserPoolUICustomization resources.
        :param pulumi.Input[str] client_id: The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
        :param pulumi.Input[str] creation_date: The creation date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
        :param pulumi.Input[str] css: The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
        :param pulumi.Input[str] css_version: The CSS version number.
        :param pulumi.Input[str] image_file: The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
        :param pulumi.Input[str] image_url: The logo image URL for the UI customization.
        :param pulumi.Input[str] last_modified_date: The last-modified date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if css is not None:
            pulumi.set(__self__, "css", css)
        if css_version is not None:
            pulumi.set(__self__, "css_version", css_version)
        if image_file is not None:
            pulumi.set(__self__, "image_file", image_file)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if last_modified_date is not None:
            pulumi.set(__self__, "last_modified_date", last_modified_date)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[str]]:
        """
        The creation date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter
    def css(self) -> Optional[pulumi.Input[str]]:
        """
        The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
        """
        return pulumi.get(self, "css")

    @css.setter
    def css(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "css", value)

    @property
    @pulumi.getter(name="cssVersion")
    def css_version(self) -> Optional[pulumi.Input[str]]:
        """
        The CSS version number.
        """
        return pulumi.get(self, "css_version")

    @css_version.setter
    def css_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "css_version", value)

    @property
    @pulumi.getter(name="imageFile")
    def image_file(self) -> Optional[pulumi.Input[str]]:
        """
        The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
        """
        return pulumi.get(self, "image_file")

    @image_file.setter
    def image_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_file", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The logo image URL for the UI customization.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> Optional[pulumi.Input[str]]:
        """
        The last-modified date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
        """
        return pulumi.get(self, "last_modified_date")

    @last_modified_date.setter
    def last_modified_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_date", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user pool ID for the user pool.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_pool_id", value)


class UserPoolUICustomization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 css: Optional[pulumi.Input[str]] = None,
                 image_file: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cognito User Pool UI Customization resource.

        > **Note:** To use this resource, the user pool must have a domain associated with it. For more information, see the Amazon Cognito Developer Guide on [Customizing the Built-in Sign-In and Sign-up Webpages](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-ui-customization.html).

        ## Example Usage
        ### UI customization settings for a single client

        ```python
        import pulumi
        import base64
        import pulumi_aws as aws

        example_user_pool = aws.cognito.UserPool("exampleUserPool")
        example_user_pool_domain = aws.cognito.UserPoolDomain("exampleUserPoolDomain",
            domain="example",
            user_pool_id=example_user_pool.id)
        example_user_pool_client = aws.cognito.UserPoolClient("exampleUserPoolClient", user_pool_id=example_user_pool.id)
        example_user_pool_ui_customization = aws.cognito.UserPoolUICustomization("exampleUserPoolUICustomization",
            client_id=example_user_pool_client.id,
            css=".label-customizable {font-weight: 400;}",
            image_file=(lambda path: base64.b64encode(open(path).read().encode()).decode())("logo.png"),
            user_pool_id=example_user_pool_domain.user_pool_id)
        ```
        ### UI customization settings for all clients

        ```python
        import pulumi
        import base64
        import pulumi_aws as aws

        example_user_pool = aws.cognito.UserPool("exampleUserPool")
        example_user_pool_domain = aws.cognito.UserPoolDomain("exampleUserPoolDomain",
            domain="example",
            user_pool_id=example_user_pool.id)
        example_user_pool_ui_customization = aws.cognito.UserPoolUICustomization("exampleUserPoolUICustomization",
            css=".label-customizable {font-weight: 400;}",
            image_file=(lambda path: base64.b64encode(open(path).read().encode()).decode())("logo.png"),
            user_pool_id=example_user_pool_domain.user_pool_id)
        ```

        ## Import

        Cognito User Pool UI Customizations can be imported using the `user_pool_id` and `client_id` separated by `,`, e.g.,

        ```sh
         $ pulumi import aws:cognito/userPoolUICustomization:UserPoolUICustomization example us-west-2_ZCTarbt5C,12bu4fuk3mlgqa2rtrujgp6egq
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
        :param pulumi.Input[str] css: The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
        :param pulumi.Input[str] image_file: The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserPoolUICustomizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cognito User Pool UI Customization resource.

        > **Note:** To use this resource, the user pool must have a domain associated with it. For more information, see the Amazon Cognito Developer Guide on [Customizing the Built-in Sign-In and Sign-up Webpages](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-ui-customization.html).

        ## Example Usage
        ### UI customization settings for a single client

        ```python
        import pulumi
        import base64
        import pulumi_aws as aws

        example_user_pool = aws.cognito.UserPool("exampleUserPool")
        example_user_pool_domain = aws.cognito.UserPoolDomain("exampleUserPoolDomain",
            domain="example",
            user_pool_id=example_user_pool.id)
        example_user_pool_client = aws.cognito.UserPoolClient("exampleUserPoolClient", user_pool_id=example_user_pool.id)
        example_user_pool_ui_customization = aws.cognito.UserPoolUICustomization("exampleUserPoolUICustomization",
            client_id=example_user_pool_client.id,
            css=".label-customizable {font-weight: 400;}",
            image_file=(lambda path: base64.b64encode(open(path).read().encode()).decode())("logo.png"),
            user_pool_id=example_user_pool_domain.user_pool_id)
        ```
        ### UI customization settings for all clients

        ```python
        import pulumi
        import base64
        import pulumi_aws as aws

        example_user_pool = aws.cognito.UserPool("exampleUserPool")
        example_user_pool_domain = aws.cognito.UserPoolDomain("exampleUserPoolDomain",
            domain="example",
            user_pool_id=example_user_pool.id)
        example_user_pool_ui_customization = aws.cognito.UserPoolUICustomization("exampleUserPoolUICustomization",
            css=".label-customizable {font-weight: 400;}",
            image_file=(lambda path: base64.b64encode(open(path).read().encode()).decode())("logo.png"),
            user_pool_id=example_user_pool_domain.user_pool_id)
        ```

        ## Import

        Cognito User Pool UI Customizations can be imported using the `user_pool_id` and `client_id` separated by `,`, e.g.,

        ```sh
         $ pulumi import aws:cognito/userPoolUICustomization:UserPoolUICustomization example us-west-2_ZCTarbt5C,12bu4fuk3mlgqa2rtrujgp6egq
        ```

        :param str resource_name: The name of the resource.
        :param UserPoolUICustomizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserPoolUICustomizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 css: Optional[pulumi.Input[str]] = None,
                 image_file: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserPoolUICustomizationArgs.__new__(UserPoolUICustomizationArgs)

            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["css"] = css
            __props__.__dict__["image_file"] = image_file
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["css_version"] = None
            __props__.__dict__["image_url"] = None
            __props__.__dict__["last_modified_date"] = None
        super(UserPoolUICustomization, __self__).__init__(
            'aws:cognito/userPoolUICustomization:UserPoolUICustomization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            creation_date: Optional[pulumi.Input[str]] = None,
            css: Optional[pulumi.Input[str]] = None,
            css_version: Optional[pulumi.Input[str]] = None,
            image_file: Optional[pulumi.Input[str]] = None,
            image_url: Optional[pulumi.Input[str]] = None,
            last_modified_date: Optional[pulumi.Input[str]] = None,
            user_pool_id: Optional[pulumi.Input[str]] = None) -> 'UserPoolUICustomization':
        """
        Get an existing UserPoolUICustomization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
        :param pulumi.Input[str] creation_date: The creation date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
        :param pulumi.Input[str] css: The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
        :param pulumi.Input[str] css_version: The CSS version number.
        :param pulumi.Input[str] image_file: The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
        :param pulumi.Input[str] image_url: The logo image URL for the UI customization.
        :param pulumi.Input[str] last_modified_date: The last-modified date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserPoolUICustomizationState.__new__(_UserPoolUICustomizationState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["css"] = css
        __props__.__dict__["css_version"] = css_version
        __props__.__dict__["image_file"] = image_file
        __props__.__dict__["image_url"] = image_url
        __props__.__dict__["last_modified_date"] = last_modified_date
        __props__.__dict__["user_pool_id"] = user_pool_id
        return UserPoolUICustomization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[str]]:
        """
        The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[str]:
        """
        The creation date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def css(self) -> pulumi.Output[Optional[str]]:
        """
        The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
        """
        return pulumi.get(self, "css")

    @property
    @pulumi.getter(name="cssVersion")
    def css_version(self) -> pulumi.Output[str]:
        """
        The CSS version number.
        """
        return pulumi.get(self, "css_version")

    @property
    @pulumi.getter(name="imageFile")
    def image_file(self) -> pulumi.Output[Optional[str]]:
        """
        The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
        """
        return pulumi.get(self, "image_file")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> pulumi.Output[str]:
        """
        The logo image URL for the UI customization.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> pulumi.Output[str]:
        """
        The last-modified date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
        """
        return pulumi.get(self, "last_modified_date")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[str]:
        """
        The user pool ID for the user pool.
        """
        return pulumi.get(self, "user_pool_id")

