# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'IdentityPoolCognitoIdentityProviderArgs',
    'IdentityPoolRoleAttachmentRoleMappingArgs',
    'IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs',
    'ResourceServerScopeArgs',
    'UserPoolAccountRecoverySettingArgs',
    'UserPoolAccountRecoverySettingRecoveryMechanismArgs',
    'UserPoolAdminCreateUserConfigArgs',
    'UserPoolAdminCreateUserConfigInviteMessageTemplateArgs',
    'UserPoolClientAnalyticsConfigurationArgs',
    'UserPoolClientTokenValidityUnitsArgs',
    'UserPoolDeviceConfigurationArgs',
    'UserPoolEmailConfigurationArgs',
    'UserPoolLambdaConfigArgs',
    'UserPoolLambdaConfigCustomEmailSenderArgs',
    'UserPoolLambdaConfigCustomSmsSenderArgs',
    'UserPoolPasswordPolicyArgs',
    'UserPoolSchemaArgs',
    'UserPoolSchemaNumberAttributeConstraintsArgs',
    'UserPoolSchemaStringAttributeConstraintsArgs',
    'UserPoolSmsConfigurationArgs',
    'UserPoolSoftwareTokenMfaConfigurationArgs',
    'UserPoolUserPoolAddOnsArgs',
    'UserPoolUsernameConfigurationArgs',
    'UserPoolVerificationMessageTemplateArgs',
]

@pulumi.input_type
class IdentityPoolCognitoIdentityProviderArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 provider_name: Optional[pulumi.Input[str]] = None,
                 server_side_token_check: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] client_id: The client ID for the Amazon Cognito Identity User Pool.
        :param pulumi.Input[str] provider_name: The provider name for an Amazon Cognito Identity User Pool.
        :param pulumi.Input[bool] server_side_token_check: Whether server-side token validation is enabled for the identity provider’s token or not.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)
        if server_side_token_check is not None:
            pulumi.set(__self__, "server_side_token_check", server_side_token_check)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client ID for the Amazon Cognito Identity User Pool.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        The provider name for an Amazon Cognito Identity User Pool.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_name", value)

    @property
    @pulumi.getter(name="serverSideTokenCheck")
    def server_side_token_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether server-side token validation is enabled for the identity provider’s token or not.
        """
        return pulumi.get(self, "server_side_token_check")

    @server_side_token_check.setter
    def server_side_token_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "server_side_token_check", value)


@pulumi.input_type
class IdentityPoolRoleAttachmentRoleMappingArgs:
    def __init__(__self__, *,
                 identity_provider: pulumi.Input[str],
                 type: pulumi.Input[str],
                 ambiguous_role_resolution: Optional[pulumi.Input[str]] = None,
                 mapping_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs']]]] = None):
        """
        :param pulumi.Input[str] identity_provider: A string identifying the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id". Depends on `cognito_identity_providers` set on `cognito.IdentityPool` resource or a `cognito.IdentityProvider` resource.
        :param pulumi.Input[str] type: The role mapping type.
        :param pulumi.Input[str] ambiguous_role_resolution: Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no cognito:preferred_role claim and there are multiple cognito:roles matches for the Token type. `Required` if you specify Token or Rules as the Type.
        :param pulumi.Input[Sequence[pulumi.Input['IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs']]] mapping_rules: The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
        """
        pulumi.set(__self__, "identity_provider", identity_provider)
        pulumi.set(__self__, "type", type)
        if ambiguous_role_resolution is not None:
            pulumi.set(__self__, "ambiguous_role_resolution", ambiguous_role_resolution)
        if mapping_rules is not None:
            pulumi.set(__self__, "mapping_rules", mapping_rules)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> pulumi.Input[str]:
        """
        A string identifying the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id". Depends on `cognito_identity_providers` set on `cognito.IdentityPool` resource or a `cognito.IdentityProvider` resource.
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_provider", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The role mapping type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="ambiguousRoleResolution")
    def ambiguous_role_resolution(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no cognito:preferred_role claim and there are multiple cognito:roles matches for the Token type. `Required` if you specify Token or Rules as the Type.
        """
        return pulumi.get(self, "ambiguous_role_resolution")

    @ambiguous_role_resolution.setter
    def ambiguous_role_resolution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ambiguous_role_resolution", value)

    @property
    @pulumi.getter(name="mappingRules")
    def mapping_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs']]]]:
        """
        The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
        """
        return pulumi.get(self, "mapping_rules")

    @mapping_rules.setter
    def mapping_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs']]]]):
        pulumi.set(self, "mapping_rules", value)


@pulumi.input_type
class IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs:
    def __init__(__self__, *,
                 claim: pulumi.Input[str],
                 match_type: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] claim: The claim name that must be present in the token, for example, "isAdmin" or "paid".
        :param pulumi.Input[str] match_type: The match condition that specifies how closely the claim value in the IdP token must match Value.
        :param pulumi.Input[str] role_arn: The role ARN.
        :param pulumi.Input[str] value: A brief string that the claim must match, for example, "paid" or "yes".
        """
        pulumi.set(__self__, "claim", claim)
        pulumi.set(__self__, "match_type", match_type)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def claim(self) -> pulumi.Input[str]:
        """
        The claim name that must be present in the token, for example, "isAdmin" or "paid".
        """
        return pulumi.get(self, "claim")

    @claim.setter
    def claim(self, value: pulumi.Input[str]):
        pulumi.set(self, "claim", value)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> pulumi.Input[str]:
        """
        The match condition that specifies how closely the claim value in the IdP token must match Value.
        """
        return pulumi.get(self, "match_type")

    @match_type.setter
    def match_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "match_type", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The role ARN.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        A brief string that the claim must match, for example, "paid" or "yes".
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ResourceServerScopeArgs:
    def __init__(__self__, *,
                 scope_description: pulumi.Input[str],
                 scope_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] scope_description: The scope description.
        :param pulumi.Input[str] scope_name: The scope name.
        """
        pulumi.set(__self__, "scope_description", scope_description)
        pulumi.set(__self__, "scope_name", scope_name)

    @property
    @pulumi.getter(name="scopeDescription")
    def scope_description(self) -> pulumi.Input[str]:
        """
        The scope description.
        """
        return pulumi.get(self, "scope_description")

    @scope_description.setter
    def scope_description(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope_description", value)

    @property
    @pulumi.getter(name="scopeName")
    def scope_name(self) -> pulumi.Input[str]:
        """
        The scope name.
        """
        return pulumi.get(self, "scope_name")

    @scope_name.setter
    def scope_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope_name", value)


@pulumi.input_type
class UserPoolAccountRecoverySettingArgs:
    def __init__(__self__, *,
                 recovery_mechanisms: pulumi.Input[Sequence[pulumi.Input['UserPoolAccountRecoverySettingRecoveryMechanismArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['UserPoolAccountRecoverySettingRecoveryMechanismArgs']]] recovery_mechanisms: List of Account Recovery Options of the following structure:
        """
        pulumi.set(__self__, "recovery_mechanisms", recovery_mechanisms)

    @property
    @pulumi.getter(name="recoveryMechanisms")
    def recovery_mechanisms(self) -> pulumi.Input[Sequence[pulumi.Input['UserPoolAccountRecoverySettingRecoveryMechanismArgs']]]:
        """
        List of Account Recovery Options of the following structure:
        """
        return pulumi.get(self, "recovery_mechanisms")

    @recovery_mechanisms.setter
    def recovery_mechanisms(self, value: pulumi.Input[Sequence[pulumi.Input['UserPoolAccountRecoverySettingRecoveryMechanismArgs']]]):
        pulumi.set(self, "recovery_mechanisms", value)


@pulumi.input_type
class UserPoolAccountRecoverySettingRecoveryMechanismArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 priority: pulumi.Input[int]):
        """
        :param pulumi.Input[str] name: Name of the attribute.
        :param pulumi.Input[int] priority: Positive integer specifying priority of a method with 1 being the highest priority.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Positive integer specifying priority of a method with 1 being the highest priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)


@pulumi.input_type
class UserPoolAdminCreateUserConfigArgs:
    def __init__(__self__, *,
                 allow_admin_create_user_only: Optional[pulumi.Input[bool]] = None,
                 invite_message_template: Optional[pulumi.Input['UserPoolAdminCreateUserConfigInviteMessageTemplateArgs']] = None):
        """
        :param pulumi.Input[bool] allow_admin_create_user_only: Set to True if only the administrator is allowed to create user profiles. Set to False if users can sign themselves up via an app.
        :param pulumi.Input['UserPoolAdminCreateUserConfigInviteMessageTemplateArgs'] invite_message_template: Invite message template structure. Detailed below.
        """
        if allow_admin_create_user_only is not None:
            pulumi.set(__self__, "allow_admin_create_user_only", allow_admin_create_user_only)
        if invite_message_template is not None:
            pulumi.set(__self__, "invite_message_template", invite_message_template)

    @property
    @pulumi.getter(name="allowAdminCreateUserOnly")
    def allow_admin_create_user_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to True if only the administrator is allowed to create user profiles. Set to False if users can sign themselves up via an app.
        """
        return pulumi.get(self, "allow_admin_create_user_only")

    @allow_admin_create_user_only.setter
    def allow_admin_create_user_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_admin_create_user_only", value)

    @property
    @pulumi.getter(name="inviteMessageTemplate")
    def invite_message_template(self) -> Optional[pulumi.Input['UserPoolAdminCreateUserConfigInviteMessageTemplateArgs']]:
        """
        Invite message template structure. Detailed below.
        """
        return pulumi.get(self, "invite_message_template")

    @invite_message_template.setter
    def invite_message_template(self, value: Optional[pulumi.Input['UserPoolAdminCreateUserConfigInviteMessageTemplateArgs']]):
        pulumi.set(self, "invite_message_template", value)


@pulumi.input_type
class UserPoolAdminCreateUserConfigInviteMessageTemplateArgs:
    def __init__(__self__, *,
                 email_message: Optional[pulumi.Input[str]] = None,
                 email_subject: Optional[pulumi.Input[str]] = None,
                 sms_message: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] email_message: Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
        :param pulumi.Input[str] email_subject: Subject line for the email message template. Conflicts with `email_verification_subject` argument.
        :param pulumi.Input[str] sms_message: SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
        """
        if email_message is not None:
            pulumi.set(__self__, "email_message", email_message)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if sms_message is not None:
            pulumi.set(__self__, "sms_message", sms_message)

    @property
    @pulumi.getter(name="emailMessage")
    def email_message(self) -> Optional[pulumi.Input[str]]:
        """
        Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
        """
        return pulumi.get(self, "email_message")

    @email_message.setter
    def email_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_message", value)

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[pulumi.Input[str]]:
        """
        Subject line for the email message template. Conflicts with `email_verification_subject` argument.
        """
        return pulumi.get(self, "email_subject")

    @email_subject.setter
    def email_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_subject", value)

    @property
    @pulumi.getter(name="smsMessage")
    def sms_message(self) -> Optional[pulumi.Input[str]]:
        """
        SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
        """
        return pulumi.get(self, "sms_message")

    @sms_message.setter
    def sms_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sms_message", value)


@pulumi.input_type
class UserPoolClientAnalyticsConfigurationArgs:
    def __init__(__self__, *,
                 application_arn: Optional[pulumi.Input[str]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 user_data_shared: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] application_arn: Application ARN for an Amazon Pinpoint application. Conflicts with `external_id` and `role_arn`.
        :param pulumi.Input[str] application_id: Application ID for an Amazon Pinpoint application.
        :param pulumi.Input[str] external_id: ID for the Analytics Configuration. Conflicts with `application_arn`.
        :param pulumi.Input[str] role_arn: ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. Conflicts with `application_arn`.
        :param pulumi.Input[bool] user_data_shared: If set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
        """
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if user_data_shared is not None:
            pulumi.set(__self__, "user_data_shared", user_data_shared)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Application ARN for an Amazon Pinpoint application. Conflicts with `external_id` and `role_arn`.
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_arn", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Application ID for an Amazon Pinpoint application.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID for the Analytics Configuration. Conflicts with `application_arn`.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. Conflicts with `application_arn`.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="userDataShared")
    def user_data_shared(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
        """
        return pulumi.get(self, "user_data_shared")

    @user_data_shared.setter
    def user_data_shared(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_data_shared", value)


@pulumi.input_type
class UserPoolClientTokenValidityUnitsArgs:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[str]] = None,
                 id_token: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] access_token: Time unit in for the value in `access_token_validity`, defaults to `hours`.
        :param pulumi.Input[str] id_token: Time unit in for the value in `id_token_validity`, defaults to `hours`.
        :param pulumi.Input[str] refresh_token: Time unit in for the value in `refresh_token_validity`, defaults to `days`.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if id_token is not None:
            pulumi.set(__self__, "id_token", id_token)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Time unit in for the value in `access_token_validity`, defaults to `hours`.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="idToken")
    def id_token(self) -> Optional[pulumi.Input[str]]:
        """
        Time unit in for the value in `id_token_validity`, defaults to `hours`.
        """
        return pulumi.get(self, "id_token")

    @id_token.setter
    def id_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id_token", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        Time unit in for the value in `refresh_token_validity`, defaults to `days`.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token", value)


@pulumi.input_type
class UserPoolDeviceConfigurationArgs:
    def __init__(__self__, *,
                 challenge_required_on_new_device: Optional[pulumi.Input[bool]] = None,
                 device_only_remembered_on_user_prompt: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] challenge_required_on_new_device: Whether a challenge is required on a new device. Only applicable to a new device.
        :param pulumi.Input[bool] device_only_remembered_on_user_prompt: Whether a device is only remembered on user prompt. `false` equates to "Always" remember, `true` is "User Opt In," and not using a `device_configuration` block is "No."
        """
        if challenge_required_on_new_device is not None:
            pulumi.set(__self__, "challenge_required_on_new_device", challenge_required_on_new_device)
        if device_only_remembered_on_user_prompt is not None:
            pulumi.set(__self__, "device_only_remembered_on_user_prompt", device_only_remembered_on_user_prompt)

    @property
    @pulumi.getter(name="challengeRequiredOnNewDevice")
    def challenge_required_on_new_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a challenge is required on a new device. Only applicable to a new device.
        """
        return pulumi.get(self, "challenge_required_on_new_device")

    @challenge_required_on_new_device.setter
    def challenge_required_on_new_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "challenge_required_on_new_device", value)

    @property
    @pulumi.getter(name="deviceOnlyRememberedOnUserPrompt")
    def device_only_remembered_on_user_prompt(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a device is only remembered on user prompt. `false` equates to "Always" remember, `true` is "User Opt In," and not using a `device_configuration` block is "No."
        """
        return pulumi.get(self, "device_only_remembered_on_user_prompt")

    @device_only_remembered_on_user_prompt.setter
    def device_only_remembered_on_user_prompt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "device_only_remembered_on_user_prompt", value)


@pulumi.input_type
class UserPoolEmailConfigurationArgs:
    def __init__(__self__, *,
                 configuration_set: Optional[pulumi.Input[str]] = None,
                 email_sending_account: Optional[pulumi.Input[str]] = None,
                 from_email_address: Optional[pulumi.Input[str]] = None,
                 reply_to_email_address: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] configuration_set: Email configuration set name from SES.
        :param pulumi.Input[str] email_sending_account: Email delivery method to use. `COGNITO_DEFAULT` for the default email functionality built into Cognito or `DEVELOPER` to use your Amazon SES configuration.
        :param pulumi.Input[str] from_email_address: Sender’s email address or sender’s display name with their email address (e.g., `john@example.com`, `John Smith <john@example.com>` or `\"John Smith Ph.D.\" <john@example.com>`). Escaped double quotes are required around display names that contain certain characters as specified in [RFC 5322](https://tools.ietf.org/html/rfc5322).
        :param pulumi.Input[str] reply_to_email_address: REPLY-TO email address.
        :param pulumi.Input[str] source_arn: ARN of the SES verified email identity to to use. Required if `email_sending_account` is set to `DEVELOPER`.
        """
        if configuration_set is not None:
            pulumi.set(__self__, "configuration_set", configuration_set)
        if email_sending_account is not None:
            pulumi.set(__self__, "email_sending_account", email_sending_account)
        if from_email_address is not None:
            pulumi.set(__self__, "from_email_address", from_email_address)
        if reply_to_email_address is not None:
            pulumi.set(__self__, "reply_to_email_address", reply_to_email_address)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)

    @property
    @pulumi.getter(name="configurationSet")
    def configuration_set(self) -> Optional[pulumi.Input[str]]:
        """
        Email configuration set name from SES.
        """
        return pulumi.get(self, "configuration_set")

    @configuration_set.setter
    def configuration_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_set", value)

    @property
    @pulumi.getter(name="emailSendingAccount")
    def email_sending_account(self) -> Optional[pulumi.Input[str]]:
        """
        Email delivery method to use. `COGNITO_DEFAULT` for the default email functionality built into Cognito or `DEVELOPER` to use your Amazon SES configuration.
        """
        return pulumi.get(self, "email_sending_account")

    @email_sending_account.setter
    def email_sending_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_sending_account", value)

    @property
    @pulumi.getter(name="fromEmailAddress")
    def from_email_address(self) -> Optional[pulumi.Input[str]]:
        """
        Sender’s email address or sender’s display name with their email address (e.g., `john@example.com`, `John Smith <john@example.com>` or `\"John Smith Ph.D.\" <john@example.com>`). Escaped double quotes are required around display names that contain certain characters as specified in [RFC 5322](https://tools.ietf.org/html/rfc5322).
        """
        return pulumi.get(self, "from_email_address")

    @from_email_address.setter
    def from_email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "from_email_address", value)

    @property
    @pulumi.getter(name="replyToEmailAddress")
    def reply_to_email_address(self) -> Optional[pulumi.Input[str]]:
        """
        REPLY-TO email address.
        """
        return pulumi.get(self, "reply_to_email_address")

    @reply_to_email_address.setter
    def reply_to_email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reply_to_email_address", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the SES verified email identity to to use. Required if `email_sending_account` is set to `DEVELOPER`.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)


@pulumi.input_type
class UserPoolLambdaConfigArgs:
    def __init__(__self__, *,
                 create_auth_challenge: Optional[pulumi.Input[str]] = None,
                 custom_email_sender: Optional[pulumi.Input['UserPoolLambdaConfigCustomEmailSenderArgs']] = None,
                 custom_message: Optional[pulumi.Input[str]] = None,
                 custom_sms_sender: Optional[pulumi.Input['UserPoolLambdaConfigCustomSmsSenderArgs']] = None,
                 define_auth_challenge: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 post_authentication: Optional[pulumi.Input[str]] = None,
                 post_confirmation: Optional[pulumi.Input[str]] = None,
                 pre_authentication: Optional[pulumi.Input[str]] = None,
                 pre_sign_up: Optional[pulumi.Input[str]] = None,
                 pre_token_generation: Optional[pulumi.Input[str]] = None,
                 user_migration: Optional[pulumi.Input[str]] = None,
                 verify_auth_challenge_response: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create_auth_challenge: ARN of the lambda creating an authentication challenge.
        :param pulumi.Input['UserPoolLambdaConfigCustomEmailSenderArgs'] custom_email_sender: A custom email sender AWS Lambda trigger. See custom_email_sender Below.
        :param pulumi.Input[str] custom_message: Custom Message AWS Lambda trigger.
        :param pulumi.Input['UserPoolLambdaConfigCustomSmsSenderArgs'] custom_sms_sender: A custom SMS sender AWS Lambda trigger. See custom_sms_sender Below.
        :param pulumi.Input[str] define_auth_challenge: Defines the authentication challenge.
        :param pulumi.Input[str] kms_key_id: The Amazon Resource Name of Key Management Service Customer master keys. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to CustomEmailSender and CustomSMSSender.
        :param pulumi.Input[str] post_authentication: Post-authentication AWS Lambda trigger.
        :param pulumi.Input[str] post_confirmation: Post-confirmation AWS Lambda trigger.
        :param pulumi.Input[str] pre_authentication: Pre-authentication AWS Lambda trigger.
        :param pulumi.Input[str] pre_sign_up: Pre-registration AWS Lambda trigger.
        :param pulumi.Input[str] pre_token_generation: Allow to customize identity token claims before token generation.
        :param pulumi.Input[str] user_migration: User migration Lambda config type.
        :param pulumi.Input[str] verify_auth_challenge_response: Verifies the authentication challenge response.
        """
        if create_auth_challenge is not None:
            pulumi.set(__self__, "create_auth_challenge", create_auth_challenge)
        if custom_email_sender is not None:
            pulumi.set(__self__, "custom_email_sender", custom_email_sender)
        if custom_message is not None:
            pulumi.set(__self__, "custom_message", custom_message)
        if custom_sms_sender is not None:
            pulumi.set(__self__, "custom_sms_sender", custom_sms_sender)
        if define_auth_challenge is not None:
            pulumi.set(__self__, "define_auth_challenge", define_auth_challenge)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if post_authentication is not None:
            pulumi.set(__self__, "post_authentication", post_authentication)
        if post_confirmation is not None:
            pulumi.set(__self__, "post_confirmation", post_confirmation)
        if pre_authentication is not None:
            pulumi.set(__self__, "pre_authentication", pre_authentication)
        if pre_sign_up is not None:
            pulumi.set(__self__, "pre_sign_up", pre_sign_up)
        if pre_token_generation is not None:
            pulumi.set(__self__, "pre_token_generation", pre_token_generation)
        if user_migration is not None:
            pulumi.set(__self__, "user_migration", user_migration)
        if verify_auth_challenge_response is not None:
            pulumi.set(__self__, "verify_auth_challenge_response", verify_auth_challenge_response)

    @property
    @pulumi.getter(name="createAuthChallenge")
    def create_auth_challenge(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the lambda creating an authentication challenge.
        """
        return pulumi.get(self, "create_auth_challenge")

    @create_auth_challenge.setter
    def create_auth_challenge(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_auth_challenge", value)

    @property
    @pulumi.getter(name="customEmailSender")
    def custom_email_sender(self) -> Optional[pulumi.Input['UserPoolLambdaConfigCustomEmailSenderArgs']]:
        """
        A custom email sender AWS Lambda trigger. See custom_email_sender Below.
        """
        return pulumi.get(self, "custom_email_sender")

    @custom_email_sender.setter
    def custom_email_sender(self, value: Optional[pulumi.Input['UserPoolLambdaConfigCustomEmailSenderArgs']]):
        pulumi.set(self, "custom_email_sender", value)

    @property
    @pulumi.getter(name="customMessage")
    def custom_message(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Message AWS Lambda trigger.
        """
        return pulumi.get(self, "custom_message")

    @custom_message.setter
    def custom_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_message", value)

    @property
    @pulumi.getter(name="customSmsSender")
    def custom_sms_sender(self) -> Optional[pulumi.Input['UserPoolLambdaConfigCustomSmsSenderArgs']]:
        """
        A custom SMS sender AWS Lambda trigger. See custom_sms_sender Below.
        """
        return pulumi.get(self, "custom_sms_sender")

    @custom_sms_sender.setter
    def custom_sms_sender(self, value: Optional[pulumi.Input['UserPoolLambdaConfigCustomSmsSenderArgs']]):
        pulumi.set(self, "custom_sms_sender", value)

    @property
    @pulumi.getter(name="defineAuthChallenge")
    def define_auth_challenge(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the authentication challenge.
        """
        return pulumi.get(self, "define_auth_challenge")

    @define_auth_challenge.setter
    def define_auth_challenge(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "define_auth_challenge", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name of Key Management Service Customer master keys. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to CustomEmailSender and CustomSMSSender.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="postAuthentication")
    def post_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Post-authentication AWS Lambda trigger.
        """
        return pulumi.get(self, "post_authentication")

    @post_authentication.setter
    def post_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_authentication", value)

    @property
    @pulumi.getter(name="postConfirmation")
    def post_confirmation(self) -> Optional[pulumi.Input[str]]:
        """
        Post-confirmation AWS Lambda trigger.
        """
        return pulumi.get(self, "post_confirmation")

    @post_confirmation.setter
    def post_confirmation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_confirmation", value)

    @property
    @pulumi.getter(name="preAuthentication")
    def pre_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-authentication AWS Lambda trigger.
        """
        return pulumi.get(self, "pre_authentication")

    @pre_authentication.setter
    def pre_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_authentication", value)

    @property
    @pulumi.getter(name="preSignUp")
    def pre_sign_up(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-registration AWS Lambda trigger.
        """
        return pulumi.get(self, "pre_sign_up")

    @pre_sign_up.setter
    def pre_sign_up(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_sign_up", value)

    @property
    @pulumi.getter(name="preTokenGeneration")
    def pre_token_generation(self) -> Optional[pulumi.Input[str]]:
        """
        Allow to customize identity token claims before token generation.
        """
        return pulumi.get(self, "pre_token_generation")

    @pre_token_generation.setter
    def pre_token_generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_token_generation", value)

    @property
    @pulumi.getter(name="userMigration")
    def user_migration(self) -> Optional[pulumi.Input[str]]:
        """
        User migration Lambda config type.
        """
        return pulumi.get(self, "user_migration")

    @user_migration.setter
    def user_migration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_migration", value)

    @property
    @pulumi.getter(name="verifyAuthChallengeResponse")
    def verify_auth_challenge_response(self) -> Optional[pulumi.Input[str]]:
        """
        Verifies the authentication challenge response.
        """
        return pulumi.get(self, "verify_auth_challenge_response")

    @verify_auth_challenge_response.setter
    def verify_auth_challenge_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verify_auth_challenge_response", value)


@pulumi.input_type
class UserPoolLambdaConfigCustomEmailSenderArgs:
    def __init__(__self__, *,
                 lambda_arn: pulumi.Input[str],
                 lambda_version: pulumi.Input[str]):
        """
        :param pulumi.Input[str] lambda_arn: The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send SMS notifications to users.
        :param pulumi.Input[str] lambda_version: The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS Lambda function. The only supported value is `V1_0`.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        pulumi.set(__self__, "lambda_version", lambda_version)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> pulumi.Input[str]:
        """
        The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send SMS notifications to users.
        """
        return pulumi.get(self, "lambda_arn")

    @lambda_arn.setter
    def lambda_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "lambda_arn", value)

    @property
    @pulumi.getter(name="lambdaVersion")
    def lambda_version(self) -> pulumi.Input[str]:
        """
        The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS Lambda function. The only supported value is `V1_0`.
        """
        return pulumi.get(self, "lambda_version")

    @lambda_version.setter
    def lambda_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "lambda_version", value)


@pulumi.input_type
class UserPoolLambdaConfigCustomSmsSenderArgs:
    def __init__(__self__, *,
                 lambda_arn: pulumi.Input[str],
                 lambda_version: pulumi.Input[str]):
        """
        :param pulumi.Input[str] lambda_arn: The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send SMS notifications to users.
        :param pulumi.Input[str] lambda_version: The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS Lambda function. The only supported value is `V1_0`.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        pulumi.set(__self__, "lambda_version", lambda_version)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> pulumi.Input[str]:
        """
        The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send SMS notifications to users.
        """
        return pulumi.get(self, "lambda_arn")

    @lambda_arn.setter
    def lambda_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "lambda_arn", value)

    @property
    @pulumi.getter(name="lambdaVersion")
    def lambda_version(self) -> pulumi.Input[str]:
        """
        The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS Lambda function. The only supported value is `V1_0`.
        """
        return pulumi.get(self, "lambda_version")

    @lambda_version.setter
    def lambda_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "lambda_version", value)


@pulumi.input_type
class UserPoolPasswordPolicyArgs:
    def __init__(__self__, *,
                 minimum_length: Optional[pulumi.Input[int]] = None,
                 require_lowercase: Optional[pulumi.Input[bool]] = None,
                 require_numbers: Optional[pulumi.Input[bool]] = None,
                 require_symbols: Optional[pulumi.Input[bool]] = None,
                 require_uppercase: Optional[pulumi.Input[bool]] = None,
                 temporary_password_validity_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] minimum_length: Minimum length of the password policy that you have set.
        :param pulumi.Input[bool] require_lowercase: Whether you have required users to use at least one lowercase letter in their password.
        :param pulumi.Input[bool] require_numbers: Whether you have required users to use at least one number in their password.
        :param pulumi.Input[bool] require_symbols: Whether you have required users to use at least one symbol in their password.
        :param pulumi.Input[bool] require_uppercase: Whether you have required users to use at least one uppercase letter in their password.
        :param pulumi.Input[int] temporary_password_validity_days: In the password policy you have set, refers to the number of days a temporary password is valid. If the user does not sign-in during this time, their password will need to be reset by an administrator.
        """
        if minimum_length is not None:
            pulumi.set(__self__, "minimum_length", minimum_length)
        if require_lowercase is not None:
            pulumi.set(__self__, "require_lowercase", require_lowercase)
        if require_numbers is not None:
            pulumi.set(__self__, "require_numbers", require_numbers)
        if require_symbols is not None:
            pulumi.set(__self__, "require_symbols", require_symbols)
        if require_uppercase is not None:
            pulumi.set(__self__, "require_uppercase", require_uppercase)
        if temporary_password_validity_days is not None:
            pulumi.set(__self__, "temporary_password_validity_days", temporary_password_validity_days)

    @property
    @pulumi.getter(name="minimumLength")
    def minimum_length(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum length of the password policy that you have set.
        """
        return pulumi.get(self, "minimum_length")

    @minimum_length.setter
    def minimum_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_length", value)

    @property
    @pulumi.getter(name="requireLowercase")
    def require_lowercase(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether you have required users to use at least one lowercase letter in their password.
        """
        return pulumi.get(self, "require_lowercase")

    @require_lowercase.setter
    def require_lowercase(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_lowercase", value)

    @property
    @pulumi.getter(name="requireNumbers")
    def require_numbers(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether you have required users to use at least one number in their password.
        """
        return pulumi.get(self, "require_numbers")

    @require_numbers.setter
    def require_numbers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_numbers", value)

    @property
    @pulumi.getter(name="requireSymbols")
    def require_symbols(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether you have required users to use at least one symbol in their password.
        """
        return pulumi.get(self, "require_symbols")

    @require_symbols.setter
    def require_symbols(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_symbols", value)

    @property
    @pulumi.getter(name="requireUppercase")
    def require_uppercase(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether you have required users to use at least one uppercase letter in their password.
        """
        return pulumi.get(self, "require_uppercase")

    @require_uppercase.setter
    def require_uppercase(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_uppercase", value)

    @property
    @pulumi.getter(name="temporaryPasswordValidityDays")
    def temporary_password_validity_days(self) -> Optional[pulumi.Input[int]]:
        """
        In the password policy you have set, refers to the number of days a temporary password is valid. If the user does not sign-in during this time, their password will need to be reset by an administrator.
        """
        return pulumi.get(self, "temporary_password_validity_days")

    @temporary_password_validity_days.setter
    def temporary_password_validity_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "temporary_password_validity_days", value)


@pulumi.input_type
class UserPoolSchemaArgs:
    def __init__(__self__, *,
                 attribute_data_type: pulumi.Input[str],
                 name: pulumi.Input[str],
                 developer_only_attribute: Optional[pulumi.Input[bool]] = None,
                 mutable: Optional[pulumi.Input[bool]] = None,
                 number_attribute_constraints: Optional[pulumi.Input['UserPoolSchemaNumberAttributeConstraintsArgs']] = None,
                 required: Optional[pulumi.Input[bool]] = None,
                 string_attribute_constraints: Optional[pulumi.Input['UserPoolSchemaStringAttributeConstraintsArgs']] = None):
        """
        :param pulumi.Input[str] attribute_data_type: Attribute data type. Must be one of `Boolean`, `Number`, `String`, `DateTime`.
        :param pulumi.Input[str] name: Name of the attribute.
        :param pulumi.Input[bool] developer_only_attribute: Whether the attribute type is developer only.
        :param pulumi.Input[bool] mutable: Whether the attribute can be changed once it has been created.
        :param pulumi.Input['UserPoolSchemaNumberAttributeConstraintsArgs'] number_attribute_constraints: Configuration block for the constraints for an attribute of the number type. Detailed below.
        :param pulumi.Input[bool] required: Whether a user pool attribute is required. If the attribute is required and the user does not provide a value, registration or sign-in will fail.
        :param pulumi.Input['UserPoolSchemaStringAttributeConstraintsArgs'] string_attribute_constraints: Constraints for an attribute of the string type. Detailed below.
        """
        pulumi.set(__self__, "attribute_data_type", attribute_data_type)
        pulumi.set(__self__, "name", name)
        if developer_only_attribute is not None:
            pulumi.set(__self__, "developer_only_attribute", developer_only_attribute)
        if mutable is not None:
            pulumi.set(__self__, "mutable", mutable)
        if number_attribute_constraints is not None:
            pulumi.set(__self__, "number_attribute_constraints", number_attribute_constraints)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if string_attribute_constraints is not None:
            pulumi.set(__self__, "string_attribute_constraints", string_attribute_constraints)

    @property
    @pulumi.getter(name="attributeDataType")
    def attribute_data_type(self) -> pulumi.Input[str]:
        """
        Attribute data type. Must be one of `Boolean`, `Number`, `String`, `DateTime`.
        """
        return pulumi.get(self, "attribute_data_type")

    @attribute_data_type.setter
    def attribute_data_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "attribute_data_type", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="developerOnlyAttribute")
    def developer_only_attribute(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the attribute type is developer only.
        """
        return pulumi.get(self, "developer_only_attribute")

    @developer_only_attribute.setter
    def developer_only_attribute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "developer_only_attribute", value)

    @property
    @pulumi.getter
    def mutable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the attribute can be changed once it has been created.
        """
        return pulumi.get(self, "mutable")

    @mutable.setter
    def mutable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mutable", value)

    @property
    @pulumi.getter(name="numberAttributeConstraints")
    def number_attribute_constraints(self) -> Optional[pulumi.Input['UserPoolSchemaNumberAttributeConstraintsArgs']]:
        """
        Configuration block for the constraints for an attribute of the number type. Detailed below.
        """
        return pulumi.get(self, "number_attribute_constraints")

    @number_attribute_constraints.setter
    def number_attribute_constraints(self, value: Optional[pulumi.Input['UserPoolSchemaNumberAttributeConstraintsArgs']]):
        pulumi.set(self, "number_attribute_constraints", value)

    @property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a user pool attribute is required. If the attribute is required and the user does not provide a value, registration or sign-in will fail.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter(name="stringAttributeConstraints")
    def string_attribute_constraints(self) -> Optional[pulumi.Input['UserPoolSchemaStringAttributeConstraintsArgs']]:
        """
        Constraints for an attribute of the string type. Detailed below.
        """
        return pulumi.get(self, "string_attribute_constraints")

    @string_attribute_constraints.setter
    def string_attribute_constraints(self, value: Optional[pulumi.Input['UserPoolSchemaStringAttributeConstraintsArgs']]):
        pulumi.set(self, "string_attribute_constraints", value)


@pulumi.input_type
class UserPoolSchemaNumberAttributeConstraintsArgs:
    def __init__(__self__, *,
                 max_value: Optional[pulumi.Input[str]] = None,
                 min_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_value: Maximum value of an attribute that is of the number data type.
        :param pulumi.Input[str] min_value: Minimum value of an attribute that is of the number data type.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum value of an attribute that is of the number data type.
        """
        return pulumi.get(self, "max_value")

    @max_value.setter
    def max_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_value", value)

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum value of an attribute that is of the number data type.
        """
        return pulumi.get(self, "min_value")

    @min_value.setter
    def min_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_value", value)


@pulumi.input_type
class UserPoolSchemaStringAttributeConstraintsArgs:
    def __init__(__self__, *,
                 max_length: Optional[pulumi.Input[str]] = None,
                 min_length: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_length: Maximum length of an attribute value of the string type.
        :param pulumi.Input[str] min_length: Minimum length of an attribute value of the string type.
        """
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum length of an attribute value of the string type.
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum length of an attribute value of the string type.
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_length", value)


@pulumi.input_type
class UserPoolSmsConfigurationArgs:
    def __init__(__self__, *,
                 external_id: pulumi.Input[str],
                 sns_caller_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] external_id: External ID used in IAM role trust relationships. For more information about using external IDs, see [How to Use an External ID When Granting Access to Your AWS Resources to a Third Party](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html).
        :param pulumi.Input[str] sns_caller_arn: ARN of the Amazon SNS caller. This is usually the IAM role that you've given Cognito permission to assume.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "sns_caller_arn", sns_caller_arn)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Input[str]:
        """
        External ID used in IAM role trust relationships. For more information about using external IDs, see [How to Use an External ID When Granting Access to Your AWS Resources to a Third Party](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html).
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="snsCallerArn")
    def sns_caller_arn(self) -> pulumi.Input[str]:
        """
        ARN of the Amazon SNS caller. This is usually the IAM role that you've given Cognito permission to assume.
        """
        return pulumi.get(self, "sns_caller_arn")

    @sns_caller_arn.setter
    def sns_caller_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "sns_caller_arn", value)


@pulumi.input_type
class UserPoolSoftwareTokenMfaConfigurationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: Boolean whether to enable software token Multi-Factor (MFA) tokens, such as Time-based One-Time Password (TOTP). To disable software token MFA When `sms_configuration` is not present, the `mfa_configuration` argument must be set to `OFF` and the `software_token_mfa_configuration` configuration block must be fully removed.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Boolean whether to enable software token Multi-Factor (MFA) tokens, such as Time-based One-Time Password (TOTP). To disable software token MFA When `sms_configuration` is not present, the `mfa_configuration` argument must be set to `OFF` and the `software_token_mfa_configuration` configuration block must be fully removed.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class UserPoolUserPoolAddOnsArgs:
    def __init__(__self__, *,
                 advanced_security_mode: pulumi.Input[str]):
        """
        :param pulumi.Input[str] advanced_security_mode: Mode for advanced security, must be one of `OFF`, `AUDIT` or `ENFORCED`.
        """
        pulumi.set(__self__, "advanced_security_mode", advanced_security_mode)

    @property
    @pulumi.getter(name="advancedSecurityMode")
    def advanced_security_mode(self) -> pulumi.Input[str]:
        """
        Mode for advanced security, must be one of `OFF`, `AUDIT` or `ENFORCED`.
        """
        return pulumi.get(self, "advanced_security_mode")

    @advanced_security_mode.setter
    def advanced_security_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "advanced_security_mode", value)


@pulumi.input_type
class UserPoolUsernameConfigurationArgs:
    def __init__(__self__, *,
                 case_sensitive: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] case_sensitive: Whether username case sensitivity will be applied for all users in the user pool through Cognito APIs.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> pulumi.Input[bool]:
        """
        Whether username case sensitivity will be applied for all users in the user pool through Cognito APIs.
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: pulumi.Input[bool]):
        pulumi.set(self, "case_sensitive", value)


@pulumi.input_type
class UserPoolVerificationMessageTemplateArgs:
    def __init__(__self__, *,
                 default_email_option: Optional[pulumi.Input[str]] = None,
                 email_message: Optional[pulumi.Input[str]] = None,
                 email_message_by_link: Optional[pulumi.Input[str]] = None,
                 email_subject: Optional[pulumi.Input[str]] = None,
                 email_subject_by_link: Optional[pulumi.Input[str]] = None,
                 sms_message: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] default_email_option: Default email option. Must be either `CONFIRM_WITH_CODE` or `CONFIRM_WITH_LINK`. Defaults to `CONFIRM_WITH_CODE`.
        :param pulumi.Input[str] email_message: Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
        :param pulumi.Input[str] email_message_by_link: Email message template for sending a confirmation link to the user, it must contain the `{##Click Here##}` placeholder.
        :param pulumi.Input[str] email_subject: Subject line for the email message template. Conflicts with `email_verification_subject` argument.
        :param pulumi.Input[str] email_subject_by_link: Subject line for the email message template for sending a confirmation link to the user.
        :param pulumi.Input[str] sms_message: SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
        """
        if default_email_option is not None:
            pulumi.set(__self__, "default_email_option", default_email_option)
        if email_message is not None:
            pulumi.set(__self__, "email_message", email_message)
        if email_message_by_link is not None:
            pulumi.set(__self__, "email_message_by_link", email_message_by_link)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if email_subject_by_link is not None:
            pulumi.set(__self__, "email_subject_by_link", email_subject_by_link)
        if sms_message is not None:
            pulumi.set(__self__, "sms_message", sms_message)

    @property
    @pulumi.getter(name="defaultEmailOption")
    def default_email_option(self) -> Optional[pulumi.Input[str]]:
        """
        Default email option. Must be either `CONFIRM_WITH_CODE` or `CONFIRM_WITH_LINK`. Defaults to `CONFIRM_WITH_CODE`.
        """
        return pulumi.get(self, "default_email_option")

    @default_email_option.setter
    def default_email_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_email_option", value)

    @property
    @pulumi.getter(name="emailMessage")
    def email_message(self) -> Optional[pulumi.Input[str]]:
        """
        Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
        """
        return pulumi.get(self, "email_message")

    @email_message.setter
    def email_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_message", value)

    @property
    @pulumi.getter(name="emailMessageByLink")
    def email_message_by_link(self) -> Optional[pulumi.Input[str]]:
        """
        Email message template for sending a confirmation link to the user, it must contain the `{##Click Here##}` placeholder.
        """
        return pulumi.get(self, "email_message_by_link")

    @email_message_by_link.setter
    def email_message_by_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_message_by_link", value)

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[pulumi.Input[str]]:
        """
        Subject line for the email message template. Conflicts with `email_verification_subject` argument.
        """
        return pulumi.get(self, "email_subject")

    @email_subject.setter
    def email_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_subject", value)

    @property
    @pulumi.getter(name="emailSubjectByLink")
    def email_subject_by_link(self) -> Optional[pulumi.Input[str]]:
        """
        Subject line for the email message template for sending a confirmation link to the user.
        """
        return pulumi.get(self, "email_subject_by_link")

    @email_subject_by_link.setter
    def email_subject_by_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_subject_by_link", value)

    @property
    @pulumi.getter(name="smsMessage")
    def sms_message(self) -> Optional[pulumi.Input[str]]:
        """
        SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
        """
        return pulumi.get(self, "sms_message")

    @sms_message.setter
    def sms_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sms_message", value)


