# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 artifacts: pulumi.Input['ProjectArtifactsArgs'],
                 environment: pulumi.Input['ProjectEnvironmentArgs'],
                 service_role: pulumi.Input[str],
                 source: pulumi.Input['ProjectSourceArgs'],
                 badge_enabled: Optional[pulumi.Input[bool]] = None,
                 build_batch_config: Optional[pulumi.Input['ProjectBuildBatchConfigArgs']] = None,
                 build_timeout: Optional[pulumi.Input[int]] = None,
                 cache: Optional[pulumi.Input['ProjectCacheArgs']] = None,
                 concurrent_build_limit: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]] = None,
                 logs_config: Optional[pulumi.Input['ProjectLogsConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_visibility: Optional[pulumi.Input[str]] = None,
                 queued_timeout: Optional[pulumi.Input[int]] = None,
                 resource_access_role: Optional[pulumi.Input[str]] = None,
                 secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]] = None,
                 secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]] = None,
                 secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]] = None,
                 source_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_config: Optional[pulumi.Input['ProjectVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input['ProjectArtifactsArgs'] artifacts: Configuration block. Detailed below.
        :param pulumi.Input['ProjectEnvironmentArgs'] environment: Configuration block. Detailed below.
        :param pulumi.Input[str] service_role: Specifies the service role ARN for the batch build project.
        :param pulumi.Input['ProjectSourceArgs'] source: Configuration block. Detailed below.
        :param pulumi.Input[bool] badge_enabled: Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
        :param pulumi.Input['ProjectBuildBatchConfigArgs'] build_batch_config: Defines the batch build options for the project.
        :param pulumi.Input[int] build_timeout: Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
        :param pulumi.Input['ProjectCacheArgs'] cache: Configuration block. Detailed below.
        :param pulumi.Input[int] concurrent_build_limit: Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
        :param pulumi.Input[str] description: Short description of the project.
        :param pulumi.Input[str] encryption_key: AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]] file_system_locations: A set of file system locations to to mount inside the build. File system locations are documented below.
        :param pulumi.Input['ProjectLogsConfigArgs'] logs_config: Configuration block. Detailed below.
        :param pulumi.Input[str] name: Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        :param pulumi.Input[str] project_visibility: Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
        :param pulumi.Input[int] queued_timeout: Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
        :param pulumi.Input[str] resource_access_role: The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]] secondary_artifacts: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]] secondary_source_versions: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]] secondary_sources: Configuration block. Detailed below.
        :param pulumi.Input[str] source_version: The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['ProjectVpcConfigArgs'] vpc_config: Configuration block. Detailed below.
        """
        pulumi.set(__self__, "artifacts", artifacts)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "service_role", service_role)
        pulumi.set(__self__, "source", source)
        if badge_enabled is not None:
            pulumi.set(__self__, "badge_enabled", badge_enabled)
        if build_batch_config is not None:
            pulumi.set(__self__, "build_batch_config", build_batch_config)
        if build_timeout is not None:
            pulumi.set(__self__, "build_timeout", build_timeout)
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if concurrent_build_limit is not None:
            pulumi.set(__self__, "concurrent_build_limit", concurrent_build_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if file_system_locations is not None:
            pulumi.set(__self__, "file_system_locations", file_system_locations)
        if logs_config is not None:
            pulumi.set(__self__, "logs_config", logs_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_visibility is not None:
            pulumi.set(__self__, "project_visibility", project_visibility)
        if queued_timeout is not None:
            pulumi.set(__self__, "queued_timeout", queued_timeout)
        if resource_access_role is not None:
            pulumi.set(__self__, "resource_access_role", resource_access_role)
        if secondary_artifacts is not None:
            pulumi.set(__self__, "secondary_artifacts", secondary_artifacts)
        if secondary_source_versions is not None:
            pulumi.set(__self__, "secondary_source_versions", secondary_source_versions)
        if secondary_sources is not None:
            pulumi.set(__self__, "secondary_sources", secondary_sources)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def artifacts(self) -> pulumi.Input['ProjectArtifactsArgs']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: pulumi.Input['ProjectArtifactsArgs']):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input['ProjectEnvironmentArgs']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['ProjectEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Input[str]:
        """
        Specifies the service role ARN for the batch build project.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_role", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['ProjectSourceArgs']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['ProjectSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="badgeEnabled")
    def badge_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
        """
        return pulumi.get(self, "badge_enabled")

    @badge_enabled.setter
    def badge_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "badge_enabled", value)

    @property
    @pulumi.getter(name="buildBatchConfig")
    def build_batch_config(self) -> Optional[pulumi.Input['ProjectBuildBatchConfigArgs']]:
        """
        Defines the batch build options for the project.
        """
        return pulumi.get(self, "build_batch_config")

    @build_batch_config.setter
    def build_batch_config(self, value: Optional[pulumi.Input['ProjectBuildBatchConfigArgs']]):
        pulumi.set(self, "build_batch_config", value)

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
        """
        return pulumi.get(self, "build_timeout")

    @build_timeout.setter
    def build_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "build_timeout", value)

    @property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input['ProjectCacheArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input['ProjectCacheArgs']]):
        pulumi.set(self, "cache", value)

    @property
    @pulumi.getter(name="concurrentBuildLimit")
    def concurrent_build_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
        """
        return pulumi.get(self, "concurrent_build_limit")

    @concurrent_build_limit.setter
    def concurrent_build_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "concurrent_build_limit", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Short description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="fileSystemLocations")
    def file_system_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]]:
        """
        A set of file system locations to to mount inside the build. File system locations are documented below.
        """
        return pulumi.get(self, "file_system_locations")

    @file_system_locations.setter
    def file_system_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]]):
        pulumi.set(self, "file_system_locations", value)

    @property
    @pulumi.getter(name="logsConfig")
    def logs_config(self) -> Optional[pulumi.Input['ProjectLogsConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "logs_config")

    @logs_config.setter
    def logs_config(self, value: Optional[pulumi.Input['ProjectLogsConfigArgs']]):
        pulumi.set(self, "logs_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectVisibility")
    def project_visibility(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
        """
        return pulumi.get(self, "project_visibility")

    @project_visibility.setter
    def project_visibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_visibility", value)

    @property
    @pulumi.getter(name="queuedTimeout")
    def queued_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
        """
        return pulumi.get(self, "queued_timeout")

    @queued_timeout.setter
    def queued_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queued_timeout", value)

    @property
    @pulumi.getter(name="resourceAccessRole")
    def resource_access_role(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
        """
        return pulumi.get(self, "resource_access_role")

    @resource_access_role.setter
    def resource_access_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_access_role", value)

    @property
    @pulumi.getter(name="secondaryArtifacts")
    def secondary_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_artifacts")

    @secondary_artifacts.setter
    def secondary_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]]):
        pulumi.set(self, "secondary_artifacts", value)

    @property
    @pulumi.getter(name="secondarySourceVersions")
    def secondary_source_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_source_versions")

    @secondary_source_versions.setter
    def secondary_source_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]]):
        pulumi.set(self, "secondary_source_versions", value)

    @property
    @pulumi.getter(name="secondarySources")
    def secondary_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_sources")

    @secondary_sources.setter
    def secondary_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]]):
        pulumi.set(self, "secondary_sources", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['ProjectVpcConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['ProjectVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 artifacts: Optional[pulumi.Input['ProjectArtifactsArgs']] = None,
                 badge_enabled: Optional[pulumi.Input[bool]] = None,
                 badge_url: Optional[pulumi.Input[str]] = None,
                 build_batch_config: Optional[pulumi.Input['ProjectBuildBatchConfigArgs']] = None,
                 build_timeout: Optional[pulumi.Input[int]] = None,
                 cache: Optional[pulumi.Input['ProjectCacheArgs']] = None,
                 concurrent_build_limit: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input['ProjectEnvironmentArgs']] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]] = None,
                 logs_config: Optional[pulumi.Input['ProjectLogsConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_visibility: Optional[pulumi.Input[str]] = None,
                 public_project_alias: Optional[pulumi.Input[str]] = None,
                 queued_timeout: Optional[pulumi.Input[int]] = None,
                 resource_access_role: Optional[pulumi.Input[str]] = None,
                 secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]] = None,
                 secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]] = None,
                 secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['ProjectSourceArgs']] = None,
                 source_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_config: Optional[pulumi.Input['ProjectVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[str] arn: ARN of the CodeBuild project.
        :param pulumi.Input['ProjectArtifactsArgs'] artifacts: Configuration block. Detailed below.
        :param pulumi.Input[bool] badge_enabled: Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
        :param pulumi.Input[str] badge_url: URL of the build badge when `badge_enabled` is enabled.
        :param pulumi.Input['ProjectBuildBatchConfigArgs'] build_batch_config: Defines the batch build options for the project.
        :param pulumi.Input[int] build_timeout: Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
        :param pulumi.Input['ProjectCacheArgs'] cache: Configuration block. Detailed below.
        :param pulumi.Input[int] concurrent_build_limit: Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
        :param pulumi.Input[str] description: Short description of the project.
        :param pulumi.Input[str] encryption_key: AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
        :param pulumi.Input['ProjectEnvironmentArgs'] environment: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]] file_system_locations: A set of file system locations to to mount inside the build. File system locations are documented below.
        :param pulumi.Input['ProjectLogsConfigArgs'] logs_config: Configuration block. Detailed below.
        :param pulumi.Input[str] name: Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        :param pulumi.Input[str] project_visibility: Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
        :param pulumi.Input[str] public_project_alias: The project identifier used with the public build APIs.
        :param pulumi.Input[int] queued_timeout: Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
        :param pulumi.Input[str] resource_access_role: The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]] secondary_artifacts: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]] secondary_source_versions: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]] secondary_sources: Configuration block. Detailed below.
        :param pulumi.Input[str] service_role: Specifies the service role ARN for the batch build project.
        :param pulumi.Input['ProjectSourceArgs'] source: Configuration block. Detailed below.
        :param pulumi.Input[str] source_version: The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['ProjectVpcConfigArgs'] vpc_config: Configuration block. Detailed below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if badge_enabled is not None:
            pulumi.set(__self__, "badge_enabled", badge_enabled)
        if badge_url is not None:
            pulumi.set(__self__, "badge_url", badge_url)
        if build_batch_config is not None:
            pulumi.set(__self__, "build_batch_config", build_batch_config)
        if build_timeout is not None:
            pulumi.set(__self__, "build_timeout", build_timeout)
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if concurrent_build_limit is not None:
            pulumi.set(__self__, "concurrent_build_limit", concurrent_build_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if file_system_locations is not None:
            pulumi.set(__self__, "file_system_locations", file_system_locations)
        if logs_config is not None:
            pulumi.set(__self__, "logs_config", logs_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_visibility is not None:
            pulumi.set(__self__, "project_visibility", project_visibility)
        if public_project_alias is not None:
            pulumi.set(__self__, "public_project_alias", public_project_alias)
        if queued_timeout is not None:
            pulumi.set(__self__, "queued_timeout", queued_timeout)
        if resource_access_role is not None:
            pulumi.set(__self__, "resource_access_role", resource_access_role)
        if secondary_artifacts is not None:
            pulumi.set(__self__, "secondary_artifacts", secondary_artifacts)
        if secondary_source_versions is not None:
            pulumi.set(__self__, "secondary_source_versions", secondary_source_versions)
        if secondary_sources is not None:
            pulumi.set(__self__, "secondary_sources", secondary_sources)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the CodeBuild project.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input['ProjectArtifactsArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input['ProjectArtifactsArgs']]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="badgeEnabled")
    def badge_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
        """
        return pulumi.get(self, "badge_enabled")

    @badge_enabled.setter
    def badge_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "badge_enabled", value)

    @property
    @pulumi.getter(name="badgeUrl")
    def badge_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the build badge when `badge_enabled` is enabled.
        """
        return pulumi.get(self, "badge_url")

    @badge_url.setter
    def badge_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "badge_url", value)

    @property
    @pulumi.getter(name="buildBatchConfig")
    def build_batch_config(self) -> Optional[pulumi.Input['ProjectBuildBatchConfigArgs']]:
        """
        Defines the batch build options for the project.
        """
        return pulumi.get(self, "build_batch_config")

    @build_batch_config.setter
    def build_batch_config(self, value: Optional[pulumi.Input['ProjectBuildBatchConfigArgs']]):
        pulumi.set(self, "build_batch_config", value)

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
        """
        return pulumi.get(self, "build_timeout")

    @build_timeout.setter
    def build_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "build_timeout", value)

    @property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input['ProjectCacheArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input['ProjectCacheArgs']]):
        pulumi.set(self, "cache", value)

    @property
    @pulumi.getter(name="concurrentBuildLimit")
    def concurrent_build_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
        """
        return pulumi.get(self, "concurrent_build_limit")

    @concurrent_build_limit.setter
    def concurrent_build_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "concurrent_build_limit", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Short description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['ProjectEnvironmentArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['ProjectEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="fileSystemLocations")
    def file_system_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]]:
        """
        A set of file system locations to to mount inside the build. File system locations are documented below.
        """
        return pulumi.get(self, "file_system_locations")

    @file_system_locations.setter
    def file_system_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]]):
        pulumi.set(self, "file_system_locations", value)

    @property
    @pulumi.getter(name="logsConfig")
    def logs_config(self) -> Optional[pulumi.Input['ProjectLogsConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "logs_config")

    @logs_config.setter
    def logs_config(self, value: Optional[pulumi.Input['ProjectLogsConfigArgs']]):
        pulumi.set(self, "logs_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectVisibility")
    def project_visibility(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
        """
        return pulumi.get(self, "project_visibility")

    @project_visibility.setter
    def project_visibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_visibility", value)

    @property
    @pulumi.getter(name="publicProjectAlias")
    def public_project_alias(self) -> Optional[pulumi.Input[str]]:
        """
        The project identifier used with the public build APIs.
        """
        return pulumi.get(self, "public_project_alias")

    @public_project_alias.setter
    def public_project_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_project_alias", value)

    @property
    @pulumi.getter(name="queuedTimeout")
    def queued_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
        """
        return pulumi.get(self, "queued_timeout")

    @queued_timeout.setter
    def queued_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queued_timeout", value)

    @property
    @pulumi.getter(name="resourceAccessRole")
    def resource_access_role(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
        """
        return pulumi.get(self, "resource_access_role")

    @resource_access_role.setter
    def resource_access_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_access_role", value)

    @property
    @pulumi.getter(name="secondaryArtifacts")
    def secondary_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_artifacts")

    @secondary_artifacts.setter
    def secondary_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]]):
        pulumi.set(self, "secondary_artifacts", value)

    @property
    @pulumi.getter(name="secondarySourceVersions")
    def secondary_source_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_source_versions")

    @secondary_source_versions.setter
    def secondary_source_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]]):
        pulumi.set(self, "secondary_source_versions", value)

    @property
    @pulumi.getter(name="secondarySources")
    def secondary_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_sources")

    @secondary_sources.setter
    def secondary_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]]):
        pulumi.set(self, "secondary_sources", value)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the service role ARN for the batch build project.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_role", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['ProjectSourceArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['ProjectSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['ProjectVpcConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['ProjectVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifacts: Optional[pulumi.Input[pulumi.InputType['ProjectArtifactsArgs']]] = None,
                 badge_enabled: Optional[pulumi.Input[bool]] = None,
                 build_batch_config: Optional[pulumi.Input[pulumi.InputType['ProjectBuildBatchConfigArgs']]] = None,
                 build_timeout: Optional[pulumi.Input[int]] = None,
                 cache: Optional[pulumi.Input[pulumi.InputType['ProjectCacheArgs']]] = None,
                 concurrent_build_limit: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']]] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectFileSystemLocationArgs']]]]] = None,
                 logs_config: Optional[pulumi.Input[pulumi.InputType['ProjectLogsConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_visibility: Optional[pulumi.Input[str]] = None,
                 queued_timeout: Optional[pulumi.Input[int]] = None,
                 resource_access_role: Optional[pulumi.Input[str]] = None,
                 secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondaryArtifactArgs']]]]] = None,
                 secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceVersionArgs']]]]] = None,
                 secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceArgs']]]]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['ProjectSourceArgs']]] = None,
                 source_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_config: Optional[pulumi.Input[pulumi.InputType['ProjectVpcConfigArgs']]] = None,
                 __props__=None):
        """
        Provides a CodeBuild Project resource. See also the `codebuild.Webhook` resource, which manages the webhook to the source (e.g., the "rebuild every time a code change is pushed" option in the CodeBuild web console).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket_v2 = aws.s3.BucketV2("exampleBucketV2")
        example_bucket_acl_v2 = aws.s3.BucketAclV2("exampleBucketAclV2",
            bucket=example_bucket_v2.id,
            acl="private")
        example_role = aws.iam.Role("exampleRole", assume_role_policy=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Effect": "Allow",
              "Principal": {
                "Service": "codebuild.amazonaws.com"
              },
              "Action": "sts:AssumeRole"
            }
          ]
        }
        \"\"\")
        example_role_policy = aws.iam.RolePolicy("exampleRolePolicy",
            role=example_role.name,
            policy=pulumi.Output.all(example_bucket_v2.arn, example_bucket_v2.arn).apply(lambda exampleBucketV2Arn, exampleBucketV2Arn1: f\"\"\"{{
          "Version": "2012-10-17",
          "Statement": [
            {{
              "Effect": "Allow",
              "Resource": [
                "*"
              ],
              "Action": [
                "logs:CreateLogGroup",
                "logs:CreateLogStream",
                "logs:PutLogEvents"
              ]
            }},
            {{
              "Effect": "Allow",
              "Action": [
                "ec2:CreateNetworkInterface",
                "ec2:DescribeDhcpOptions",
                "ec2:DescribeNetworkInterfaces",
                "ec2:DeleteNetworkInterface",
                "ec2:DescribeSubnets",
                "ec2:DescribeSecurityGroups",
                "ec2:DescribeVpcs"
              ],
              "Resource": "*"
            }},
            {{
              "Effect": "Allow",
              "Action": [
                "ec2:CreateNetworkInterfacePermission"
              ],
              "Resource": [
                "arn:aws:ec2:us-east-1:123456789012:network-interface/*"
              ],
              "Condition": {{
                "StringEquals": {{
                  "ec2:Subnet": [
                    "{aws_subnet["example1"]["arn"]}",
                    "{aws_subnet["example2"]["arn"]}"
                  ],
                  "ec2:AuthorizedService": "codebuild.amazonaws.com"
                }}
              }}
            }},
            {{
              "Effect": "Allow",
              "Action": [
                "s3:*"
              ],
              "Resource": [
                "{example_bucket_v2_arn}",
                "{example_bucket_v2_arn1}/*"
              ]
            }}
          ]
        }}
        \"\"\"))
        example_project = aws.codebuild.Project("exampleProject",
            description="test_codebuild_project",
            build_timeout=5,
            service_role=example_role.arn,
            artifacts=aws.codebuild.ProjectArtifactsArgs(
                type="NO_ARTIFACTS",
            ),
            cache=aws.codebuild.ProjectCacheArgs(
                type="S3",
                location=example_bucket_v2.bucket,
            ),
            environment=aws.codebuild.ProjectEnvironmentArgs(
                compute_type="BUILD_GENERAL1_SMALL",
                image="aws/codebuild/standard:1.0",
                type="LINUX_CONTAINER",
                image_pull_credentials_type="CODEBUILD",
                environment_variables=[
                    aws.codebuild.ProjectEnvironmentEnvironmentVariableArgs(
                        name="SOME_KEY1",
                        value="SOME_VALUE1",
                    ),
                    aws.codebuild.ProjectEnvironmentEnvironmentVariableArgs(
                        name="SOME_KEY2",
                        value="SOME_VALUE2",
                        type="PARAMETER_STORE",
                    ),
                ],
            ),
            logs_config=aws.codebuild.ProjectLogsConfigArgs(
                cloudwatch_logs=aws.codebuild.ProjectLogsConfigCloudwatchLogsArgs(
                    group_name="log-group",
                    stream_name="log-stream",
                ),
                s3_logs=aws.codebuild.ProjectLogsConfigS3LogsArgs(
                    status="ENABLED",
                    location=example_bucket_v2.id.apply(lambda id: f"{id}/build-log"),
                ),
            ),
            source=aws.codebuild.ProjectSourceArgs(
                type="GITHUB",
                location="https://github.com/mitchellh/packer.git",
                git_clone_depth=1,
                git_submodules_config=aws.codebuild.ProjectSourceGitSubmodulesConfigArgs(
                    fetch_submodules=True,
                ),
            ),
            source_version="master",
            vpc_config=aws.codebuild.ProjectVpcConfigArgs(
                vpc_id=aws_vpc["example"]["id"],
                subnets=[
                    aws_subnet["example1"]["id"],
                    aws_subnet["example2"]["id"],
                ],
                security_group_ids=[
                    aws_security_group["example1"]["id"],
                    aws_security_group["example2"]["id"],
                ],
            ),
            tags={
                "Environment": "Test",
            })
        project_with_cache = aws.codebuild.Project("project-with-cache",
            description="test_codebuild_project_cache",
            build_timeout=5,
            queued_timeout=5,
            service_role=example_role.arn,
            artifacts=aws.codebuild.ProjectArtifactsArgs(
                type="NO_ARTIFACTS",
            ),
            cache=aws.codebuild.ProjectCacheArgs(
                type="LOCAL",
                modes=[
                    "LOCAL_DOCKER_LAYER_CACHE",
                    "LOCAL_SOURCE_CACHE",
                ],
            ),
            environment=aws.codebuild.ProjectEnvironmentArgs(
                compute_type="BUILD_GENERAL1_SMALL",
                image="aws/codebuild/standard:1.0",
                type="LINUX_CONTAINER",
                image_pull_credentials_type="CODEBUILD",
                environment_variables=[aws.codebuild.ProjectEnvironmentEnvironmentVariableArgs(
                    name="SOME_KEY1",
                    value="SOME_VALUE1",
                )],
            ),
            source=aws.codebuild.ProjectSourceArgs(
                type="GITHUB",
                location="https://github.com/mitchellh/packer.git",
                git_clone_depth=1,
            ),
            tags={
                "Environment": "Test",
            })
        ```

        ## Import

        CodeBuild Project can be imported using the `name`, e.g.,

        ```sh
         $ pulumi import aws:codebuild/project:Project name project-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ProjectArtifactsArgs']] artifacts: Configuration block. Detailed below.
        :param pulumi.Input[bool] badge_enabled: Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
        :param pulumi.Input[pulumi.InputType['ProjectBuildBatchConfigArgs']] build_batch_config: Defines the batch build options for the project.
        :param pulumi.Input[int] build_timeout: Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
        :param pulumi.Input[pulumi.InputType['ProjectCacheArgs']] cache: Configuration block. Detailed below.
        :param pulumi.Input[int] concurrent_build_limit: Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
        :param pulumi.Input[str] description: Short description of the project.
        :param pulumi.Input[str] encryption_key: AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
        :param pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']] environment: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectFileSystemLocationArgs']]]] file_system_locations: A set of file system locations to to mount inside the build. File system locations are documented below.
        :param pulumi.Input[pulumi.InputType['ProjectLogsConfigArgs']] logs_config: Configuration block. Detailed below.
        :param pulumi.Input[str] name: Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        :param pulumi.Input[str] project_visibility: Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
        :param pulumi.Input[int] queued_timeout: Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
        :param pulumi.Input[str] resource_access_role: The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondaryArtifactArgs']]]] secondary_artifacts: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceVersionArgs']]]] secondary_source_versions: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceArgs']]]] secondary_sources: Configuration block. Detailed below.
        :param pulumi.Input[str] service_role: Specifies the service role ARN for the batch build project.
        :param pulumi.Input[pulumi.InputType['ProjectSourceArgs']] source: Configuration block. Detailed below.
        :param pulumi.Input[str] source_version: The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[pulumi.InputType['ProjectVpcConfigArgs']] vpc_config: Configuration block. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CodeBuild Project resource. See also the `codebuild.Webhook` resource, which manages the webhook to the source (e.g., the "rebuild every time a code change is pushed" option in the CodeBuild web console).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket_v2 = aws.s3.BucketV2("exampleBucketV2")
        example_bucket_acl_v2 = aws.s3.BucketAclV2("exampleBucketAclV2",
            bucket=example_bucket_v2.id,
            acl="private")
        example_role = aws.iam.Role("exampleRole", assume_role_policy=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Effect": "Allow",
              "Principal": {
                "Service": "codebuild.amazonaws.com"
              },
              "Action": "sts:AssumeRole"
            }
          ]
        }
        \"\"\")
        example_role_policy = aws.iam.RolePolicy("exampleRolePolicy",
            role=example_role.name,
            policy=pulumi.Output.all(example_bucket_v2.arn, example_bucket_v2.arn).apply(lambda exampleBucketV2Arn, exampleBucketV2Arn1: f\"\"\"{{
          "Version": "2012-10-17",
          "Statement": [
            {{
              "Effect": "Allow",
              "Resource": [
                "*"
              ],
              "Action": [
                "logs:CreateLogGroup",
                "logs:CreateLogStream",
                "logs:PutLogEvents"
              ]
            }},
            {{
              "Effect": "Allow",
              "Action": [
                "ec2:CreateNetworkInterface",
                "ec2:DescribeDhcpOptions",
                "ec2:DescribeNetworkInterfaces",
                "ec2:DeleteNetworkInterface",
                "ec2:DescribeSubnets",
                "ec2:DescribeSecurityGroups",
                "ec2:DescribeVpcs"
              ],
              "Resource": "*"
            }},
            {{
              "Effect": "Allow",
              "Action": [
                "ec2:CreateNetworkInterfacePermission"
              ],
              "Resource": [
                "arn:aws:ec2:us-east-1:123456789012:network-interface/*"
              ],
              "Condition": {{
                "StringEquals": {{
                  "ec2:Subnet": [
                    "{aws_subnet["example1"]["arn"]}",
                    "{aws_subnet["example2"]["arn"]}"
                  ],
                  "ec2:AuthorizedService": "codebuild.amazonaws.com"
                }}
              }}
            }},
            {{
              "Effect": "Allow",
              "Action": [
                "s3:*"
              ],
              "Resource": [
                "{example_bucket_v2_arn}",
                "{example_bucket_v2_arn1}/*"
              ]
            }}
          ]
        }}
        \"\"\"))
        example_project = aws.codebuild.Project("exampleProject",
            description="test_codebuild_project",
            build_timeout=5,
            service_role=example_role.arn,
            artifacts=aws.codebuild.ProjectArtifactsArgs(
                type="NO_ARTIFACTS",
            ),
            cache=aws.codebuild.ProjectCacheArgs(
                type="S3",
                location=example_bucket_v2.bucket,
            ),
            environment=aws.codebuild.ProjectEnvironmentArgs(
                compute_type="BUILD_GENERAL1_SMALL",
                image="aws/codebuild/standard:1.0",
                type="LINUX_CONTAINER",
                image_pull_credentials_type="CODEBUILD",
                environment_variables=[
                    aws.codebuild.ProjectEnvironmentEnvironmentVariableArgs(
                        name="SOME_KEY1",
                        value="SOME_VALUE1",
                    ),
                    aws.codebuild.ProjectEnvironmentEnvironmentVariableArgs(
                        name="SOME_KEY2",
                        value="SOME_VALUE2",
                        type="PARAMETER_STORE",
                    ),
                ],
            ),
            logs_config=aws.codebuild.ProjectLogsConfigArgs(
                cloudwatch_logs=aws.codebuild.ProjectLogsConfigCloudwatchLogsArgs(
                    group_name="log-group",
                    stream_name="log-stream",
                ),
                s3_logs=aws.codebuild.ProjectLogsConfigS3LogsArgs(
                    status="ENABLED",
                    location=example_bucket_v2.id.apply(lambda id: f"{id}/build-log"),
                ),
            ),
            source=aws.codebuild.ProjectSourceArgs(
                type="GITHUB",
                location="https://github.com/mitchellh/packer.git",
                git_clone_depth=1,
                git_submodules_config=aws.codebuild.ProjectSourceGitSubmodulesConfigArgs(
                    fetch_submodules=True,
                ),
            ),
            source_version="master",
            vpc_config=aws.codebuild.ProjectVpcConfigArgs(
                vpc_id=aws_vpc["example"]["id"],
                subnets=[
                    aws_subnet["example1"]["id"],
                    aws_subnet["example2"]["id"],
                ],
                security_group_ids=[
                    aws_security_group["example1"]["id"],
                    aws_security_group["example2"]["id"],
                ],
            ),
            tags={
                "Environment": "Test",
            })
        project_with_cache = aws.codebuild.Project("project-with-cache",
            description="test_codebuild_project_cache",
            build_timeout=5,
            queued_timeout=5,
            service_role=example_role.arn,
            artifacts=aws.codebuild.ProjectArtifactsArgs(
                type="NO_ARTIFACTS",
            ),
            cache=aws.codebuild.ProjectCacheArgs(
                type="LOCAL",
                modes=[
                    "LOCAL_DOCKER_LAYER_CACHE",
                    "LOCAL_SOURCE_CACHE",
                ],
            ),
            environment=aws.codebuild.ProjectEnvironmentArgs(
                compute_type="BUILD_GENERAL1_SMALL",
                image="aws/codebuild/standard:1.0",
                type="LINUX_CONTAINER",
                image_pull_credentials_type="CODEBUILD",
                environment_variables=[aws.codebuild.ProjectEnvironmentEnvironmentVariableArgs(
                    name="SOME_KEY1",
                    value="SOME_VALUE1",
                )],
            ),
            source=aws.codebuild.ProjectSourceArgs(
                type="GITHUB",
                location="https://github.com/mitchellh/packer.git",
                git_clone_depth=1,
            ),
            tags={
                "Environment": "Test",
            })
        ```

        ## Import

        CodeBuild Project can be imported using the `name`, e.g.,

        ```sh
         $ pulumi import aws:codebuild/project:Project name project-name
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifacts: Optional[pulumi.Input[pulumi.InputType['ProjectArtifactsArgs']]] = None,
                 badge_enabled: Optional[pulumi.Input[bool]] = None,
                 build_batch_config: Optional[pulumi.Input[pulumi.InputType['ProjectBuildBatchConfigArgs']]] = None,
                 build_timeout: Optional[pulumi.Input[int]] = None,
                 cache: Optional[pulumi.Input[pulumi.InputType['ProjectCacheArgs']]] = None,
                 concurrent_build_limit: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']]] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectFileSystemLocationArgs']]]]] = None,
                 logs_config: Optional[pulumi.Input[pulumi.InputType['ProjectLogsConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_visibility: Optional[pulumi.Input[str]] = None,
                 queued_timeout: Optional[pulumi.Input[int]] = None,
                 resource_access_role: Optional[pulumi.Input[str]] = None,
                 secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondaryArtifactArgs']]]]] = None,
                 secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceVersionArgs']]]]] = None,
                 secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceArgs']]]]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['ProjectSourceArgs']]] = None,
                 source_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_config: Optional[pulumi.Input[pulumi.InputType['ProjectVpcConfigArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            if artifacts is None and not opts.urn:
                raise TypeError("Missing required property 'artifacts'")
            __props__.__dict__["artifacts"] = artifacts
            __props__.__dict__["badge_enabled"] = badge_enabled
            __props__.__dict__["build_batch_config"] = build_batch_config
            __props__.__dict__["build_timeout"] = build_timeout
            __props__.__dict__["cache"] = cache
            __props__.__dict__["concurrent_build_limit"] = concurrent_build_limit
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_key"] = encryption_key
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["file_system_locations"] = file_system_locations
            __props__.__dict__["logs_config"] = logs_config
            __props__.__dict__["name"] = name
            __props__.__dict__["project_visibility"] = project_visibility
            __props__.__dict__["queued_timeout"] = queued_timeout
            __props__.__dict__["resource_access_role"] = resource_access_role
            __props__.__dict__["secondary_artifacts"] = secondary_artifacts
            __props__.__dict__["secondary_source_versions"] = secondary_source_versions
            __props__.__dict__["secondary_sources"] = secondary_sources
            if service_role is None and not opts.urn:
                raise TypeError("Missing required property 'service_role'")
            __props__.__dict__["service_role"] = service_role
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["source_version"] = source_version
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["badge_url"] = None
            __props__.__dict__["public_project_alias"] = None
            __props__.__dict__["tags_all"] = None
        super(Project, __self__).__init__(
            'aws:codebuild/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            artifacts: Optional[pulumi.Input[pulumi.InputType['ProjectArtifactsArgs']]] = None,
            badge_enabled: Optional[pulumi.Input[bool]] = None,
            badge_url: Optional[pulumi.Input[str]] = None,
            build_batch_config: Optional[pulumi.Input[pulumi.InputType['ProjectBuildBatchConfigArgs']]] = None,
            build_timeout: Optional[pulumi.Input[int]] = None,
            cache: Optional[pulumi.Input[pulumi.InputType['ProjectCacheArgs']]] = None,
            concurrent_build_limit: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            encryption_key: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']]] = None,
            file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectFileSystemLocationArgs']]]]] = None,
            logs_config: Optional[pulumi.Input[pulumi.InputType['ProjectLogsConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_visibility: Optional[pulumi.Input[str]] = None,
            public_project_alias: Optional[pulumi.Input[str]] = None,
            queued_timeout: Optional[pulumi.Input[int]] = None,
            resource_access_role: Optional[pulumi.Input[str]] = None,
            secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondaryArtifactArgs']]]]] = None,
            secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceVersionArgs']]]]] = None,
            secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceArgs']]]]] = None,
            service_role: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[pulumi.InputType['ProjectSourceArgs']]] = None,
            source_version: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_config: Optional[pulumi.Input[pulumi.InputType['ProjectVpcConfigArgs']]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the CodeBuild project.
        :param pulumi.Input[pulumi.InputType['ProjectArtifactsArgs']] artifacts: Configuration block. Detailed below.
        :param pulumi.Input[bool] badge_enabled: Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
        :param pulumi.Input[str] badge_url: URL of the build badge when `badge_enabled` is enabled.
        :param pulumi.Input[pulumi.InputType['ProjectBuildBatchConfigArgs']] build_batch_config: Defines the batch build options for the project.
        :param pulumi.Input[int] build_timeout: Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
        :param pulumi.Input[pulumi.InputType['ProjectCacheArgs']] cache: Configuration block. Detailed below.
        :param pulumi.Input[int] concurrent_build_limit: Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
        :param pulumi.Input[str] description: Short description of the project.
        :param pulumi.Input[str] encryption_key: AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
        :param pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']] environment: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectFileSystemLocationArgs']]]] file_system_locations: A set of file system locations to to mount inside the build. File system locations are documented below.
        :param pulumi.Input[pulumi.InputType['ProjectLogsConfigArgs']] logs_config: Configuration block. Detailed below.
        :param pulumi.Input[str] name: Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        :param pulumi.Input[str] project_visibility: Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
        :param pulumi.Input[str] public_project_alias: The project identifier used with the public build APIs.
        :param pulumi.Input[int] queued_timeout: Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
        :param pulumi.Input[str] resource_access_role: The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondaryArtifactArgs']]]] secondary_artifacts: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceVersionArgs']]]] secondary_source_versions: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectSecondarySourceArgs']]]] secondary_sources: Configuration block. Detailed below.
        :param pulumi.Input[str] service_role: Specifies the service role ARN for the batch build project.
        :param pulumi.Input[pulumi.InputType['ProjectSourceArgs']] source: Configuration block. Detailed below.
        :param pulumi.Input[str] source_version: The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[pulumi.InputType['ProjectVpcConfigArgs']] vpc_config: Configuration block. Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["artifacts"] = artifacts
        __props__.__dict__["badge_enabled"] = badge_enabled
        __props__.__dict__["badge_url"] = badge_url
        __props__.__dict__["build_batch_config"] = build_batch_config
        __props__.__dict__["build_timeout"] = build_timeout
        __props__.__dict__["cache"] = cache
        __props__.__dict__["concurrent_build_limit"] = concurrent_build_limit
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["environment"] = environment
        __props__.__dict__["file_system_locations"] = file_system_locations
        __props__.__dict__["logs_config"] = logs_config
        __props__.__dict__["name"] = name
        __props__.__dict__["project_visibility"] = project_visibility
        __props__.__dict__["public_project_alias"] = public_project_alias
        __props__.__dict__["queued_timeout"] = queued_timeout
        __props__.__dict__["resource_access_role"] = resource_access_role
        __props__.__dict__["secondary_artifacts"] = secondary_artifacts
        __props__.__dict__["secondary_source_versions"] = secondary_source_versions
        __props__.__dict__["secondary_sources"] = secondary_sources
        __props__.__dict__["service_role"] = service_role
        __props__.__dict__["source"] = source
        __props__.__dict__["source_version"] = source_version
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_config"] = vpc_config
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the CodeBuild project.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def artifacts(self) -> pulumi.Output['outputs.ProjectArtifacts']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="badgeEnabled")
    def badge_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
        """
        return pulumi.get(self, "badge_enabled")

    @property
    @pulumi.getter(name="badgeUrl")
    def badge_url(self) -> pulumi.Output[str]:
        """
        URL of the build badge when `badge_enabled` is enabled.
        """
        return pulumi.get(self, "badge_url")

    @property
    @pulumi.getter(name="buildBatchConfig")
    def build_batch_config(self) -> pulumi.Output[Optional['outputs.ProjectBuildBatchConfig']]:
        """
        Defines the batch build options for the project.
        """
        return pulumi.get(self, "build_batch_config")

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
        """
        return pulumi.get(self, "build_timeout")

    @property
    @pulumi.getter
    def cache(self) -> pulumi.Output[Optional['outputs.ProjectCache']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "cache")

    @property
    @pulumi.getter(name="concurrentBuildLimit")
    def concurrent_build_limit(self) -> pulumi.Output[Optional[int]]:
        """
        Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
        """
        return pulumi.get(self, "concurrent_build_limit")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Short description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[str]:
        """
        AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.ProjectEnvironment']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="fileSystemLocations")
    def file_system_locations(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectFileSystemLocation']]]:
        """
        A set of file system locations to to mount inside the build. File system locations are documented below.
        """
        return pulumi.get(self, "file_system_locations")

    @property
    @pulumi.getter(name="logsConfig")
    def logs_config(self) -> pulumi.Output[Optional['outputs.ProjectLogsConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "logs_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectVisibility")
    def project_visibility(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
        """
        return pulumi.get(self, "project_visibility")

    @property
    @pulumi.getter(name="publicProjectAlias")
    def public_project_alias(self) -> pulumi.Output[str]:
        """
        The project identifier used with the public build APIs.
        """
        return pulumi.get(self, "public_project_alias")

    @property
    @pulumi.getter(name="queuedTimeout")
    def queued_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
        """
        return pulumi.get(self, "queued_timeout")

    @property
    @pulumi.getter(name="resourceAccessRole")
    def resource_access_role(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
        """
        return pulumi.get(self, "resource_access_role")

    @property
    @pulumi.getter(name="secondaryArtifacts")
    def secondary_artifacts(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectSecondaryArtifact']]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_artifacts")

    @property
    @pulumi.getter(name="secondarySourceVersions")
    def secondary_source_versions(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectSecondarySourceVersion']]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_source_versions")

    @property
    @pulumi.getter(name="secondarySources")
    def secondary_sources(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectSecondarySource']]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_sources")

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Output[str]:
        """
        Specifies the service role ARN for the batch build project.
        """
        return pulumi.get(self, "service_role")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.ProjectSource']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> pulumi.Output[Optional[str]]:
        """
        The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
        """
        return pulumi.get(self, "source_version")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.ProjectVpcConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

