# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DomainServiceAccessPolicyArgs', 'DomainServiceAccessPolicy']

@pulumi.input_type
class DomainServiceAccessPolicyArgs:
    def __init__(__self__, *,
                 access_policy: pulumi.Input[str],
                 domain_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a DomainServiceAccessPolicy resource.
        :param pulumi.Input[str] access_policy: The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        :param pulumi.Input[str] domain_name: The CloudSearch domain name the policy applies to.
        """
        pulumi.set(__self__, "access_policy", access_policy)
        pulumi.set(__self__, "domain_name", domain_name)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> pulumi.Input[str]:
        """
        The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_policy", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The CloudSearch domain name the policy applies to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)


@pulumi.input_type
class _DomainServiceAccessPolicyState:
    def __init__(__self__, *,
                 access_policy: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DomainServiceAccessPolicy resources.
        :param pulumi.Input[str] access_policy: The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        :param pulumi.Input[str] domain_name: The CloudSearch domain name the policy applies to.
        """
        if access_policy is not None:
            pulumi.set(__self__, "access_policy", access_policy)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_policy", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The CloudSearch domain name the policy applies to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)


class DomainServiceAccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_domain = aws.cloudsearch.Domain("exampleDomain")
        example_domain_service_access_policy = aws.cloudsearch.DomainServiceAccessPolicy("exampleDomainServiceAccessPolicy",
            domain_name=example_domain.id,
            access_policy=\"\"\"{
          "Version":"2012-10-17",
          "Statement":[{
            "Sid":"search_only",
            "Effect":"Allow",
            "Principal":"*",
            "Action":[
              "cloudsearch:search",
              "cloudsearch:document"
            ],
            "Condition":{"IpAddress":{"aws:SourceIp":"192.0.2.0/32"}}
          }]
        }
        \"\"\")
        ```

        ## Import

        CloudSearch domain service access policies can be imported using the domain name, e.g.,

        ```sh
         $ pulumi import aws:cloudsearch/domainServiceAccessPolicy:DomainServiceAccessPolicy example example-domain
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_policy: The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        :param pulumi.Input[str] domain_name: The CloudSearch domain name the policy applies to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainServiceAccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_domain = aws.cloudsearch.Domain("exampleDomain")
        example_domain_service_access_policy = aws.cloudsearch.DomainServiceAccessPolicy("exampleDomainServiceAccessPolicy",
            domain_name=example_domain.id,
            access_policy=\"\"\"{
          "Version":"2012-10-17",
          "Statement":[{
            "Sid":"search_only",
            "Effect":"Allow",
            "Principal":"*",
            "Action":[
              "cloudsearch:search",
              "cloudsearch:document"
            ],
            "Condition":{"IpAddress":{"aws:SourceIp":"192.0.2.0/32"}}
          }]
        }
        \"\"\")
        ```

        ## Import

        CloudSearch domain service access policies can be imported using the domain name, e.g.,

        ```sh
         $ pulumi import aws:cloudsearch/domainServiceAccessPolicy:DomainServiceAccessPolicy example example-domain
        ```

        :param str resource_name: The name of the resource.
        :param DomainServiceAccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainServiceAccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainServiceAccessPolicyArgs.__new__(DomainServiceAccessPolicyArgs)

            if access_policy is None and not opts.urn:
                raise TypeError("Missing required property 'access_policy'")
            __props__.__dict__["access_policy"] = access_policy
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
        super(DomainServiceAccessPolicy, __self__).__init__(
            'aws:cloudsearch/domainServiceAccessPolicy:DomainServiceAccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None) -> 'DomainServiceAccessPolicy':
        """
        Get an existing DomainServiceAccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_policy: The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        :param pulumi.Input[str] domain_name: The CloudSearch domain name the policy applies to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainServiceAccessPolicyState.__new__(_DomainServiceAccessPolicyState)

        __props__.__dict__["access_policy"] = access_policy
        __props__.__dict__["domain_name"] = domain_name
        return DomainServiceAccessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> pulumi.Output[str]:
        """
        The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        """
        return pulumi.get(self, "access_policy")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The CloudSearch domain name the policy applies to.
        """
        return pulumi.get(self, "domain_name")

