# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CustomDomainAssociationCertificateValidationRecord',
    'ServiceEncryptionConfiguration',
    'ServiceHealthCheckConfiguration',
    'ServiceInstanceConfiguration',
    'ServiceNetworkConfiguration',
    'ServiceNetworkConfigurationEgressConfiguration',
    'ServiceSourceConfiguration',
    'ServiceSourceConfigurationAuthenticationConfiguration',
    'ServiceSourceConfigurationCodeRepository',
    'ServiceSourceConfigurationCodeRepositoryCodeConfiguration',
    'ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues',
    'ServiceSourceConfigurationCodeRepositorySourceCodeVersion',
    'ServiceSourceConfigurationImageRepository',
    'ServiceSourceConfigurationImageRepositoryImageConfiguration',
]

@pulumi.output_type
class CustomDomainAssociationCertificateValidationRecord(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: The certificate CNAME record name.
        :param str status: The current state of the certificate CNAME record validation. It should change to `SUCCESS` after App Runner completes validation with your DNS.
        :param str type: The record type, always `CNAME`.
        :param str value: The certificate CNAME record value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The certificate CNAME record name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The current state of the certificate CNAME record validation. It should change to `SUCCESS` after App Runner completes validation with your DNS.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The record type, always `CNAME`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The certificate CNAME record value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: str):
        """
        :param str kms_key: The ARN of the KMS key used for encryption.
        """
        pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> str:
        """
        The ARN of the KMS key used for encryption.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class ServiceHealthCheckConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHealthCheckConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHealthCheckConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHealthCheckConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 healthy_threshold: Optional[int] = None,
                 interval: Optional[int] = None,
                 path: Optional[str] = None,
                 protocol: Optional[str] = None,
                 timeout: Optional[int] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        :param int healthy_threshold: The number of consecutive checks that must succeed before App Runner decides that the service is healthy. Defaults to 1. Minimum value of 1. Maximum value of 20.
        :param int interval: The time interval, in seconds, between health checks. Defaults to 5. Minimum value of 1. Maximum value of 20.
        :param str path: The URL to send requests to for health checks. Defaults to `/`. Minimum length of 0. Maximum length of 51200.
        :param str protocol: The IP protocol that App Runner uses to perform health checks for your service. Valid values: `TCP`, `HTTP`. Defaults to `TCP`. If you set protocol to `HTTP`, App Runner sends health check requests to the HTTP path specified by `path`.
        :param int timeout: The time, in seconds, to wait for a health check response before deciding it failed. Defaults to 2. Minimum value of  1. Maximum value of 20.
        :param int unhealthy_threshold: The number of consecutive checks that must fail before App Runner decides that the service is unhealthy. Defaults to 5. Minimum value of  1. Maximum value of 20.
        """
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[int]:
        """
        The number of consecutive checks that must succeed before App Runner decides that the service is healthy. Defaults to 1. Minimum value of 1. Maximum value of 20.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The time interval, in seconds, between health checks. Defaults to 5. Minimum value of 1. Maximum value of 20.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The URL to send requests to for health checks. Defaults to `/`. Minimum length of 0. Maximum length of 51200.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The IP protocol that App Runner uses to perform health checks for your service. Valid values: `TCP`, `HTTP`. Defaults to `TCP`. If you set protocol to `HTTP`, App Runner sends health check requests to the HTTP path specified by `path`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The time, in seconds, to wait for a health check response before deciding it failed. Defaults to 2. Minimum value of  1. Maximum value of 20.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        The number of consecutive checks that must fail before App Runner decides that the service is unhealthy. Defaults to 5. Minimum value of  1. Maximum value of 20.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ServiceInstanceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceRoleArn":
            suggest = "instance_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceInstanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceInstanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceInstanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[str] = None,
                 instance_role_arn: Optional[str] = None,
                 memory: Optional[str] = None):
        """
        :param str cpu: The number of CPU units reserved for each instance of your App Runner service represented as a String. Defaults to `1024`. Valid values: `1024|2048|(1|2) vCPU`.
        :param str instance_role_arn: The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any AWS APIs.
        :param str memory: The amount of memory, in MB or GB, reserved for each instance of your App Runner service. Defaults to `2048`. Valid values: `2048|3072|4096|(2|3|4) GB`.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if instance_role_arn is not None:
            pulumi.set(__self__, "instance_role_arn", instance_role_arn)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[str]:
        """
        The number of CPU units reserved for each instance of your App Runner service represented as a String. Defaults to `1024`. Valid values: `1024|2048|(1|2) vCPU`.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="instanceRoleArn")
    def instance_role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any AWS APIs.
        """
        return pulumi.get(self, "instance_role_arn")

    @property
    @pulumi.getter
    def memory(self) -> Optional[str]:
        """
        The amount of memory, in MB or GB, reserved for each instance of your App Runner service. Defaults to `2048`. Valid values: `2048|3072|4096|(2|3|4) GB`.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class ServiceNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressConfiguration":
            suggest = "egress_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_configuration: Optional['outputs.ServiceNetworkConfigurationEgressConfiguration'] = None):
        """
        :param 'ServiceNetworkConfigurationEgressConfigurationArgs' egress_configuration: Network configuration settings for outbound message traffic.
        """
        if egress_configuration is not None:
            pulumi.set(__self__, "egress_configuration", egress_configuration)

    @property
    @pulumi.getter(name="egressConfiguration")
    def egress_configuration(self) -> Optional['outputs.ServiceNetworkConfigurationEgressConfiguration']:
        """
        Network configuration settings for outbound message traffic.
        """
        return pulumi.get(self, "egress_configuration")


@pulumi.output_type
class ServiceNetworkConfigurationEgressConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressType":
            suggest = "egress_type"
        elif key == "vpcConnectorArn":
            suggest = "vpc_connector_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkConfigurationEgressConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkConfigurationEgressConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkConfigurationEgressConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_type: Optional[str] = None,
                 vpc_connector_arn: Optional[str] = None):
        """
        :param str egress_type: The type of egress configuration.Set to DEFAULT for access to resources hosted on public networks.Set to VPC to associate your service to a custom VPC specified by VpcConnectorArn.
        :param str vpc_connector_arn: The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when EgressType = VPC.
        """
        if egress_type is not None:
            pulumi.set(__self__, "egress_type", egress_type)
        if vpc_connector_arn is not None:
            pulumi.set(__self__, "vpc_connector_arn", vpc_connector_arn)

    @property
    @pulumi.getter(name="egressType")
    def egress_type(self) -> Optional[str]:
        """
        The type of egress configuration.Set to DEFAULT for access to resources hosted on public networks.Set to VPC to associate your service to a custom VPC specified by VpcConnectorArn.
        """
        return pulumi.get(self, "egress_type")

    @property
    @pulumi.getter(name="vpcConnectorArn")
    def vpc_connector_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when EgressType = VPC.
        """
        return pulumi.get(self, "vpc_connector_arn")


@pulumi.output_type
class ServiceSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationConfiguration":
            suggest = "authentication_configuration"
        elif key == "autoDeploymentsEnabled":
            suggest = "auto_deployments_enabled"
        elif key == "codeRepository":
            suggest = "code_repository"
        elif key == "imageRepository":
            suggest = "image_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_configuration: Optional['outputs.ServiceSourceConfigurationAuthenticationConfiguration'] = None,
                 auto_deployments_enabled: Optional[bool] = None,
                 code_repository: Optional['outputs.ServiceSourceConfigurationCodeRepository'] = None,
                 image_repository: Optional['outputs.ServiceSourceConfigurationImageRepository'] = None):
        """
        :param 'ServiceSourceConfigurationAuthenticationConfigurationArgs' authentication_configuration: Describes resources needed to authenticate access to some source repositories. See Authentication Configuration below for more details.
        :param bool auto_deployments_enabled: Whether continuous integration from the source repository is enabled for the App Runner service. If set to `true`, each repository change (source code commit or new image version) starts a deployment. Defaults to `true`.
        :param 'ServiceSourceConfigurationCodeRepositoryArgs' code_repository: Description of a source code repository. See Code Repository below for more details.
        :param 'ServiceSourceConfigurationImageRepositoryArgs' image_repository: Description of a source image repository. See Image Repository below for more details.
        """
        if authentication_configuration is not None:
            pulumi.set(__self__, "authentication_configuration", authentication_configuration)
        if auto_deployments_enabled is not None:
            pulumi.set(__self__, "auto_deployments_enabled", auto_deployments_enabled)
        if code_repository is not None:
            pulumi.set(__self__, "code_repository", code_repository)
        if image_repository is not None:
            pulumi.set(__self__, "image_repository", image_repository)

    @property
    @pulumi.getter(name="authenticationConfiguration")
    def authentication_configuration(self) -> Optional['outputs.ServiceSourceConfigurationAuthenticationConfiguration']:
        """
        Describes resources needed to authenticate access to some source repositories. See Authentication Configuration below for more details.
        """
        return pulumi.get(self, "authentication_configuration")

    @property
    @pulumi.getter(name="autoDeploymentsEnabled")
    def auto_deployments_enabled(self) -> Optional[bool]:
        """
        Whether continuous integration from the source repository is enabled for the App Runner service. If set to `true`, each repository change (source code commit or new image version) starts a deployment. Defaults to `true`.
        """
        return pulumi.get(self, "auto_deployments_enabled")

    @property
    @pulumi.getter(name="codeRepository")
    def code_repository(self) -> Optional['outputs.ServiceSourceConfigurationCodeRepository']:
        """
        Description of a source code repository. See Code Repository below for more details.
        """
        return pulumi.get(self, "code_repository")

    @property
    @pulumi.getter(name="imageRepository")
    def image_repository(self) -> Optional['outputs.ServiceSourceConfigurationImageRepository']:
        """
        Description of a source image repository. See Image Repository below for more details.
        """
        return pulumi.get(self, "image_repository")


@pulumi.output_type
class ServiceSourceConfigurationAuthenticationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessRoleArn":
            suggest = "access_role_arn"
        elif key == "connectionArn":
            suggest = "connection_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSourceConfigurationAuthenticationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSourceConfigurationAuthenticationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSourceConfigurationAuthenticationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_role_arn: Optional[str] = None,
                 connection_arn: Optional[str] = None):
        """
        :param str access_role_arn: ARN of the IAM role that grants the App Runner service access to a source repository. Required for ECR image repositories (but not for ECR Public)
        :param str connection_arn: ARN of the App Runner connection that enables the App Runner service to connect to a source repository. Required for GitHub code repositories.
        """
        if access_role_arn is not None:
            pulumi.set(__self__, "access_role_arn", access_role_arn)
        if connection_arn is not None:
            pulumi.set(__self__, "connection_arn", connection_arn)

    @property
    @pulumi.getter(name="accessRoleArn")
    def access_role_arn(self) -> Optional[str]:
        """
        ARN of the IAM role that grants the App Runner service access to a source repository. Required for ECR image repositories (but not for ECR Public)
        """
        return pulumi.get(self, "access_role_arn")

    @property
    @pulumi.getter(name="connectionArn")
    def connection_arn(self) -> Optional[str]:
        """
        ARN of the App Runner connection that enables the App Runner service to connect to a source repository. Required for GitHub code repositories.
        """
        return pulumi.get(self, "connection_arn")


@pulumi.output_type
class ServiceSourceConfigurationCodeRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryUrl":
            suggest = "repository_url"
        elif key == "sourceCodeVersion":
            suggest = "source_code_version"
        elif key == "codeConfiguration":
            suggest = "code_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSourceConfigurationCodeRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSourceConfigurationCodeRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSourceConfigurationCodeRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_url: str,
                 source_code_version: 'outputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersion',
                 code_configuration: Optional['outputs.ServiceSourceConfigurationCodeRepositoryCodeConfiguration'] = None):
        """
        :param str repository_url: The location of the repository that contains the source code.
        :param 'ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs' source_code_version: The version that should be used within the source code repository. See Source Code Version below for more details.
        :param 'ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs' code_configuration: Configuration for building and running the service from a source code repository. See Code Configuration below for more details.
        """
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "source_code_version", source_code_version)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> str:
        """
        The location of the repository that contains the source code.
        """
        return pulumi.get(self, "repository_url")

    @property
    @pulumi.getter(name="sourceCodeVersion")
    def source_code_version(self) -> 'outputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersion':
        """
        The version that should be used within the source code repository. See Source Code Version below for more details.
        """
        return pulumi.get(self, "source_code_version")

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.ServiceSourceConfigurationCodeRepositoryCodeConfiguration']:
        """
        Configuration for building and running the service from a source code repository. See Code Configuration below for more details.
        """
        return pulumi.get(self, "code_configuration")


@pulumi.output_type
class ServiceSourceConfigurationCodeRepositoryCodeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationSource":
            suggest = "configuration_source"
        elif key == "codeConfigurationValues":
            suggest = "code_configuration_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSourceConfigurationCodeRepositoryCodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSourceConfigurationCodeRepositoryCodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSourceConfigurationCodeRepositoryCodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_source: str,
                 code_configuration_values: Optional['outputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues'] = None):
        """
        :param str configuration_source: The source of the App Runner configuration. Valid values: `REPOSITORY`, `API`. Values are interpreted as follows:
        :param 'ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs' code_configuration_values: Basic configuration for building and running the App Runner service. Use this parameter to quickly launch an App Runner service without providing an apprunner.yaml file in the source code repository (or ignoring the file if it exists). See Code Configuration Values below for more details.
        """
        pulumi.set(__self__, "configuration_source", configuration_source)
        if code_configuration_values is not None:
            pulumi.set(__self__, "code_configuration_values", code_configuration_values)

    @property
    @pulumi.getter(name="configurationSource")
    def configuration_source(self) -> str:
        """
        The source of the App Runner configuration. Valid values: `REPOSITORY`, `API`. Values are interpreted as follows:
        """
        return pulumi.get(self, "configuration_source")

    @property
    @pulumi.getter(name="codeConfigurationValues")
    def code_configuration_values(self) -> Optional['outputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues']:
        """
        Basic configuration for building and running the App Runner service. Use this parameter to quickly launch an App Runner service without providing an apprunner.yaml file in the source code repository (or ignoring the file if it exists). See Code Configuration Values below for more details.
        """
        return pulumi.get(self, "code_configuration_values")


@pulumi.output_type
class ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "runtimeEnvironmentVariables":
            suggest = "runtime_environment_variables"
        elif key == "startCommand":
            suggest = "start_command"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 runtime: str,
                 build_command: Optional[str] = None,
                 port: Optional[str] = None,
                 runtime_environment_variables: Optional[Mapping[str, str]] = None,
                 start_command: Optional[str] = None):
        """
        :param str runtime: A runtime environment type for building and running an App Runner service. Represents a programming language runtime. Valid values: `PYTHON_3`, `NODEJS_12`.
        :param str build_command: The command App Runner runs to build your application.
        :param str port: The port that your application listens to in the container. Defaults to `"8080"`.
        :param Mapping[str, str] runtime_environment_variables: Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
        :param str start_command: The command App Runner runs to start your application.
        """
        pulumi.set(__self__, "runtime", runtime)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if runtime_environment_variables is not None:
            pulumi.set(__self__, "runtime_environment_variables", runtime_environment_variables)
        if start_command is not None:
            pulumi.set(__self__, "start_command", start_command)

    @property
    @pulumi.getter
    def runtime(self) -> str:
        """
        A runtime environment type for building and running an App Runner service. Represents a programming language runtime. Valid values: `PYTHON_3`, `NODEJS_12`.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        The command App Runner runs to build your application.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port that your application listens to in the container. Defaults to `"8080"`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="runtimeEnvironmentVariables")
    def runtime_environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
        """
        return pulumi.get(self, "runtime_environment_variables")

    @property
    @pulumi.getter(name="startCommand")
    def start_command(self) -> Optional[str]:
        """
        The command App Runner runs to start your application.
        """
        return pulumi.get(self, "start_command")


@pulumi.output_type
class ServiceSourceConfigurationCodeRepositorySourceCodeVersion(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: The type of version identifier. For a git-based repository, branches represent versions. Valid values: `BRANCH`.
        :param str value: A source code version. For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of version identifier. For a git-based repository, branches represent versions. Valid values: `BRANCH`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A source code version. For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceSourceConfigurationImageRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageIdentifier":
            suggest = "image_identifier"
        elif key == "imageRepositoryType":
            suggest = "image_repository_type"
        elif key == "imageConfiguration":
            suggest = "image_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSourceConfigurationImageRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSourceConfigurationImageRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSourceConfigurationImageRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_identifier: str,
                 image_repository_type: str,
                 image_configuration: Optional['outputs.ServiceSourceConfigurationImageRepositoryImageConfiguration'] = None):
        """
        :param str image_identifier: The identifier of an image. For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the
               image name format, see Pulling an image in the Amazon ECR User Guide.
        :param str image_repository_type: The type of the image repository. This reflects the repository provider and whether the repository is private or public. Valid values: `ECR` , `ECR_PUBLIC`.
        :param 'ServiceSourceConfigurationImageRepositoryImageConfigurationArgs' image_configuration: Configuration for running the identified image. See Image Configuration below for more details.
        """
        pulumi.set(__self__, "image_identifier", image_identifier)
        pulumi.set(__self__, "image_repository_type", image_repository_type)
        if image_configuration is not None:
            pulumi.set(__self__, "image_configuration", image_configuration)

    @property
    @pulumi.getter(name="imageIdentifier")
    def image_identifier(self) -> str:
        """
        The identifier of an image. For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the
        image name format, see Pulling an image in the Amazon ECR User Guide.
        """
        return pulumi.get(self, "image_identifier")

    @property
    @pulumi.getter(name="imageRepositoryType")
    def image_repository_type(self) -> str:
        """
        The type of the image repository. This reflects the repository provider and whether the repository is private or public. Valid values: `ECR` , `ECR_PUBLIC`.
        """
        return pulumi.get(self, "image_repository_type")

    @property
    @pulumi.getter(name="imageConfiguration")
    def image_configuration(self) -> Optional['outputs.ServiceSourceConfigurationImageRepositoryImageConfiguration']:
        """
        Configuration for running the identified image. See Image Configuration below for more details.
        """
        return pulumi.get(self, "image_configuration")


@pulumi.output_type
class ServiceSourceConfigurationImageRepositoryImageConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeEnvironmentVariables":
            suggest = "runtime_environment_variables"
        elif key == "startCommand":
            suggest = "start_command"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSourceConfigurationImageRepositoryImageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSourceConfigurationImageRepositoryImageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSourceConfigurationImageRepositoryImageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Optional[str] = None,
                 runtime_environment_variables: Optional[Mapping[str, str]] = None,
                 start_command: Optional[str] = None):
        """
        :param str port: The port that your application listens to in the container. Defaults to `"8080"`.
        :param Mapping[str, str] runtime_environment_variables: Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
        :param str start_command: A command App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if runtime_environment_variables is not None:
            pulumi.set(__self__, "runtime_environment_variables", runtime_environment_variables)
        if start_command is not None:
            pulumi.set(__self__, "start_command", start_command)

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port that your application listens to in the container. Defaults to `"8080"`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="runtimeEnvironmentVariables")
    def runtime_environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
        """
        return pulumi.get(self, "runtime_environment_variables")

    @property
    @pulumi.getter(name="startCommand")
    def start_command(self) -> Optional[str]:
        """
        A command App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.
        """
        return pulumi.get(self, "start_command")


