# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDnsNamespaceResult',
    'AwaitableGetDnsNamespaceResult',
    'get_dns_namespace',
    'get_dns_namespace_output',
]

@pulumi.output_type
class GetDnsNamespaceResult:
    """
    A collection of values returned by getDnsNamespace.
    """
    def __init__(__self__, arn=None, description=None, hosted_zone=None, id=None, name=None, type=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if hosted_zone and not isinstance(hosted_zone, str):
            raise TypeError("Expected argument 'hosted_zone' to be a str")
        pulumi.set(__self__, "hosted_zone", hosted_zone)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the namespace.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the namespace.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hostedZone")
    def hosted_zone(self) -> str:
        """
        The ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
        """
        return pulumi.get(self, "hosted_zone")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


class AwaitableGetDnsNamespaceResult(GetDnsNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsNamespaceResult(
            arn=self.arn,
            description=self.description,
            hosted_zone=self.hosted_zone,
            id=self.id,
            name=self.name,
            type=self.type)


def get_dns_namespace(name: Optional[str] = None,
                      type: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsNamespaceResult:
    """
    Retrieves information about a Service Discovery private or public DNS namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.servicediscovery.get_dns_namespace(name="example.service.local",
        type="DNS_PRIVATE")
    ```


    :param str name: The name of the namespace.
    :param str type: The type of the namespace. Allowed values are `DNS_PUBLIC` or `DNS_PRIVATE`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['type'] = type
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:servicediscovery/getDnsNamespace:getDnsNamespace', __args__, opts=opts, typ=GetDnsNamespaceResult).value

    return AwaitableGetDnsNamespaceResult(
        arn=__ret__.arn,
        description=__ret__.description,
        hosted_zone=__ret__.hosted_zone,
        id=__ret__.id,
        name=__ret__.name,
        type=__ret__.type)


@_utilities.lift_output_func(get_dns_namespace)
def get_dns_namespace_output(name: Optional[pulumi.Input[str]] = None,
                             type: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDnsNamespaceResult]:
    """
    Retrieves information about a Service Discovery private or public DNS namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.servicediscovery.get_dns_namespace(name="example.service.local",
        type="DNS_PRIVATE")
    ```


    :param str name: The name of the namespace.
    :param str type: The type of the namespace. Allowed values are `DNS_PUBLIC` or `DNS_PRIVATE`.
    """
    ...
