# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketReplicationConfigArgs', 'BucketReplicationConfig']

@pulumi.input_type
class BucketReplicationConfigArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 role: pulumi.Input[str],
                 rules: pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigRuleArgs']]]):
        """
        The set of arguments for constructing a BucketReplicationConfig resource.
        :param pulumi.Input[str] bucket: The name of the source S3 bucket you want Amazon S3 to monitor.
        :param pulumi.Input[str] role: The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        :param pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigRuleArgs']]] rules: Set of configuration blocks describing the rules managing the replication documented below.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of the source S3 bucket you want Amazon S3 to monitor.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigRuleArgs']]]:
        """
        Set of configuration blocks describing the rules managing the replication documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigRuleArgs']]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _BucketReplicationConfigState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering BucketReplicationConfig resources.
        :param pulumi.Input[str] bucket: The name of the source S3 bucket you want Amazon S3 to monitor.
        :param pulumi.Input[str] role: The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        :param pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigRuleArgs']]] rules: Set of configuration blocks describing the rules managing the replication documented below.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the source S3 bucket you want Amazon S3 to monitor.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigRuleArgs']]]]:
        """
        Set of configuration blocks describing the rules managing the replication documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigRuleArgs']]]]):
        pulumi.set(self, "rules", value)


class BucketReplicationConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketReplicationConfigRuleArgs']]]]] = None,
                 __props__=None):
        """
        Provides an independent configuration resource for S3 bucket [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html).

        ## Example Usage
        ### Using replication configuration

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_pulumi as pulumi

        central = pulumi.providers.Aws("central", region="eu-central-1")
        replication_role = aws.iam.Role("replicationRole", assume_role_policy=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Action": "sts:AssumeRole",
              "Principal": {
                "Service": "s3.amazonaws.com"
              },
              "Effect": "Allow",
              "Sid": ""
            }
          ]
        }
        \"\"\")
        destination = aws.s3.Bucket("destination", versioning=aws.s3.BucketVersioningArgs(
            enabled=True,
        ))
        source = aws.s3.Bucket("source",
            acl="private",
            versioning=aws.s3.BucketVersioningArgs(
                enabled=True,
            ),
            opts=pulumi.ResourceOptions(provider=aws["central"]))
        replication_policy = aws.iam.Policy("replicationPolicy", policy=pulumi.Output.all(source.arn, source.arn, destination.arn).apply(lambda sourceArn, sourceArn1, destinationArn: f\"\"\"{{
          "Version": "2012-10-17",
          "Statement": [
            {{
              "Action": [
                "s3:GetReplicationConfiguration",
                "s3:ListBucket"
              ],
              "Effect": "Allow",
              "Resource": [
                "{source_arn}"
              ]
            }},
            {{
              "Action": [
                "s3:GetObjectVersionForReplication",
                "s3:GetObjectVersionAcl",
                 "s3:GetObjectVersionTagging"
              ],
              "Effect": "Allow",
              "Resource": [
                "{source_arn1}/*"
              ]
            }},
            {{
              "Action": [
                "s3:ReplicateObject",
                "s3:ReplicateDelete",
                "s3:ReplicateTags"
              ],
              "Effect": "Allow",
              "Resource": "{destination_arn}/*"
            }}
          ]
        }}
        \"\"\"))
        replication_role_policy_attachment = aws.iam.RolePolicyAttachment("replicationRolePolicyAttachment",
            role=replication_role.name,
            policy_arn=replication_policy.arn)
        replication_bucket_replication_config = aws.s3.BucketReplicationConfig("replicationBucketReplicationConfig",
            role=replication_role.arn,
            bucket=source.id,
            rules=[aws.s3.BucketReplicationConfigRuleArgs(
                id="foobar",
                prefix="foo",
                status="Enabled",
                destination=aws.s3.BucketReplicationConfigRuleDestinationArgs(
                    bucket=destination.arn,
                    storage_class="STANDARD",
                ),
            )])
        ```
        ## Usage Notes

        > **NOTE:** To avoid conflicts always add the following lifecycle object to the `s3.Bucket` resource of the source bucket.

        This resource implements the same features that are provided by the `replication_configuration` object of the `s3.Bucket` resource. To avoid conflicts or unexpected apply results, a lifecycle configuration is needed on the `s3.Bucket` to ignore changes to the internal `replication_configuration` object.  Failure to add the `lifecycle` configuration to the `s3.Bucket` will result in conflicting state results.

        ```python
        import pulumi
        ```

        The `s3.BucketReplicationConfig` resource provides the following features that are not available in the `s3.Bucket` resource:

        * `replica_modifications` - Added to the `source_selection_criteria` configuration object documented below
        * `metrics` - Added to the `destination` configuration object documented below
        * `replication_time` - Added to the `destination` configuration object documented below
        * `existing_object_replication` - Added to the replication rule object documented below

        Replication for existing objects requires activation by AWS Support.  See [userguide/replication-what-is-isnot-replicated](https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-what-is-isnot-replicated.html#existing-object-replication).

        ## Import

        S3 bucket replication configuration can be imported using the `bucket`, e.g.

        ```sh
         $ pulumi import aws:s3/bucketReplicationConfig:BucketReplicationConfig replication bucket-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the source S3 bucket you want Amazon S3 to monitor.
        :param pulumi.Input[str] role: The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketReplicationConfigRuleArgs']]]] rules: Set of configuration blocks describing the rules managing the replication documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketReplicationConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an independent configuration resource for S3 bucket [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html).

        ## Example Usage
        ### Using replication configuration

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_pulumi as pulumi

        central = pulumi.providers.Aws("central", region="eu-central-1")
        replication_role = aws.iam.Role("replicationRole", assume_role_policy=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Action": "sts:AssumeRole",
              "Principal": {
                "Service": "s3.amazonaws.com"
              },
              "Effect": "Allow",
              "Sid": ""
            }
          ]
        }
        \"\"\")
        destination = aws.s3.Bucket("destination", versioning=aws.s3.BucketVersioningArgs(
            enabled=True,
        ))
        source = aws.s3.Bucket("source",
            acl="private",
            versioning=aws.s3.BucketVersioningArgs(
                enabled=True,
            ),
            opts=pulumi.ResourceOptions(provider=aws["central"]))
        replication_policy = aws.iam.Policy("replicationPolicy", policy=pulumi.Output.all(source.arn, source.arn, destination.arn).apply(lambda sourceArn, sourceArn1, destinationArn: f\"\"\"{{
          "Version": "2012-10-17",
          "Statement": [
            {{
              "Action": [
                "s3:GetReplicationConfiguration",
                "s3:ListBucket"
              ],
              "Effect": "Allow",
              "Resource": [
                "{source_arn}"
              ]
            }},
            {{
              "Action": [
                "s3:GetObjectVersionForReplication",
                "s3:GetObjectVersionAcl",
                 "s3:GetObjectVersionTagging"
              ],
              "Effect": "Allow",
              "Resource": [
                "{source_arn1}/*"
              ]
            }},
            {{
              "Action": [
                "s3:ReplicateObject",
                "s3:ReplicateDelete",
                "s3:ReplicateTags"
              ],
              "Effect": "Allow",
              "Resource": "{destination_arn}/*"
            }}
          ]
        }}
        \"\"\"))
        replication_role_policy_attachment = aws.iam.RolePolicyAttachment("replicationRolePolicyAttachment",
            role=replication_role.name,
            policy_arn=replication_policy.arn)
        replication_bucket_replication_config = aws.s3.BucketReplicationConfig("replicationBucketReplicationConfig",
            role=replication_role.arn,
            bucket=source.id,
            rules=[aws.s3.BucketReplicationConfigRuleArgs(
                id="foobar",
                prefix="foo",
                status="Enabled",
                destination=aws.s3.BucketReplicationConfigRuleDestinationArgs(
                    bucket=destination.arn,
                    storage_class="STANDARD",
                ),
            )])
        ```
        ## Usage Notes

        > **NOTE:** To avoid conflicts always add the following lifecycle object to the `s3.Bucket` resource of the source bucket.

        This resource implements the same features that are provided by the `replication_configuration` object of the `s3.Bucket` resource. To avoid conflicts or unexpected apply results, a lifecycle configuration is needed on the `s3.Bucket` to ignore changes to the internal `replication_configuration` object.  Failure to add the `lifecycle` configuration to the `s3.Bucket` will result in conflicting state results.

        ```python
        import pulumi
        ```

        The `s3.BucketReplicationConfig` resource provides the following features that are not available in the `s3.Bucket` resource:

        * `replica_modifications` - Added to the `source_selection_criteria` configuration object documented below
        * `metrics` - Added to the `destination` configuration object documented below
        * `replication_time` - Added to the `destination` configuration object documented below
        * `existing_object_replication` - Added to the replication rule object documented below

        Replication for existing objects requires activation by AWS Support.  See [userguide/replication-what-is-isnot-replicated](https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-what-is-isnot-replicated.html#existing-object-replication).

        ## Import

        S3 bucket replication configuration can be imported using the `bucket`, e.g.

        ```sh
         $ pulumi import aws:s3/bucketReplicationConfig:BucketReplicationConfig replication bucket-name
        ```

        :param str resource_name: The name of the resource.
        :param BucketReplicationConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketReplicationConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketReplicationConfigRuleArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketReplicationConfigArgs.__new__(BucketReplicationConfigArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
        super(BucketReplicationConfig, __self__).__init__(
            'aws:s3/bucketReplicationConfig:BucketReplicationConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketReplicationConfigRuleArgs']]]]] = None) -> 'BucketReplicationConfig':
        """
        Get an existing BucketReplicationConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the source S3 bucket you want Amazon S3 to monitor.
        :param pulumi.Input[str] role: The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketReplicationConfigRuleArgs']]]] rules: Set of configuration blocks describing the rules managing the replication documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketReplicationConfigState.__new__(_BucketReplicationConfigState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["role"] = role
        __props__.__dict__["rules"] = rules
        return BucketReplicationConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the source S3 bucket you want Amazon S3 to monitor.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.BucketReplicationConfigRule']]:
        """
        Set of configuration blocks describing the rules managing the replication documented below.
        """
        return pulumi.get(self, "rules")

