# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetResourcesResourceTagMappingListResult',
    'GetResourcesResourceTagMappingListComplianceDetailResult',
    'GetResourcesTagFilterResult',
]

@pulumi.output_type
class GetResourcesResourceTagMappingListResult(dict):
    def __init__(__self__, *,
                 compliance_details: Sequence['outputs.GetResourcesResourceTagMappingListComplianceDetailResult'],
                 resource_arn: str,
                 tags: Mapping[str, str]):
        """
        :param Sequence['GetResourcesResourceTagMappingListComplianceDetailArgs'] compliance_details: List of objects with information that shows whether a resource is compliant with the effective tag policy, including details on any noncompliant tag keys.
        :param str resource_arn: ARN of the resource.
        :param Mapping[str, str] tags: Map of tags assigned to the resource.
        """
        pulumi.set(__self__, "compliance_details", compliance_details)
        pulumi.set(__self__, "resource_arn", resource_arn)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="complianceDetails")
    def compliance_details(self) -> Sequence['outputs.GetResourcesResourceTagMappingListComplianceDetailResult']:
        """
        List of objects with information that shows whether a resource is compliant with the effective tag policy, including details on any noncompliant tag keys.
        """
        return pulumi.get(self, "compliance_details")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> str:
        """
        ARN of the resource.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetResourcesResourceTagMappingListComplianceDetailResult(dict):
    def __init__(__self__, *,
                 compliance_status: bool,
                 keys_with_noncompliant_values: Sequence[str],
                 non_compliant_keys: Sequence[str]):
        """
        :param bool compliance_status: Whether the resource is compliant.
               * `keys_with_noncompliant_values ` - Set of tag keys with non-compliant tag values.
               * `non_compliant_keys ` - Set of non-compliant tag keys.
        """
        pulumi.set(__self__, "compliance_status", compliance_status)
        pulumi.set(__self__, "keys_with_noncompliant_values", keys_with_noncompliant_values)
        pulumi.set(__self__, "non_compliant_keys", non_compliant_keys)

    @property
    @pulumi.getter(name="complianceStatus")
    def compliance_status(self) -> bool:
        """
        Whether the resource is compliant.
        * `keys_with_noncompliant_values ` - Set of tag keys with non-compliant tag values.
        * `non_compliant_keys ` - Set of non-compliant tag keys.
        """
        return pulumi.get(self, "compliance_status")

    @property
    @pulumi.getter(name="keysWithNoncompliantValues")
    def keys_with_noncompliant_values(self) -> Sequence[str]:
        return pulumi.get(self, "keys_with_noncompliant_values")

    @property
    @pulumi.getter(name="nonCompliantKeys")
    def non_compliant_keys(self) -> Sequence[str]:
        return pulumi.get(self, "non_compliant_keys")


@pulumi.output_type
class GetResourcesTagFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Optional[Sequence[str]] = None):
        """
        :param str key: One part of a key-value pair that makes up a tag.
        :param Sequence[str] values: The optional part of a key-value pair that make up a tag.
        """
        pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        One part of a key-value pair that makes up a tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The optional part of a key-value pair that make up a tag.
        """
        return pulumi.get(self, "values")


