# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCustomPluginResult',
    'AwaitableGetCustomPluginResult',
    'get_custom_plugin',
    'get_custom_plugin_output',
]

@pulumi.output_type
class GetCustomPluginResult:
    """
    A collection of values returned by getCustomPlugin.
    """
    def __init__(__self__, arn=None, description=None, id=None, latest_revision=None, name=None, state=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest_revision and not isinstance(latest_revision, int):
            raise TypeError("Expected argument 'latest_revision' to be a int")
        pulumi.set(__self__, "latest_revision", latest_revision)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        the Amazon Resource Name (ARN) of the custom plugin.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        a summary description of the custom plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> int:
        """
        an ID of the latest successfully created revision of the custom plugin.
        """
        return pulumi.get(self, "latest_revision")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        the state of the custom plugin.
        """
        return pulumi.get(self, "state")


class AwaitableGetCustomPluginResult(GetCustomPluginResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomPluginResult(
            arn=self.arn,
            description=self.description,
            id=self.id,
            latest_revision=self.latest_revision,
            name=self.name,
            state=self.state)


def get_custom_plugin(name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomPluginResult:
    """
    Get information on an Amazon MSK Connect custom plugin.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.mskconnect.get_custom_plugin(name="example-debezium-1")
    ```


    :param str name: Name of the custom plugin.
    """
    __args__ = dict()
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:mskconnect/getCustomPlugin:getCustomPlugin', __args__, opts=opts, typ=GetCustomPluginResult).value

    return AwaitableGetCustomPluginResult(
        arn=__ret__.arn,
        description=__ret__.description,
        id=__ret__.id,
        latest_revision=__ret__.latest_revision,
        name=__ret__.name,
        state=__ret__.state)


@_utilities.lift_output_func(get_custom_plugin)
def get_custom_plugin_output(name: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomPluginResult]:
    """
    Get information on an Amazon MSK Connect custom plugin.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.mskconnect.get_custom_plugin(name="example-debezium-1")
    ```


    :param str name: Name of the custom plugin.
    """
    ...
