# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MemberAccountAssociationArgs', 'MemberAccountAssociation']

@pulumi.input_type
class MemberAccountAssociationArgs:
    def __init__(__self__, *,
                 member_account_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a MemberAccountAssociation resource.
        :param pulumi.Input[str] member_account_id: The ID of the AWS account that you want to associate with Amazon Macie as a member account.
        """
        pulumi.set(__self__, "member_account_id", member_account_id)

    @property
    @pulumi.getter(name="memberAccountId")
    def member_account_id(self) -> pulumi.Input[str]:
        """
        The ID of the AWS account that you want to associate with Amazon Macie as a member account.
        """
        return pulumi.get(self, "member_account_id")

    @member_account_id.setter
    def member_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "member_account_id", value)


@pulumi.input_type
class _MemberAccountAssociationState:
    def __init__(__self__, *,
                 member_account_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MemberAccountAssociation resources.
        :param pulumi.Input[str] member_account_id: The ID of the AWS account that you want to associate with Amazon Macie as a member account.
        """
        if member_account_id is not None:
            pulumi.set(__self__, "member_account_id", member_account_id)

    @property
    @pulumi.getter(name="memberAccountId")
    def member_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AWS account that you want to associate with Amazon Macie as a member account.
        """
        return pulumi.get(self, "member_account_id")

    @member_account_id.setter
    def member_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "member_account_id", value)


class MemberAccountAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 member_account_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        > **NOTE:** This resource interacts with [Amazon Macie Classic](https://docs.aws.amazon.com/macie/latest/userguide/what-is-macie.html). Macie Classic cannot be activated in new accounts. See the [FAQ](https://aws.amazon.com/macie/classic-faqs/) for more details.

        Associates an AWS account with Amazon Macie as a member account.

        > **NOTE:** Before using Amazon Macie for the first time it must be enabled manually. Instructions are [here](https://docs.aws.amazon.com/macie/latest/userguide/macie-setting-up.html#macie-setting-up-enable).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.macie.MemberAccountAssociation("example", member_account_id="123456789012")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] member_account_id: The ID of the AWS account that you want to associate with Amazon Macie as a member account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MemberAccountAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **NOTE:** This resource interacts with [Amazon Macie Classic](https://docs.aws.amazon.com/macie/latest/userguide/what-is-macie.html). Macie Classic cannot be activated in new accounts. See the [FAQ](https://aws.amazon.com/macie/classic-faqs/) for more details.

        Associates an AWS account with Amazon Macie as a member account.

        > **NOTE:** Before using Amazon Macie for the first time it must be enabled manually. Instructions are [here](https://docs.aws.amazon.com/macie/latest/userguide/macie-setting-up.html#macie-setting-up-enable).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.macie.MemberAccountAssociation("example", member_account_id="123456789012")
        ```

        :param str resource_name: The name of the resource.
        :param MemberAccountAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MemberAccountAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 member_account_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MemberAccountAssociationArgs.__new__(MemberAccountAssociationArgs)

            if member_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'member_account_id'")
            __props__.__dict__["member_account_id"] = member_account_id
        super(MemberAccountAssociation, __self__).__init__(
            'aws:macie/memberAccountAssociation:MemberAccountAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            member_account_id: Optional[pulumi.Input[str]] = None) -> 'MemberAccountAssociation':
        """
        Get an existing MemberAccountAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] member_account_id: The ID of the AWS account that you want to associate with Amazon Macie as a member account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MemberAccountAssociationState.__new__(_MemberAccountAssociationState)

        __props__.__dict__["member_account_id"] = member_account_id
        return MemberAccountAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="memberAccountId")
    def member_account_id(self) -> pulumi.Output[str]:
        """
        The ID of the AWS account that you want to associate with Amazon Macie as a member account.
        """
        return pulumi.get(self, "member_account_id")

