# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DistributionConfigurationDistribution',
    'DistributionConfigurationDistributionAmiDistributionConfiguration',
    'DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission',
    'DistributionConfigurationDistributionContainerDistributionConfiguration',
    'DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository',
    'ImageImageTestsConfiguration',
    'ImageOutputResource',
    'ImageOutputResourceAmi',
    'ImagePipelineImageTestsConfiguration',
    'ImagePipelineSchedule',
    'ImageRecipeBlockDeviceMapping',
    'ImageRecipeBlockDeviceMappingEbs',
    'ImageRecipeComponent',
    'InfrastructureConfigurationLogging',
    'InfrastructureConfigurationLoggingS3Logs',
    'GetComponentsFilterResult',
    'GetDistributionConfigurationDistributionResult',
    'GetDistributionConfigurationDistributionAmiDistributionConfigurationResult',
    'GetDistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionResult',
    'GetDistributionConfigurationsFilterResult',
    'GetImageImageTestsConfigurationResult',
    'GetImageOutputResourceResult',
    'GetImageOutputResourceAmiResult',
    'GetImagePipelineImageTestsConfigurationResult',
    'GetImagePipelineScheduleResult',
    'GetImageRecipeBlockDeviceMappingResult',
    'GetImageRecipeBlockDeviceMappingEbResult',
    'GetImageRecipeComponentResult',
    'GetImageRecipesFilterResult',
    'GetInfrastructureConfigurationLoggingResult',
    'GetInfrastructureConfigurationLoggingS3LogResult',
    'GetInfrastructureConfigurationsFilterResult',
]

@pulumi.output_type
class DistributionConfigurationDistribution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiDistributionConfiguration":
            suggest = "ami_distribution_configuration"
        elif key == "containerDistributionConfiguration":
            suggest = "container_distribution_configuration"
        elif key == "licenseConfigurationArns":
            suggest = "license_configuration_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationDistribution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationDistribution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationDistribution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 ami_distribution_configuration: Optional['outputs.DistributionConfigurationDistributionAmiDistributionConfiguration'] = None,
                 container_distribution_configuration: Optional['outputs.DistributionConfigurationDistributionContainerDistributionConfiguration'] = None,
                 license_configuration_arns: Optional[Sequence[str]] = None):
        """
        :param str region: AWS Region for the distribution.
        :param 'DistributionConfigurationDistributionAmiDistributionConfigurationArgs' ami_distribution_configuration: Configuration block with Amazon Machine Image (AMI) distribution settings. Detailed below.
        :param 'DistributionConfigurationDistributionContainerDistributionConfigurationArgs' container_distribution_configuration: Configuration block with container distribution settings. Detailed below.
        :param Sequence[str] license_configuration_arns: Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
        """
        pulumi.set(__self__, "region", region)
        if ami_distribution_configuration is not None:
            pulumi.set(__self__, "ami_distribution_configuration", ami_distribution_configuration)
        if container_distribution_configuration is not None:
            pulumi.set(__self__, "container_distribution_configuration", container_distribution_configuration)
        if license_configuration_arns is not None:
            pulumi.set(__self__, "license_configuration_arns", license_configuration_arns)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        AWS Region for the distribution.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="amiDistributionConfiguration")
    def ami_distribution_configuration(self) -> Optional['outputs.DistributionConfigurationDistributionAmiDistributionConfiguration']:
        """
        Configuration block with Amazon Machine Image (AMI) distribution settings. Detailed below.
        """
        return pulumi.get(self, "ami_distribution_configuration")

    @property
    @pulumi.getter(name="containerDistributionConfiguration")
    def container_distribution_configuration(self) -> Optional['outputs.DistributionConfigurationDistributionContainerDistributionConfiguration']:
        """
        Configuration block with container distribution settings. Detailed below.
        """
        return pulumi.get(self, "container_distribution_configuration")

    @property
    @pulumi.getter(name="licenseConfigurationArns")
    def license_configuration_arns(self) -> Optional[Sequence[str]]:
        """
        Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
        """
        return pulumi.get(self, "license_configuration_arns")


@pulumi.output_type
class DistributionConfigurationDistributionAmiDistributionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiTags":
            suggest = "ami_tags"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "launchPermission":
            suggest = "launch_permission"
        elif key == "targetAccountIds":
            suggest = "target_account_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationDistributionAmiDistributionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationDistributionAmiDistributionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationDistributionAmiDistributionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ami_tags: Optional[Mapping[str, str]] = None,
                 description: Optional[str] = None,
                 kms_key_id: Optional[str] = None,
                 launch_permission: Optional['outputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission'] = None,
                 name: Optional[str] = None,
                 target_account_ids: Optional[Sequence[str]] = None):
        """
        :param Mapping[str, str] ami_tags: Key-value map of tags to apply to the distributed AMI.
        :param str description: Description of the container distribution configuration.
        :param str kms_key_id: Amazon Resource Name (ARN) of the Key Management Service (KMS) Key to encrypt the distributed AMI.
        :param 'DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs' launch_permission: Configuration block of EC2 launch permissions to apply to the distributed AMI. Detailed below.
        :param str name: Name to apply to the distributed AMI.
        :param Sequence[str] target_account_ids: Set of AWS Account identifiers to distribute the AMI.
        """
        if ami_tags is not None:
            pulumi.set(__self__, "ami_tags", ami_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if launch_permission is not None:
            pulumi.set(__self__, "launch_permission", launch_permission)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_account_ids is not None:
            pulumi.set(__self__, "target_account_ids", target_account_ids)

    @property
    @pulumi.getter(name="amiTags")
    def ami_tags(self) -> Optional[Mapping[str, str]]:
        """
        Key-value map of tags to apply to the distributed AMI.
        """
        return pulumi.get(self, "ami_tags")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the container distribution configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the Key Management Service (KMS) Key to encrypt the distributed AMI.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="launchPermission")
    def launch_permission(self) -> Optional['outputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission']:
        """
        Configuration block of EC2 launch permissions to apply to the distributed AMI. Detailed below.
        """
        return pulumi.get(self, "launch_permission")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name to apply to the distributed AMI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetAccountIds")
    def target_account_ids(self) -> Optional[Sequence[str]]:
        """
        Set of AWS Account identifiers to distribute the AMI.
        """
        return pulumi.get(self, "target_account_ids")


@pulumi.output_type
class DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userGroups":
            suggest = "user_groups"
        elif key == "userIds":
            suggest = "user_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_groups: Optional[Sequence[str]] = None,
                 user_ids: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] user_groups: Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
        :param Sequence[str] user_ids: Set of AWS Account identifiers to assign.
        """
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[Sequence[str]]:
        """
        Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
        """
        return pulumi.get(self, "user_groups")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[Sequence[str]]:
        """
        Set of AWS Account identifiers to assign.
        """
        return pulumi.get(self, "user_ids")


@pulumi.output_type
class DistributionConfigurationDistributionContainerDistributionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetRepository":
            suggest = "target_repository"
        elif key == "containerTags":
            suggest = "container_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationDistributionContainerDistributionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationDistributionContainerDistributionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationDistributionContainerDistributionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_repository: 'outputs.DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository',
                 container_tags: Optional[Sequence[str]] = None,
                 description: Optional[str] = None):
        """
        :param 'DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs' target_repository: Configuration block with the destination repository for the container distribution configuration.
        :param Sequence[str] container_tags: Set of tags that are attached to the container distribution configuration.
        :param str description: Description of the container distribution configuration.
        """
        pulumi.set(__self__, "target_repository", target_repository)
        if container_tags is not None:
            pulumi.set(__self__, "container_tags", container_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="targetRepository")
    def target_repository(self) -> 'outputs.DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository':
        """
        Configuration block with the destination repository for the container distribution configuration.
        """
        return pulumi.get(self, "target_repository")

    @property
    @pulumi.getter(name="containerTags")
    def container_tags(self) -> Optional[Sequence[str]]:
        """
        Set of tags that are attached to the container distribution configuration.
        """
        return pulumi.get(self, "container_tags")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the container distribution configuration.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryName":
            suggest = "repository_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_name: str,
                 service: str):
        """
        :param str repository_name: The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        :param str service: The service in which this image is registered. Valid values: `ECR`.
        """
        pulumi.set(__self__, "repository_name", repository_name)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> str:
        """
        The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The service in which this image is registered. Valid values: `ECR`.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ImageImageTestsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageTestsEnabled":
            suggest = "image_tests_enabled"
        elif key == "timeoutMinutes":
            suggest = "timeout_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageImageTestsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageImageTestsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageImageTestsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_tests_enabled: Optional[bool] = None,
                 timeout_minutes: Optional[int] = None):
        """
        :param bool image_tests_enabled: Whether image tests are enabled. Defaults to `true`.
        :param int timeout_minutes: Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[bool]:
        """
        Whether image tests are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "image_tests_enabled")

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[int]:
        """
        Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
        """
        return pulumi.get(self, "timeout_minutes")


@pulumi.output_type
class ImageOutputResource(dict):
    def __init__(__self__, *,
                 amis: Optional[Sequence['outputs.ImageOutputResourceAmi']] = None):
        """
        :param Sequence['ImageOutputResourceAmiArgs'] amis: Set of objects with each Amazon Machine Image (AMI) created.
        """
        if amis is not None:
            pulumi.set(__self__, "amis", amis)

    @property
    @pulumi.getter
    def amis(self) -> Optional[Sequence['outputs.ImageOutputResourceAmi']]:
        """
        Set of objects with each Amazon Machine Image (AMI) created.
        """
        return pulumi.get(self, "amis")


@pulumi.output_type
class ImageOutputResourceAmi(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageOutputResourceAmi. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageOutputResourceAmi.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageOutputResourceAmi.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[str] = None,
                 description: Optional[str] = None,
                 image: Optional[str] = None,
                 name: Optional[str] = None,
                 region: Optional[str] = None):
        """
        :param str account_id: Account identifier of the AMI.
        :param str description: Description of the AMI.
        :param str image: Identifier of the AMI.
        :param str name: Name of the AMI.
        :param str region: Region of the AMI.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        Account identifier of the AMI.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the AMI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Identifier of the AMI.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the AMI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region of the AMI.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ImagePipelineImageTestsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageTestsEnabled":
            suggest = "image_tests_enabled"
        elif key == "timeoutMinutes":
            suggest = "timeout_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagePipelineImageTestsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagePipelineImageTestsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagePipelineImageTestsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_tests_enabled: Optional[bool] = None,
                 timeout_minutes: Optional[int] = None):
        """
        :param bool image_tests_enabled: Whether image tests are enabled. Defaults to `true`.
        :param int timeout_minutes: Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[bool]:
        """
        Whether image tests are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "image_tests_enabled")

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[int]:
        """
        Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
        """
        return pulumi.get(self, "timeout_minutes")


@pulumi.output_type
class ImagePipelineSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"
        elif key == "pipelineExecutionStartCondition":
            suggest = "pipeline_execution_start_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagePipelineSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagePipelineSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagePipelineSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: str,
                 pipeline_execution_start_condition: Optional[str] = None):
        """
        :param str schedule_expression: Cron expression of how often the pipeline start condition is evaluated. For example, `cron(0 0 * * ? *)` is evaluated every day at midnight UTC. Configurations using the five field syntax that was previously accepted by the API, such as `cron(0 0 * * *)`, must be updated to the six field syntax. For more information, see the [Image Builder User Guide](https://docs.aws.amazon.com/imagebuilder/latest/userguide/cron-expressions.html).
        :param str pipeline_execution_start_condition: Condition when the pipeline should trigger a new image build. Valid values are `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` and `EXPRESSION_MATCH_ONLY`. Defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if pipeline_execution_start_condition is not None:
            pulumi.set(__self__, "pipeline_execution_start_condition", pipeline_execution_start_condition)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> str:
        """
        Cron expression of how often the pipeline start condition is evaluated. For example, `cron(0 0 * * ? *)` is evaluated every day at midnight UTC. Configurations using the five field syntax that was previously accepted by the API, such as `cron(0 0 * * *)`, must be updated to the six field syntax. For more information, see the [Image Builder User Guide](https://docs.aws.amazon.com/imagebuilder/latest/userguide/cron-expressions.html).
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="pipelineExecutionStartCondition")
    def pipeline_execution_start_condition(self) -> Optional[str]:
        """
        Condition when the pipeline should trigger a new image build. Valid values are `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` and `EXPRESSION_MATCH_ONLY`. Defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
        """
        return pulumi.get(self, "pipeline_execution_start_condition")


@pulumi.output_type
class ImageRecipeBlockDeviceMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[str] = None,
                 ebs: Optional['outputs.ImageRecipeBlockDeviceMappingEbs'] = None,
                 no_device: Optional[bool] = None,
                 virtual_name: Optional[str] = None):
        """
        :param str device_name: Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
        :param 'ImageRecipeBlockDeviceMappingEbsArgs' ebs: Configuration block with Elastic Block Storage (EBS) block device mapping settings. Detailed below.
        :param bool no_device: Set to `true` to remove a mapping from the parent image.
        :param str virtual_name: Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[str]:
        """
        Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.ImageRecipeBlockDeviceMappingEbs']:
        """
        Configuration block with Elastic Block Storage (EBS) block device mapping settings. Detailed below.
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[bool]:
        """
        Set to `true` to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[str]:
        """
        Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
        """
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class ImageRecipeBlockDeviceMappingEbs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeBlockDeviceMappingEbs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeBlockDeviceMappingEbs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeBlockDeviceMappingEbs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[str] = None,
                 encrypted: Optional[str] = None,
                 iops: Optional[int] = None,
                 kms_key_id: Optional[str] = None,
                 snapshot_id: Optional[str] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        """
        :param str delete_on_termination: Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
        :param str encrypted: Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
        :param int iops: Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
        :param str kms_key_id: Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
        :param str snapshot_id: Identifier of the EC2 Volume Snapshot.
        :param int volume_size: Size of the volume, in GiB.
        :param str volume_type: Type of the volume. For example, `gp2` or `io2`.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[str]:
        """
        Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[str]:
        """
        Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        Identifier of the EC2 Volume Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        """
        Size of the volume, in GiB.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        """
        Type of the volume. For example, `gp2` or `io2`.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ImageRecipeComponent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentArn":
            suggest = "component_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRecipeComponent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRecipeComponent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRecipeComponent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_arn: str):
        """
        :param str component_arn: Amazon Resource Name (ARN) of the Image Builder Component to associate.
        """
        pulumi.set(__self__, "component_arn", component_arn)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the Image Builder Component to associate.
        """
        return pulumi.get(self, "component_arn")


@pulumi.output_type
class InfrastructureConfigurationLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Logs":
            suggest = "s3_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureConfigurationLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureConfigurationLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureConfigurationLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_logs: 'outputs.InfrastructureConfigurationLoggingS3Logs'):
        """
        :param 'InfrastructureConfigurationLoggingS3LogsArgs' s3_logs: Configuration block with S3 logging settings. Detailed below.
        """
        pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> 'outputs.InfrastructureConfigurationLoggingS3Logs':
        """
        Configuration block with S3 logging settings. Detailed below.
        """
        return pulumi.get(self, "s3_logs")


@pulumi.output_type
class InfrastructureConfigurationLoggingS3Logs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureConfigurationLoggingS3Logs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureConfigurationLoggingS3Logs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureConfigurationLoggingS3Logs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: str,
                 s3_key_prefix: Optional[str] = None):
        """
        :param str s3_bucket_name: Name of the S3 Bucket.
        :param str s3_key_prefix: Prefix to use for S3 logs. Defaults to `/`.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> str:
        """
        Name of the S3 Bucket.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[str]:
        """
        Prefix to use for S3 logs. Defaults to `/`.
        """
        return pulumi.get(self, "s3_key_prefix")


@pulumi.output_type
class GetComponentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the filter field. Valid values can be found in the [Image Builder ListComponents API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListComponents.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the filter field. Valid values can be found in the [Image Builder ListComponents API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListComponents.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetDistributionConfigurationDistributionResult(dict):
    def __init__(__self__, *,
                 ami_distribution_configurations: Sequence['outputs.GetDistributionConfigurationDistributionAmiDistributionConfigurationResult'],
                 license_configuration_arns: Sequence[str],
                 region: str):
        """
        :param Sequence['GetDistributionConfigurationDistributionAmiDistributionConfigurationArgs'] ami_distribution_configurations: Nested list of AMI distribution configuration.
        :param Sequence[str] license_configuration_arns: Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
        :param str region: AWS Region of distribution.
        """
        pulumi.set(__self__, "ami_distribution_configurations", ami_distribution_configurations)
        pulumi.set(__self__, "license_configuration_arns", license_configuration_arns)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="amiDistributionConfigurations")
    def ami_distribution_configurations(self) -> Sequence['outputs.GetDistributionConfigurationDistributionAmiDistributionConfigurationResult']:
        """
        Nested list of AMI distribution configuration.
        """
        return pulumi.get(self, "ami_distribution_configurations")

    @property
    @pulumi.getter(name="licenseConfigurationArns")
    def license_configuration_arns(self) -> Sequence[str]:
        """
        Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
        """
        return pulumi.get(self, "license_configuration_arns")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        AWS Region of distribution.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetDistributionConfigurationDistributionAmiDistributionConfigurationResult(dict):
    def __init__(__self__, *,
                 ami_tags: Mapping[str, str],
                 description: str,
                 kms_key_id: str,
                 launch_permissions: Sequence['outputs.GetDistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionResult'],
                 name: str,
                 target_account_ids: Sequence[str]):
        """
        :param Mapping[str, str] ami_tags: Key-value map of tags to apply to distributed AMI.
        :param str description: Description to apply to distributed AMI.
        :param str kms_key_id: Amazon Resource Name (ARN) of Key Management Service (KMS) Key to encrypt AMI.
        :param Sequence['GetDistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs'] launch_permissions: Nested list of EC2 launch permissions.
        :param str name: Name of the distribution configuration.
        :param Sequence[str] target_account_ids: Set of target AWS Account identifiers.
        """
        pulumi.set(__self__, "ami_tags", ami_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "launch_permissions", launch_permissions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target_account_ids", target_account_ids)

    @property
    @pulumi.getter(name="amiTags")
    def ami_tags(self) -> Mapping[str, str]:
        """
        Key-value map of tags to apply to distributed AMI.
        """
        return pulumi.get(self, "ami_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description to apply to distributed AMI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        Amazon Resource Name (ARN) of Key Management Service (KMS) Key to encrypt AMI.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="launchPermissions")
    def launch_permissions(self) -> Sequence['outputs.GetDistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionResult']:
        """
        Nested list of EC2 launch permissions.
        """
        return pulumi.get(self, "launch_permissions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the distribution configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetAccountIds")
    def target_account_ids(self) -> Sequence[str]:
        """
        Set of target AWS Account identifiers.
        """
        return pulumi.get(self, "target_account_ids")


@pulumi.output_type
class GetDistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionResult(dict):
    def __init__(__self__, *,
                 user_groups: Sequence[str],
                 user_ids: Sequence[str]):
        """
        :param Sequence[str] user_groups: Set of EC2 launch permission user groups.
        :param Sequence[str] user_ids: Set of AWS Account identifiers.
        """
        pulumi.set(__self__, "user_groups", user_groups)
        pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Sequence[str]:
        """
        Set of EC2 launch permission user groups.
        """
        return pulumi.get(self, "user_groups")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Sequence[str]:
        """
        Set of AWS Account identifiers.
        """
        return pulumi.get(self, "user_ids")


@pulumi.output_type
class GetDistributionConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the filter field. Valid values can be found in the [Image Builder ListDistributionConfigurations API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListDistributionConfigurations.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the filter field. Valid values can be found in the [Image Builder ListDistributionConfigurations API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListDistributionConfigurations.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetImageImageTestsConfigurationResult(dict):
    def __init__(__self__, *,
                 image_tests_enabled: bool,
                 timeout_minutes: int):
        """
        :param bool image_tests_enabled: Whether image tests are enabled.
        :param int timeout_minutes: Number of minutes before image tests time out.
        """
        pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> bool:
        """
        Whether image tests are enabled.
        """
        return pulumi.get(self, "image_tests_enabled")

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> int:
        """
        Number of minutes before image tests time out.
        """
        return pulumi.get(self, "timeout_minutes")


@pulumi.output_type
class GetImageOutputResourceResult(dict):
    def __init__(__self__, *,
                 amis: Sequence['outputs.GetImageOutputResourceAmiResult']):
        """
        :param Sequence['GetImageOutputResourceAmiArgs'] amis: Set of objects with each Amazon Machine Image (AMI) created.
        """
        pulumi.set(__self__, "amis", amis)

    @property
    @pulumi.getter
    def amis(self) -> Sequence['outputs.GetImageOutputResourceAmiResult']:
        """
        Set of objects with each Amazon Machine Image (AMI) created.
        """
        return pulumi.get(self, "amis")


@pulumi.output_type
class GetImageOutputResourceAmiResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 description: str,
                 image: str,
                 name: str,
                 region: str):
        """
        :param str account_id: Account identifier of the AMI.
        :param str description: Description of the AMI.
        :param str image: Identifier of the AMI.
        :param str name: Name of the AMI.
        :param str region: Region of the AMI.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Account identifier of the AMI.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the AMI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Identifier of the AMI.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the AMI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region of the AMI.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetImagePipelineImageTestsConfigurationResult(dict):
    def __init__(__self__, *,
                 image_tests_enabled: bool,
                 timeout_minutes: int):
        """
        :param bool image_tests_enabled: Whether image tests are enabled.
        :param int timeout_minutes: Number of minutes before image tests time out.
        """
        pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> bool:
        """
        Whether image tests are enabled.
        """
        return pulumi.get(self, "image_tests_enabled")

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> int:
        """
        Number of minutes before image tests time out.
        """
        return pulumi.get(self, "timeout_minutes")


@pulumi.output_type
class GetImagePipelineScheduleResult(dict):
    def __init__(__self__, *,
                 pipeline_execution_start_condition: str,
                 schedule_expression: str):
        """
        :param str pipeline_execution_start_condition: Condition when the pipeline should trigger a new image build.
        :param str schedule_expression: Cron expression of how often the pipeline start condition is evaluated.
        """
        pulumi.set(__self__, "pipeline_execution_start_condition", pipeline_execution_start_condition)
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="pipelineExecutionStartCondition")
    def pipeline_execution_start_condition(self) -> str:
        """
        Condition when the pipeline should trigger a new image build.
        """
        return pulumi.get(self, "pipeline_execution_start_condition")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> str:
        """
        Cron expression of how often the pipeline start condition is evaluated.
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class GetImageRecipeBlockDeviceMappingResult(dict):
    def __init__(__self__, *,
                 device_name: str,
                 ebs: Sequence['outputs.GetImageRecipeBlockDeviceMappingEbResult'],
                 no_device: str,
                 virtual_name: str):
        """
        :param str device_name: Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
        :param Sequence['GetImageRecipeBlockDeviceMappingEbArgs'] ebs: Single list of object with Elastic Block Storage (EBS) block device mapping settings.
        :param str no_device: Whether to remove a mapping from the parent image.
        :param str virtual_name: Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
        """
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "ebs", ebs)
        pulumi.set(__self__, "no_device", no_device)
        pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Sequence['outputs.GetImageRecipeBlockDeviceMappingEbResult']:
        """
        Single list of object with Elastic Block Storage (EBS) block device mapping settings.
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> str:
        """
        Whether to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> str:
        """
        Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
        """
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class GetImageRecipeBlockDeviceMappingEbResult(dict):
    def __init__(__self__, *,
                 delete_on_termination: bool,
                 encrypted: bool,
                 iops: int,
                 kms_key_id: str,
                 snapshot_id: str,
                 volume_size: int,
                 volume_type: str):
        """
        :param bool delete_on_termination: Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
        :param bool encrypted: Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
        :param int iops: Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
        :param str kms_key_id: Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
        :param str snapshot_id: Identifier of the EC2 Volume Snapshot.
        :param int volume_size: Size of the volume, in GiB.
        :param str volume_type: Type of the volume. For example, `gp2` or `io2`.
        """
        pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "volume_size", volume_size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> bool:
        """
        Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def encrypted(self) -> bool:
        """
        Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> int:
        """
        Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        Identifier of the EC2 Volume Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> int:
        """
        Size of the volume, in GiB.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        """
        Type of the volume. For example, `gp2` or `io2`.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class GetImageRecipeComponentResult(dict):
    def __init__(__self__, *,
                 component_arn: str):
        """
        :param str component_arn: Amazon Resource Name (ARN) of the Image Builder Component.
        """
        pulumi.set(__self__, "component_arn", component_arn)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the Image Builder Component.
        """
        return pulumi.get(self, "component_arn")


@pulumi.output_type
class GetImageRecipesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the filter field. Valid values can be found in the [Image Builder ListImageRecipes API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImageRecipes.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the filter field. Valid values can be found in the [Image Builder ListImageRecipes API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImageRecipes.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInfrastructureConfigurationLoggingResult(dict):
    def __init__(__self__, *,
                 s3_logs: Sequence['outputs.GetInfrastructureConfigurationLoggingS3LogResult']):
        """
        :param Sequence['GetInfrastructureConfigurationLoggingS3LogArgs'] s3_logs: Nested list of S3 logs settings.
        """
        pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Sequence['outputs.GetInfrastructureConfigurationLoggingS3LogResult']:
        """
        Nested list of S3 logs settings.
        """
        return pulumi.get(self, "s3_logs")


@pulumi.output_type
class GetInfrastructureConfigurationLoggingS3LogResult(dict):
    def __init__(__self__, *,
                 s3_bucket_name: str,
                 s3_key_prefix: str):
        """
        :param str s3_bucket_name: Name of the S3 Bucket for logging.
        :param str s3_key_prefix: Key prefix for S3 Bucket logging.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> str:
        """
        Name of the S3 Bucket for logging.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> str:
        """
        Key prefix for S3 Bucket logging.
        """
        return pulumi.get(self, "s3_key_prefix")


@pulumi.output_type
class GetInfrastructureConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the filter field. Valid values can be found in the [Image Builder ListInfrastructureConfigurations API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListInfrastructureConfigurations.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the filter field. Valid values can be found in the [Image Builder ListInfrastructureConfigurations API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListInfrastructureConfigurations.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


